%--------------------------------------------------------------------------
% File     : TOP004=BasisTplgLem4-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Topology
% Problem  : Topology generated by a basis forms a topological space, part 4
% Version  : [Wick & McCune, 1989] axioms : Incomplete.
% English  : 

% Refs     : Wick C.A., McCune W.W. (1989), Automated Reasoning about 
%            Elementary Point-Set Topology, Journal of Automated Reasoning 
%            5(2), 239-255.
% Source   : [Wick & McCune, 1989]
% Names    : Lemma 1d [Wick & McCune, 1989]

% Status   : 
% Syntax   : Number of clauses           :  113 (  23 non-Horn)(   4 unit)
%            Number of literals          :  340 (   0 equality)
%            Number of predicate symbols :   22 (   0 propositional)
%            Number of function symbols  :   37 (   3 constant)
%            Number of variables         :  361 (  60 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    3

% Comments : The axioms in this version are known to be incomplete. To
%            obtain a proof of this theorem it may be necessary to add
%            appropriate set theory axioms.
%--------------------------------------------------------------------------
%----Include Point-set topology axioms 
include('Axioms/TOP001-0.ax').
%--------------------------------------------------------------------------
input_clause(lemma_1d_1,theorem,
    [++basis(cx,f)]).

input_clause(lemma_1d_2,theorem,
    [++element_of_collection(U,top_of_basis(f))]).

input_clause(lemma_1d_3,theorem,
    [++element_of_collection(V,top_of_basis(f))]).

input_clause(lemma_1d_4,theorem,
    [--element_of_collection(intersection_of_sets(U,V),top_of_basis(f))]).
%--------------------------------------------------------------------------
