%--------------------------------------------------------------------------
% File     : TOP003=BasisTplgLem3-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Topology
% Problem  : Topology generated by a basis forms a topological space, part 3
% Version  : [Wick & McCune, 1989] axioms :
%            Incomplete > Reduced & Augmented > Incomplete.
% English  : 

% Refs     : Wick C.A., McCune W.W. (1989), Automated Reasoning about 
%            Elementary Point-Set Topology, Journal of Automated Reasoning 
%            5(2), 239-255.
% Source   : [Wick & McCune, 1989]
% Names    : Lemma 1c [Wick & McCune, 1989]

% Status   : 
% Syntax   : Number of clauses           :   11 (   1 non-Horn)(   3 unit)
%            Number of literals          :   22 (   0 equality)
%            Number of predicate symbols :    5 (   0 propositional)
%            Number of function symbols  :    6 (   2 constant)
%            Number of variables         :   20 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    2

% Comments : The axioms in this version are known to be incomplete. To
%            make them complete it is be necessary to add appropriate set 
%            theory axioms.
%--------------------------------------------------------------------------
%----Include Point-set topology axioms 
% include('Axioms/TOP001-0.ax').
%--------------------------------------------------------------------------
%----Sigma (union of members). 
input_clause(union_of_members_1,axiom,
    [--element_of_set(U,union_of_members(Vf)),
     ++element_of_set(U,f1(Vf,U))]).

input_clause(union_of_members_2,axiom,
    [--element_of_set(U,union_of_members(Vf)),
     ++element_of_collection(f1(Vf,U),Vf)]).

%----Basis for a topology 
input_clause(basis_for_topology_28,axiom,
    [--basis(X,Vf),
     ++equal_sets(union_of_members(Vf),X)]).

%----Topology generated by a basis 
input_clause(topology_generated_40,axiom,
    [++element_of_collection(U,top_of_basis(Vf)),
     ++element_of_set(f11(Vf,U),U)]).

input_clause(set_theory_7,axiom,
    [--element_of_collection(X,Y),
     ++subset_sets(X,union_of_members(Y))]).

input_clause(set_theory_8,axiom,
    [--subset_sets(X,Y),
     --element_of_set(U,X),
     ++element_of_set(U,Y)]).

input_clause(set_theory_9,axiom,
    [++subset_sets(X,X)]).

input_clause(set_theory_10,axiom,
    [--equal_sets(X,Y),
     --subset_sets(Z,X),
     ++subset_sets(Z,Y)]).

input_clause(set_theory_11,axiom,
    [--equal_sets(X,Y),
     --subset_sets(X,Z),
     ++subset_sets(Y,Z)]).

input_clause(lemma_1c_1,theorem,
    [++basis(cx,f)]).

input_clause(lemma_1c_2,theorem,
    [--element_of_collection(cx,top_of_basis(f))]).
%--------------------------------------------------------------------------
