%--------------------------------------------------------------------------
% File     : TOP001=BasisTplgLem1-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Topology
% Problem  : Topology generated by a basis forms a topological space, part 1
% Version  : [Wick & McCune, 1989] axioms :
%            Incomplete > Reduced & Augmented > Incomplete.
% English  : 

% Refs     : Wick C.A., McCune W.W. (1989), Automated Reasoning about 
%            Elementary Point-Set Topology, Journal of Automated Reasoning 
%            5(2), 239-255.
% Source   : [Wick & McCune, 1989]
% Names    : Lemma 1a [Wick & McCune, 1989]

% Status   : 
% Syntax   : Number of clauses           :   13 (   1 non-Horn)(   3 unit)
%            Number of literals          :   27 (   0 equality)
%            Number of predicate symbols :    5 (   0 propositional)
%            Number of function symbols  :    7 (   2 constant)
%            Number of variables         :   25 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : The axioms in this version are known to be incomplete. To
%            make them complete it is be necessary to add appropriate set 
%            theory axioms.
%--------------------------------------------------------------------------
%----Include Point-set topology axioms 
% include('Axioms/TOP001-0.ax').
%--------------------------------------------------------------------------
%----Sigma (union of members). 
input_clause(union_of_members_1,axiom,
    [--element_of_set(U,union_of_members(Vf)),
     ++element_of_set(U,f1(Vf,U))]).

input_clause(union_of_members_2,axiom,
    [--element_of_set(U,union_of_members(Vf)),
     ++element_of_collection(f1(Vf,U),Vf)]).

input_clause(union_of_members_3,axiom,
    [++element_of_set(U,union_of_members(Vf)),
     --element_of_set(U,Uu1),
     --element_of_collection(Uu1,Vf)]).

%----Basis for a topology 
input_clause(basis_for_topology_28,axiom,
    [--basis(X,Vf),
     ++equal_sets(union_of_members(Vf),X)]).

%----Topology generated by a basis 
input_clause(topology_generated_37,axiom,
    [--element_of_collection(U,top_of_basis(Vf)),
     --element_of_set(X,U),
     ++element_of_set(X,f10(Vf,U,X))]).

input_clause(topology_generated_38,axiom,
    [--element_of_collection(U,top_of_basis(Vf)),
     --element_of_set(X,U),
     ++element_of_collection(f10(Vf,U,X),Vf)]).

input_clause(set_theory_1,axiom,
    [++subset_sets(X,X)]).

input_clause(set_theory_2,axiom,
    [--subset_sets(X,Y),
     --element_of_set(U,X),
     ++element_of_set(U,Y)]).

input_clause(set_theory_3,axiom,
    [--equal_sets(X,Y),
     ++subset_sets(X,Y)]).

input_clause(set_theory_4,axiom,
    [++subset_sets(X,Y),
     ++element_of_set(in_1st_set(X,Y),X)]).

input_clause(set_theory_5,axiom,
    [++subset_sets(X,Y),
     --element_of_set(in_1st_set(X,Y),Y)]).

input_clause(lemma_1a_1,theorem,
    [++basis(cx,f)]).

input_clause(lemma_1a_2,theorem,
    [--subset_sets(union_of_members(top_of_basis(f)),cx)]).
%--------------------------------------------------------------------------
