%--------------------------------------------------------------------------
% File     : SYN084=FPell62-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Syntactic
% Problem  : Pelletier Problem 62
% Version  : 
% English  : 

% Refs     : Pelletier F.J. (1986), Seventy-Five Problems for Testing 
%            Automatic Theorem Provers, Journal of Automated Reasoning 
%            2(2), 191-216.
%          : Pelletier F.J. (1988), Errata, Journal of Automated 
%            Reasoning 4(2), 235-236.
% Source   : [Pelletier, 1988]
% Names    : Pelletier 62 [Pelletier, 1986]

% Status   : 
% Syntax   : Number of clauses           :   13 (   8 non-Horn)(   1 unit)
%            Number of literals          :   50 (   0 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    4 (   3 constant)
%            Number of variables         :   14 (   6 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    3

% Comments : This problem is incorrect in [Pelletier, 1986] and is 
%            corrected in [Pelletier, 1988].
%--------------------------------------------------------------------------
input_clause(clause_1,theorem,
    [++big_f(a)]).

input_clause(clause_2,theorem,
    [--big_f(f(Y)),
     ++big_f(f(f(X))),
     ++big_f(X),
     --big_f(a)]).

input_clause(clause_3,theorem,
    [++big_f(Y),
     ++big_f(f(f(X))),
     ++big_f(X),
     --big_f(a)]).

input_clause(clause_4,theorem,
    [--big_f(c),
     ++big_f(f(c)),
     ++big_f(f(f(X))),
     ++big_f(X),
     --big_f(a)]).

input_clause(clause_5,theorem,
    [--big_f(f(f(c))),
     ++big_f(f(f(X))),
     ++big_f(X),
     --big_f(a)]).

input_clause(clause_6,theorem,
    [--big_f(f(f(c))),
     ++big_f(f(f(X))),
     --big_f(f(X)),
     --big_f(a)]).

input_clause(clause_7,theorem,
    [--big_f(c),
     ++big_f(f(c)),
     ++big_f(f(f(X))),
     --big_f(f(X)),
     --big_f(a)]).

input_clause(clause_8,theorem,
    [++big_f(Y),
     ++big_f(f(f(X))),
     --big_f(f(X)),
     --big_f(a)]).

input_clause(clause_9,theorem,
    [--big_f(f(Y)),
     ++big_f(f(f(X))),
     --big_f(f(X)),
     --big_f(a)]).

input_clause(clause_10,theorem,
    [--big_f(f(f(c))),
     ++big_f(f(b)),
     --big_f(b)]).

input_clause(clause_11,theorem,
    [--big_f(c),
     ++big_f(f(c)),
     ++big_f(f(b)),
     --big_f(b)]).

input_clause(clause_12,theorem,
    [--big_f(a),
     ++big_f(Y),
     ++big_f(f(b)),
     --big_f(b)]).

input_clause(clause_13,theorem,
    [--big_f(a),
     --big_f(f(Y)),
     ++big_f(f(b)),
     --big_f(b)]).
%--------------------------------------------------------------------------
