%--------------------------------------------------------------------------
% File     : SYN083=FPell61-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Syntactic
% Problem  : Pelletier Problem 61
% Version  : 
% English  : 

% Refs     : Pelletier F.J. (1986), Seventy-Five Problems for Testing 
%            Automatic Theorem Provers, Journal of Automated Reasoning 
%            2(2), 191-216.
% Source   : [Pelletier, 1986]
% Names    : Pelletier 61 [Pelletier, 1986]

% Status   : 
% Syntax   : Number of clauses           :    7 (   0 non-Horn)(   3 unit)
%            Number of literals          :   12 (  12 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    5 (   4 constant)
%            Number of variables         :   15 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
input_clause(f_substitutivity1,axiom,
    [--equal(A,B),
     ++equal(f(A,C),f(B,C))]).

input_clause(f_substitutivity2,axiom,
    [--equal(D,E),
     ++equal(f(F,D),f(F,E))]).

input_clause(f_is_associative,axiom,
    [++equal(f(X,f(Y,Z)),f(f(X,Y),Z))]).

input_clause(prove_this,theorem,
    [--equal(f(a,f(b,f(c,d))),f(f(f(a,b),c),d))]).
%--------------------------------------------------------------------------
