%--------------------------------------------------------------------------
% File     : SYN082=FPell60-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Syntactic
% Problem  : Pelletier Problem 60
% Version  : 
% English  : 

% Refs     : Pelletier F.J. (1986), Seventy-Five Problems for Testing 
%            Automatic Theorem Provers, Journal of Automated Reasoning 
%            2(2), 191-216.
%          : Pelletier F.J. (1988), Errata, Journal of Automated
%            Reasoning 4(2), 235-236.
% Source   : [Pelletier, 1986]
% Names    : Pelletier 60 [Pelletier, 1986]

% Status   : 
% Syntax   : Number of clauses           :    8 (   4 non-Horn)(   0 unit)
%            Number of literals          :   25 (   0 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    4 (   2 constant)
%            Number of variables         :    9 (   0 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    2

% Comments : This problem is incorrect in [Pelletier, 1986] and is
%            corrected in [Pelletier, 1988].
%--------------------------------------------------------------------------
input_clause(clause_1,theorem,
    [++big_f(a,f(a)),
     --big_f(Y,b),
     ++big_f(Y,f(a))]).

input_clause(clause_2,theorem,
    [++big_f(a,f(a)),
     ++big_f(a,b)]).

input_clause(clause_3,theorem,
    [++big_f(g(X),X),
     --big_f(a,X),
     --big_f(Y,b),
     ++big_f(Y,f(a))]).

input_clause(clause_4,theorem,
    [++big_f(g(X),X),
     --big_f(a,X),
     ++big_f(a,b)]).

input_clause(clause_5,theorem,
    [++big_f(g(X),X),
     --big_f(a,X),
     --big_f(a,f(a))]).

input_clause(clause_6,theorem,
    [--big_f(g(X),X),
     --big_f(a,X),
     --big_f(Y,b),
     ++big_f(Y,f(a))]).

input_clause(clause_7,theorem,
    [--big_f(g(X),X),
     --big_f(a,X),
     ++big_f(a,b)]).

input_clause(clause_8,theorem,
    [--big_f(g(X),X),
     --big_f(a,X),
     --big_f(a,f(a))]).
%--------------------------------------------------------------------------
