%--------------------------------------------------------------------------
% File     : SYN080=FPell58-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Syntactic
% Problem  : Pelletier Problem 58
% Version  : 
% English  : 

% Refs     : Pelletier F.J. (1986), Seventy-Five Problems for Testing 
%            Automatic Theorem Provers, Journal of Automated Reasoning 
%            2(2), 191-216.
% Source   : [Pelletier, 1986]
% Names    : Pelletier 58 [Pelletier, 1986]

% Status   : 
% Syntax   : Number of clauses           :    7 (   0 non-Horn)(   3 unit)
%            Number of literals          :   12 (  12 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    4 (   2 constant)
%            Number of variables         :   12 (   2 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
input_clause(f_substitutivity1,axiom,
    [--equal(A,B),
     ++equal(f(A),f(B))]).

input_clause(g_substitutivity1,axiom,
    [--equal(C,D),
     ++equal(g(C),g(D))]).

input_clause(clause_1,axiom,
    [++equal(f(X),g(Y))]).

input_clause(prove_this,theorem,
    [--equal(f(f(a)),f(g(b)))]).
%--------------------------------------------------------------------------
