%--------------------------------------------------------------------------
% File     : SYN078=FPell56-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Syntactic
% Problem  : Pelletier Problem 56
% Version  : 
% English  : 

% Refs     : Pelletier F.J. (1986), Seventy-Five Problems for Testing 
%            Automatic Theorem Provers, Journal of Automated Reasoning 
%            2(2), 191-216.
%          : Pelletier F.J. (1988), Errata, Journal of Automated
%            Reasoning 4(2), 235-236.
% Source   : [Pelletier, 1986]
% Names    : Pelletier 56 [Pelletier, 1986]

% Status   : 
% Syntax   : Number of clauses           :   17 (   6 non-Horn)(   1 unit)
%            Number of literals          :   46 (  16 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    4 (   3 constant)
%            Number of variables         :   21 (   4 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    2

% Comments : This problem is incorrect in [Pelletier, 1986] and is
%            corrected in [Pelletier, 1988].
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
input_clause(f_substitutivity1,axiom,
    [--equal(A,B),
     ++equal(f(A),f(B))]).

input_clause(big_f_substitutivity1,axiom,
    [--equal(C,D),
     --big_f(C),
     ++big_f(D)]).

input_clause(clause_1,theorem,
    [--big_f(X),
     --equal(Y,f(Y)),
     ++big_f(Y),
     --big_f(Z),
     ++big_f(f(Z))]).

input_clause(clause_2,theorem,
    [--big_f(X),
     --equal(Y,f(Y)),
     ++big_f(Y),
     ++big_f(a)]).

input_clause(clause_3,theorem,
    [--big_f(X),
     --equal(Y,f(Y)),
     ++big_f(Y),
     ++equal(b,f(b))]).

input_clause(clause_4,theorem,
    [--big_f(X),
     --equal(Y,f(Y)),
     ++big_f(Y),
     --big_f(b)]).

input_clause(clause_5,theorem,
    [++big_f(c),
     --big_f(X),
     ++big_f(f(X))]).

input_clause(clause_6,theorem,
    [++big_f(c),
     ++big_f(a)]).

input_clause(clause_7,theorem,
    [++big_f(c),
     ++equal(b,f(b))]).

input_clause(clause_8,theorem,
    [++big_f(c),
     --big_f(b)]).

input_clause(clause_9,theorem,
    [--big_f(f(c)),
     --big_f(X),
     ++big_f(f(X))]).

input_clause(clause_10,theorem,
    [--big_f(f(c)),
     ++big_f(a)]).

input_clause(clause_11,theorem,
    [--big_f(f(c)),
     ++equal(b,f(b))]).

input_clause(clause_12,theorem,
    [--big_f(f(c)),
     --big_f(b)]).
%--------------------------------------------------------------------------
