%--------------------------------------------------------------------------
% File     : SYN077=FPell54-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Syntactic
% Problem  : Pelletier Problem 54
% Version  : 
% English  : Montegue's paradox of grounded classes

% Refs     : Montegue R. (1955), On the Paradox of Grounded Classes, 
%            Journal of Symbolic Logic 20(X), 140.
%          : Pelletier F.J. (1986), Seventy-Five Problems for Testing 
%            Automatic Theorem Provers, Journal of Automated Reasoning 
%            2(2), 191-216.
%          : Pelletier F.J. (1988), Errata, Journal of Automated
%            Reasoning 4(2), 235-236.
% Source   : [Pelletier, 1986]
% Names    : Pelletier 54 [Pelletier, 1986]

% Status   : 
% Syntax   : Number of clauses           :   18 (   3 non-Horn)(   1 unit)
%            Number of literals          :   43 (  22 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    5 (   1 constant)
%            Number of variables         :   42 (   0 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    2

% Comments : This problem is incorrect in [Pelletier, 1986] and is
%            corrected in [Pelletier, 1988].
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
input_clause(f_substitutivity1,axiom,
    [--equal(A,B),
     ++equal(f(A),f(B))]).

input_clause(g_substitutivity1,axiom,
    [--equal(C,D),
     ++equal(g(C,E),g(D,E))]).

input_clause(g_substitutivity2,axiom,
    [--equal(F,G),
     ++equal(g(H,F),g(H,G))]).

input_clause(h_substitutivity1,axiom,
    [--equal(I,J),
     ++equal(h(I),h(J))]).

input_clause(i_substitutivity1,axiom,
    [--equal(K,L),
     ++equal(i(K,M),i(L,M))]).

input_clause(i_substitutivity2,axiom,
    [--equal(N,O),
     ++equal(i(P,N),i(P,O))]).

input_clause(big_f_substitutivity1,axiom,
    [--equal(Q,R),
     --big_f(Q,S),
     ++big_f(R,S)]).

input_clause(big_f_substitutivity2,axiom,
    [--equal(T,U),
     --big_f(V,T),
     ++big_f(V,U)]).

input_clause(clause_1,axiom,
    [--big_f(X,f(Y)),
     ++equal(X,Y)]).

input_clause(clause_2,axiom,
    [--equal(X,Y),
     ++big_f(X,f(Y))]).

input_clause(clause_3,theorem,
    [--big_f(X,a),
     --big_f(X,Y),
     ++big_f(g(X,Y),Y)]).

input_clause(clause_4,theorem,
    [--big_f(X,a),
     --big_f(X,Y),
     --big_f(Z,g(X,Y)),
     --big_f(Z,Y)]).

input_clause(clause_5,theorem,
    [++big_f(X,h(X)),
     ++big_f(X,a)]).

input_clause(clause_6,theorem,
    [--big_f(X,h(Y)),
     ++big_f(i(Y,X),X),
     ++big_f(Y,a)]).

input_clause(clause_7,theorem,
    [++big_f(X,a),
     ++big_f(i(X,Y),h(X)),
     --big_f(Y,h(X))]).
%--------------------------------------------------------------------------
