%--------------------------------------------------------------------------
% File     : SYN076=FPell53-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Syntactic
% Problem  : Pelletier Problem 53
% Version  : 
% English  : 

% Refs     : Pelletier F.J. (1986), Seventy-Five Problems for Testing 
%            Automatic Theorem Provers, Journal of Automated Reasoning 
%            2(2), 191-216.
% Source   : [Pelletier, 1986]
% Names    : Pelletier 53 [Pelletier, 1986]

% Status   : 
% Syntax   : Number of clauses           :   53 (  32 non-Horn)(   2 unit)
%            Number of literals          :  235 ( 167 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :   14 (   4 constant)
%            Number of variables         :  177 (   0 singleton)
%            Maximal clause size         :    6
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
input_clause(f1_substitutivity1,axiom,
    [--equal(A,B),
     ++equal(f1(A,C),f1(B,C))]).

input_clause(f1_substitutivity2,axiom,
    [--equal(D,E),
     ++equal(f1(F,D),f1(F,E))]).

input_clause(f10_substitutivity1,axiom,
    [--equal(G,H),
     ++equal(f10(G),f10(H))]).

input_clause(f2_substitutivity1,axiom,
    [--equal(I,J),
     ++equal(f2(I),f2(J))]).

input_clause(f3_substitutivity1,axiom,
    [--equal(K,L),
     ++equal(f3(K,M),f3(L,M))]).

input_clause(f3_substitutivity2,axiom,
    [--equal(N,O),
     ++equal(f3(P,N),f3(P,O))]).

input_clause(f4_substitutivity1,axiom,
    [--equal(Q,R),
     ++equal(f4(Q),f4(R))]).

input_clause(f5_substitutivity1,axiom,
    [--equal(S,T),
     ++equal(f5(S),f5(T))]).

input_clause(f6_substitutivity1,axiom,
    [--equal(U,V),
     ++equal(f6(U,W),f6(V,W))]).

input_clause(f6_substitutivity2,axiom,
    [--equal(X,Y),
     ++equal(f6(Z,X),f6(Z,Y))]).

input_clause(f7_substitutivity1,axiom,
    [--equal(A1,B1),
     ++equal(f7(A1),f7(B1))]).

input_clause(f8_substitutivity1,axiom,
    [--equal(C1,D1),
     ++equal(f8(C1),f8(D1))]).

input_clause(f9_substitutivity1,axiom,
    [--equal(E1,F1),
     ++equal(f9(E1,G1),f9(F1,G1))]).

input_clause(f9_substitutivity2,axiom,
    [--equal(H1,I1),
     ++equal(f9(J1,H1),f9(J1,I1))]).

input_clause(big_f_substitutivity1,axiom,
    [--equal(K1,L1),
     --big_f(K1,M1),
     ++big_f(L1,M1)]).

input_clause(big_f_substitutivity2,axiom,
    [--equal(N1,O1),
     --big_f(P1,N1),
     ++big_f(P1,O1)]).

input_clause(clause_1,axiom,
    [--equal(c2,c1)]).

input_clause(clause_2,axiom,
    [++equal(X1,c2),
     ++equal(X1,c1)]).

input_clause(clause_3,theorem,
    [++big_f(X10,f1(X10,X11)),
     ++equal(f1(X10,X11),X11),
     ++equal(X10,c3),
     ++big_f(f3(X2,X13),X2),
     ++equal(f3(X2,X13),X13),
     ++equal(X2,c4)]).

input_clause(clause_4,theorem,
    [++big_f(X10,f1(X10,X11)),
     ++equal(f1(X10,X11),X11),
     ++equal(X10,c3),
     --big_f(f3(X2,X13),X2),
     --equal(f3(X2,X13),X13),
     ++equal(X2,c4)]).

input_clause(clause_5,theorem,
    [++big_f(X10,f1(X10,X11)),
     ++equal(f1(X10,X11),X11),
     ++equal(X10,c3),
     --big_f(X3,X2),
     ++equal(X3,f4(X2)),
     --equal(X2,c4)]).

input_clause(clause_6,theorem,
    [++big_f(X10,f1(X10,X11)),
     ++equal(f1(X10,X11),X11),
     ++equal(X10,c3),
     ++big_f(X3,X2),
     --equal(X3,f4(X2)),
     --equal(X2,c4)]).

input_clause(clause_7,theorem,
    [--big_f(X10,f1(X10,X11)),
     --equal(f1(X10,X11),X11),
     ++equal(X10,c3),
     ++big_f(f3(X2,X13),X2),
     ++equal(f3(X2,X13),X13),
     ++equal(X2,c4)]).

input_clause(clause_8,theorem,
    [--big_f(X10,f1(X10,X11)),
     --equal(f1(X10,X11),X11),
     ++equal(X10,c3),
     --big_f(f3(X2,X13),X2),
     --equal(f3(X2,X13),X13),
     ++equal(X2,c4)]).

input_clause(clause_9,theorem,
    [--big_f(X10,f1(X10,X11)),
     --equal(f1(X10,X11),X11),
     ++equal(X10,c3),
     --big_f(X3,X2),
     ++equal(X3,f4(X2)),
     --equal(X2,c4)]).

input_clause(clause_10,theorem,
    [--big_f(X10,f1(X10,X11)),
     --equal(f1(X10,X11),X11),
     ++equal(X10,c3),
     ++big_f(X3,X2),
     --equal(X3,f4(X2)),
     --equal(X2,c4)]).

input_clause(clause_11,theorem,
    [--big_f(X10,X12),
     ++equal(X12,f2(X10)),
     --equal(X10,c3),
     ++big_f(f3(X2,X13),X2),
     ++equal(f3(X2,X13),X13),
     ++equal(X2,c4)]).

input_clause(clause_12,theorem,
    [--big_f(X10,X12),
     ++equal(X12,f2(X10)),
     --equal(X10,c3),
     --big_f(f3(X2,X13),X2),
     --equal(f3(X2,X13),X13),
     ++equal(X2,c4)]).

input_clause(clause_13,theorem,
    [--big_f(X10,X12),
     ++equal(X12,f2(X10)),
     --equal(X10,c3),
     --big_f(X3,X2),
     ++equal(X3,f4(X2)),
     --equal(X2,c4)]).

input_clause(clause_14,theorem,
    [--big_f(X10,X12),
     ++equal(X12,f2(X10)),
     --equal(X10,c3),
     ++big_f(X3,X2),
     --equal(X3,f4(X2)),
     --equal(X2,c4)]).

input_clause(clause_15,theorem,
    [++big_f(X10,X12),
     --equal(X12,f2(X10)),
     --equal(X10,c3),
     ++big_f(f3(X2,X13),X2),
     ++equal(f3(X2,X13),X13),
     ++equal(X2,c4)]).

input_clause(clause_16,theorem,
    [++big_f(X10,X12),
     --equal(X12,f2(X10)),
     --equal(X10,c3),
     --big_f(f3(X2,X13),X2),
     --equal(f3(X2,X13),X13),
     ++equal(X2,c4)]).

input_clause(clause_17,theorem,
    [++big_f(X10,X12),
     --equal(X12,f2(X10)),
     --equal(X10,c3),
     --big_f(X3,X2),
     ++equal(X3,f4(X2)),
     --equal(X2,c4)]).

input_clause(clause_18,theorem,
    [++big_f(X10,X12),
     --equal(X12,f2(X10)),
     --equal(X10,c3),
     ++big_f(X3,X2),
     --equal(X3,f4(X2)),
     --equal(X2,c4)]).

input_clause(clause_19,theorem,
    [--big_f(f7(X4),X5),
     ++equal(X5,f5(X4)),
     ++equal(f7(X4),X4),
     --big_f(X8,f10(X7)),
     ++equal(X8,f8(X7)),
     ++equal(f10(X7),X7)]).

input_clause(clause_20,theorem,
    [--big_f(f7(X4),X5),
     ++equal(X5,f5(X4)),
     ++equal(f7(X4),X4),
     ++big_f(X8,f10(X7)),
     --equal(X8,f8(X7)),
     ++equal(f10(X7),X7)]).

input_clause(clause_21,theorem,
    [--big_f(f7(X4),X5),
     ++equal(X5,f5(X4)),
     ++equal(f7(X4),X4),
     ++big_f(f9(X7,X9),f10(X7)),
     ++equal(f9(X7,X9),X9),
     --equal(f10(X7),X7)]).

input_clause(clause_22,theorem,
    [--big_f(f7(X4),X5),
     ++equal(X5,f5(X4)),
     ++equal(f7(X4),X4),
     --big_f(f9(X7,X9),f10(X7)),
     --equal(f9(X7,X9),X9),
     --equal(f10(X7),X7)]).

input_clause(clause_23,theorem,
    [++big_f(f7(X4),X5),
     --equal(X5,f5(X4)),
     ++equal(f7(X4),X4),
     --big_f(X8,f10(X7)),
     ++equal(X8,f8(X7)),
     ++equal(f10(X7),X7)]).

input_clause(clause_24,theorem,
    [++big_f(f7(X4),X5),
     --equal(X5,f5(X4)),
     ++equal(f7(X4),X4),
     ++big_f(X8,f10(X7)),
     --equal(X8,f8(X7)),
     ++equal(f10(X7),X7)]).

input_clause(clause_25,theorem,
    [++big_f(f7(X4),X5),
     --equal(X5,f5(X4)),
     ++equal(f7(X4),X4),
     ++big_f(f9(X7,X9),f10(X7)),
     ++equal(f9(X7,X9),X9),
     --equal(f10(X7),X7)]).

input_clause(clause_26,theorem,
    [++big_f(f7(X4),X5),
     --equal(X5,f5(X4)),
     ++equal(f7(X4),X4),
     --big_f(f9(X7,X9),f10(X7)),
     --equal(f9(X7,X9),X9),
     --equal(f10(X7),X7)]).

input_clause(clause_27,theorem,
    [++big_f(f7(X4),f6(X4,X6)),
     ++equal(f6(X4,X6),X6),
     --equal(f7(X4),X4),
     --big_f(X8,f10(X7)),
     ++equal(X8,f8(X7)),
     ++equal(f10(X7),X7)]).

input_clause(clause_28,theorem,
    [++big_f(f7(X4),f6(X4,X6)),
     ++equal(f6(X4,X6),X6),
     --equal(f7(X4),X4),
     ++big_f(X8,f10(X7)),
     --equal(X8,f8(X7)),
     ++equal(f10(X7),X7)]).

input_clause(clause_29,theorem,
    [++big_f(f7(X4),f6(X4,X6)),
     ++equal(f6(X4,X6),X6),
     --equal(f7(X4),X4),
     ++big_f(f9(X7,X9),f10(X7)),
     ++equal(f9(X7,X9),X9),
     --equal(f10(X7),X7)]).

input_clause(clause_30,theorem,
    [++big_f(f7(X4),f6(X4,X6)),
     ++equal(f6(X4,X6),X6),
     --equal(f7(X4),X4),
     --big_f(f9(X7,X9),f10(X7)),
     --equal(f9(X7,X9),X9),
     --equal(f10(X7),X7)]).

input_clause(clause_31,theorem,
    [--big_f(f7(X4),f6(X4,X6)),
     --equal(f6(X4,X6),X6),
     --equal(f7(X4),X4),
     --big_f(X8,f10(X7)),
     ++equal(X8,f8(X7)),
     ++equal(f10(X7),X7)]).

input_clause(clause_32,theorem,
    [--big_f(f7(X4),f6(X4,X6)),
     --equal(f6(X4,X6),X6),
     --equal(f7(X4),X4),
     ++big_f(X8,f10(X7)),
     --equal(X8,f8(X7)),
     ++equal(f10(X7),X7)]).

input_clause(clause_33,theorem,
    [--big_f(f7(X4),f6(X4,X6)),
     --equal(f6(X4,X6),X6),
     --equal(f7(X4),X4),
     ++big_f(f9(X7,X9),f10(X7)),
     ++equal(f9(X7,X9),X9),
     --equal(f10(X7),X7)]).

input_clause(clause_34,theorem,
    [--big_f(f7(X4),f6(X4,X6)),
     --equal(f6(X4,X6),X6),
     --equal(f7(X4),X4),
     --big_f(f9(X7,X9),f10(X7)),
     --equal(f9(X7,X9),X9),
     --equal(f10(X7),X7)]).
%--------------------------------------------------------------------------
