%--------------------------------------------------------------------------
% File     : SYN075=FPell52-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Syntactic
% Problem  : Pelletier Problem 52
% Version  : 
% English  : 

% Refs     : Pelletier F.J. (1986), Seventy-Five Problems for Testing 
%            Automatic Theorem Provers, Journal of Automated Reasoning 
%            2(2), 191-216.
% Source   : [Pelletier, 1986]
% Names    : Pelletier 52 [Pelletier, 1986]

% Status   : 
% Syntax   : Number of clauses           :   19 (   4 non-Horn)(   1 unit)
%            Number of literals          :   51 (  33 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    5 (   2 constant)
%            Number of variables         :   45 (   2 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
input_clause(f_substitutivity1,axiom,
    [--equal(A,B),
     ++equal(f(A),f(B))]).

input_clause(g_substitutivity1,axiom,
    [--equal(C,D),
     ++equal(g(C),g(D))]).

input_clause(h_substitutivity1,axiom,
    [--equal(E,F),
     ++equal(h(E,G),h(F,G))]).

input_clause(h_substitutivity2,axiom,
    [--equal(H,I),
     ++equal(h(J,H),h(J,I))]).

input_clause(big_f_substitutivity1,axiom,
    [--equal(K,L),
     --big_f(K,M),
     ++big_f(L,M)]).

input_clause(big_f_substitutivity2,axiom,
    [--equal(N,O),
     --big_f(P,N),
     ++big_f(P,O)]).

input_clause(clause_1,axiom,
    [--big_f(X,Y),
     ++equal(X,a)]).

input_clause(clause_2,axiom,
    [--big_f(X,Y),
     ++equal(Y,b)]).

input_clause(clause_3,axiom,
    [--equal(X,a),
     --equal(Y,b),
     ++big_f(X,Y)]).

input_clause(clause_4,theorem,
    [--big_f(Y,f(X)),
     --equal(Y,g(X)),
     ++equal(f(X),X)]).

input_clause(clause_5,theorem,
    [--big_f(Y,f(X)),
     ++equal(Y,g(X)),
     ++big_f(h(X,Z),f(X)),
     --big_f(h(X,Z),f(X))]).

input_clause(clause_6,theorem,
    [--equal(Y,g(X)),
     ++big_f(Y,f(X)),
     ++equal(f(X),X)]).

input_clause(clause_7,theorem,
    [--equal(Y,g(X)),
     ++big_f(Y,f(X)),
     ++big_f(h(X,Z),f(X)),
     ++equal(h(X,Z),Z)]).

input_clause(clause_8,theorem,
    [--equal(Y,g(X)),
     ++big_f(Y,f(X)),
     --equal(h(X,Z),Z),
     --big_f(h(X,Z),f(X))]).

input_clause(clause_9,theorem,
    [--equal(f(X),X),
     ++big_f(h(X,Z),f(X)),
     ++equal(h(X,Z),Z)]).

input_clause(clause_10,theorem,
    [--equal(f(X),X),
     --equal(h(X,Z),Z),
     --big_f(h(X,Z),f(X))]).
%--------------------------------------------------------------------------
