%--------------------------------------------------------------------------
% File     : SYN073=FPell50-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Syntactic
% Problem  : Pelletier Problem 50
% Version  : 
% English  : 

% Refs     : Pelletier F.J. (1986), Seventy-Five Problems for Testing 
%            Automatic Theorem Provers, Journal of Automated Reasoning 
%            2(2), 191-216.
% Source   : [Pelletier, 1986]
% Names    : Pelletier 50 [Pelletier, 1986]

% Status   : 
% Syntax   : Number of clauses           :    8 (   1 non-Horn)(   2 unit)
%            Number of literals          :   17 (  10 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    2 (   1 constant)
%            Number of variables         :   17 (   1 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
input_clause(f_substitutivity1,axiom,
    [--equal(A,B),
     ++equal(f(A),f(B))]).

input_clause(big_f_substitutivity1,axiom,
    [--equal(C,D),
     --big_f(C,E),
     ++big_f(D,E)]).

input_clause(big_f_substitutivity2,axiom,
    [--equal(F,G),
     --big_f(H,F),
     ++big_f(H,G)]).

input_clause(clause_1,theorem,
    [++big_f(a,X),
     ++big_f(X,Y)]).

input_clause(prove_this,theorem,
    [--big_f(X,f(X))]).
%--------------------------------------------------------------------------
