%--------------------------------------------------------------------------
% File     : SYN072=FPell49-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Syntactic
% Problem  : Pelletier Problem 49
% Version  : 
% English  : 

% Refs     : Pelletier F.J. (1986), Seventy-Five Problems for Testing 
%            Automatic Theorem Provers, Journal of Automated Reasoning 
%            2(2), 191-216.
% Source   : [Pelletier, 1986]
% Names    : Pelletier 49 [Pelletier, 1986]

% Status   : 
% Syntax   : Number of clauses           :    9 (   1 non-Horn)(   5 unit)
%            Number of literals          :   15 (  10 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    5 (   5 constant)
%            Number of variables         :    9 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    1

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
input_clause(big_p_substitutivity1,axiom,
    [--equal(A,B),
     --big_p(A),
     ++big_p(B)]).

input_clause(clause_1,axiom,
    [++equal(X,c),
     ++equal(X,d)]).

input_clause(clause_2,axiom,
    [++big_p(a)]).

input_clause(clause_3,axiom,
    [++big_p(b)]).

input_clause(clause_4,axiom,
    [--equal(a,b)]).

input_clause(prove_this,theorem,
    [--big_p(e)]).
%--------------------------------------------------------------------------
