%--------------------------------------------------------------------------
% File     : SYN071=FPell48-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Syntactic
% Problem  : Pelletier Problem 48
% Version  : 
% English  : 

% Refs     : Pelletier F.J. (1986), Seventy-Five Problems for Testing 
%            Automatic Theorem Provers, Journal of Automated Reasoning 
%            2(2), 191-216.
% Source   : [Pelletier, 1986]
% Names    : Pelletier 48 [Pelletier, 1986]

% Status   : 
% Syntax   : Number of clauses           :    7 (   2 non-Horn)(   3 unit)
%            Number of literals          :   12 (  12 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    4 (   4 constant)
%            Number of variables         :    6 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    1

% Comments : Pelletier says that Rudnicki has not published this problem 
%            anywhere.
%            Rudnicki says "I have seen it for the first time around 1977, 
%            it was shown to me by A. Trybulec but I am sure 
%            it is folklore."
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
input_clause(clause_1,axiom,
    [++equal(a,b),
     ++equal(c,d)]).

input_clause(clause_2,axiom,
    [++equal(a,c),
     ++equal(b,d)]).

input_clause(clause_3,theorem,
    [--equal(a,d)]).

input_clause(clause_4,theorem,
    [--equal(b,c)]).
%--------------------------------------------------------------------------
