%--------------------------------------------------------------------------
% File     : SYN067=FPell38-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Syntactic
% Problem  : Pelletier Problem 38
% Version  : 
% English  : 

% Refs     : Pelletier F.J. (1986), Seventy-Five Problems for Testing 
%            Automatic Theorem Provers, Journal of Automated Reasoning 
%            2(2), 191-216.
% Source   : [Pelletier, 1986]
% Names    : Pelletier 38 [Pelletier, 1986]
%          : p38a.in [ANL]
%          : p38b.in [ANL]

% Status   : satisfiable
% Syntax   : Number of clauses           :   84 (  69 non-Horn)(   0 unit)
%            Number of literals          :  500 (   0 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :   11 (   5 constant)
%            Number of variables         :  188 (   0 singleton)
%            Maximal clause size         :    9
%            Maximal term depth          :    2

% Comments : A full predicate logic version of Pelletier 17 and 33.
%--------------------------------------------------------------------------
input_clause(clause_1,theorem,
    [--p(a),
     ++p(X7),
     ++p(f2(X7)),
     --p(a),
     ++p(X1),
     ++p(f4(X1))]).

input_clause(clause_2,theorem,
    [--p(a),
     ++p(X7),
     ++p(f2(X7)),
     --p(a),
     ++p(X1),
     ++r(X1,f3(X1))]).

input_clause(clause_3,theorem,
    [--p(a),
     ++p(X7),
     ++p(f2(X7)),
     --p(a),
     ++p(X1),
     ++r(f3(X1),f4(X1))]).

input_clause(clause_4,theorem,
    [--p(a),
     ++p(X7),
     ++p(f2(X7)),
     --p(a),
     --p(X2),
     --r(X1,X2),
     ++p(f6(X1))]).

input_clause(clause_5,theorem,
    [--p(a),
     ++p(X7),
     ++p(f2(X7)),
     --p(a),
     --p(X2),
     --r(X1,X2),
     ++r(X1,f5(X1))]).

input_clause(clause_6,theorem,
    [--p(a),
     ++p(X7),
     ++p(f2(X7)),
     --p(a),
     --p(X2),
     --r(X1,X2),
     ++r(f5(X1),f6(X1))]).

input_clause(clause_7,theorem,
    [--p(a),
     ++p(X7),
     ++r(X7,f1(X7)),
     --p(a),
     ++p(X1),
     ++p(f4(X1))]).

input_clause(clause_8,theorem,
    [--p(a),
     ++p(X7),
     ++r(X7,f1(X7)),
     --p(a),
     ++p(X1),
     ++r(X1,f3(X1))]).

input_clause(clause_9,theorem,
    [--p(a),
     ++p(X7),
     ++r(X7,f1(X7)),
     --p(a),
     ++p(X1),
     ++r(f3(X1),f4(X1))]).

input_clause(clause_10,theorem,
    [--p(a),
     ++p(X7),
     ++r(X7,f1(X7)),
     --p(a),
     --p(X2),
     --r(X1,X2),
     ++p(f6(X1))]).

input_clause(clause_11,theorem,
    [--p(a),
     ++p(X7),
     ++r(X7,f1(X7)),
     --p(a),
     --p(X2),
     --r(X1,X2),
     ++r(X1,f5(X1))]).

input_clause(clause_12,theorem,
    [--p(a),
     ++p(X7),
     ++r(X7,f1(X7)),
     --p(a),
     --p(X2),
     --r(X1,X2),
     ++r(f5(X1),f6(X1))]).

input_clause(clause_13,theorem,
    [--p(a),
     ++p(X7),
     ++r(f1(X7),f2(X7)),
     --p(a),
     ++p(X1),
     ++p(f4(X1))]).

input_clause(clause_14,theorem,
    [--p(a),
     ++p(X7),
     ++r(f1(X7),f2(X7)),
     --p(a),
     ++p(X1),
     ++r(X1,f3(X1))]).

input_clause(clause_15,theorem,
    [--p(a),
     ++p(X7),
     ++r(f1(X7),f2(X7)),
     --p(a),
     ++p(X1),
     ++r(f3(X1),f4(X1))]).

input_clause(clause_16,theorem,
    [--p(a),
     ++p(X7),
     ++r(f1(X7),f2(X7)),
     --p(a),
     --p(X2),
     --r(X1,X2),
     ++p(f6(X1))]).

input_clause(clause_17,theorem,
    [--p(a),
     ++p(X7),
     ++r(f1(X7),f2(X7)),
     --p(a),
     --p(X2),
     --r(X1,X2),
     ++r(X1,f5(X1))]).

input_clause(clause_18,theorem,
    [--p(a),
     ++p(X7),
     ++r(f1(X7),f2(X7)),
     --p(a),
     --p(X2),
     --r(X1,X2),
     ++r(f5(X1),f6(X1))]).

input_clause(clause_19,theorem,
    [--p(a),
     --p(X8),
     --r(X7,X8),
     ++p(f2(X7)),
     --p(a),
     ++p(X1),
     ++p(f4(X1))]).

input_clause(clause_20,theorem,
    [--p(a),
     --p(X8),
     --r(X7,X8),
     ++p(f2(X7)),
     --p(a),
     ++p(X1),
     ++r(X1,f3(X1))]).

input_clause(clause_21,theorem,
    [--p(a),
     --p(X8),
     --r(X7,X8),
     ++p(f2(X7)),
     --p(a),
     ++p(X1),
     ++r(f3(X1),f4(X1))]).

input_clause(clause_22,theorem,
    [--p(a),
     --p(X8),
     --r(X7,X8),
     ++p(f2(X7)),
     --p(a),
     --p(X2),
     --r(X1,X2),
     ++p(f6(X1))]).

input_clause(clause_23,theorem,
    [--p(a),
     --p(X8),
     --r(X7,X8),
     ++p(f2(X7)),
     --p(a),
     --p(X2),
     --r(X1,X2),
     ++r(X1,f5(X1))]).

input_clause(clause_24,theorem,
    [--p(a),
     --p(X8),
     --r(X7,X8),
     ++p(f2(X7)),
     --p(a),
     --p(X2),
     --r(X1,X2),
     ++r(f5(X1),f6(X1))]).

input_clause(clause_25,theorem,
    [--p(a),
     --p(X8),
     --r(X7,X8),
     ++r(X7,f1(X7)),
     --p(a),
     ++p(X1),
     ++p(f4(X1))]).

input_clause(clause_26,theorem,
    [--p(a),
     --p(X8),
     --r(X7,X8),
     ++r(X7,f1(X7)),
     --p(a),
     ++p(X1),
     ++r(X1,f3(X1))]).

input_clause(clause_27,theorem,
    [--p(a),
     --p(X8),
     --r(X7,X8),
     ++r(X7,f1(X7)),
     --p(a),
     ++p(X1),
     ++r(f3(X1),f4(X1))]).

input_clause(clause_28,theorem,
    [--p(a),
     --p(X8),
     --r(X7,X8),
     ++r(X7,f1(X7)),
     --p(a),
     --p(X2),
     --r(X1,X2),
     ++p(f6(X1))]).

input_clause(clause_29,theorem,
    [--p(a),
     --p(X8),
     --r(X7,X8),
     ++r(X7,f1(X7)),
     --p(a),
     --p(X2),
     --r(X1,X2),
     ++r(X1,f5(X1))]).

input_clause(clause_30,theorem,
    [--p(a),
     --p(X8),
     --r(X7,X8),
     ++r(X7,f1(X7)),
     --p(a),
     --p(X2),
     --r(X1,X2),
     ++r(f5(X1),f6(X1))]).

input_clause(clause_31,theorem,
    [--p(a),
     --p(X8),
     --r(X7,X8),
     ++r(f1(X7),f2(X7)),
     --p(a),
     ++p(X1),
     ++p(f4(X1))]).

input_clause(clause_32,theorem,
    [--p(a),
     --p(X8),
     --r(X7,X8),
     ++r(f1(X7),f2(X7)),
     --p(a),
     ++p(X1),
     ++r(X1,f3(X1))]).

input_clause(clause_33,theorem,
    [--p(a),
     --p(X8),
     --r(X7,X8),
     ++r(f1(X7),f2(X7)),
     --p(a),
     ++p(X1),
     ++r(f3(X1),f4(X1))]).

input_clause(clause_34,theorem,
    [--p(a),
     --p(X8),
     --r(X7,X8),
     ++r(f1(X7),f2(X7)),
     --p(a),
     --p(X2),
     --r(X1,X2),
     ++p(f6(X1))]).

input_clause(clause_35,theorem,
    [--p(a),
     --p(X8),
     --r(X7,X8),
     ++r(f1(X7),f2(X7)),
     --p(a),
     --p(X2),
     --r(X1,X2),
     ++r(X1,f5(X1))]).

input_clause(clause_36,theorem,
    [--p(a),
     --p(X8),
     --r(X7,X8),
     ++r(f1(X7),f2(X7)),
     --p(a),
     --p(X2),
     --r(X1,X2),
     ++r(f5(X1),f6(X1))]).

input_clause(clause_37,theorem,
    [++p(a),
     ++p(a),
     ++p(a)]).

input_clause(clause_38,theorem,
    [++p(a),
     ++p(a),
     ++p(c3)]).

input_clause(clause_39,theorem,
    [++p(a),
     ++p(a),
     ++r(c4,c3)]).

input_clause(clause_40,theorem,
    [++p(a),
     ++p(a),
     --p(X5),
     --r(c4,X6),
     --r(X6,X5)]).

input_clause(clause_41,theorem,
    [++p(a),
     --p(c4),
     ++p(a)]).

input_clause(clause_42,theorem,
    [++p(a),
     --p(c4),
     ++p(c3)]).

input_clause(clause_43,theorem,
    [++p(a),
     --p(c4),
     ++r(c4,c3)]).

input_clause(clause_44,theorem,
    [++p(a),
     --p(c4),
     --p(X5),
     --r(c4,X6),
     --r(X6,X5)]).

input_clause(clause_45,theorem,
    [++p(a),
     --p(X3),
     --r(c4,X4),
     --r(X4,X3),
     ++p(a)]).

input_clause(clause_46,theorem,
    [++p(a),
     --p(X3),
     --r(c4,X4),
     --r(X4,X3),
     ++p(c3)]).

input_clause(clause_47,theorem,
    [++p(a),
     --p(X3),
     --r(c4,X4),
     --r(X4,X3),
     ++r(c4,c3)]).

input_clause(clause_48,theorem,
    [++p(a),
     --p(X3),
     --r(c4,X4),
     --r(X4,X3),
     --p(X5),
     --r(c4,X6),
     --r(X6,X5)]).

input_clause(clause_49,theorem,
    [--p(c2),
     ++p(c1),
     ++p(a),
     ++p(a)]).

input_clause(clause_50,theorem,
    [--p(c2),
     ++p(c1),
     ++p(a),
     ++p(c3)]).

input_clause(clause_51,theorem,
    [--p(c2),
     ++p(c1),
     ++p(a),
     ++r(c4,c3)]).

input_clause(clause_52,theorem,
    [--p(c2),
     ++p(c1),
     ++p(a),
     --p(X5),
     --r(c4,X6),
     --r(X6,X5)]).

input_clause(clause_53,theorem,
    [--p(c2),
     ++p(c1),
     --p(c4),
     ++p(a)]).

input_clause(clause_54,theorem,
    [--p(c2),
     ++p(c1),
     --p(c4),
     ++p(c3)]).

input_clause(clause_55,theorem,
    [--p(c2),
     ++p(c1),
     --p(c4),
     ++r(c4,c3)]).

input_clause(clause_56,theorem,
    [--p(c2),
     ++p(c1),
     --p(c4),
     --p(X5),
     --r(c4,X6),
     --r(X6,X5)]).

input_clause(clause_57,theorem,
    [--p(c2),
     ++p(c1),
     --p(X3),
     --r(c4,X4),
     --r(X4,X3),
     ++p(a)]).

input_clause(clause_58,theorem,
    [--p(c2),
     ++p(c1),
     --p(X3),
     --r(c4,X4),
     --r(X4,X3),
     ++p(c3)]).

input_clause(clause_59,theorem,
    [--p(c2),
     ++p(c1),
     --p(X3),
     --r(c4,X4),
     --r(X4,X3),
     ++r(c4,c3)]).

input_clause(clause_60,theorem,
    [--p(c2),
     ++p(c1),
     --p(X3),
     --r(c4,X4),
     --r(X4,X3),
     --p(X5),
     --r(c4,X6),
     --r(X6,X5)]).

input_clause(clause_61,theorem,
    [--p(c2),
     ++r(c2,c1),
     ++p(a),
     ++p(a)]).

input_clause(clause_62,theorem,
    [--p(c2),
     ++r(c2,c1),
     ++p(a),
     ++p(c3)]).

input_clause(clause_63,theorem,
    [--p(c2),
     ++r(c2,c1),
     ++p(a),
     ++r(c4,c3)]).

input_clause(clause_64,theorem,
    [--p(c2),
     ++r(c2,c1),
     ++p(a),
     --p(X5),
     --r(c4,X6),
     --r(X6,X5)]).

input_clause(clause_65,theorem,
    [--p(c2),
     ++r(c2,c1),
     --p(c4),
     ++p(a)]).

input_clause(clause_66,theorem,
    [--p(c2),
     ++r(c2,c1),
     --p(c4),
     ++p(c3)]).

input_clause(clause_67,theorem,
    [--p(c2),
     ++r(c2,c1),
     --p(c4),
     ++r(c4,c3)]).

input_clause(clause_68,theorem,
    [--p(c2),
     ++r(c2,c1),
     --p(c4),
     --p(X5),
     --r(c4,X6),
     --r(X6,X5)]).

input_clause(clause_69,theorem,
    [--p(c2),
     ++r(c2,c1),
     --p(X3),
     --r(c4,X4),
     --r(X4,X3),
     ++p(a)]).

input_clause(clause_70,theorem,
    [--p(c2),
     ++r(c2,c1),
     --p(X3),
     --r(c4,X4),
     --r(X4,X3),
     ++p(c3)]).

input_clause(clause_71,theorem,
    [--p(c2),
     ++r(c2,c1),
     --p(X3),
     --r(c4,X4),
     --r(X4,X3),
     ++r(c4,c3)]).

input_clause(clause_72,theorem,
    [--p(c2),
     ++r(c2,c1),
     --p(X3),
     --r(c4,X4),
     --r(X4,X3),
     --p(X5),
     --r(c4,X6),
     --r(X6,X5)]).

input_clause(clause_73,theorem,
    [--p(X9),
     --r(c2,X10),
     --r(X10,X9),
     ++p(a),
     ++p(a)]).

input_clause(clause_74,theorem,
    [--p(X9),
     --r(c2,X10),
     --r(X10,X9),
     ++p(a),
     ++p(c3)]).

input_clause(clause_75,theorem,
    [--p(X9),
     --r(c2,X10),
     --r(X10,X9),
     ++p(a),
     ++r(c4,c3)]).

input_clause(clause_76,theorem,
    [--p(X9),
     --r(c2,X10),
     --r(X10,X9),
     ++p(a),
     --p(X5),
     --r(c4,X6),
     --r(X6,X5)]).

input_clause(clause_77,theorem,
    [--p(X9),
     --r(c2,X10),
     --r(X10,X9),
     --p(c4),
     ++p(a)]).

input_clause(clause_78,theorem,
    [--p(X9),
     --r(c2,X10),
     --r(X10,X9),
     --p(c4),
     ++p(c3)]).

input_clause(clause_79,theorem,
    [--p(X9),
     --r(c2,X10),
     --r(X10,X9),
     --p(c4),
     ++r(c4,c3)]).

input_clause(clause_80,theorem,
    [--p(X9),
     --r(c2,X10),
     --r(X10,X9),
     --p(c4),
     --p(X5),
     --r(c4,X6),
     --r(X6,X5)]).

input_clause(clause_81,theorem,
    [--p(X9),
     --r(c2,X10),
     --r(X10,X9),
     --p(X3),
     --r(c4,X4),
     --r(X4,X3),
     ++p(a)]).

input_clause(clause_82,theorem,
    [--p(X9),
     --r(c2,X10),
     --r(X10,X9),
     --p(X3),
     --r(c4,X4),
     --r(X4,X3),
     ++p(c3)]).

input_clause(clause_83,theorem,
    [--p(X9),
     --r(c2,X10),
     --r(X10,X9),
     --p(X3),
     --r(c4,X4),
     --r(X4,X3),
     ++r(c4,c3)]).

input_clause(clause_84,theorem,
    [--p(X9),
     --r(c2,X10),
     --r(X10,X9),
     --p(X3),
     --r(c4,X4),
     --r(X4,X3),
     --p(X5),
     --r(c4,X6),
     --r(X6,X5)]).
%--------------------------------------------------------------------------
