%--------------------------------------------------------------------------
% File     : SYN063=FPell33-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Syntactic
% Problem  : Pelletier Problem 33
% Version  : 
% English  : 

% Refs     : Kalish D. and Montegue R. (1964), Logic: Techniques of Formal 
%            Reasoning, World, Harcourt and Brace, New York, NY.
%          : Pelletier F.J. (1986), Seventy-Five Problems for Testing 
%            Automatic Theorem Provers, Journal of Automated Reasoning 
%            2(2), 191-216.
% Source   : [Pelletier, 1986]
% Names    : Pelletier 33 [Pelletier, 1986]

% Status   : 
% Syntax   : Number of clauses           :    7 (   3 non-Horn)(   2 unit)
%            Number of literals          :   22 (   0 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    5 (   5 constant)
%            Number of variables         :    4 (   4 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    1

% Comments : This is a monadic predicate formulation of Pelletier 17.
%--------------------------------------------------------------------------
input_clause(clause_1,theorem,
    [--big_p(a),
     ++big_p(X),
     ++big_p(c),
     ++big_p(Y)]).

input_clause(clause_2,theorem,
    [--big_p(c)]).

input_clause(clause_3,theorem,
    [--big_p(a),
     ++big_p(X),
     ++big_p(c),
     --big_p(d),
     ++big_p(b)]).

input_clause(clause_4,theorem,
    [--big_p(a),
     --big_p(b),
     ++big_p(c)]).

input_clause(clause_5,theorem,
    [++big_p(a)]).

input_clause(clause_6,theorem,
    [--big_p(e),
     ++big_p(b),
     --big_p(a),
     ++big_p(X),
     ++big_p(c)]).

input_clause(clause_7,theorem,
    [--big_p(e),
     ++big_p(b),
     --big_p(d)]).
%--------------------------------------------------------------------------
