%--------------------------------------------------------------------------
% File     : SYN058=FPell28-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Syntactic
% Problem  : Pelletier Problem 28
% Version  : 
% English  : 

% Refs     : Kalish D. and Montegue R. (1964), Logic: Techniques of Formal 
%            Reasoning, World, Harcourt and Brace, New York, NY.
%          : Pelletier F.J. (1986), Seventy-Five Problems for Testing 
%            Automatic Theorem Provers, Journal of Automated Reasoning 
%            2(2), 191-216.
%          : Pelletier F.J. (1988), Errata, Journal of Automated
%            Reasoning 4(2), 235-236.
% Source   : [Pelletier, 1986]
% Names    : Pelletier 28 [Pelletier, 1986]

% Status   : 
% Syntax   : Number of clauses           :    9 (   0 non-Horn)(   3 unit)
%            Number of literals          :   16 (   0 equality)
%            Number of predicate symbols :    6 (   0 propositional)
%            Number of function symbols  :    3 (   3 constant)
%            Number of variables         :    4 (   3 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    1

% Comments : This problem is incorrect in [Pelletier, 1986] and is
%            corrected in [Pelletier, 1988].
%--------------------------------------------------------------------------
input_clause(clause_1,axiom,
    [--big_p(X),
     ++big_q(Y)]).

input_clause(clause_2,axiom,
    [--big_q(b),
     ++big_q(c)]).

input_clause(clause_3,axiom,
    [--big_q(b),
     ++big_s(c)]).

input_clause(clause_4,axiom,
    [--big_r(b),
     ++big_q(c)]).

input_clause(clause_5,axiom,
    [--big_r(b),
     ++big_s(c)]).

input_clause(clause_6,axiom,
    [--big_s(Y),
     --big_f(X),
     ++big_g(X)]).

input_clause(clause_7,theorem,
    [++big_p(d)]).

input_clause(clause_8,theorem,
    [++big_f(d)]).

input_clause(clause_9,theorem,
    [--big_g(d)]).
%--------------------------------------------------------------------------
