%--------------------------------------------------------------------------
% File     : SYN056=FPell26-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Syntactic
% Problem  : Pelletier Problem 26
% Version  : 
% English  : 

% Refs     : Kalish D. and Montegue R. (1964), Logic: Techniques of Formal 
%            Reasoning, World, Harcourt and Brace, New York, NY.
%          : Pelletier F.J. (1986), Seventy-Five Problems for Testing 
%            Automatic Theorem Provers, Journal of Automated Reasoning 
%            2(2), 191-216.
% Source   : [Pelletier, 1986]
% Names    : Pelletier 26 [Pelletier, 1986]

% Status   : satisfiable
% Syntax   : Number of clauses           :   13 (   4 non-Horn)(   0 unit)
%            Number of literals          :   36 (   0 equality)
%            Number of predicate symbols :    4 (   0 propositional)
%            Number of function symbols  :    4 (   4 constant)
%            Number of variables         :   11 (   2 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    1

% Comments : 
%--------------------------------------------------------------------------
% skolem_functor(a).
% skolem_functor(b).
% skolem_functor(d).
% skolem_functor(c).

input_clause(clause_1,axiom,
    [--big_p(X),
     ++big_q(a)]).

input_clause(clause_2,axiom,
    [--big_q(X),
     ++big_p(b)]).

input_clause(clause_3,axiom,
    [--big_p(X),
     --big_q(Y),
     --big_r(X),
     ++big_s(Y)]).

input_clause(clause_4,axiom,
    [--big_p(X),
     --big_q(Y),
     --big_s(Y),
     ++big_r(X)]).

input_clause(clause_5,theorem,
    [--big_p(X),
     --big_q(X),
     ++big_r(X),
     ++big_s(X)]).

input_clause(clause_6,theorem,
    [--big_p(X),
     ++big_p(c),
     ++big_r(X)]).

input_clause(clause_7,theorem,
    [--big_p(X),
     --big_r(c),
     ++big_r(X)]).

input_clause(clause_8,theorem,
    [--big_q(X),
     ++big_q(d),
     ++big_s(X)]).

input_clause(clause_9,theorem,
    [--big_q(X),
     --big_s(d),
     ++big_s(X)]).

input_clause(clause_10,theorem,
    [++big_p(c),
     ++big_q(d)]).

input_clause(clause_11,theorem,
    [--big_r(c),
     ++big_q(d)]).

input_clause(clause_12,theorem,
    [--big_s(d),
     ++big_p(c)]).

input_clause(clause_13,theorem,
    [--big_r(c),
     --big_s(d)]).
%--------------------------------------------------------------------------
