%--------------------------------------------------------------------------
% File     : SYN055=FPell25-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Syntactic
% Problem  : Pelletier Problem 25
% Version  : 
% English  : 

% Refs     : Kalish D. and Montegue R. (1964), Logic: Techniques of Formal 
%            Reasoning, World, Harcourt and Brace, New York, NY.
%          : Pelletier F.J. (1986), Seventy-Five Problems for Testing 
%            Automatic Theorem Provers, Journal of Automated Reasoning 
%            2(2), 191-216.
% Source   : [Pelletier, 1986]
% Names    : Pelletier 25 [Pelletier, 1986]

% Status   : 
% Syntax   : Number of clauses           :    7 (   2 non-Horn)(   1 unit)
%            Number of literals          :   16 (   0 equality)
%            Number of predicate symbols :    5 (   0 propositional)
%            Number of function symbols  :    2 (   2 constant)
%            Number of variables         :    6 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    1

% Comments : 
%--------------------------------------------------------------------------
input_clause(clause_1,axiom,
    [++big_p(a)]).

input_clause(clause_2,axiom,
    [--big_f(X),
     --big_g(X),
     --big_r(X)]).

input_clause(clause_3,axiom,
    [--big_p(X),
     ++big_f(X)]).

input_clause(clause_4,axiom,
    [--big_p(X),
     ++big_g(X)]).

input_clause(clause_5,axiom,
    [--big_p(X),
     ++big_q(X),
     ++big_p(b)]).

input_clause(clause_6,theorem,
    [--big_p(X),
     ++big_q(X),
     ++big_r(b)]).

input_clause(clause_7,theorem,
    [--big_q(X),
     --big_p(X)]).
%--------------------------------------------------------------------------
