%--------------------------------------------------------------------------
% File     : SYN040=FPell01-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Syntactic
% Problem  : Pelletier Problem 1
% Version  : 
% English  : A biconditional version of the 'most difficult' theorem 
%            proved by the original Logic Theorist.

% Refs     : Newell A., Shaw J.C., Simon H. (1963), Empirical Explorations
%            with the Logic Theory Machine: A Case Study in Heuristics,
%            In Feigenbaum E., Feldman J. (Eds), Computers and Thought,
%            McGraw-Hill, New York, USA, 109-133.
%          : Pelletier F.J. (1986), Seventy-Five Problems for Testing 
%            Automatic Theorem Provers, Journal of Automated Reasoning 
%            2(2), 191-216.
% Source   : [Pelletier, 1986]
% Names    : Pelletier 1 [Pelletier, 1986]

% Status   : 
% Syntax   : Number of clauses           :    4 (   0 non-Horn)(   2 unit)
%            Number of literals          :    6 (   0 equality)
%            Number of predicate symbols :    2 (   2 propositional)
%            Number of function symbols  :    0 (   0 constant)
%            Number of variables         :    0 (   0 singleton)
%            Maximal clause size         :    2
%            Maximal term depth          :    0

% Comments : [Newell, Shaw & Simon, 1963] first appeared in 1957, as cited
%            in [Pelletier, 1986]. The 1963 version is a reprint.
%--------------------------------------------------------------------------
input_clause(clause_1,theorem,
    [--p,++q]).

input_clause(clause_2,theorem,
    [--q,++p]).

input_clause(clause_3,theorem,
    [--q]).

input_clause(clause_4,theorem,
    [++p]).
%--------------------------------------------------------------------------
