%--------------------------------------------------------------------------
% File     : SYN039=VLifsch-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Syntactic
% Problem  : A challenge to resolution programs
% Version  : 
% English  : 

% Refs     : Lifschitz V. (1989), What Is the Inverse Method?, Journal 
%            of Automated Reasoning 5(1), 1-24.
% Source   : [OTTER]
% Names    : lifsch.in [OTTER]

% Status   : 
% Syntax   : Number of clauses           :   27 (  11 non-Horn)(   0 unit)
%            Number of literals          :   81 (   0 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    1 (   0 constant)
%            Number of variables         :   84 (  21 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    2

% Comments : It is easily solved by Maslov's inverse method. "In 
%            a personal communication, Minc quotes one problem that was 
%            successfully solved by the program not later than 1968" 
%            [Lifchitz, 1989, p.14].
%--------------------------------------------------------------------------
% formula_list(sos).
% -(exists x exists x1 all y exists z exists z1
%      (  ( -p(y,y) | p(x,x)   | -s(z,x)  ) &
%         ( s(x,y)  | -s(y,z)  | q(z1,z1) ) &
%         ( q(x1,y) | -q(y,z1) | s(x1,x1) )  )).

input_clause(c_1,theorem,
    [++p(f1(X,X1),f1(X,X1)),
     --s(X,f1(X,X1)),
     --q(X1,f1(X,X1))]).

input_clause(c_2,theorem,
    [++p(f1(X,X1),f1(X,X1)),
     --s(X,f1(X,X1)),
     ++q(f1(X,X1),Z1)]).

input_clause(c_3,theorem,
    [++p(f1(X,X1),f1(X,X1)),
     --s(X,f1(X,X1)),
     --s(X1,X1)]).

input_clause(c_4,theorem,
    [++p(f1(X,X1),f1(X,X1)),
     ++s(f1(X,X1),Z),
     --q(X1,f1(X,X1))]).

input_clause(c_5,theorem,
    [++p(f1(X,X1),f1(X,X1)),
     ++s(f1(X,X1),Z),
     ++q(f1(X,X1),Z1)]).

input_clause(c_6,theorem,
    [++p(f1(X,X1),f1(X,X1)),
     ++s(f1(X,X1),Z),
     --s(X1,X1)]).

input_clause(c_7,theorem,
    [++p(f1(X,X1),f1(X,X1)),
     --q(Z1,Z1),
     --q(X1,f1(X,X1))]).

input_clause(c_8,theorem,
    [++p(f1(X,X1),f1(X,X1)),
     --q(Z1,Z1),
     ++q(f1(X,X1),Z1)]).

input_clause(c_9,theorem,
    [++p(f1(X,X1),f1(X,X1)),
     --q(Z1,Z1),
     --s(X1,X1)]).

input_clause(c_10,theorem,
    [--p(X,X),
     --s(X,f1(X,X1)),
     --q(X1,f1(X,X1))]).

input_clause(c_11,theorem,
    [--p(X,X),
     --s(X,f1(X,X1)),
     ++q(f1(X,X1),Z1)]).

input_clause(c_12,theorem,
    [--p(X,X),
     --s(X,f1(X,X1)),
     --s(X1,X1)]).

input_clause(c_13,theorem,
    [--p(X,X),
     ++s(f1(X,X1),Z),
     --q(X1,f1(X,X1))]).

input_clause(c_14,theorem,
    [--p(X,X),
     ++s(f1(X,X1),Z),
     ++q(f1(X,X1),Z1)]).

input_clause(c_15,theorem,
    [--p(X,X),
     ++s(f1(X,X1),Z),
     --s(X1,X1)]).

input_clause(c_16,theorem,
    [--p(X,X),
     --q(Z1,Z1),
     --q(X1,f1(X,X1))]).

input_clause(c_17,theorem,
    [--p(X,X),
     --q(Z1,Z1),
     ++q(f1(X,X1),Z1)]).

input_clause(c_18,theorem,
    [--p(X,X),
     --q(Z1,Z1),
     --s(X1,X1)]).

input_clause(c_19,theorem,
    [++s(Z,X),
     --s(X,f1(X,X1)),
     --q(X1,f1(X,X1))]).

input_clause(c_20,theorem,
    [++s(Z,X),
     --s(X,f1(X,X1)),
     ++q(f1(X,X1),Z1)]).

input_clause(c_21,theorem,
    [++s(Z,X),
     --s(X,f1(X,X1)),
     --s(X1,X1)]).

input_clause(c_22,theorem,
    [++s(Z,X),
     ++s(f1(X,X1),Z),
     --q(X1,f1(X,X1))]).

input_clause(c_23,theorem,
    [++s(Z,X),
     ++s(f1(X,X1),Z),
     ++q(f1(X,X1),Z1)]).

input_clause(c_24,theorem,
    [++s(Z,X),
     ++s(f1(X,X1),Z),
     --s(X1,X1)]).

input_clause(c_25,theorem,
    [++s(Z,X),
     --q(Z1,Z1),
     --q(X1,f1(X,X1))]).

input_clause(c_26,theorem,
    [++s(Z,X),
     --q(Z1,Z1),
     ++q(f1(X,X1),Z1)]).

input_clause(c_27,theorem,
    [++s(Z,X),
     --q(Z1,Z1),
     --s(X1,X1)]).
%--------------------------------------------------------------------------
