%--------------------------------------------------------------------------
% File     : SYN038=SFleisig4-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Syntactic
% Problem  : Syntactic formula
% Version  : 
% English  : Exists X, Exists Y, All Z (((p(X,Y) -> (p(X,Z) <-> q(Y,Z))) 
%            & (p(X,Y) <-> (p(Z,Z) -> q(Z,Z)))) -> (q(Z,Y) <-> q(Z,Z)))

% Refs     : Friedman J. (1963), A Semi-Decision Procedure for the 
%            Functional Calculus, In Journal of the ACM 10(1), ACM Press, 
%            New York, NY, 1-24.
%          : Fleisig S., Loveland D.W., Smiley A.K., and Yarmush D.L. 
%            (1974), An Implementation of the Model Elimination Proof 
%            Procedure, In Journal of the ACM 21(1), ACM Press, New York, 
%            NY, 124-139.
%          : Wilson G.A. and Minker J. (1976), Resolution, Refinements, 
%            and Search Strategies: A Comparative Study, IEEE Transactions 
%            on Computers C-25(8), 782-801.
% Source   : [SPRFN]
% Names    : Example 4 [Fleisig, et al., 1974]
%          : EX4-T? [Wilson & Minker, 1976]
%          : ex4.lop [SETHEO]
%          : FEX4T1 [SPRFN]
%          : FEX4T2 [SPRFN]

% Status   : 
% Syntax   : Number of clauses           :    7 (   2 non-Horn)(   0 unit)
%            Number of literals          :   17 (   0 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    1 (   0 constant)
%            Number of variables         :   14 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
input_clause(clause_1,theorem,
    [--p(X,f(X,Y)),
     --p(X,Y),
     ++q(Y,f(X,Y))]).

input_clause(clause_2,theorem,
    [--p(X,Y),
     --q(Y,f(X,Y)),
     ++p(X,f(X,Y))]).

input_clause(clause_3,theorem,
    [--p(X,Y),
     --p(f(X,Y),f(X,Y)),
     ++q(f(X,Y),f(X,Y))]).

input_clause(clause_4,theorem,
    [++p(X,Y),
     ++p(f(X,Y),f(X,Y))]).

input_clause(clause_5,theorem,
    [++p(X,Y),
     --q(f(X,Y),f(X,Y))]).

input_clause(clause_6,theorem,
    [++q(X,Y),
     ++q(f(X,Y),f(X,Y))]).

input_clause(clause_7,theorem,
    [--q(X,Y),
     --q(f(X,Y),f(X,Y))]).
%--------------------------------------------------------------------------
