%--------------------------------------------------------------------------
% File     : SYN037=PAndrews2-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Syntactic
% Problem  : Andrews Challenge Problem Variant
% Version  : Theorem formulation : Different clausal form.
% English  : 

% Refs     : De Champeaux D. (1979), Sub-problem Finder and Instance 
%            Checker: Two Co-operating Preprocessors for Theorem Provers, 
%            Proceedings of the 6th International Joint Conference 
%            on Artificial Intelligence, 191-196.
%          : Pelletier F.J. (1986), Seventy-Five Problems for Testing 
%            Automatic Theorem Provers, Journal of Automated Reasoning 
%            2(2), 191-216.
%          : Angshuman G., Zhang H. (1989), Andrews' Challenge Problem: 
%            Clause Conversion and Solutions, AAR Newsletter 14, 5-8.
%          : Quaife A. (1990), Andrews' Challenge Problem Revisited, AAR 
%            Newsletter 15, 3-7.
% Source   : [Quaife, 1990]
% Names    : Theorem P [Quaife, 1990]

% Status   : 
% Syntax   : Number of clauses           :   22 (  13 non-Horn)(   0 unit)
%            Number of literals          :   78 (   0 equality)
%            Number of predicate symbols :    5 (   3 propositional)
%            Number of function symbols  :   10 (   6 constant)
%            Number of variables         :   20 (  12 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
input_clause(clause_1,theorem,
    [--m1,
     --m3,
     --p(X1),
     --p(fy(X1))]).

input_clause(clause_2,theorem,
    [--m1,
     --m3,
     ++p(X1),
     ++p(fy(X1))]).

input_clause(clause_3,theorem,
    [--m1,
     --p(cx),
     ++m3,
     ++p(Y4)]).

input_clause(clause_4,theorem,
    [--m1,
     --p(Y5),
     ++m3,
     ++p(cx)]).

input_clause(clause_5,theorem,
    [--m2,
     --m3,
     --q(cw),
     ++q(Z1)]).

input_clause(clause_6,theorem,
    [--m2,
     --m3,
     --q(Z),
     ++q(cw)]).

input_clause(clause_7,theorem,
    [--m2,
     --q(W2),
     --q(fz5(W2)),
     ++m3]).

input_clause(clause_8,theorem,
    [--m2,
     ++m3,
     ++q(W2),
     ++q(fz5(W2))]).

input_clause(clause_9,theorem,
    [--m3,
     --p(cx),
     ++m1,
     ++p(Y1)]).

input_clause(clause_10,theorem,
    [--m3,
     --p(Y2),
     ++m1,
     ++p(cx)]).

input_clause(clause_11,theorem,
    [--m3,
     --q(W1),
     --q(fz2(W1)),
     ++m2]).

input_clause(clause_12,theorem,
    [--m3,
     ++m2,
     ++q(W1),
     ++q(fz2(W1))]).

input_clause(clause_13,theorem,
    [--p(X2),
     --p(fy3(X2)),
     ++m1,
     ++m3]).

input_clause(clause_14,theorem,
    [--q(cw),
     ++m2,
     ++m3,
     ++q(Z4)]).

input_clause(clause_15,theorem,
    [--q(Z3),
     ++m2,
     ++m3,
     ++q(cw)]).

input_clause(clause_16,theorem,
    [++m1,
     ++m3,
     ++p(X2),
     ++p(fy3(X2))]).

input_clause(clause_17,theorem,
    [--m1,
     --q(U1),
     ++q(Uu1)]).

input_clause(clause_18,theorem,
    [--m2,
     --p(V1),
     ++p(Vv1)]).

input_clause(clause_19,theorem,
    [--p(cvv),
     ++m2]).

input_clause(clause_20,theorem,
    [--q(cuu),
     ++m1]).

input_clause(clause_21,theorem,
    [++m2,
     ++p(cv)]).

input_clause(clause_22,theorem,
    [++m1,
     ++q(cu)]).
%--------------------------------------------------------------------------
