%--------------------------------------------------------------------------
% File     : SYN036=PAndrews-3 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Syntactic
% Problem  : Andrews Challenge Problem
% Version  : Theorem formulation : Different clausal form.
% English  : 

% Refs     : De Champeaux D. (1979), Sub-problem Finder and Instance 
%            Checker: Two Co-operating Preprocessors for Theorem Provers, 
%            Proceedings of the 6th International Joint Conference 
%            on Artificial Intelligence, 191-196.
%          : Pelletier F.J. (1986), Seventy-Five Problems for Testing 
%            Automatic Theorem Provers, Journal of Automated Reasoning 
%            2(2), 191-216.
%          : Angshuman G., Zhang H. (1989), Andrews' Challenge Problem: 
%            Clause Conversion and Solutions, AAR Newsletter 14, 5-8.
% Source   : [Angshuman & Zhang, 1989]
% Names    : Problem 9 [Angshuman & Zhang, 1989]

% Status   : 
% Syntax   : Number of clauses           :   36 (  11 non-Horn)(   0 unit)
%            Number of literals          :  104 (   0 equality)
%            Number of predicate symbols :   12 (   8 propositional)
%            Number of function symbols  :    8 (   6 constant)
%            Number of variables         :   18 (  10 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
input_clause(clause_1,theorem,
    [--n2,
     --n9,
     --n6,
     --n10]).

input_clause(clause_2,theorem,
    [--n2,
     --n9,
     ++n6,
     ++n10]).

input_clause(clause_3,theorem,
    [++n2,
     ++n9,
     --n6,
     --n10]).

input_clause(clause_4,theorem,
    [++n2,
     ++n9,
     ++n6,
     ++n10]).

input_clause(clause_5,theorem,
    [--n2,
     ++n9,
     --n6,
     ++n10]).

input_clause(clause_6,theorem,
    [--n2,
     ++n9,
     ++n6,
     --n10]).

input_clause(clause_7,theorem,
    [++n2,
     --n9,
     --n6,
     ++n10]).

input_clause(clause_8,theorem,
    [++n2,
     --n9,
     ++n6,
     --n10]).

input_clause(clause_9,theorem,
    [--p(s8),
     ++n8]).

input_clause(clause_10,theorem,
    [--n8,
     ++p(X8)]).

input_clause(clause_11,theorem,
    [--p(X7),
     ++n7]).

input_clause(clause_12,theorem,
    [--n7,
     ++p(s7)]).

input_clause(clause_13,theorem,
    [--n5(X6),
     ++n6]).

input_clause(clause_14,theorem,
    [--n6,
     ++n5(s6)]).

input_clause(clause_15,theorem,
    [--q(X),
     --q(s5(X)),
     ++n5(X)]).

input_clause(clause_16,theorem,
    [++q(X),
     ++q(s5(X)),
     ++n5(X)]).

input_clause(clause_17,theorem,
    [--n5(X),
     --q(X),
     ++q(X5)]).

input_clause(clause_18,theorem,
    [--n5(X),
     ++q(X),
     --q(X5)]).

input_clause(clause_19,theorem,
    [--q(s4),
     ++n4]).

input_clause(clause_20,theorem,
    [--n4,
     ++q(X4)]).

input_clause(clause_21,theorem,
    [--q(X3),
     ++n3]).

input_clause(clause_22,theorem,
    [--n3,
     ++q(s3)]).

input_clause(clause_23,theorem,
    [--n1(X2),
     ++n2]).

input_clause(clause_24,theorem,
    [--n2,
     ++n1(s2)]).

input_clause(clause_25,theorem,
    [--p(X),
     --p(s1(X)),
     ++n1(X)]).

input_clause(clause_26,theorem,
    [++p(X),
     ++p(s1(X)),
     ++n1(X)]).

input_clause(clause_27,theorem,
    [--n1(X),
     --p(X),
     ++p(X1)]).

input_clause(clause_28,theorem,
    [--n1(X),
     ++p(X),
     --p(X1)]).

input_clause(clause_29,theorem,
    [--n3,
     --n4,
     ++n9]).

input_clause(clause_30,theorem,
    [++n3,
     ++n4,
     ++n9]).

input_clause(clause_31,theorem,
    [--n3,
     ++n4,
     --n9]).

input_clause(clause_32,theorem,
    [++n3,
     --n4,
     --n9]).

input_clause(clause_33,theorem,
    [--n7,
     --n8,
     ++n10]).

input_clause(clause_34,theorem,
    [++n7,
     ++n8,
     ++n10]).

input_clause(clause_35,theorem,
    [--n7,
     ++n8,
     --n10]).

input_clause(clause_36,theorem,
    [++n7,
     --n8,
     --n10]).
%--------------------------------------------------------------------------
