%--------------------------------------------------------------------------
% File     : SYN015=Quant3-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Syntactic
% Problem  : A problem in quantification theory
% Version  : [Wang, 1965] axioms.
% English  : 

% Refs     : Wang H. (1965), Formalization & Automatic Theorem Proving, 
%            Proceedings of the IFIP Congress 1965, 51-58.
%          : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [McCharen, et al., 1976]
% Names    : ExQ3 [Wang, 1965]
%          : EXQ3 [McCharen, et al., 1976]
%          : exq3.ver1.in [ANL]
%          : exq3.ver2.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   23 (  13 non-Horn)(   2 unit)
%            Number of literals          :   69 (  42 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    6 (   4 constant)
%            Number of variables         :   33 (   0 singleton)
%            Maximal clause size         :    6
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
input_clause(c_1,theorem,
    [--equal(m,n)]).

input_clause(c_2,theorem,
    [++equal(Y,j),
     --equal(Y,k),
     ++element(Y,j)]).

input_clause(c_3,theorem,
    [++equal(Y,j),
     ++equal(Y,k),
     --element(Y,j)]).

input_clause(c_4,theorem,
    [++equal(Y,m),
     --element(Y,m),
     --equal(f(Y),m)]).

input_clause(c_5,theorem,
    [++equal(Y,m),
     --element(Y,m),
     --equal(f(Y),Y)]).

input_clause(c_6,theorem,
    [++equal(Y,m),
     --element(Y,m),
     ++element(Y,f(Y))]).

input_clause(c_7,theorem,
    [++equal(Y,m),
     --element(Y,m),
     ++element(f(Y),Y)]).

input_clause(c_8,theorem,
    [++equal(Y,m),
     ++element(Y,m),
     ++equal(V1,m),
     ++equal(V1,Y),
     --element(Y,V1),
     --element(V1,Y)]).

input_clause(c_9,theorem,
    [++equal(Y,n),
     ++element(Y,n),
     --equal(g(Y),n)]).

input_clause(c_10,theorem,
    [++equal(Y,n),
     ++element(Y,n),
     --equal(g(Y),Y)]).

input_clause(c_11,theorem,
    [++equal(Y,n),
     ++element(Y,n),
     ++element(Y,g(Y))]).

input_clause(c_12,theorem,
    [++equal(Y,n),
     ++element(Y,n),
     ++element(g(Y),Y)]).

input_clause(c_13,theorem,
    [++equal(Y,n),
     --element(Y,n),
     ++equal(V,n),
     ++equal(V,Y),
     --element(Y,V),
     --element(V,Y)]).

input_clause(c_14,theorem,
    [++equal(Y,k),
     --equal(Y,m),
     ++element(Y,k)]).

input_clause(c_15,theorem,
    [++equal(Y,k),
     --equal(Y,n),
     ++element(Y,k)]).

input_clause(c_16,theorem,
    [++equal(Y,k),
     ++equal(Y,m),
     ++equal(Y,n),
     --element(Y,k)]).

input_clause(p_substitution1,axiom,
    [--equal(X,Y),
     --element(X,Z),
     ++element(Y,Z)]).

input_clause(p_substitution2,axiom,
    [--equal(X,Y),
     --element(Z,X),
     ++element(Z,Y)]).

input_clause(f_substitution1,axiom,
    [--equal(X,Y),
     ++equal(f(X),f(Y))]).

input_clause(g_substitution1,axiom,
    [--equal(X,Y),
     ++equal(g(X),g(Y))]).
%--------------------------------------------------------------------------
