%--------------------------------------------------------------------------
% File     : SYN014=Quant2-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Syntactic
% Problem  : A problem in quantification theory
% Version  : [Wang, 1965] axioms : Reduced & Augmented > Incomplete.
%            Theorem formulation : Modified.
% English  : 

% Refs     : Wos L.A. (1965), Unpublished notes, Argonne National 
%            Laboratory.
%          : Wang H. (1965), Formalization & Automatic Theorem Proving, 
%            Proceedings of the IFIP Congress 1965, 51-58.
%          : Wilson G.A. and Minker J. (1976), Resolution, Refinements, 
%            and Search Strategies: A Comparative Study, IEEE Transactions 
%            on Computers C-25(8), 782-801.
% Source   : [SPRFN]
% Names    : Problem 32 [Wos, 1965]
%          : wos32 [Wilson & Minker, 1976]

% Status   : 
% Syntax   : Number of clauses           :   26 (  13 non-Horn)(   7 unit)
%            Number of literals          :   70 (  43 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    6 (   4 constant)
%            Number of variables         :   29 (   0 singleton)
%            Maximal clause size         :    6
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
input_clause(element_substitution1,axiom,
    [--equal(A,B),
     --element(C,A),
     ++element(C,B)]).

input_clause(element_substitution2,axiom,
    [--element(A,B),
     --equal(A,C),
     ++element(C,B)]).

input_clause(c_3,theorem,
    [--element(A,a),
     ++equal(A,k),
     ++equal(A,a)]).

input_clause(c_4,theorem,
    [--equal(A,k),
     ++element(A,a),
     ++equal(A,a)]).

input_clause(c_5,theorem,
    [--equal(f(A),m),
     --element(A,m),
     ++equal(A,m)]).

input_clause(c_6,theorem,
    [--equal(f(A),A),
     --element(A,m),
     ++equal(A,m)]).

input_clause(c_7,theorem,
    [++element(A,f(A)),
     --element(A,m),
     ++equal(A,m)]).

input_clause(c_8,theorem,
    [++element(f(A),A),
     --element(A,m),
     ++equal(A,m)]).

input_clause(c_9,theorem,
    [--element(A,B),
     --element(B,A),
     ++equal(A,B),
     ++equal(A,m),
     ++element(B,m),
     ++equal(B,m)]).

input_clause(c_10,theorem,
    [--equal(g(A),n),
     ++element(A,n),
     ++equal(A,n)]).

input_clause(c_11,theorem,
    [--equal(g(A),A),
     ++element(A,n),
     ++equal(A,n)]).

input_clause(c_12,theorem,
    [++element(A,g(A)),
     ++element(A,n),
     ++equal(A,n)]).

input_clause(c_13,theorem,
    [++element(g(A),A),
     ++element(A,n),
     ++equal(A,n)]).

input_clause(c_14,theorem,
    [--element(A,B),
     --element(B,A),
     ++equal(A,B),
     ++equal(A,n),
     --element(B,n),
     ++equal(B,n)]).

input_clause(c_15,theorem,
    [--equal(A,m),
     ++element(A,k),
     ++equal(A,k)]).

input_clause(c_16,theorem,
    [--equal(A,n),
     ++element(A,k),
     ++equal(A,k)]).

input_clause(c_17,theorem,
    [--element(A,k),
     ++equal(A,n),
     ++equal(A,m),
     ++equal(A,k)]).

input_clause(c_18,theorem,
    [--equal(n,a)]).

input_clause(c_19,theorem,
    [--equal(m,n)]).

%----This is the only difference from wos33 - SYN015-1.p 
input_clause(c_20,theorem,
    [++equal(n,k)]).

input_clause(c_21,theorem,
    [--equal(m,a)]).

input_clause(c_22,theorem,
    [--equal(k,a)]).

input_clause(c_23,theorem,
    [++equal(m,k)]).
%--------------------------------------------------------------------------
