%--------------------------------------------------------------------------
% File     : SYN012=ModelElim-1 : TPTP v1.1.1. Bugfixed v1.1.0.
% Domain   : Syntactic
% Problem  : A problem to demonstrate Model Elimination
% Version  : 
% English  : 

% Refs     : Loveland D.W. (1968), Mechanical Theorem-Proving by Model 
%            Elimination, Journal of the ACM 15(2), 236-251.
% Source   : [Loveland, 1968]
% Names    : Example [Loveland, 1968]

% Status   : 
% Syntax   : Number of clauses           :    7 (   2 non-Horn)(   0 unit)
%            Number of literals          :   17 (   0 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    1 (   0 constant)
%            Number of variables         :   14 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----exists(X,exists(Y,forall(Z,((bf(X,Y) -> (bf(X,Z) <-> bg(Y,Z))) 
%----& (bf(X,Y) <-> (bf(Z,Z) -> bg(Z,Z)))) -> (bg(Z,Y) <-> bg(Z,Z))))) 
input_clause(clause_1,theorem,
    [--big_f(X,Y),
     --big_f(X,g(X,Y)),
     ++big_g(Y,g(X,Y))]).

input_clause(clause_2,theorem,
    [--big_f(X,Y),
     ++big_f(X,g(X,Y)),
     --big_g(Y,g(X,Y))]).

input_clause(clause_3,theorem,
    [--big_f(X,Y),
     --big_f(g(X,Y),g(X,Y)),
     ++big_g(g(X,Y),g(X,Y))]).

input_clause(clause_4,theorem,
    [++big_f(X,Y),
     ++big_f(g(X,Y),g(X,Y))]).

input_clause(clause_5,theorem,
    [++big_f(X,Y),
     --big_g(g(X,Y),g(X,Y))]).

input_clause(clause_6,theorem,
    [++big_g(X,Y),
     ++big_g(g(X,Y),g(X,Y))]).

input_clause(clause_7,theorem,
    [--big_g(X,Y),
     --big_g(g(X,Y),g(X,Y))]).
%--------------------------------------------------------------------------
