%--------------------------------------------------------------------------
% File     : SYN007=FPell71-1.007 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Syntactic
% Problem  : Pelletier Problem 71
% Version  : Theorem formulation : For N = 7.
% English  : Clausal forms of statements of the form :
%            (p1 <-> (p2 <->...(pN <-> (p1 <-> (p2 <->...<-> pN)...)

% Refs     : Urquhart A. (1987), Hard Examples for Resolution, Journal
%            of the ACM 34(1), 209-219.
%          : Pelletier F.J. (1986), Seventy-Five Problems for Testing 
%            Automatic Theorem Provers, Journal of Automated Reasoning
%            2(2), 191-216.
% Source   : [Pelletier, 1986]
% Names    : Pelletier 71 [Pelletier, 1986]

% Status   : 
% Syntax   : Number of clauses           : 8192 (8184 non-Horn)(   0 unit)
%            Number of literals          : 86014 (   0 equality)
%            Number of predicate symbols :    7 (   7 propositional)
%            Number of function symbols  :    0 (   0 constant)
%            Number of variables         :    0 (   0 singleton)
%            Maximal clause size         :   13
%            Maximal term depth          :    0

% Comments : The number of distinct letters in U-N is N. The number of
%            occurrences of sentence letters in 2N. The number of
%            clauses goes up dramatically as N increases, but I don't
%            think it shows that the problems are dramatically more
%            difficult as N increases. Rather, it's that the awkward 
%            clause form representation comes to the fore most
%            dramatically with embedded biconditionals. On all other
%            measures of complexity, one should say that the problems
%            increase linearly in difficulty. Urquhart says that the
%            proof size of any resolution system increases
%            exponentially with increase in N.
%          : This problem can also be done in terms of graphs,
%            as described in Pelletier Problem 74.
%--------------------------------------------------------------------------
input_clause(c_1,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,--p1,++p7]).

input_clause(c_2,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,--p1,++p6]).

input_clause(c_3,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,--p1,++p5,++p6,++p7]).

input_clause(c_4,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,--p1,++p5]).

input_clause(c_5,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,--p1,++p4,++p5,++p7]).

input_clause(c_6,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,--p1,++p4,++p5,++p6]).

input_clause(c_7,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,--p1,++p4,++p6,++p7]).

input_clause(c_8,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,--p1,++p4]).

input_clause(c_9,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,--p1,++p3,++p4,++p7]).

input_clause(c_10,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,--p1,++p3,++p4,++p6]).

input_clause(c_11,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,--p1,++p3,++p4,++p5,++p6,++p7]).

input_clause(c_12,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,--p1,++p3,++p4,++p5]).

input_clause(c_13,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,--p1,++p3,++p5,++p7]).

input_clause(c_14,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,--p1,++p3,++p5,++p6]).

input_clause(c_15,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,--p1,++p3,++p6,++p7]).

input_clause(c_16,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,--p1,++p3]).

input_clause(c_17,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,--p1,++p2,++p3,++p7]).

input_clause(c_18,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,--p1,++p2,++p3,++p6]).

input_clause(c_19,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,--p1,++p2,++p3,++p5,++p6,++p7]).

input_clause(c_20,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,--p1,++p2,++p3,++p5]).

input_clause(c_21,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,--p1,++p2,++p3,++p4,++p5,++p7]).

input_clause(c_22,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,--p1,++p2,++p3,++p4,++p5,++p6]).

input_clause(c_23,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,--p1,++p2,++p3,++p4,++p6,++p7]).

input_clause(c_24,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,--p1,++p2,++p3,++p4]).

input_clause(c_25,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,--p1,++p2,++p4,++p7]).

input_clause(c_26,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,--p1,++p2,++p4,++p6]).

input_clause(c_27,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,--p1,++p2,++p4,++p5,++p6,++p7]).

input_clause(c_28,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,--p1,++p2,++p4,++p5]).

input_clause(c_29,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,--p1,++p2,++p5,++p7]).

input_clause(c_30,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,--p1,++p2,++p5,++p6]).

input_clause(c_31,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,--p1,++p2,++p6,++p7]).

input_clause(c_32,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,--p1,++p2]).

input_clause(c_33,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,++p2,++p7]).

input_clause(c_34,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,++p2,++p6]).

input_clause(c_35,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,++p2,++p5,++p6,++p7]).

input_clause(c_36,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,++p2,++p5]).

input_clause(c_37,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,++p2,++p4,++p5,++p7]).

input_clause(c_38,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,++p2,++p4,++p5,++p6]).

input_clause(c_39,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,++p2,++p4,++p6,++p7]).

input_clause(c_40,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,++p2,++p4]).

input_clause(c_41,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,++p2,++p3,++p4,++p7]).

input_clause(c_42,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,++p2,++p3,++p4,++p6]).

input_clause(c_43,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,++p2,++p3,++p4,++p5,++p6,++p7]).

input_clause(c_44,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,++p2,++p3,++p4,++p5]).

input_clause(c_45,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,++p2,++p3,++p5,++p7]).

input_clause(c_46,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,++p2,++p3,++p5,++p6]).

input_clause(c_47,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,++p2,++p3,++p6,++p7]).

input_clause(c_48,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,++p2,++p3]).

input_clause(c_49,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,++p3,++p7]).

input_clause(c_50,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,++p3,++p6]).

input_clause(c_51,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,++p3,++p5,++p6,++p7]).

input_clause(c_52,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,++p3,++p5]).

input_clause(c_53,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,++p3,++p4,++p5,++p7]).

input_clause(c_54,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,++p3,++p4,++p5,++p6]).

input_clause(c_55,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,++p3,++p4,++p6,++p7]).

input_clause(c_56,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,++p3,++p4]).

input_clause(c_57,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,++p4,++p7]).

input_clause(c_58,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,++p4,++p6]).

input_clause(c_59,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,++p4,++p5,++p6,++p7]).

input_clause(c_60,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,++p4,++p5]).

input_clause(c_61,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,++p5,++p7]).

input_clause(c_62,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,++p5,++p6]).

input_clause(c_63,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7,++p6,++p7]).

input_clause(c_64,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p7]).

input_clause(c_65,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7]).

input_clause(c_66,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,++p6,--p7]).

input_clause(c_67,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,++p5,++p6]).

input_clause(c_68,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,++p5,--p7]).

input_clause(c_69,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,++p4,++p5]).

input_clause(c_70,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,++p4,++p5,++p6,--p7]).

input_clause(c_71,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,++p4,++p6]).

input_clause(c_72,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,++p4,--p7]).

input_clause(c_73,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,++p3,++p4]).

input_clause(c_74,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,++p3,++p4,++p6,--p7]).

input_clause(c_75,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,++p3,++p4,++p5,++p6]).

input_clause(c_76,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,++p3,++p4,++p5,--p7]).

input_clause(c_77,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,++p3,++p5]).

input_clause(c_78,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,++p3,++p5,++p6,--p7]).

input_clause(c_79,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,++p3,++p6]).

input_clause(c_80,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,++p3,--p7]).

input_clause(c_81,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,++p2,++p3]).

input_clause(c_82,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,++p2,++p3,++p6,--p7]).

input_clause(c_83,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,++p2,++p3,++p5,++p6]).

input_clause(c_84,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,++p2,++p3,++p5,--p7]).

input_clause(c_85,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,++p2,++p3,++p4,++p5]).

input_clause(c_86,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,++p2,++p3,++p4,++p5,++p6,--p7]).

input_clause(c_87,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,++p2,++p3,++p4,++p6]).

input_clause(c_88,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,++p2,++p3,++p4,--p7]).

input_clause(c_89,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,++p2,++p4]).

input_clause(c_90,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,++p2,++p4,++p6,--p7]).

input_clause(c_91,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,++p2,++p4,++p5,++p6]).

input_clause(c_92,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,++p2,++p4,++p5,--p7]).

input_clause(c_93,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,++p2,++p5]).

input_clause(c_94,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,++p2,++p5,++p6,--p7]).

input_clause(c_95,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,++p2,++p6]).

input_clause(c_96,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,++p2,--p7]).

input_clause(c_97,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,--p1,++p2]).

input_clause(c_98,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,--p1,++p2,++p6,--p7]).

input_clause(c_99,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,--p1,++p2,++p5,++p6]).

input_clause(c_100,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,--p1,++p2,++p5,--p7]).

input_clause(c_101,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,--p1,++p2,++p4,++p5]).

input_clause(c_102,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,--p1,++p2,++p4,++p5,++p6,--p7]).

input_clause(c_103,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,--p1,++p2,++p4,++p6]).

input_clause(c_104,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,--p1,++p2,++p4,--p7]).

input_clause(c_105,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,--p1,++p2,++p3,++p4]).

input_clause(c_106,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,--p1,++p2,++p3,++p4,++p6,--p7]).

input_clause(c_107,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,--p1,++p2,++p3,++p4,++p5,++p6]).

input_clause(c_108,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,--p1,++p2,++p3,++p4,++p5,--p7]).

input_clause(c_109,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,--p1,++p2,++p3,++p5]).

input_clause(c_110,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,--p1,++p2,++p3,++p5,++p6,--p7]).

input_clause(c_111,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,--p1,++p2,++p3,++p6]).

input_clause(c_112,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,--p1,++p2,++p3,--p7]).

input_clause(c_113,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,--p1,++p3]).

input_clause(c_114,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,--p1,++p3,++p6,--p7]).

input_clause(c_115,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,--p1,++p3,++p5,++p6]).

input_clause(c_116,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,--p1,++p3,++p5,--p7]).

input_clause(c_117,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,--p1,++p3,++p4,++p5]).

input_clause(c_118,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,--p1,++p3,++p4,++p5,++p6,--p7]).

input_clause(c_119,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,--p1,++p3,++p4,++p6]).

input_clause(c_120,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,--p1,++p3,++p4,--p7]).

input_clause(c_121,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,--p1,++p4]).

input_clause(c_122,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,--p1,++p4,++p6,--p7]).

input_clause(c_123,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,--p1,++p4,++p5,++p6]).

input_clause(c_124,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,--p1,++p4,++p5,--p7]).

input_clause(c_125,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,--p1,++p5]).

input_clause(c_126,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,--p1,++p5,++p6,--p7]).

input_clause(c_127,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,--p1,++p6]).

input_clause(c_128,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p7,--p1,--p7]).

input_clause(c_129,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,--p1,--p6]).

input_clause(c_130,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,--p1,--p7]).

input_clause(c_131,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,--p1,++p5]).

input_clause(c_132,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,--p1,++p5,--p6,--p7]).

input_clause(c_133,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,--p1,++p4,++p5,--p6]).

input_clause(c_134,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,--p1,++p4,++p5,--p7]).

input_clause(c_135,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,--p1,++p4]).

input_clause(c_136,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,--p1,++p4,--p6,--p7]).

input_clause(c_137,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,--p1,++p3,++p4,--p6]).

input_clause(c_138,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,--p1,++p3,++p4,--p7]).

input_clause(c_139,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,--p1,++p3,++p4,++p5]).

input_clause(c_140,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,--p1,++p3,++p4,++p5,--p6,--p7]).

input_clause(c_141,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,--p1,++p3,++p5,--p6]).

input_clause(c_142,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,--p1,++p3,++p5,--p7]).

input_clause(c_143,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,--p1,++p3]).

input_clause(c_144,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,--p1,++p3,--p6,--p7]).

input_clause(c_145,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,--p1,++p2,++p3,--p6]).

input_clause(c_146,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,--p1,++p2,++p3,--p7]).

input_clause(c_147,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,--p1,++p2,++p3,++p5]).

input_clause(c_148,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,--p1,++p2,++p3,++p5,--p6,--p7]).

input_clause(c_149,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,--p1,++p2,++p3,++p4,++p5,--p6]).

input_clause(c_150,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,--p1,++p2,++p3,++p4,++p5,--p7]).

input_clause(c_151,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,--p1,++p2,++p3,++p4]).

input_clause(c_152,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,--p1,++p2,++p3,++p4,--p6,--p7]).

input_clause(c_153,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,--p1,++p2,++p4,--p6]).

input_clause(c_154,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,--p1,++p2,++p4,--p7]).

input_clause(c_155,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,--p1,++p2,++p4,++p5]).

input_clause(c_156,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,--p1,++p2,++p4,++p5,--p6,--p7]).

input_clause(c_157,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,--p1,++p2,++p5,--p6]).

input_clause(c_158,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,--p1,++p2,++p5,--p7]).

input_clause(c_159,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,--p1,++p2]).

input_clause(c_160,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,--p1,++p2,--p6,--p7]).

input_clause(c_161,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,++p2,--p6]).

input_clause(c_162,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,++p2,--p7]).

input_clause(c_163,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,++p2,++p5]).

input_clause(c_164,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,++p2,++p5,--p6,--p7]).

input_clause(c_165,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,++p2,++p4,++p5,--p6]).

input_clause(c_166,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,++p2,++p4,++p5,--p7]).

input_clause(c_167,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,++p2,++p4]).

input_clause(c_168,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,++p2,++p4,--p6,--p7]).

input_clause(c_169,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,++p2,++p3,++p4,--p6]).

input_clause(c_170,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,++p2,++p3,++p4,--p7]).

input_clause(c_171,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,++p2,++p3,++p4,++p5]).

input_clause(c_172,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,++p2,++p3,++p4,++p5,--p6,--p7]).

input_clause(c_173,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,++p2,++p3,++p5,--p6]).

input_clause(c_174,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,++p2,++p3,++p5,--p7]).

input_clause(c_175,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,++p2,++p3]).

input_clause(c_176,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,++p2,++p3,--p6,--p7]).

input_clause(c_177,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,++p3,--p6]).

input_clause(c_178,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,++p3,--p7]).

input_clause(c_179,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,++p3,++p5]).

input_clause(c_180,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,++p3,++p5,--p6,--p7]).

input_clause(c_181,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,++p3,++p4,++p5,--p6]).

input_clause(c_182,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,++p3,++p4,++p5,--p7]).

input_clause(c_183,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,++p3,++p4]).

input_clause(c_184,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,++p3,++p4,--p6,--p7]).

input_clause(c_185,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,++p4,--p6]).

input_clause(c_186,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,++p4,--p7]).

input_clause(c_187,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,++p4,++p5]).

input_clause(c_188,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,++p4,++p5,--p6,--p7]).

input_clause(c_189,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,++p5,--p6]).

input_clause(c_190,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,++p5,--p7]).

input_clause(c_191,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7]).

input_clause(c_192,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p7,--p6,--p7]).

input_clause(c_193,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,--p6,++p7]).

input_clause(c_194,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7]).

input_clause(c_195,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,++p5,++p7]).

input_clause(c_196,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,++p5,--p6]).

input_clause(c_197,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,++p4,++p5,--p6,++p7]).

input_clause(c_198,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,++p4,++p5]).

input_clause(c_199,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,++p4,++p7]).

input_clause(c_200,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,++p4,--p6]).

input_clause(c_201,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,++p3,++p4,--p6,++p7]).

input_clause(c_202,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,++p3,++p4]).

input_clause(c_203,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,++p3,++p4,++p5,++p7]).

input_clause(c_204,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,++p3,++p4,++p5,--p6]).

input_clause(c_205,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,++p3,++p5,--p6,++p7]).

input_clause(c_206,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,++p3,++p5]).

input_clause(c_207,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,++p3,++p7]).

input_clause(c_208,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,++p3,--p6]).

input_clause(c_209,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,++p2,++p3,--p6,++p7]).

input_clause(c_210,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,++p2,++p3]).

input_clause(c_211,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,++p2,++p3,++p5,++p7]).

input_clause(c_212,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,++p2,++p3,++p5,--p6]).

input_clause(c_213,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,++p2,++p3,++p4,++p5,--p6,++p7]).

input_clause(c_214,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,++p2,++p3,++p4,++p5]).

input_clause(c_215,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,++p2,++p3,++p4,++p7]).

input_clause(c_216,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,++p2,++p3,++p4,--p6]).

input_clause(c_217,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,++p2,++p4,--p6,++p7]).

input_clause(c_218,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,++p2,++p4]).

input_clause(c_219,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,++p2,++p4,++p5,++p7]).

input_clause(c_220,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,++p2,++p4,++p5,--p6]).

input_clause(c_221,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,++p2,++p5,--p6,++p7]).

input_clause(c_222,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,++p2,++p5]).

input_clause(c_223,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,++p2,++p7]).

input_clause(c_224,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,++p2,--p6]).

input_clause(c_225,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,--p1,++p2,--p6,++p7]).

input_clause(c_226,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,--p1,++p2]).

input_clause(c_227,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,--p1,++p2,++p5,++p7]).

input_clause(c_228,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,--p1,++p2,++p5,--p6]).

input_clause(c_229,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,--p1,++p2,++p4,++p5,--p6,++p7]).

input_clause(c_230,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,--p1,++p2,++p4,++p5]).

input_clause(c_231,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,--p1,++p2,++p4,++p7]).

input_clause(c_232,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,--p1,++p2,++p4,--p6]).

input_clause(c_233,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,--p1,++p2,++p3,++p4,--p6,++p7]).

input_clause(c_234,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,--p1,++p2,++p3,++p4]).

input_clause(c_235,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,--p1,++p2,++p3,++p4,++p5,++p7]).

input_clause(c_236,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,--p1,++p2,++p3,++p4,++p5,--p6]).

input_clause(c_237,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,--p1,++p2,++p3,++p5,--p6,++p7]).

input_clause(c_238,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,--p1,++p2,++p3,++p5]).

input_clause(c_239,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,--p1,++p2,++p3,++p7]).

input_clause(c_240,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,--p1,++p2,++p3,--p6]).

input_clause(c_241,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,--p1,++p3,--p6,++p7]).

input_clause(c_242,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,--p1,++p3]).

input_clause(c_243,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,--p1,++p3,++p5,++p7]).

input_clause(c_244,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,--p1,++p3,++p5,--p6]).

input_clause(c_245,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,--p1,++p3,++p4,++p5,--p6,++p7]).

input_clause(c_246,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,--p1,++p3,++p4,++p5]).

input_clause(c_247,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,--p1,++p3,++p4,++p7]).

input_clause(c_248,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,--p1,++p3,++p4,--p6]).

input_clause(c_249,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,--p1,++p4,--p6,++p7]).

input_clause(c_250,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,--p1,++p4]).

input_clause(c_251,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,--p1,++p4,++p5,++p7]).

input_clause(c_252,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,--p1,++p4,++p5,--p6]).

input_clause(c_253,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,--p1,++p5,--p6,++p7]).

input_clause(c_254,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,--p1,++p5]).

input_clause(c_255,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,--p1,++p7]).

input_clause(c_256,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p7,--p1,--p6]).

input_clause(c_257,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,--p1,--p5,--p6,++p7]).

input_clause(c_258,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,--p1,--p5]).

input_clause(c_259,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,--p1,++p7]).

input_clause(c_260,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,--p1,--p6]).

input_clause(c_261,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,--p1,++p4,--p6,++p7]).

input_clause(c_262,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,--p1,++p4]).

input_clause(c_263,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,--p1,++p4,--p5,++p7]).

input_clause(c_264,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,--p1,++p4,--p5,--p6]).

input_clause(c_265,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,--p1,++p3,++p4,--p5,--p6,++p7]).

input_clause(c_266,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,--p1,++p3,++p4,--p5]).

input_clause(c_267,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,--p1,++p3,++p4,++p7]).

input_clause(c_268,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,--p1,++p3,++p4,--p6]).

input_clause(c_269,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,--p1,++p3,--p6,++p7]).

input_clause(c_270,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,--p1,++p3]).

input_clause(c_271,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,--p1,++p3,--p5,++p7]).

input_clause(c_272,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,--p1,++p3,--p5,--p6]).

input_clause(c_273,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,--p1,++p2,++p3,--p5,--p6,++p7]).

input_clause(c_274,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,--p1,++p2,++p3,--p5]).

input_clause(c_275,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,--p1,++p2,++p3,++p7]).

input_clause(c_276,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,--p1,++p2,++p3,--p6]).

input_clause(c_277,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,--p1,++p2,++p3,++p4,--p6,++p7]).

input_clause(c_278,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,--p1,++p2,++p3,++p4]).

input_clause(c_279,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,--p1,++p2,++p3,++p4,--p5,++p7]).

input_clause(c_280,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,--p1,++p2,++p3,++p4,--p5,--p6]).

input_clause(c_281,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,--p1,++p2,++p4,--p5,--p6,++p7]).

input_clause(c_282,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,--p1,++p2,++p4,--p5]).

input_clause(c_283,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,--p1,++p2,++p4,++p7]).

input_clause(c_284,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,--p1,++p2,++p4,--p6]).

input_clause(c_285,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,--p1,++p2,--p6,++p7]).

input_clause(c_286,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,--p1,++p2]).

input_clause(c_287,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,--p1,++p2,--p5,++p7]).

input_clause(c_288,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,--p1,++p2,--p5,--p6]).

input_clause(c_289,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,++p2,--p5,--p6,++p7]).

input_clause(c_290,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,++p2,--p5]).

input_clause(c_291,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,++p2,++p7]).

input_clause(c_292,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,++p2,--p6]).

input_clause(c_293,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,++p2,++p4,--p6,++p7]).

input_clause(c_294,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,++p2,++p4]).

input_clause(c_295,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,++p2,++p4,--p5,++p7]).

input_clause(c_296,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,++p2,++p4,--p5,--p6]).

input_clause(c_297,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,++p2,++p3,++p4,--p5,--p6,++p7]).

input_clause(c_298,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,++p2,++p3,++p4,--p5]).

input_clause(c_299,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,++p2,++p3,++p4,++p7]).

input_clause(c_300,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,++p2,++p3,++p4,--p6]).

input_clause(c_301,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,++p2,++p3,--p6,++p7]).

input_clause(c_302,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,++p2,++p3]).

input_clause(c_303,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,++p2,++p3,--p5,++p7]).

input_clause(c_304,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,++p2,++p3,--p5,--p6]).

input_clause(c_305,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,++p3,--p5,--p6,++p7]).

input_clause(c_306,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,++p3,--p5]).

input_clause(c_307,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,++p3,++p7]).

input_clause(c_308,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,++p3,--p6]).

input_clause(c_309,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,++p3,++p4,--p6,++p7]).

input_clause(c_310,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,++p3,++p4]).

input_clause(c_311,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,++p3,++p4,--p5,++p7]).

input_clause(c_312,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,++p3,++p4,--p5,--p6]).

input_clause(c_313,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,++p4,--p5,--p6,++p7]).

input_clause(c_314,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,++p4,--p5]).

input_clause(c_315,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,++p4,++p7]).

input_clause(c_316,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,++p4,--p6]).

input_clause(c_317,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,--p6,++p7]).

input_clause(c_318,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7]).

input_clause(c_319,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,--p5,++p7]).

input_clause(c_320,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p7,--p5,--p6]).

input_clause(c_321,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,--p5,--p6]).

input_clause(c_322,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,--p5,--p7]).

input_clause(c_323,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7]).

input_clause(c_324,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,--p6,--p7]).

input_clause(c_325,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,++p4,--p6]).

input_clause(c_326,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,++p4,--p7]).

input_clause(c_327,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,++p4,--p5]).

input_clause(c_328,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,++p4,--p5,--p6,--p7]).

input_clause(c_329,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,++p3,++p4,--p5,--p6]).

input_clause(c_330,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,++p3,++p4,--p5,--p7]).

input_clause(c_331,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,++p3,++p4]).

input_clause(c_332,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,++p3,++p4,--p6,--p7]).

input_clause(c_333,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,++p3,--p6]).

input_clause(c_334,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,++p3,--p7]).

input_clause(c_335,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,++p3,--p5]).

input_clause(c_336,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,++p3,--p5,--p6,--p7]).

input_clause(c_337,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,++p2,++p3,--p5,--p6]).

input_clause(c_338,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,++p2,++p3,--p5,--p7]).

input_clause(c_339,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,++p2,++p3]).

input_clause(c_340,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,++p2,++p3,--p6,--p7]).

input_clause(c_341,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,++p2,++p3,++p4,--p6]).

input_clause(c_342,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,++p2,++p3,++p4,--p7]).

input_clause(c_343,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,++p2,++p3,++p4,--p5]).

input_clause(c_344,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,++p2,++p3,++p4,--p5,--p6,--p7]).

input_clause(c_345,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,++p2,++p4,--p5,--p6]).

input_clause(c_346,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,++p2,++p4,--p5,--p7]).

input_clause(c_347,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,++p2,++p4]).

input_clause(c_348,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,++p2,++p4,--p6,--p7]).

input_clause(c_349,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,++p2,--p6]).

input_clause(c_350,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,++p2,--p7]).

input_clause(c_351,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,++p2,--p5]).

input_clause(c_352,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,++p2,--p5,--p6,--p7]).

input_clause(c_353,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,--p1,++p2,--p5,--p6]).

input_clause(c_354,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,--p1,++p2,--p5,--p7]).

input_clause(c_355,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,--p1,++p2]).

input_clause(c_356,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,--p1,++p2,--p6,--p7]).

input_clause(c_357,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,--p1,++p2,++p4,--p6]).

input_clause(c_358,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,--p1,++p2,++p4,--p7]).

input_clause(c_359,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,--p1,++p2,++p4,--p5]).

input_clause(c_360,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,--p1,++p2,++p4,--p5,--p6,--p7]).

input_clause(c_361,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,--p1,++p2,++p3,++p4,--p5,--p6]).

input_clause(c_362,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,--p1,++p2,++p3,++p4,--p5,--p7]).

input_clause(c_363,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,--p1,++p2,++p3,++p4]).

input_clause(c_364,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,--p1,++p2,++p3,++p4,--p6,--p7]).

input_clause(c_365,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,--p1,++p2,++p3,--p6]).

input_clause(c_366,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,--p1,++p2,++p3,--p7]).

input_clause(c_367,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,--p1,++p2,++p3,--p5]).

input_clause(c_368,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,--p1,++p2,++p3,--p5,--p6,--p7]).

input_clause(c_369,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,--p1,++p3,--p5,--p6]).

input_clause(c_370,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,--p1,++p3,--p5,--p7]).

input_clause(c_371,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,--p1,++p3]).

input_clause(c_372,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,--p1,++p3,--p6,--p7]).

input_clause(c_373,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,--p1,++p3,++p4,--p6]).

input_clause(c_374,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,--p1,++p3,++p4,--p7]).

input_clause(c_375,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,--p1,++p3,++p4,--p5]).

input_clause(c_376,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,--p1,++p3,++p4,--p5,--p6,--p7]).

input_clause(c_377,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,--p1,++p4,--p5,--p6]).

input_clause(c_378,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,--p1,++p4,--p5,--p7]).

input_clause(c_379,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,--p1,++p4]).

input_clause(c_380,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,--p1,++p4,--p6,--p7]).

input_clause(c_381,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,--p1,--p6]).

input_clause(c_382,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,--p1,--p7]).

input_clause(c_383,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,--p1,--p5]).

input_clause(c_384,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p7,--p1,--p5,--p6,--p7]).

input_clause(c_385,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,--p1,--p5]).

input_clause(c_386,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,--p1,--p5,++p6,--p7]).

input_clause(c_387,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,--p1,++p6]).

input_clause(c_388,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,--p1,--p7]).

input_clause(c_389,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,--p1,++p4]).

input_clause(c_390,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,--p1,++p4,++p6,--p7]).

input_clause(c_391,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,--p1,++p4,--p5,++p6]).

input_clause(c_392,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,--p1,++p4,--p5,--p7]).

input_clause(c_393,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,--p1,++p3,++p4,--p5]).

input_clause(c_394,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,--p1,++p3,++p4,--p5,++p6,--p7]).

input_clause(c_395,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,--p1,++p3,++p4,++p6]).

input_clause(c_396,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,--p1,++p3,++p4,--p7]).

input_clause(c_397,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,--p1,++p3]).

input_clause(c_398,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,--p1,++p3,++p6,--p7]).

input_clause(c_399,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,--p1,++p3,--p5,++p6]).

input_clause(c_400,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,--p1,++p3,--p5,--p7]).

input_clause(c_401,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,--p1,++p2,++p3,--p5]).

input_clause(c_402,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,--p1,++p2,++p3,--p5,++p6,--p7]).

input_clause(c_403,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,--p1,++p2,++p3,++p6]).

input_clause(c_404,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,--p1,++p2,++p3,--p7]).

input_clause(c_405,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,--p1,++p2,++p3,++p4]).

input_clause(c_406,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,--p1,++p2,++p3,++p4,++p6,--p7]).

input_clause(c_407,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,--p1,++p2,++p3,++p4,--p5,++p6]).

input_clause(c_408,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,--p1,++p2,++p3,++p4,--p5,--p7]).

input_clause(c_409,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,--p1,++p2,++p4,--p5]).

input_clause(c_410,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,--p1,++p2,++p4,--p5,++p6,--p7]).

input_clause(c_411,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,--p1,++p2,++p4,++p6]).

input_clause(c_412,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,--p1,++p2,++p4,--p7]).

input_clause(c_413,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,--p1,++p2]).

input_clause(c_414,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,--p1,++p2,++p6,--p7]).

input_clause(c_415,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,--p1,++p2,--p5,++p6]).

input_clause(c_416,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,--p1,++p2,--p5,--p7]).

input_clause(c_417,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,++p2,--p5]).

input_clause(c_418,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,++p2,--p5,++p6,--p7]).

input_clause(c_419,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,++p2,++p6]).

input_clause(c_420,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,++p2,--p7]).

input_clause(c_421,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,++p2,++p4]).

input_clause(c_422,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,++p2,++p4,++p6,--p7]).

input_clause(c_423,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,++p2,++p4,--p5,++p6]).

input_clause(c_424,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,++p2,++p4,--p5,--p7]).

input_clause(c_425,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,++p2,++p3,++p4,--p5]).

input_clause(c_426,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,++p2,++p3,++p4,--p5,++p6,--p7]).

input_clause(c_427,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,++p2,++p3,++p4,++p6]).

input_clause(c_428,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,++p2,++p3,++p4,--p7]).

input_clause(c_429,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,++p2,++p3]).

input_clause(c_430,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,++p2,++p3,++p6,--p7]).

input_clause(c_431,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,++p2,++p3,--p5,++p6]).

input_clause(c_432,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,++p2,++p3,--p5,--p7]).

input_clause(c_433,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,++p3,--p5]).

input_clause(c_434,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,++p3,--p5,++p6,--p7]).

input_clause(c_435,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,++p3,++p6]).

input_clause(c_436,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,++p3,--p7]).

input_clause(c_437,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,++p3,++p4]).

input_clause(c_438,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,++p3,++p4,++p6,--p7]).

input_clause(c_439,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,++p3,++p4,--p5,++p6]).

input_clause(c_440,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,++p3,++p4,--p5,--p7]).

input_clause(c_441,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,++p4,--p5]).

input_clause(c_442,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,++p4,--p5,++p6,--p7]).

input_clause(c_443,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,++p4,++p6]).

input_clause(c_444,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,++p4,--p7]).

input_clause(c_445,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7]).

input_clause(c_446,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,++p6,--p7]).

input_clause(c_447,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,--p5,++p6]).

input_clause(c_448,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p7,--p5,--p7]).

input_clause(c_449,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,--p5,++p7]).

input_clause(c_450,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,--p5,++p6]).

input_clause(c_451,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,++p6,++p7]).

input_clause(c_452,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7]).

input_clause(c_453,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,++p4,++p7]).

input_clause(c_454,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,++p4,++p6]).

input_clause(c_455,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,++p4,--p5,++p6,++p7]).

input_clause(c_456,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,++p4,--p5]).

input_clause(c_457,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,++p3,++p4,--p5,++p7]).

input_clause(c_458,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,++p3,++p4,--p5,++p6]).

input_clause(c_459,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,++p3,++p4,++p6,++p7]).

input_clause(c_460,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,++p3,++p4]).

input_clause(c_461,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,++p3,++p7]).

input_clause(c_462,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,++p3,++p6]).

input_clause(c_463,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,++p3,--p5,++p6,++p7]).

input_clause(c_464,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,++p3,--p5]).

input_clause(c_465,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,++p2,++p3,--p5,++p7]).

input_clause(c_466,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,++p2,++p3,--p5,++p6]).

input_clause(c_467,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,++p2,++p3,++p6,++p7]).

input_clause(c_468,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,++p2,++p3]).

input_clause(c_469,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,++p2,++p3,++p4,++p7]).

input_clause(c_470,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,++p2,++p3,++p4,++p6]).

input_clause(c_471,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,++p2,++p3,++p4,--p5,++p6,++p7]).

input_clause(c_472,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,++p2,++p3,++p4,--p5]).

input_clause(c_473,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,++p2,++p4,--p5,++p7]).

input_clause(c_474,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,++p2,++p4,--p5,++p6]).

input_clause(c_475,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,++p2,++p4,++p6,++p7]).

input_clause(c_476,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,++p2,++p4]).

input_clause(c_477,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,++p2,++p7]).

input_clause(c_478,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,++p2,++p6]).

input_clause(c_479,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,++p2,--p5,++p6,++p7]).

input_clause(c_480,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,++p2,--p5]).

input_clause(c_481,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,--p1,++p2,--p5,++p7]).

input_clause(c_482,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,--p1,++p2,--p5,++p6]).

input_clause(c_483,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,--p1,++p2,++p6,++p7]).

input_clause(c_484,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,--p1,++p2]).

input_clause(c_485,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,--p1,++p2,++p4,++p7]).

input_clause(c_486,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,--p1,++p2,++p4,++p6]).

input_clause(c_487,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,--p1,++p2,++p4,--p5,++p6,++p7]).

input_clause(c_488,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,--p1,++p2,++p4,--p5]).

input_clause(c_489,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,--p1,++p2,++p3,++p4,--p5,++p7]).

input_clause(c_490,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,--p1,++p2,++p3,++p4,--p5,++p6]).

input_clause(c_491,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,--p1,++p2,++p3,++p4,++p6,++p7]).

input_clause(c_492,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,--p1,++p2,++p3,++p4]).

input_clause(c_493,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,--p1,++p2,++p3,++p7]).

input_clause(c_494,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,--p1,++p2,++p3,++p6]).

input_clause(c_495,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,--p1,++p2,++p3,--p5,++p6,++p7]).

input_clause(c_496,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,--p1,++p2,++p3,--p5]).

input_clause(c_497,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,--p1,++p3,--p5,++p7]).

input_clause(c_498,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,--p1,++p3,--p5,++p6]).

input_clause(c_499,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,--p1,++p3,++p6,++p7]).

input_clause(c_500,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,--p1,++p3]).

input_clause(c_501,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,--p1,++p3,++p4,++p7]).

input_clause(c_502,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,--p1,++p3,++p4,++p6]).

input_clause(c_503,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,--p1,++p3,++p4,--p5,++p6,++p7]).

input_clause(c_504,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,--p1,++p3,++p4,--p5]).

input_clause(c_505,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,--p1,++p4,--p5,++p7]).

input_clause(c_506,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,--p1,++p4,--p5,++p6]).

input_clause(c_507,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,--p1,++p4,++p6,++p7]).

input_clause(c_508,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,--p1,++p4]).

input_clause(c_509,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,--p1,++p7]).

input_clause(c_510,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,--p1,++p6]).

input_clause(c_511,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,--p1,--p5,++p6,++p7]).

input_clause(c_512,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p7,--p1,--p5]).

input_clause(c_513,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,--p1,--p4,--p5,++p7]).

input_clause(c_514,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,--p1,--p4,--p5,++p6]).

input_clause(c_515,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,--p1,--p4,++p6,++p7]).

input_clause(c_516,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,--p1,--p4]).

input_clause(c_517,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,--p1,++p7]).

input_clause(c_518,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,--p1,++p6]).

input_clause(c_519,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,--p1,--p5,++p6,++p7]).

input_clause(c_520,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,--p1,--p5]).

input_clause(c_521,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,--p1,++p3,--p5,++p7]).

input_clause(c_522,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,--p1,++p3,--p5,++p6]).

input_clause(c_523,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,--p1,++p3,++p6,++p7]).

input_clause(c_524,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,--p1,++p3]).

input_clause(c_525,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,--p1,++p3,--p4,++p7]).

input_clause(c_526,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,--p1,++p3,--p4,++p6]).

input_clause(c_527,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,--p1,++p3,--p4,--p5,++p6,++p7]).

input_clause(c_528,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,--p1,++p3,--p4,--p5]).

input_clause(c_529,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,--p1,++p2,++p3,--p4,--p5,++p7]).

input_clause(c_530,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,--p1,++p2,++p3,--p4,--p5,++p6]).

input_clause(c_531,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,--p1,++p2,++p3,--p4,++p6,++p7]).

input_clause(c_532,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,--p1,++p2,++p3,--p4]).

input_clause(c_533,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,--p1,++p2,++p3,++p7]).

input_clause(c_534,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,--p1,++p2,++p3,++p6]).

input_clause(c_535,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,--p1,++p2,++p3,--p5,++p6,++p7]).

input_clause(c_536,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,--p1,++p2,++p3,--p5]).

input_clause(c_537,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,--p1,++p2,--p5,++p7]).

input_clause(c_538,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,--p1,++p2,--p5,++p6]).

input_clause(c_539,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,--p1,++p2,++p6,++p7]).

input_clause(c_540,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,--p1,++p2]).

input_clause(c_541,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,--p1,++p2,--p4,++p7]).

input_clause(c_542,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,--p1,++p2,--p4,++p6]).

input_clause(c_543,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,--p1,++p2,--p4,--p5,++p6,++p7]).

input_clause(c_544,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,--p1,++p2,--p4,--p5]).

input_clause(c_545,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,++p2,--p4,--p5,++p7]).

input_clause(c_546,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,++p2,--p4,--p5,++p6]).

input_clause(c_547,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,++p2,--p4,++p6,++p7]).

input_clause(c_548,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,++p2,--p4]).

input_clause(c_549,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,++p2,++p7]).

input_clause(c_550,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,++p2,++p6]).

input_clause(c_551,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,++p2,--p5,++p6,++p7]).

input_clause(c_552,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,++p2,--p5]).

input_clause(c_553,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,++p2,++p3,--p5,++p7]).

input_clause(c_554,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,++p2,++p3,--p5,++p6]).

input_clause(c_555,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,++p2,++p3,++p6,++p7]).

input_clause(c_556,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,++p2,++p3]).

input_clause(c_557,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,++p2,++p3,--p4,++p7]).

input_clause(c_558,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,++p2,++p3,--p4,++p6]).

input_clause(c_559,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,++p2,++p3,--p4,--p5,++p6,++p7]).

input_clause(c_560,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,++p2,++p3,--p4,--p5]).

input_clause(c_561,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,++p3,--p4,--p5,++p7]).

input_clause(c_562,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,++p3,--p4,--p5,++p6]).

input_clause(c_563,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,++p3,--p4,++p6,++p7]).

input_clause(c_564,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,++p3,--p4]).

input_clause(c_565,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,++p3,++p7]).

input_clause(c_566,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,++p3,++p6]).

input_clause(c_567,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,++p3,--p5,++p6,++p7]).

input_clause(c_568,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,++p3,--p5]).

input_clause(c_569,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,--p5,++p7]).

input_clause(c_570,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,--p5,++p6]).

input_clause(c_571,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,++p6,++p7]).

input_clause(c_572,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7]).

input_clause(c_573,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,--p4,++p7]).

input_clause(c_574,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,--p4,++p6]).

input_clause(c_575,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,--p4,--p5,++p6,++p7]).

input_clause(c_576,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p7,--p4,--p5]).

input_clause(c_577,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,--p4,--p5]).

input_clause(c_578,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,--p4,--p5,++p6,--p7]).

input_clause(c_579,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,--p4,++p6]).

input_clause(c_580,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,--p4,--p7]).

input_clause(c_581,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7]).

input_clause(c_582,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,++p6,--p7]).

input_clause(c_583,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,--p5,++p6]).

input_clause(c_584,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,--p5,--p7]).

input_clause(c_585,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,++p3,--p5]).

input_clause(c_586,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,++p3,--p5,++p6,--p7]).

input_clause(c_587,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,++p3,++p6]).

input_clause(c_588,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,++p3,--p7]).

input_clause(c_589,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,++p3,--p4]).

input_clause(c_590,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,++p3,--p4,++p6,--p7]).

input_clause(c_591,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,++p3,--p4,--p5,++p6]).

input_clause(c_592,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,++p3,--p4,--p5,--p7]).

input_clause(c_593,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,++p2,++p3,--p4,--p5]).

input_clause(c_594,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,++p2,++p3,--p4,--p5,++p6,--p7]).

input_clause(c_595,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,++p2,++p3,--p4,++p6]).

input_clause(c_596,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,++p2,++p3,--p4,--p7]).

input_clause(c_597,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,++p2,++p3]).

input_clause(c_598,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,++p2,++p3,++p6,--p7]).

input_clause(c_599,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,++p2,++p3,--p5,++p6]).

input_clause(c_600,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,++p2,++p3,--p5,--p7]).

input_clause(c_601,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,++p2,--p5]).

input_clause(c_602,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,++p2,--p5,++p6,--p7]).

input_clause(c_603,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,++p2,++p6]).

input_clause(c_604,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,++p2,--p7]).

input_clause(c_605,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,++p2,--p4]).

input_clause(c_606,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,++p2,--p4,++p6,--p7]).

input_clause(c_607,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,++p2,--p4,--p5,++p6]).

input_clause(c_608,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,++p2,--p4,--p5,--p7]).

input_clause(c_609,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,--p1,++p2,--p4,--p5]).

input_clause(c_610,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,--p1,++p2,--p4,--p5,++p6,--p7]).

input_clause(c_611,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,--p1,++p2,--p4,++p6]).

input_clause(c_612,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,--p1,++p2,--p4,--p7]).

input_clause(c_613,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,--p1,++p2]).

input_clause(c_614,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,--p1,++p2,++p6,--p7]).

input_clause(c_615,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,--p1,++p2,--p5,++p6]).

input_clause(c_616,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,--p1,++p2,--p5,--p7]).

input_clause(c_617,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,--p1,++p2,++p3,--p5]).

input_clause(c_618,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,--p1,++p2,++p3,--p5,++p6,--p7]).

input_clause(c_619,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,--p1,++p2,++p3,++p6]).

input_clause(c_620,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,--p1,++p2,++p3,--p7]).

input_clause(c_621,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,--p1,++p2,++p3,--p4]).

input_clause(c_622,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,--p1,++p2,++p3,--p4,++p6,--p7]).

input_clause(c_623,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,--p1,++p2,++p3,--p4,--p5,++p6]).

input_clause(c_624,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,--p1,++p2,++p3,--p4,--p5,--p7]).

input_clause(c_625,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,--p1,++p3,--p4,--p5]).

input_clause(c_626,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,--p1,++p3,--p4,--p5,++p6,--p7]).

input_clause(c_627,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,--p1,++p3,--p4,++p6]).

input_clause(c_628,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,--p1,++p3,--p4,--p7]).

input_clause(c_629,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,--p1,++p3]).

input_clause(c_630,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,--p1,++p3,++p6,--p7]).

input_clause(c_631,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,--p1,++p3,--p5,++p6]).

input_clause(c_632,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,--p1,++p3,--p5,--p7]).

input_clause(c_633,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,--p1,--p5]).

input_clause(c_634,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,--p1,--p5,++p6,--p7]).

input_clause(c_635,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,--p1,++p6]).

input_clause(c_636,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,--p1,--p7]).

input_clause(c_637,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,--p1,--p4]).

input_clause(c_638,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,--p1,--p4,++p6,--p7]).

input_clause(c_639,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,--p1,--p4,--p5,++p6]).

input_clause(c_640,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p7,--p1,--p4,--p5,--p7]).

input_clause(c_641,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,--p1,--p4,--p5,--p6]).

input_clause(c_642,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,--p1,--p4,--p5,--p7]).

input_clause(c_643,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,--p1,--p4]).

input_clause(c_644,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,--p1,--p4,--p6,--p7]).

input_clause(c_645,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,--p1,--p6]).

input_clause(c_646,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,--p1,--p7]).

input_clause(c_647,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,--p1,--p5]).

input_clause(c_648,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,--p1,--p5,--p6,--p7]).

input_clause(c_649,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,--p1,++p3,--p5,--p6]).

input_clause(c_650,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,--p1,++p3,--p5,--p7]).

input_clause(c_651,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,--p1,++p3]).

input_clause(c_652,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,--p1,++p3,--p6,--p7]).

input_clause(c_653,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,--p1,++p3,--p4,--p6]).

input_clause(c_654,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,--p1,++p3,--p4,--p7]).

input_clause(c_655,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,--p1,++p3,--p4,--p5]).

input_clause(c_656,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,--p1,++p3,--p4,--p5,--p6,--p7]).

input_clause(c_657,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,--p1,++p2,++p3,--p4,--p5,--p6]).

input_clause(c_658,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,--p1,++p2,++p3,--p4,--p5,--p7]).

input_clause(c_659,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,--p1,++p2,++p3,--p4]).

input_clause(c_660,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,--p1,++p2,++p3,--p4,--p6,--p7]).

input_clause(c_661,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,--p1,++p2,++p3,--p6]).

input_clause(c_662,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,--p1,++p2,++p3,--p7]).

input_clause(c_663,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,--p1,++p2,++p3,--p5]).

input_clause(c_664,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,--p1,++p2,++p3,--p5,--p6,--p7]).

input_clause(c_665,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,--p1,++p2,--p5,--p6]).

input_clause(c_666,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,--p1,++p2,--p5,--p7]).

input_clause(c_667,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,--p1,++p2]).

input_clause(c_668,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,--p1,++p2,--p6,--p7]).

input_clause(c_669,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,--p1,++p2,--p4,--p6]).

input_clause(c_670,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,--p1,++p2,--p4,--p7]).

input_clause(c_671,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,--p1,++p2,--p4,--p5]).

input_clause(c_672,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,--p1,++p2,--p4,--p5,--p6,--p7]).

input_clause(c_673,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,++p2,--p4,--p5,--p6]).

input_clause(c_674,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,++p2,--p4,--p5,--p7]).

input_clause(c_675,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,++p2,--p4]).

input_clause(c_676,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,++p2,--p4,--p6,--p7]).

input_clause(c_677,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,++p2,--p6]).

input_clause(c_678,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,++p2,--p7]).

input_clause(c_679,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,++p2,--p5]).

input_clause(c_680,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,++p2,--p5,--p6,--p7]).

input_clause(c_681,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,++p2,++p3,--p5,--p6]).

input_clause(c_682,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,++p2,++p3,--p5,--p7]).

input_clause(c_683,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,++p2,++p3]).

input_clause(c_684,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,++p2,++p3,--p6,--p7]).

input_clause(c_685,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,++p2,++p3,--p4,--p6]).

input_clause(c_686,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,++p2,++p3,--p4,--p7]).

input_clause(c_687,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,++p2,++p3,--p4,--p5]).

input_clause(c_688,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,++p2,++p3,--p4,--p5,--p6,--p7]).

input_clause(c_689,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,++p3,--p4,--p5,--p6]).

input_clause(c_690,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,++p3,--p4,--p5,--p7]).

input_clause(c_691,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,++p3,--p4]).

input_clause(c_692,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,++p3,--p4,--p6,--p7]).

input_clause(c_693,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,++p3,--p6]).

input_clause(c_694,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,++p3,--p7]).

input_clause(c_695,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,++p3,--p5]).

input_clause(c_696,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,++p3,--p5,--p6,--p7]).

input_clause(c_697,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,--p5,--p6]).

input_clause(c_698,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,--p5,--p7]).

input_clause(c_699,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7]).

input_clause(c_700,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,--p6,--p7]).

input_clause(c_701,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,--p4,--p6]).

input_clause(c_702,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,--p4,--p7]).

input_clause(c_703,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,--p4,--p5]).

input_clause(c_704,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p7,--p4,--p5,--p6,--p7]).

input_clause(c_705,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,--p4,--p5,--p6,++p7]).

input_clause(c_706,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,--p4,--p5]).

input_clause(c_707,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,--p4,++p7]).

input_clause(c_708,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,--p4,--p6]).

input_clause(c_709,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,--p6,++p7]).

input_clause(c_710,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7]).

input_clause(c_711,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,--p5,++p7]).

input_clause(c_712,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,--p5,--p6]).

input_clause(c_713,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,++p3,--p5,--p6,++p7]).

input_clause(c_714,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,++p3,--p5]).

input_clause(c_715,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,++p3,++p7]).

input_clause(c_716,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,++p3,--p6]).

input_clause(c_717,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,++p3,--p4,--p6,++p7]).

input_clause(c_718,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,++p3,--p4]).

input_clause(c_719,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,++p3,--p4,--p5,++p7]).

input_clause(c_720,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,++p3,--p4,--p5,--p6]).

input_clause(c_721,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,++p2,++p3,--p4,--p5,--p6,++p7]).

input_clause(c_722,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,++p2,++p3,--p4,--p5]).

input_clause(c_723,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,++p2,++p3,--p4,++p7]).

input_clause(c_724,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,++p2,++p3,--p4,--p6]).

input_clause(c_725,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,++p2,++p3,--p6,++p7]).

input_clause(c_726,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,++p2,++p3]).

input_clause(c_727,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,++p2,++p3,--p5,++p7]).

input_clause(c_728,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,++p2,++p3,--p5,--p6]).

input_clause(c_729,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,++p2,--p5,--p6,++p7]).

input_clause(c_730,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,++p2,--p5]).

input_clause(c_731,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,++p2,++p7]).

input_clause(c_732,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,++p2,--p6]).

input_clause(c_733,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,++p2,--p4,--p6,++p7]).

input_clause(c_734,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,++p2,--p4]).

input_clause(c_735,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,++p2,--p4,--p5,++p7]).

input_clause(c_736,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,++p2,--p4,--p5,--p6]).

input_clause(c_737,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,--p1,++p2,--p4,--p5,--p6,++p7]).

input_clause(c_738,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,--p1,++p2,--p4,--p5]).

input_clause(c_739,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,--p1,++p2,--p4,++p7]).

input_clause(c_740,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,--p1,++p2,--p4,--p6]).

input_clause(c_741,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,--p1,++p2,--p6,++p7]).

input_clause(c_742,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,--p1,++p2]).

input_clause(c_743,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,--p1,++p2,--p5,++p7]).

input_clause(c_744,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,--p1,++p2,--p5,--p6]).

input_clause(c_745,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,--p1,++p2,++p3,--p5,--p6,++p7]).

input_clause(c_746,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,--p1,++p2,++p3,--p5]).

input_clause(c_747,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,--p1,++p2,++p3,++p7]).

input_clause(c_748,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,--p1,++p2,++p3,--p6]).

input_clause(c_749,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,--p1,++p2,++p3,--p4,--p6,++p7]).

input_clause(c_750,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,--p1,++p2,++p3,--p4]).

input_clause(c_751,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,--p1,++p2,++p3,--p4,--p5,++p7]).

input_clause(c_752,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,--p1,++p2,++p3,--p4,--p5,--p6]).

input_clause(c_753,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,--p1,++p3,--p4,--p5,--p6,++p7]).

input_clause(c_754,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,--p1,++p3,--p4,--p5]).

input_clause(c_755,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,--p1,++p3,--p4,++p7]).

input_clause(c_756,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,--p1,++p3,--p4,--p6]).

input_clause(c_757,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,--p1,++p3,--p6,++p7]).

input_clause(c_758,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,--p1,++p3]).

input_clause(c_759,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,--p1,++p3,--p5,++p7]).

input_clause(c_760,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,--p1,++p3,--p5,--p6]).

input_clause(c_761,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,--p1,--p5,--p6,++p7]).

input_clause(c_762,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,--p1,--p5]).

input_clause(c_763,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,--p1,++p7]).

input_clause(c_764,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,--p1,--p6]).

input_clause(c_765,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,--p1,--p4,--p6,++p7]).

input_clause(c_766,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,--p1,--p4]).

input_clause(c_767,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,--p1,--p4,--p5,++p7]).

input_clause(c_768,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p7,--p1,--p4,--p5,--p6]).

input_clause(c_769,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,--p1,--p4,--p6,++p7]).

input_clause(c_770,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,--p1,--p4]).

input_clause(c_771,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,--p1,--p4,++p5,++p7]).

input_clause(c_772,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,--p1,--p4,++p5,--p6]).

input_clause(c_773,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,--p1,++p5,--p6,++p7]).

input_clause(c_774,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,--p1,++p5]).

input_clause(c_775,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,--p1,++p7]).

input_clause(c_776,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,--p1,--p6]).

input_clause(c_777,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,--p1,++p3,--p6,++p7]).

input_clause(c_778,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,--p1,++p3]).

input_clause(c_779,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,--p1,++p3,++p5,++p7]).

input_clause(c_780,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,--p1,++p3,++p5,--p6]).

input_clause(c_781,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,--p1,++p3,--p4,++p5,--p6,++p7]).

input_clause(c_782,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,--p1,++p3,--p4,++p5]).

input_clause(c_783,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,--p1,++p3,--p4,++p7]).

input_clause(c_784,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,--p1,++p3,--p4,--p6]).

input_clause(c_785,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,--p1,++p2,++p3,--p4,--p6,++p7]).

input_clause(c_786,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,--p1,++p2,++p3,--p4]).

input_clause(c_787,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,--p1,++p2,++p3,--p4,++p5,++p7]).

input_clause(c_788,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,--p1,++p2,++p3,--p4,++p5,--p6]).

input_clause(c_789,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,--p1,++p2,++p3,++p5,--p6,++p7]).

input_clause(c_790,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,--p1,++p2,++p3,++p5]).

input_clause(c_791,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,--p1,++p2,++p3,++p7]).

input_clause(c_792,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,--p1,++p2,++p3,--p6]).

input_clause(c_793,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,--p1,++p2,--p6,++p7]).

input_clause(c_794,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,--p1,++p2]).

input_clause(c_795,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,--p1,++p2,++p5,++p7]).

input_clause(c_796,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,--p1,++p2,++p5,--p6]).

input_clause(c_797,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,--p1,++p2,--p4,++p5,--p6,++p7]).

input_clause(c_798,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,--p1,++p2,--p4,++p5]).

input_clause(c_799,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,--p1,++p2,--p4,++p7]).

input_clause(c_800,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,--p1,++p2,--p4,--p6]).

input_clause(c_801,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,++p2,--p4,--p6,++p7]).

input_clause(c_802,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,++p2,--p4]).

input_clause(c_803,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,++p2,--p4,++p5,++p7]).

input_clause(c_804,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,++p2,--p4,++p5,--p6]).

input_clause(c_805,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,++p2,++p5,--p6,++p7]).

input_clause(c_806,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,++p2,++p5]).

input_clause(c_807,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,++p2,++p7]).

input_clause(c_808,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,++p2,--p6]).

input_clause(c_809,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,++p2,++p3,--p6,++p7]).

input_clause(c_810,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,++p2,++p3]).

input_clause(c_811,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,++p2,++p3,++p5,++p7]).

input_clause(c_812,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,++p2,++p3,++p5,--p6]).

input_clause(c_813,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,++p2,++p3,--p4,++p5,--p6,++p7]).

input_clause(c_814,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,++p2,++p3,--p4,++p5]).

input_clause(c_815,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,++p2,++p3,--p4,++p7]).

input_clause(c_816,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,++p2,++p3,--p4,--p6]).

input_clause(c_817,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,++p3,--p4,--p6,++p7]).

input_clause(c_818,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,++p3,--p4]).

input_clause(c_819,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,++p3,--p4,++p5,++p7]).

input_clause(c_820,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,++p3,--p4,++p5,--p6]).

input_clause(c_821,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,++p3,++p5,--p6,++p7]).

input_clause(c_822,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,++p3,++p5]).

input_clause(c_823,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,++p3,++p7]).

input_clause(c_824,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,++p3,--p6]).

input_clause(c_825,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,--p6,++p7]).

input_clause(c_826,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7]).

input_clause(c_827,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,++p5,++p7]).

input_clause(c_828,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,++p5,--p6]).

input_clause(c_829,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,--p4,++p5,--p6,++p7]).

input_clause(c_830,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,--p4,++p5]).

input_clause(c_831,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,--p4,++p7]).

input_clause(c_832,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p7,--p4,--p6]).

input_clause(c_833,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,--p4,--p6]).

input_clause(c_834,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,--p4,--p7]).

input_clause(c_835,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,--p4,++p5]).

input_clause(c_836,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,--p4,++p5,--p6,--p7]).

input_clause(c_837,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,++p5,--p6]).

input_clause(c_838,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,++p5,--p7]).

input_clause(c_839,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7]).

input_clause(c_840,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,--p6,--p7]).

input_clause(c_841,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,++p3,--p6]).

input_clause(c_842,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,++p3,--p7]).

input_clause(c_843,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,++p3,++p5]).

input_clause(c_844,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,++p3,++p5,--p6,--p7]).

input_clause(c_845,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,++p3,--p4,++p5,--p6]).

input_clause(c_846,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,++p3,--p4,++p5,--p7]).

input_clause(c_847,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,++p3,--p4]).

input_clause(c_848,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,++p3,--p4,--p6,--p7]).

input_clause(c_849,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,++p2,++p3,--p4,--p6]).

input_clause(c_850,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,++p2,++p3,--p4,--p7]).

input_clause(c_851,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,++p2,++p3,--p4,++p5]).

input_clause(c_852,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,++p2,++p3,--p4,++p5,--p6,--p7]).

input_clause(c_853,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,++p2,++p3,++p5,--p6]).

input_clause(c_854,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,++p2,++p3,++p5,--p7]).

input_clause(c_855,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,++p2,++p3]).

input_clause(c_856,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,++p2,++p3,--p6,--p7]).

input_clause(c_857,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,++p2,--p6]).

input_clause(c_858,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,++p2,--p7]).

input_clause(c_859,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,++p2,++p5]).

input_clause(c_860,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,++p2,++p5,--p6,--p7]).

input_clause(c_861,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,++p2,--p4,++p5,--p6]).

input_clause(c_862,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,++p2,--p4,++p5,--p7]).

input_clause(c_863,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,++p2,--p4]).

input_clause(c_864,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,++p2,--p4,--p6,--p7]).

input_clause(c_865,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,--p1,++p2,--p4,--p6]).

input_clause(c_866,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,--p1,++p2,--p4,--p7]).

input_clause(c_867,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,--p1,++p2,--p4,++p5]).

input_clause(c_868,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,--p1,++p2,--p4,++p5,--p6,--p7]).

input_clause(c_869,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,--p1,++p2,++p5,--p6]).

input_clause(c_870,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,--p1,++p2,++p5,--p7]).

input_clause(c_871,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,--p1,++p2]).

input_clause(c_872,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,--p1,++p2,--p6,--p7]).

input_clause(c_873,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,--p1,++p2,++p3,--p6]).

input_clause(c_874,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,--p1,++p2,++p3,--p7]).

input_clause(c_875,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,--p1,++p2,++p3,++p5]).

input_clause(c_876,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,--p1,++p2,++p3,++p5,--p6,--p7]).

input_clause(c_877,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,--p1,++p2,++p3,--p4,++p5,--p6]).

input_clause(c_878,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,--p1,++p2,++p3,--p4,++p5,--p7]).

input_clause(c_879,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,--p1,++p2,++p3,--p4]).

input_clause(c_880,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,--p1,++p2,++p3,--p4,--p6,--p7]).

input_clause(c_881,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,--p1,++p3,--p4,--p6]).

input_clause(c_882,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,--p1,++p3,--p4,--p7]).

input_clause(c_883,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,--p1,++p3,--p4,++p5]).

input_clause(c_884,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,--p1,++p3,--p4,++p5,--p6,--p7]).

input_clause(c_885,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,--p1,++p3,++p5,--p6]).

input_clause(c_886,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,--p1,++p3,++p5,--p7]).

input_clause(c_887,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,--p1,++p3]).

input_clause(c_888,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,--p1,++p3,--p6,--p7]).

input_clause(c_889,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,--p1,--p6]).

input_clause(c_890,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,--p1,--p7]).

input_clause(c_891,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,--p1,++p5]).

input_clause(c_892,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,--p1,++p5,--p6,--p7]).

input_clause(c_893,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,--p1,--p4,++p5,--p6]).

input_clause(c_894,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,--p1,--p4,++p5,--p7]).

input_clause(c_895,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,--p1,--p4]).

input_clause(c_896,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p7,--p1,--p4,--p6,--p7]).

input_clause(c_897,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,--p1,--p4]).

input_clause(c_898,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,--p1,--p4,++p6,--p7]).

input_clause(c_899,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,--p1,--p4,++p5,++p6]).

input_clause(c_900,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,--p1,--p4,++p5,--p7]).

input_clause(c_901,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,--p1,++p5]).

input_clause(c_902,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,--p1,++p5,++p6,--p7]).

input_clause(c_903,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,--p1,++p6]).

input_clause(c_904,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,--p1,--p7]).

input_clause(c_905,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,--p1,++p3]).

input_clause(c_906,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,--p1,++p3,++p6,--p7]).

input_clause(c_907,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,--p1,++p3,++p5,++p6]).

input_clause(c_908,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,--p1,++p3,++p5,--p7]).

input_clause(c_909,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,--p1,++p3,--p4,++p5]).

input_clause(c_910,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,--p1,++p3,--p4,++p5,++p6,--p7]).

input_clause(c_911,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,--p1,++p3,--p4,++p6]).

input_clause(c_912,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,--p1,++p3,--p4,--p7]).

input_clause(c_913,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,--p1,++p2,++p3,--p4]).

input_clause(c_914,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,--p1,++p2,++p3,--p4,++p6,--p7]).

input_clause(c_915,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,--p1,++p2,++p3,--p4,++p5,++p6]).

input_clause(c_916,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,--p1,++p2,++p3,--p4,++p5,--p7]).

input_clause(c_917,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,--p1,++p2,++p3,++p5]).

input_clause(c_918,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,--p1,++p2,++p3,++p5,++p6,--p7]).

input_clause(c_919,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,--p1,++p2,++p3,++p6]).

input_clause(c_920,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,--p1,++p2,++p3,--p7]).

input_clause(c_921,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,--p1,++p2]).

input_clause(c_922,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,--p1,++p2,++p6,--p7]).

input_clause(c_923,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,--p1,++p2,++p5,++p6]).

input_clause(c_924,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,--p1,++p2,++p5,--p7]).

input_clause(c_925,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,--p1,++p2,--p4,++p5]).

input_clause(c_926,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,--p1,++p2,--p4,++p5,++p6,--p7]).

input_clause(c_927,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,--p1,++p2,--p4,++p6]).

input_clause(c_928,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,--p1,++p2,--p4,--p7]).

input_clause(c_929,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,++p2,--p4]).

input_clause(c_930,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,++p2,--p4,++p6,--p7]).

input_clause(c_931,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,++p2,--p4,++p5,++p6]).

input_clause(c_932,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,++p2,--p4,++p5,--p7]).

input_clause(c_933,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,++p2,++p5]).

input_clause(c_934,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,++p2,++p5,++p6,--p7]).

input_clause(c_935,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,++p2,++p6]).

input_clause(c_936,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,++p2,--p7]).

input_clause(c_937,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,++p2,++p3]).

input_clause(c_938,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,++p2,++p3,++p6,--p7]).

input_clause(c_939,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,++p2,++p3,++p5,++p6]).

input_clause(c_940,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,++p2,++p3,++p5,--p7]).

input_clause(c_941,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,++p2,++p3,--p4,++p5]).

input_clause(c_942,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,++p2,++p3,--p4,++p5,++p6,--p7]).

input_clause(c_943,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,++p2,++p3,--p4,++p6]).

input_clause(c_944,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,++p2,++p3,--p4,--p7]).

input_clause(c_945,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,++p3,--p4]).

input_clause(c_946,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,++p3,--p4,++p6,--p7]).

input_clause(c_947,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,++p3,--p4,++p5,++p6]).

input_clause(c_948,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,++p3,--p4,++p5,--p7]).

input_clause(c_949,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,++p3,++p5]).

input_clause(c_950,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,++p3,++p5,++p6,--p7]).

input_clause(c_951,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,++p3,++p6]).

input_clause(c_952,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,++p3,--p7]).

input_clause(c_953,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7]).

input_clause(c_954,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,++p6,--p7]).

input_clause(c_955,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,++p5,++p6]).

input_clause(c_956,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,++p5,--p7]).

input_clause(c_957,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,--p4,++p5]).

input_clause(c_958,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,--p4,++p5,++p6,--p7]).

input_clause(c_959,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,--p4,++p6]).

input_clause(c_960,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p7,--p4,--p7]).

input_clause(c_961,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,--p4,++p7]).

input_clause(c_962,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,--p4,++p6]).

input_clause(c_963,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,--p4,++p5,++p6,++p7]).

input_clause(c_964,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,--p4,++p5]).

input_clause(c_965,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,++p5,++p7]).

input_clause(c_966,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,++p5,++p6]).

input_clause(c_967,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,++p6,++p7]).

input_clause(c_968,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7]).

input_clause(c_969,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,++p3,++p7]).

input_clause(c_970,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,++p3,++p6]).

input_clause(c_971,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,++p3,++p5,++p6,++p7]).

input_clause(c_972,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,++p3,++p5]).

input_clause(c_973,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,++p3,--p4,++p5,++p7]).

input_clause(c_974,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,++p3,--p4,++p5,++p6]).

input_clause(c_975,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,++p3,--p4,++p6,++p7]).

input_clause(c_976,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,++p3,--p4]).

input_clause(c_977,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,++p2,++p3,--p4,++p7]).

input_clause(c_978,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,++p2,++p3,--p4,++p6]).

input_clause(c_979,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,++p2,++p3,--p4,++p5,++p6,++p7]).

input_clause(c_980,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,++p2,++p3,--p4,++p5]).

input_clause(c_981,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,++p2,++p3,++p5,++p7]).

input_clause(c_982,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,++p2,++p3,++p5,++p6]).

input_clause(c_983,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,++p2,++p3,++p6,++p7]).

input_clause(c_984,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,++p2,++p3]).

input_clause(c_985,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,++p2,++p7]).

input_clause(c_986,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,++p2,++p6]).

input_clause(c_987,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,++p2,++p5,++p6,++p7]).

input_clause(c_988,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,++p2,++p5]).

input_clause(c_989,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,++p2,--p4,++p5,++p7]).

input_clause(c_990,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,++p2,--p4,++p5,++p6]).

input_clause(c_991,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,++p2,--p4,++p6,++p7]).

input_clause(c_992,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,++p2,--p4]).

input_clause(c_993,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,--p1,++p2,--p4,++p7]).

input_clause(c_994,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,--p1,++p2,--p4,++p6]).

input_clause(c_995,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,--p1,++p2,--p4,++p5,++p6,++p7]).

input_clause(c_996,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,--p1,++p2,--p4,++p5]).

input_clause(c_997,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,--p1,++p2,++p5,++p7]).

input_clause(c_998,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,--p1,++p2,++p5,++p6]).

input_clause(c_999,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,--p1,++p2,++p6,++p7]).

input_clause(c_1000,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,--p1,++p2]).

input_clause(c_1001,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,--p1,++p2,++p3,++p7]).

input_clause(c_1002,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,--p1,++p2,++p3,++p6]).

input_clause(c_1003,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,--p1,++p2,++p3,++p5,++p6,++p7]).

input_clause(c_1004,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,--p1,++p2,++p3,++p5]).

input_clause(c_1005,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,--p1,++p2,++p3,--p4,++p5,++p7]).

input_clause(c_1006,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,--p1,++p2,++p3,--p4,++p5,++p6]).

input_clause(c_1007,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,--p1,++p2,++p3,--p4,++p6,++p7]).

input_clause(c_1008,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,--p1,++p2,++p3,--p4]).

input_clause(c_1009,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,--p1,++p3,--p4,++p7]).

input_clause(c_1010,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,--p1,++p3,--p4,++p6]).

input_clause(c_1011,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,--p1,++p3,--p4,++p5,++p6,++p7]).

input_clause(c_1012,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,--p1,++p3,--p4,++p5]).

input_clause(c_1013,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,--p1,++p3,++p5,++p7]).

input_clause(c_1014,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,--p1,++p3,++p5,++p6]).

input_clause(c_1015,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,--p1,++p3,++p6,++p7]).

input_clause(c_1016,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,--p1,++p3]).

input_clause(c_1017,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,--p1,++p7]).

input_clause(c_1018,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,--p1,++p6]).

input_clause(c_1019,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,--p1,++p5,++p6,++p7]).

input_clause(c_1020,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,--p1,++p5]).

input_clause(c_1021,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,--p1,--p4,++p5,++p7]).

input_clause(c_1022,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,--p1,--p4,++p5,++p6]).

input_clause(c_1023,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,--p1,--p4,++p6,++p7]).

input_clause(c_1024,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p7,--p1,--p4]).

input_clause(c_1025,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,--p1,--p3,--p4,++p7]).

input_clause(c_1026,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,--p1,--p3,--p4,++p6]).

input_clause(c_1027,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,--p1,--p3,--p4,++p5,++p6,++p7]).

input_clause(c_1028,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,--p1,--p3,--p4,++p5]).

input_clause(c_1029,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,--p1,--p3,++p5,++p7]).

input_clause(c_1030,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,--p1,--p3,++p5,++p6]).

input_clause(c_1031,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,--p1,--p3,++p6,++p7]).

input_clause(c_1032,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,--p1,--p3]).

input_clause(c_1033,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,--p1,++p7]).

input_clause(c_1034,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,--p1,++p6]).

input_clause(c_1035,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,--p1,++p5,++p6,++p7]).

input_clause(c_1036,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,--p1,++p5]).

input_clause(c_1037,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,--p1,--p4,++p5,++p7]).

input_clause(c_1038,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,--p1,--p4,++p5,++p6]).

input_clause(c_1039,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,--p1,--p4,++p6,++p7]).

input_clause(c_1040,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,--p1,--p4]).

input_clause(c_1041,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,--p1,++p2,--p4,++p7]).

input_clause(c_1042,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,--p1,++p2,--p4,++p6]).

input_clause(c_1043,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,--p1,++p2,--p4,++p5,++p6,++p7]).

input_clause(c_1044,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,--p1,++p2,--p4,++p5]).

input_clause(c_1045,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,--p1,++p2,++p5,++p7]).

input_clause(c_1046,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,--p1,++p2,++p5,++p6]).

input_clause(c_1047,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,--p1,++p2,++p6,++p7]).

input_clause(c_1048,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,--p1,++p2]).

input_clause(c_1049,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,--p1,++p2,--p3,++p7]).

input_clause(c_1050,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,--p1,++p2,--p3,++p6]).

input_clause(c_1051,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,--p1,++p2,--p3,++p5,++p6,++p7]).

input_clause(c_1052,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,--p1,++p2,--p3,++p5]).

input_clause(c_1053,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,--p1,++p2,--p3,--p4,++p5,++p7]).

input_clause(c_1054,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,--p1,++p2,--p3,--p4,++p5,++p6]).

input_clause(c_1055,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,--p1,++p2,--p3,--p4,++p6,++p7]).

input_clause(c_1056,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,--p1,++p2,--p3,--p4]).

input_clause(c_1057,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,++p2,--p3,--p4,++p7]).

input_clause(c_1058,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,++p2,--p3,--p4,++p6]).

input_clause(c_1059,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,++p2,--p3,--p4,++p5,++p6,++p7]).

input_clause(c_1060,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,++p2,--p3,--p4,++p5]).

input_clause(c_1061,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,++p2,--p3,++p5,++p7]).

input_clause(c_1062,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,++p2,--p3,++p5,++p6]).

input_clause(c_1063,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,++p2,--p3,++p6,++p7]).

input_clause(c_1064,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,++p2,--p3]).

input_clause(c_1065,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,++p2,++p7]).

input_clause(c_1066,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,++p2,++p6]).

input_clause(c_1067,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,++p2,++p5,++p6,++p7]).

input_clause(c_1068,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,++p2,++p5]).

input_clause(c_1069,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,++p2,--p4,++p5,++p7]).

input_clause(c_1070,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,++p2,--p4,++p5,++p6]).

input_clause(c_1071,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,++p2,--p4,++p6,++p7]).

input_clause(c_1072,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,++p2,--p4]).

input_clause(c_1073,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,--p4,++p7]).

input_clause(c_1074,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,--p4,++p6]).

input_clause(c_1075,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,--p4,++p5,++p6,++p7]).

input_clause(c_1076,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,--p4,++p5]).

input_clause(c_1077,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,++p5,++p7]).

input_clause(c_1078,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,++p5,++p6]).

input_clause(c_1079,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,++p6,++p7]).

input_clause(c_1080,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7]).

input_clause(c_1081,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,--p3,++p7]).

input_clause(c_1082,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,--p3,++p6]).

input_clause(c_1083,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,--p3,++p5,++p6,++p7]).

input_clause(c_1084,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,--p3,++p5]).

input_clause(c_1085,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,--p3,--p4,++p5,++p7]).

input_clause(c_1086,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,--p3,--p4,++p5,++p6]).

input_clause(c_1087,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,--p3,--p4,++p6,++p7]).

input_clause(c_1088,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p7,--p3,--p4]).

input_clause(c_1089,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,--p3,--p4]).

input_clause(c_1090,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,--p3,--p4,++p6,--p7]).

input_clause(c_1091,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,--p3,--p4,++p5,++p6]).

input_clause(c_1092,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,--p3,--p4,++p5,--p7]).

input_clause(c_1093,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,--p3,++p5]).

input_clause(c_1094,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,--p3,++p5,++p6,--p7]).

input_clause(c_1095,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,--p3,++p6]).

input_clause(c_1096,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,--p3,--p7]).

input_clause(c_1097,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7]).

input_clause(c_1098,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,++p6,--p7]).

input_clause(c_1099,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,++p5,++p6]).

input_clause(c_1100,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,++p5,--p7]).

input_clause(c_1101,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,--p4,++p5]).

input_clause(c_1102,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,--p4,++p5,++p6,--p7]).

input_clause(c_1103,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,--p4,++p6]).

input_clause(c_1104,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,--p4,--p7]).

input_clause(c_1105,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,++p2,--p4]).

input_clause(c_1106,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,++p2,--p4,++p6,--p7]).

input_clause(c_1107,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,++p2,--p4,++p5,++p6]).

input_clause(c_1108,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,++p2,--p4,++p5,--p7]).

input_clause(c_1109,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,++p2,++p5]).

input_clause(c_1110,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,++p2,++p5,++p6,--p7]).

input_clause(c_1111,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,++p2,++p6]).

input_clause(c_1112,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,++p2,--p7]).

input_clause(c_1113,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,++p2,--p3]).

input_clause(c_1114,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,++p2,--p3,++p6,--p7]).

input_clause(c_1115,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,++p2,--p3,++p5,++p6]).

input_clause(c_1116,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,++p2,--p3,++p5,--p7]).

input_clause(c_1117,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,++p2,--p3,--p4,++p5]).

input_clause(c_1118,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,++p2,--p3,--p4,++p5,++p6,--p7]).

input_clause(c_1119,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,++p2,--p3,--p4,++p6]).

input_clause(c_1120,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,++p2,--p3,--p4,--p7]).

input_clause(c_1121,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,--p1,++p2,--p3,--p4]).

input_clause(c_1122,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,--p1,++p2,--p3,--p4,++p6,--p7]).

input_clause(c_1123,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,--p1,++p2,--p3,--p4,++p5,++p6]).

input_clause(c_1124,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,--p1,++p2,--p3,--p4,++p5,--p7]).

input_clause(c_1125,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,--p1,++p2,--p3,++p5]).

input_clause(c_1126,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,--p1,++p2,--p3,++p5,++p6,--p7]).

input_clause(c_1127,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,--p1,++p2,--p3,++p6]).

input_clause(c_1128,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,--p1,++p2,--p3,--p7]).

input_clause(c_1129,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,--p1,++p2]).

input_clause(c_1130,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,--p1,++p2,++p6,--p7]).

input_clause(c_1131,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,--p1,++p2,++p5,++p6]).

input_clause(c_1132,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,--p1,++p2,++p5,--p7]).

input_clause(c_1133,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,--p1,++p2,--p4,++p5]).

input_clause(c_1134,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,--p1,++p2,--p4,++p5,++p6,--p7]).

input_clause(c_1135,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,--p1,++p2,--p4,++p6]).

input_clause(c_1136,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,--p1,++p2,--p4,--p7]).

input_clause(c_1137,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,--p1,--p4]).

input_clause(c_1138,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,--p1,--p4,++p6,--p7]).

input_clause(c_1139,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,--p1,--p4,++p5,++p6]).

input_clause(c_1140,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,--p1,--p4,++p5,--p7]).

input_clause(c_1141,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,--p1,++p5]).

input_clause(c_1142,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,--p1,++p5,++p6,--p7]).

input_clause(c_1143,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,--p1,++p6]).

input_clause(c_1144,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,--p1,--p7]).

input_clause(c_1145,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,--p1,--p3]).

input_clause(c_1146,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,--p1,--p3,++p6,--p7]).

input_clause(c_1147,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,--p1,--p3,++p5,++p6]).

input_clause(c_1148,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,--p1,--p3,++p5,--p7]).

input_clause(c_1149,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,--p1,--p3,--p4,++p5]).

input_clause(c_1150,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,--p1,--p3,--p4,++p5,++p6,--p7]).

input_clause(c_1151,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,--p1,--p3,--p4,++p6]).

input_clause(c_1152,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p7,--p1,--p3,--p4,--p7]).

input_clause(c_1153,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,--p1,--p3,--p4,--p6]).

input_clause(c_1154,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,--p1,--p3,--p4,--p7]).

input_clause(c_1155,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,--p1,--p3,--p4,++p5]).

input_clause(c_1156,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,--p1,--p3,--p4,++p5,--p6,--p7]).

input_clause(c_1157,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,--p1,--p3,++p5,--p6]).

input_clause(c_1158,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,--p1,--p3,++p5,--p7]).

input_clause(c_1159,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,--p1,--p3]).

input_clause(c_1160,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,--p1,--p3,--p6,--p7]).

input_clause(c_1161,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,--p1,--p6]).

input_clause(c_1162,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,--p1,--p7]).

input_clause(c_1163,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,--p1,++p5]).

input_clause(c_1164,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,--p1,++p5,--p6,--p7]).

input_clause(c_1165,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,--p1,--p4,++p5,--p6]).

input_clause(c_1166,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,--p1,--p4,++p5,--p7]).

input_clause(c_1167,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,--p1,--p4]).

input_clause(c_1168,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,--p1,--p4,--p6,--p7]).

input_clause(c_1169,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,--p1,++p2,--p4,--p6]).

input_clause(c_1170,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,--p1,++p2,--p4,--p7]).

input_clause(c_1171,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,--p1,++p2,--p4,++p5]).

input_clause(c_1172,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,--p1,++p2,--p4,++p5,--p6,--p7]).

input_clause(c_1173,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,--p1,++p2,++p5,--p6]).

input_clause(c_1174,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,--p1,++p2,++p5,--p7]).

input_clause(c_1175,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,--p1,++p2]).

input_clause(c_1176,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,--p1,++p2,--p6,--p7]).

input_clause(c_1177,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,--p1,++p2,--p3,--p6]).

input_clause(c_1178,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,--p1,++p2,--p3,--p7]).

input_clause(c_1179,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,--p1,++p2,--p3,++p5]).

input_clause(c_1180,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,--p1,++p2,--p3,++p5,--p6,--p7]).

input_clause(c_1181,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,--p1,++p2,--p3,--p4,++p5,--p6]).

input_clause(c_1182,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,--p1,++p2,--p3,--p4,++p5,--p7]).

input_clause(c_1183,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,--p1,++p2,--p3,--p4]).

input_clause(c_1184,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,--p1,++p2,--p3,--p4,--p6,--p7]).

input_clause(c_1185,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,++p2,--p3,--p4,--p6]).

input_clause(c_1186,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,++p2,--p3,--p4,--p7]).

input_clause(c_1187,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,++p2,--p3,--p4,++p5]).

input_clause(c_1188,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,++p2,--p3,--p4,++p5,--p6,--p7]).

input_clause(c_1189,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,++p2,--p3,++p5,--p6]).

input_clause(c_1190,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,++p2,--p3,++p5,--p7]).

input_clause(c_1191,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,++p2,--p3]).

input_clause(c_1192,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,++p2,--p3,--p6,--p7]).

input_clause(c_1193,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,++p2,--p6]).

input_clause(c_1194,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,++p2,--p7]).

input_clause(c_1195,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,++p2,++p5]).

input_clause(c_1196,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,++p2,++p5,--p6,--p7]).

input_clause(c_1197,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,++p2,--p4,++p5,--p6]).

input_clause(c_1198,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,++p2,--p4,++p5,--p7]).

input_clause(c_1199,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,++p2,--p4]).

input_clause(c_1200,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,++p2,--p4,--p6,--p7]).

input_clause(c_1201,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,--p4,--p6]).

input_clause(c_1202,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,--p4,--p7]).

input_clause(c_1203,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,--p4,++p5]).

input_clause(c_1204,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,--p4,++p5,--p6,--p7]).

input_clause(c_1205,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,++p5,--p6]).

input_clause(c_1206,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,++p5,--p7]).

input_clause(c_1207,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7]).

input_clause(c_1208,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,--p6,--p7]).

input_clause(c_1209,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,--p3,--p6]).

input_clause(c_1210,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,--p3,--p7]).

input_clause(c_1211,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,--p3,++p5]).

input_clause(c_1212,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,--p3,++p5,--p6,--p7]).

input_clause(c_1213,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,--p3,--p4,++p5,--p6]).

input_clause(c_1214,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,--p3,--p4,++p5,--p7]).

input_clause(c_1215,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,--p3,--p4]).

input_clause(c_1216,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p7,--p3,--p4,--p6,--p7]).

input_clause(c_1217,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,--p3,--p4,--p6,++p7]).

input_clause(c_1218,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,--p3,--p4]).

input_clause(c_1219,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,--p3,--p4,++p5,++p7]).

input_clause(c_1220,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,--p3,--p4,++p5,--p6]).

input_clause(c_1221,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,--p3,++p5,--p6,++p7]).

input_clause(c_1222,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,--p3,++p5]).

input_clause(c_1223,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,--p3,++p7]).

input_clause(c_1224,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,--p3,--p6]).

input_clause(c_1225,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,--p6,++p7]).

input_clause(c_1226,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7]).

input_clause(c_1227,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,++p5,++p7]).

input_clause(c_1228,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,++p5,--p6]).

input_clause(c_1229,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,--p4,++p5,--p6,++p7]).

input_clause(c_1230,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,--p4,++p5]).

input_clause(c_1231,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,--p4,++p7]).

input_clause(c_1232,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,--p4,--p6]).

input_clause(c_1233,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,++p2,--p4,--p6,++p7]).

input_clause(c_1234,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,++p2,--p4]).

input_clause(c_1235,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,++p2,--p4,++p5,++p7]).

input_clause(c_1236,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,++p2,--p4,++p5,--p6]).

input_clause(c_1237,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,++p2,++p5,--p6,++p7]).

input_clause(c_1238,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,++p2,++p5]).

input_clause(c_1239,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,++p2,++p7]).

input_clause(c_1240,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,++p2,--p6]).

input_clause(c_1241,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,++p2,--p3,--p6,++p7]).

input_clause(c_1242,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,++p2,--p3]).

input_clause(c_1243,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,++p2,--p3,++p5,++p7]).

input_clause(c_1244,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,++p2,--p3,++p5,--p6]).

input_clause(c_1245,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,++p2,--p3,--p4,++p5,--p6,++p7]).

input_clause(c_1246,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,++p2,--p3,--p4,++p5]).

input_clause(c_1247,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,++p2,--p3,--p4,++p7]).

input_clause(c_1248,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,++p2,--p3,--p4,--p6]).

input_clause(c_1249,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,--p1,++p2,--p3,--p4,--p6,++p7]).

input_clause(c_1250,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,--p1,++p2,--p3,--p4]).

input_clause(c_1251,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,--p1,++p2,--p3,--p4,++p5,++p7]).

input_clause(c_1252,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,--p1,++p2,--p3,--p4,++p5,--p6]).

input_clause(c_1253,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,--p1,++p2,--p3,++p5,--p6,++p7]).

input_clause(c_1254,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,--p1,++p2,--p3,++p5]).

input_clause(c_1255,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,--p1,++p2,--p3,++p7]).

input_clause(c_1256,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,--p1,++p2,--p3,--p6]).

input_clause(c_1257,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,--p1,++p2,--p6,++p7]).

input_clause(c_1258,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,--p1,++p2]).

input_clause(c_1259,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,--p1,++p2,++p5,++p7]).

input_clause(c_1260,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,--p1,++p2,++p5,--p6]).

input_clause(c_1261,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,--p1,++p2,--p4,++p5,--p6,++p7]).

input_clause(c_1262,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,--p1,++p2,--p4,++p5]).

input_clause(c_1263,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,--p1,++p2,--p4,++p7]).

input_clause(c_1264,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,--p1,++p2,--p4,--p6]).

input_clause(c_1265,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,--p1,--p4,--p6,++p7]).

input_clause(c_1266,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,--p1,--p4]).

input_clause(c_1267,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,--p1,--p4,++p5,++p7]).

input_clause(c_1268,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,--p1,--p4,++p5,--p6]).

input_clause(c_1269,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,--p1,++p5,--p6,++p7]).

input_clause(c_1270,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,--p1,++p5]).

input_clause(c_1271,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,--p1,++p7]).

input_clause(c_1272,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,--p1,--p6]).

input_clause(c_1273,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,--p1,--p3,--p6,++p7]).

input_clause(c_1274,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,--p1,--p3]).

input_clause(c_1275,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,--p1,--p3,++p5,++p7]).

input_clause(c_1276,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,--p1,--p3,++p5,--p6]).

input_clause(c_1277,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,--p1,--p3,--p4,++p5,--p6,++p7]).

input_clause(c_1278,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,--p1,--p3,--p4,++p5]).

input_clause(c_1279,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,--p1,--p3,--p4,++p7]).

input_clause(c_1280,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p7,--p1,--p3,--p4,--p6]).

input_clause(c_1281,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,--p1,--p3,--p4,--p5,--p6,++p7]).

input_clause(c_1282,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,--p1,--p3,--p4,--p5]).

input_clause(c_1283,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,--p1,--p3,--p4,++p7]).

input_clause(c_1284,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,--p1,--p3,--p4,--p6]).

input_clause(c_1285,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,--p1,--p3,--p6,++p7]).

input_clause(c_1286,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,--p1,--p3]).

input_clause(c_1287,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,--p1,--p3,--p5,++p7]).

input_clause(c_1288,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,--p1,--p3,--p5,--p6]).

input_clause(c_1289,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,--p1,--p5,--p6,++p7]).

input_clause(c_1290,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,--p1,--p5]).

input_clause(c_1291,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,--p1,++p7]).

input_clause(c_1292,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,--p1,--p6]).

input_clause(c_1293,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,--p1,--p4,--p6,++p7]).

input_clause(c_1294,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,--p1,--p4]).

input_clause(c_1295,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,--p1,--p4,--p5,++p7]).

input_clause(c_1296,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,--p1,--p4,--p5,--p6]).

input_clause(c_1297,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,--p1,++p2,--p4,--p5,--p6,++p7]).

input_clause(c_1298,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,--p1,++p2,--p4,--p5]).

input_clause(c_1299,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,--p1,++p2,--p4,++p7]).

input_clause(c_1300,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,--p1,++p2,--p4,--p6]).

input_clause(c_1301,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,--p1,++p2,--p6,++p7]).

input_clause(c_1302,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,--p1,++p2]).

input_clause(c_1303,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,--p1,++p2,--p5,++p7]).

input_clause(c_1304,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,--p1,++p2,--p5,--p6]).

input_clause(c_1305,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,--p1,++p2,--p3,--p5,--p6,++p7]).

input_clause(c_1306,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,--p1,++p2,--p3,--p5]).

input_clause(c_1307,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,--p1,++p2,--p3,++p7]).

input_clause(c_1308,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,--p1,++p2,--p3,--p6]).

input_clause(c_1309,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,--p1,++p2,--p3,--p4,--p6,++p7]).

input_clause(c_1310,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,--p1,++p2,--p3,--p4]).

input_clause(c_1311,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,--p1,++p2,--p3,--p4,--p5,++p7]).

input_clause(c_1312,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,--p1,++p2,--p3,--p4,--p5,--p6]).

input_clause(c_1313,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,++p2,--p3,--p4,--p5,--p6,++p7]).

input_clause(c_1314,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,++p2,--p3,--p4,--p5]).

input_clause(c_1315,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,++p2,--p3,--p4,++p7]).

input_clause(c_1316,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,++p2,--p3,--p4,--p6]).

input_clause(c_1317,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,++p2,--p3,--p6,++p7]).

input_clause(c_1318,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,++p2,--p3]).

input_clause(c_1319,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,++p2,--p3,--p5,++p7]).

input_clause(c_1320,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,++p2,--p3,--p5,--p6]).

input_clause(c_1321,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,++p2,--p5,--p6,++p7]).

input_clause(c_1322,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,++p2,--p5]).

input_clause(c_1323,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,++p2,++p7]).

input_clause(c_1324,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,++p2,--p6]).

input_clause(c_1325,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,++p2,--p4,--p6,++p7]).

input_clause(c_1326,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,++p2,--p4]).

input_clause(c_1327,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,++p2,--p4,--p5,++p7]).

input_clause(c_1328,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,++p2,--p4,--p5,--p6]).

input_clause(c_1329,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,--p4,--p5,--p6,++p7]).

input_clause(c_1330,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,--p4,--p5]).

input_clause(c_1331,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,--p4,++p7]).

input_clause(c_1332,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,--p4,--p6]).

input_clause(c_1333,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,--p6,++p7]).

input_clause(c_1334,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7]).

input_clause(c_1335,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,--p5,++p7]).

input_clause(c_1336,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,--p5,--p6]).

input_clause(c_1337,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,--p3,--p5,--p6,++p7]).

input_clause(c_1338,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,--p3,--p5]).

input_clause(c_1339,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,--p3,++p7]).

input_clause(c_1340,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,--p3,--p6]).

input_clause(c_1341,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,--p3,--p4,--p6,++p7]).

input_clause(c_1342,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,--p3,--p4]).

input_clause(c_1343,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,--p3,--p4,--p5,++p7]).

input_clause(c_1344,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p7,--p3,--p4,--p5,--p6]).

input_clause(c_1345,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,--p3,--p4,--p5,--p6]).

input_clause(c_1346,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,--p3,--p4,--p5,--p7]).

input_clause(c_1347,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,--p3,--p4]).

input_clause(c_1348,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,--p3,--p4,--p6,--p7]).

input_clause(c_1349,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,--p3,--p6]).

input_clause(c_1350,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,--p3,--p7]).

input_clause(c_1351,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,--p3,--p5]).

input_clause(c_1352,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,--p3,--p5,--p6,--p7]).

input_clause(c_1353,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,--p5,--p6]).

input_clause(c_1354,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,--p5,--p7]).

input_clause(c_1355,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7]).

input_clause(c_1356,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,--p6,--p7]).

input_clause(c_1357,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,--p4,--p6]).

input_clause(c_1358,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,--p4,--p7]).

input_clause(c_1359,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,--p4,--p5]).

input_clause(c_1360,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,--p4,--p5,--p6,--p7]).

input_clause(c_1361,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,++p2,--p4,--p5,--p6]).

input_clause(c_1362,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,++p2,--p4,--p5,--p7]).

input_clause(c_1363,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,++p2,--p4]).

input_clause(c_1364,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,++p2,--p4,--p6,--p7]).

input_clause(c_1365,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,++p2,--p6]).

input_clause(c_1366,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,++p2,--p7]).

input_clause(c_1367,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,++p2,--p5]).

input_clause(c_1368,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,++p2,--p5,--p6,--p7]).

input_clause(c_1369,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,++p2,--p3,--p5,--p6]).

input_clause(c_1370,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,++p2,--p3,--p5,--p7]).

input_clause(c_1371,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,++p2,--p3]).

input_clause(c_1372,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,++p2,--p3,--p6,--p7]).

input_clause(c_1373,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,++p2,--p3,--p4,--p6]).

input_clause(c_1374,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,++p2,--p3,--p4,--p7]).

input_clause(c_1375,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,++p2,--p3,--p4,--p5]).

input_clause(c_1376,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,++p2,--p3,--p4,--p5,--p6,--p7]).

input_clause(c_1377,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,--p1,++p2,--p3,--p4,--p5,--p6]).

input_clause(c_1378,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,--p1,++p2,--p3,--p4,--p5,--p7]).

input_clause(c_1379,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,--p1,++p2,--p3,--p4]).

input_clause(c_1380,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,--p1,++p2,--p3,--p4,--p6,--p7]).

input_clause(c_1381,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,--p1,++p2,--p3,--p6]).

input_clause(c_1382,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,--p1,++p2,--p3,--p7]).

input_clause(c_1383,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,--p1,++p2,--p3,--p5]).

input_clause(c_1384,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,--p1,++p2,--p3,--p5,--p6,--p7]).

input_clause(c_1385,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,--p1,++p2,--p5,--p6]).

input_clause(c_1386,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,--p1,++p2,--p5,--p7]).

input_clause(c_1387,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,--p1,++p2]).

input_clause(c_1388,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,--p1,++p2,--p6,--p7]).

input_clause(c_1389,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,--p1,++p2,--p4,--p6]).

input_clause(c_1390,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,--p1,++p2,--p4,--p7]).

input_clause(c_1391,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,--p1,++p2,--p4,--p5]).

input_clause(c_1392,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,--p1,++p2,--p4,--p5,--p6,--p7]).

input_clause(c_1393,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,--p1,--p4,--p5,--p6]).

input_clause(c_1394,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,--p1,--p4,--p5,--p7]).

input_clause(c_1395,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,--p1,--p4]).

input_clause(c_1396,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,--p1,--p4,--p6,--p7]).

input_clause(c_1397,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,--p1,--p6]).

input_clause(c_1398,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,--p1,--p7]).

input_clause(c_1399,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,--p1,--p5]).

input_clause(c_1400,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,--p1,--p5,--p6,--p7]).

input_clause(c_1401,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,--p1,--p3,--p5,--p6]).

input_clause(c_1402,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,--p1,--p3,--p5,--p7]).

input_clause(c_1403,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,--p1,--p3]).

input_clause(c_1404,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,--p1,--p3,--p6,--p7]).

input_clause(c_1405,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,--p1,--p3,--p4,--p6]).

input_clause(c_1406,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,--p1,--p3,--p4,--p7]).

input_clause(c_1407,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,--p1,--p3,--p4,--p5]).

input_clause(c_1408,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p7,--p1,--p3,--p4,--p5,--p6,--p7]).

input_clause(c_1409,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,--p1,--p3,--p4,--p5]).

input_clause(c_1410,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,--p1,--p3,--p4,--p5,++p6,--p7]).

input_clause(c_1411,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,--p1,--p3,--p4,++p6]).

input_clause(c_1412,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,--p1,--p3,--p4,--p7]).

input_clause(c_1413,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,--p1,--p3]).

input_clause(c_1414,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,--p1,--p3,++p6,--p7]).

input_clause(c_1415,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,--p1,--p3,--p5,++p6]).

input_clause(c_1416,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,--p1,--p3,--p5,--p7]).

input_clause(c_1417,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,--p1,--p5]).

input_clause(c_1418,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,--p1,--p5,++p6,--p7]).

input_clause(c_1419,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,--p1,++p6]).

input_clause(c_1420,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,--p1,--p7]).

input_clause(c_1421,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,--p1,--p4]).

input_clause(c_1422,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,--p1,--p4,++p6,--p7]).

input_clause(c_1423,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,--p1,--p4,--p5,++p6]).

input_clause(c_1424,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,--p1,--p4,--p5,--p7]).

input_clause(c_1425,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,--p1,++p2,--p4,--p5]).

input_clause(c_1426,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,--p1,++p2,--p4,--p5,++p6,--p7]).

input_clause(c_1427,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,--p1,++p2,--p4,++p6]).

input_clause(c_1428,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,--p1,++p2,--p4,--p7]).

input_clause(c_1429,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,--p1,++p2]).

input_clause(c_1430,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,--p1,++p2,++p6,--p7]).

input_clause(c_1431,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,--p1,++p2,--p5,++p6]).

input_clause(c_1432,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,--p1,++p2,--p5,--p7]).

input_clause(c_1433,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,--p1,++p2,--p3,--p5]).

input_clause(c_1434,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,--p1,++p2,--p3,--p5,++p6,--p7]).

input_clause(c_1435,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,--p1,++p2,--p3,++p6]).

input_clause(c_1436,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,--p1,++p2,--p3,--p7]).

input_clause(c_1437,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,--p1,++p2,--p3,--p4]).

input_clause(c_1438,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,--p1,++p2,--p3,--p4,++p6,--p7]).

input_clause(c_1439,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,--p1,++p2,--p3,--p4,--p5,++p6]).

input_clause(c_1440,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,--p1,++p2,--p3,--p4,--p5,--p7]).

input_clause(c_1441,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,++p2,--p3,--p4,--p5]).

input_clause(c_1442,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,++p2,--p3,--p4,--p5,++p6,--p7]).

input_clause(c_1443,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,++p2,--p3,--p4,++p6]).

input_clause(c_1444,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,++p2,--p3,--p4,--p7]).

input_clause(c_1445,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,++p2,--p3]).

input_clause(c_1446,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,++p2,--p3,++p6,--p7]).

input_clause(c_1447,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,++p2,--p3,--p5,++p6]).

input_clause(c_1448,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,++p2,--p3,--p5,--p7]).

input_clause(c_1449,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,++p2,--p5]).

input_clause(c_1450,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,++p2,--p5,++p6,--p7]).

input_clause(c_1451,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,++p2,++p6]).

input_clause(c_1452,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,++p2,--p7]).

input_clause(c_1453,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,++p2,--p4]).

input_clause(c_1454,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,++p2,--p4,++p6,--p7]).

input_clause(c_1455,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,++p2,--p4,--p5,++p6]).

input_clause(c_1456,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,++p2,--p4,--p5,--p7]).

input_clause(c_1457,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,--p4,--p5]).

input_clause(c_1458,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,--p4,--p5,++p6,--p7]).

input_clause(c_1459,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,--p4,++p6]).

input_clause(c_1460,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,--p4,--p7]).

input_clause(c_1461,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7]).

input_clause(c_1462,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,++p6,--p7]).

input_clause(c_1463,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,--p5,++p6]).

input_clause(c_1464,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,--p5,--p7]).

input_clause(c_1465,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,--p3,--p5]).

input_clause(c_1466,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,--p3,--p5,++p6,--p7]).

input_clause(c_1467,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,--p3,++p6]).

input_clause(c_1468,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,--p3,--p7]).

input_clause(c_1469,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,--p3,--p4]).

input_clause(c_1470,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,--p3,--p4,++p6,--p7]).

input_clause(c_1471,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,--p3,--p4,--p5,++p6]).

input_clause(c_1472,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p7,--p3,--p4,--p5,--p7]).

input_clause(c_1473,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,--p3,--p4,--p5,++p7]).

input_clause(c_1474,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,--p3,--p4,--p5,++p6]).

input_clause(c_1475,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,--p3,--p4,++p6,++p7]).

input_clause(c_1476,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,--p3,--p4]).

input_clause(c_1477,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,--p3,++p7]).

input_clause(c_1478,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,--p3,++p6]).

input_clause(c_1479,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,--p3,--p5,++p6,++p7]).

input_clause(c_1480,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,--p3,--p5]).

input_clause(c_1481,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,--p5,++p7]).

input_clause(c_1482,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,--p5,++p6]).

input_clause(c_1483,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,++p6,++p7]).

input_clause(c_1484,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7]).

input_clause(c_1485,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,--p4,++p7]).

input_clause(c_1486,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,--p4,++p6]).

input_clause(c_1487,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,--p4,--p5,++p6,++p7]).

input_clause(c_1488,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,--p4,--p5]).

input_clause(c_1489,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,++p2,--p4,--p5,++p7]).

input_clause(c_1490,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,++p2,--p4,--p5,++p6]).

input_clause(c_1491,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,++p2,--p4,++p6,++p7]).

input_clause(c_1492,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,++p2,--p4]).

input_clause(c_1493,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,++p2,++p7]).

input_clause(c_1494,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,++p2,++p6]).

input_clause(c_1495,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,++p2,--p5,++p6,++p7]).

input_clause(c_1496,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,++p2,--p5]).

input_clause(c_1497,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,++p2,--p3,--p5,++p7]).

input_clause(c_1498,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,++p2,--p3,--p5,++p6]).

input_clause(c_1499,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,++p2,--p3,++p6,++p7]).

input_clause(c_1500,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,++p2,--p3]).

input_clause(c_1501,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,++p2,--p3,--p4,++p7]).

input_clause(c_1502,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,++p2,--p3,--p4,++p6]).

input_clause(c_1503,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,++p2,--p3,--p4,--p5,++p6,++p7]).

input_clause(c_1504,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,++p2,--p3,--p4,--p5]).

input_clause(c_1505,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,--p1,++p2,--p3,--p4,--p5,++p7]).

input_clause(c_1506,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,--p1,++p2,--p3,--p4,--p5,++p6]).

input_clause(c_1507,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,--p1,++p2,--p3,--p4,++p6,++p7]).

input_clause(c_1508,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,--p1,++p2,--p3,--p4]).

input_clause(c_1509,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,--p1,++p2,--p3,++p7]).

input_clause(c_1510,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,--p1,++p2,--p3,++p6]).

input_clause(c_1511,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,--p1,++p2,--p3,--p5,++p6,++p7]).

input_clause(c_1512,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,--p1,++p2,--p3,--p5]).

input_clause(c_1513,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,--p1,++p2,--p5,++p7]).

input_clause(c_1514,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,--p1,++p2,--p5,++p6]).

input_clause(c_1515,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,--p1,++p2,++p6,++p7]).

input_clause(c_1516,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,--p1,++p2]).

input_clause(c_1517,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,--p1,++p2,--p4,++p7]).

input_clause(c_1518,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,--p1,++p2,--p4,++p6]).

input_clause(c_1519,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,--p1,++p2,--p4,--p5,++p6,++p7]).

input_clause(c_1520,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,--p1,++p2,--p4,--p5]).

input_clause(c_1521,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,--p1,--p4,--p5,++p7]).

input_clause(c_1522,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,--p1,--p4,--p5,++p6]).

input_clause(c_1523,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,--p1,--p4,++p6,++p7]).

input_clause(c_1524,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,--p1,--p4]).

input_clause(c_1525,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,--p1,++p7]).

input_clause(c_1526,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,--p1,++p6]).

input_clause(c_1527,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,--p1,--p5,++p6,++p7]).

input_clause(c_1528,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,--p1,--p5]).

input_clause(c_1529,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,--p1,--p3,--p5,++p7]).

input_clause(c_1530,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,--p1,--p3,--p5,++p6]).

input_clause(c_1531,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,--p1,--p3,++p6,++p7]).

input_clause(c_1532,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,--p1,--p3]).

input_clause(c_1533,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,--p1,--p3,--p4,++p7]).

input_clause(c_1534,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,--p1,--p3,--p4,++p6]).

input_clause(c_1535,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,--p1,--p3,--p4,--p5,++p6,++p7]).

input_clause(c_1536,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p7,--p1,--p3,--p4,--p5]).

input_clause(c_1537,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,--p1,--p3,--p5,++p7]).

input_clause(c_1538,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,--p1,--p3,--p5,++p6]).

input_clause(c_1539,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,--p1,--p3,++p6,++p7]).

input_clause(c_1540,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,--p1,--p3]).

input_clause(c_1541,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,--p1,--p3,++p4,++p7]).

input_clause(c_1542,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,--p1,--p3,++p4,++p6]).

input_clause(c_1543,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,--p1,--p3,++p4,--p5,++p6,++p7]).

input_clause(c_1544,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,--p1,--p3,++p4,--p5]).

input_clause(c_1545,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,--p1,++p4,--p5,++p7]).

input_clause(c_1546,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,--p1,++p4,--p5,++p6]).

input_clause(c_1547,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,--p1,++p4,++p6,++p7]).

input_clause(c_1548,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,--p1,++p4]).

input_clause(c_1549,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,--p1,++p7]).

input_clause(c_1550,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,--p1,++p6]).

input_clause(c_1551,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,--p1,--p5,++p6,++p7]).

input_clause(c_1552,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,--p1,--p5]).

input_clause(c_1553,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,--p1,++p2,--p5,++p7]).

input_clause(c_1554,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,--p1,++p2,--p5,++p6]).

input_clause(c_1555,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,--p1,++p2,++p6,++p7]).

input_clause(c_1556,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,--p1,++p2]).

input_clause(c_1557,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,--p1,++p2,++p4,++p7]).

input_clause(c_1558,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,--p1,++p2,++p4,++p6]).

input_clause(c_1559,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,--p1,++p2,++p4,--p5,++p6,++p7]).

input_clause(c_1560,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,--p1,++p2,++p4,--p5]).

input_clause(c_1561,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,--p1,++p2,--p3,++p4,--p5,++p7]).

input_clause(c_1562,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,--p1,++p2,--p3,++p4,--p5,++p6]).

input_clause(c_1563,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,--p1,++p2,--p3,++p4,++p6,++p7]).

input_clause(c_1564,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,--p1,++p2,--p3,++p4]).

input_clause(c_1565,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,--p1,++p2,--p3,++p7]).

input_clause(c_1566,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,--p1,++p2,--p3,++p6]).

input_clause(c_1567,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,--p1,++p2,--p3,--p5,++p6,++p7]).

input_clause(c_1568,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,--p1,++p2,--p3,--p5]).

input_clause(c_1569,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,++p2,--p3,--p5,++p7]).

input_clause(c_1570,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,++p2,--p3,--p5,++p6]).

input_clause(c_1571,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,++p2,--p3,++p6,++p7]).

input_clause(c_1572,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,++p2,--p3]).

input_clause(c_1573,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,++p2,--p3,++p4,++p7]).

input_clause(c_1574,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,++p2,--p3,++p4,++p6]).

input_clause(c_1575,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,++p2,--p3,++p4,--p5,++p6,++p7]).

input_clause(c_1576,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,++p2,--p3,++p4,--p5]).

input_clause(c_1577,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,++p2,++p4,--p5,++p7]).

input_clause(c_1578,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,++p2,++p4,--p5,++p6]).

input_clause(c_1579,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,++p2,++p4,++p6,++p7]).

input_clause(c_1580,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,++p2,++p4]).

input_clause(c_1581,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,++p2,++p7]).

input_clause(c_1582,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,++p2,++p6]).

input_clause(c_1583,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,++p2,--p5,++p6,++p7]).

input_clause(c_1584,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,++p2,--p5]).

input_clause(c_1585,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,--p5,++p7]).

input_clause(c_1586,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,--p5,++p6]).

input_clause(c_1587,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,++p6,++p7]).

input_clause(c_1588,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7]).

input_clause(c_1589,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,++p4,++p7]).

input_clause(c_1590,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,++p4,++p6]).

input_clause(c_1591,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,++p4,--p5,++p6,++p7]).

input_clause(c_1592,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,++p4,--p5]).

input_clause(c_1593,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,--p3,++p4,--p5,++p7]).

input_clause(c_1594,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,--p3,++p4,--p5,++p6]).

input_clause(c_1595,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,--p3,++p4,++p6,++p7]).

input_clause(c_1596,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,--p3,++p4]).

input_clause(c_1597,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,--p3,++p7]).

input_clause(c_1598,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,--p3,++p6]).

input_clause(c_1599,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,--p3,--p5,++p6,++p7]).

input_clause(c_1600,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p7,--p3,--p5]).

input_clause(c_1601,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,--p3,--p5]).

input_clause(c_1602,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,--p3,--p5,++p6,--p7]).

input_clause(c_1603,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,--p3,++p6]).

input_clause(c_1604,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,--p3,--p7]).

input_clause(c_1605,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,--p3,++p4]).

input_clause(c_1606,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,--p3,++p4,++p6,--p7]).

input_clause(c_1607,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,--p3,++p4,--p5,++p6]).

input_clause(c_1608,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,--p3,++p4,--p5,--p7]).

input_clause(c_1609,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,++p4,--p5]).

input_clause(c_1610,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,++p4,--p5,++p6,--p7]).

input_clause(c_1611,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,++p4,++p6]).

input_clause(c_1612,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,++p4,--p7]).

input_clause(c_1613,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7]).

input_clause(c_1614,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,++p6,--p7]).

input_clause(c_1615,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,--p5,++p6]).

input_clause(c_1616,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,--p5,--p7]).

input_clause(c_1617,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,++p2,--p5]).

input_clause(c_1618,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,++p2,--p5,++p6,--p7]).

input_clause(c_1619,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,++p2,++p6]).

input_clause(c_1620,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,++p2,--p7]).

input_clause(c_1621,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,++p2,++p4]).

input_clause(c_1622,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,++p2,++p4,++p6,--p7]).

input_clause(c_1623,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,++p2,++p4,--p5,++p6]).

input_clause(c_1624,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,++p2,++p4,--p5,--p7]).

input_clause(c_1625,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,++p2,--p3,++p4,--p5]).

input_clause(c_1626,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,++p2,--p3,++p4,--p5,++p6,--p7]).

input_clause(c_1627,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,++p2,--p3,++p4,++p6]).

input_clause(c_1628,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,++p2,--p3,++p4,--p7]).

input_clause(c_1629,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,++p2,--p3]).

input_clause(c_1630,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,++p2,--p3,++p6,--p7]).

input_clause(c_1631,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,++p2,--p3,--p5,++p6]).

input_clause(c_1632,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,++p2,--p3,--p5,--p7]).

input_clause(c_1633,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,--p1,++p2,--p3,--p5]).

input_clause(c_1634,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,--p1,++p2,--p3,--p5,++p6,--p7]).

input_clause(c_1635,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,--p1,++p2,--p3,++p6]).

input_clause(c_1636,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,--p1,++p2,--p3,--p7]).

input_clause(c_1637,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,--p1,++p2,--p3,++p4]).

input_clause(c_1638,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,--p1,++p2,--p3,++p4,++p6,--p7]).

input_clause(c_1639,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,--p1,++p2,--p3,++p4,--p5,++p6]).

input_clause(c_1640,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,--p1,++p2,--p3,++p4,--p5,--p7]).

input_clause(c_1641,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,--p1,++p2,++p4,--p5]).

input_clause(c_1642,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,--p1,++p2,++p4,--p5,++p6,--p7]).

input_clause(c_1643,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,--p1,++p2,++p4,++p6]).

input_clause(c_1644,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,--p1,++p2,++p4,--p7]).

input_clause(c_1645,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,--p1,++p2]).

input_clause(c_1646,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,--p1,++p2,++p6,--p7]).

input_clause(c_1647,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,--p1,++p2,--p5,++p6]).

input_clause(c_1648,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,--p1,++p2,--p5,--p7]).

input_clause(c_1649,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,--p1,--p5]).

input_clause(c_1650,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,--p1,--p5,++p6,--p7]).

input_clause(c_1651,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,--p1,++p6]).

input_clause(c_1652,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,--p1,--p7]).

input_clause(c_1653,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,--p1,++p4]).

input_clause(c_1654,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,--p1,++p4,++p6,--p7]).

input_clause(c_1655,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,--p1,++p4,--p5,++p6]).

input_clause(c_1656,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,--p1,++p4,--p5,--p7]).

input_clause(c_1657,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,--p1,--p3,++p4,--p5]).

input_clause(c_1658,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,--p1,--p3,++p4,--p5,++p6,--p7]).

input_clause(c_1659,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,--p1,--p3,++p4,++p6]).

input_clause(c_1660,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,--p1,--p3,++p4,--p7]).

input_clause(c_1661,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,--p1,--p3]).

input_clause(c_1662,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,--p1,--p3,++p6,--p7]).

input_clause(c_1663,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,--p1,--p3,--p5,++p6]).

input_clause(c_1664,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p7,--p1,--p3,--p5,--p7]).

input_clause(c_1665,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,--p1,--p3,--p5,--p6]).

input_clause(c_1666,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,--p1,--p3,--p5,--p7]).

input_clause(c_1667,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,--p1,--p3]).

input_clause(c_1668,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,--p1,--p3,--p6,--p7]).

input_clause(c_1669,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,--p1,--p3,++p4,--p6]).

input_clause(c_1670,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,--p1,--p3,++p4,--p7]).

input_clause(c_1671,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,--p1,--p3,++p4,--p5]).

input_clause(c_1672,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,--p1,--p3,++p4,--p5,--p6,--p7]).

input_clause(c_1673,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,--p1,++p4,--p5,--p6]).

input_clause(c_1674,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,--p1,++p4,--p5,--p7]).

input_clause(c_1675,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,--p1,++p4]).

input_clause(c_1676,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,--p1,++p4,--p6,--p7]).

input_clause(c_1677,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,--p1,--p6]).

input_clause(c_1678,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,--p1,--p7]).

input_clause(c_1679,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,--p1,--p5]).

input_clause(c_1680,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,--p1,--p5,--p6,--p7]).

input_clause(c_1681,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,--p1,++p2,--p5,--p6]).

input_clause(c_1682,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,--p1,++p2,--p5,--p7]).

input_clause(c_1683,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,--p1,++p2]).

input_clause(c_1684,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,--p1,++p2,--p6,--p7]).

input_clause(c_1685,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,--p1,++p2,++p4,--p6]).

input_clause(c_1686,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,--p1,++p2,++p4,--p7]).

input_clause(c_1687,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,--p1,++p2,++p4,--p5]).

input_clause(c_1688,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,--p1,++p2,++p4,--p5,--p6,--p7]).

input_clause(c_1689,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,--p1,++p2,--p3,++p4,--p5,--p6]).

input_clause(c_1690,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,--p1,++p2,--p3,++p4,--p5,--p7]).

input_clause(c_1691,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,--p1,++p2,--p3,++p4]).

input_clause(c_1692,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,--p1,++p2,--p3,++p4,--p6,--p7]).

input_clause(c_1693,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,--p1,++p2,--p3,--p6]).

input_clause(c_1694,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,--p1,++p2,--p3,--p7]).

input_clause(c_1695,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,--p1,++p2,--p3,--p5]).

input_clause(c_1696,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,--p1,++p2,--p3,--p5,--p6,--p7]).

input_clause(c_1697,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,++p2,--p3,--p5,--p6]).

input_clause(c_1698,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,++p2,--p3,--p5,--p7]).

input_clause(c_1699,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,++p2,--p3]).

input_clause(c_1700,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,++p2,--p3,--p6,--p7]).

input_clause(c_1701,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,++p2,--p3,++p4,--p6]).

input_clause(c_1702,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,++p2,--p3,++p4,--p7]).

input_clause(c_1703,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,++p2,--p3,++p4,--p5]).

input_clause(c_1704,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,++p2,--p3,++p4,--p5,--p6,--p7]).

input_clause(c_1705,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,++p2,++p4,--p5,--p6]).

input_clause(c_1706,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,++p2,++p4,--p5,--p7]).

input_clause(c_1707,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,++p2,++p4]).

input_clause(c_1708,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,++p2,++p4,--p6,--p7]).

input_clause(c_1709,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,++p2,--p6]).

input_clause(c_1710,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,++p2,--p7]).

input_clause(c_1711,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,++p2,--p5]).

input_clause(c_1712,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,++p2,--p5,--p6,--p7]).

input_clause(c_1713,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,--p5,--p6]).

input_clause(c_1714,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,--p5,--p7]).

input_clause(c_1715,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7]).

input_clause(c_1716,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,--p6,--p7]).

input_clause(c_1717,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,++p4,--p6]).

input_clause(c_1718,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,++p4,--p7]).

input_clause(c_1719,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,++p4,--p5]).

input_clause(c_1720,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,++p4,--p5,--p6,--p7]).

input_clause(c_1721,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,--p3,++p4,--p5,--p6]).

input_clause(c_1722,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,--p3,++p4,--p5,--p7]).

input_clause(c_1723,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,--p3,++p4]).

input_clause(c_1724,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,--p3,++p4,--p6,--p7]).

input_clause(c_1725,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,--p3,--p6]).

input_clause(c_1726,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,--p3,--p7]).

input_clause(c_1727,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,--p3,--p5]).

input_clause(c_1728,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p7,--p3,--p5,--p6,--p7]).

input_clause(c_1729,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,--p3,--p5,--p6,++p7]).

input_clause(c_1730,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,--p3,--p5]).

input_clause(c_1731,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,--p3,++p7]).

input_clause(c_1732,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,--p3,--p6]).

input_clause(c_1733,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,--p3,++p4,--p6,++p7]).

input_clause(c_1734,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,--p3,++p4]).

input_clause(c_1735,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,--p3,++p4,--p5,++p7]).

input_clause(c_1736,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,--p3,++p4,--p5,--p6]).

input_clause(c_1737,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,++p4,--p5,--p6,++p7]).

input_clause(c_1738,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,++p4,--p5]).

input_clause(c_1739,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,++p4,++p7]).

input_clause(c_1740,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,++p4,--p6]).

input_clause(c_1741,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,--p6,++p7]).

input_clause(c_1742,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7]).

input_clause(c_1743,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,--p5,++p7]).

input_clause(c_1744,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,--p5,--p6]).

input_clause(c_1745,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,++p2,--p5,--p6,++p7]).

input_clause(c_1746,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,++p2,--p5]).

input_clause(c_1747,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,++p2,++p7]).

input_clause(c_1748,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,++p2,--p6]).

input_clause(c_1749,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,++p2,++p4,--p6,++p7]).

input_clause(c_1750,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,++p2,++p4]).

input_clause(c_1751,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,++p2,++p4,--p5,++p7]).

input_clause(c_1752,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,++p2,++p4,--p5,--p6]).

input_clause(c_1753,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,++p2,--p3,++p4,--p5,--p6,++p7]).

input_clause(c_1754,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,++p2,--p3,++p4,--p5]).

input_clause(c_1755,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,++p2,--p3,++p4,++p7]).

input_clause(c_1756,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,++p2,--p3,++p4,--p6]).

input_clause(c_1757,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,++p2,--p3,--p6,++p7]).

input_clause(c_1758,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,++p2,--p3]).

input_clause(c_1759,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,++p2,--p3,--p5,++p7]).

input_clause(c_1760,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,++p2,--p3,--p5,--p6]).

input_clause(c_1761,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,--p1,++p2,--p3,--p5,--p6,++p7]).

input_clause(c_1762,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,--p1,++p2,--p3,--p5]).

input_clause(c_1763,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,--p1,++p2,--p3,++p7]).

input_clause(c_1764,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,--p1,++p2,--p3,--p6]).

input_clause(c_1765,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,--p1,++p2,--p3,++p4,--p6,++p7]).

input_clause(c_1766,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,--p1,++p2,--p3,++p4]).

input_clause(c_1767,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,--p1,++p2,--p3,++p4,--p5,++p7]).

input_clause(c_1768,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,--p1,++p2,--p3,++p4,--p5,--p6]).

input_clause(c_1769,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,--p1,++p2,++p4,--p5,--p6,++p7]).

input_clause(c_1770,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,--p1,++p2,++p4,--p5]).

input_clause(c_1771,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,--p1,++p2,++p4,++p7]).

input_clause(c_1772,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,--p1,++p2,++p4,--p6]).

input_clause(c_1773,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,--p1,++p2,--p6,++p7]).

input_clause(c_1774,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,--p1,++p2]).

input_clause(c_1775,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,--p1,++p2,--p5,++p7]).

input_clause(c_1776,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,--p1,++p2,--p5,--p6]).

input_clause(c_1777,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,--p1,--p5,--p6,++p7]).

input_clause(c_1778,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,--p1,--p5]).

input_clause(c_1779,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,--p1,++p7]).

input_clause(c_1780,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,--p1,--p6]).

input_clause(c_1781,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,--p1,++p4,--p6,++p7]).

input_clause(c_1782,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,--p1,++p4]).

input_clause(c_1783,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,--p1,++p4,--p5,++p7]).

input_clause(c_1784,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,--p1,++p4,--p5,--p6]).

input_clause(c_1785,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,--p1,--p3,++p4,--p5,--p6,++p7]).

input_clause(c_1786,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,--p1,--p3,++p4,--p5]).

input_clause(c_1787,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,--p1,--p3,++p4,++p7]).

input_clause(c_1788,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,--p1,--p3,++p4,--p6]).

input_clause(c_1789,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,--p1,--p3,--p6,++p7]).

input_clause(c_1790,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,--p1,--p3]).

input_clause(c_1791,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,--p1,--p3,--p5,++p7]).

input_clause(c_1792,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p7,--p1,--p3,--p5,--p6]).

input_clause(c_1793,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,--p1,--p3,--p6,++p7]).

input_clause(c_1794,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,--p1,--p3]).

input_clause(c_1795,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,--p1,--p3,++p5,++p7]).

input_clause(c_1796,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,--p1,--p3,++p5,--p6]).

input_clause(c_1797,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,--p1,--p3,++p4,++p5,--p6,++p7]).

input_clause(c_1798,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,--p1,--p3,++p4,++p5]).

input_clause(c_1799,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,--p1,--p3,++p4,++p7]).

input_clause(c_1800,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,--p1,--p3,++p4,--p6]).

input_clause(c_1801,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,--p1,++p4,--p6,++p7]).

input_clause(c_1802,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,--p1,++p4]).

input_clause(c_1803,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,--p1,++p4,++p5,++p7]).

input_clause(c_1804,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,--p1,++p4,++p5,--p6]).

input_clause(c_1805,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,--p1,++p5,--p6,++p7]).

input_clause(c_1806,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,--p1,++p5]).

input_clause(c_1807,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,--p1,++p7]).

input_clause(c_1808,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,--p1,--p6]).

input_clause(c_1809,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,--p1,++p2,--p6,++p7]).

input_clause(c_1810,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,--p1,++p2]).

input_clause(c_1811,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,--p1,++p2,++p5,++p7]).

input_clause(c_1812,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,--p1,++p2,++p5,--p6]).

input_clause(c_1813,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,--p1,++p2,++p4,++p5,--p6,++p7]).

input_clause(c_1814,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,--p1,++p2,++p4,++p5]).

input_clause(c_1815,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,--p1,++p2,++p4,++p7]).

input_clause(c_1816,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,--p1,++p2,++p4,--p6]).

input_clause(c_1817,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,--p1,++p2,--p3,++p4,--p6,++p7]).

input_clause(c_1818,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,--p1,++p2,--p3,++p4]).

input_clause(c_1819,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,--p1,++p2,--p3,++p4,++p5,++p7]).

input_clause(c_1820,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,--p1,++p2,--p3,++p4,++p5,--p6]).

input_clause(c_1821,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,--p1,++p2,--p3,++p5,--p6,++p7]).

input_clause(c_1822,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,--p1,++p2,--p3,++p5]).

input_clause(c_1823,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,--p1,++p2,--p3,++p7]).

input_clause(c_1824,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,--p1,++p2,--p3,--p6]).

input_clause(c_1825,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,++p2,--p3,--p6,++p7]).

input_clause(c_1826,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,++p2,--p3]).

input_clause(c_1827,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,++p2,--p3,++p5,++p7]).

input_clause(c_1828,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,++p2,--p3,++p5,--p6]).

input_clause(c_1829,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,++p2,--p3,++p4,++p5,--p6,++p7]).

input_clause(c_1830,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,++p2,--p3,++p4,++p5]).

input_clause(c_1831,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,++p2,--p3,++p4,++p7]).

input_clause(c_1832,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,++p2,--p3,++p4,--p6]).

input_clause(c_1833,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,++p2,++p4,--p6,++p7]).

input_clause(c_1834,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,++p2,++p4]).

input_clause(c_1835,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,++p2,++p4,++p5,++p7]).

input_clause(c_1836,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,++p2,++p4,++p5,--p6]).

input_clause(c_1837,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,++p2,++p5,--p6,++p7]).

input_clause(c_1838,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,++p2,++p5]).

input_clause(c_1839,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,++p2,++p7]).

input_clause(c_1840,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,++p2,--p6]).

input_clause(c_1841,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,--p6,++p7]).

input_clause(c_1842,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7]).

input_clause(c_1843,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,++p5,++p7]).

input_clause(c_1844,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,++p5,--p6]).

input_clause(c_1845,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,++p4,++p5,--p6,++p7]).

input_clause(c_1846,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,++p4,++p5]).

input_clause(c_1847,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,++p4,++p7]).

input_clause(c_1848,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,++p4,--p6]).

input_clause(c_1849,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,--p3,++p4,--p6,++p7]).

input_clause(c_1850,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,--p3,++p4]).

input_clause(c_1851,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,--p3,++p4,++p5,++p7]).

input_clause(c_1852,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,--p3,++p4,++p5,--p6]).

input_clause(c_1853,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,--p3,++p5,--p6,++p7]).

input_clause(c_1854,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,--p3,++p5]).

input_clause(c_1855,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,--p3,++p7]).

input_clause(c_1856,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p7,--p3,--p6]).

input_clause(c_1857,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,--p3,--p6]).

input_clause(c_1858,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,--p3,--p7]).

input_clause(c_1859,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,--p3,++p5]).

input_clause(c_1860,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,--p3,++p5,--p6,--p7]).

input_clause(c_1861,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,--p3,++p4,++p5,--p6]).

input_clause(c_1862,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,--p3,++p4,++p5,--p7]).

input_clause(c_1863,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,--p3,++p4]).

input_clause(c_1864,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,--p3,++p4,--p6,--p7]).

input_clause(c_1865,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,++p4,--p6]).

input_clause(c_1866,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,++p4,--p7]).

input_clause(c_1867,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,++p4,++p5]).

input_clause(c_1868,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,++p4,++p5,--p6,--p7]).

input_clause(c_1869,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,++p5,--p6]).

input_clause(c_1870,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,++p5,--p7]).

input_clause(c_1871,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7]).

input_clause(c_1872,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,--p6,--p7]).

input_clause(c_1873,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,++p2,--p6]).

input_clause(c_1874,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,++p2,--p7]).

input_clause(c_1875,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,++p2,++p5]).

input_clause(c_1876,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,++p2,++p5,--p6,--p7]).

input_clause(c_1877,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,++p2,++p4,++p5,--p6]).

input_clause(c_1878,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,++p2,++p4,++p5,--p7]).

input_clause(c_1879,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,++p2,++p4]).

input_clause(c_1880,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,++p2,++p4,--p6,--p7]).

input_clause(c_1881,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,++p2,--p3,++p4,--p6]).

input_clause(c_1882,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,++p2,--p3,++p4,--p7]).

input_clause(c_1883,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,++p2,--p3,++p4,++p5]).

input_clause(c_1884,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,++p2,--p3,++p4,++p5,--p6,--p7]).

input_clause(c_1885,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,++p2,--p3,++p5,--p6]).

input_clause(c_1886,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,++p2,--p3,++p5,--p7]).

input_clause(c_1887,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,++p2,--p3]).

input_clause(c_1888,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,++p2,--p3,--p6,--p7]).

input_clause(c_1889,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,--p1,++p2,--p3,--p6]).

input_clause(c_1890,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,--p1,++p2,--p3,--p7]).

input_clause(c_1891,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,--p1,++p2,--p3,++p5]).

input_clause(c_1892,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,--p1,++p2,--p3,++p5,--p6,--p7]).

input_clause(c_1893,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,--p1,++p2,--p3,++p4,++p5,--p6]).

input_clause(c_1894,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,--p1,++p2,--p3,++p4,++p5,--p7]).

input_clause(c_1895,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,--p1,++p2,--p3,++p4]).

input_clause(c_1896,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,--p1,++p2,--p3,++p4,--p6,--p7]).

input_clause(c_1897,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,--p1,++p2,++p4,--p6]).

input_clause(c_1898,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,--p1,++p2,++p4,--p7]).

input_clause(c_1899,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,--p1,++p2,++p4,++p5]).

input_clause(c_1900,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,--p1,++p2,++p4,++p5,--p6,--p7]).

input_clause(c_1901,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,--p1,++p2,++p5,--p6]).

input_clause(c_1902,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,--p1,++p2,++p5,--p7]).

input_clause(c_1903,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,--p1,++p2]).

input_clause(c_1904,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,--p1,++p2,--p6,--p7]).

input_clause(c_1905,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,--p1,--p6]).

input_clause(c_1906,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,--p1,--p7]).

input_clause(c_1907,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,--p1,++p5]).

input_clause(c_1908,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,--p1,++p5,--p6,--p7]).

input_clause(c_1909,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,--p1,++p4,++p5,--p6]).

input_clause(c_1910,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,--p1,++p4,++p5,--p7]).

input_clause(c_1911,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,--p1,++p4]).

input_clause(c_1912,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,--p1,++p4,--p6,--p7]).

input_clause(c_1913,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,--p1,--p3,++p4,--p6]).

input_clause(c_1914,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,--p1,--p3,++p4,--p7]).

input_clause(c_1915,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,--p1,--p3,++p4,++p5]).

input_clause(c_1916,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,--p1,--p3,++p4,++p5,--p6,--p7]).

input_clause(c_1917,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,--p1,--p3,++p5,--p6]).

input_clause(c_1918,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,--p1,--p3,++p5,--p7]).

input_clause(c_1919,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,--p1,--p3]).

input_clause(c_1920,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p7,--p1,--p3,--p6,--p7]).

input_clause(c_1921,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,--p1,--p3]).

input_clause(c_1922,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,--p1,--p3,++p6,--p7]).

input_clause(c_1923,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,--p1,--p3,++p5,++p6]).

input_clause(c_1924,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,--p1,--p3,++p5,--p7]).

input_clause(c_1925,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,--p1,--p3,++p4,++p5]).

input_clause(c_1926,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,--p1,--p3,++p4,++p5,++p6,--p7]).

input_clause(c_1927,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,--p1,--p3,++p4,++p6]).

input_clause(c_1928,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,--p1,--p3,++p4,--p7]).

input_clause(c_1929,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,--p1,++p4]).

input_clause(c_1930,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,--p1,++p4,++p6,--p7]).

input_clause(c_1931,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,--p1,++p4,++p5,++p6]).

input_clause(c_1932,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,--p1,++p4,++p5,--p7]).

input_clause(c_1933,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,--p1,++p5]).

input_clause(c_1934,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,--p1,++p5,++p6,--p7]).

input_clause(c_1935,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,--p1,++p6]).

input_clause(c_1936,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,--p1,--p7]).

input_clause(c_1937,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,--p1,++p2]).

input_clause(c_1938,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,--p1,++p2,++p6,--p7]).

input_clause(c_1939,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,--p1,++p2,++p5,++p6]).

input_clause(c_1940,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,--p1,++p2,++p5,--p7]).

input_clause(c_1941,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,--p1,++p2,++p4,++p5]).

input_clause(c_1942,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,--p1,++p2,++p4,++p5,++p6,--p7]).

input_clause(c_1943,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,--p1,++p2,++p4,++p6]).

input_clause(c_1944,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,--p1,++p2,++p4,--p7]).

input_clause(c_1945,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,--p1,++p2,--p3,++p4]).

input_clause(c_1946,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,--p1,++p2,--p3,++p4,++p6,--p7]).

input_clause(c_1947,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,--p1,++p2,--p3,++p4,++p5,++p6]).

input_clause(c_1948,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,--p1,++p2,--p3,++p4,++p5,--p7]).

input_clause(c_1949,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,--p1,++p2,--p3,++p5]).

input_clause(c_1950,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,--p1,++p2,--p3,++p5,++p6,--p7]).

input_clause(c_1951,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,--p1,++p2,--p3,++p6]).

input_clause(c_1952,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,--p1,++p2,--p3,--p7]).

input_clause(c_1953,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,++p2,--p3]).

input_clause(c_1954,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,++p2,--p3,++p6,--p7]).

input_clause(c_1955,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,++p2,--p3,++p5,++p6]).

input_clause(c_1956,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,++p2,--p3,++p5,--p7]).

input_clause(c_1957,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,++p2,--p3,++p4,++p5]).

input_clause(c_1958,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,++p2,--p3,++p4,++p5,++p6,--p7]).

input_clause(c_1959,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,++p2,--p3,++p4,++p6]).

input_clause(c_1960,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,++p2,--p3,++p4,--p7]).

input_clause(c_1961,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,++p2,++p4]).

input_clause(c_1962,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,++p2,++p4,++p6,--p7]).

input_clause(c_1963,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,++p2,++p4,++p5,++p6]).

input_clause(c_1964,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,++p2,++p4,++p5,--p7]).

input_clause(c_1965,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,++p2,++p5]).

input_clause(c_1966,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,++p2,++p5,++p6,--p7]).

input_clause(c_1967,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,++p2,++p6]).

input_clause(c_1968,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,++p2,--p7]).

input_clause(c_1969,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7]).

input_clause(c_1970,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,++p6,--p7]).

input_clause(c_1971,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,++p5,++p6]).

input_clause(c_1972,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,++p5,--p7]).

input_clause(c_1973,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,++p4,++p5]).

input_clause(c_1974,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,++p4,++p5,++p6,--p7]).

input_clause(c_1975,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,++p4,++p6]).

input_clause(c_1976,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,++p4,--p7]).

input_clause(c_1977,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,--p3,++p4]).

input_clause(c_1978,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,--p3,++p4,++p6,--p7]).

input_clause(c_1979,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,--p3,++p4,++p5,++p6]).

input_clause(c_1980,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,--p3,++p4,++p5,--p7]).

input_clause(c_1981,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,--p3,++p5]).

input_clause(c_1982,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,--p3,++p5,++p6,--p7]).

input_clause(c_1983,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,--p3,++p6]).

input_clause(c_1984,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p7,--p3,--p7]).

input_clause(c_1985,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,--p3,++p7]).

input_clause(c_1986,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,--p3,++p6]).

input_clause(c_1987,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,--p3,++p5,++p6,++p7]).

input_clause(c_1988,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,--p3,++p5]).

input_clause(c_1989,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,--p3,++p4,++p5,++p7]).

input_clause(c_1990,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,--p3,++p4,++p5,++p6]).

input_clause(c_1991,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,--p3,++p4,++p6,++p7]).

input_clause(c_1992,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,--p3,++p4]).

input_clause(c_1993,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,++p4,++p7]).

input_clause(c_1994,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,++p4,++p6]).

input_clause(c_1995,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,++p4,++p5,++p6,++p7]).

input_clause(c_1996,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,++p4,++p5]).

input_clause(c_1997,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,++p5,++p7]).

input_clause(c_1998,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,++p5,++p6]).

input_clause(c_1999,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,++p6,++p7]).

input_clause(c_2000,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7]).

input_clause(c_2001,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,++p2,++p7]).

input_clause(c_2002,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,++p2,++p6]).

input_clause(c_2003,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,++p2,++p5,++p6,++p7]).

input_clause(c_2004,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,++p2,++p5]).

input_clause(c_2005,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,++p2,++p4,++p5,++p7]).

input_clause(c_2006,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,++p2,++p4,++p5,++p6]).

input_clause(c_2007,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,++p2,++p4,++p6,++p7]).

input_clause(c_2008,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,++p2,++p4]).

input_clause(c_2009,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,++p2,--p3,++p4,++p7]).

input_clause(c_2010,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,++p2,--p3,++p4,++p6]).

input_clause(c_2011,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,++p2,--p3,++p4,++p5,++p6,++p7]).

input_clause(c_2012,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,++p2,--p3,++p4,++p5]).

input_clause(c_2013,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,++p2,--p3,++p5,++p7]).

input_clause(c_2014,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,++p2,--p3,++p5,++p6]).

input_clause(c_2015,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,++p2,--p3,++p6,++p7]).

input_clause(c_2016,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,++p2,--p3]).

input_clause(c_2017,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,--p1,++p2,--p3,++p7]).

input_clause(c_2018,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,--p1,++p2,--p3,++p6]).

input_clause(c_2019,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,--p1,++p2,--p3,++p5,++p6,++p7]).

input_clause(c_2020,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,--p1,++p2,--p3,++p5]).

input_clause(c_2021,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,--p1,++p2,--p3,++p4,++p5,++p7]).

input_clause(c_2022,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,--p1,++p2,--p3,++p4,++p5,++p6]).

input_clause(c_2023,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,--p1,++p2,--p3,++p4,++p6,++p7]).

input_clause(c_2024,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,--p1,++p2,--p3,++p4]).

input_clause(c_2025,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,--p1,++p2,++p4,++p7]).

input_clause(c_2026,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,--p1,++p2,++p4,++p6]).

input_clause(c_2027,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,--p1,++p2,++p4,++p5,++p6,++p7]).

input_clause(c_2028,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,--p1,++p2,++p4,++p5]).

input_clause(c_2029,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,--p1,++p2,++p5,++p7]).

input_clause(c_2030,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,--p1,++p2,++p5,++p6]).

input_clause(c_2031,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,--p1,++p2,++p6,++p7]).

input_clause(c_2032,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,--p1,++p2]).

input_clause(c_2033,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,--p1,++p7]).

input_clause(c_2034,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,--p1,++p6]).

input_clause(c_2035,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,--p1,++p5,++p6,++p7]).

input_clause(c_2036,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,--p1,++p5]).

input_clause(c_2037,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,--p1,++p4,++p5,++p7]).

input_clause(c_2038,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,--p1,++p4,++p5,++p6]).

input_clause(c_2039,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,--p1,++p4,++p6,++p7]).

input_clause(c_2040,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,--p1,++p4]).

input_clause(c_2041,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,--p1,--p3,++p4,++p7]).

input_clause(c_2042,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,--p1,--p3,++p4,++p6]).

input_clause(c_2043,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,--p1,--p3,++p4,++p5,++p6,++p7]).

input_clause(c_2044,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,--p1,--p3,++p4,++p5]).

input_clause(c_2045,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,--p1,--p3,++p5,++p7]).

input_clause(c_2046,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,--p1,--p3,++p5,++p6]).

input_clause(c_2047,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,--p1,--p3,++p6,++p7]).

input_clause(c_2048,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p7,--p1,--p3]).

input_clause(c_2049,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,--p1,--p2,--p3,++p7]).

input_clause(c_2050,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,--p1,--p2,--p3,++p6]).

input_clause(c_2051,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,--p1,--p2,--p3,++p5,++p6,++p7]).

input_clause(c_2052,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,--p1,--p2,--p3,++p5]).

input_clause(c_2053,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,--p1,--p2,--p3,++p4,++p5,++p7]).

input_clause(c_2054,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,--p1,--p2,--p3,++p4,++p5,++p6]).

input_clause(c_2055,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,--p1,--p2,--p3,++p4,++p6,++p7]).

input_clause(c_2056,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,--p1,--p2,--p3,++p4]).

input_clause(c_2057,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,--p1,--p2,++p4,++p7]).

input_clause(c_2058,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,--p1,--p2,++p4,++p6]).

input_clause(c_2059,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,--p1,--p2,++p4,++p5,++p6,++p7]).

input_clause(c_2060,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,--p1,--p2,++p4,++p5]).

input_clause(c_2061,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,--p1,--p2,++p5,++p7]).

input_clause(c_2062,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,--p1,--p2,++p5,++p6]).

input_clause(c_2063,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,--p1,--p2,++p6,++p7]).

input_clause(c_2064,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,--p1,--p2]).

input_clause(c_2065,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,--p1,++p7]).

input_clause(c_2066,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,--p1,++p6]).

input_clause(c_2067,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,--p1,++p5,++p6,++p7]).

input_clause(c_2068,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,--p1,++p5]).

input_clause(c_2069,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,--p1,++p4,++p5,++p7]).

input_clause(c_2070,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,--p1,++p4,++p5,++p6]).

input_clause(c_2071,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,--p1,++p4,++p6,++p7]).

input_clause(c_2072,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,--p1,++p4]).

input_clause(c_2073,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,--p1,--p3,++p4,++p7]).

input_clause(c_2074,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,--p1,--p3,++p4,++p6]).

input_clause(c_2075,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,--p1,--p3,++p4,++p5,++p6,++p7]).

input_clause(c_2076,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,--p1,--p3,++p4,++p5]).

input_clause(c_2077,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,--p1,--p3,++p5,++p7]).

input_clause(c_2078,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,--p1,--p3,++p5,++p6]).

input_clause(c_2079,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,--p1,--p3,++p6,++p7]).

input_clause(c_2080,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,--p1,--p3]).

input_clause(c_2081,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,--p3,++p7]).

input_clause(c_2082,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,--p3,++p6]).

input_clause(c_2083,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,--p3,++p5,++p6,++p7]).

input_clause(c_2084,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,--p3,++p5]).

input_clause(c_2085,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,--p3,++p4,++p5,++p7]).

input_clause(c_2086,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,--p3,++p4,++p5,++p6]).

input_clause(c_2087,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,--p3,++p4,++p6,++p7]).

input_clause(c_2088,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,--p3,++p4]).

input_clause(c_2089,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,++p4,++p7]).

input_clause(c_2090,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,++p4,++p6]).

input_clause(c_2091,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,++p4,++p5,++p6,++p7]).

input_clause(c_2092,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,++p4,++p5]).

input_clause(c_2093,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,++p5,++p7]).

input_clause(c_2094,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,++p5,++p6]).

input_clause(c_2095,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,++p6,++p7]).

input_clause(c_2096,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7]).

input_clause(c_2097,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,--p2,++p7]).

input_clause(c_2098,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,--p2,++p6]).

input_clause(c_2099,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,--p2,++p5,++p6,++p7]).

input_clause(c_2100,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,--p2,++p5]).

input_clause(c_2101,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,--p2,++p4,++p5,++p7]).

input_clause(c_2102,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,--p2,++p4,++p5,++p6]).

input_clause(c_2103,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,--p2,++p4,++p6,++p7]).

input_clause(c_2104,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,--p2,++p4]).

input_clause(c_2105,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,--p2,--p3,++p4,++p7]).

input_clause(c_2106,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,--p2,--p3,++p4,++p6]).

input_clause(c_2107,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,--p2,--p3,++p4,++p5,++p6,++p7]).

input_clause(c_2108,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,--p2,--p3,++p4,++p5]).

input_clause(c_2109,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,--p2,--p3,++p5,++p7]).

input_clause(c_2110,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,--p2,--p3,++p5,++p6]).

input_clause(c_2111,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,--p2,--p3,++p6,++p7]).

input_clause(c_2112,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p7,--p2,--p3]).

input_clause(c_2113,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,--p2,--p3]).

input_clause(c_2114,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,--p2,--p3,++p6,--p7]).

input_clause(c_2115,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,--p2,--p3,++p5,++p6]).

input_clause(c_2116,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,--p2,--p3,++p5,--p7]).

input_clause(c_2117,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,--p2,--p3,++p4,++p5]).

input_clause(c_2118,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,--p2,--p3,++p4,++p5,++p6,--p7]).

input_clause(c_2119,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,--p2,--p3,++p4,++p6]).

input_clause(c_2120,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,--p2,--p3,++p4,--p7]).

input_clause(c_2121,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,--p2,++p4]).

input_clause(c_2122,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,--p2,++p4,++p6,--p7]).

input_clause(c_2123,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,--p2,++p4,++p5,++p6]).

input_clause(c_2124,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,--p2,++p4,++p5,--p7]).

input_clause(c_2125,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,--p2,++p5]).

input_clause(c_2126,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,--p2,++p5,++p6,--p7]).

input_clause(c_2127,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,--p2,++p6]).

input_clause(c_2128,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,--p2,--p7]).

input_clause(c_2129,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7]).

input_clause(c_2130,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,++p6,--p7]).

input_clause(c_2131,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,++p5,++p6]).

input_clause(c_2132,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,++p5,--p7]).

input_clause(c_2133,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,++p4,++p5]).

input_clause(c_2134,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,++p4,++p5,++p6,--p7]).

input_clause(c_2135,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,++p4,++p6]).

input_clause(c_2136,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,++p4,--p7]).

input_clause(c_2137,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,--p3,++p4]).

input_clause(c_2138,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,--p3,++p4,++p6,--p7]).

input_clause(c_2139,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,--p3,++p4,++p5,++p6]).

input_clause(c_2140,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,--p3,++p4,++p5,--p7]).

input_clause(c_2141,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,--p3,++p5]).

input_clause(c_2142,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,--p3,++p5,++p6,--p7]).

input_clause(c_2143,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,--p3,++p6]).

input_clause(c_2144,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,--p3,--p7]).

input_clause(c_2145,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,--p1,--p3]).

input_clause(c_2146,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,--p1,--p3,++p6,--p7]).

input_clause(c_2147,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,--p1,--p3,++p5,++p6]).

input_clause(c_2148,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,--p1,--p3,++p5,--p7]).

input_clause(c_2149,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,--p1,--p3,++p4,++p5]).

input_clause(c_2150,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,--p1,--p3,++p4,++p5,++p6,--p7]).

input_clause(c_2151,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,--p1,--p3,++p4,++p6]).

input_clause(c_2152,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,--p1,--p3,++p4,--p7]).

input_clause(c_2153,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,--p1,++p4]).

input_clause(c_2154,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,--p1,++p4,++p6,--p7]).

input_clause(c_2155,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,--p1,++p4,++p5,++p6]).

input_clause(c_2156,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,--p1,++p4,++p5,--p7]).

input_clause(c_2157,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,--p1,++p5]).

input_clause(c_2158,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,--p1,++p5,++p6,--p7]).

input_clause(c_2159,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,--p1,++p6]).

input_clause(c_2160,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,--p1,--p7]).

input_clause(c_2161,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,--p1,--p2]).

input_clause(c_2162,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,--p1,--p2,++p6,--p7]).

input_clause(c_2163,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,--p1,--p2,++p5,++p6]).

input_clause(c_2164,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,--p1,--p2,++p5,--p7]).

input_clause(c_2165,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,--p1,--p2,++p4,++p5]).

input_clause(c_2166,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,--p1,--p2,++p4,++p5,++p6,--p7]).

input_clause(c_2167,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,--p1,--p2,++p4,++p6]).

input_clause(c_2168,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,--p1,--p2,++p4,--p7]).

input_clause(c_2169,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,--p1,--p2,--p3,++p4]).

input_clause(c_2170,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,--p1,--p2,--p3,++p4,++p6,--p7]).

input_clause(c_2171,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,--p1,--p2,--p3,++p4,++p5,++p6]).

input_clause(c_2172,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,--p1,--p2,--p3,++p4,++p5,--p7]).

input_clause(c_2173,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,--p1,--p2,--p3,++p5]).

input_clause(c_2174,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,--p1,--p2,--p3,++p5,++p6,--p7]).

input_clause(c_2175,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,--p1,--p2,--p3,++p6]).

input_clause(c_2176,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p7,--p1,--p2,--p3,--p7]).

input_clause(c_2177,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,--p1,--p2,--p3,--p6]).

input_clause(c_2178,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,--p1,--p2,--p3,--p7]).

input_clause(c_2179,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,--p1,--p2,--p3,++p5]).

input_clause(c_2180,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,--p1,--p2,--p3,++p5,--p6,--p7]).

input_clause(c_2181,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,--p1,--p2,--p3,++p4,++p5,--p6]).

input_clause(c_2182,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,--p1,--p2,--p3,++p4,++p5,--p7]).

input_clause(c_2183,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,--p1,--p2,--p3,++p4]).

input_clause(c_2184,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,--p1,--p2,--p3,++p4,--p6,--p7]).

input_clause(c_2185,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,--p1,--p2,++p4,--p6]).

input_clause(c_2186,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,--p1,--p2,++p4,--p7]).

input_clause(c_2187,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,--p1,--p2,++p4,++p5]).

input_clause(c_2188,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,--p1,--p2,++p4,++p5,--p6,--p7]).

input_clause(c_2189,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,--p1,--p2,++p5,--p6]).

input_clause(c_2190,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,--p1,--p2,++p5,--p7]).

input_clause(c_2191,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,--p1,--p2]).

input_clause(c_2192,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,--p1,--p2,--p6,--p7]).

input_clause(c_2193,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,--p1,--p6]).

input_clause(c_2194,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,--p1,--p7]).

input_clause(c_2195,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,--p1,++p5]).

input_clause(c_2196,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,--p1,++p5,--p6,--p7]).

input_clause(c_2197,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,--p1,++p4,++p5,--p6]).

input_clause(c_2198,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,--p1,++p4,++p5,--p7]).

input_clause(c_2199,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,--p1,++p4]).

input_clause(c_2200,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,--p1,++p4,--p6,--p7]).

input_clause(c_2201,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,--p1,--p3,++p4,--p6]).

input_clause(c_2202,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,--p1,--p3,++p4,--p7]).

input_clause(c_2203,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,--p1,--p3,++p4,++p5]).

input_clause(c_2204,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,--p1,--p3,++p4,++p5,--p6,--p7]).

input_clause(c_2205,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,--p1,--p3,++p5,--p6]).

input_clause(c_2206,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,--p1,--p3,++p5,--p7]).

input_clause(c_2207,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,--p1,--p3]).

input_clause(c_2208,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,--p1,--p3,--p6,--p7]).

input_clause(c_2209,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,--p3,--p6]).

input_clause(c_2210,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,--p3,--p7]).

input_clause(c_2211,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,--p3,++p5]).

input_clause(c_2212,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,--p3,++p5,--p6,--p7]).

input_clause(c_2213,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,--p3,++p4,++p5,--p6]).

input_clause(c_2214,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,--p3,++p4,++p5,--p7]).

input_clause(c_2215,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,--p3,++p4]).

input_clause(c_2216,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,--p3,++p4,--p6,--p7]).

input_clause(c_2217,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,++p4,--p6]).

input_clause(c_2218,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,++p4,--p7]).

input_clause(c_2219,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,++p4,++p5]).

input_clause(c_2220,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,++p4,++p5,--p6,--p7]).

input_clause(c_2221,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,++p5,--p6]).

input_clause(c_2222,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,++p5,--p7]).

input_clause(c_2223,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7]).

input_clause(c_2224,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,--p6,--p7]).

input_clause(c_2225,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,--p2,--p6]).

input_clause(c_2226,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,--p2,--p7]).

input_clause(c_2227,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,--p2,++p5]).

input_clause(c_2228,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,--p2,++p5,--p6,--p7]).

input_clause(c_2229,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,--p2,++p4,++p5,--p6]).

input_clause(c_2230,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,--p2,++p4,++p5,--p7]).

input_clause(c_2231,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,--p2,++p4]).

input_clause(c_2232,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,--p2,++p4,--p6,--p7]).

input_clause(c_2233,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,--p2,--p3,++p4,--p6]).

input_clause(c_2234,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,--p2,--p3,++p4,--p7]).

input_clause(c_2235,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,--p2,--p3,++p4,++p5]).

input_clause(c_2236,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,--p2,--p3,++p4,++p5,--p6,--p7]).

input_clause(c_2237,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,--p2,--p3,++p5,--p6]).

input_clause(c_2238,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,--p2,--p3,++p5,--p7]).

input_clause(c_2239,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,--p2,--p3]).

input_clause(c_2240,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p7,--p2,--p3,--p6,--p7]).

input_clause(c_2241,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,--p2,--p3,--p6,++p7]).

input_clause(c_2242,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,--p2,--p3]).

input_clause(c_2243,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,--p2,--p3,++p5,++p7]).

input_clause(c_2244,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,--p2,--p3,++p5,--p6]).

input_clause(c_2245,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,--p2,--p3,++p4,++p5,--p6,++p7]).

input_clause(c_2246,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,--p2,--p3,++p4,++p5]).

input_clause(c_2247,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,--p2,--p3,++p4,++p7]).

input_clause(c_2248,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,--p2,--p3,++p4,--p6]).

input_clause(c_2249,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,--p2,++p4,--p6,++p7]).

input_clause(c_2250,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,--p2,++p4]).

input_clause(c_2251,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,--p2,++p4,++p5,++p7]).

input_clause(c_2252,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,--p2,++p4,++p5,--p6]).

input_clause(c_2253,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,--p2,++p5,--p6,++p7]).

input_clause(c_2254,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,--p2,++p5]).

input_clause(c_2255,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,--p2,++p7]).

input_clause(c_2256,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,--p2,--p6]).

input_clause(c_2257,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,--p6,++p7]).

input_clause(c_2258,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7]).

input_clause(c_2259,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,++p5,++p7]).

input_clause(c_2260,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,++p5,--p6]).

input_clause(c_2261,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,++p4,++p5,--p6,++p7]).

input_clause(c_2262,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,++p4,++p5]).

input_clause(c_2263,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,++p4,++p7]).

input_clause(c_2264,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,++p4,--p6]).

input_clause(c_2265,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,--p3,++p4,--p6,++p7]).

input_clause(c_2266,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,--p3,++p4]).

input_clause(c_2267,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,--p3,++p4,++p5,++p7]).

input_clause(c_2268,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,--p3,++p4,++p5,--p6]).

input_clause(c_2269,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,--p3,++p5,--p6,++p7]).

input_clause(c_2270,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,--p3,++p5]).

input_clause(c_2271,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,--p3,++p7]).

input_clause(c_2272,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,--p3,--p6]).

input_clause(c_2273,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,--p1,--p3,--p6,++p7]).

input_clause(c_2274,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,--p1,--p3]).

input_clause(c_2275,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,--p1,--p3,++p5,++p7]).

input_clause(c_2276,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,--p1,--p3,++p5,--p6]).

input_clause(c_2277,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,--p1,--p3,++p4,++p5,--p6,++p7]).

input_clause(c_2278,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,--p1,--p3,++p4,++p5]).

input_clause(c_2279,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,--p1,--p3,++p4,++p7]).

input_clause(c_2280,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,--p1,--p3,++p4,--p6]).

input_clause(c_2281,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,--p1,++p4,--p6,++p7]).

input_clause(c_2282,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,--p1,++p4]).

input_clause(c_2283,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,--p1,++p4,++p5,++p7]).

input_clause(c_2284,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,--p1,++p4,++p5,--p6]).

input_clause(c_2285,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,--p1,++p5,--p6,++p7]).

input_clause(c_2286,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,--p1,++p5]).

input_clause(c_2287,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,--p1,++p7]).

input_clause(c_2288,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,--p1,--p6]).

input_clause(c_2289,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,--p1,--p2,--p6,++p7]).

input_clause(c_2290,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,--p1,--p2]).

input_clause(c_2291,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,--p1,--p2,++p5,++p7]).

input_clause(c_2292,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,--p1,--p2,++p5,--p6]).

input_clause(c_2293,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,--p1,--p2,++p4,++p5,--p6,++p7]).

input_clause(c_2294,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,--p1,--p2,++p4,++p5]).

input_clause(c_2295,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,--p1,--p2,++p4,++p7]).

input_clause(c_2296,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,--p1,--p2,++p4,--p6]).

input_clause(c_2297,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,--p1,--p2,--p3,++p4,--p6,++p7]).

input_clause(c_2298,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,--p1,--p2,--p3,++p4]).

input_clause(c_2299,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,--p1,--p2,--p3,++p4,++p5,++p7]).

input_clause(c_2300,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,--p1,--p2,--p3,++p4,++p5,--p6]).

input_clause(c_2301,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,--p1,--p2,--p3,++p5,--p6,++p7]).

input_clause(c_2302,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,--p1,--p2,--p3,++p5]).

input_clause(c_2303,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,--p1,--p2,--p3,++p7]).

input_clause(c_2304,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p7,--p1,--p2,--p3,--p6]).

input_clause(c_2305,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p1,--p2,--p3,--p5,--p6,++p7]).

input_clause(c_2306,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p1,--p2,--p3,--p5]).

input_clause(c_2307,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p1,--p2,--p3,++p7]).

input_clause(c_2308,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p1,--p2,--p3,--p6]).

input_clause(c_2309,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p1,--p2,--p3,++p4,--p6,++p7]).

input_clause(c_2310,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p1,--p2,--p3,++p4]).

input_clause(c_2311,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p1,--p2,--p3,++p4,--p5,++p7]).

input_clause(c_2312,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p1,--p2,--p3,++p4,--p5,--p6]).

input_clause(c_2313,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p1,--p2,++p4,--p5,--p6,++p7]).

input_clause(c_2314,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p1,--p2,++p4,--p5]).

input_clause(c_2315,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p1,--p2,++p4,++p7]).

input_clause(c_2316,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p1,--p2,++p4,--p6]).

input_clause(c_2317,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p1,--p2,--p6,++p7]).

input_clause(c_2318,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p1,--p2]).

input_clause(c_2319,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p1,--p2,--p5,++p7]).

input_clause(c_2320,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p1,--p2,--p5,--p6]).

input_clause(c_2321,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p1,--p5,--p6,++p7]).

input_clause(c_2322,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p1,--p5]).

input_clause(c_2323,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p1,++p7]).

input_clause(c_2324,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p1,--p6]).

input_clause(c_2325,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p1,++p4,--p6,++p7]).

input_clause(c_2326,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p1,++p4]).

input_clause(c_2327,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p1,++p4,--p5,++p7]).

input_clause(c_2328,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p1,++p4,--p5,--p6]).

input_clause(c_2329,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p1,--p3,++p4,--p5,--p6,++p7]).

input_clause(c_2330,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p1,--p3,++p4,--p5]).

input_clause(c_2331,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p1,--p3,++p4,++p7]).

input_clause(c_2332,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p1,--p3,++p4,--p6]).

input_clause(c_2333,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p1,--p3,--p6,++p7]).

input_clause(c_2334,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p1,--p3]).

input_clause(c_2335,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p1,--p3,--p5,++p7]).

input_clause(c_2336,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p1,--p3,--p5,--p6]).

input_clause(c_2337,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p3,--p5,--p6,++p7]).

input_clause(c_2338,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p3,--p5]).

input_clause(c_2339,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p3,++p7]).

input_clause(c_2340,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p3,--p6]).

input_clause(c_2341,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p3,++p4,--p6,++p7]).

input_clause(c_2342,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p3,++p4]).

input_clause(c_2343,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p3,++p4,--p5,++p7]).

input_clause(c_2344,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p3,++p4,--p5,--p6]).

input_clause(c_2345,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,++p4,--p5,--p6,++p7]).

input_clause(c_2346,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,++p4,--p5]).

input_clause(c_2347,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,++p4,++p7]).

input_clause(c_2348,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,++p4,--p6]).

input_clause(c_2349,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p6,++p7]).

input_clause(c_2350,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7]).

input_clause(c_2351,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p5,++p7]).

input_clause(c_2352,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p5,--p6]).

input_clause(c_2353,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p2,--p5,--p6,++p7]).

input_clause(c_2354,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p2,--p5]).

input_clause(c_2355,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p2,++p7]).

input_clause(c_2356,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p2,--p6]).

input_clause(c_2357,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p2,++p4,--p6,++p7]).

input_clause(c_2358,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p2,++p4]).

input_clause(c_2359,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p2,++p4,--p5,++p7]).

input_clause(c_2360,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p2,++p4,--p5,--p6]).

input_clause(c_2361,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p2,--p3,++p4,--p5,--p6,++p7]).

input_clause(c_2362,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p2,--p3,++p4,--p5]).

input_clause(c_2363,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p2,--p3,++p4,++p7]).

input_clause(c_2364,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p2,--p3,++p4,--p6]).

input_clause(c_2365,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p2,--p3,--p6,++p7]).

input_clause(c_2366,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p2,--p3]).

input_clause(c_2367,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p2,--p3,--p5,++p7]).

input_clause(c_2368,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p7,--p2,--p3,--p5,--p6]).

input_clause(c_2369,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p2,--p3,--p5,--p6]).

input_clause(c_2370,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p2,--p3,--p5,--p7]).

input_clause(c_2371,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p2,--p3]).

input_clause(c_2372,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p2,--p3,--p6,--p7]).

input_clause(c_2373,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p2,--p3,++p4,--p6]).

input_clause(c_2374,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p2,--p3,++p4,--p7]).

input_clause(c_2375,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p2,--p3,++p4,--p5]).

input_clause(c_2376,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p2,--p3,++p4,--p5,--p6,--p7]).

input_clause(c_2377,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p2,++p4,--p5,--p6]).

input_clause(c_2378,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p2,++p4,--p5,--p7]).

input_clause(c_2379,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p2,++p4]).

input_clause(c_2380,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p2,++p4,--p6,--p7]).

input_clause(c_2381,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p2,--p6]).

input_clause(c_2382,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p2,--p7]).

input_clause(c_2383,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p2,--p5]).

input_clause(c_2384,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p2,--p5,--p6,--p7]).

input_clause(c_2385,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p5,--p6]).

input_clause(c_2386,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p5,--p7]).

input_clause(c_2387,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7]).

input_clause(c_2388,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p6,--p7]).

input_clause(c_2389,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,++p4,--p6]).

input_clause(c_2390,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,++p4,--p7]).

input_clause(c_2391,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,++p4,--p5]).

input_clause(c_2392,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,++p4,--p5,--p6,--p7]).

input_clause(c_2393,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p3,++p4,--p5,--p6]).

input_clause(c_2394,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p3,++p4,--p5,--p7]).

input_clause(c_2395,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p3,++p4]).

input_clause(c_2396,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p3,++p4,--p6,--p7]).

input_clause(c_2397,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p3,--p6]).

input_clause(c_2398,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p3,--p7]).

input_clause(c_2399,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p3,--p5]).

input_clause(c_2400,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p3,--p5,--p6,--p7]).

input_clause(c_2401,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p1,--p3,--p5,--p6]).

input_clause(c_2402,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p1,--p3,--p5,--p7]).

input_clause(c_2403,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p1,--p3]).

input_clause(c_2404,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p1,--p3,--p6,--p7]).

input_clause(c_2405,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p1,--p3,++p4,--p6]).

input_clause(c_2406,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p1,--p3,++p4,--p7]).

input_clause(c_2407,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p1,--p3,++p4,--p5]).

input_clause(c_2408,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p1,--p3,++p4,--p5,--p6,--p7]).

input_clause(c_2409,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p1,++p4,--p5,--p6]).

input_clause(c_2410,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p1,++p4,--p5,--p7]).

input_clause(c_2411,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p1,++p4]).

input_clause(c_2412,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p1,++p4,--p6,--p7]).

input_clause(c_2413,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p1,--p6]).

input_clause(c_2414,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p1,--p7]).

input_clause(c_2415,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p1,--p5]).

input_clause(c_2416,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p1,--p5,--p6,--p7]).

input_clause(c_2417,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p1,--p2,--p5,--p6]).

input_clause(c_2418,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p1,--p2,--p5,--p7]).

input_clause(c_2419,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p1,--p2]).

input_clause(c_2420,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p1,--p2,--p6,--p7]).

input_clause(c_2421,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p1,--p2,++p4,--p6]).

input_clause(c_2422,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p1,--p2,++p4,--p7]).

input_clause(c_2423,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p1,--p2,++p4,--p5]).

input_clause(c_2424,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p1,--p2,++p4,--p5,--p6,--p7]).

input_clause(c_2425,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p1,--p2,--p3,++p4,--p5,--p6]).

input_clause(c_2426,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p1,--p2,--p3,++p4,--p5,--p7]).

input_clause(c_2427,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p1,--p2,--p3,++p4]).

input_clause(c_2428,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p1,--p2,--p3,++p4,--p6,--p7]).

input_clause(c_2429,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p1,--p2,--p3,--p6]).

input_clause(c_2430,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p1,--p2,--p3,--p7]).

input_clause(c_2431,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p1,--p2,--p3,--p5]).

input_clause(c_2432,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p7,--p1,--p2,--p3,--p5,--p6,--p7]).

input_clause(c_2433,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p1,--p2,--p3,--p5]).

input_clause(c_2434,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p1,--p2,--p3,--p5,++p6,--p7]).

input_clause(c_2435,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p1,--p2,--p3,++p6]).

input_clause(c_2436,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p1,--p2,--p3,--p7]).

input_clause(c_2437,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p1,--p2,--p3,++p4]).

input_clause(c_2438,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p1,--p2,--p3,++p4,++p6,--p7]).

input_clause(c_2439,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p1,--p2,--p3,++p4,--p5,++p6]).

input_clause(c_2440,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p1,--p2,--p3,++p4,--p5,--p7]).

input_clause(c_2441,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p1,--p2,++p4,--p5]).

input_clause(c_2442,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p1,--p2,++p4,--p5,++p6,--p7]).

input_clause(c_2443,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p1,--p2,++p4,++p6]).

input_clause(c_2444,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p1,--p2,++p4,--p7]).

input_clause(c_2445,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p1,--p2]).

input_clause(c_2446,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p1,--p2,++p6,--p7]).

input_clause(c_2447,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p1,--p2,--p5,++p6]).

input_clause(c_2448,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p1,--p2,--p5,--p7]).

input_clause(c_2449,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p1,--p5]).

input_clause(c_2450,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p1,--p5,++p6,--p7]).

input_clause(c_2451,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p1,++p6]).

input_clause(c_2452,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p1,--p7]).

input_clause(c_2453,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p1,++p4]).

input_clause(c_2454,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p1,++p4,++p6,--p7]).

input_clause(c_2455,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p1,++p4,--p5,++p6]).

input_clause(c_2456,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p1,++p4,--p5,--p7]).

input_clause(c_2457,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p1,--p3,++p4,--p5]).

input_clause(c_2458,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p1,--p3,++p4,--p5,++p6,--p7]).

input_clause(c_2459,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p1,--p3,++p4,++p6]).

input_clause(c_2460,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p1,--p3,++p4,--p7]).

input_clause(c_2461,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p1,--p3]).

input_clause(c_2462,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p1,--p3,++p6,--p7]).

input_clause(c_2463,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p1,--p3,--p5,++p6]).

input_clause(c_2464,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p1,--p3,--p5,--p7]).

input_clause(c_2465,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p3,--p5]).

input_clause(c_2466,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p3,--p5,++p6,--p7]).

input_clause(c_2467,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p3,++p6]).

input_clause(c_2468,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p3,--p7]).

input_clause(c_2469,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p3,++p4]).

input_clause(c_2470,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p3,++p4,++p6,--p7]).

input_clause(c_2471,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p3,++p4,--p5,++p6]).

input_clause(c_2472,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p3,++p4,--p5,--p7]).

input_clause(c_2473,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,++p4,--p5]).

input_clause(c_2474,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,++p4,--p5,++p6,--p7]).

input_clause(c_2475,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,++p4,++p6]).

input_clause(c_2476,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,++p4,--p7]).

input_clause(c_2477,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7]).

input_clause(c_2478,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,++p6,--p7]).

input_clause(c_2479,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p5,++p6]).

input_clause(c_2480,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p5,--p7]).

input_clause(c_2481,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p2,--p5]).

input_clause(c_2482,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p2,--p5,++p6,--p7]).

input_clause(c_2483,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p2,++p6]).

input_clause(c_2484,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p2,--p7]).

input_clause(c_2485,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p2,++p4]).

input_clause(c_2486,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p2,++p4,++p6,--p7]).

input_clause(c_2487,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p2,++p4,--p5,++p6]).

input_clause(c_2488,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p2,++p4,--p5,--p7]).

input_clause(c_2489,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p2,--p3,++p4,--p5]).

input_clause(c_2490,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p2,--p3,++p4,--p5,++p6,--p7]).

input_clause(c_2491,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p2,--p3,++p4,++p6]).

input_clause(c_2492,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p2,--p3,++p4,--p7]).

input_clause(c_2493,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p2,--p3]).

input_clause(c_2494,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p2,--p3,++p6,--p7]).

input_clause(c_2495,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p2,--p3,--p5,++p6]).

input_clause(c_2496,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p7,--p2,--p3,--p5,--p7]).

input_clause(c_2497,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p2,--p3,--p5,++p7]).

input_clause(c_2498,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p2,--p3,--p5,++p6]).

input_clause(c_2499,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p2,--p3,++p6,++p7]).

input_clause(c_2500,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p2,--p3]).

input_clause(c_2501,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p2,--p3,++p4,++p7]).

input_clause(c_2502,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p2,--p3,++p4,++p6]).

input_clause(c_2503,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p2,--p3,++p4,--p5,++p6,++p7]).

input_clause(c_2504,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p2,--p3,++p4,--p5]).

input_clause(c_2505,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p2,++p4,--p5,++p7]).

input_clause(c_2506,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p2,++p4,--p5,++p6]).

input_clause(c_2507,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p2,++p4,++p6,++p7]).

input_clause(c_2508,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p2,++p4]).

input_clause(c_2509,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p2,++p7]).

input_clause(c_2510,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p2,++p6]).

input_clause(c_2511,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p2,--p5,++p6,++p7]).

input_clause(c_2512,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p2,--p5]).

input_clause(c_2513,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p5,++p7]).

input_clause(c_2514,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p5,++p6]).

input_clause(c_2515,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,++p6,++p7]).

input_clause(c_2516,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7]).

input_clause(c_2517,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,++p4,++p7]).

input_clause(c_2518,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,++p4,++p6]).

input_clause(c_2519,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,++p4,--p5,++p6,++p7]).

input_clause(c_2520,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,++p4,--p5]).

input_clause(c_2521,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p3,++p4,--p5,++p7]).

input_clause(c_2522,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p3,++p4,--p5,++p6]).

input_clause(c_2523,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p3,++p4,++p6,++p7]).

input_clause(c_2524,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p3,++p4]).

input_clause(c_2525,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p3,++p7]).

input_clause(c_2526,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p3,++p6]).

input_clause(c_2527,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p3,--p5,++p6,++p7]).

input_clause(c_2528,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p3,--p5]).

input_clause(c_2529,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p1,--p3,--p5,++p7]).

input_clause(c_2530,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p1,--p3,--p5,++p6]).

input_clause(c_2531,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p1,--p3,++p6,++p7]).

input_clause(c_2532,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p1,--p3]).

input_clause(c_2533,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p1,--p3,++p4,++p7]).

input_clause(c_2534,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p1,--p3,++p4,++p6]).

input_clause(c_2535,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p1,--p3,++p4,--p5,++p6,++p7]).

input_clause(c_2536,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p1,--p3,++p4,--p5]).

input_clause(c_2537,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p1,++p4,--p5,++p7]).

input_clause(c_2538,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p1,++p4,--p5,++p6]).

input_clause(c_2539,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p1,++p4,++p6,++p7]).

input_clause(c_2540,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p1,++p4]).

input_clause(c_2541,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p1,++p7]).

input_clause(c_2542,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p1,++p6]).

input_clause(c_2543,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p1,--p5,++p6,++p7]).

input_clause(c_2544,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p1,--p5]).

input_clause(c_2545,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p1,--p2,--p5,++p7]).

input_clause(c_2546,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p1,--p2,--p5,++p6]).

input_clause(c_2547,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p1,--p2,++p6,++p7]).

input_clause(c_2548,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p1,--p2]).

input_clause(c_2549,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p1,--p2,++p4,++p7]).

input_clause(c_2550,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p1,--p2,++p4,++p6]).

input_clause(c_2551,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p1,--p2,++p4,--p5,++p6,++p7]).

input_clause(c_2552,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p1,--p2,++p4,--p5]).

input_clause(c_2553,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p1,--p2,--p3,++p4,--p5,++p7]).

input_clause(c_2554,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p1,--p2,--p3,++p4,--p5,++p6]).

input_clause(c_2555,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p1,--p2,--p3,++p4,++p6,++p7]).

input_clause(c_2556,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p1,--p2,--p3,++p4]).

input_clause(c_2557,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p1,--p2,--p3,++p7]).

input_clause(c_2558,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p1,--p2,--p3,++p6]).

input_clause(c_2559,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p1,--p2,--p3,--p5,++p6,++p7]).

input_clause(c_2560,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p7,--p1,--p2,--p3,--p5]).

input_clause(c_2561,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p1,--p2,--p3,--p4,--p5,++p7]).

input_clause(c_2562,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p1,--p2,--p3,--p4,--p5,++p6]).

input_clause(c_2563,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p1,--p2,--p3,--p4,++p6,++p7]).

input_clause(c_2564,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p1,--p2,--p3,--p4]).

input_clause(c_2565,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p1,--p2,--p3,++p7]).

input_clause(c_2566,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p1,--p2,--p3,++p6]).

input_clause(c_2567,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p1,--p2,--p3,--p5,++p6,++p7]).

input_clause(c_2568,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p1,--p2,--p3,--p5]).

input_clause(c_2569,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p1,--p2,--p5,++p7]).

input_clause(c_2570,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p1,--p2,--p5,++p6]).

input_clause(c_2571,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p1,--p2,++p6,++p7]).

input_clause(c_2572,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p1,--p2]).

input_clause(c_2573,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p1,--p2,--p4,++p7]).

input_clause(c_2574,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p1,--p2,--p4,++p6]).

input_clause(c_2575,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p1,--p2,--p4,--p5,++p6,++p7]).

input_clause(c_2576,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p1,--p2,--p4,--p5]).

input_clause(c_2577,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p1,--p4,--p5,++p7]).

input_clause(c_2578,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p1,--p4,--p5,++p6]).

input_clause(c_2579,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p1,--p4,++p6,++p7]).

input_clause(c_2580,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p1,--p4]).

input_clause(c_2581,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p1,++p7]).

input_clause(c_2582,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p1,++p6]).

input_clause(c_2583,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p1,--p5,++p6,++p7]).

input_clause(c_2584,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p1,--p5]).

input_clause(c_2585,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p1,--p3,--p5,++p7]).

input_clause(c_2586,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p1,--p3,--p5,++p6]).

input_clause(c_2587,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p1,--p3,++p6,++p7]).

input_clause(c_2588,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p1,--p3]).

input_clause(c_2589,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p1,--p3,--p4,++p7]).

input_clause(c_2590,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p1,--p3,--p4,++p6]).

input_clause(c_2591,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p1,--p3,--p4,--p5,++p6,++p7]).

input_clause(c_2592,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p1,--p3,--p4,--p5]).

input_clause(c_2593,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p3,--p4,--p5,++p7]).

input_clause(c_2594,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p3,--p4,--p5,++p6]).

input_clause(c_2595,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p3,--p4,++p6,++p7]).

input_clause(c_2596,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p3,--p4]).

input_clause(c_2597,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p3,++p7]).

input_clause(c_2598,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p3,++p6]).

input_clause(c_2599,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p3,--p5,++p6,++p7]).

input_clause(c_2600,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p3,--p5]).

input_clause(c_2601,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p5,++p7]).

input_clause(c_2602,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p5,++p6]).

input_clause(c_2603,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,++p6,++p7]).

input_clause(c_2604,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7]).

input_clause(c_2605,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p4,++p7]).

input_clause(c_2606,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p4,++p6]).

input_clause(c_2607,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p4,--p5,++p6,++p7]).

input_clause(c_2608,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p4,--p5]).

input_clause(c_2609,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p2,--p4,--p5,++p7]).

input_clause(c_2610,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p2,--p4,--p5,++p6]).

input_clause(c_2611,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p2,--p4,++p6,++p7]).

input_clause(c_2612,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p2,--p4]).

input_clause(c_2613,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p2,++p7]).

input_clause(c_2614,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p2,++p6]).

input_clause(c_2615,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p2,--p5,++p6,++p7]).

input_clause(c_2616,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p2,--p5]).

input_clause(c_2617,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p2,--p3,--p5,++p7]).

input_clause(c_2618,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p2,--p3,--p5,++p6]).

input_clause(c_2619,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p2,--p3,++p6,++p7]).

input_clause(c_2620,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p2,--p3]).

input_clause(c_2621,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p2,--p3,--p4,++p7]).

input_clause(c_2622,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p2,--p3,--p4,++p6]).

input_clause(c_2623,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p2,--p3,--p4,--p5,++p6,++p7]).

input_clause(c_2624,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p7,--p2,--p3,--p4,--p5]).

input_clause(c_2625,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p2,--p3,--p4,--p5]).

input_clause(c_2626,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p2,--p3,--p4,--p5,++p6,--p7]).

input_clause(c_2627,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p2,--p3,--p4,++p6]).

input_clause(c_2628,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p2,--p3,--p4,--p7]).

input_clause(c_2629,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p2,--p3]).

input_clause(c_2630,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p2,--p3,++p6,--p7]).

input_clause(c_2631,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p2,--p3,--p5,++p6]).

input_clause(c_2632,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p2,--p3,--p5,--p7]).

input_clause(c_2633,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p2,--p5]).

input_clause(c_2634,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p2,--p5,++p6,--p7]).

input_clause(c_2635,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p2,++p6]).

input_clause(c_2636,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p2,--p7]).

input_clause(c_2637,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p2,--p4]).

input_clause(c_2638,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p2,--p4,++p6,--p7]).

input_clause(c_2639,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p2,--p4,--p5,++p6]).

input_clause(c_2640,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p2,--p4,--p5,--p7]).

input_clause(c_2641,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p4,--p5]).

input_clause(c_2642,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p4,--p5,++p6,--p7]).

input_clause(c_2643,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p4,++p6]).

input_clause(c_2644,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p4,--p7]).

input_clause(c_2645,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7]).

input_clause(c_2646,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,++p6,--p7]).

input_clause(c_2647,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p5,++p6]).

input_clause(c_2648,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p5,--p7]).

input_clause(c_2649,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p3,--p5]).

input_clause(c_2650,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p3,--p5,++p6,--p7]).

input_clause(c_2651,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p3,++p6]).

input_clause(c_2652,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p3,--p7]).

input_clause(c_2653,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p3,--p4]).

input_clause(c_2654,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p3,--p4,++p6,--p7]).

input_clause(c_2655,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p3,--p4,--p5,++p6]).

input_clause(c_2656,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p3,--p4,--p5,--p7]).

input_clause(c_2657,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p1,--p3,--p4,--p5]).

input_clause(c_2658,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p1,--p3,--p4,--p5,++p6,--p7]).

input_clause(c_2659,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p1,--p3,--p4,++p6]).

input_clause(c_2660,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p1,--p3,--p4,--p7]).

input_clause(c_2661,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p1,--p3]).

input_clause(c_2662,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p1,--p3,++p6,--p7]).

input_clause(c_2663,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p1,--p3,--p5,++p6]).

input_clause(c_2664,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p1,--p3,--p5,--p7]).

input_clause(c_2665,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p1,--p5]).

input_clause(c_2666,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p1,--p5,++p6,--p7]).

input_clause(c_2667,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p1,++p6]).

input_clause(c_2668,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p1,--p7]).

input_clause(c_2669,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p1,--p4]).

input_clause(c_2670,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p1,--p4,++p6,--p7]).

input_clause(c_2671,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p1,--p4,--p5,++p6]).

input_clause(c_2672,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p1,--p4,--p5,--p7]).

input_clause(c_2673,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p1,--p2,--p4,--p5]).

input_clause(c_2674,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p1,--p2,--p4,--p5,++p6,--p7]).

input_clause(c_2675,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p1,--p2,--p4,++p6]).

input_clause(c_2676,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p1,--p2,--p4,--p7]).

input_clause(c_2677,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p1,--p2]).

input_clause(c_2678,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p1,--p2,++p6,--p7]).

input_clause(c_2679,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p1,--p2,--p5,++p6]).

input_clause(c_2680,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p1,--p2,--p5,--p7]).

input_clause(c_2681,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p1,--p2,--p3,--p5]).

input_clause(c_2682,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p1,--p2,--p3,--p5,++p6,--p7]).

input_clause(c_2683,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p1,--p2,--p3,++p6]).

input_clause(c_2684,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p1,--p2,--p3,--p7]).

input_clause(c_2685,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p1,--p2,--p3,--p4]).

input_clause(c_2686,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p1,--p2,--p3,--p4,++p6,--p7]).

input_clause(c_2687,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p1,--p2,--p3,--p4,--p5,++p6]).

input_clause(c_2688,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,++p7,--p1,--p2,--p3,--p4,--p5,--p7]).

input_clause(c_2689,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p1,--p2,--p3,--p4,--p5,--p6]).

input_clause(c_2690,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p1,--p2,--p3,--p4,--p5,--p7]).

input_clause(c_2691,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p1,--p2,--p3,--p4]).

input_clause(c_2692,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p1,--p2,--p3,--p4,--p6,--p7]).

input_clause(c_2693,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p1,--p2,--p3,--p6]).

input_clause(c_2694,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p1,--p2,--p3,--p7]).

input_clause(c_2695,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p1,--p2,--p3,--p5]).

input_clause(c_2696,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p1,--p2,--p3,--p5,--p6,--p7]).

input_clause(c_2697,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p1,--p2,--p5,--p6]).

input_clause(c_2698,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p1,--p2,--p5,--p7]).

input_clause(c_2699,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p1,--p2]).

input_clause(c_2700,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p1,--p2,--p6,--p7]).

input_clause(c_2701,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p1,--p2,--p4,--p6]).

input_clause(c_2702,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p1,--p2,--p4,--p7]).

input_clause(c_2703,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p1,--p2,--p4,--p5]).

input_clause(c_2704,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p1,--p2,--p4,--p5,--p6,--p7]).

input_clause(c_2705,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p1,--p4,--p5,--p6]).

input_clause(c_2706,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p1,--p4,--p5,--p7]).

input_clause(c_2707,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p1,--p4]).

input_clause(c_2708,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p1,--p4,--p6,--p7]).

input_clause(c_2709,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p1,--p6]).

input_clause(c_2710,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p1,--p7]).

input_clause(c_2711,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p1,--p5]).

input_clause(c_2712,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p1,--p5,--p6,--p7]).

input_clause(c_2713,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p1,--p3,--p5,--p6]).

input_clause(c_2714,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p1,--p3,--p5,--p7]).

input_clause(c_2715,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p1,--p3]).

input_clause(c_2716,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p1,--p3,--p6,--p7]).

input_clause(c_2717,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p1,--p3,--p4,--p6]).

input_clause(c_2718,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p1,--p3,--p4,--p7]).

input_clause(c_2719,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p1,--p3,--p4,--p5]).

input_clause(c_2720,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p1,--p3,--p4,--p5,--p6,--p7]).

input_clause(c_2721,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p3,--p4,--p5,--p6]).

input_clause(c_2722,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p3,--p4,--p5,--p7]).

input_clause(c_2723,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p3,--p4]).

input_clause(c_2724,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p3,--p4,--p6,--p7]).

input_clause(c_2725,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p3,--p6]).

input_clause(c_2726,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p3,--p7]).

input_clause(c_2727,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p3,--p5]).

input_clause(c_2728,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p3,--p5,--p6,--p7]).

input_clause(c_2729,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p5,--p6]).

input_clause(c_2730,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p5,--p7]).

input_clause(c_2731,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7]).

input_clause(c_2732,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p6,--p7]).

input_clause(c_2733,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p4,--p6]).

input_clause(c_2734,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p4,--p7]).

input_clause(c_2735,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p4,--p5]).

input_clause(c_2736,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p4,--p5,--p6,--p7]).

input_clause(c_2737,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p2,--p4,--p5,--p6]).

input_clause(c_2738,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p2,--p4,--p5,--p7]).

input_clause(c_2739,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p2,--p4]).

input_clause(c_2740,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p2,--p4,--p6,--p7]).

input_clause(c_2741,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p2,--p6]).

input_clause(c_2742,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p2,--p7]).

input_clause(c_2743,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p2,--p5]).

input_clause(c_2744,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p2,--p5,--p6,--p7]).

input_clause(c_2745,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p2,--p3,--p5,--p6]).

input_clause(c_2746,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p2,--p3,--p5,--p7]).

input_clause(c_2747,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p2,--p3]).

input_clause(c_2748,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p2,--p3,--p6,--p7]).

input_clause(c_2749,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p2,--p3,--p4,--p6]).

input_clause(c_2750,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p2,--p3,--p4,--p7]).

input_clause(c_2751,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p2,--p3,--p4,--p5]).

input_clause(c_2752,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,++p7,--p2,--p3,--p4,--p5,--p6,--p7]).

input_clause(c_2753,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p2,--p3,--p4,--p5,--p6,++p7]).

input_clause(c_2754,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p2,--p3,--p4,--p5]).

input_clause(c_2755,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p2,--p3,--p4,++p7]).

input_clause(c_2756,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p2,--p3,--p4,--p6]).

input_clause(c_2757,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p2,--p3,--p6,++p7]).

input_clause(c_2758,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p2,--p3]).

input_clause(c_2759,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p2,--p3,--p5,++p7]).

input_clause(c_2760,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p2,--p3,--p5,--p6]).

input_clause(c_2761,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p2,--p5,--p6,++p7]).

input_clause(c_2762,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p2,--p5]).

input_clause(c_2763,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p2,++p7]).

input_clause(c_2764,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p2,--p6]).

input_clause(c_2765,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p2,--p4,--p6,++p7]).

input_clause(c_2766,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p2,--p4]).

input_clause(c_2767,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p2,--p4,--p5,++p7]).

input_clause(c_2768,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p2,--p4,--p5,--p6]).

input_clause(c_2769,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p4,--p5,--p6,++p7]).

input_clause(c_2770,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p4,--p5]).

input_clause(c_2771,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p4,++p7]).

input_clause(c_2772,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p4,--p6]).

input_clause(c_2773,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p6,++p7]).

input_clause(c_2774,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7]).

input_clause(c_2775,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p5,++p7]).

input_clause(c_2776,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p5,--p6]).

input_clause(c_2777,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p3,--p5,--p6,++p7]).

input_clause(c_2778,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p3,--p5]).

input_clause(c_2779,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p3,++p7]).

input_clause(c_2780,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p3,--p6]).

input_clause(c_2781,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p3,--p4,--p6,++p7]).

input_clause(c_2782,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p3,--p4]).

input_clause(c_2783,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p3,--p4,--p5,++p7]).

input_clause(c_2784,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p3,--p4,--p5,--p6]).

input_clause(c_2785,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p1,--p3,--p4,--p5,--p6,++p7]).

input_clause(c_2786,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p1,--p3,--p4,--p5]).

input_clause(c_2787,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p1,--p3,--p4,++p7]).

input_clause(c_2788,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p1,--p3,--p4,--p6]).

input_clause(c_2789,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p1,--p3,--p6,++p7]).

input_clause(c_2790,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p1,--p3]).

input_clause(c_2791,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p1,--p3,--p5,++p7]).

input_clause(c_2792,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p1,--p3,--p5,--p6]).

input_clause(c_2793,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p1,--p5,--p6,++p7]).

input_clause(c_2794,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p1,--p5]).

input_clause(c_2795,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p1,++p7]).

input_clause(c_2796,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p1,--p6]).

input_clause(c_2797,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p1,--p4,--p6,++p7]).

input_clause(c_2798,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p1,--p4]).

input_clause(c_2799,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p1,--p4,--p5,++p7]).

input_clause(c_2800,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p1,--p4,--p5,--p6]).

input_clause(c_2801,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p1,--p2,--p4,--p5,--p6,++p7]).

input_clause(c_2802,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p1,--p2,--p4,--p5]).

input_clause(c_2803,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p1,--p2,--p4,++p7]).

input_clause(c_2804,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p1,--p2,--p4,--p6]).

input_clause(c_2805,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p1,--p2,--p6,++p7]).

input_clause(c_2806,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p1,--p2]).

input_clause(c_2807,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p1,--p2,--p5,++p7]).

input_clause(c_2808,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p1,--p2,--p5,--p6]).

input_clause(c_2809,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p1,--p2,--p3,--p5,--p6,++p7]).

input_clause(c_2810,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p1,--p2,--p3,--p5]).

input_clause(c_2811,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p1,--p2,--p3,++p7]).

input_clause(c_2812,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p1,--p2,--p3,--p6]).

input_clause(c_2813,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p1,--p2,--p3,--p4,--p6,++p7]).

input_clause(c_2814,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p1,--p2,--p3,--p4]).

input_clause(c_2815,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p1,--p2,--p3,--p4,--p5,++p7]).

input_clause(c_2816,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p7,--p1,--p2,--p3,--p4,--p5,--p6]).

input_clause(c_2817,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p1,--p2,--p3,--p4,--p6,++p7]).

input_clause(c_2818,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p1,--p2,--p3,--p4]).

input_clause(c_2819,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p1,--p2,--p3,--p4,++p5,++p7]).

input_clause(c_2820,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p1,--p2,--p3,--p4,++p5,--p6]).

input_clause(c_2821,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p1,--p2,--p3,++p5,--p6,++p7]).

input_clause(c_2822,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p1,--p2,--p3,++p5]).

input_clause(c_2823,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p1,--p2,--p3,++p7]).

input_clause(c_2824,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p1,--p2,--p3,--p6]).

input_clause(c_2825,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p1,--p2,--p6,++p7]).

input_clause(c_2826,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p1,--p2]).

input_clause(c_2827,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p1,--p2,++p5,++p7]).

input_clause(c_2828,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p1,--p2,++p5,--p6]).

input_clause(c_2829,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p1,--p2,--p4,++p5,--p6,++p7]).

input_clause(c_2830,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p1,--p2,--p4,++p5]).

input_clause(c_2831,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p1,--p2,--p4,++p7]).

input_clause(c_2832,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p1,--p2,--p4,--p6]).

input_clause(c_2833,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p1,--p4,--p6,++p7]).

input_clause(c_2834,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p1,--p4]).

input_clause(c_2835,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p1,--p4,++p5,++p7]).

input_clause(c_2836,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p1,--p4,++p5,--p6]).

input_clause(c_2837,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p1,++p5,--p6,++p7]).

input_clause(c_2838,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p1,++p5]).

input_clause(c_2839,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p1,++p7]).

input_clause(c_2840,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p1,--p6]).

input_clause(c_2841,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p1,--p3,--p6,++p7]).

input_clause(c_2842,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p1,--p3]).

input_clause(c_2843,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p1,--p3,++p5,++p7]).

input_clause(c_2844,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p1,--p3,++p5,--p6]).

input_clause(c_2845,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p1,--p3,--p4,++p5,--p6,++p7]).

input_clause(c_2846,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p1,--p3,--p4,++p5]).

input_clause(c_2847,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p1,--p3,--p4,++p7]).

input_clause(c_2848,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p1,--p3,--p4,--p6]).

input_clause(c_2849,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p3,--p4,--p6,++p7]).

input_clause(c_2850,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p3,--p4]).

input_clause(c_2851,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p3,--p4,++p5,++p7]).

input_clause(c_2852,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p3,--p4,++p5,--p6]).

input_clause(c_2853,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p3,++p5,--p6,++p7]).

input_clause(c_2854,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p3,++p5]).

input_clause(c_2855,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p3,++p7]).

input_clause(c_2856,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p3,--p6]).

input_clause(c_2857,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p6,++p7]).

input_clause(c_2858,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7]).

input_clause(c_2859,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,++p5,++p7]).

input_clause(c_2860,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,++p5,--p6]).

input_clause(c_2861,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p4,++p5,--p6,++p7]).

input_clause(c_2862,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p4,++p5]).

input_clause(c_2863,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p4,++p7]).

input_clause(c_2864,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p4,--p6]).

input_clause(c_2865,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p2,--p4,--p6,++p7]).

input_clause(c_2866,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p2,--p4]).

input_clause(c_2867,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p2,--p4,++p5,++p7]).

input_clause(c_2868,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p2,--p4,++p5,--p6]).

input_clause(c_2869,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p2,++p5,--p6,++p7]).

input_clause(c_2870,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p2,++p5]).

input_clause(c_2871,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p2,++p7]).

input_clause(c_2872,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p2,--p6]).

input_clause(c_2873,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p2,--p3,--p6,++p7]).

input_clause(c_2874,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p2,--p3]).

input_clause(c_2875,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p2,--p3,++p5,++p7]).

input_clause(c_2876,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p2,--p3,++p5,--p6]).

input_clause(c_2877,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p2,--p3,--p4,++p5,--p6,++p7]).

input_clause(c_2878,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p2,--p3,--p4,++p5]).

input_clause(c_2879,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p2,--p3,--p4,++p7]).

input_clause(c_2880,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p7,--p2,--p3,--p4,--p6]).

input_clause(c_2881,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p2,--p3,--p4,--p6]).

input_clause(c_2882,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p2,--p3,--p4,--p7]).

input_clause(c_2883,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p2,--p3,--p4,++p5]).

input_clause(c_2884,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p2,--p3,--p4,++p5,--p6,--p7]).

input_clause(c_2885,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p2,--p3,++p5,--p6]).

input_clause(c_2886,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p2,--p3,++p5,--p7]).

input_clause(c_2887,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p2,--p3]).

input_clause(c_2888,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p2,--p3,--p6,--p7]).

input_clause(c_2889,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p2,--p6]).

input_clause(c_2890,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p2,--p7]).

input_clause(c_2891,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p2,++p5]).

input_clause(c_2892,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p2,++p5,--p6,--p7]).

input_clause(c_2893,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p2,--p4,++p5,--p6]).

input_clause(c_2894,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p2,--p4,++p5,--p7]).

input_clause(c_2895,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p2,--p4]).

input_clause(c_2896,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p2,--p4,--p6,--p7]).

input_clause(c_2897,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p4,--p6]).

input_clause(c_2898,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p4,--p7]).

input_clause(c_2899,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p4,++p5]).

input_clause(c_2900,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p4,++p5,--p6,--p7]).

input_clause(c_2901,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,++p5,--p6]).

input_clause(c_2902,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,++p5,--p7]).

input_clause(c_2903,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7]).

input_clause(c_2904,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p6,--p7]).

input_clause(c_2905,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p3,--p6]).

input_clause(c_2906,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p3,--p7]).

input_clause(c_2907,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p3,++p5]).

input_clause(c_2908,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p3,++p5,--p6,--p7]).

input_clause(c_2909,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p3,--p4,++p5,--p6]).

input_clause(c_2910,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p3,--p4,++p5,--p7]).

input_clause(c_2911,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p3,--p4]).

input_clause(c_2912,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p3,--p4,--p6,--p7]).

input_clause(c_2913,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p1,--p3,--p4,--p6]).

input_clause(c_2914,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p1,--p3,--p4,--p7]).

input_clause(c_2915,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p1,--p3,--p4,++p5]).

input_clause(c_2916,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p1,--p3,--p4,++p5,--p6,--p7]).

input_clause(c_2917,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p1,--p3,++p5,--p6]).

input_clause(c_2918,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p1,--p3,++p5,--p7]).

input_clause(c_2919,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p1,--p3]).

input_clause(c_2920,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p1,--p3,--p6,--p7]).

input_clause(c_2921,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p1,--p6]).

input_clause(c_2922,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p1,--p7]).

input_clause(c_2923,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p1,++p5]).

input_clause(c_2924,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p1,++p5,--p6,--p7]).

input_clause(c_2925,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p1,--p4,++p5,--p6]).

input_clause(c_2926,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p1,--p4,++p5,--p7]).

input_clause(c_2927,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p1,--p4]).

input_clause(c_2928,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p1,--p4,--p6,--p7]).

input_clause(c_2929,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p1,--p2,--p4,--p6]).

input_clause(c_2930,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p1,--p2,--p4,--p7]).

input_clause(c_2931,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p1,--p2,--p4,++p5]).

input_clause(c_2932,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p1,--p2,--p4,++p5,--p6,--p7]).

input_clause(c_2933,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p1,--p2,++p5,--p6]).

input_clause(c_2934,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p1,--p2,++p5,--p7]).

input_clause(c_2935,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p1,--p2]).

input_clause(c_2936,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p1,--p2,--p6,--p7]).

input_clause(c_2937,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p1,--p2,--p3,--p6]).

input_clause(c_2938,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p1,--p2,--p3,--p7]).

input_clause(c_2939,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p1,--p2,--p3,++p5]).

input_clause(c_2940,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p1,--p2,--p3,++p5,--p6,--p7]).

input_clause(c_2941,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p1,--p2,--p3,--p4,++p5,--p6]).

input_clause(c_2942,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p1,--p2,--p3,--p4,++p5,--p7]).

input_clause(c_2943,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p1,--p2,--p3,--p4]).

input_clause(c_2944,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p7,--p1,--p2,--p3,--p4,--p6,--p7]).

input_clause(c_2945,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p1,--p2,--p3,--p4]).

input_clause(c_2946,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p1,--p2,--p3,--p4,++p6,--p7]).

input_clause(c_2947,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p1,--p2,--p3,--p4,++p5,++p6]).

input_clause(c_2948,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p1,--p2,--p3,--p4,++p5,--p7]).

input_clause(c_2949,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p1,--p2,--p3,++p5]).

input_clause(c_2950,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p1,--p2,--p3,++p5,++p6,--p7]).

input_clause(c_2951,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p1,--p2,--p3,++p6]).

input_clause(c_2952,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p1,--p2,--p3,--p7]).

input_clause(c_2953,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p1,--p2]).

input_clause(c_2954,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p1,--p2,++p6,--p7]).

input_clause(c_2955,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p1,--p2,++p5,++p6]).

input_clause(c_2956,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p1,--p2,++p5,--p7]).

input_clause(c_2957,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p1,--p2,--p4,++p5]).

input_clause(c_2958,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p1,--p2,--p4,++p5,++p6,--p7]).

input_clause(c_2959,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p1,--p2,--p4,++p6]).

input_clause(c_2960,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p1,--p2,--p4,--p7]).

input_clause(c_2961,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p1,--p4]).

input_clause(c_2962,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p1,--p4,++p6,--p7]).

input_clause(c_2963,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p1,--p4,++p5,++p6]).

input_clause(c_2964,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p1,--p4,++p5,--p7]).

input_clause(c_2965,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p1,++p5]).

input_clause(c_2966,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p1,++p5,++p6,--p7]).

input_clause(c_2967,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p1,++p6]).

input_clause(c_2968,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p1,--p7]).

input_clause(c_2969,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p1,--p3]).

input_clause(c_2970,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p1,--p3,++p6,--p7]).

input_clause(c_2971,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p1,--p3,++p5,++p6]).

input_clause(c_2972,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p1,--p3,++p5,--p7]).

input_clause(c_2973,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p1,--p3,--p4,++p5]).

input_clause(c_2974,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p1,--p3,--p4,++p5,++p6,--p7]).

input_clause(c_2975,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p1,--p3,--p4,++p6]).

input_clause(c_2976,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p1,--p3,--p4,--p7]).

input_clause(c_2977,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p3,--p4]).

input_clause(c_2978,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p3,--p4,++p6,--p7]).

input_clause(c_2979,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p3,--p4,++p5,++p6]).

input_clause(c_2980,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p3,--p4,++p5,--p7]).

input_clause(c_2981,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p3,++p5]).

input_clause(c_2982,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p3,++p5,++p6,--p7]).

input_clause(c_2983,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p3,++p6]).

input_clause(c_2984,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p3,--p7]).

input_clause(c_2985,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7]).

input_clause(c_2986,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,++p6,--p7]).

input_clause(c_2987,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,++p5,++p6]).

input_clause(c_2988,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,++p5,--p7]).

input_clause(c_2989,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p4,++p5]).

input_clause(c_2990,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p4,++p5,++p6,--p7]).

input_clause(c_2991,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p4,++p6]).

input_clause(c_2992,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p4,--p7]).

input_clause(c_2993,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p2,--p4]).

input_clause(c_2994,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p2,--p4,++p6,--p7]).

input_clause(c_2995,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p2,--p4,++p5,++p6]).

input_clause(c_2996,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p2,--p4,++p5,--p7]).

input_clause(c_2997,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p2,++p5]).

input_clause(c_2998,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p2,++p5,++p6,--p7]).

input_clause(c_2999,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p2,++p6]).

input_clause(c_3000,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p2,--p7]).

input_clause(c_3001,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p2,--p3]).

input_clause(c_3002,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p2,--p3,++p6,--p7]).

input_clause(c_3003,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p2,--p3,++p5,++p6]).

input_clause(c_3004,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p2,--p3,++p5,--p7]).

input_clause(c_3005,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p2,--p3,--p4,++p5]).

input_clause(c_3006,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p2,--p3,--p4,++p5,++p6,--p7]).

input_clause(c_3007,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p2,--p3,--p4,++p6]).

input_clause(c_3008,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p7,--p2,--p3,--p4,--p7]).

input_clause(c_3009,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p2,--p3,--p4,++p7]).

input_clause(c_3010,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p2,--p3,--p4,++p6]).

input_clause(c_3011,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p2,--p3,--p4,++p5,++p6,++p7]).

input_clause(c_3012,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p2,--p3,--p4,++p5]).

input_clause(c_3013,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p2,--p3,++p5,++p7]).

input_clause(c_3014,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p2,--p3,++p5,++p6]).

input_clause(c_3015,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p2,--p3,++p6,++p7]).

input_clause(c_3016,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p2,--p3]).

input_clause(c_3017,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p2,++p7]).

input_clause(c_3018,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p2,++p6]).

input_clause(c_3019,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p2,++p5,++p6,++p7]).

input_clause(c_3020,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p2,++p5]).

input_clause(c_3021,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p2,--p4,++p5,++p7]).

input_clause(c_3022,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p2,--p4,++p5,++p6]).

input_clause(c_3023,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p2,--p4,++p6,++p7]).

input_clause(c_3024,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p2,--p4]).

input_clause(c_3025,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p4,++p7]).

input_clause(c_3026,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p4,++p6]).

input_clause(c_3027,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p4,++p5,++p6,++p7]).

input_clause(c_3028,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p4,++p5]).

input_clause(c_3029,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,++p5,++p7]).

input_clause(c_3030,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,++p5,++p6]).

input_clause(c_3031,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,++p6,++p7]).

input_clause(c_3032,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7]).

input_clause(c_3033,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p3,++p7]).

input_clause(c_3034,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p3,++p6]).

input_clause(c_3035,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p3,++p5,++p6,++p7]).

input_clause(c_3036,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p3,++p5]).

input_clause(c_3037,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p3,--p4,++p5,++p7]).

input_clause(c_3038,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p3,--p4,++p5,++p6]).

input_clause(c_3039,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p3,--p4,++p6,++p7]).

input_clause(c_3040,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p3,--p4]).

input_clause(c_3041,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p1,--p3,--p4,++p7]).

input_clause(c_3042,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p1,--p3,--p4,++p6]).

input_clause(c_3043,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p1,--p3,--p4,++p5,++p6,++p7]).

input_clause(c_3044,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p1,--p3,--p4,++p5]).

input_clause(c_3045,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p1,--p3,++p5,++p7]).

input_clause(c_3046,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p1,--p3,++p5,++p6]).

input_clause(c_3047,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p1,--p3,++p6,++p7]).

input_clause(c_3048,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p1,--p3]).

input_clause(c_3049,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p1,++p7]).

input_clause(c_3050,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p1,++p6]).

input_clause(c_3051,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p1,++p5,++p6,++p7]).

input_clause(c_3052,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p1,++p5]).

input_clause(c_3053,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p1,--p4,++p5,++p7]).

input_clause(c_3054,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p1,--p4,++p5,++p6]).

input_clause(c_3055,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p1,--p4,++p6,++p7]).

input_clause(c_3056,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p1,--p4]).

input_clause(c_3057,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p1,--p2,--p4,++p7]).

input_clause(c_3058,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p1,--p2,--p4,++p6]).

input_clause(c_3059,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p1,--p2,--p4,++p5,++p6,++p7]).

input_clause(c_3060,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p1,--p2,--p4,++p5]).

input_clause(c_3061,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p1,--p2,++p5,++p7]).

input_clause(c_3062,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p1,--p2,++p5,++p6]).

input_clause(c_3063,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p1,--p2,++p6,++p7]).

input_clause(c_3064,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p1,--p2]).

input_clause(c_3065,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p1,--p2,--p3,++p7]).

input_clause(c_3066,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p1,--p2,--p3,++p6]).

input_clause(c_3067,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p1,--p2,--p3,++p5,++p6,++p7]).

input_clause(c_3068,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p1,--p2,--p3,++p5]).

input_clause(c_3069,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p1,--p2,--p3,--p4,++p5,++p7]).

input_clause(c_3070,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p1,--p2,--p3,--p4,++p5,++p6]).

input_clause(c_3071,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p1,--p2,--p3,--p4,++p6,++p7]).

input_clause(c_3072,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p7,--p1,--p2,--p3,--p4]).

input_clause(c_3073,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,--p1,--p2,--p4,++p7]).

input_clause(c_3074,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,--p1,--p2,--p4,++p6]).

input_clause(c_3075,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,--p1,--p2,--p4,++p5,++p6,++p7]).

input_clause(c_3076,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,--p1,--p2,--p4,++p5]).

input_clause(c_3077,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,--p1,--p2,++p5,++p7]).

input_clause(c_3078,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,--p1,--p2,++p5,++p6]).

input_clause(c_3079,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,--p1,--p2,++p6,++p7]).

input_clause(c_3080,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,--p1,--p2]).

input_clause(c_3081,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,--p1,--p2,++p3,++p7]).

input_clause(c_3082,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,--p1,--p2,++p3,++p6]).

input_clause(c_3083,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,--p1,--p2,++p3,++p5,++p6,++p7]).

input_clause(c_3084,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,--p1,--p2,++p3,++p5]).

input_clause(c_3085,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,--p1,--p2,++p3,--p4,++p5,++p7]).

input_clause(c_3086,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,--p1,--p2,++p3,--p4,++p5,++p6]).

input_clause(c_3087,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,--p1,--p2,++p3,--p4,++p6,++p7]).

input_clause(c_3088,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,--p1,--p2,++p3,--p4]).

input_clause(c_3089,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,--p1,++p3,--p4,++p7]).

input_clause(c_3090,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,--p1,++p3,--p4,++p6]).

input_clause(c_3091,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,--p1,++p3,--p4,++p5,++p6,++p7]).

input_clause(c_3092,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,--p1,++p3,--p4,++p5]).

input_clause(c_3093,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,--p1,++p3,++p5,++p7]).

input_clause(c_3094,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,--p1,++p3,++p5,++p6]).

input_clause(c_3095,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,--p1,++p3,++p6,++p7]).

input_clause(c_3096,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,--p1,++p3]).

input_clause(c_3097,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,--p1,++p7]).

input_clause(c_3098,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,--p1,++p6]).

input_clause(c_3099,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,--p1,++p5,++p6,++p7]).

input_clause(c_3100,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,--p1,++p5]).

input_clause(c_3101,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,--p1,--p4,++p5,++p7]).

input_clause(c_3102,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,--p1,--p4,++p5,++p6]).

input_clause(c_3103,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,--p1,--p4,++p6,++p7]).

input_clause(c_3104,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,--p1,--p4]).

input_clause(c_3105,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,--p4,++p7]).

input_clause(c_3106,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,--p4,++p6]).

input_clause(c_3107,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,--p4,++p5,++p6,++p7]).

input_clause(c_3108,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,--p4,++p5]).

input_clause(c_3109,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,++p5,++p7]).

input_clause(c_3110,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,++p5,++p6]).

input_clause(c_3111,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,++p6,++p7]).

input_clause(c_3112,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7]).

input_clause(c_3113,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,++p3,++p7]).

input_clause(c_3114,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,++p3,++p6]).

input_clause(c_3115,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,++p3,++p5,++p6,++p7]).

input_clause(c_3116,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,++p3,++p5]).

input_clause(c_3117,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,++p3,--p4,++p5,++p7]).

input_clause(c_3118,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,++p3,--p4,++p5,++p6]).

input_clause(c_3119,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,++p3,--p4,++p6,++p7]).

input_clause(c_3120,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,++p3,--p4]).

input_clause(c_3121,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,--p2,++p3,--p4,++p7]).

input_clause(c_3122,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,--p2,++p3,--p4,++p6]).

input_clause(c_3123,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,--p2,++p3,--p4,++p5,++p6,++p7]).

input_clause(c_3124,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,--p2,++p3,--p4,++p5]).

input_clause(c_3125,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,--p2,++p3,++p5,++p7]).

input_clause(c_3126,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,--p2,++p3,++p5,++p6]).

input_clause(c_3127,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,--p2,++p3,++p6,++p7]).

input_clause(c_3128,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,--p2,++p3]).

input_clause(c_3129,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,--p2,++p7]).

input_clause(c_3130,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,--p2,++p6]).

input_clause(c_3131,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,--p2,++p5,++p6,++p7]).

input_clause(c_3132,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,--p2,++p5]).

input_clause(c_3133,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,--p2,--p4,++p5,++p7]).

input_clause(c_3134,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,--p2,--p4,++p5,++p6]).

input_clause(c_3135,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,--p2,--p4,++p6,++p7]).

input_clause(c_3136,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p7,--p2,--p4]).

input_clause(c_3137,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,--p2,--p4]).

input_clause(c_3138,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,--p2,--p4,++p6,--p7]).

input_clause(c_3139,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,--p2,--p4,++p5,++p6]).

input_clause(c_3140,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,--p2,--p4,++p5,--p7]).

input_clause(c_3141,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,--p2,++p5]).

input_clause(c_3142,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,--p2,++p5,++p6,--p7]).

input_clause(c_3143,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,--p2,++p6]).

input_clause(c_3144,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,--p2,--p7]).

input_clause(c_3145,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,--p2,++p3]).

input_clause(c_3146,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,--p2,++p3,++p6,--p7]).

input_clause(c_3147,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,--p2,++p3,++p5,++p6]).

input_clause(c_3148,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,--p2,++p3,++p5,--p7]).

input_clause(c_3149,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,--p2,++p3,--p4,++p5]).

input_clause(c_3150,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,--p2,++p3,--p4,++p5,++p6,--p7]).

input_clause(c_3151,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,--p2,++p3,--p4,++p6]).

input_clause(c_3152,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,--p2,++p3,--p4,--p7]).

input_clause(c_3153,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,++p3,--p4]).

input_clause(c_3154,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,++p3,--p4,++p6,--p7]).

input_clause(c_3155,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,++p3,--p4,++p5,++p6]).

input_clause(c_3156,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,++p3,--p4,++p5,--p7]).

input_clause(c_3157,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,++p3,++p5]).

input_clause(c_3158,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,++p3,++p5,++p6,--p7]).

input_clause(c_3159,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,++p3,++p6]).

input_clause(c_3160,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,++p3,--p7]).

input_clause(c_3161,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7]).

input_clause(c_3162,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,++p6,--p7]).

input_clause(c_3163,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,++p5,++p6]).

input_clause(c_3164,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,++p5,--p7]).

input_clause(c_3165,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,--p4,++p5]).

input_clause(c_3166,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,--p4,++p5,++p6,--p7]).

input_clause(c_3167,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,--p4,++p6]).

input_clause(c_3168,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,--p4,--p7]).

input_clause(c_3169,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,--p1,--p4]).

input_clause(c_3170,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,--p1,--p4,++p6,--p7]).

input_clause(c_3171,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,--p1,--p4,++p5,++p6]).

input_clause(c_3172,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,--p1,--p4,++p5,--p7]).

input_clause(c_3173,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,--p1,++p5]).

input_clause(c_3174,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,--p1,++p5,++p6,--p7]).

input_clause(c_3175,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,--p1,++p6]).

input_clause(c_3176,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,--p1,--p7]).

input_clause(c_3177,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,--p1,++p3]).

input_clause(c_3178,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,--p1,++p3,++p6,--p7]).

input_clause(c_3179,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,--p1,++p3,++p5,++p6]).

input_clause(c_3180,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,--p1,++p3,++p5,--p7]).

input_clause(c_3181,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,--p1,++p3,--p4,++p5]).

input_clause(c_3182,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,--p1,++p3,--p4,++p5,++p6,--p7]).

input_clause(c_3183,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,--p1,++p3,--p4,++p6]).

input_clause(c_3184,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,--p1,++p3,--p4,--p7]).

input_clause(c_3185,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,--p1,--p2,++p3,--p4]).

input_clause(c_3186,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,--p1,--p2,++p3,--p4,++p6,--p7]).

input_clause(c_3187,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,--p1,--p2,++p3,--p4,++p5,++p6]).

input_clause(c_3188,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,--p1,--p2,++p3,--p4,++p5,--p7]).

input_clause(c_3189,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,--p1,--p2,++p3,++p5]).

input_clause(c_3190,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,--p1,--p2,++p3,++p5,++p6,--p7]).

input_clause(c_3191,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,--p1,--p2,++p3,++p6]).

input_clause(c_3192,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,--p1,--p2,++p3,--p7]).

input_clause(c_3193,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,--p1,--p2]).

input_clause(c_3194,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,--p1,--p2,++p6,--p7]).

input_clause(c_3195,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,--p1,--p2,++p5,++p6]).

input_clause(c_3196,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,--p1,--p2,++p5,--p7]).

input_clause(c_3197,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,--p1,--p2,--p4,++p5]).

input_clause(c_3198,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,--p1,--p2,--p4,++p5,++p6,--p7]).

input_clause(c_3199,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,--p1,--p2,--p4,++p6]).

input_clause(c_3200,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p7,--p1,--p2,--p4,--p7]).

input_clause(c_3201,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,--p1,--p2,--p4,--p6]).

input_clause(c_3202,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,--p1,--p2,--p4,--p7]).

input_clause(c_3203,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,--p1,--p2,--p4,++p5]).

input_clause(c_3204,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,--p1,--p2,--p4,++p5,--p6,--p7]).

input_clause(c_3205,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,--p1,--p2,++p5,--p6]).

input_clause(c_3206,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,--p1,--p2,++p5,--p7]).

input_clause(c_3207,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,--p1,--p2]).

input_clause(c_3208,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,--p1,--p2,--p6,--p7]).

input_clause(c_3209,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,--p1,--p2,++p3,--p6]).

input_clause(c_3210,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,--p1,--p2,++p3,--p7]).

input_clause(c_3211,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,--p1,--p2,++p3,++p5]).

input_clause(c_3212,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,--p1,--p2,++p3,++p5,--p6,--p7]).

input_clause(c_3213,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,--p1,--p2,++p3,--p4,++p5,--p6]).

input_clause(c_3214,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,--p1,--p2,++p3,--p4,++p5,--p7]).

input_clause(c_3215,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,--p1,--p2,++p3,--p4]).

input_clause(c_3216,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,--p1,--p2,++p3,--p4,--p6,--p7]).

input_clause(c_3217,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,--p1,++p3,--p4,--p6]).

input_clause(c_3218,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,--p1,++p3,--p4,--p7]).

input_clause(c_3219,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,--p1,++p3,--p4,++p5]).

input_clause(c_3220,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,--p1,++p3,--p4,++p5,--p6,--p7]).

input_clause(c_3221,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,--p1,++p3,++p5,--p6]).

input_clause(c_3222,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,--p1,++p3,++p5,--p7]).

input_clause(c_3223,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,--p1,++p3]).

input_clause(c_3224,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,--p1,++p3,--p6,--p7]).

input_clause(c_3225,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,--p1,--p6]).

input_clause(c_3226,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,--p1,--p7]).

input_clause(c_3227,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,--p1,++p5]).

input_clause(c_3228,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,--p1,++p5,--p6,--p7]).

input_clause(c_3229,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,--p1,--p4,++p5,--p6]).

input_clause(c_3230,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,--p1,--p4,++p5,--p7]).

input_clause(c_3231,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,--p1,--p4]).

input_clause(c_3232,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,--p1,--p4,--p6,--p7]).

input_clause(c_3233,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,--p4,--p6]).

input_clause(c_3234,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,--p4,--p7]).

input_clause(c_3235,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,--p4,++p5]).

input_clause(c_3236,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,--p4,++p5,--p6,--p7]).

input_clause(c_3237,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,++p5,--p6]).

input_clause(c_3238,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,++p5,--p7]).

input_clause(c_3239,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7]).

input_clause(c_3240,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,--p6,--p7]).

input_clause(c_3241,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,++p3,--p6]).

input_clause(c_3242,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,++p3,--p7]).

input_clause(c_3243,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,++p3,++p5]).

input_clause(c_3244,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,++p3,++p5,--p6,--p7]).

input_clause(c_3245,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,++p3,--p4,++p5,--p6]).

input_clause(c_3246,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,++p3,--p4,++p5,--p7]).

input_clause(c_3247,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,++p3,--p4]).

input_clause(c_3248,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,++p3,--p4,--p6,--p7]).

input_clause(c_3249,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,--p2,++p3,--p4,--p6]).

input_clause(c_3250,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,--p2,++p3,--p4,--p7]).

input_clause(c_3251,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,--p2,++p3,--p4,++p5]).

input_clause(c_3252,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,--p2,++p3,--p4,++p5,--p6,--p7]).

input_clause(c_3253,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,--p2,++p3,++p5,--p6]).

input_clause(c_3254,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,--p2,++p3,++p5,--p7]).

input_clause(c_3255,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,--p2,++p3]).

input_clause(c_3256,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,--p2,++p3,--p6,--p7]).

input_clause(c_3257,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,--p2,--p6]).

input_clause(c_3258,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,--p2,--p7]).

input_clause(c_3259,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,--p2,++p5]).

input_clause(c_3260,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,--p2,++p5,--p6,--p7]).

input_clause(c_3261,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,--p2,--p4,++p5,--p6]).

input_clause(c_3262,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,--p2,--p4,++p5,--p7]).

input_clause(c_3263,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,--p2,--p4]).

input_clause(c_3264,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p7,--p2,--p4,--p6,--p7]).

input_clause(c_3265,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,--p2,--p4,--p6,++p7]).

input_clause(c_3266,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,--p2,--p4]).

input_clause(c_3267,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,--p2,--p4,++p5,++p7]).

input_clause(c_3268,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,--p2,--p4,++p5,--p6]).

input_clause(c_3269,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,--p2,++p5,--p6,++p7]).

input_clause(c_3270,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,--p2,++p5]).

input_clause(c_3271,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,--p2,++p7]).

input_clause(c_3272,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,--p2,--p6]).

input_clause(c_3273,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,--p2,++p3,--p6,++p7]).

input_clause(c_3274,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,--p2,++p3]).

input_clause(c_3275,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,--p2,++p3,++p5,++p7]).

input_clause(c_3276,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,--p2,++p3,++p5,--p6]).

input_clause(c_3277,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,--p2,++p3,--p4,++p5,--p6,++p7]).

input_clause(c_3278,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,--p2,++p3,--p4,++p5]).

input_clause(c_3279,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,--p2,++p3,--p4,++p7]).

input_clause(c_3280,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,--p2,++p3,--p4,--p6]).

input_clause(c_3281,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,++p3,--p4,--p6,++p7]).

input_clause(c_3282,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,++p3,--p4]).

input_clause(c_3283,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,++p3,--p4,++p5,++p7]).

input_clause(c_3284,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,++p3,--p4,++p5,--p6]).

input_clause(c_3285,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,++p3,++p5,--p6,++p7]).

input_clause(c_3286,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,++p3,++p5]).

input_clause(c_3287,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,++p3,++p7]).

input_clause(c_3288,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,++p3,--p6]).

input_clause(c_3289,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,--p6,++p7]).

input_clause(c_3290,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7]).

input_clause(c_3291,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,++p5,++p7]).

input_clause(c_3292,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,++p5,--p6]).

input_clause(c_3293,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,--p4,++p5,--p6,++p7]).

input_clause(c_3294,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,--p4,++p5]).

input_clause(c_3295,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,--p4,++p7]).

input_clause(c_3296,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,--p4,--p6]).

input_clause(c_3297,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,--p1,--p4,--p6,++p7]).

input_clause(c_3298,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,--p1,--p4]).

input_clause(c_3299,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,--p1,--p4,++p5,++p7]).

input_clause(c_3300,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,--p1,--p4,++p5,--p6]).

input_clause(c_3301,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,--p1,++p5,--p6,++p7]).

input_clause(c_3302,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,--p1,++p5]).

input_clause(c_3303,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,--p1,++p7]).

input_clause(c_3304,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,--p1,--p6]).

input_clause(c_3305,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,--p1,++p3,--p6,++p7]).

input_clause(c_3306,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,--p1,++p3]).

input_clause(c_3307,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,--p1,++p3,++p5,++p7]).

input_clause(c_3308,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,--p1,++p3,++p5,--p6]).

input_clause(c_3309,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,--p1,++p3,--p4,++p5,--p6,++p7]).

input_clause(c_3310,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,--p1,++p3,--p4,++p5]).

input_clause(c_3311,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,--p1,++p3,--p4,++p7]).

input_clause(c_3312,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,--p1,++p3,--p4,--p6]).

input_clause(c_3313,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,--p1,--p2,++p3,--p4,--p6,++p7]).

input_clause(c_3314,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,--p1,--p2,++p3,--p4]).

input_clause(c_3315,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,--p1,--p2,++p3,--p4,++p5,++p7]).

input_clause(c_3316,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,--p1,--p2,++p3,--p4,++p5,--p6]).

input_clause(c_3317,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,--p1,--p2,++p3,++p5,--p6,++p7]).

input_clause(c_3318,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,--p1,--p2,++p3,++p5]).

input_clause(c_3319,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,--p1,--p2,++p3,++p7]).

input_clause(c_3320,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,--p1,--p2,++p3,--p6]).

input_clause(c_3321,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,--p1,--p2,--p6,++p7]).

input_clause(c_3322,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,--p1,--p2]).

input_clause(c_3323,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,--p1,--p2,++p5,++p7]).

input_clause(c_3324,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,--p1,--p2,++p5,--p6]).

input_clause(c_3325,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,--p1,--p2,--p4,++p5,--p6,++p7]).

input_clause(c_3326,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,--p1,--p2,--p4,++p5]).

input_clause(c_3327,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,--p1,--p2,--p4,++p7]).

input_clause(c_3328,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p7,--p1,--p2,--p4,--p6]).

input_clause(c_3329,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,--p1,--p2,--p4,--p5,--p6,++p7]).

input_clause(c_3330,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,--p1,--p2,--p4,--p5]).

input_clause(c_3331,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,--p1,--p2,--p4,++p7]).

input_clause(c_3332,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,--p1,--p2,--p4,--p6]).

input_clause(c_3333,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,--p1,--p2,--p6,++p7]).

input_clause(c_3334,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,--p1,--p2]).

input_clause(c_3335,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,--p1,--p2,--p5,++p7]).

input_clause(c_3336,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,--p1,--p2,--p5,--p6]).

input_clause(c_3337,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,--p1,--p2,++p3,--p5,--p6,++p7]).

input_clause(c_3338,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,--p1,--p2,++p3,--p5]).

input_clause(c_3339,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,--p1,--p2,++p3,++p7]).

input_clause(c_3340,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,--p1,--p2,++p3,--p6]).

input_clause(c_3341,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,--p1,--p2,++p3,--p4,--p6,++p7]).

input_clause(c_3342,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,--p1,--p2,++p3,--p4]).

input_clause(c_3343,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,--p1,--p2,++p3,--p4,--p5,++p7]).

input_clause(c_3344,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,--p1,--p2,++p3,--p4,--p5,--p6]).

input_clause(c_3345,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,--p1,++p3,--p4,--p5,--p6,++p7]).

input_clause(c_3346,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,--p1,++p3,--p4,--p5]).

input_clause(c_3347,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,--p1,++p3,--p4,++p7]).

input_clause(c_3348,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,--p1,++p3,--p4,--p6]).

input_clause(c_3349,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,--p1,++p3,--p6,++p7]).

input_clause(c_3350,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,--p1,++p3]).

input_clause(c_3351,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,--p1,++p3,--p5,++p7]).

input_clause(c_3352,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,--p1,++p3,--p5,--p6]).

input_clause(c_3353,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,--p1,--p5,--p6,++p7]).

input_clause(c_3354,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,--p1,--p5]).

input_clause(c_3355,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,--p1,++p7]).

input_clause(c_3356,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,--p1,--p6]).

input_clause(c_3357,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,--p1,--p4,--p6,++p7]).

input_clause(c_3358,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,--p1,--p4]).

input_clause(c_3359,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,--p1,--p4,--p5,++p7]).

input_clause(c_3360,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,--p1,--p4,--p5,--p6]).

input_clause(c_3361,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,--p4,--p5,--p6,++p7]).

input_clause(c_3362,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,--p4,--p5]).

input_clause(c_3363,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,--p4,++p7]).

input_clause(c_3364,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,--p4,--p6]).

input_clause(c_3365,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,--p6,++p7]).

input_clause(c_3366,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7]).

input_clause(c_3367,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,--p5,++p7]).

input_clause(c_3368,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,--p5,--p6]).

input_clause(c_3369,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,++p3,--p5,--p6,++p7]).

input_clause(c_3370,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,++p3,--p5]).

input_clause(c_3371,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,++p3,++p7]).

input_clause(c_3372,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,++p3,--p6]).

input_clause(c_3373,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,++p3,--p4,--p6,++p7]).

input_clause(c_3374,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,++p3,--p4]).

input_clause(c_3375,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,++p3,--p4,--p5,++p7]).

input_clause(c_3376,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,++p3,--p4,--p5,--p6]).

input_clause(c_3377,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,--p2,++p3,--p4,--p5,--p6,++p7]).

input_clause(c_3378,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,--p2,++p3,--p4,--p5]).

input_clause(c_3379,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,--p2,++p3,--p4,++p7]).

input_clause(c_3380,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,--p2,++p3,--p4,--p6]).

input_clause(c_3381,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,--p2,++p3,--p6,++p7]).

input_clause(c_3382,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,--p2,++p3]).

input_clause(c_3383,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,--p2,++p3,--p5,++p7]).

input_clause(c_3384,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,--p2,++p3,--p5,--p6]).

input_clause(c_3385,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,--p2,--p5,--p6,++p7]).

input_clause(c_3386,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,--p2,--p5]).

input_clause(c_3387,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,--p2,++p7]).

input_clause(c_3388,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,--p2,--p6]).

input_clause(c_3389,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,--p2,--p4,--p6,++p7]).

input_clause(c_3390,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,--p2,--p4]).

input_clause(c_3391,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,--p2,--p4,--p5,++p7]).

input_clause(c_3392,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p7,--p2,--p4,--p5,--p6]).

input_clause(c_3393,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,--p2,--p4,--p5,--p6]).

input_clause(c_3394,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,--p2,--p4,--p5,--p7]).

input_clause(c_3395,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,--p2,--p4]).

input_clause(c_3396,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,--p2,--p4,--p6,--p7]).

input_clause(c_3397,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,--p2,--p6]).

input_clause(c_3398,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,--p2,--p7]).

input_clause(c_3399,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,--p2,--p5]).

input_clause(c_3400,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,--p2,--p5,--p6,--p7]).

input_clause(c_3401,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,--p2,++p3,--p5,--p6]).

input_clause(c_3402,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,--p2,++p3,--p5,--p7]).

input_clause(c_3403,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,--p2,++p3]).

input_clause(c_3404,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,--p2,++p3,--p6,--p7]).

input_clause(c_3405,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,--p2,++p3,--p4,--p6]).

input_clause(c_3406,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,--p2,++p3,--p4,--p7]).

input_clause(c_3407,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,--p2,++p3,--p4,--p5]).

input_clause(c_3408,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,--p2,++p3,--p4,--p5,--p6,--p7]).

input_clause(c_3409,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,++p3,--p4,--p5,--p6]).

input_clause(c_3410,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,++p3,--p4,--p5,--p7]).

input_clause(c_3411,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,++p3,--p4]).

input_clause(c_3412,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,++p3,--p4,--p6,--p7]).

input_clause(c_3413,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,++p3,--p6]).

input_clause(c_3414,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,++p3,--p7]).

input_clause(c_3415,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,++p3,--p5]).

input_clause(c_3416,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,++p3,--p5,--p6,--p7]).

input_clause(c_3417,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,--p5,--p6]).

input_clause(c_3418,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,--p5,--p7]).

input_clause(c_3419,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7]).

input_clause(c_3420,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,--p6,--p7]).

input_clause(c_3421,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,--p4,--p6]).

input_clause(c_3422,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,--p4,--p7]).

input_clause(c_3423,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,--p4,--p5]).

input_clause(c_3424,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,--p4,--p5,--p6,--p7]).

input_clause(c_3425,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,--p1,--p4,--p5,--p6]).

input_clause(c_3426,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,--p1,--p4,--p5,--p7]).

input_clause(c_3427,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,--p1,--p4]).

input_clause(c_3428,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,--p1,--p4,--p6,--p7]).

input_clause(c_3429,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,--p1,--p6]).

input_clause(c_3430,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,--p1,--p7]).

input_clause(c_3431,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,--p1,--p5]).

input_clause(c_3432,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,--p1,--p5,--p6,--p7]).

input_clause(c_3433,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,--p1,++p3,--p5,--p6]).

input_clause(c_3434,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,--p1,++p3,--p5,--p7]).

input_clause(c_3435,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,--p1,++p3]).

input_clause(c_3436,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,--p1,++p3,--p6,--p7]).

input_clause(c_3437,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,--p1,++p3,--p4,--p6]).

input_clause(c_3438,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,--p1,++p3,--p4,--p7]).

input_clause(c_3439,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,--p1,++p3,--p4,--p5]).

input_clause(c_3440,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,--p1,++p3,--p4,--p5,--p6,--p7]).

input_clause(c_3441,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,--p1,--p2,++p3,--p4,--p5,--p6]).

input_clause(c_3442,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,--p1,--p2,++p3,--p4,--p5,--p7]).

input_clause(c_3443,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,--p1,--p2,++p3,--p4]).

input_clause(c_3444,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,--p1,--p2,++p3,--p4,--p6,--p7]).

input_clause(c_3445,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,--p1,--p2,++p3,--p6]).

input_clause(c_3446,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,--p1,--p2,++p3,--p7]).

input_clause(c_3447,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,--p1,--p2,++p3,--p5]).

input_clause(c_3448,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,--p1,--p2,++p3,--p5,--p6,--p7]).

input_clause(c_3449,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,--p1,--p2,--p5,--p6]).

input_clause(c_3450,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,--p1,--p2,--p5,--p7]).

input_clause(c_3451,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,--p1,--p2]).

input_clause(c_3452,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,--p1,--p2,--p6,--p7]).

input_clause(c_3453,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,--p1,--p2,--p4,--p6]).

input_clause(c_3454,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,--p1,--p2,--p4,--p7]).

input_clause(c_3455,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,--p1,--p2,--p4,--p5]).

input_clause(c_3456,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p7,--p1,--p2,--p4,--p5,--p6,--p7]).

input_clause(c_3457,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,--p1,--p2,--p4,--p5]).

input_clause(c_3458,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,--p1,--p2,--p4,--p5,++p6,--p7]).

input_clause(c_3459,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,--p1,--p2,--p4,++p6]).

input_clause(c_3460,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,--p1,--p2,--p4,--p7]).

input_clause(c_3461,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,--p1,--p2]).

input_clause(c_3462,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,--p1,--p2,++p6,--p7]).

input_clause(c_3463,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,--p1,--p2,--p5,++p6]).

input_clause(c_3464,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,--p1,--p2,--p5,--p7]).

input_clause(c_3465,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,--p1,--p2,++p3,--p5]).

input_clause(c_3466,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,--p1,--p2,++p3,--p5,++p6,--p7]).

input_clause(c_3467,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,--p1,--p2,++p3,++p6]).

input_clause(c_3468,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,--p1,--p2,++p3,--p7]).

input_clause(c_3469,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,--p1,--p2,++p3,--p4]).

input_clause(c_3470,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,--p1,--p2,++p3,--p4,++p6,--p7]).

input_clause(c_3471,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,--p1,--p2,++p3,--p4,--p5,++p6]).

input_clause(c_3472,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,--p1,--p2,++p3,--p4,--p5,--p7]).

input_clause(c_3473,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,--p1,++p3,--p4,--p5]).

input_clause(c_3474,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,--p1,++p3,--p4,--p5,++p6,--p7]).

input_clause(c_3475,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,--p1,++p3,--p4,++p6]).

input_clause(c_3476,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,--p1,++p3,--p4,--p7]).

input_clause(c_3477,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,--p1,++p3]).

input_clause(c_3478,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,--p1,++p3,++p6,--p7]).

input_clause(c_3479,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,--p1,++p3,--p5,++p6]).

input_clause(c_3480,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,--p1,++p3,--p5,--p7]).

input_clause(c_3481,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,--p1,--p5]).

input_clause(c_3482,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,--p1,--p5,++p6,--p7]).

input_clause(c_3483,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,--p1,++p6]).

input_clause(c_3484,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,--p1,--p7]).

input_clause(c_3485,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,--p1,--p4]).

input_clause(c_3486,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,--p1,--p4,++p6,--p7]).

input_clause(c_3487,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,--p1,--p4,--p5,++p6]).

input_clause(c_3488,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,--p1,--p4,--p5,--p7]).

input_clause(c_3489,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,--p4,--p5]).

input_clause(c_3490,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,--p4,--p5,++p6,--p7]).

input_clause(c_3491,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,--p4,++p6]).

input_clause(c_3492,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,--p4,--p7]).

input_clause(c_3493,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7]).

input_clause(c_3494,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,++p6,--p7]).

input_clause(c_3495,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,--p5,++p6]).

input_clause(c_3496,theorem,
    [++p1,++p2,++p5,--p6,++p7,--p5,--p7]).

input_clause(c_3497,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,++p3,--p5]).

input_clause(c_3498,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,++p3,--p5,++p6,--p7]).

input_clause(c_3499,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,++p3,++p6]).

input_clause(c_3500,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,++p3,--p7]).

input_clause(c_3501,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,++p3,--p4]).

input_clause(c_3502,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,++p3,--p4,++p6,--p7]).

input_clause(c_3503,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,++p3,--p4,--p5,++p6]).

input_clause(c_3504,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,++p3,--p4,--p5,--p7]).

input_clause(c_3505,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,--p2,++p3,--p4,--p5]).

input_clause(c_3506,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,--p2,++p3,--p4,--p5,++p6,--p7]).

input_clause(c_3507,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,--p2,++p3,--p4,++p6]).

input_clause(c_3508,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,--p2,++p3,--p4,--p7]).

input_clause(c_3509,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,--p2,++p3]).

input_clause(c_3510,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,--p2,++p3,++p6,--p7]).

input_clause(c_3511,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,--p2,++p3,--p5,++p6]).

input_clause(c_3512,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,--p2,++p3,--p5,--p7]).

input_clause(c_3513,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,--p2,--p5]).

input_clause(c_3514,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,--p2,--p5,++p6,--p7]).

input_clause(c_3515,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,--p2,++p6]).

input_clause(c_3516,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,--p2,--p7]).

input_clause(c_3517,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,--p2,--p4]).

input_clause(c_3518,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,--p2,--p4,++p6,--p7]).

input_clause(c_3519,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,--p2,--p4,--p5,++p6]).

input_clause(c_3520,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p7,--p2,--p4,--p5,--p7]).

input_clause(c_3521,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,--p2,--p4,--p5,++p7]).

input_clause(c_3522,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,--p2,--p4,--p5,++p6]).

input_clause(c_3523,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,--p2,--p4,++p6,++p7]).

input_clause(c_3524,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,--p2,--p4]).

input_clause(c_3525,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,--p2,++p7]).

input_clause(c_3526,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,--p2,++p6]).

input_clause(c_3527,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,--p2,--p5,++p6,++p7]).

input_clause(c_3528,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,--p2,--p5]).

input_clause(c_3529,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,--p2,++p3,--p5,++p7]).

input_clause(c_3530,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,--p2,++p3,--p5,++p6]).

input_clause(c_3531,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,--p2,++p3,++p6,++p7]).

input_clause(c_3532,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,--p2,++p3]).

input_clause(c_3533,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,--p2,++p3,--p4,++p7]).

input_clause(c_3534,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,--p2,++p3,--p4,++p6]).

input_clause(c_3535,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,--p2,++p3,--p4,--p5,++p6,++p7]).

input_clause(c_3536,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,--p2,++p3,--p4,--p5]).

input_clause(c_3537,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,++p3,--p4,--p5,++p7]).

input_clause(c_3538,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,++p3,--p4,--p5,++p6]).

input_clause(c_3539,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,++p3,--p4,++p6,++p7]).

input_clause(c_3540,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,++p3,--p4]).

input_clause(c_3541,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,++p3,++p7]).

input_clause(c_3542,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,++p3,++p6]).

input_clause(c_3543,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,++p3,--p5,++p6,++p7]).

input_clause(c_3544,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,++p3,--p5]).

input_clause(c_3545,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,--p5,++p7]).

input_clause(c_3546,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,--p5,++p6]).

input_clause(c_3547,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,++p6,++p7]).

input_clause(c_3548,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7]).

input_clause(c_3549,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,--p4,++p7]).

input_clause(c_3550,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,--p4,++p6]).

input_clause(c_3551,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,--p4,--p5,++p6,++p7]).

input_clause(c_3552,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,--p4,--p5]).

input_clause(c_3553,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,--p1,--p4,--p5,++p7]).

input_clause(c_3554,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,--p1,--p4,--p5,++p6]).

input_clause(c_3555,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,--p1,--p4,++p6,++p7]).

input_clause(c_3556,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,--p1,--p4]).

input_clause(c_3557,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,--p1,++p7]).

input_clause(c_3558,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,--p1,++p6]).

input_clause(c_3559,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,--p1,--p5,++p6,++p7]).

input_clause(c_3560,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,--p1,--p5]).

input_clause(c_3561,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,--p1,++p3,--p5,++p7]).

input_clause(c_3562,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,--p1,++p3,--p5,++p6]).

input_clause(c_3563,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,--p1,++p3,++p6,++p7]).

input_clause(c_3564,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,--p1,++p3]).

input_clause(c_3565,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,--p1,++p3,--p4,++p7]).

input_clause(c_3566,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,--p1,++p3,--p4,++p6]).

input_clause(c_3567,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,--p1,++p3,--p4,--p5,++p6,++p7]).

input_clause(c_3568,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,--p1,++p3,--p4,--p5]).

input_clause(c_3569,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,--p1,--p2,++p3,--p4,--p5,++p7]).

input_clause(c_3570,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,--p1,--p2,++p3,--p4,--p5,++p6]).

input_clause(c_3571,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,--p1,--p2,++p3,--p4,++p6,++p7]).

input_clause(c_3572,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,--p1,--p2,++p3,--p4]).

input_clause(c_3573,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,--p1,--p2,++p3,++p7]).

input_clause(c_3574,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,--p1,--p2,++p3,++p6]).

input_clause(c_3575,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,--p1,--p2,++p3,--p5,++p6,++p7]).

input_clause(c_3576,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,--p1,--p2,++p3,--p5]).

input_clause(c_3577,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,--p1,--p2,--p5,++p7]).

input_clause(c_3578,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,--p1,--p2,--p5,++p6]).

input_clause(c_3579,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,--p1,--p2,++p6,++p7]).

input_clause(c_3580,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,--p1,--p2]).

input_clause(c_3581,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,--p1,--p2,--p4,++p7]).

input_clause(c_3582,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,--p1,--p2,--p4,++p6]).

input_clause(c_3583,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,--p1,--p2,--p4,--p5,++p6,++p7]).

input_clause(c_3584,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p7,--p1,--p2,--p4,--p5]).

input_clause(c_3585,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,--p1,--p2,--p5,++p7]).

input_clause(c_3586,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,--p1,--p2,--p5,++p6]).

input_clause(c_3587,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,--p1,--p2,++p6,++p7]).

input_clause(c_3588,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,--p1,--p2]).

input_clause(c_3589,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,--p1,--p2,++p4,++p7]).

input_clause(c_3590,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,--p1,--p2,++p4,++p6]).

input_clause(c_3591,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,--p1,--p2,++p4,--p5,++p6,++p7]).

input_clause(c_3592,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,--p1,--p2,++p4,--p5]).

input_clause(c_3593,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,--p1,--p2,++p3,++p4,--p5,++p7]).

input_clause(c_3594,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,--p1,--p2,++p3,++p4,--p5,++p6]).

input_clause(c_3595,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,--p1,--p2,++p3,++p4,++p6,++p7]).

input_clause(c_3596,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,--p1,--p2,++p3,++p4]).

input_clause(c_3597,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,--p1,--p2,++p3,++p7]).

input_clause(c_3598,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,--p1,--p2,++p3,++p6]).

input_clause(c_3599,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,--p1,--p2,++p3,--p5,++p6,++p7]).

input_clause(c_3600,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,--p1,--p2,++p3,--p5]).

input_clause(c_3601,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,--p1,++p3,--p5,++p7]).

input_clause(c_3602,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,--p1,++p3,--p5,++p6]).

input_clause(c_3603,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,--p1,++p3,++p6,++p7]).

input_clause(c_3604,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,--p1,++p3]).

input_clause(c_3605,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,--p1,++p3,++p4,++p7]).

input_clause(c_3606,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,--p1,++p3,++p4,++p6]).

input_clause(c_3607,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,--p1,++p3,++p4,--p5,++p6,++p7]).

input_clause(c_3608,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,--p1,++p3,++p4,--p5]).

input_clause(c_3609,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,--p1,++p4,--p5,++p7]).

input_clause(c_3610,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,--p1,++p4,--p5,++p6]).

input_clause(c_3611,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,--p1,++p4,++p6,++p7]).

input_clause(c_3612,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,--p1,++p4]).

input_clause(c_3613,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,--p1,++p7]).

input_clause(c_3614,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,--p1,++p6]).

input_clause(c_3615,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,--p1,--p5,++p6,++p7]).

input_clause(c_3616,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,--p1,--p5]).

input_clause(c_3617,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,--p5,++p7]).

input_clause(c_3618,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,--p5,++p6]).

input_clause(c_3619,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,++p6,++p7]).

input_clause(c_3620,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7]).

input_clause(c_3621,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,++p4,++p7]).

input_clause(c_3622,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,++p4,++p6]).

input_clause(c_3623,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,++p4,--p5,++p6,++p7]).

input_clause(c_3624,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,++p4,--p5]).

input_clause(c_3625,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,++p3,++p4,--p5,++p7]).

input_clause(c_3626,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,++p3,++p4,--p5,++p6]).

input_clause(c_3627,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,++p3,++p4,++p6,++p7]).

input_clause(c_3628,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,++p3,++p4]).

input_clause(c_3629,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,++p3,++p7]).

input_clause(c_3630,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,++p3,++p6]).

input_clause(c_3631,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,++p3,--p5,++p6,++p7]).

input_clause(c_3632,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,++p3,--p5]).

input_clause(c_3633,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,--p2,++p3,--p5,++p7]).

input_clause(c_3634,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,--p2,++p3,--p5,++p6]).

input_clause(c_3635,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,--p2,++p3,++p6,++p7]).

input_clause(c_3636,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,--p2,++p3]).

input_clause(c_3637,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,--p2,++p3,++p4,++p7]).

input_clause(c_3638,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,--p2,++p3,++p4,++p6]).

input_clause(c_3639,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,--p2,++p3,++p4,--p5,++p6,++p7]).

input_clause(c_3640,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,--p2,++p3,++p4,--p5]).

input_clause(c_3641,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,--p2,++p4,--p5,++p7]).

input_clause(c_3642,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,--p2,++p4,--p5,++p6]).

input_clause(c_3643,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,--p2,++p4,++p6,++p7]).

input_clause(c_3644,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,--p2,++p4]).

input_clause(c_3645,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,--p2,++p7]).

input_clause(c_3646,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,--p2,++p6]).

input_clause(c_3647,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,--p2,--p5,++p6,++p7]).

input_clause(c_3648,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p7,--p2,--p5]).

input_clause(c_3649,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,--p2,--p5]).

input_clause(c_3650,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,--p2,--p5,++p6,--p7]).

input_clause(c_3651,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,--p2,++p6]).

input_clause(c_3652,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,--p2,--p7]).

input_clause(c_3653,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,--p2,++p4]).

input_clause(c_3654,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,--p2,++p4,++p6,--p7]).

input_clause(c_3655,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,--p2,++p4,--p5,++p6]).

input_clause(c_3656,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,--p2,++p4,--p5,--p7]).

input_clause(c_3657,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,--p2,++p3,++p4,--p5]).

input_clause(c_3658,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,--p2,++p3,++p4,--p5,++p6,--p7]).

input_clause(c_3659,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,--p2,++p3,++p4,++p6]).

input_clause(c_3660,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,--p2,++p3,++p4,--p7]).

input_clause(c_3661,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,--p2,++p3]).

input_clause(c_3662,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,--p2,++p3,++p6,--p7]).

input_clause(c_3663,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,--p2,++p3,--p5,++p6]).

input_clause(c_3664,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,--p2,++p3,--p5,--p7]).

input_clause(c_3665,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,++p3,--p5]).

input_clause(c_3666,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,++p3,--p5,++p6,--p7]).

input_clause(c_3667,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,++p3,++p6]).

input_clause(c_3668,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,++p3,--p7]).

input_clause(c_3669,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,++p3,++p4]).

input_clause(c_3670,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,++p3,++p4,++p6,--p7]).

input_clause(c_3671,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,++p3,++p4,--p5,++p6]).

input_clause(c_3672,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,++p3,++p4,--p5,--p7]).

input_clause(c_3673,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,++p4,--p5]).

input_clause(c_3674,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,++p4,--p5,++p6,--p7]).

input_clause(c_3675,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,++p4,++p6]).

input_clause(c_3676,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,++p4,--p7]).

input_clause(c_3677,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7]).

input_clause(c_3678,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,++p6,--p7]).

input_clause(c_3679,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,--p5,++p6]).

input_clause(c_3680,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,--p5,--p7]).

input_clause(c_3681,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,--p1,--p5]).

input_clause(c_3682,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,--p1,--p5,++p6,--p7]).

input_clause(c_3683,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,--p1,++p6]).

input_clause(c_3684,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,--p1,--p7]).

input_clause(c_3685,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,--p1,++p4]).

input_clause(c_3686,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,--p1,++p4,++p6,--p7]).

input_clause(c_3687,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,--p1,++p4,--p5,++p6]).

input_clause(c_3688,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,--p1,++p4,--p5,--p7]).

input_clause(c_3689,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,--p1,++p3,++p4,--p5]).

input_clause(c_3690,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,--p1,++p3,++p4,--p5,++p6,--p7]).

input_clause(c_3691,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,--p1,++p3,++p4,++p6]).

input_clause(c_3692,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,--p1,++p3,++p4,--p7]).

input_clause(c_3693,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,--p1,++p3]).

input_clause(c_3694,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,--p1,++p3,++p6,--p7]).

input_clause(c_3695,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,--p1,++p3,--p5,++p6]).

input_clause(c_3696,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,--p1,++p3,--p5,--p7]).

input_clause(c_3697,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,--p1,--p2,++p3,--p5]).

input_clause(c_3698,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,--p1,--p2,++p3,--p5,++p6,--p7]).

input_clause(c_3699,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,--p1,--p2,++p3,++p6]).

input_clause(c_3700,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,--p1,--p2,++p3,--p7]).

input_clause(c_3701,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,--p1,--p2,++p3,++p4]).

input_clause(c_3702,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,--p1,--p2,++p3,++p4,++p6,--p7]).

input_clause(c_3703,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,--p1,--p2,++p3,++p4,--p5,++p6]).

input_clause(c_3704,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,--p1,--p2,++p3,++p4,--p5,--p7]).

input_clause(c_3705,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,--p1,--p2,++p4,--p5]).

input_clause(c_3706,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,--p1,--p2,++p4,--p5,++p6,--p7]).

input_clause(c_3707,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,--p1,--p2,++p4,++p6]).

input_clause(c_3708,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,--p1,--p2,++p4,--p7]).

input_clause(c_3709,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,--p1,--p2]).

input_clause(c_3710,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,--p1,--p2,++p6,--p7]).

input_clause(c_3711,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,--p1,--p2,--p5,++p6]).

input_clause(c_3712,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p7,--p1,--p2,--p5,--p7]).

input_clause(c_3713,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,--p1,--p2,--p5,--p6]).

input_clause(c_3714,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,--p1,--p2,--p5,--p7]).

input_clause(c_3715,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,--p1,--p2]).

input_clause(c_3716,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,--p1,--p2,--p6,--p7]).

input_clause(c_3717,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,--p1,--p2,++p4,--p6]).

input_clause(c_3718,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,--p1,--p2,++p4,--p7]).

input_clause(c_3719,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,--p1,--p2,++p4,--p5]).

input_clause(c_3720,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,--p1,--p2,++p4,--p5,--p6,--p7]).

input_clause(c_3721,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,--p1,--p2,++p3,++p4,--p5,--p6]).

input_clause(c_3722,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,--p1,--p2,++p3,++p4,--p5,--p7]).

input_clause(c_3723,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,--p1,--p2,++p3,++p4]).

input_clause(c_3724,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,--p1,--p2,++p3,++p4,--p6,--p7]).

input_clause(c_3725,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,--p1,--p2,++p3,--p6]).

input_clause(c_3726,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,--p1,--p2,++p3,--p7]).

input_clause(c_3727,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,--p1,--p2,++p3,--p5]).

input_clause(c_3728,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,--p1,--p2,++p3,--p5,--p6,--p7]).

input_clause(c_3729,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,--p1,++p3,--p5,--p6]).

input_clause(c_3730,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,--p1,++p3,--p5,--p7]).

input_clause(c_3731,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,--p1,++p3]).

input_clause(c_3732,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,--p1,++p3,--p6,--p7]).

input_clause(c_3733,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,--p1,++p3,++p4,--p6]).

input_clause(c_3734,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,--p1,++p3,++p4,--p7]).

input_clause(c_3735,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,--p1,++p3,++p4,--p5]).

input_clause(c_3736,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,--p1,++p3,++p4,--p5,--p6,--p7]).

input_clause(c_3737,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,--p1,++p4,--p5,--p6]).

input_clause(c_3738,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,--p1,++p4,--p5,--p7]).

input_clause(c_3739,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,--p1,++p4]).

input_clause(c_3740,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,--p1,++p4,--p6,--p7]).

input_clause(c_3741,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,--p1,--p6]).

input_clause(c_3742,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,--p1,--p7]).

input_clause(c_3743,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,--p1,--p5]).

input_clause(c_3744,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,--p1,--p5,--p6,--p7]).

input_clause(c_3745,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,--p5,--p6]).

input_clause(c_3746,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,--p5,--p7]).

input_clause(c_3747,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7]).

input_clause(c_3748,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,--p6,--p7]).

input_clause(c_3749,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,++p4,--p6]).

input_clause(c_3750,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,++p4,--p7]).

input_clause(c_3751,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,++p4,--p5]).

input_clause(c_3752,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,++p4,--p5,--p6,--p7]).

input_clause(c_3753,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,++p3,++p4,--p5,--p6]).

input_clause(c_3754,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,++p3,++p4,--p5,--p7]).

input_clause(c_3755,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,++p3,++p4]).

input_clause(c_3756,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,++p3,++p4,--p6,--p7]).

input_clause(c_3757,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,++p3,--p6]).

input_clause(c_3758,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,++p3,--p7]).

input_clause(c_3759,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,++p3,--p5]).

input_clause(c_3760,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,++p3,--p5,--p6,--p7]).

input_clause(c_3761,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,--p2,++p3,--p5,--p6]).

input_clause(c_3762,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,--p2,++p3,--p5,--p7]).

input_clause(c_3763,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,--p2,++p3]).

input_clause(c_3764,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,--p2,++p3,--p6,--p7]).

input_clause(c_3765,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,--p2,++p3,++p4,--p6]).

input_clause(c_3766,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,--p2,++p3,++p4,--p7]).

input_clause(c_3767,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,--p2,++p3,++p4,--p5]).

input_clause(c_3768,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,--p2,++p3,++p4,--p5,--p6,--p7]).

input_clause(c_3769,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,--p2,++p4,--p5,--p6]).

input_clause(c_3770,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,--p2,++p4,--p5,--p7]).

input_clause(c_3771,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,--p2,++p4]).

input_clause(c_3772,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,--p2,++p4,--p6,--p7]).

input_clause(c_3773,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,--p2,--p6]).

input_clause(c_3774,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,--p2,--p7]).

input_clause(c_3775,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,--p2,--p5]).

input_clause(c_3776,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p7,--p2,--p5,--p6,--p7]).

input_clause(c_3777,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,--p2,--p5,--p6,++p7]).

input_clause(c_3778,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,--p2,--p5]).

input_clause(c_3779,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,--p2,++p7]).

input_clause(c_3780,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,--p2,--p6]).

input_clause(c_3781,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,--p2,++p4,--p6,++p7]).

input_clause(c_3782,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,--p2,++p4]).

input_clause(c_3783,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,--p2,++p4,--p5,++p7]).

input_clause(c_3784,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,--p2,++p4,--p5,--p6]).

input_clause(c_3785,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,--p2,++p3,++p4,--p5,--p6,++p7]).

input_clause(c_3786,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,--p2,++p3,++p4,--p5]).

input_clause(c_3787,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,--p2,++p3,++p4,++p7]).

input_clause(c_3788,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,--p2,++p3,++p4,--p6]).

input_clause(c_3789,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,--p2,++p3,--p6,++p7]).

input_clause(c_3790,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,--p2,++p3]).

input_clause(c_3791,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,--p2,++p3,--p5,++p7]).

input_clause(c_3792,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,--p2,++p3,--p5,--p6]).

input_clause(c_3793,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,++p3,--p5,--p6,++p7]).

input_clause(c_3794,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,++p3,--p5]).

input_clause(c_3795,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,++p3,++p7]).

input_clause(c_3796,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,++p3,--p6]).

input_clause(c_3797,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,++p3,++p4,--p6,++p7]).

input_clause(c_3798,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,++p3,++p4]).

input_clause(c_3799,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,++p3,++p4,--p5,++p7]).

input_clause(c_3800,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,++p3,++p4,--p5,--p6]).

input_clause(c_3801,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,++p4,--p5,--p6,++p7]).

input_clause(c_3802,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,++p4,--p5]).

input_clause(c_3803,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,++p4,++p7]).

input_clause(c_3804,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,++p4,--p6]).

input_clause(c_3805,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,--p6,++p7]).

input_clause(c_3806,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7]).

input_clause(c_3807,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,--p5,++p7]).

input_clause(c_3808,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,--p5,--p6]).

input_clause(c_3809,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,--p1,--p5,--p6,++p7]).

input_clause(c_3810,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,--p1,--p5]).

input_clause(c_3811,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,--p1,++p7]).

input_clause(c_3812,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,--p1,--p6]).

input_clause(c_3813,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,--p1,++p4,--p6,++p7]).

input_clause(c_3814,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,--p1,++p4]).

input_clause(c_3815,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,--p1,++p4,--p5,++p7]).

input_clause(c_3816,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,--p1,++p4,--p5,--p6]).

input_clause(c_3817,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,--p1,++p3,++p4,--p5,--p6,++p7]).

input_clause(c_3818,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,--p1,++p3,++p4,--p5]).

input_clause(c_3819,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,--p1,++p3,++p4,++p7]).

input_clause(c_3820,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,--p1,++p3,++p4,--p6]).

input_clause(c_3821,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,--p1,++p3,--p6,++p7]).

input_clause(c_3822,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,--p1,++p3]).

input_clause(c_3823,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,--p1,++p3,--p5,++p7]).

input_clause(c_3824,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,--p1,++p3,--p5,--p6]).

input_clause(c_3825,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,--p1,--p2,++p3,--p5,--p6,++p7]).

input_clause(c_3826,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,--p1,--p2,++p3,--p5]).

input_clause(c_3827,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,--p1,--p2,++p3,++p7]).

input_clause(c_3828,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,--p1,--p2,++p3,--p6]).

input_clause(c_3829,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,--p1,--p2,++p3,++p4,--p6,++p7]).

input_clause(c_3830,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,--p1,--p2,++p3,++p4]).

input_clause(c_3831,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,--p1,--p2,++p3,++p4,--p5,++p7]).

input_clause(c_3832,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,--p1,--p2,++p3,++p4,--p5,--p6]).

input_clause(c_3833,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,--p1,--p2,++p4,--p5,--p6,++p7]).

input_clause(c_3834,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,--p1,--p2,++p4,--p5]).

input_clause(c_3835,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,--p1,--p2,++p4,++p7]).

input_clause(c_3836,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,--p1,--p2,++p4,--p6]).

input_clause(c_3837,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,--p1,--p2,--p6,++p7]).

input_clause(c_3838,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,--p1,--p2]).

input_clause(c_3839,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,--p1,--p2,--p5,++p7]).

input_clause(c_3840,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p7,--p1,--p2,--p5,--p6]).

input_clause(c_3841,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,--p1,--p2,--p6,++p7]).

input_clause(c_3842,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,--p1,--p2]).

input_clause(c_3843,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,--p1,--p2,++p5,++p7]).

input_clause(c_3844,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,--p1,--p2,++p5,--p6]).

input_clause(c_3845,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,--p1,--p2,++p4,++p5,--p6,++p7]).

input_clause(c_3846,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,--p1,--p2,++p4,++p5]).

input_clause(c_3847,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,--p1,--p2,++p4,++p7]).

input_clause(c_3848,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,--p1,--p2,++p4,--p6]).

input_clause(c_3849,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,--p1,--p2,++p3,++p4,--p6,++p7]).

input_clause(c_3850,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,--p1,--p2,++p3,++p4]).

input_clause(c_3851,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,--p1,--p2,++p3,++p4,++p5,++p7]).

input_clause(c_3852,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,--p1,--p2,++p3,++p4,++p5,--p6]).

input_clause(c_3853,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,--p1,--p2,++p3,++p5,--p6,++p7]).

input_clause(c_3854,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,--p1,--p2,++p3,++p5]).

input_clause(c_3855,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,--p1,--p2,++p3,++p7]).

input_clause(c_3856,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,--p1,--p2,++p3,--p6]).

input_clause(c_3857,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,--p1,++p3,--p6,++p7]).

input_clause(c_3858,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,--p1,++p3]).

input_clause(c_3859,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,--p1,++p3,++p5,++p7]).

input_clause(c_3860,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,--p1,++p3,++p5,--p6]).

input_clause(c_3861,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,--p1,++p3,++p4,++p5,--p6,++p7]).

input_clause(c_3862,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,--p1,++p3,++p4,++p5]).

input_clause(c_3863,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,--p1,++p3,++p4,++p7]).

input_clause(c_3864,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,--p1,++p3,++p4,--p6]).

input_clause(c_3865,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,--p1,++p4,--p6,++p7]).

input_clause(c_3866,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,--p1,++p4]).

input_clause(c_3867,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,--p1,++p4,++p5,++p7]).

input_clause(c_3868,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,--p1,++p4,++p5,--p6]).

input_clause(c_3869,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,--p1,++p5,--p6,++p7]).

input_clause(c_3870,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,--p1,++p5]).

input_clause(c_3871,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,--p1,++p7]).

input_clause(c_3872,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,--p1,--p6]).

input_clause(c_3873,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,--p6,++p7]).

input_clause(c_3874,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7]).

input_clause(c_3875,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,++p5,++p7]).

input_clause(c_3876,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,++p5,--p6]).

input_clause(c_3877,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,++p4,++p5,--p6,++p7]).

input_clause(c_3878,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,++p4,++p5]).

input_clause(c_3879,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,++p4,++p7]).

input_clause(c_3880,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,++p4,--p6]).

input_clause(c_3881,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,++p3,++p4,--p6,++p7]).

input_clause(c_3882,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,++p3,++p4]).

input_clause(c_3883,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,++p3,++p4,++p5,++p7]).

input_clause(c_3884,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,++p3,++p4,++p5,--p6]).

input_clause(c_3885,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,++p3,++p5,--p6,++p7]).

input_clause(c_3886,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,++p3,++p5]).

input_clause(c_3887,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,++p3,++p7]).

input_clause(c_3888,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,++p3,--p6]).

input_clause(c_3889,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,--p2,++p3,--p6,++p7]).

input_clause(c_3890,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,--p2,++p3]).

input_clause(c_3891,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,--p2,++p3,++p5,++p7]).

input_clause(c_3892,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,--p2,++p3,++p5,--p6]).

input_clause(c_3893,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,--p2,++p3,++p4,++p5,--p6,++p7]).

input_clause(c_3894,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,--p2,++p3,++p4,++p5]).

input_clause(c_3895,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,--p2,++p3,++p4,++p7]).

input_clause(c_3896,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,--p2,++p3,++p4,--p6]).

input_clause(c_3897,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,--p2,++p4,--p6,++p7]).

input_clause(c_3898,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,--p2,++p4]).

input_clause(c_3899,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,--p2,++p4,++p5,++p7]).

input_clause(c_3900,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,--p2,++p4,++p5,--p6]).

input_clause(c_3901,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,--p2,++p5,--p6,++p7]).

input_clause(c_3902,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,--p2,++p5]).

input_clause(c_3903,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,--p2,++p7]).

input_clause(c_3904,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p7,--p2,--p6]).

input_clause(c_3905,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,--p2,--p6]).

input_clause(c_3906,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,--p2,--p7]).

input_clause(c_3907,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,--p2,++p5]).

input_clause(c_3908,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,--p2,++p5,--p6,--p7]).

input_clause(c_3909,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,--p2,++p4,++p5,--p6]).

input_clause(c_3910,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,--p2,++p4,++p5,--p7]).

input_clause(c_3911,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,--p2,++p4]).

input_clause(c_3912,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,--p2,++p4,--p6,--p7]).

input_clause(c_3913,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,--p2,++p3,++p4,--p6]).

input_clause(c_3914,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,--p2,++p3,++p4,--p7]).

input_clause(c_3915,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,--p2,++p3,++p4,++p5]).

input_clause(c_3916,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,--p2,++p3,++p4,++p5,--p6,--p7]).

input_clause(c_3917,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,--p2,++p3,++p5,--p6]).

input_clause(c_3918,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,--p2,++p3,++p5,--p7]).

input_clause(c_3919,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,--p2,++p3]).

input_clause(c_3920,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,--p2,++p3,--p6,--p7]).

input_clause(c_3921,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,++p3,--p6]).

input_clause(c_3922,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,++p3,--p7]).

input_clause(c_3923,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,++p3,++p5]).

input_clause(c_3924,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,++p3,++p5,--p6,--p7]).

input_clause(c_3925,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,++p3,++p4,++p5,--p6]).

input_clause(c_3926,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,++p3,++p4,++p5,--p7]).

input_clause(c_3927,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,++p3,++p4]).

input_clause(c_3928,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,++p3,++p4,--p6,--p7]).

input_clause(c_3929,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,++p4,--p6]).

input_clause(c_3930,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,++p4,--p7]).

input_clause(c_3931,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,++p4,++p5]).

input_clause(c_3932,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,++p4,++p5,--p6,--p7]).

input_clause(c_3933,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,++p5,--p6]).

input_clause(c_3934,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,++p5,--p7]).

input_clause(c_3935,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7]).

input_clause(c_3936,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,--p6,--p7]).

input_clause(c_3937,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,--p1,--p6]).

input_clause(c_3938,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,--p1,--p7]).

input_clause(c_3939,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,--p1,++p5]).

input_clause(c_3940,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,--p1,++p5,--p6,--p7]).

input_clause(c_3941,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,--p1,++p4,++p5,--p6]).

input_clause(c_3942,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,--p1,++p4,++p5,--p7]).

input_clause(c_3943,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,--p1,++p4]).

input_clause(c_3944,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,--p1,++p4,--p6,--p7]).

input_clause(c_3945,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,--p1,++p3,++p4,--p6]).

input_clause(c_3946,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,--p1,++p3,++p4,--p7]).

input_clause(c_3947,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,--p1,++p3,++p4,++p5]).

input_clause(c_3948,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,--p1,++p3,++p4,++p5,--p6,--p7]).

input_clause(c_3949,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,--p1,++p3,++p5,--p6]).

input_clause(c_3950,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,--p1,++p3,++p5,--p7]).

input_clause(c_3951,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,--p1,++p3]).

input_clause(c_3952,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,--p1,++p3,--p6,--p7]).

input_clause(c_3953,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,--p1,--p2,++p3,--p6]).

input_clause(c_3954,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,--p1,--p2,++p3,--p7]).

input_clause(c_3955,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,--p1,--p2,++p3,++p5]).

input_clause(c_3956,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,--p1,--p2,++p3,++p5,--p6,--p7]).

input_clause(c_3957,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,--p1,--p2,++p3,++p4,++p5,--p6]).

input_clause(c_3958,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,--p1,--p2,++p3,++p4,++p5,--p7]).

input_clause(c_3959,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,--p1,--p2,++p3,++p4]).

input_clause(c_3960,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,--p1,--p2,++p3,++p4,--p6,--p7]).

input_clause(c_3961,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,--p1,--p2,++p4,--p6]).

input_clause(c_3962,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,--p1,--p2,++p4,--p7]).

input_clause(c_3963,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,--p1,--p2,++p4,++p5]).

input_clause(c_3964,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,--p1,--p2,++p4,++p5,--p6,--p7]).

input_clause(c_3965,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,--p1,--p2,++p5,--p6]).

input_clause(c_3966,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,--p1,--p2,++p5,--p7]).

input_clause(c_3967,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,--p1,--p2]).

input_clause(c_3968,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p7,--p1,--p2,--p6,--p7]).

input_clause(c_3969,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,--p1,--p2]).

input_clause(c_3970,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,--p1,--p2,++p6,--p7]).

input_clause(c_3971,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,--p1,--p2,++p5,++p6]).

input_clause(c_3972,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,--p1,--p2,++p5,--p7]).

input_clause(c_3973,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,--p1,--p2,++p4,++p5]).

input_clause(c_3974,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,--p1,--p2,++p4,++p5,++p6,--p7]).

input_clause(c_3975,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,--p1,--p2,++p4,++p6]).

input_clause(c_3976,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,--p1,--p2,++p4,--p7]).

input_clause(c_3977,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,--p1,--p2,++p3,++p4]).

input_clause(c_3978,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,--p1,--p2,++p3,++p4,++p6,--p7]).

input_clause(c_3979,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,--p1,--p2,++p3,++p4,++p5,++p6]).

input_clause(c_3980,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,--p1,--p2,++p3,++p4,++p5,--p7]).

input_clause(c_3981,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,--p1,--p2,++p3,++p5]).

input_clause(c_3982,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,--p1,--p2,++p3,++p5,++p6,--p7]).

input_clause(c_3983,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,--p1,--p2,++p3,++p6]).

input_clause(c_3984,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,--p1,--p2,++p3,--p7]).

input_clause(c_3985,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,--p1,++p3]).

input_clause(c_3986,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,--p1,++p3,++p6,--p7]).

input_clause(c_3987,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,--p1,++p3,++p5,++p6]).

input_clause(c_3988,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,--p1,++p3,++p5,--p7]).

input_clause(c_3989,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,--p1,++p3,++p4,++p5]).

input_clause(c_3990,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,--p1,++p3,++p4,++p5,++p6,--p7]).

input_clause(c_3991,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,--p1,++p3,++p4,++p6]).

input_clause(c_3992,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,--p1,++p3,++p4,--p7]).

input_clause(c_3993,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,--p1,++p4]).

input_clause(c_3994,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,--p1,++p4,++p6,--p7]).

input_clause(c_3995,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,--p1,++p4,++p5,++p6]).

input_clause(c_3996,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,--p1,++p4,++p5,--p7]).

input_clause(c_3997,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,--p1,++p5]).

input_clause(c_3998,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,--p1,++p5,++p6,--p7]).

input_clause(c_3999,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,--p1,++p6]).

input_clause(c_4000,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,--p1,--p7]).

input_clause(c_4001,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7]).

input_clause(c_4002,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,++p6,--p7]).

input_clause(c_4003,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,++p5,++p6]).

input_clause(c_4004,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,++p5,--p7]).

input_clause(c_4005,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,++p4,++p5]).

input_clause(c_4006,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,++p4,++p5,++p6,--p7]).

input_clause(c_4007,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,++p4,++p6]).

input_clause(c_4008,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,++p4,--p7]).

input_clause(c_4009,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,++p3,++p4]).

input_clause(c_4010,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,++p3,++p4,++p6,--p7]).

input_clause(c_4011,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,++p3,++p4,++p5,++p6]).

input_clause(c_4012,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,++p3,++p4,++p5,--p7]).

input_clause(c_4013,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,++p3,++p5]).

input_clause(c_4014,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,++p3,++p5,++p6,--p7]).

input_clause(c_4015,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,++p3,++p6]).

input_clause(c_4016,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,++p3,--p7]).

input_clause(c_4017,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,--p2,++p3]).

input_clause(c_4018,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,--p2,++p3,++p6,--p7]).

input_clause(c_4019,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,--p2,++p3,++p5,++p6]).

input_clause(c_4020,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,--p2,++p3,++p5,--p7]).

input_clause(c_4021,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,--p2,++p3,++p4,++p5]).

input_clause(c_4022,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,--p2,++p3,++p4,++p5,++p6,--p7]).

input_clause(c_4023,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,--p2,++p3,++p4,++p6]).

input_clause(c_4024,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,--p2,++p3,++p4,--p7]).

input_clause(c_4025,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,--p2,++p4]).

input_clause(c_4026,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,--p2,++p4,++p6,--p7]).

input_clause(c_4027,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,--p2,++p4,++p5,++p6]).

input_clause(c_4028,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,--p2,++p4,++p5,--p7]).

input_clause(c_4029,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,--p2,++p5]).

input_clause(c_4030,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,--p2,++p5,++p6,--p7]).

input_clause(c_4031,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,--p2,++p6]).

input_clause(c_4032,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p7,--p2,--p7]).

input_clause(c_4033,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,--p2,++p7]).

input_clause(c_4034,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,--p2,++p6]).

input_clause(c_4035,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,--p2,++p5,++p6,++p7]).

input_clause(c_4036,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,--p2,++p5]).

input_clause(c_4037,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,--p2,++p4,++p5,++p7]).

input_clause(c_4038,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,--p2,++p4,++p5,++p6]).

input_clause(c_4039,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,--p2,++p4,++p6,++p7]).

input_clause(c_4040,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,--p2,++p4]).

input_clause(c_4041,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,--p2,++p3,++p4,++p7]).

input_clause(c_4042,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,--p2,++p3,++p4,++p6]).

input_clause(c_4043,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,--p2,++p3,++p4,++p5,++p6,++p7]).

input_clause(c_4044,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,--p2,++p3,++p4,++p5]).

input_clause(c_4045,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,--p2,++p3,++p5,++p7]).

input_clause(c_4046,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,--p2,++p3,++p5,++p6]).

input_clause(c_4047,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,--p2,++p3,++p6,++p7]).

input_clause(c_4048,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,--p2,++p3]).

input_clause(c_4049,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,++p3,++p7]).

input_clause(c_4050,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,++p3,++p6]).

input_clause(c_4051,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,++p3,++p5,++p6,++p7]).

input_clause(c_4052,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,++p3,++p5]).

input_clause(c_4053,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,++p3,++p4,++p5,++p7]).

input_clause(c_4054,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,++p3,++p4,++p5,++p6]).

input_clause(c_4055,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,++p3,++p4,++p6,++p7]).

input_clause(c_4056,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,++p3,++p4]).

input_clause(c_4057,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,++p4,++p7]).

input_clause(c_4058,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,++p4,++p6]).

input_clause(c_4059,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,++p4,++p5,++p6,++p7]).

input_clause(c_4060,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,++p4,++p5]).

input_clause(c_4061,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,++p5,++p7]).

input_clause(c_4062,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,++p5,++p6]).

input_clause(c_4063,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,++p6,++p7]).

input_clause(c_4064,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7]).

input_clause(c_4065,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,--p1,++p7]).

input_clause(c_4066,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,--p1,++p6]).

input_clause(c_4067,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,--p1,++p5,++p6,++p7]).

input_clause(c_4068,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,--p1,++p5]).

input_clause(c_4069,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,--p1,++p4,++p5,++p7]).

input_clause(c_4070,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,--p1,++p4,++p5,++p6]).

input_clause(c_4071,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,--p1,++p4,++p6,++p7]).

input_clause(c_4072,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,--p1,++p4]).

input_clause(c_4073,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,--p1,++p3,++p4,++p7]).

input_clause(c_4074,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,--p1,++p3,++p4,++p6]).

input_clause(c_4075,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,--p1,++p3,++p4,++p5,++p6,++p7]).

input_clause(c_4076,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,--p1,++p3,++p4,++p5]).

input_clause(c_4077,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,--p1,++p3,++p5,++p7]).

input_clause(c_4078,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,--p1,++p3,++p5,++p6]).

input_clause(c_4079,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,--p1,++p3,++p6,++p7]).

input_clause(c_4080,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,--p1,++p3]).

input_clause(c_4081,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,--p1,--p2,++p3,++p7]).

input_clause(c_4082,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,--p1,--p2,++p3,++p6]).

input_clause(c_4083,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,--p1,--p2,++p3,++p5,++p6,++p7]).

input_clause(c_4084,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,--p1,--p2,++p3,++p5]).

input_clause(c_4085,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,--p1,--p2,++p3,++p4,++p5,++p7]).

input_clause(c_4086,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,--p1,--p2,++p3,++p4,++p5,++p6]).

input_clause(c_4087,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,--p1,--p2,++p3,++p4,++p6,++p7]).

input_clause(c_4088,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,--p1,--p2,++p3,++p4]).

input_clause(c_4089,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,--p1,--p2,++p4,++p7]).

input_clause(c_4090,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,--p1,--p2,++p4,++p6]).

input_clause(c_4091,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,--p1,--p2,++p4,++p5,++p6,++p7]).

input_clause(c_4092,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,--p1,--p2,++p4,++p5]).

input_clause(c_4093,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,--p1,--p2,++p5,++p7]).

input_clause(c_4094,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,--p1,--p2,++p5,++p6]).

input_clause(c_4095,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,--p1,--p2,++p6,++p7]).

input_clause(c_4096,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p7,--p1,--p2]).

input_clause(c_4097,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,--p2,++p7]).

input_clause(c_4098,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,--p2,++p6]).

input_clause(c_4099,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,--p2,++p5,++p6,++p7]).

input_clause(c_4100,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,--p2,++p5]).

input_clause(c_4101,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,--p2,++p4,++p5,++p7]).

input_clause(c_4102,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,--p2,++p4,++p5,++p6]).

input_clause(c_4103,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,--p2,++p4,++p6,++p7]).

input_clause(c_4104,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,--p2,++p4]).

input_clause(c_4105,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,--p2,++p3,++p4,++p7]).

input_clause(c_4106,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,--p2,++p3,++p4,++p6]).

input_clause(c_4107,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,--p2,++p3,++p4,++p5,++p6,++p7]).

input_clause(c_4108,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,--p2,++p3,++p4,++p5]).

input_clause(c_4109,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,--p2,++p3,++p5,++p7]).

input_clause(c_4110,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,--p2,++p3,++p5,++p6]).

input_clause(c_4111,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,--p2,++p3,++p6,++p7]).

input_clause(c_4112,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,--p2,++p3]).

input_clause(c_4113,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,++p3,++p7]).

input_clause(c_4114,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,++p3,++p6]).

input_clause(c_4115,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,++p3,++p5,++p6,++p7]).

input_clause(c_4116,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,++p3,++p5]).

input_clause(c_4117,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,++p3,++p4,++p5,++p7]).

input_clause(c_4118,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,++p3,++p4,++p5,++p6]).

input_clause(c_4119,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,++p3,++p4,++p6,++p7]).

input_clause(c_4120,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,++p3,++p4]).

input_clause(c_4121,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,++p4,++p7]).

input_clause(c_4122,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,++p4,++p6]).

input_clause(c_4123,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,++p4,++p5,++p6,++p7]).

input_clause(c_4124,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,++p4,++p5]).

input_clause(c_4125,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,++p5,++p7]).

input_clause(c_4126,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,++p5,++p6]).

input_clause(c_4127,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,++p6,++p7]).

input_clause(c_4128,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7]).

input_clause(c_4129,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,++p1,++p7]).

input_clause(c_4130,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,++p1,++p6]).

input_clause(c_4131,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,++p1,++p5,++p6,++p7]).

input_clause(c_4132,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,++p1,++p5]).

input_clause(c_4133,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,++p1,++p4,++p5,++p7]).

input_clause(c_4134,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,++p1,++p4,++p5,++p6]).

input_clause(c_4135,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,++p1,++p4,++p6,++p7]).

input_clause(c_4136,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,++p1,++p4]).

input_clause(c_4137,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,++p1,++p3,++p4,++p7]).

input_clause(c_4138,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,++p1,++p3,++p4,++p6]).

input_clause(c_4139,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,++p1,++p3,++p4,++p5,++p6,++p7]).

input_clause(c_4140,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,++p1,++p3,++p4,++p5]).

input_clause(c_4141,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,++p1,++p3,++p5,++p7]).

input_clause(c_4142,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,++p1,++p3,++p5,++p6]).

input_clause(c_4143,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,++p1,++p3,++p6,++p7]).

input_clause(c_4144,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,++p1,++p3]).

input_clause(c_4145,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,++p1,--p2,++p3,++p7]).

input_clause(c_4146,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,++p1,--p2,++p3,++p6]).

input_clause(c_4147,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,++p1,--p2,++p3,++p5,++p6,++p7]).

input_clause(c_4148,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,++p1,--p2,++p3,++p5]).

input_clause(c_4149,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,++p1,--p2,++p3,++p4,++p5,++p7]).

input_clause(c_4150,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,++p1,--p2,++p3,++p4,++p5,++p6]).

input_clause(c_4151,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,++p1,--p2,++p3,++p4,++p6,++p7]).

input_clause(c_4152,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,++p1,--p2,++p3,++p4]).

input_clause(c_4153,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,++p1,--p2,++p4,++p7]).

input_clause(c_4154,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,++p1,--p2,++p4,++p6]).

input_clause(c_4155,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,++p1,--p2,++p4,++p5,++p6,++p7]).

input_clause(c_4156,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,++p1,--p2,++p4,++p5]).

input_clause(c_4157,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,++p1,--p2,++p5,++p7]).

input_clause(c_4158,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,++p1,--p2,++p5,++p6]).

input_clause(c_4159,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,++p1,--p2,++p6,++p7]).

input_clause(c_4160,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p7,++p1,--p2]).

input_clause(c_4161,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,++p1,--p2]).

input_clause(c_4162,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,++p1,--p2,++p6,--p7]).

input_clause(c_4163,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,++p1,--p2,++p5,++p6]).

input_clause(c_4164,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,++p1,--p2,++p5,--p7]).

input_clause(c_4165,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,++p1,--p2,++p4,++p5]).

input_clause(c_4166,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,++p1,--p2,++p4,++p5,++p6,--p7]).

input_clause(c_4167,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,++p1,--p2,++p4,++p6]).

input_clause(c_4168,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,++p1,--p2,++p4,--p7]).

input_clause(c_4169,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,++p1,--p2,++p3,++p4]).

input_clause(c_4170,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,++p1,--p2,++p3,++p4,++p6,--p7]).

input_clause(c_4171,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,++p1,--p2,++p3,++p4,++p5,++p6]).

input_clause(c_4172,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,++p1,--p2,++p3,++p4,++p5,--p7]).

input_clause(c_4173,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,++p1,--p2,++p3,++p5]).

input_clause(c_4174,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,++p1,--p2,++p3,++p5,++p6,--p7]).

input_clause(c_4175,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,++p1,--p2,++p3,++p6]).

input_clause(c_4176,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,++p1,--p2,++p3,--p7]).

input_clause(c_4177,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,++p1,++p3]).

input_clause(c_4178,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,++p1,++p3,++p6,--p7]).

input_clause(c_4179,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,++p1,++p3,++p5,++p6]).

input_clause(c_4180,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,++p1,++p3,++p5,--p7]).

input_clause(c_4181,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,++p1,++p3,++p4,++p5]).

input_clause(c_4182,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,++p1,++p3,++p4,++p5,++p6,--p7]).

input_clause(c_4183,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,++p1,++p3,++p4,++p6]).

input_clause(c_4184,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,++p1,++p3,++p4,--p7]).

input_clause(c_4185,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,++p1,++p4]).

input_clause(c_4186,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,++p1,++p4,++p6,--p7]).

input_clause(c_4187,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,++p1,++p4,++p5,++p6]).

input_clause(c_4188,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,++p1,++p4,++p5,--p7]).

input_clause(c_4189,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,++p1,++p5]).

input_clause(c_4190,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,++p1,++p5,++p6,--p7]).

input_clause(c_4191,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,++p1,++p6]).

input_clause(c_4192,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,++p1,--p7]).

input_clause(c_4193,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7]).

input_clause(c_4194,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,++p6,--p7]).

input_clause(c_4195,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,++p5,++p6]).

input_clause(c_4196,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,++p5,--p7]).

input_clause(c_4197,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,++p4,++p5]).

input_clause(c_4198,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,++p4,++p5,++p6,--p7]).

input_clause(c_4199,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,++p4,++p6]).

input_clause(c_4200,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,++p4,--p7]).

input_clause(c_4201,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,++p3,++p4]).

input_clause(c_4202,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,++p3,++p4,++p6,--p7]).

input_clause(c_4203,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,++p3,++p4,++p5,++p6]).

input_clause(c_4204,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,++p3,++p4,++p5,--p7]).

input_clause(c_4205,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,++p3,++p5]).

input_clause(c_4206,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,++p3,++p5,++p6,--p7]).

input_clause(c_4207,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,++p3,++p6]).

input_clause(c_4208,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,++p3,--p7]).

input_clause(c_4209,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,--p2,++p3]).

input_clause(c_4210,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,--p2,++p3,++p6,--p7]).

input_clause(c_4211,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,--p2,++p3,++p5,++p6]).

input_clause(c_4212,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,--p2,++p3,++p5,--p7]).

input_clause(c_4213,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,--p2,++p3,++p4,++p5]).

input_clause(c_4214,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,--p2,++p3,++p4,++p5,++p6,--p7]).

input_clause(c_4215,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,--p2,++p3,++p4,++p6]).

input_clause(c_4216,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,--p2,++p3,++p4,--p7]).

input_clause(c_4217,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,--p2,++p4]).

input_clause(c_4218,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,--p2,++p4,++p6,--p7]).

input_clause(c_4219,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,--p2,++p4,++p5,++p6]).

input_clause(c_4220,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,--p2,++p4,++p5,--p7]).

input_clause(c_4221,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,--p2,++p5]).

input_clause(c_4222,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,--p2,++p5,++p6,--p7]).

input_clause(c_4223,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,--p2,++p6]).

input_clause(c_4224,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p7,--p2,--p7]).

input_clause(c_4225,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,--p2,--p6]).

input_clause(c_4226,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,--p2,--p7]).

input_clause(c_4227,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,--p2,++p5]).

input_clause(c_4228,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,--p2,++p5,--p6,--p7]).

input_clause(c_4229,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,--p2,++p4,++p5,--p6]).

input_clause(c_4230,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,--p2,++p4,++p5,--p7]).

input_clause(c_4231,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,--p2,++p4]).

input_clause(c_4232,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,--p2,++p4,--p6,--p7]).

input_clause(c_4233,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,--p2,++p3,++p4,--p6]).

input_clause(c_4234,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,--p2,++p3,++p4,--p7]).

input_clause(c_4235,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,--p2,++p3,++p4,++p5]).

input_clause(c_4236,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,--p2,++p3,++p4,++p5,--p6,--p7]).

input_clause(c_4237,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,--p2,++p3,++p5,--p6]).

input_clause(c_4238,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,--p2,++p3,++p5,--p7]).

input_clause(c_4239,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,--p2,++p3]).

input_clause(c_4240,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,--p2,++p3,--p6,--p7]).

input_clause(c_4241,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,++p3,--p6]).

input_clause(c_4242,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,++p3,--p7]).

input_clause(c_4243,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,++p3,++p5]).

input_clause(c_4244,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,++p3,++p5,--p6,--p7]).

input_clause(c_4245,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,++p3,++p4,++p5,--p6]).

input_clause(c_4246,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,++p3,++p4,++p5,--p7]).

input_clause(c_4247,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,++p3,++p4]).

input_clause(c_4248,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,++p3,++p4,--p6,--p7]).

input_clause(c_4249,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,++p4,--p6]).

input_clause(c_4250,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,++p4,--p7]).

input_clause(c_4251,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,++p4,++p5]).

input_clause(c_4252,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,++p4,++p5,--p6,--p7]).

input_clause(c_4253,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,++p5,--p6]).

input_clause(c_4254,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,++p5,--p7]).

input_clause(c_4255,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7]).

input_clause(c_4256,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,--p6,--p7]).

input_clause(c_4257,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,++p1,--p6]).

input_clause(c_4258,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,++p1,--p7]).

input_clause(c_4259,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,++p1,++p5]).

input_clause(c_4260,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,++p1,++p5,--p6,--p7]).

input_clause(c_4261,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,++p1,++p4,++p5,--p6]).

input_clause(c_4262,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,++p1,++p4,++p5,--p7]).

input_clause(c_4263,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,++p1,++p4]).

input_clause(c_4264,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,++p1,++p4,--p6,--p7]).

input_clause(c_4265,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,++p1,++p3,++p4,--p6]).

input_clause(c_4266,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,++p1,++p3,++p4,--p7]).

input_clause(c_4267,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,++p1,++p3,++p4,++p5]).

input_clause(c_4268,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,++p1,++p3,++p4,++p5,--p6,--p7]).

input_clause(c_4269,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,++p1,++p3,++p5,--p6]).

input_clause(c_4270,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,++p1,++p3,++p5,--p7]).

input_clause(c_4271,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,++p1,++p3]).

input_clause(c_4272,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,++p1,++p3,--p6,--p7]).

input_clause(c_4273,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,++p1,--p2,++p3,--p6]).

input_clause(c_4274,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,++p1,--p2,++p3,--p7]).

input_clause(c_4275,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,++p1,--p2,++p3,++p5]).

input_clause(c_4276,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,++p1,--p2,++p3,++p5,--p6,--p7]).

input_clause(c_4277,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,++p1,--p2,++p3,++p4,++p5,--p6]).

input_clause(c_4278,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,++p1,--p2,++p3,++p4,++p5,--p7]).

input_clause(c_4279,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,++p1,--p2,++p3,++p4]).

input_clause(c_4280,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,++p1,--p2,++p3,++p4,--p6,--p7]).

input_clause(c_4281,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,++p1,--p2,++p4,--p6]).

input_clause(c_4282,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,++p1,--p2,++p4,--p7]).

input_clause(c_4283,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,++p1,--p2,++p4,++p5]).

input_clause(c_4284,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,++p1,--p2,++p4,++p5,--p6,--p7]).

input_clause(c_4285,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,++p1,--p2,++p5,--p6]).

input_clause(c_4286,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,++p1,--p2,++p5,--p7]).

input_clause(c_4287,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,++p1,--p2]).

input_clause(c_4288,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p7,++p1,--p2,--p6,--p7]).

input_clause(c_4289,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,++p1,--p2,--p6,++p7]).

input_clause(c_4290,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,++p1,--p2]).

input_clause(c_4291,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,++p1,--p2,++p5,++p7]).

input_clause(c_4292,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,++p1,--p2,++p5,--p6]).

input_clause(c_4293,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,++p1,--p2,++p4,++p5,--p6,++p7]).

input_clause(c_4294,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,++p1,--p2,++p4,++p5]).

input_clause(c_4295,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,++p1,--p2,++p4,++p7]).

input_clause(c_4296,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,++p1,--p2,++p4,--p6]).

input_clause(c_4297,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,++p1,--p2,++p3,++p4,--p6,++p7]).

input_clause(c_4298,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,++p1,--p2,++p3,++p4]).

input_clause(c_4299,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,++p1,--p2,++p3,++p4,++p5,++p7]).

input_clause(c_4300,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,++p1,--p2,++p3,++p4,++p5,--p6]).

input_clause(c_4301,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,++p1,--p2,++p3,++p5,--p6,++p7]).

input_clause(c_4302,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,++p1,--p2,++p3,++p5]).

input_clause(c_4303,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,++p1,--p2,++p3,++p7]).

input_clause(c_4304,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,++p1,--p2,++p3,--p6]).

input_clause(c_4305,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,++p1,++p3,--p6,++p7]).

input_clause(c_4306,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,++p1,++p3]).

input_clause(c_4307,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,++p1,++p3,++p5,++p7]).

input_clause(c_4308,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,++p1,++p3,++p5,--p6]).

input_clause(c_4309,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,++p1,++p3,++p4,++p5,--p6,++p7]).

input_clause(c_4310,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,++p1,++p3,++p4,++p5]).

input_clause(c_4311,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,++p1,++p3,++p4,++p7]).

input_clause(c_4312,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,++p1,++p3,++p4,--p6]).

input_clause(c_4313,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,++p1,++p4,--p6,++p7]).

input_clause(c_4314,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,++p1,++p4]).

input_clause(c_4315,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,++p1,++p4,++p5,++p7]).

input_clause(c_4316,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,++p1,++p4,++p5,--p6]).

input_clause(c_4317,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,++p1,++p5,--p6,++p7]).

input_clause(c_4318,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,++p1,++p5]).

input_clause(c_4319,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,++p1,++p7]).

input_clause(c_4320,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,++p1,--p6]).

input_clause(c_4321,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,--p6,++p7]).

input_clause(c_4322,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7]).

input_clause(c_4323,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,++p5,++p7]).

input_clause(c_4324,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,++p5,--p6]).

input_clause(c_4325,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,++p4,++p5,--p6,++p7]).

input_clause(c_4326,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,++p4,++p5]).

input_clause(c_4327,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,++p4,++p7]).

input_clause(c_4328,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,++p4,--p6]).

input_clause(c_4329,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,++p3,++p4,--p6,++p7]).

input_clause(c_4330,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,++p3,++p4]).

input_clause(c_4331,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,++p3,++p4,++p5,++p7]).

input_clause(c_4332,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,++p3,++p4,++p5,--p6]).

input_clause(c_4333,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,++p3,++p5,--p6,++p7]).

input_clause(c_4334,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,++p3,++p5]).

input_clause(c_4335,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,++p3,++p7]).

input_clause(c_4336,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,++p3,--p6]).

input_clause(c_4337,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,--p2,++p3,--p6,++p7]).

input_clause(c_4338,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,--p2,++p3]).

input_clause(c_4339,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,--p2,++p3,++p5,++p7]).

input_clause(c_4340,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,--p2,++p3,++p5,--p6]).

input_clause(c_4341,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,--p2,++p3,++p4,++p5,--p6,++p7]).

input_clause(c_4342,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,--p2,++p3,++p4,++p5]).

input_clause(c_4343,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,--p2,++p3,++p4,++p7]).

input_clause(c_4344,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,--p2,++p3,++p4,--p6]).

input_clause(c_4345,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,--p2,++p4,--p6,++p7]).

input_clause(c_4346,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,--p2,++p4]).

input_clause(c_4347,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,--p2,++p4,++p5,++p7]).

input_clause(c_4348,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,--p2,++p4,++p5,--p6]).

input_clause(c_4349,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,--p2,++p5,--p6,++p7]).

input_clause(c_4350,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,--p2,++p5]).

input_clause(c_4351,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,--p2,++p7]).

input_clause(c_4352,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p7,--p2,--p6]).

input_clause(c_4353,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,--p2,--p5,--p6,++p7]).

input_clause(c_4354,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,--p2,--p5]).

input_clause(c_4355,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,--p2,++p7]).

input_clause(c_4356,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,--p2,--p6]).

input_clause(c_4357,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,--p2,++p4,--p6,++p7]).

input_clause(c_4358,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,--p2,++p4]).

input_clause(c_4359,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,--p2,++p4,--p5,++p7]).

input_clause(c_4360,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,--p2,++p4,--p5,--p6]).

input_clause(c_4361,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,--p2,++p3,++p4,--p5,--p6,++p7]).

input_clause(c_4362,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,--p2,++p3,++p4,--p5]).

input_clause(c_4363,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,--p2,++p3,++p4,++p7]).

input_clause(c_4364,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,--p2,++p3,++p4,--p6]).

input_clause(c_4365,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,--p2,++p3,--p6,++p7]).

input_clause(c_4366,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,--p2,++p3]).

input_clause(c_4367,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,--p2,++p3,--p5,++p7]).

input_clause(c_4368,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,--p2,++p3,--p5,--p6]).

input_clause(c_4369,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,++p3,--p5,--p6,++p7]).

input_clause(c_4370,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,++p3,--p5]).

input_clause(c_4371,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,++p3,++p7]).

input_clause(c_4372,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,++p3,--p6]).

input_clause(c_4373,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,++p3,++p4,--p6,++p7]).

input_clause(c_4374,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,++p3,++p4]).

input_clause(c_4375,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,++p3,++p4,--p5,++p7]).

input_clause(c_4376,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,++p3,++p4,--p5,--p6]).

input_clause(c_4377,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,++p4,--p5,--p6,++p7]).

input_clause(c_4378,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,++p4,--p5]).

input_clause(c_4379,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,++p4,++p7]).

input_clause(c_4380,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,++p4,--p6]).

input_clause(c_4381,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,--p6,++p7]).

input_clause(c_4382,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7]).

input_clause(c_4383,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,--p5,++p7]).

input_clause(c_4384,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,--p5,--p6]).

input_clause(c_4385,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,++p1,--p5,--p6,++p7]).

input_clause(c_4386,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,++p1,--p5]).

input_clause(c_4387,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,++p1,++p7]).

input_clause(c_4388,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,++p1,--p6]).

input_clause(c_4389,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,++p1,++p4,--p6,++p7]).

input_clause(c_4390,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,++p1,++p4]).

input_clause(c_4391,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,++p1,++p4,--p5,++p7]).

input_clause(c_4392,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,++p1,++p4,--p5,--p6]).

input_clause(c_4393,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,++p1,++p3,++p4,--p5,--p6,++p7]).

input_clause(c_4394,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,++p1,++p3,++p4,--p5]).

input_clause(c_4395,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,++p1,++p3,++p4,++p7]).

input_clause(c_4396,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,++p1,++p3,++p4,--p6]).

input_clause(c_4397,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,++p1,++p3,--p6,++p7]).

input_clause(c_4398,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,++p1,++p3]).

input_clause(c_4399,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,++p1,++p3,--p5,++p7]).

input_clause(c_4400,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,++p1,++p3,--p5,--p6]).

input_clause(c_4401,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,++p1,--p2,++p3,--p5,--p6,++p7]).

input_clause(c_4402,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,++p1,--p2,++p3,--p5]).

input_clause(c_4403,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,++p1,--p2,++p3,++p7]).

input_clause(c_4404,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,++p1,--p2,++p3,--p6]).

input_clause(c_4405,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,++p1,--p2,++p3,++p4,--p6,++p7]).

input_clause(c_4406,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,++p1,--p2,++p3,++p4]).

input_clause(c_4407,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,++p1,--p2,++p3,++p4,--p5,++p7]).

input_clause(c_4408,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,++p1,--p2,++p3,++p4,--p5,--p6]).

input_clause(c_4409,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,++p1,--p2,++p4,--p5,--p6,++p7]).

input_clause(c_4410,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,++p1,--p2,++p4,--p5]).

input_clause(c_4411,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,++p1,--p2,++p4,++p7]).

input_clause(c_4412,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,++p1,--p2,++p4,--p6]).

input_clause(c_4413,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,++p1,--p2,--p6,++p7]).

input_clause(c_4414,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,++p1,--p2]).

input_clause(c_4415,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,++p1,--p2,--p5,++p7]).

input_clause(c_4416,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p7,++p1,--p2,--p5,--p6]).

input_clause(c_4417,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,++p1,--p2,--p5,--p6]).

input_clause(c_4418,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,++p1,--p2,--p5,--p7]).

input_clause(c_4419,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,++p1,--p2]).

input_clause(c_4420,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,++p1,--p2,--p6,--p7]).

input_clause(c_4421,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,++p1,--p2,++p4,--p6]).

input_clause(c_4422,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,++p1,--p2,++p4,--p7]).

input_clause(c_4423,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,++p1,--p2,++p4,--p5]).

input_clause(c_4424,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,++p1,--p2,++p4,--p5,--p6,--p7]).

input_clause(c_4425,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,++p1,--p2,++p3,++p4,--p5,--p6]).

input_clause(c_4426,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,++p1,--p2,++p3,++p4,--p5,--p7]).

input_clause(c_4427,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,++p1,--p2,++p3,++p4]).

input_clause(c_4428,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,++p1,--p2,++p3,++p4,--p6,--p7]).

input_clause(c_4429,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,++p1,--p2,++p3,--p6]).

input_clause(c_4430,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,++p1,--p2,++p3,--p7]).

input_clause(c_4431,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,++p1,--p2,++p3,--p5]).

input_clause(c_4432,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,++p1,--p2,++p3,--p5,--p6,--p7]).

input_clause(c_4433,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,++p1,++p3,--p5,--p6]).

input_clause(c_4434,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,++p1,++p3,--p5,--p7]).

input_clause(c_4435,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,++p1,++p3]).

input_clause(c_4436,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,++p1,++p3,--p6,--p7]).

input_clause(c_4437,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,++p1,++p3,++p4,--p6]).

input_clause(c_4438,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,++p1,++p3,++p4,--p7]).

input_clause(c_4439,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,++p1,++p3,++p4,--p5]).

input_clause(c_4440,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,++p1,++p3,++p4,--p5,--p6,--p7]).

input_clause(c_4441,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,++p1,++p4,--p5,--p6]).

input_clause(c_4442,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,++p1,++p4,--p5,--p7]).

input_clause(c_4443,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,++p1,++p4]).

input_clause(c_4444,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,++p1,++p4,--p6,--p7]).

input_clause(c_4445,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,++p1,--p6]).

input_clause(c_4446,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,++p1,--p7]).

input_clause(c_4447,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,++p1,--p5]).

input_clause(c_4448,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,++p1,--p5,--p6,--p7]).

input_clause(c_4449,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,--p5,--p6]).

input_clause(c_4450,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,--p5,--p7]).

input_clause(c_4451,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7]).

input_clause(c_4452,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,--p6,--p7]).

input_clause(c_4453,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,++p4,--p6]).

input_clause(c_4454,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,++p4,--p7]).

input_clause(c_4455,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,++p4,--p5]).

input_clause(c_4456,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,++p4,--p5,--p6,--p7]).

input_clause(c_4457,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,++p3,++p4,--p5,--p6]).

input_clause(c_4458,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,++p3,++p4,--p5,--p7]).

input_clause(c_4459,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,++p3,++p4]).

input_clause(c_4460,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,++p3,++p4,--p6,--p7]).

input_clause(c_4461,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,++p3,--p6]).

input_clause(c_4462,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,++p3,--p7]).

input_clause(c_4463,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,++p3,--p5]).

input_clause(c_4464,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,++p3,--p5,--p6,--p7]).

input_clause(c_4465,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,--p2,++p3,--p5,--p6]).

input_clause(c_4466,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,--p2,++p3,--p5,--p7]).

input_clause(c_4467,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,--p2,++p3]).

input_clause(c_4468,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,--p2,++p3,--p6,--p7]).

input_clause(c_4469,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,--p2,++p3,++p4,--p6]).

input_clause(c_4470,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,--p2,++p3,++p4,--p7]).

input_clause(c_4471,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,--p2,++p3,++p4,--p5]).

input_clause(c_4472,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,--p2,++p3,++p4,--p5,--p6,--p7]).

input_clause(c_4473,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,--p2,++p4,--p5,--p6]).

input_clause(c_4474,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,--p2,++p4,--p5,--p7]).

input_clause(c_4475,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,--p2,++p4]).

input_clause(c_4476,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,--p2,++p4,--p6,--p7]).

input_clause(c_4477,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,--p2,--p6]).

input_clause(c_4478,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,--p2,--p7]).

input_clause(c_4479,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,--p2,--p5]).

input_clause(c_4480,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p7,--p2,--p5,--p6,--p7]).

input_clause(c_4481,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,--p2,--p5]).

input_clause(c_4482,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,--p2,--p5,++p6,--p7]).

input_clause(c_4483,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,--p2,++p6]).

input_clause(c_4484,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,--p2,--p7]).

input_clause(c_4485,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,--p2,++p4]).

input_clause(c_4486,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,--p2,++p4,++p6,--p7]).

input_clause(c_4487,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,--p2,++p4,--p5,++p6]).

input_clause(c_4488,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,--p2,++p4,--p5,--p7]).

input_clause(c_4489,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,--p2,++p3,++p4,--p5]).

input_clause(c_4490,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,--p2,++p3,++p4,--p5,++p6,--p7]).

input_clause(c_4491,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,--p2,++p3,++p4,++p6]).

input_clause(c_4492,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,--p2,++p3,++p4,--p7]).

input_clause(c_4493,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,--p2,++p3]).

input_clause(c_4494,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,--p2,++p3,++p6,--p7]).

input_clause(c_4495,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,--p2,++p3,--p5,++p6]).

input_clause(c_4496,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,--p2,++p3,--p5,--p7]).

input_clause(c_4497,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,++p3,--p5]).

input_clause(c_4498,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,++p3,--p5,++p6,--p7]).

input_clause(c_4499,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,++p3,++p6]).

input_clause(c_4500,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,++p3,--p7]).

input_clause(c_4501,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,++p3,++p4]).

input_clause(c_4502,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,++p3,++p4,++p6,--p7]).

input_clause(c_4503,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,++p3,++p4,--p5,++p6]).

input_clause(c_4504,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,++p3,++p4,--p5,--p7]).

input_clause(c_4505,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,++p4,--p5]).

input_clause(c_4506,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,++p4,--p5,++p6,--p7]).

input_clause(c_4507,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,++p4,++p6]).

input_clause(c_4508,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,++p4,--p7]).

input_clause(c_4509,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7]).

input_clause(c_4510,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,++p6,--p7]).

input_clause(c_4511,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,--p5,++p6]).

input_clause(c_4512,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,--p5,--p7]).

input_clause(c_4513,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,++p1,--p5]).

input_clause(c_4514,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,++p1,--p5,++p6,--p7]).

input_clause(c_4515,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,++p1,++p6]).

input_clause(c_4516,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,++p1,--p7]).

input_clause(c_4517,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,++p1,++p4]).

input_clause(c_4518,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,++p1,++p4,++p6,--p7]).

input_clause(c_4519,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,++p1,++p4,--p5,++p6]).

input_clause(c_4520,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,++p1,++p4,--p5,--p7]).

input_clause(c_4521,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,++p1,++p3,++p4,--p5]).

input_clause(c_4522,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,++p1,++p3,++p4,--p5,++p6,--p7]).

input_clause(c_4523,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,++p1,++p3,++p4,++p6]).

input_clause(c_4524,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,++p1,++p3,++p4,--p7]).

input_clause(c_4525,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,++p1,++p3]).

input_clause(c_4526,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,++p1,++p3,++p6,--p7]).

input_clause(c_4527,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,++p1,++p3,--p5,++p6]).

input_clause(c_4528,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,++p1,++p3,--p5,--p7]).

input_clause(c_4529,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,++p1,--p2,++p3,--p5]).

input_clause(c_4530,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,++p1,--p2,++p3,--p5,++p6,--p7]).

input_clause(c_4531,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,++p1,--p2,++p3,++p6]).

input_clause(c_4532,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,++p1,--p2,++p3,--p7]).

input_clause(c_4533,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,++p1,--p2,++p3,++p4]).

input_clause(c_4534,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,++p1,--p2,++p3,++p4,++p6,--p7]).

input_clause(c_4535,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,++p1,--p2,++p3,++p4,--p5,++p6]).

input_clause(c_4536,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,++p1,--p2,++p3,++p4,--p5,--p7]).

input_clause(c_4537,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,++p1,--p2,++p4,--p5]).

input_clause(c_4538,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,++p1,--p2,++p4,--p5,++p6,--p7]).

input_clause(c_4539,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,++p1,--p2,++p4,++p6]).

input_clause(c_4540,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,++p1,--p2,++p4,--p7]).

input_clause(c_4541,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,++p1,--p2]).

input_clause(c_4542,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,++p1,--p2,++p6,--p7]).

input_clause(c_4543,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,++p1,--p2,--p5,++p6]).

input_clause(c_4544,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p7,++p1,--p2,--p5,--p7]).

input_clause(c_4545,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,++p1,--p2,--p5,++p7]).

input_clause(c_4546,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,++p1,--p2,--p5,++p6]).

input_clause(c_4547,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,++p1,--p2,++p6,++p7]).

input_clause(c_4548,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,++p1,--p2]).

input_clause(c_4549,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,++p1,--p2,++p4,++p7]).

input_clause(c_4550,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,++p1,--p2,++p4,++p6]).

input_clause(c_4551,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,++p1,--p2,++p4,--p5,++p6,++p7]).

input_clause(c_4552,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,++p1,--p2,++p4,--p5]).

input_clause(c_4553,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,++p1,--p2,++p3,++p4,--p5,++p7]).

input_clause(c_4554,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,++p1,--p2,++p3,++p4,--p5,++p6]).

input_clause(c_4555,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,++p1,--p2,++p3,++p4,++p6,++p7]).

input_clause(c_4556,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,++p1,--p2,++p3,++p4]).

input_clause(c_4557,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,++p1,--p2,++p3,++p7]).

input_clause(c_4558,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,++p1,--p2,++p3,++p6]).

input_clause(c_4559,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,++p1,--p2,++p3,--p5,++p6,++p7]).

input_clause(c_4560,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,++p1,--p2,++p3,--p5]).

input_clause(c_4561,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,++p1,++p3,--p5,++p7]).

input_clause(c_4562,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,++p1,++p3,--p5,++p6]).

input_clause(c_4563,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,++p1,++p3,++p6,++p7]).

input_clause(c_4564,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,++p1,++p3]).

input_clause(c_4565,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,++p1,++p3,++p4,++p7]).

input_clause(c_4566,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,++p1,++p3,++p4,++p6]).

input_clause(c_4567,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,++p1,++p3,++p4,--p5,++p6,++p7]).

input_clause(c_4568,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,++p1,++p3,++p4,--p5]).

input_clause(c_4569,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,++p1,++p4,--p5,++p7]).

input_clause(c_4570,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,++p1,++p4,--p5,++p6]).

input_clause(c_4571,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,++p1,++p4,++p6,++p7]).

input_clause(c_4572,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,++p1,++p4]).

input_clause(c_4573,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,++p1,++p7]).

input_clause(c_4574,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,++p1,++p6]).

input_clause(c_4575,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,++p1,--p5,++p6,++p7]).

input_clause(c_4576,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,++p1,--p5]).

input_clause(c_4577,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,--p5,++p7]).

input_clause(c_4578,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,--p5,++p6]).

input_clause(c_4579,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,++p6,++p7]).

input_clause(c_4580,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7]).

input_clause(c_4581,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,++p4,++p7]).

input_clause(c_4582,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,++p4,++p6]).

input_clause(c_4583,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,++p4,--p5,++p6,++p7]).

input_clause(c_4584,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,++p4,--p5]).

input_clause(c_4585,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,++p3,++p4,--p5,++p7]).

input_clause(c_4586,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,++p3,++p4,--p5,++p6]).

input_clause(c_4587,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,++p3,++p4,++p6,++p7]).

input_clause(c_4588,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,++p3,++p4]).

input_clause(c_4589,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,++p3,++p7]).

input_clause(c_4590,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,++p3,++p6]).

input_clause(c_4591,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,++p3,--p5,++p6,++p7]).

input_clause(c_4592,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,++p3,--p5]).

input_clause(c_4593,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,--p2,++p3,--p5,++p7]).

input_clause(c_4594,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,--p2,++p3,--p5,++p6]).

input_clause(c_4595,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,--p2,++p3,++p6,++p7]).

input_clause(c_4596,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,--p2,++p3]).

input_clause(c_4597,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,--p2,++p3,++p4,++p7]).

input_clause(c_4598,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,--p2,++p3,++p4,++p6]).

input_clause(c_4599,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,--p2,++p3,++p4,--p5,++p6,++p7]).

input_clause(c_4600,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,--p2,++p3,++p4,--p5]).

input_clause(c_4601,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,--p2,++p4,--p5,++p7]).

input_clause(c_4602,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,--p2,++p4,--p5,++p6]).

input_clause(c_4603,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,--p2,++p4,++p6,++p7]).

input_clause(c_4604,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,--p2,++p4]).

input_clause(c_4605,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,--p2,++p7]).

input_clause(c_4606,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,--p2,++p6]).

input_clause(c_4607,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,--p2,--p5,++p6,++p7]).

input_clause(c_4608,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p7,--p2,--p5]).

input_clause(c_4609,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,--p2,--p4,--p5,++p7]).

input_clause(c_4610,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,--p2,--p4,--p5,++p6]).

input_clause(c_4611,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,--p2,--p4,++p6,++p7]).

input_clause(c_4612,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,--p2,--p4]).

input_clause(c_4613,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,--p2,++p7]).

input_clause(c_4614,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,--p2,++p6]).

input_clause(c_4615,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,--p2,--p5,++p6,++p7]).

input_clause(c_4616,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,--p2,--p5]).

input_clause(c_4617,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,--p2,++p3,--p5,++p7]).

input_clause(c_4618,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,--p2,++p3,--p5,++p6]).

input_clause(c_4619,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,--p2,++p3,++p6,++p7]).

input_clause(c_4620,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,--p2,++p3]).

input_clause(c_4621,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,--p2,++p3,--p4,++p7]).

input_clause(c_4622,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,--p2,++p3,--p4,++p6]).

input_clause(c_4623,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,--p2,++p3,--p4,--p5,++p6,++p7]).

input_clause(c_4624,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,--p2,++p3,--p4,--p5]).

input_clause(c_4625,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,++p3,--p4,--p5,++p7]).

input_clause(c_4626,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,++p3,--p4,--p5,++p6]).

input_clause(c_4627,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,++p3,--p4,++p6,++p7]).

input_clause(c_4628,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,++p3,--p4]).

input_clause(c_4629,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,++p3,++p7]).

input_clause(c_4630,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,++p3,++p6]).

input_clause(c_4631,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,++p3,--p5,++p6,++p7]).

input_clause(c_4632,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,++p3,--p5]).

input_clause(c_4633,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,--p5,++p7]).

input_clause(c_4634,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,--p5,++p6]).

input_clause(c_4635,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,++p6,++p7]).

input_clause(c_4636,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7]).

input_clause(c_4637,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,--p4,++p7]).

input_clause(c_4638,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,--p4,++p6]).

input_clause(c_4639,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,--p4,--p5,++p6,++p7]).

input_clause(c_4640,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,--p4,--p5]).

input_clause(c_4641,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,++p1,--p4,--p5,++p7]).

input_clause(c_4642,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,++p1,--p4,--p5,++p6]).

input_clause(c_4643,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,++p1,--p4,++p6,++p7]).

input_clause(c_4644,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,++p1,--p4]).

input_clause(c_4645,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,++p1,++p7]).

input_clause(c_4646,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,++p1,++p6]).

input_clause(c_4647,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,++p1,--p5,++p6,++p7]).

input_clause(c_4648,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,++p1,--p5]).

input_clause(c_4649,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,++p1,++p3,--p5,++p7]).

input_clause(c_4650,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,++p1,++p3,--p5,++p6]).

input_clause(c_4651,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,++p1,++p3,++p6,++p7]).

input_clause(c_4652,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,++p1,++p3]).

input_clause(c_4653,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,++p1,++p3,--p4,++p7]).

input_clause(c_4654,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,++p1,++p3,--p4,++p6]).

input_clause(c_4655,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,++p1,++p3,--p4,--p5,++p6,++p7]).

input_clause(c_4656,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,++p1,++p3,--p4,--p5]).

input_clause(c_4657,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,++p1,--p2,++p3,--p4,--p5,++p7]).

input_clause(c_4658,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,++p1,--p2,++p3,--p4,--p5,++p6]).

input_clause(c_4659,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,++p1,--p2,++p3,--p4,++p6,++p7]).

input_clause(c_4660,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,++p1,--p2,++p3,--p4]).

input_clause(c_4661,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,++p1,--p2,++p3,++p7]).

input_clause(c_4662,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,++p1,--p2,++p3,++p6]).

input_clause(c_4663,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,++p1,--p2,++p3,--p5,++p6,++p7]).

input_clause(c_4664,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,++p1,--p2,++p3,--p5]).

input_clause(c_4665,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,++p1,--p2,--p5,++p7]).

input_clause(c_4666,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,++p1,--p2,--p5,++p6]).

input_clause(c_4667,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,++p1,--p2,++p6,++p7]).

input_clause(c_4668,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,++p1,--p2]).

input_clause(c_4669,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,++p1,--p2,--p4,++p7]).

input_clause(c_4670,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,++p1,--p2,--p4,++p6]).

input_clause(c_4671,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,++p1,--p2,--p4,--p5,++p6,++p7]).

input_clause(c_4672,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p7,++p1,--p2,--p4,--p5]).

input_clause(c_4673,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,++p1,--p2,--p4,--p5]).

input_clause(c_4674,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,++p1,--p2,--p4,--p5,++p6,--p7]).

input_clause(c_4675,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,++p1,--p2,--p4,++p6]).

input_clause(c_4676,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,++p1,--p2,--p4,--p7]).

input_clause(c_4677,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,++p1,--p2]).

input_clause(c_4678,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,++p1,--p2,++p6,--p7]).

input_clause(c_4679,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,++p1,--p2,--p5,++p6]).

input_clause(c_4680,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,++p1,--p2,--p5,--p7]).

input_clause(c_4681,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,++p1,--p2,++p3,--p5]).

input_clause(c_4682,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,++p1,--p2,++p3,--p5,++p6,--p7]).

input_clause(c_4683,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,++p1,--p2,++p3,++p6]).

input_clause(c_4684,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,++p1,--p2,++p3,--p7]).

input_clause(c_4685,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,++p1,--p2,++p3,--p4]).

input_clause(c_4686,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,++p1,--p2,++p3,--p4,++p6,--p7]).

input_clause(c_4687,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,++p1,--p2,++p3,--p4,--p5,++p6]).

input_clause(c_4688,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,++p1,--p2,++p3,--p4,--p5,--p7]).

input_clause(c_4689,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,++p1,++p3,--p4,--p5]).

input_clause(c_4690,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,++p1,++p3,--p4,--p5,++p6,--p7]).

input_clause(c_4691,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,++p1,++p3,--p4,++p6]).

input_clause(c_4692,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,++p1,++p3,--p4,--p7]).

input_clause(c_4693,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,++p1,++p3]).

input_clause(c_4694,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,++p1,++p3,++p6,--p7]).

input_clause(c_4695,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,++p1,++p3,--p5,++p6]).

input_clause(c_4696,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,++p1,++p3,--p5,--p7]).

input_clause(c_4697,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,++p1,--p5]).

input_clause(c_4698,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,++p1,--p5,++p6,--p7]).

input_clause(c_4699,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,++p1,++p6]).

input_clause(c_4700,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,++p1,--p7]).

input_clause(c_4701,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,++p1,--p4]).

input_clause(c_4702,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,++p1,--p4,++p6,--p7]).

input_clause(c_4703,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,++p1,--p4,--p5,++p6]).

input_clause(c_4704,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,++p1,--p4,--p5,--p7]).

input_clause(c_4705,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,--p4,--p5]).

input_clause(c_4706,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,--p4,--p5,++p6,--p7]).

input_clause(c_4707,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,--p4,++p6]).

input_clause(c_4708,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,--p4,--p7]).

input_clause(c_4709,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7]).

input_clause(c_4710,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,++p6,--p7]).

input_clause(c_4711,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,--p5,++p6]).

input_clause(c_4712,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,--p5,--p7]).

input_clause(c_4713,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,++p3,--p5]).

input_clause(c_4714,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,++p3,--p5,++p6,--p7]).

input_clause(c_4715,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,++p3,++p6]).

input_clause(c_4716,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,++p3,--p7]).

input_clause(c_4717,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,++p3,--p4]).

input_clause(c_4718,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,++p3,--p4,++p6,--p7]).

input_clause(c_4719,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,++p3,--p4,--p5,++p6]).

input_clause(c_4720,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,++p3,--p4,--p5,--p7]).

input_clause(c_4721,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,--p2,++p3,--p4,--p5]).

input_clause(c_4722,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,--p2,++p3,--p4,--p5,++p6,--p7]).

input_clause(c_4723,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,--p2,++p3,--p4,++p6]).

input_clause(c_4724,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,--p2,++p3,--p4,--p7]).

input_clause(c_4725,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,--p2,++p3]).

input_clause(c_4726,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,--p2,++p3,++p6,--p7]).

input_clause(c_4727,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,--p2,++p3,--p5,++p6]).

input_clause(c_4728,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,--p2,++p3,--p5,--p7]).

input_clause(c_4729,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,--p2,--p5]).

input_clause(c_4730,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,--p2,--p5,++p6,--p7]).

input_clause(c_4731,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,--p2,++p6]).

input_clause(c_4732,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,--p2,--p7]).

input_clause(c_4733,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,--p2,--p4]).

input_clause(c_4734,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,--p2,--p4,++p6,--p7]).

input_clause(c_4735,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,--p2,--p4,--p5,++p6]).

input_clause(c_4736,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p7,--p2,--p4,--p5,--p7]).

input_clause(c_4737,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,--p2,--p4,--p5,--p6]).

input_clause(c_4738,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,--p2,--p4,--p5,--p7]).

input_clause(c_4739,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,--p2,--p4]).

input_clause(c_4740,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,--p2,--p4,--p6,--p7]).

input_clause(c_4741,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,--p2,--p6]).

input_clause(c_4742,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,--p2,--p7]).

input_clause(c_4743,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,--p2,--p5]).

input_clause(c_4744,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,--p2,--p5,--p6,--p7]).

input_clause(c_4745,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,--p2,++p3,--p5,--p6]).

input_clause(c_4746,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,--p2,++p3,--p5,--p7]).

input_clause(c_4747,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,--p2,++p3]).

input_clause(c_4748,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,--p2,++p3,--p6,--p7]).

input_clause(c_4749,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,--p2,++p3,--p4,--p6]).

input_clause(c_4750,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,--p2,++p3,--p4,--p7]).

input_clause(c_4751,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,--p2,++p3,--p4,--p5]).

input_clause(c_4752,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,--p2,++p3,--p4,--p5,--p6,--p7]).

input_clause(c_4753,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,++p3,--p4,--p5,--p6]).

input_clause(c_4754,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,++p3,--p4,--p5,--p7]).

input_clause(c_4755,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,++p3,--p4]).

input_clause(c_4756,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,++p3,--p4,--p6,--p7]).

input_clause(c_4757,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,++p3,--p6]).

input_clause(c_4758,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,++p3,--p7]).

input_clause(c_4759,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,++p3,--p5]).

input_clause(c_4760,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,++p3,--p5,--p6,--p7]).

input_clause(c_4761,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,--p5,--p6]).

input_clause(c_4762,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,--p5,--p7]).

input_clause(c_4763,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7]).

input_clause(c_4764,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,--p6,--p7]).

input_clause(c_4765,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,--p4,--p6]).

input_clause(c_4766,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,--p4,--p7]).

input_clause(c_4767,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,--p4,--p5]).

input_clause(c_4768,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,--p4,--p5,--p6,--p7]).

input_clause(c_4769,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,++p1,--p4,--p5,--p6]).

input_clause(c_4770,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,++p1,--p4,--p5,--p7]).

input_clause(c_4771,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,++p1,--p4]).

input_clause(c_4772,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,++p1,--p4,--p6,--p7]).

input_clause(c_4773,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,++p1,--p6]).

input_clause(c_4774,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,++p1,--p7]).

input_clause(c_4775,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,++p1,--p5]).

input_clause(c_4776,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,++p1,--p5,--p6,--p7]).

input_clause(c_4777,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,++p1,++p3,--p5,--p6]).

input_clause(c_4778,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,++p1,++p3,--p5,--p7]).

input_clause(c_4779,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,++p1,++p3]).

input_clause(c_4780,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,++p1,++p3,--p6,--p7]).

input_clause(c_4781,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,++p1,++p3,--p4,--p6]).

input_clause(c_4782,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,++p1,++p3,--p4,--p7]).

input_clause(c_4783,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,++p1,++p3,--p4,--p5]).

input_clause(c_4784,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,++p1,++p3,--p4,--p5,--p6,--p7]).

input_clause(c_4785,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,++p1,--p2,++p3,--p4,--p5,--p6]).

input_clause(c_4786,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,++p1,--p2,++p3,--p4,--p5,--p7]).

input_clause(c_4787,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,++p1,--p2,++p3,--p4]).

input_clause(c_4788,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,++p1,--p2,++p3,--p4,--p6,--p7]).

input_clause(c_4789,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,++p1,--p2,++p3,--p6]).

input_clause(c_4790,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,++p1,--p2,++p3,--p7]).

input_clause(c_4791,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,++p1,--p2,++p3,--p5]).

input_clause(c_4792,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,++p1,--p2,++p3,--p5,--p6,--p7]).

input_clause(c_4793,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,++p1,--p2,--p5,--p6]).

input_clause(c_4794,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,++p1,--p2,--p5,--p7]).

input_clause(c_4795,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,++p1,--p2]).

input_clause(c_4796,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,++p1,--p2,--p6,--p7]).

input_clause(c_4797,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,++p1,--p2,--p4,--p6]).

input_clause(c_4798,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,++p1,--p2,--p4,--p7]).

input_clause(c_4799,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,++p1,--p2,--p4,--p5]).

input_clause(c_4800,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p7,++p1,--p2,--p4,--p5,--p6,--p7]).

input_clause(c_4801,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,++p1,--p2,--p4,--p5,--p6,++p7]).

input_clause(c_4802,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,++p1,--p2,--p4,--p5]).

input_clause(c_4803,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,++p1,--p2,--p4,++p7]).

input_clause(c_4804,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,++p1,--p2,--p4,--p6]).

input_clause(c_4805,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,++p1,--p2,--p6,++p7]).

input_clause(c_4806,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,++p1,--p2]).

input_clause(c_4807,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,++p1,--p2,--p5,++p7]).

input_clause(c_4808,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,++p1,--p2,--p5,--p6]).

input_clause(c_4809,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,++p1,--p2,++p3,--p5,--p6,++p7]).

input_clause(c_4810,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,++p1,--p2,++p3,--p5]).

input_clause(c_4811,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,++p1,--p2,++p3,++p7]).

input_clause(c_4812,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,++p1,--p2,++p3,--p6]).

input_clause(c_4813,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,++p1,--p2,++p3,--p4,--p6,++p7]).

input_clause(c_4814,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,++p1,--p2,++p3,--p4]).

input_clause(c_4815,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,++p1,--p2,++p3,--p4,--p5,++p7]).

input_clause(c_4816,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,++p1,--p2,++p3,--p4,--p5,--p6]).

input_clause(c_4817,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,++p1,++p3,--p4,--p5,--p6,++p7]).

input_clause(c_4818,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,++p1,++p3,--p4,--p5]).

input_clause(c_4819,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,++p1,++p3,--p4,++p7]).

input_clause(c_4820,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,++p1,++p3,--p4,--p6]).

input_clause(c_4821,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,++p1,++p3,--p6,++p7]).

input_clause(c_4822,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,++p1,++p3]).

input_clause(c_4823,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,++p1,++p3,--p5,++p7]).

input_clause(c_4824,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,++p1,++p3,--p5,--p6]).

input_clause(c_4825,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,++p1,--p5,--p6,++p7]).

input_clause(c_4826,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,++p1,--p5]).

input_clause(c_4827,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,++p1,++p7]).

input_clause(c_4828,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,++p1,--p6]).

input_clause(c_4829,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,++p1,--p4,--p6,++p7]).

input_clause(c_4830,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,++p1,--p4]).

input_clause(c_4831,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,++p1,--p4,--p5,++p7]).

input_clause(c_4832,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,++p1,--p4,--p5,--p6]).

input_clause(c_4833,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,--p4,--p5,--p6,++p7]).

input_clause(c_4834,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,--p4,--p5]).

input_clause(c_4835,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,--p4,++p7]).

input_clause(c_4836,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,--p4,--p6]).

input_clause(c_4837,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,--p6,++p7]).

input_clause(c_4838,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7]).

input_clause(c_4839,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,--p5,++p7]).

input_clause(c_4840,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,--p5,--p6]).

input_clause(c_4841,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,++p3,--p5,--p6,++p7]).

input_clause(c_4842,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,++p3,--p5]).

input_clause(c_4843,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,++p3,++p7]).

input_clause(c_4844,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,++p3,--p6]).

input_clause(c_4845,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,++p3,--p4,--p6,++p7]).

input_clause(c_4846,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,++p3,--p4]).

input_clause(c_4847,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,++p3,--p4,--p5,++p7]).

input_clause(c_4848,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,++p3,--p4,--p5,--p6]).

input_clause(c_4849,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,--p2,++p3,--p4,--p5,--p6,++p7]).

input_clause(c_4850,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,--p2,++p3,--p4,--p5]).

input_clause(c_4851,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,--p2,++p3,--p4,++p7]).

input_clause(c_4852,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,--p2,++p3,--p4,--p6]).

input_clause(c_4853,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,--p2,++p3,--p6,++p7]).

input_clause(c_4854,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,--p2,++p3]).

input_clause(c_4855,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,--p2,++p3,--p5,++p7]).

input_clause(c_4856,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,--p2,++p3,--p5,--p6]).

input_clause(c_4857,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,--p2,--p5,--p6,++p7]).

input_clause(c_4858,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,--p2,--p5]).

input_clause(c_4859,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,--p2,++p7]).

input_clause(c_4860,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,--p2,--p6]).

input_clause(c_4861,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,--p2,--p4,--p6,++p7]).

input_clause(c_4862,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,--p2,--p4]).

input_clause(c_4863,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,--p2,--p4,--p5,++p7]).

input_clause(c_4864,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p7,--p2,--p4,--p5,--p6]).

input_clause(c_4865,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,--p2,--p4,--p6,++p7]).

input_clause(c_4866,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,--p2,--p4]).

input_clause(c_4867,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,--p2,--p4,++p5,++p7]).

input_clause(c_4868,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,--p2,--p4,++p5,--p6]).

input_clause(c_4869,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,--p2,++p5,--p6,++p7]).

input_clause(c_4870,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,--p2,++p5]).

input_clause(c_4871,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,--p2,++p7]).

input_clause(c_4872,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,--p2,--p6]).

input_clause(c_4873,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,--p2,++p3,--p6,++p7]).

input_clause(c_4874,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,--p2,++p3]).

input_clause(c_4875,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,--p2,++p3,++p5,++p7]).

input_clause(c_4876,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,--p2,++p3,++p5,--p6]).

input_clause(c_4877,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,--p2,++p3,--p4,++p5,--p6,++p7]).

input_clause(c_4878,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,--p2,++p3,--p4,++p5]).

input_clause(c_4879,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,--p2,++p3,--p4,++p7]).

input_clause(c_4880,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,--p2,++p3,--p4,--p6]).

input_clause(c_4881,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,++p3,--p4,--p6,++p7]).

input_clause(c_4882,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,++p3,--p4]).

input_clause(c_4883,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,++p3,--p4,++p5,++p7]).

input_clause(c_4884,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,++p3,--p4,++p5,--p6]).

input_clause(c_4885,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,++p3,++p5,--p6,++p7]).

input_clause(c_4886,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,++p3,++p5]).

input_clause(c_4887,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,++p3,++p7]).

input_clause(c_4888,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,++p3,--p6]).

input_clause(c_4889,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,--p6,++p7]).

input_clause(c_4890,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7]).

input_clause(c_4891,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,++p5,++p7]).

input_clause(c_4892,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,++p5,--p6]).

input_clause(c_4893,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,--p4,++p5,--p6,++p7]).

input_clause(c_4894,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,--p4,++p5]).

input_clause(c_4895,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,--p4,++p7]).

input_clause(c_4896,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,--p4,--p6]).

input_clause(c_4897,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,++p1,--p4,--p6,++p7]).

input_clause(c_4898,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,++p1,--p4]).

input_clause(c_4899,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,++p1,--p4,++p5,++p7]).

input_clause(c_4900,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,++p1,--p4,++p5,--p6]).

input_clause(c_4901,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,++p1,++p5,--p6,++p7]).

input_clause(c_4902,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,++p1,++p5]).

input_clause(c_4903,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,++p1,++p7]).

input_clause(c_4904,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,++p1,--p6]).

input_clause(c_4905,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,++p1,++p3,--p6,++p7]).

input_clause(c_4906,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,++p1,++p3]).

input_clause(c_4907,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,++p1,++p3,++p5,++p7]).

input_clause(c_4908,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,++p1,++p3,++p5,--p6]).

input_clause(c_4909,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,++p1,++p3,--p4,++p5,--p6,++p7]).

input_clause(c_4910,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,++p1,++p3,--p4,++p5]).

input_clause(c_4911,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,++p1,++p3,--p4,++p7]).

input_clause(c_4912,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,++p1,++p3,--p4,--p6]).

input_clause(c_4913,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,++p1,--p2,++p3,--p4,--p6,++p7]).

input_clause(c_4914,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,++p1,--p2,++p3,--p4]).

input_clause(c_4915,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,++p1,--p2,++p3,--p4,++p5,++p7]).

input_clause(c_4916,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,++p1,--p2,++p3,--p4,++p5,--p6]).

input_clause(c_4917,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,++p1,--p2,++p3,++p5,--p6,++p7]).

input_clause(c_4918,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,++p1,--p2,++p3,++p5]).

input_clause(c_4919,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,++p1,--p2,++p3,++p7]).

input_clause(c_4920,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,++p1,--p2,++p3,--p6]).

input_clause(c_4921,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,++p1,--p2,--p6,++p7]).

input_clause(c_4922,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,++p1,--p2]).

input_clause(c_4923,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,++p1,--p2,++p5,++p7]).

input_clause(c_4924,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,++p1,--p2,++p5,--p6]).

input_clause(c_4925,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,++p1,--p2,--p4,++p5,--p6,++p7]).

input_clause(c_4926,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,++p1,--p2,--p4,++p5]).

input_clause(c_4927,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,++p1,--p2,--p4,++p7]).

input_clause(c_4928,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p7,++p1,--p2,--p4,--p6]).

input_clause(c_4929,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,++p1,--p2,--p4,--p6]).

input_clause(c_4930,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,++p1,--p2,--p4,--p7]).

input_clause(c_4931,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,++p1,--p2,--p4,++p5]).

input_clause(c_4932,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,++p1,--p2,--p4,++p5,--p6,--p7]).

input_clause(c_4933,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,++p1,--p2,++p5,--p6]).

input_clause(c_4934,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,++p1,--p2,++p5,--p7]).

input_clause(c_4935,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,++p1,--p2]).

input_clause(c_4936,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,++p1,--p2,--p6,--p7]).

input_clause(c_4937,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,++p1,--p2,++p3,--p6]).

input_clause(c_4938,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,++p1,--p2,++p3,--p7]).

input_clause(c_4939,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,++p1,--p2,++p3,++p5]).

input_clause(c_4940,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,++p1,--p2,++p3,++p5,--p6,--p7]).

input_clause(c_4941,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,++p1,--p2,++p3,--p4,++p5,--p6]).

input_clause(c_4942,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,++p1,--p2,++p3,--p4,++p5,--p7]).

input_clause(c_4943,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,++p1,--p2,++p3,--p4]).

input_clause(c_4944,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,++p1,--p2,++p3,--p4,--p6,--p7]).

input_clause(c_4945,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,++p1,++p3,--p4,--p6]).

input_clause(c_4946,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,++p1,++p3,--p4,--p7]).

input_clause(c_4947,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,++p1,++p3,--p4,++p5]).

input_clause(c_4948,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,++p1,++p3,--p4,++p5,--p6,--p7]).

input_clause(c_4949,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,++p1,++p3,++p5,--p6]).

input_clause(c_4950,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,++p1,++p3,++p5,--p7]).

input_clause(c_4951,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,++p1,++p3]).

input_clause(c_4952,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,++p1,++p3,--p6,--p7]).

input_clause(c_4953,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,++p1,--p6]).

input_clause(c_4954,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,++p1,--p7]).

input_clause(c_4955,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,++p1,++p5]).

input_clause(c_4956,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,++p1,++p5,--p6,--p7]).

input_clause(c_4957,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,++p1,--p4,++p5,--p6]).

input_clause(c_4958,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,++p1,--p4,++p5,--p7]).

input_clause(c_4959,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,++p1,--p4]).

input_clause(c_4960,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,++p1,--p4,--p6,--p7]).

input_clause(c_4961,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,--p4,--p6]).

input_clause(c_4962,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,--p4,--p7]).

input_clause(c_4963,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,--p4,++p5]).

input_clause(c_4964,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,--p4,++p5,--p6,--p7]).

input_clause(c_4965,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,++p5,--p6]).

input_clause(c_4966,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,++p5,--p7]).

input_clause(c_4967,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7]).

input_clause(c_4968,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,--p6,--p7]).

input_clause(c_4969,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,++p3,--p6]).

input_clause(c_4970,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,++p3,--p7]).

input_clause(c_4971,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,++p3,++p5]).

input_clause(c_4972,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,++p3,++p5,--p6,--p7]).

input_clause(c_4973,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,++p3,--p4,++p5,--p6]).

input_clause(c_4974,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,++p3,--p4,++p5,--p7]).

input_clause(c_4975,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,++p3,--p4]).

input_clause(c_4976,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,++p3,--p4,--p6,--p7]).

input_clause(c_4977,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,--p2,++p3,--p4,--p6]).

input_clause(c_4978,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,--p2,++p3,--p4,--p7]).

input_clause(c_4979,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,--p2,++p3,--p4,++p5]).

input_clause(c_4980,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,--p2,++p3,--p4,++p5,--p6,--p7]).

input_clause(c_4981,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,--p2,++p3,++p5,--p6]).

input_clause(c_4982,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,--p2,++p3,++p5,--p7]).

input_clause(c_4983,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,--p2,++p3]).

input_clause(c_4984,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,--p2,++p3,--p6,--p7]).

input_clause(c_4985,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,--p2,--p6]).

input_clause(c_4986,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,--p2,--p7]).

input_clause(c_4987,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,--p2,++p5]).

input_clause(c_4988,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,--p2,++p5,--p6,--p7]).

input_clause(c_4989,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,--p2,--p4,++p5,--p6]).

input_clause(c_4990,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,--p2,--p4,++p5,--p7]).

input_clause(c_4991,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,--p2,--p4]).

input_clause(c_4992,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p7,--p2,--p4,--p6,--p7]).

input_clause(c_4993,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,--p2,--p4]).

input_clause(c_4994,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,--p2,--p4,++p6,--p7]).

input_clause(c_4995,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,--p2,--p4,++p5,++p6]).

input_clause(c_4996,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,--p2,--p4,++p5,--p7]).

input_clause(c_4997,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,--p2,++p5]).

input_clause(c_4998,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,--p2,++p5,++p6,--p7]).

input_clause(c_4999,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,--p2,++p6]).

input_clause(c_5000,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,--p2,--p7]).

input_clause(c_5001,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,--p2,++p3]).

input_clause(c_5002,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,--p2,++p3,++p6,--p7]).

input_clause(c_5003,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,--p2,++p3,++p5,++p6]).

input_clause(c_5004,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,--p2,++p3,++p5,--p7]).

input_clause(c_5005,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,--p2,++p3,--p4,++p5]).

input_clause(c_5006,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,--p2,++p3,--p4,++p5,++p6,--p7]).

input_clause(c_5007,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,--p2,++p3,--p4,++p6]).

input_clause(c_5008,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,--p2,++p3,--p4,--p7]).

input_clause(c_5009,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,++p3,--p4]).

input_clause(c_5010,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,++p3,--p4,++p6,--p7]).

input_clause(c_5011,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,++p3,--p4,++p5,++p6]).

input_clause(c_5012,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,++p3,--p4,++p5,--p7]).

input_clause(c_5013,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,++p3,++p5]).

input_clause(c_5014,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,++p3,++p5,++p6,--p7]).

input_clause(c_5015,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,++p3,++p6]).

input_clause(c_5016,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,++p3,--p7]).

input_clause(c_5017,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7]).

input_clause(c_5018,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,++p6,--p7]).

input_clause(c_5019,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,++p5,++p6]).

input_clause(c_5020,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,++p5,--p7]).

input_clause(c_5021,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,--p4,++p5]).

input_clause(c_5022,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,--p4,++p5,++p6,--p7]).

input_clause(c_5023,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,--p4,++p6]).

input_clause(c_5024,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,--p4,--p7]).

input_clause(c_5025,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,++p1,--p4]).

input_clause(c_5026,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,++p1,--p4,++p6,--p7]).

input_clause(c_5027,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,++p1,--p4,++p5,++p6]).

input_clause(c_5028,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,++p1,--p4,++p5,--p7]).

input_clause(c_5029,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,++p1,++p5]).

input_clause(c_5030,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,++p1,++p5,++p6,--p7]).

input_clause(c_5031,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,++p1,++p6]).

input_clause(c_5032,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,++p1,--p7]).

input_clause(c_5033,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,++p1,++p3]).

input_clause(c_5034,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,++p1,++p3,++p6,--p7]).

input_clause(c_5035,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,++p1,++p3,++p5,++p6]).

input_clause(c_5036,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,++p1,++p3,++p5,--p7]).

input_clause(c_5037,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,++p1,++p3,--p4,++p5]).

input_clause(c_5038,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,++p1,++p3,--p4,++p5,++p6,--p7]).

input_clause(c_5039,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,++p1,++p3,--p4,++p6]).

input_clause(c_5040,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,++p1,++p3,--p4,--p7]).

input_clause(c_5041,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,++p1,--p2,++p3,--p4]).

input_clause(c_5042,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,++p1,--p2,++p3,--p4,++p6,--p7]).

input_clause(c_5043,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,++p1,--p2,++p3,--p4,++p5,++p6]).

input_clause(c_5044,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,++p1,--p2,++p3,--p4,++p5,--p7]).

input_clause(c_5045,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,++p1,--p2,++p3,++p5]).

input_clause(c_5046,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,++p1,--p2,++p3,++p5,++p6,--p7]).

input_clause(c_5047,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,++p1,--p2,++p3,++p6]).

input_clause(c_5048,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,++p1,--p2,++p3,--p7]).

input_clause(c_5049,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,++p1,--p2]).

input_clause(c_5050,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,++p1,--p2,++p6,--p7]).

input_clause(c_5051,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,++p1,--p2,++p5,++p6]).

input_clause(c_5052,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,++p1,--p2,++p5,--p7]).

input_clause(c_5053,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,++p1,--p2,--p4,++p5]).

input_clause(c_5054,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,++p1,--p2,--p4,++p5,++p6,--p7]).

input_clause(c_5055,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,++p1,--p2,--p4,++p6]).

input_clause(c_5056,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p7,++p1,--p2,--p4,--p7]).

input_clause(c_5057,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,++p1,--p2,--p4,++p7]).

input_clause(c_5058,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,++p1,--p2,--p4,++p6]).

input_clause(c_5059,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,++p1,--p2,--p4,++p5,++p6,++p7]).

input_clause(c_5060,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,++p1,--p2,--p4,++p5]).

input_clause(c_5061,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,++p1,--p2,++p5,++p7]).

input_clause(c_5062,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,++p1,--p2,++p5,++p6]).

input_clause(c_5063,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,++p1,--p2,++p6,++p7]).

input_clause(c_5064,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,++p1,--p2]).

input_clause(c_5065,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,++p1,--p2,++p3,++p7]).

input_clause(c_5066,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,++p1,--p2,++p3,++p6]).

input_clause(c_5067,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,++p1,--p2,++p3,++p5,++p6,++p7]).

input_clause(c_5068,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,++p1,--p2,++p3,++p5]).

input_clause(c_5069,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,++p1,--p2,++p3,--p4,++p5,++p7]).

input_clause(c_5070,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,++p1,--p2,++p3,--p4,++p5,++p6]).

input_clause(c_5071,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,++p1,--p2,++p3,--p4,++p6,++p7]).

input_clause(c_5072,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,++p1,--p2,++p3,--p4]).

input_clause(c_5073,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,++p1,++p3,--p4,++p7]).

input_clause(c_5074,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,++p1,++p3,--p4,++p6]).

input_clause(c_5075,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,++p1,++p3,--p4,++p5,++p6,++p7]).

input_clause(c_5076,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,++p1,++p3,--p4,++p5]).

input_clause(c_5077,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,++p1,++p3,++p5,++p7]).

input_clause(c_5078,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,++p1,++p3,++p5,++p6]).

input_clause(c_5079,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,++p1,++p3,++p6,++p7]).

input_clause(c_5080,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,++p1,++p3]).

input_clause(c_5081,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,++p1,++p7]).

input_clause(c_5082,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,++p1,++p6]).

input_clause(c_5083,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,++p1,++p5,++p6,++p7]).

input_clause(c_5084,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,++p1,++p5]).

input_clause(c_5085,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,++p1,--p4,++p5,++p7]).

input_clause(c_5086,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,++p1,--p4,++p5,++p6]).

input_clause(c_5087,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,++p1,--p4,++p6,++p7]).

input_clause(c_5088,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,++p1,--p4]).

input_clause(c_5089,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,--p4,++p7]).

input_clause(c_5090,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,--p4,++p6]).

input_clause(c_5091,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,--p4,++p5,++p6,++p7]).

input_clause(c_5092,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,--p4,++p5]).

input_clause(c_5093,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,++p5,++p7]).

input_clause(c_5094,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,++p5,++p6]).

input_clause(c_5095,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,++p6,++p7]).

input_clause(c_5096,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7]).

input_clause(c_5097,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,++p3,++p7]).

input_clause(c_5098,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,++p3,++p6]).

input_clause(c_5099,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,++p3,++p5,++p6,++p7]).

input_clause(c_5100,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,++p3,++p5]).

input_clause(c_5101,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,++p3,--p4,++p5,++p7]).

input_clause(c_5102,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,++p3,--p4,++p5,++p6]).

input_clause(c_5103,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,++p3,--p4,++p6,++p7]).

input_clause(c_5104,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,++p3,--p4]).

input_clause(c_5105,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,--p2,++p3,--p4,++p7]).

input_clause(c_5106,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,--p2,++p3,--p4,++p6]).

input_clause(c_5107,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,--p2,++p3,--p4,++p5,++p6,++p7]).

input_clause(c_5108,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,--p2,++p3,--p4,++p5]).

input_clause(c_5109,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,--p2,++p3,++p5,++p7]).

input_clause(c_5110,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,--p2,++p3,++p5,++p6]).

input_clause(c_5111,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,--p2,++p3,++p6,++p7]).

input_clause(c_5112,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,--p2,++p3]).

input_clause(c_5113,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,--p2,++p7]).

input_clause(c_5114,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,--p2,++p6]).

input_clause(c_5115,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,--p2,++p5,++p6,++p7]).

input_clause(c_5116,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,--p2,++p5]).

input_clause(c_5117,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,--p2,--p4,++p5,++p7]).

input_clause(c_5118,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,--p2,--p4,++p5,++p6]).

input_clause(c_5119,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,--p2,--p4,++p6,++p7]).

input_clause(c_5120,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p7,--p2,--p4]).

input_clause(c_5121,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,--p2,--p3,--p4,++p7]).

input_clause(c_5122,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,--p2,--p3,--p4,++p6]).

input_clause(c_5123,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,--p2,--p3,--p4,++p5,++p6,++p7]).

input_clause(c_5124,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,--p2,--p3,--p4,++p5]).

input_clause(c_5125,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,--p2,--p3,++p5,++p7]).

input_clause(c_5126,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,--p2,--p3,++p5,++p6]).

input_clause(c_5127,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,--p2,--p3,++p6,++p7]).

input_clause(c_5128,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,--p2,--p3]).

input_clause(c_5129,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,--p2,++p7]).

input_clause(c_5130,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,--p2,++p6]).

input_clause(c_5131,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,--p2,++p5,++p6,++p7]).

input_clause(c_5132,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,--p2,++p5]).

input_clause(c_5133,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,--p2,--p4,++p5,++p7]).

input_clause(c_5134,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,--p2,--p4,++p5,++p6]).

input_clause(c_5135,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,--p2,--p4,++p6,++p7]).

input_clause(c_5136,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,--p2,--p4]).

input_clause(c_5137,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,--p4,++p7]).

input_clause(c_5138,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,--p4,++p6]).

input_clause(c_5139,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,--p4,++p5,++p6,++p7]).

input_clause(c_5140,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,--p4,++p5]).

input_clause(c_5141,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,++p5,++p7]).

input_clause(c_5142,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,++p5,++p6]).

input_clause(c_5143,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,++p6,++p7]).

input_clause(c_5144,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7]).

input_clause(c_5145,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,--p3,++p7]).

input_clause(c_5146,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,--p3,++p6]).

input_clause(c_5147,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,--p3,++p5,++p6,++p7]).

input_clause(c_5148,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,--p3,++p5]).

input_clause(c_5149,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,--p3,--p4,++p5,++p7]).

input_clause(c_5150,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,--p3,--p4,++p5,++p6]).

input_clause(c_5151,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,--p3,--p4,++p6,++p7]).

input_clause(c_5152,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,--p3,--p4]).

input_clause(c_5153,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,++p1,--p3,--p4,++p7]).

input_clause(c_5154,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,++p1,--p3,--p4,++p6]).

input_clause(c_5155,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,++p1,--p3,--p4,++p5,++p6,++p7]).

input_clause(c_5156,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,++p1,--p3,--p4,++p5]).

input_clause(c_5157,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,++p1,--p3,++p5,++p7]).

input_clause(c_5158,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,++p1,--p3,++p5,++p6]).

input_clause(c_5159,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,++p1,--p3,++p6,++p7]).

input_clause(c_5160,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,++p1,--p3]).

input_clause(c_5161,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,++p1,++p7]).

input_clause(c_5162,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,++p1,++p6]).

input_clause(c_5163,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,++p1,++p5,++p6,++p7]).

input_clause(c_5164,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,++p1,++p5]).

input_clause(c_5165,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,++p1,--p4,++p5,++p7]).

input_clause(c_5166,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,++p1,--p4,++p5,++p6]).

input_clause(c_5167,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,++p1,--p4,++p6,++p7]).

input_clause(c_5168,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,++p1,--p4]).

input_clause(c_5169,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,++p1,--p2,--p4,++p7]).

input_clause(c_5170,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,++p1,--p2,--p4,++p6]).

input_clause(c_5171,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,++p1,--p2,--p4,++p5,++p6,++p7]).

input_clause(c_5172,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,++p1,--p2,--p4,++p5]).

input_clause(c_5173,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,++p1,--p2,++p5,++p7]).

input_clause(c_5174,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,++p1,--p2,++p5,++p6]).

input_clause(c_5175,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,++p1,--p2,++p6,++p7]).

input_clause(c_5176,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,++p1,--p2]).

input_clause(c_5177,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,++p1,--p2,--p3,++p7]).

input_clause(c_5178,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,++p1,--p2,--p3,++p6]).

input_clause(c_5179,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,++p1,--p2,--p3,++p5,++p6,++p7]).

input_clause(c_5180,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,++p1,--p2,--p3,++p5]).

input_clause(c_5181,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,++p1,--p2,--p3,--p4,++p5,++p7]).

input_clause(c_5182,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,++p1,--p2,--p3,--p4,++p5,++p6]).

input_clause(c_5183,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,++p1,--p2,--p3,--p4,++p6,++p7]).

input_clause(c_5184,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p7,++p1,--p2,--p3,--p4]).

input_clause(c_5185,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,++p1,--p2,--p3,--p4]).

input_clause(c_5186,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,++p1,--p2,--p3,--p4,++p6,--p7]).

input_clause(c_5187,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,++p1,--p2,--p3,--p4,++p5,++p6]).

input_clause(c_5188,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,++p1,--p2,--p3,--p4,++p5,--p7]).

input_clause(c_5189,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,++p1,--p2,--p3,++p5]).

input_clause(c_5190,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,++p1,--p2,--p3,++p5,++p6,--p7]).

input_clause(c_5191,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,++p1,--p2,--p3,++p6]).

input_clause(c_5192,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,++p1,--p2,--p3,--p7]).

input_clause(c_5193,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,++p1,--p2]).

input_clause(c_5194,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,++p1,--p2,++p6,--p7]).

input_clause(c_5195,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,++p1,--p2,++p5,++p6]).

input_clause(c_5196,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,++p1,--p2,++p5,--p7]).

input_clause(c_5197,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,++p1,--p2,--p4,++p5]).

input_clause(c_5198,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,++p1,--p2,--p4,++p5,++p6,--p7]).

input_clause(c_5199,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,++p1,--p2,--p4,++p6]).

input_clause(c_5200,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,++p1,--p2,--p4,--p7]).

input_clause(c_5201,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,++p1,--p4]).

input_clause(c_5202,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,++p1,--p4,++p6,--p7]).

input_clause(c_5203,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,++p1,--p4,++p5,++p6]).

input_clause(c_5204,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,++p1,--p4,++p5,--p7]).

input_clause(c_5205,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,++p1,++p5]).

input_clause(c_5206,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,++p1,++p5,++p6,--p7]).

input_clause(c_5207,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,++p1,++p6]).

input_clause(c_5208,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,++p1,--p7]).

input_clause(c_5209,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,++p1,--p3]).

input_clause(c_5210,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,++p1,--p3,++p6,--p7]).

input_clause(c_5211,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,++p1,--p3,++p5,++p6]).

input_clause(c_5212,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,++p1,--p3,++p5,--p7]).

input_clause(c_5213,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,++p1,--p3,--p4,++p5]).

input_clause(c_5214,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,++p1,--p3,--p4,++p5,++p6,--p7]).

input_clause(c_5215,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,++p1,--p3,--p4,++p6]).

input_clause(c_5216,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,++p1,--p3,--p4,--p7]).

input_clause(c_5217,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,--p3,--p4]).

input_clause(c_5218,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,--p3,--p4,++p6,--p7]).

input_clause(c_5219,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,--p3,--p4,++p5,++p6]).

input_clause(c_5220,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,--p3,--p4,++p5,--p7]).

input_clause(c_5221,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,--p3,++p5]).

input_clause(c_5222,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,--p3,++p5,++p6,--p7]).

input_clause(c_5223,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,--p3,++p6]).

input_clause(c_5224,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,--p3,--p7]).

input_clause(c_5225,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7]).

input_clause(c_5226,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,++p6,--p7]).

input_clause(c_5227,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,++p5,++p6]).

input_clause(c_5228,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,++p5,--p7]).

input_clause(c_5229,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,--p4,++p5]).

input_clause(c_5230,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,--p4,++p5,++p6,--p7]).

input_clause(c_5231,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,--p4,++p6]).

input_clause(c_5232,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,--p4,--p7]).

input_clause(c_5233,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,--p2,--p4]).

input_clause(c_5234,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,--p2,--p4,++p6,--p7]).

input_clause(c_5235,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,--p2,--p4,++p5,++p6]).

input_clause(c_5236,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,--p2,--p4,++p5,--p7]).

input_clause(c_5237,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,--p2,++p5]).

input_clause(c_5238,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,--p2,++p5,++p6,--p7]).

input_clause(c_5239,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,--p2,++p6]).

input_clause(c_5240,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,--p2,--p7]).

input_clause(c_5241,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,--p2,--p3]).

input_clause(c_5242,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,--p2,--p3,++p6,--p7]).

input_clause(c_5243,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,--p2,--p3,++p5,++p6]).

input_clause(c_5244,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,--p2,--p3,++p5,--p7]).

input_clause(c_5245,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,--p2,--p3,--p4,++p5]).

input_clause(c_5246,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,--p2,--p3,--p4,++p5,++p6,--p7]).

input_clause(c_5247,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,--p2,--p3,--p4,++p6]).

input_clause(c_5248,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p7,--p2,--p3,--p4,--p7]).

input_clause(c_5249,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,--p2,--p3,--p4,--p6]).

input_clause(c_5250,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,--p2,--p3,--p4,--p7]).

input_clause(c_5251,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,--p2,--p3,--p4,++p5]).

input_clause(c_5252,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,--p2,--p3,--p4,++p5,--p6,--p7]).

input_clause(c_5253,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,--p2,--p3,++p5,--p6]).

input_clause(c_5254,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,--p2,--p3,++p5,--p7]).

input_clause(c_5255,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,--p2,--p3]).

input_clause(c_5256,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,--p2,--p3,--p6,--p7]).

input_clause(c_5257,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,--p2,--p6]).

input_clause(c_5258,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,--p2,--p7]).

input_clause(c_5259,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,--p2,++p5]).

input_clause(c_5260,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,--p2,++p5,--p6,--p7]).

input_clause(c_5261,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,--p2,--p4,++p5,--p6]).

input_clause(c_5262,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,--p2,--p4,++p5,--p7]).

input_clause(c_5263,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,--p2,--p4]).

input_clause(c_5264,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,--p2,--p4,--p6,--p7]).

input_clause(c_5265,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,--p4,--p6]).

input_clause(c_5266,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,--p4,--p7]).

input_clause(c_5267,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,--p4,++p5]).

input_clause(c_5268,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,--p4,++p5,--p6,--p7]).

input_clause(c_5269,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,++p5,--p6]).

input_clause(c_5270,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,++p5,--p7]).

input_clause(c_5271,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7]).

input_clause(c_5272,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,--p6,--p7]).

input_clause(c_5273,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,--p3,--p6]).

input_clause(c_5274,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,--p3,--p7]).

input_clause(c_5275,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,--p3,++p5]).

input_clause(c_5276,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,--p3,++p5,--p6,--p7]).

input_clause(c_5277,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,--p3,--p4,++p5,--p6]).

input_clause(c_5278,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,--p3,--p4,++p5,--p7]).

input_clause(c_5279,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,--p3,--p4]).

input_clause(c_5280,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,--p3,--p4,--p6,--p7]).

input_clause(c_5281,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,++p1,--p3,--p4,--p6]).

input_clause(c_5282,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,++p1,--p3,--p4,--p7]).

input_clause(c_5283,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,++p1,--p3,--p4,++p5]).

input_clause(c_5284,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,++p1,--p3,--p4,++p5,--p6,--p7]).

input_clause(c_5285,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,++p1,--p3,++p5,--p6]).

input_clause(c_5286,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,++p1,--p3,++p5,--p7]).

input_clause(c_5287,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,++p1,--p3]).

input_clause(c_5288,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,++p1,--p3,--p6,--p7]).

input_clause(c_5289,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,++p1,--p6]).

input_clause(c_5290,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,++p1,--p7]).

input_clause(c_5291,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,++p1,++p5]).

input_clause(c_5292,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,++p1,++p5,--p6,--p7]).

input_clause(c_5293,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,++p1,--p4,++p5,--p6]).

input_clause(c_5294,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,++p1,--p4,++p5,--p7]).

input_clause(c_5295,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,++p1,--p4]).

input_clause(c_5296,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,++p1,--p4,--p6,--p7]).

input_clause(c_5297,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,++p1,--p2,--p4,--p6]).

input_clause(c_5298,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,++p1,--p2,--p4,--p7]).

input_clause(c_5299,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,++p1,--p2,--p4,++p5]).

input_clause(c_5300,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,++p1,--p2,--p4,++p5,--p6,--p7]).

input_clause(c_5301,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,++p1,--p2,++p5,--p6]).

input_clause(c_5302,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,++p1,--p2,++p5,--p7]).

input_clause(c_5303,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,++p1,--p2]).

input_clause(c_5304,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,++p1,--p2,--p6,--p7]).

input_clause(c_5305,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,++p1,--p2,--p3,--p6]).

input_clause(c_5306,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,++p1,--p2,--p3,--p7]).

input_clause(c_5307,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,++p1,--p2,--p3,++p5]).

input_clause(c_5308,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,++p1,--p2,--p3,++p5,--p6,--p7]).

input_clause(c_5309,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,++p1,--p2,--p3,--p4,++p5,--p6]).

input_clause(c_5310,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,++p1,--p2,--p3,--p4,++p5,--p7]).

input_clause(c_5311,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,++p1,--p2,--p3,--p4]).

input_clause(c_5312,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p7,++p1,--p2,--p3,--p4,--p6,--p7]).

input_clause(c_5313,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,++p1,--p2,--p3,--p4,--p6,++p7]).

input_clause(c_5314,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,++p1,--p2,--p3,--p4]).

input_clause(c_5315,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,++p1,--p2,--p3,--p4,++p5,++p7]).

input_clause(c_5316,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,++p1,--p2,--p3,--p4,++p5,--p6]).

input_clause(c_5317,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,++p1,--p2,--p3,++p5,--p6,++p7]).

input_clause(c_5318,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,++p1,--p2,--p3,++p5]).

input_clause(c_5319,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,++p1,--p2,--p3,++p7]).

input_clause(c_5320,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,++p1,--p2,--p3,--p6]).

input_clause(c_5321,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,++p1,--p2,--p6,++p7]).

input_clause(c_5322,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,++p1,--p2]).

input_clause(c_5323,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,++p1,--p2,++p5,++p7]).

input_clause(c_5324,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,++p1,--p2,++p5,--p6]).

input_clause(c_5325,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,++p1,--p2,--p4,++p5,--p6,++p7]).

input_clause(c_5326,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,++p1,--p2,--p4,++p5]).

input_clause(c_5327,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,++p1,--p2,--p4,++p7]).

input_clause(c_5328,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,++p1,--p2,--p4,--p6]).

input_clause(c_5329,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,++p1,--p4,--p6,++p7]).

input_clause(c_5330,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,++p1,--p4]).

input_clause(c_5331,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,++p1,--p4,++p5,++p7]).

input_clause(c_5332,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,++p1,--p4,++p5,--p6]).

input_clause(c_5333,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,++p1,++p5,--p6,++p7]).

input_clause(c_5334,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,++p1,++p5]).

input_clause(c_5335,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,++p1,++p7]).

input_clause(c_5336,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,++p1,--p6]).

input_clause(c_5337,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,++p1,--p3,--p6,++p7]).

input_clause(c_5338,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,++p1,--p3]).

input_clause(c_5339,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,++p1,--p3,++p5,++p7]).

input_clause(c_5340,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,++p1,--p3,++p5,--p6]).

input_clause(c_5341,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,++p1,--p3,--p4,++p5,--p6,++p7]).

input_clause(c_5342,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,++p1,--p3,--p4,++p5]).

input_clause(c_5343,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,++p1,--p3,--p4,++p7]).

input_clause(c_5344,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,++p1,--p3,--p4,--p6]).

input_clause(c_5345,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,--p3,--p4,--p6,++p7]).

input_clause(c_5346,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,--p3,--p4]).

input_clause(c_5347,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,--p3,--p4,++p5,++p7]).

input_clause(c_5348,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,--p3,--p4,++p5,--p6]).

input_clause(c_5349,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,--p3,++p5,--p6,++p7]).

input_clause(c_5350,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,--p3,++p5]).

input_clause(c_5351,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,--p3,++p7]).

input_clause(c_5352,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,--p3,--p6]).

input_clause(c_5353,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,--p6,++p7]).

input_clause(c_5354,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7]).

input_clause(c_5355,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,++p5,++p7]).

input_clause(c_5356,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,++p5,--p6]).

input_clause(c_5357,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,--p4,++p5,--p6,++p7]).

input_clause(c_5358,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,--p4,++p5]).

input_clause(c_5359,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,--p4,++p7]).

input_clause(c_5360,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,--p4,--p6]).

input_clause(c_5361,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,--p2,--p4,--p6,++p7]).

input_clause(c_5362,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,--p2,--p4]).

input_clause(c_5363,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,--p2,--p4,++p5,++p7]).

input_clause(c_5364,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,--p2,--p4,++p5,--p6]).

input_clause(c_5365,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,--p2,++p5,--p6,++p7]).

input_clause(c_5366,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,--p2,++p5]).

input_clause(c_5367,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,--p2,++p7]).

input_clause(c_5368,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,--p2,--p6]).

input_clause(c_5369,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,--p2,--p3,--p6,++p7]).

input_clause(c_5370,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,--p2,--p3]).

input_clause(c_5371,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,--p2,--p3,++p5,++p7]).

input_clause(c_5372,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,--p2,--p3,++p5,--p6]).

input_clause(c_5373,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,--p2,--p3,--p4,++p5,--p6,++p7]).

input_clause(c_5374,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,--p2,--p3,--p4,++p5]).

input_clause(c_5375,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,--p2,--p3,--p4,++p7]).

input_clause(c_5376,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p7,--p2,--p3,--p4,--p6]).

input_clause(c_5377,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,--p2,--p3,--p4,--p5,--p6,++p7]).

input_clause(c_5378,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,--p2,--p3,--p4,--p5]).

input_clause(c_5379,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,--p2,--p3,--p4,++p7]).

input_clause(c_5380,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,--p2,--p3,--p4,--p6]).

input_clause(c_5381,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,--p2,--p3,--p6,++p7]).

input_clause(c_5382,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,--p2,--p3]).

input_clause(c_5383,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,--p2,--p3,--p5,++p7]).

input_clause(c_5384,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,--p2,--p3,--p5,--p6]).

input_clause(c_5385,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,--p2,--p5,--p6,++p7]).

input_clause(c_5386,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,--p2,--p5]).

input_clause(c_5387,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,--p2,++p7]).

input_clause(c_5388,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,--p2,--p6]).

input_clause(c_5389,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,--p2,--p4,--p6,++p7]).

input_clause(c_5390,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,--p2,--p4]).

input_clause(c_5391,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,--p2,--p4,--p5,++p7]).

input_clause(c_5392,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,--p2,--p4,--p5,--p6]).

input_clause(c_5393,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,--p4,--p5,--p6,++p7]).

input_clause(c_5394,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,--p4,--p5]).

input_clause(c_5395,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,--p4,++p7]).

input_clause(c_5396,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,--p4,--p6]).

input_clause(c_5397,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,--p6,++p7]).

input_clause(c_5398,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7]).

input_clause(c_5399,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,--p5,++p7]).

input_clause(c_5400,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,--p5,--p6]).

input_clause(c_5401,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,--p3,--p5,--p6,++p7]).

input_clause(c_5402,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,--p3,--p5]).

input_clause(c_5403,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,--p3,++p7]).

input_clause(c_5404,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,--p3,--p6]).

input_clause(c_5405,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,--p3,--p4,--p6,++p7]).

input_clause(c_5406,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,--p3,--p4]).

input_clause(c_5407,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,--p3,--p4,--p5,++p7]).

input_clause(c_5408,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,--p3,--p4,--p5,--p6]).

input_clause(c_5409,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,++p1,--p3,--p4,--p5,--p6,++p7]).

input_clause(c_5410,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,++p1,--p3,--p4,--p5]).

input_clause(c_5411,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,++p1,--p3,--p4,++p7]).

input_clause(c_5412,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,++p1,--p3,--p4,--p6]).

input_clause(c_5413,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,++p1,--p3,--p6,++p7]).

input_clause(c_5414,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,++p1,--p3]).

input_clause(c_5415,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,++p1,--p3,--p5,++p7]).

input_clause(c_5416,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,++p1,--p3,--p5,--p6]).

input_clause(c_5417,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,++p1,--p5,--p6,++p7]).

input_clause(c_5418,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,++p1,--p5]).

input_clause(c_5419,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,++p1,++p7]).

input_clause(c_5420,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,++p1,--p6]).

input_clause(c_5421,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,++p1,--p4,--p6,++p7]).

input_clause(c_5422,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,++p1,--p4]).

input_clause(c_5423,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,++p1,--p4,--p5,++p7]).

input_clause(c_5424,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,++p1,--p4,--p5,--p6]).

input_clause(c_5425,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,++p1,--p2,--p4,--p5,--p6,++p7]).

input_clause(c_5426,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,++p1,--p2,--p4,--p5]).

input_clause(c_5427,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,++p1,--p2,--p4,++p7]).

input_clause(c_5428,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,++p1,--p2,--p4,--p6]).

input_clause(c_5429,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,++p1,--p2,--p6,++p7]).

input_clause(c_5430,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,++p1,--p2]).

input_clause(c_5431,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,++p1,--p2,--p5,++p7]).

input_clause(c_5432,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,++p1,--p2,--p5,--p6]).

input_clause(c_5433,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,++p1,--p2,--p3,--p5,--p6,++p7]).

input_clause(c_5434,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,++p1,--p2,--p3,--p5]).

input_clause(c_5435,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,++p1,--p2,--p3,++p7]).

input_clause(c_5436,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,++p1,--p2,--p3,--p6]).

input_clause(c_5437,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,++p1,--p2,--p3,--p4,--p6,++p7]).

input_clause(c_5438,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,++p1,--p2,--p3,--p4]).

input_clause(c_5439,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,++p1,--p2,--p3,--p4,--p5,++p7]).

input_clause(c_5440,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p7,++p1,--p2,--p3,--p4,--p5,--p6]).

input_clause(c_5441,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,++p1,--p2,--p3,--p4,--p5,--p6]).

input_clause(c_5442,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,++p1,--p2,--p3,--p4,--p5,--p7]).

input_clause(c_5443,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,++p1,--p2,--p3,--p4]).

input_clause(c_5444,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,++p1,--p2,--p3,--p4,--p6,--p7]).

input_clause(c_5445,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,++p1,--p2,--p3,--p6]).

input_clause(c_5446,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,++p1,--p2,--p3,--p7]).

input_clause(c_5447,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,++p1,--p2,--p3,--p5]).

input_clause(c_5448,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,++p1,--p2,--p3,--p5,--p6,--p7]).

input_clause(c_5449,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,++p1,--p2,--p5,--p6]).

input_clause(c_5450,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,++p1,--p2,--p5,--p7]).

input_clause(c_5451,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,++p1,--p2]).

input_clause(c_5452,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,++p1,--p2,--p6,--p7]).

input_clause(c_5453,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,++p1,--p2,--p4,--p6]).

input_clause(c_5454,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,++p1,--p2,--p4,--p7]).

input_clause(c_5455,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,++p1,--p2,--p4,--p5]).

input_clause(c_5456,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,++p1,--p2,--p4,--p5,--p6,--p7]).

input_clause(c_5457,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,++p1,--p4,--p5,--p6]).

input_clause(c_5458,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,++p1,--p4,--p5,--p7]).

input_clause(c_5459,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,++p1,--p4]).

input_clause(c_5460,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,++p1,--p4,--p6,--p7]).

input_clause(c_5461,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,++p1,--p6]).

input_clause(c_5462,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,++p1,--p7]).

input_clause(c_5463,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,++p1,--p5]).

input_clause(c_5464,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,++p1,--p5,--p6,--p7]).

input_clause(c_5465,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,++p1,--p3,--p5,--p6]).

input_clause(c_5466,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,++p1,--p3,--p5,--p7]).

input_clause(c_5467,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,++p1,--p3]).

input_clause(c_5468,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,++p1,--p3,--p6,--p7]).

input_clause(c_5469,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,++p1,--p3,--p4,--p6]).

input_clause(c_5470,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,++p1,--p3,--p4,--p7]).

input_clause(c_5471,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,++p1,--p3,--p4,--p5]).

input_clause(c_5472,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,++p1,--p3,--p4,--p5,--p6,--p7]).

input_clause(c_5473,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,--p3,--p4,--p5,--p6]).

input_clause(c_5474,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,--p3,--p4,--p5,--p7]).

input_clause(c_5475,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,--p3,--p4]).

input_clause(c_5476,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,--p3,--p4,--p6,--p7]).

input_clause(c_5477,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,--p3,--p6]).

input_clause(c_5478,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,--p3,--p7]).

input_clause(c_5479,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,--p3,--p5]).

input_clause(c_5480,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,--p3,--p5,--p6,--p7]).

input_clause(c_5481,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,--p5,--p6]).

input_clause(c_5482,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,--p5,--p7]).

input_clause(c_5483,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7]).

input_clause(c_5484,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,--p6,--p7]).

input_clause(c_5485,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,--p4,--p6]).

input_clause(c_5486,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,--p4,--p7]).

input_clause(c_5487,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,--p4,--p5]).

input_clause(c_5488,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,--p4,--p5,--p6,--p7]).

input_clause(c_5489,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,--p2,--p4,--p5,--p6]).

input_clause(c_5490,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,--p2,--p4,--p5,--p7]).

input_clause(c_5491,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,--p2,--p4]).

input_clause(c_5492,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,--p2,--p4,--p6,--p7]).

input_clause(c_5493,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,--p2,--p6]).

input_clause(c_5494,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,--p2,--p7]).

input_clause(c_5495,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,--p2,--p5]).

input_clause(c_5496,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,--p2,--p5,--p6,--p7]).

input_clause(c_5497,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,--p2,--p3,--p5,--p6]).

input_clause(c_5498,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,--p2,--p3,--p5,--p7]).

input_clause(c_5499,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,--p2,--p3]).

input_clause(c_5500,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,--p2,--p3,--p6,--p7]).

input_clause(c_5501,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,--p2,--p3,--p4,--p6]).

input_clause(c_5502,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,--p2,--p3,--p4,--p7]).

input_clause(c_5503,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,--p2,--p3,--p4,--p5]).

input_clause(c_5504,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p7,--p2,--p3,--p4,--p5,--p6,--p7]).

input_clause(c_5505,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,--p2,--p3,--p4,--p5]).

input_clause(c_5506,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,--p2,--p3,--p4,--p5,++p6,--p7]).

input_clause(c_5507,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,--p2,--p3,--p4,++p6]).

input_clause(c_5508,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,--p2,--p3,--p4,--p7]).

input_clause(c_5509,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,--p2,--p3]).

input_clause(c_5510,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,--p2,--p3,++p6,--p7]).

input_clause(c_5511,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,--p2,--p3,--p5,++p6]).

input_clause(c_5512,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,--p2,--p3,--p5,--p7]).

input_clause(c_5513,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,--p2,--p5]).

input_clause(c_5514,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,--p2,--p5,++p6,--p7]).

input_clause(c_5515,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,--p2,++p6]).

input_clause(c_5516,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,--p2,--p7]).

input_clause(c_5517,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,--p2,--p4]).

input_clause(c_5518,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,--p2,--p4,++p6,--p7]).

input_clause(c_5519,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,--p2,--p4,--p5,++p6]).

input_clause(c_5520,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,--p2,--p4,--p5,--p7]).

input_clause(c_5521,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,--p4,--p5]).

input_clause(c_5522,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,--p4,--p5,++p6,--p7]).

input_clause(c_5523,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,--p4,++p6]).

input_clause(c_5524,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,--p4,--p7]).

input_clause(c_5525,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7]).

input_clause(c_5526,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,++p6,--p7]).

input_clause(c_5527,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,--p5,++p6]).

input_clause(c_5528,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,--p5,--p7]).

input_clause(c_5529,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,--p3,--p5]).

input_clause(c_5530,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,--p3,--p5,++p6,--p7]).

input_clause(c_5531,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,--p3,++p6]).

input_clause(c_5532,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,--p3,--p7]).

input_clause(c_5533,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,--p3,--p4]).

input_clause(c_5534,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,--p3,--p4,++p6,--p7]).

input_clause(c_5535,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,--p3,--p4,--p5,++p6]).

input_clause(c_5536,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,--p3,--p4,--p5,--p7]).

input_clause(c_5537,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,++p1,--p3,--p4,--p5]).

input_clause(c_5538,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,++p1,--p3,--p4,--p5,++p6,--p7]).

input_clause(c_5539,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,++p1,--p3,--p4,++p6]).

input_clause(c_5540,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,++p1,--p3,--p4,--p7]).

input_clause(c_5541,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,++p1,--p3]).

input_clause(c_5542,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,++p1,--p3,++p6,--p7]).

input_clause(c_5543,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,++p1,--p3,--p5,++p6]).

input_clause(c_5544,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,++p1,--p3,--p5,--p7]).

input_clause(c_5545,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,++p1,--p5]).

input_clause(c_5546,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,++p1,--p5,++p6,--p7]).

input_clause(c_5547,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,++p1,++p6]).

input_clause(c_5548,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,++p1,--p7]).

input_clause(c_5549,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,++p1,--p4]).

input_clause(c_5550,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,++p1,--p4,++p6,--p7]).

input_clause(c_5551,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,++p1,--p4,--p5,++p6]).

input_clause(c_5552,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,++p1,--p4,--p5,--p7]).

input_clause(c_5553,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,++p1,--p2,--p4,--p5]).

input_clause(c_5554,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,++p1,--p2,--p4,--p5,++p6,--p7]).

input_clause(c_5555,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,++p1,--p2,--p4,++p6]).

input_clause(c_5556,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,++p1,--p2,--p4,--p7]).

input_clause(c_5557,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,++p1,--p2]).

input_clause(c_5558,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,++p1,--p2,++p6,--p7]).

input_clause(c_5559,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,++p1,--p2,--p5,++p6]).

input_clause(c_5560,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,++p1,--p2,--p5,--p7]).

input_clause(c_5561,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,++p1,--p2,--p3,--p5]).

input_clause(c_5562,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,++p1,--p2,--p3,--p5,++p6,--p7]).

input_clause(c_5563,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,++p1,--p2,--p3,++p6]).

input_clause(c_5564,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,++p1,--p2,--p3,--p7]).

input_clause(c_5565,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,++p1,--p2,--p3,--p4]).

input_clause(c_5566,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,++p1,--p2,--p3,--p4,++p6,--p7]).

input_clause(c_5567,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,++p1,--p2,--p3,--p4,--p5,++p6]).

input_clause(c_5568,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p7,++p1,--p2,--p3,--p4,--p5,--p7]).

input_clause(c_5569,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,++p1,--p2,--p3,--p4,--p5,++p7]).

input_clause(c_5570,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,++p1,--p2,--p3,--p4,--p5,++p6]).

input_clause(c_5571,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,++p1,--p2,--p3,--p4,++p6,++p7]).

input_clause(c_5572,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,++p1,--p2,--p3,--p4]).

input_clause(c_5573,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,++p1,--p2,--p3,++p7]).

input_clause(c_5574,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,++p1,--p2,--p3,++p6]).

input_clause(c_5575,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,++p1,--p2,--p3,--p5,++p6,++p7]).

input_clause(c_5576,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,++p1,--p2,--p3,--p5]).

input_clause(c_5577,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,++p1,--p2,--p5,++p7]).

input_clause(c_5578,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,++p1,--p2,--p5,++p6]).

input_clause(c_5579,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,++p1,--p2,++p6,++p7]).

input_clause(c_5580,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,++p1,--p2]).

input_clause(c_5581,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,++p1,--p2,--p4,++p7]).

input_clause(c_5582,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,++p1,--p2,--p4,++p6]).

input_clause(c_5583,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,++p1,--p2,--p4,--p5,++p6,++p7]).

input_clause(c_5584,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,++p1,--p2,--p4,--p5]).

input_clause(c_5585,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,++p1,--p4,--p5,++p7]).

input_clause(c_5586,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,++p1,--p4,--p5,++p6]).

input_clause(c_5587,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,++p1,--p4,++p6,++p7]).

input_clause(c_5588,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,++p1,--p4]).

input_clause(c_5589,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,++p1,++p7]).

input_clause(c_5590,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,++p1,++p6]).

input_clause(c_5591,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,++p1,--p5,++p6,++p7]).

input_clause(c_5592,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,++p1,--p5]).

input_clause(c_5593,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,++p1,--p3,--p5,++p7]).

input_clause(c_5594,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,++p1,--p3,--p5,++p6]).

input_clause(c_5595,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,++p1,--p3,++p6,++p7]).

input_clause(c_5596,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,++p1,--p3]).

input_clause(c_5597,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,++p1,--p3,--p4,++p7]).

input_clause(c_5598,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,++p1,--p3,--p4,++p6]).

input_clause(c_5599,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,++p1,--p3,--p4,--p5,++p6,++p7]).

input_clause(c_5600,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,++p1,--p3,--p4,--p5]).

input_clause(c_5601,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,--p3,--p4,--p5,++p7]).

input_clause(c_5602,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,--p3,--p4,--p5,++p6]).

input_clause(c_5603,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,--p3,--p4,++p6,++p7]).

input_clause(c_5604,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,--p3,--p4]).

input_clause(c_5605,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,--p3,++p7]).

input_clause(c_5606,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,--p3,++p6]).

input_clause(c_5607,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,--p3,--p5,++p6,++p7]).

input_clause(c_5608,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,--p3,--p5]).

input_clause(c_5609,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,--p5,++p7]).

input_clause(c_5610,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,--p5,++p6]).

input_clause(c_5611,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,++p6,++p7]).

input_clause(c_5612,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7]).

input_clause(c_5613,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,--p4,++p7]).

input_clause(c_5614,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,--p4,++p6]).

input_clause(c_5615,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,--p4,--p5,++p6,++p7]).

input_clause(c_5616,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,--p4,--p5]).

input_clause(c_5617,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,--p2,--p4,--p5,++p7]).

input_clause(c_5618,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,--p2,--p4,--p5,++p6]).

input_clause(c_5619,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,--p2,--p4,++p6,++p7]).

input_clause(c_5620,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,--p2,--p4]).

input_clause(c_5621,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,--p2,++p7]).

input_clause(c_5622,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,--p2,++p6]).

input_clause(c_5623,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,--p2,--p5,++p6,++p7]).

input_clause(c_5624,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,--p2,--p5]).

input_clause(c_5625,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,--p2,--p3,--p5,++p7]).

input_clause(c_5626,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,--p2,--p3,--p5,++p6]).

input_clause(c_5627,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,--p2,--p3,++p6,++p7]).

input_clause(c_5628,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,--p2,--p3]).

input_clause(c_5629,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,--p2,--p3,--p4,++p7]).

input_clause(c_5630,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,--p2,--p3,--p4,++p6]).

input_clause(c_5631,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,--p2,--p3,--p4,--p5,++p6,++p7]).

input_clause(c_5632,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p7,--p2,--p3,--p4,--p5]).

input_clause(c_5633,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,--p2,--p3,--p5,++p7]).

input_clause(c_5634,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,--p2,--p3,--p5,++p6]).

input_clause(c_5635,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,--p2,--p3,++p6,++p7]).

input_clause(c_5636,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,--p2,--p3]).

input_clause(c_5637,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,--p2,--p3,++p4,++p7]).

input_clause(c_5638,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,--p2,--p3,++p4,++p6]).

input_clause(c_5639,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,--p2,--p3,++p4,--p5,++p6,++p7]).

input_clause(c_5640,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,--p2,--p3,++p4,--p5]).

input_clause(c_5641,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,--p2,++p4,--p5,++p7]).

input_clause(c_5642,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,--p2,++p4,--p5,++p6]).

input_clause(c_5643,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,--p2,++p4,++p6,++p7]).

input_clause(c_5644,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,--p2,++p4]).

input_clause(c_5645,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,--p2,++p7]).

input_clause(c_5646,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,--p2,++p6]).

input_clause(c_5647,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,--p2,--p5,++p6,++p7]).

input_clause(c_5648,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,--p2,--p5]).

input_clause(c_5649,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,--p5,++p7]).

input_clause(c_5650,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,--p5,++p6]).

input_clause(c_5651,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,++p6,++p7]).

input_clause(c_5652,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7]).

input_clause(c_5653,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,++p4,++p7]).

input_clause(c_5654,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,++p4,++p6]).

input_clause(c_5655,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,++p4,--p5,++p6,++p7]).

input_clause(c_5656,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,++p4,--p5]).

input_clause(c_5657,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,--p3,++p4,--p5,++p7]).

input_clause(c_5658,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,--p3,++p4,--p5,++p6]).

input_clause(c_5659,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,--p3,++p4,++p6,++p7]).

input_clause(c_5660,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,--p3,++p4]).

input_clause(c_5661,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,--p3,++p7]).

input_clause(c_5662,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,--p3,++p6]).

input_clause(c_5663,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,--p3,--p5,++p6,++p7]).

input_clause(c_5664,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,--p3,--p5]).

input_clause(c_5665,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,++p1,--p3,--p5,++p7]).

input_clause(c_5666,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,++p1,--p3,--p5,++p6]).

input_clause(c_5667,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,++p1,--p3,++p6,++p7]).

input_clause(c_5668,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,++p1,--p3]).

input_clause(c_5669,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,++p1,--p3,++p4,++p7]).

input_clause(c_5670,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,++p1,--p3,++p4,++p6]).

input_clause(c_5671,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,++p1,--p3,++p4,--p5,++p6,++p7]).

input_clause(c_5672,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,++p1,--p3,++p4,--p5]).

input_clause(c_5673,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,++p1,++p4,--p5,++p7]).

input_clause(c_5674,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,++p1,++p4,--p5,++p6]).

input_clause(c_5675,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,++p1,++p4,++p6,++p7]).

input_clause(c_5676,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,++p1,++p4]).

input_clause(c_5677,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,++p1,++p7]).

input_clause(c_5678,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,++p1,++p6]).

input_clause(c_5679,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,++p1,--p5,++p6,++p7]).

input_clause(c_5680,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,++p1,--p5]).

input_clause(c_5681,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,++p1,--p2,--p5,++p7]).

input_clause(c_5682,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,++p1,--p2,--p5,++p6]).

input_clause(c_5683,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,++p1,--p2,++p6,++p7]).

input_clause(c_5684,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,++p1,--p2]).

input_clause(c_5685,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,++p1,--p2,++p4,++p7]).

input_clause(c_5686,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,++p1,--p2,++p4,++p6]).

input_clause(c_5687,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,++p1,--p2,++p4,--p5,++p6,++p7]).

input_clause(c_5688,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,++p1,--p2,++p4,--p5]).

input_clause(c_5689,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,++p1,--p2,--p3,++p4,--p5,++p7]).

input_clause(c_5690,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,++p1,--p2,--p3,++p4,--p5,++p6]).

input_clause(c_5691,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,++p1,--p2,--p3,++p4,++p6,++p7]).

input_clause(c_5692,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,++p1,--p2,--p3,++p4]).

input_clause(c_5693,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,++p1,--p2,--p3,++p7]).

input_clause(c_5694,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,++p1,--p2,--p3,++p6]).

input_clause(c_5695,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,++p1,--p2,--p3,--p5,++p6,++p7]).

input_clause(c_5696,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p7,++p1,--p2,--p3,--p5]).

input_clause(c_5697,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,++p1,--p2,--p3,--p5]).

input_clause(c_5698,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,++p1,--p2,--p3,--p5,++p6,--p7]).

input_clause(c_5699,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,++p1,--p2,--p3,++p6]).

input_clause(c_5700,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,++p1,--p2,--p3,--p7]).

input_clause(c_5701,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,++p1,--p2,--p3,++p4]).

input_clause(c_5702,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,++p1,--p2,--p3,++p4,++p6,--p7]).

input_clause(c_5703,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,++p1,--p2,--p3,++p4,--p5,++p6]).

input_clause(c_5704,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,++p1,--p2,--p3,++p4,--p5,--p7]).

input_clause(c_5705,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,++p1,--p2,++p4,--p5]).

input_clause(c_5706,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,++p1,--p2,++p4,--p5,++p6,--p7]).

input_clause(c_5707,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,++p1,--p2,++p4,++p6]).

input_clause(c_5708,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,++p1,--p2,++p4,--p7]).

input_clause(c_5709,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,++p1,--p2]).

input_clause(c_5710,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,++p1,--p2,++p6,--p7]).

input_clause(c_5711,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,++p1,--p2,--p5,++p6]).

input_clause(c_5712,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,++p1,--p2,--p5,--p7]).

input_clause(c_5713,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,++p1,--p5]).

input_clause(c_5714,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,++p1,--p5,++p6,--p7]).

input_clause(c_5715,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,++p1,++p6]).

input_clause(c_5716,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,++p1,--p7]).

input_clause(c_5717,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,++p1,++p4]).

input_clause(c_5718,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,++p1,++p4,++p6,--p7]).

input_clause(c_5719,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,++p1,++p4,--p5,++p6]).

input_clause(c_5720,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,++p1,++p4,--p5,--p7]).

input_clause(c_5721,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,++p1,--p3,++p4,--p5]).

input_clause(c_5722,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,++p1,--p3,++p4,--p5,++p6,--p7]).

input_clause(c_5723,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,++p1,--p3,++p4,++p6]).

input_clause(c_5724,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,++p1,--p3,++p4,--p7]).

input_clause(c_5725,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,++p1,--p3]).

input_clause(c_5726,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,++p1,--p3,++p6,--p7]).

input_clause(c_5727,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,++p1,--p3,--p5,++p6]).

input_clause(c_5728,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,++p1,--p3,--p5,--p7]).

input_clause(c_5729,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,--p3,--p5]).

input_clause(c_5730,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,--p3,--p5,++p6,--p7]).

input_clause(c_5731,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,--p3,++p6]).

input_clause(c_5732,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,--p3,--p7]).

input_clause(c_5733,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,--p3,++p4]).

input_clause(c_5734,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,--p3,++p4,++p6,--p7]).

input_clause(c_5735,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,--p3,++p4,--p5,++p6]).

input_clause(c_5736,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,--p3,++p4,--p5,--p7]).

input_clause(c_5737,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,++p4,--p5]).

input_clause(c_5738,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,++p4,--p5,++p6,--p7]).

input_clause(c_5739,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,++p4,++p6]).

input_clause(c_5740,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,++p4,--p7]).

input_clause(c_5741,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7]).

input_clause(c_5742,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,++p6,--p7]).

input_clause(c_5743,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,--p5,++p6]).

input_clause(c_5744,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,--p5,--p7]).

input_clause(c_5745,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,--p2,--p5]).

input_clause(c_5746,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,--p2,--p5,++p6,--p7]).

input_clause(c_5747,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,--p2,++p6]).

input_clause(c_5748,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,--p2,--p7]).

input_clause(c_5749,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,--p2,++p4]).

input_clause(c_5750,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,--p2,++p4,++p6,--p7]).

input_clause(c_5751,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,--p2,++p4,--p5,++p6]).

input_clause(c_5752,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,--p2,++p4,--p5,--p7]).

input_clause(c_5753,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,--p2,--p3,++p4,--p5]).

input_clause(c_5754,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,--p2,--p3,++p4,--p5,++p6,--p7]).

input_clause(c_5755,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,--p2,--p3,++p4,++p6]).

input_clause(c_5756,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,--p2,--p3,++p4,--p7]).

input_clause(c_5757,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,--p2,--p3]).

input_clause(c_5758,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,--p2,--p3,++p6,--p7]).

input_clause(c_5759,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,--p2,--p3,--p5,++p6]).

input_clause(c_5760,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p7,--p2,--p3,--p5,--p7]).

input_clause(c_5761,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,--p2,--p3,--p5,--p6]).

input_clause(c_5762,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,--p2,--p3,--p5,--p7]).

input_clause(c_5763,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,--p2,--p3]).

input_clause(c_5764,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,--p2,--p3,--p6,--p7]).

input_clause(c_5765,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,--p2,--p3,++p4,--p6]).

input_clause(c_5766,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,--p2,--p3,++p4,--p7]).

input_clause(c_5767,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,--p2,--p3,++p4,--p5]).

input_clause(c_5768,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,--p2,--p3,++p4,--p5,--p6,--p7]).

input_clause(c_5769,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,--p2,++p4,--p5,--p6]).

input_clause(c_5770,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,--p2,++p4,--p5,--p7]).

input_clause(c_5771,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,--p2,++p4]).

input_clause(c_5772,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,--p2,++p4,--p6,--p7]).

input_clause(c_5773,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,--p2,--p6]).

input_clause(c_5774,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,--p2,--p7]).

input_clause(c_5775,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,--p2,--p5]).

input_clause(c_5776,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,--p2,--p5,--p6,--p7]).

input_clause(c_5777,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,--p5,--p6]).

input_clause(c_5778,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,--p5,--p7]).

input_clause(c_5779,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7]).

input_clause(c_5780,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,--p6,--p7]).

input_clause(c_5781,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,++p4,--p6]).

input_clause(c_5782,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,++p4,--p7]).

input_clause(c_5783,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,++p4,--p5]).

input_clause(c_5784,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,++p4,--p5,--p6,--p7]).

input_clause(c_5785,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,--p3,++p4,--p5,--p6]).

input_clause(c_5786,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,--p3,++p4,--p5,--p7]).

input_clause(c_5787,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,--p3,++p4]).

input_clause(c_5788,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,--p3,++p4,--p6,--p7]).

input_clause(c_5789,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,--p3,--p6]).

input_clause(c_5790,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,--p3,--p7]).

input_clause(c_5791,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,--p3,--p5]).

input_clause(c_5792,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,--p3,--p5,--p6,--p7]).

input_clause(c_5793,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,++p1,--p3,--p5,--p6]).

input_clause(c_5794,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,++p1,--p3,--p5,--p7]).

input_clause(c_5795,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,++p1,--p3]).

input_clause(c_5796,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,++p1,--p3,--p6,--p7]).

input_clause(c_5797,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,++p1,--p3,++p4,--p6]).

input_clause(c_5798,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,++p1,--p3,++p4,--p7]).

input_clause(c_5799,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,++p1,--p3,++p4,--p5]).

input_clause(c_5800,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,++p1,--p3,++p4,--p5,--p6,--p7]).

input_clause(c_5801,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,++p1,++p4,--p5,--p6]).

input_clause(c_5802,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,++p1,++p4,--p5,--p7]).

input_clause(c_5803,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,++p1,++p4]).

input_clause(c_5804,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,++p1,++p4,--p6,--p7]).

input_clause(c_5805,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,++p1,--p6]).

input_clause(c_5806,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,++p1,--p7]).

input_clause(c_5807,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,++p1,--p5]).

input_clause(c_5808,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,++p1,--p5,--p6,--p7]).

input_clause(c_5809,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,++p1,--p2,--p5,--p6]).

input_clause(c_5810,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,++p1,--p2,--p5,--p7]).

input_clause(c_5811,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,++p1,--p2]).

input_clause(c_5812,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,++p1,--p2,--p6,--p7]).

input_clause(c_5813,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,++p1,--p2,++p4,--p6]).

input_clause(c_5814,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,++p1,--p2,++p4,--p7]).

input_clause(c_5815,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,++p1,--p2,++p4,--p5]).

input_clause(c_5816,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,++p1,--p2,++p4,--p5,--p6,--p7]).

input_clause(c_5817,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,++p1,--p2,--p3,++p4,--p5,--p6]).

input_clause(c_5818,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,++p1,--p2,--p3,++p4,--p5,--p7]).

input_clause(c_5819,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,++p1,--p2,--p3,++p4]).

input_clause(c_5820,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,++p1,--p2,--p3,++p4,--p6,--p7]).

input_clause(c_5821,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,++p1,--p2,--p3,--p6]).

input_clause(c_5822,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,++p1,--p2,--p3,--p7]).

input_clause(c_5823,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,++p1,--p2,--p3,--p5]).

input_clause(c_5824,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p7,++p1,--p2,--p3,--p5,--p6,--p7]).

input_clause(c_5825,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,++p1,--p2,--p3,--p5,--p6,++p7]).

input_clause(c_5826,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,++p1,--p2,--p3,--p5]).

input_clause(c_5827,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,++p1,--p2,--p3,++p7]).

input_clause(c_5828,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,++p1,--p2,--p3,--p6]).

input_clause(c_5829,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,++p1,--p2,--p3,++p4,--p6,++p7]).

input_clause(c_5830,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,++p1,--p2,--p3,++p4]).

input_clause(c_5831,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,++p1,--p2,--p3,++p4,--p5,++p7]).

input_clause(c_5832,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,++p1,--p2,--p3,++p4,--p5,--p6]).

input_clause(c_5833,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,++p1,--p2,++p4,--p5,--p6,++p7]).

input_clause(c_5834,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,++p1,--p2,++p4,--p5]).

input_clause(c_5835,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,++p1,--p2,++p4,++p7]).

input_clause(c_5836,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,++p1,--p2,++p4,--p6]).

input_clause(c_5837,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,++p1,--p2,--p6,++p7]).

input_clause(c_5838,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,++p1,--p2]).

input_clause(c_5839,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,++p1,--p2,--p5,++p7]).

input_clause(c_5840,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,++p1,--p2,--p5,--p6]).

input_clause(c_5841,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,++p1,--p5,--p6,++p7]).

input_clause(c_5842,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,++p1,--p5]).

input_clause(c_5843,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,++p1,++p7]).

input_clause(c_5844,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,++p1,--p6]).

input_clause(c_5845,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,++p1,++p4,--p6,++p7]).

input_clause(c_5846,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,++p1,++p4]).

input_clause(c_5847,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,++p1,++p4,--p5,++p7]).

input_clause(c_5848,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,++p1,++p4,--p5,--p6]).

input_clause(c_5849,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,++p1,--p3,++p4,--p5,--p6,++p7]).

input_clause(c_5850,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,++p1,--p3,++p4,--p5]).

input_clause(c_5851,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,++p1,--p3,++p4,++p7]).

input_clause(c_5852,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,++p1,--p3,++p4,--p6]).

input_clause(c_5853,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,++p1,--p3,--p6,++p7]).

input_clause(c_5854,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,++p1,--p3]).

input_clause(c_5855,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,++p1,--p3,--p5,++p7]).

input_clause(c_5856,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,++p1,--p3,--p5,--p6]).

input_clause(c_5857,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,--p3,--p5,--p6,++p7]).

input_clause(c_5858,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,--p3,--p5]).

input_clause(c_5859,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,--p3,++p7]).

input_clause(c_5860,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,--p3,--p6]).

input_clause(c_5861,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,--p3,++p4,--p6,++p7]).

input_clause(c_5862,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,--p3,++p4]).

input_clause(c_5863,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,--p3,++p4,--p5,++p7]).

input_clause(c_5864,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,--p3,++p4,--p5,--p6]).

input_clause(c_5865,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,++p4,--p5,--p6,++p7]).

input_clause(c_5866,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,++p4,--p5]).

input_clause(c_5867,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,++p4,++p7]).

input_clause(c_5868,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,++p4,--p6]).

input_clause(c_5869,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,--p6,++p7]).

input_clause(c_5870,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7]).

input_clause(c_5871,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,--p5,++p7]).

input_clause(c_5872,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,--p5,--p6]).

input_clause(c_5873,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,--p2,--p5,--p6,++p7]).

input_clause(c_5874,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,--p2,--p5]).

input_clause(c_5875,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,--p2,++p7]).

input_clause(c_5876,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,--p2,--p6]).

input_clause(c_5877,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,--p2,++p4,--p6,++p7]).

input_clause(c_5878,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,--p2,++p4]).

input_clause(c_5879,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,--p2,++p4,--p5,++p7]).

input_clause(c_5880,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,--p2,++p4,--p5,--p6]).

input_clause(c_5881,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,--p2,--p3,++p4,--p5,--p6,++p7]).

input_clause(c_5882,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,--p2,--p3,++p4,--p5]).

input_clause(c_5883,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,--p2,--p3,++p4,++p7]).

input_clause(c_5884,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,--p2,--p3,++p4,--p6]).

input_clause(c_5885,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,--p2,--p3,--p6,++p7]).

input_clause(c_5886,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,--p2,--p3]).

input_clause(c_5887,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,--p2,--p3,--p5,++p7]).

input_clause(c_5888,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p7,--p2,--p3,--p5,--p6]).

input_clause(c_5889,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,--p2,--p3,--p6,++p7]).

input_clause(c_5890,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,--p2,--p3]).

input_clause(c_5891,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,--p2,--p3,++p5,++p7]).

input_clause(c_5892,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,--p2,--p3,++p5,--p6]).

input_clause(c_5893,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,--p2,--p3,++p4,++p5,--p6,++p7]).

input_clause(c_5894,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,--p2,--p3,++p4,++p5]).

input_clause(c_5895,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,--p2,--p3,++p4,++p7]).

input_clause(c_5896,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,--p2,--p3,++p4,--p6]).

input_clause(c_5897,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,--p2,++p4,--p6,++p7]).

input_clause(c_5898,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,--p2,++p4]).

input_clause(c_5899,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,--p2,++p4,++p5,++p7]).

input_clause(c_5900,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,--p2,++p4,++p5,--p6]).

input_clause(c_5901,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,--p2,++p5,--p6,++p7]).

input_clause(c_5902,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,--p2,++p5]).

input_clause(c_5903,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,--p2,++p7]).

input_clause(c_5904,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,--p2,--p6]).

input_clause(c_5905,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,--p6,++p7]).

input_clause(c_5906,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7]).

input_clause(c_5907,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,++p5,++p7]).

input_clause(c_5908,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,++p5,--p6]).

input_clause(c_5909,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,++p4,++p5,--p6,++p7]).

input_clause(c_5910,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,++p4,++p5]).

input_clause(c_5911,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,++p4,++p7]).

input_clause(c_5912,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,++p4,--p6]).

input_clause(c_5913,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,--p3,++p4,--p6,++p7]).

input_clause(c_5914,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,--p3,++p4]).

input_clause(c_5915,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,--p3,++p4,++p5,++p7]).

input_clause(c_5916,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,--p3,++p4,++p5,--p6]).

input_clause(c_5917,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,--p3,++p5,--p6,++p7]).

input_clause(c_5918,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,--p3,++p5]).

input_clause(c_5919,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,--p3,++p7]).

input_clause(c_5920,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,--p3,--p6]).

input_clause(c_5921,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,++p1,--p3,--p6,++p7]).

input_clause(c_5922,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,++p1,--p3]).

input_clause(c_5923,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,++p1,--p3,++p5,++p7]).

input_clause(c_5924,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,++p1,--p3,++p5,--p6]).

input_clause(c_5925,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,++p1,--p3,++p4,++p5,--p6,++p7]).

input_clause(c_5926,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,++p1,--p3,++p4,++p5]).

input_clause(c_5927,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,++p1,--p3,++p4,++p7]).

input_clause(c_5928,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,++p1,--p3,++p4,--p6]).

input_clause(c_5929,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,++p1,++p4,--p6,++p7]).

input_clause(c_5930,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,++p1,++p4]).

input_clause(c_5931,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,++p1,++p4,++p5,++p7]).

input_clause(c_5932,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,++p1,++p4,++p5,--p6]).

input_clause(c_5933,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,++p1,++p5,--p6,++p7]).

input_clause(c_5934,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,++p1,++p5]).

input_clause(c_5935,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,++p1,++p7]).

input_clause(c_5936,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,++p1,--p6]).

input_clause(c_5937,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,++p1,--p2,--p6,++p7]).

input_clause(c_5938,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,++p1,--p2]).

input_clause(c_5939,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,++p1,--p2,++p5,++p7]).

input_clause(c_5940,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,++p1,--p2,++p5,--p6]).

input_clause(c_5941,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,++p1,--p2,++p4,++p5,--p6,++p7]).

input_clause(c_5942,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,++p1,--p2,++p4,++p5]).

input_clause(c_5943,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,++p1,--p2,++p4,++p7]).

input_clause(c_5944,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,++p1,--p2,++p4,--p6]).

input_clause(c_5945,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,++p1,--p2,--p3,++p4,--p6,++p7]).

input_clause(c_5946,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,++p1,--p2,--p3,++p4]).

input_clause(c_5947,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,++p1,--p2,--p3,++p4,++p5,++p7]).

input_clause(c_5948,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,++p1,--p2,--p3,++p4,++p5,--p6]).

input_clause(c_5949,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,++p1,--p2,--p3,++p5,--p6,++p7]).

input_clause(c_5950,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,++p1,--p2,--p3,++p5]).

input_clause(c_5951,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,++p1,--p2,--p3,++p7]).

input_clause(c_5952,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p7,++p1,--p2,--p3,--p6]).

input_clause(c_5953,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,++p1,--p2,--p3,--p6]).

input_clause(c_5954,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,++p1,--p2,--p3,--p7]).

input_clause(c_5955,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,++p1,--p2,--p3,++p5]).

input_clause(c_5956,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,++p1,--p2,--p3,++p5,--p6,--p7]).

input_clause(c_5957,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,++p1,--p2,--p3,++p4,++p5,--p6]).

input_clause(c_5958,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,++p1,--p2,--p3,++p4,++p5,--p7]).

input_clause(c_5959,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,++p1,--p2,--p3,++p4]).

input_clause(c_5960,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,++p1,--p2,--p3,++p4,--p6,--p7]).

input_clause(c_5961,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,++p1,--p2,++p4,--p6]).

input_clause(c_5962,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,++p1,--p2,++p4,--p7]).

input_clause(c_5963,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,++p1,--p2,++p4,++p5]).

input_clause(c_5964,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,++p1,--p2,++p4,++p5,--p6,--p7]).

input_clause(c_5965,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,++p1,--p2,++p5,--p6]).

input_clause(c_5966,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,++p1,--p2,++p5,--p7]).

input_clause(c_5967,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,++p1,--p2]).

input_clause(c_5968,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,++p1,--p2,--p6,--p7]).

input_clause(c_5969,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,++p1,--p6]).

input_clause(c_5970,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,++p1,--p7]).

input_clause(c_5971,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,++p1,++p5]).

input_clause(c_5972,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,++p1,++p5,--p6,--p7]).

input_clause(c_5973,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,++p1,++p4,++p5,--p6]).

input_clause(c_5974,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,++p1,++p4,++p5,--p7]).

input_clause(c_5975,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,++p1,++p4]).

input_clause(c_5976,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,++p1,++p4,--p6,--p7]).

input_clause(c_5977,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,++p1,--p3,++p4,--p6]).

input_clause(c_5978,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,++p1,--p3,++p4,--p7]).

input_clause(c_5979,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,++p1,--p3,++p4,++p5]).

input_clause(c_5980,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,++p1,--p3,++p4,++p5,--p6,--p7]).

input_clause(c_5981,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,++p1,--p3,++p5,--p6]).

input_clause(c_5982,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,++p1,--p3,++p5,--p7]).

input_clause(c_5983,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,++p1,--p3]).

input_clause(c_5984,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,++p1,--p3,--p6,--p7]).

input_clause(c_5985,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,--p3,--p6]).

input_clause(c_5986,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,--p3,--p7]).

input_clause(c_5987,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,--p3,++p5]).

input_clause(c_5988,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,--p3,++p5,--p6,--p7]).

input_clause(c_5989,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,--p3,++p4,++p5,--p6]).

input_clause(c_5990,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,--p3,++p4,++p5,--p7]).

input_clause(c_5991,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,--p3,++p4]).

input_clause(c_5992,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,--p3,++p4,--p6,--p7]).

input_clause(c_5993,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,++p4,--p6]).

input_clause(c_5994,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,++p4,--p7]).

input_clause(c_5995,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,++p4,++p5]).

input_clause(c_5996,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,++p4,++p5,--p6,--p7]).

input_clause(c_5997,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,++p5,--p6]).

input_clause(c_5998,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,++p5,--p7]).

input_clause(c_5999,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7]).

input_clause(c_6000,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,--p6,--p7]).

input_clause(c_6001,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,--p2,--p6]).

input_clause(c_6002,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,--p2,--p7]).

input_clause(c_6003,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,--p2,++p5]).

input_clause(c_6004,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,--p2,++p5,--p6,--p7]).

input_clause(c_6005,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,--p2,++p4,++p5,--p6]).

input_clause(c_6006,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,--p2,++p4,++p5,--p7]).

input_clause(c_6007,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,--p2,++p4]).

input_clause(c_6008,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,--p2,++p4,--p6,--p7]).

input_clause(c_6009,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,--p2,--p3,++p4,--p6]).

input_clause(c_6010,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,--p2,--p3,++p4,--p7]).

input_clause(c_6011,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,--p2,--p3,++p4,++p5]).

input_clause(c_6012,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,--p2,--p3,++p4,++p5,--p6,--p7]).

input_clause(c_6013,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,--p2,--p3,++p5,--p6]).

input_clause(c_6014,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,--p2,--p3,++p5,--p7]).

input_clause(c_6015,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,--p2,--p3]).

input_clause(c_6016,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p7,--p2,--p3,--p6,--p7]).

input_clause(c_6017,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,--p2,--p3]).

input_clause(c_6018,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,--p2,--p3,++p6,--p7]).

input_clause(c_6019,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,--p2,--p3,++p5,++p6]).

input_clause(c_6020,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,--p2,--p3,++p5,--p7]).

input_clause(c_6021,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,--p2,--p3,++p4,++p5]).

input_clause(c_6022,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,--p2,--p3,++p4,++p5,++p6,--p7]).

input_clause(c_6023,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,--p2,--p3,++p4,++p6]).

input_clause(c_6024,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,--p2,--p3,++p4,--p7]).

input_clause(c_6025,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,--p2,++p4]).

input_clause(c_6026,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,--p2,++p4,++p6,--p7]).

input_clause(c_6027,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,--p2,++p4,++p5,++p6]).

input_clause(c_6028,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,--p2,++p4,++p5,--p7]).

input_clause(c_6029,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,--p2,++p5]).

input_clause(c_6030,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,--p2,++p5,++p6,--p7]).

input_clause(c_6031,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,--p2,++p6]).

input_clause(c_6032,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,--p2,--p7]).

input_clause(c_6033,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7]).

input_clause(c_6034,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,++p6,--p7]).

input_clause(c_6035,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,++p5,++p6]).

input_clause(c_6036,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,++p5,--p7]).

input_clause(c_6037,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,++p4,++p5]).

input_clause(c_6038,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,++p4,++p5,++p6,--p7]).

input_clause(c_6039,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,++p4,++p6]).

input_clause(c_6040,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,++p4,--p7]).

input_clause(c_6041,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,--p3,++p4]).

input_clause(c_6042,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,--p3,++p4,++p6,--p7]).

input_clause(c_6043,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,--p3,++p4,++p5,++p6]).

input_clause(c_6044,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,--p3,++p4,++p5,--p7]).

input_clause(c_6045,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,--p3,++p5]).

input_clause(c_6046,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,--p3,++p5,++p6,--p7]).

input_clause(c_6047,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,--p3,++p6]).

input_clause(c_6048,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,--p3,--p7]).

input_clause(c_6049,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,++p1,--p3]).

input_clause(c_6050,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,++p1,--p3,++p6,--p7]).

input_clause(c_6051,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,++p1,--p3,++p5,++p6]).

input_clause(c_6052,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,++p1,--p3,++p5,--p7]).

input_clause(c_6053,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,++p1,--p3,++p4,++p5]).

input_clause(c_6054,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,++p1,--p3,++p4,++p5,++p6,--p7]).

input_clause(c_6055,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,++p1,--p3,++p4,++p6]).

input_clause(c_6056,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,++p1,--p3,++p4,--p7]).

input_clause(c_6057,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,++p1,++p4]).

input_clause(c_6058,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,++p1,++p4,++p6,--p7]).

input_clause(c_6059,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,++p1,++p4,++p5,++p6]).

input_clause(c_6060,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,++p1,++p4,++p5,--p7]).

input_clause(c_6061,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,++p1,++p5]).

input_clause(c_6062,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,++p1,++p5,++p6,--p7]).

input_clause(c_6063,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,++p1,++p6]).

input_clause(c_6064,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,++p1,--p7]).

input_clause(c_6065,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,++p1,--p2]).

input_clause(c_6066,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,++p1,--p2,++p6,--p7]).

input_clause(c_6067,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,++p1,--p2,++p5,++p6]).

input_clause(c_6068,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,++p1,--p2,++p5,--p7]).

input_clause(c_6069,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,++p1,--p2,++p4,++p5]).

input_clause(c_6070,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,++p1,--p2,++p4,++p5,++p6,--p7]).

input_clause(c_6071,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,++p1,--p2,++p4,++p6]).

input_clause(c_6072,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,++p1,--p2,++p4,--p7]).

input_clause(c_6073,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,++p1,--p2,--p3,++p4]).

input_clause(c_6074,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,++p1,--p2,--p3,++p4,++p6,--p7]).

input_clause(c_6075,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,++p1,--p2,--p3,++p4,++p5,++p6]).

input_clause(c_6076,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,++p1,--p2,--p3,++p4,++p5,--p7]).

input_clause(c_6077,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,++p1,--p2,--p3,++p5]).

input_clause(c_6078,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,++p1,--p2,--p3,++p5,++p6,--p7]).

input_clause(c_6079,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,++p1,--p2,--p3,++p6]).

input_clause(c_6080,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p7,++p1,--p2,--p3,--p7]).

input_clause(c_6081,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,++p1,--p2,--p3,++p7]).

input_clause(c_6082,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,++p1,--p2,--p3,++p6]).

input_clause(c_6083,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,++p1,--p2,--p3,++p5,++p6,++p7]).

input_clause(c_6084,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,++p1,--p2,--p3,++p5]).

input_clause(c_6085,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,++p1,--p2,--p3,++p4,++p5,++p7]).

input_clause(c_6086,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,++p1,--p2,--p3,++p4,++p5,++p6]).

input_clause(c_6087,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,++p1,--p2,--p3,++p4,++p6,++p7]).

input_clause(c_6088,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,++p1,--p2,--p3,++p4]).

input_clause(c_6089,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,++p1,--p2,++p4,++p7]).

input_clause(c_6090,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,++p1,--p2,++p4,++p6]).

input_clause(c_6091,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,++p1,--p2,++p4,++p5,++p6,++p7]).

input_clause(c_6092,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,++p1,--p2,++p4,++p5]).

input_clause(c_6093,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,++p1,--p2,++p5,++p7]).

input_clause(c_6094,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,++p1,--p2,++p5,++p6]).

input_clause(c_6095,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,++p1,--p2,++p6,++p7]).

input_clause(c_6096,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,++p1,--p2]).

input_clause(c_6097,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,++p1,++p7]).

input_clause(c_6098,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,++p1,++p6]).

input_clause(c_6099,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,++p1,++p5,++p6,++p7]).

input_clause(c_6100,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,++p1,++p5]).

input_clause(c_6101,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,++p1,++p4,++p5,++p7]).

input_clause(c_6102,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,++p1,++p4,++p5,++p6]).

input_clause(c_6103,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,++p1,++p4,++p6,++p7]).

input_clause(c_6104,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,++p1,++p4]).

input_clause(c_6105,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,++p1,--p3,++p4,++p7]).

input_clause(c_6106,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,++p1,--p3,++p4,++p6]).

input_clause(c_6107,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,++p1,--p3,++p4,++p5,++p6,++p7]).

input_clause(c_6108,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,++p1,--p3,++p4,++p5]).

input_clause(c_6109,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,++p1,--p3,++p5,++p7]).

input_clause(c_6110,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,++p1,--p3,++p5,++p6]).

input_clause(c_6111,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,++p1,--p3,++p6,++p7]).

input_clause(c_6112,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,++p1,--p3]).

input_clause(c_6113,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,--p3,++p7]).

input_clause(c_6114,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,--p3,++p6]).

input_clause(c_6115,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,--p3,++p5,++p6,++p7]).

input_clause(c_6116,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,--p3,++p5]).

input_clause(c_6117,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,--p3,++p4,++p5,++p7]).

input_clause(c_6118,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,--p3,++p4,++p5,++p6]).

input_clause(c_6119,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,--p3,++p4,++p6,++p7]).

input_clause(c_6120,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,--p3,++p4]).

input_clause(c_6121,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,++p4,++p7]).

input_clause(c_6122,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,++p4,++p6]).

input_clause(c_6123,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,++p4,++p5,++p6,++p7]).

input_clause(c_6124,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,++p4,++p5]).

input_clause(c_6125,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,++p5,++p7]).

input_clause(c_6126,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,++p5,++p6]).

input_clause(c_6127,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,++p6,++p7]).

input_clause(c_6128,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7]).

input_clause(c_6129,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,--p2,++p7]).

input_clause(c_6130,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,--p2,++p6]).

input_clause(c_6131,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,--p2,++p5,++p6,++p7]).

input_clause(c_6132,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,--p2,++p5]).

input_clause(c_6133,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,--p2,++p4,++p5,++p7]).

input_clause(c_6134,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,--p2,++p4,++p5,++p6]).

input_clause(c_6135,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,--p2,++p4,++p6,++p7]).

input_clause(c_6136,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,--p2,++p4]).

input_clause(c_6137,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,--p2,--p3,++p4,++p7]).

input_clause(c_6138,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,--p2,--p3,++p4,++p6]).

input_clause(c_6139,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,--p2,--p3,++p4,++p5,++p6,++p7]).

input_clause(c_6140,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,--p2,--p3,++p4,++p5]).

input_clause(c_6141,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,--p2,--p3,++p5,++p7]).

input_clause(c_6142,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,--p2,--p3,++p5,++p6]).

input_clause(c_6143,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,--p2,--p3,++p6,++p7]).

input_clause(c_6144,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p7,--p2,--p3]).

input_clause(c_6145,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,--p3,++p7]).

input_clause(c_6146,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,--p3,++p6]).

input_clause(c_6147,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,--p3,++p5,++p6,++p7]).

input_clause(c_6148,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,--p3,++p5]).

input_clause(c_6149,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,--p3,++p4,++p5,++p7]).

input_clause(c_6150,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,--p3,++p4,++p5,++p6]).

input_clause(c_6151,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,--p3,++p4,++p6,++p7]).

input_clause(c_6152,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,--p3,++p4]).

input_clause(c_6153,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,++p4,++p7]).

input_clause(c_6154,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,++p4,++p6]).

input_clause(c_6155,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,++p4,++p5,++p6,++p7]).

input_clause(c_6156,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,++p4,++p5]).

input_clause(c_6157,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,++p5,++p7]).

input_clause(c_6158,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,++p5,++p6]).

input_clause(c_6159,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,++p6,++p7]).

input_clause(c_6160,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7]).

input_clause(c_6161,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,++p2,++p7]).

input_clause(c_6162,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,++p2,++p6]).

input_clause(c_6163,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,++p2,++p5,++p6,++p7]).

input_clause(c_6164,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,++p2,++p5]).

input_clause(c_6165,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,++p2,++p4,++p5,++p7]).

input_clause(c_6166,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,++p2,++p4,++p5,++p6]).

input_clause(c_6167,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,++p2,++p4,++p6,++p7]).

input_clause(c_6168,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,++p2,++p4]).

input_clause(c_6169,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,++p2,--p3,++p4,++p7]).

input_clause(c_6170,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,++p2,--p3,++p4,++p6]).

input_clause(c_6171,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,++p2,--p3,++p4,++p5,++p6,++p7]).

input_clause(c_6172,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,++p2,--p3,++p4,++p5]).

input_clause(c_6173,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,++p2,--p3,++p5,++p7]).

input_clause(c_6174,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,++p2,--p3,++p5,++p6]).

input_clause(c_6175,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,++p2,--p3,++p6,++p7]).

input_clause(c_6176,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,++p2,--p3]).

input_clause(c_6177,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,++p1,++p2,--p3,++p7]).

input_clause(c_6178,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,++p1,++p2,--p3,++p6]).

input_clause(c_6179,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,++p1,++p2,--p3,++p5,++p6,++p7]).

input_clause(c_6180,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,++p1,++p2,--p3,++p5]).

input_clause(c_6181,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,++p1,++p2,--p3,++p4,++p5,++p7]).

input_clause(c_6182,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,++p1,++p2,--p3,++p4,++p5,++p6]).

input_clause(c_6183,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,++p1,++p2,--p3,++p4,++p6,++p7]).

input_clause(c_6184,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,++p1,++p2,--p3,++p4]).

input_clause(c_6185,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,++p1,++p2,++p4,++p7]).

input_clause(c_6186,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,++p1,++p2,++p4,++p6]).

input_clause(c_6187,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,++p1,++p2,++p4,++p5,++p6,++p7]).

input_clause(c_6188,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,++p1,++p2,++p4,++p5]).

input_clause(c_6189,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,++p1,++p2,++p5,++p7]).

input_clause(c_6190,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,++p1,++p2,++p5,++p6]).

input_clause(c_6191,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,++p1,++p2,++p6,++p7]).

input_clause(c_6192,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,++p1,++p2]).

input_clause(c_6193,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,++p1,++p7]).

input_clause(c_6194,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,++p1,++p6]).

input_clause(c_6195,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,++p1,++p5,++p6,++p7]).

input_clause(c_6196,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,++p1,++p5]).

input_clause(c_6197,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,++p1,++p4,++p5,++p7]).

input_clause(c_6198,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,++p1,++p4,++p5,++p6]).

input_clause(c_6199,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,++p1,++p4,++p6,++p7]).

input_clause(c_6200,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,++p1,++p4]).

input_clause(c_6201,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,++p1,--p3,++p4,++p7]).

input_clause(c_6202,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,++p1,--p3,++p4,++p6]).

input_clause(c_6203,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,++p1,--p3,++p4,++p5,++p6,++p7]).

input_clause(c_6204,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,++p1,--p3,++p4,++p5]).

input_clause(c_6205,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,++p1,--p3,++p5,++p7]).

input_clause(c_6206,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,++p1,--p3,++p5,++p6]).

input_clause(c_6207,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,++p1,--p3,++p6,++p7]).

input_clause(c_6208,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p7,++p1,--p3]).

input_clause(c_6209,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,++p1,--p3]).

input_clause(c_6210,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,++p1,--p3,++p6,--p7]).

input_clause(c_6211,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,++p1,--p3,++p5,++p6]).

input_clause(c_6212,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,++p1,--p3,++p5,--p7]).

input_clause(c_6213,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,++p1,--p3,++p4,++p5]).

input_clause(c_6214,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,++p1,--p3,++p4,++p5,++p6,--p7]).

input_clause(c_6215,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,++p1,--p3,++p4,++p6]).

input_clause(c_6216,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,++p1,--p3,++p4,--p7]).

input_clause(c_6217,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,++p1,++p4]).

input_clause(c_6218,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,++p1,++p4,++p6,--p7]).

input_clause(c_6219,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,++p1,++p4,++p5,++p6]).

input_clause(c_6220,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,++p1,++p4,++p5,--p7]).

input_clause(c_6221,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,++p1,++p5]).

input_clause(c_6222,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,++p1,++p5,++p6,--p7]).

input_clause(c_6223,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,++p1,++p6]).

input_clause(c_6224,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,++p1,--p7]).

input_clause(c_6225,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,++p1,++p2]).

input_clause(c_6226,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,++p1,++p2,++p6,--p7]).

input_clause(c_6227,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,++p1,++p2,++p5,++p6]).

input_clause(c_6228,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,++p1,++p2,++p5,--p7]).

input_clause(c_6229,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,++p1,++p2,++p4,++p5]).

input_clause(c_6230,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,++p1,++p2,++p4,++p5,++p6,--p7]).

input_clause(c_6231,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,++p1,++p2,++p4,++p6]).

input_clause(c_6232,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,++p1,++p2,++p4,--p7]).

input_clause(c_6233,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,++p1,++p2,--p3,++p4]).

input_clause(c_6234,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,++p1,++p2,--p3,++p4,++p6,--p7]).

input_clause(c_6235,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,++p1,++p2,--p3,++p4,++p5,++p6]).

input_clause(c_6236,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,++p1,++p2,--p3,++p4,++p5,--p7]).

input_clause(c_6237,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,++p1,++p2,--p3,++p5]).

input_clause(c_6238,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,++p1,++p2,--p3,++p5,++p6,--p7]).

input_clause(c_6239,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,++p1,++p2,--p3,++p6]).

input_clause(c_6240,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,++p1,++p2,--p3,--p7]).

input_clause(c_6241,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,++p2,--p3]).

input_clause(c_6242,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,++p2,--p3,++p6,--p7]).

input_clause(c_6243,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,++p2,--p3,++p5,++p6]).

input_clause(c_6244,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,++p2,--p3,++p5,--p7]).

input_clause(c_6245,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,++p2,--p3,++p4,++p5]).

input_clause(c_6246,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,++p2,--p3,++p4,++p5,++p6,--p7]).

input_clause(c_6247,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,++p2,--p3,++p4,++p6]).

input_clause(c_6248,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,++p2,--p3,++p4,--p7]).

input_clause(c_6249,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,++p2,++p4]).

input_clause(c_6250,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,++p2,++p4,++p6,--p7]).

input_clause(c_6251,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,++p2,++p4,++p5,++p6]).

input_clause(c_6252,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,++p2,++p4,++p5,--p7]).

input_clause(c_6253,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,++p2,++p5]).

input_clause(c_6254,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,++p2,++p5,++p6,--p7]).

input_clause(c_6255,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,++p2,++p6]).

input_clause(c_6256,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,++p2,--p7]).

input_clause(c_6257,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7]).

input_clause(c_6258,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,++p6,--p7]).

input_clause(c_6259,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,++p5,++p6]).

input_clause(c_6260,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,++p5,--p7]).

input_clause(c_6261,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,++p4,++p5]).

input_clause(c_6262,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,++p4,++p5,++p6,--p7]).

input_clause(c_6263,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,++p4,++p6]).

input_clause(c_6264,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,++p4,--p7]).

input_clause(c_6265,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,--p3,++p4]).

input_clause(c_6266,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,--p3,++p4,++p6,--p7]).

input_clause(c_6267,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,--p3,++p4,++p5,++p6]).

input_clause(c_6268,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,--p3,++p4,++p5,--p7]).

input_clause(c_6269,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,--p3,++p5]).

input_clause(c_6270,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,--p3,++p5,++p6,--p7]).

input_clause(c_6271,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,--p3,++p6]).

input_clause(c_6272,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p7,--p3,--p7]).

input_clause(c_6273,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,--p3,--p6]).

input_clause(c_6274,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,--p3,--p7]).

input_clause(c_6275,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,--p3,++p5]).

input_clause(c_6276,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,--p3,++p5,--p6,--p7]).

input_clause(c_6277,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,--p3,++p4,++p5,--p6]).

input_clause(c_6278,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,--p3,++p4,++p5,--p7]).

input_clause(c_6279,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,--p3,++p4]).

input_clause(c_6280,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,--p3,++p4,--p6,--p7]).

input_clause(c_6281,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,++p4,--p6]).

input_clause(c_6282,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,++p4,--p7]).

input_clause(c_6283,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,++p4,++p5]).

input_clause(c_6284,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,++p4,++p5,--p6,--p7]).

input_clause(c_6285,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,++p5,--p6]).

input_clause(c_6286,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,++p5,--p7]).

input_clause(c_6287,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7]).

input_clause(c_6288,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,--p6,--p7]).

input_clause(c_6289,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,++p2,--p6]).

input_clause(c_6290,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,++p2,--p7]).

input_clause(c_6291,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,++p2,++p5]).

input_clause(c_6292,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,++p2,++p5,--p6,--p7]).

input_clause(c_6293,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,++p2,++p4,++p5,--p6]).

input_clause(c_6294,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,++p2,++p4,++p5,--p7]).

input_clause(c_6295,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,++p2,++p4]).

input_clause(c_6296,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,++p2,++p4,--p6,--p7]).

input_clause(c_6297,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,++p2,--p3,++p4,--p6]).

input_clause(c_6298,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,++p2,--p3,++p4,--p7]).

input_clause(c_6299,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,++p2,--p3,++p4,++p5]).

input_clause(c_6300,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,++p2,--p3,++p4,++p5,--p6,--p7]).

input_clause(c_6301,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,++p2,--p3,++p5,--p6]).

input_clause(c_6302,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,++p2,--p3,++p5,--p7]).

input_clause(c_6303,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,++p2,--p3]).

input_clause(c_6304,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,++p2,--p3,--p6,--p7]).

input_clause(c_6305,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,++p1,++p2,--p3,--p6]).

input_clause(c_6306,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,++p1,++p2,--p3,--p7]).

input_clause(c_6307,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,++p1,++p2,--p3,++p5]).

input_clause(c_6308,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,++p1,++p2,--p3,++p5,--p6,--p7]).

input_clause(c_6309,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,++p1,++p2,--p3,++p4,++p5,--p6]).

input_clause(c_6310,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,++p1,++p2,--p3,++p4,++p5,--p7]).

input_clause(c_6311,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,++p1,++p2,--p3,++p4]).

input_clause(c_6312,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,++p1,++p2,--p3,++p4,--p6,--p7]).

input_clause(c_6313,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,++p1,++p2,++p4,--p6]).

input_clause(c_6314,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,++p1,++p2,++p4,--p7]).

input_clause(c_6315,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,++p1,++p2,++p4,++p5]).

input_clause(c_6316,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,++p1,++p2,++p4,++p5,--p6,--p7]).

input_clause(c_6317,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,++p1,++p2,++p5,--p6]).

input_clause(c_6318,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,++p1,++p2,++p5,--p7]).

input_clause(c_6319,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,++p1,++p2]).

input_clause(c_6320,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,++p1,++p2,--p6,--p7]).

input_clause(c_6321,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,++p1,--p6]).

input_clause(c_6322,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,++p1,--p7]).

input_clause(c_6323,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,++p1,++p5]).

input_clause(c_6324,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,++p1,++p5,--p6,--p7]).

input_clause(c_6325,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,++p1,++p4,++p5,--p6]).

input_clause(c_6326,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,++p1,++p4,++p5,--p7]).

input_clause(c_6327,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,++p1,++p4]).

input_clause(c_6328,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,++p1,++p4,--p6,--p7]).

input_clause(c_6329,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,++p1,--p3,++p4,--p6]).

input_clause(c_6330,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,++p1,--p3,++p4,--p7]).

input_clause(c_6331,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,++p1,--p3,++p4,++p5]).

input_clause(c_6332,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,++p1,--p3,++p4,++p5,--p6,--p7]).

input_clause(c_6333,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,++p1,--p3,++p5,--p6]).

input_clause(c_6334,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,++p1,--p3,++p5,--p7]).

input_clause(c_6335,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,++p1,--p3]).

input_clause(c_6336,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p7,++p1,--p3,--p6,--p7]).

input_clause(c_6337,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,++p1,--p3,--p6,++p7]).

input_clause(c_6338,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,++p1,--p3]).

input_clause(c_6339,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,++p1,--p3,++p5,++p7]).

input_clause(c_6340,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,++p1,--p3,++p5,--p6]).

input_clause(c_6341,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,++p1,--p3,++p4,++p5,--p6,++p7]).

input_clause(c_6342,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,++p1,--p3,++p4,++p5]).

input_clause(c_6343,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,++p1,--p3,++p4,++p7]).

input_clause(c_6344,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,++p1,--p3,++p4,--p6]).

input_clause(c_6345,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,++p1,++p4,--p6,++p7]).

input_clause(c_6346,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,++p1,++p4]).

input_clause(c_6347,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,++p1,++p4,++p5,++p7]).

input_clause(c_6348,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,++p1,++p4,++p5,--p6]).

input_clause(c_6349,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,++p1,++p5,--p6,++p7]).

input_clause(c_6350,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,++p1,++p5]).

input_clause(c_6351,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,++p1,++p7]).

input_clause(c_6352,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,++p1,--p6]).

input_clause(c_6353,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,++p1,++p2,--p6,++p7]).

input_clause(c_6354,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,++p1,++p2]).

input_clause(c_6355,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,++p1,++p2,++p5,++p7]).

input_clause(c_6356,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,++p1,++p2,++p5,--p6]).

input_clause(c_6357,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,++p1,++p2,++p4,++p5,--p6,++p7]).

input_clause(c_6358,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,++p1,++p2,++p4,++p5]).

input_clause(c_6359,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,++p1,++p2,++p4,++p7]).

input_clause(c_6360,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,++p1,++p2,++p4,--p6]).

input_clause(c_6361,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,++p1,++p2,--p3,++p4,--p6,++p7]).

input_clause(c_6362,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,++p1,++p2,--p3,++p4]).

input_clause(c_6363,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,++p1,++p2,--p3,++p4,++p5,++p7]).

input_clause(c_6364,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,++p1,++p2,--p3,++p4,++p5,--p6]).

input_clause(c_6365,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,++p1,++p2,--p3,++p5,--p6,++p7]).

input_clause(c_6366,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,++p1,++p2,--p3,++p5]).

input_clause(c_6367,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,++p1,++p2,--p3,++p7]).

input_clause(c_6368,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,++p1,++p2,--p3,--p6]).

input_clause(c_6369,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,++p2,--p3,--p6,++p7]).

input_clause(c_6370,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,++p2,--p3]).

input_clause(c_6371,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,++p2,--p3,++p5,++p7]).

input_clause(c_6372,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,++p2,--p3,++p5,--p6]).

input_clause(c_6373,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,++p2,--p3,++p4,++p5,--p6,++p7]).

input_clause(c_6374,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,++p2,--p3,++p4,++p5]).

input_clause(c_6375,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,++p2,--p3,++p4,++p7]).

input_clause(c_6376,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,++p2,--p3,++p4,--p6]).

input_clause(c_6377,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,++p2,++p4,--p6,++p7]).

input_clause(c_6378,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,++p2,++p4]).

input_clause(c_6379,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,++p2,++p4,++p5,++p7]).

input_clause(c_6380,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,++p2,++p4,++p5,--p6]).

input_clause(c_6381,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,++p2,++p5,--p6,++p7]).

input_clause(c_6382,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,++p2,++p5]).

input_clause(c_6383,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,++p2,++p7]).

input_clause(c_6384,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,++p2,--p6]).

input_clause(c_6385,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,--p6,++p7]).

input_clause(c_6386,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7]).

input_clause(c_6387,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,++p5,++p7]).

input_clause(c_6388,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,++p5,--p6]).

input_clause(c_6389,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,++p4,++p5,--p6,++p7]).

input_clause(c_6390,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,++p4,++p5]).

input_clause(c_6391,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,++p4,++p7]).

input_clause(c_6392,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,++p4,--p6]).

input_clause(c_6393,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,--p3,++p4,--p6,++p7]).

input_clause(c_6394,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,--p3,++p4]).

input_clause(c_6395,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,--p3,++p4,++p5,++p7]).

input_clause(c_6396,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,--p3,++p4,++p5,--p6]).

input_clause(c_6397,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,--p3,++p5,--p6,++p7]).

input_clause(c_6398,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,--p3,++p5]).

input_clause(c_6399,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,--p3,++p7]).

input_clause(c_6400,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p7,--p3,--p6]).

input_clause(c_6401,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,--p3,--p5,--p6,++p7]).

input_clause(c_6402,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,--p3,--p5]).

input_clause(c_6403,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,--p3,++p7]).

input_clause(c_6404,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,--p3,--p6]).

input_clause(c_6405,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,--p3,++p4,--p6,++p7]).

input_clause(c_6406,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,--p3,++p4]).

input_clause(c_6407,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,--p3,++p4,--p5,++p7]).

input_clause(c_6408,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,--p3,++p4,--p5,--p6]).

input_clause(c_6409,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,++p4,--p5,--p6,++p7]).

input_clause(c_6410,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,++p4,--p5]).

input_clause(c_6411,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,++p4,++p7]).

input_clause(c_6412,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,++p4,--p6]).

input_clause(c_6413,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,--p6,++p7]).

input_clause(c_6414,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7]).

input_clause(c_6415,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,--p5,++p7]).

input_clause(c_6416,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,--p5,--p6]).

input_clause(c_6417,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,++p2,--p5,--p6,++p7]).

input_clause(c_6418,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,++p2,--p5]).

input_clause(c_6419,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,++p2,++p7]).

input_clause(c_6420,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,++p2,--p6]).

input_clause(c_6421,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,++p2,++p4,--p6,++p7]).

input_clause(c_6422,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,++p2,++p4]).

input_clause(c_6423,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,++p2,++p4,--p5,++p7]).

input_clause(c_6424,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,++p2,++p4,--p5,--p6]).

input_clause(c_6425,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,++p2,--p3,++p4,--p5,--p6,++p7]).

input_clause(c_6426,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,++p2,--p3,++p4,--p5]).

input_clause(c_6427,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,++p2,--p3,++p4,++p7]).

input_clause(c_6428,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,++p2,--p3,++p4,--p6]).

input_clause(c_6429,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,++p2,--p3,--p6,++p7]).

input_clause(c_6430,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,++p2,--p3]).

input_clause(c_6431,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,++p2,--p3,--p5,++p7]).

input_clause(c_6432,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,++p2,--p3,--p5,--p6]).

input_clause(c_6433,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,++p1,++p2,--p3,--p5,--p6,++p7]).

input_clause(c_6434,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,++p1,++p2,--p3,--p5]).

input_clause(c_6435,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,++p1,++p2,--p3,++p7]).

input_clause(c_6436,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,++p1,++p2,--p3,--p6]).

input_clause(c_6437,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,++p1,++p2,--p3,++p4,--p6,++p7]).

input_clause(c_6438,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,++p1,++p2,--p3,++p4]).

input_clause(c_6439,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,++p1,++p2,--p3,++p4,--p5,++p7]).

input_clause(c_6440,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,++p1,++p2,--p3,++p4,--p5,--p6]).

input_clause(c_6441,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,++p1,++p2,++p4,--p5,--p6,++p7]).

input_clause(c_6442,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,++p1,++p2,++p4,--p5]).

input_clause(c_6443,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,++p1,++p2,++p4,++p7]).

input_clause(c_6444,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,++p1,++p2,++p4,--p6]).

input_clause(c_6445,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,++p1,++p2,--p6,++p7]).

input_clause(c_6446,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,++p1,++p2]).

input_clause(c_6447,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,++p1,++p2,--p5,++p7]).

input_clause(c_6448,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,++p1,++p2,--p5,--p6]).

input_clause(c_6449,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,++p1,--p5,--p6,++p7]).

input_clause(c_6450,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,++p1,--p5]).

input_clause(c_6451,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,++p1,++p7]).

input_clause(c_6452,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,++p1,--p6]).

input_clause(c_6453,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,++p1,++p4,--p6,++p7]).

input_clause(c_6454,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,++p1,++p4]).

input_clause(c_6455,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,++p1,++p4,--p5,++p7]).

input_clause(c_6456,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,++p1,++p4,--p5,--p6]).

input_clause(c_6457,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,++p1,--p3,++p4,--p5,--p6,++p7]).

input_clause(c_6458,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,++p1,--p3,++p4,--p5]).

input_clause(c_6459,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,++p1,--p3,++p4,++p7]).

input_clause(c_6460,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,++p1,--p3,++p4,--p6]).

input_clause(c_6461,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,++p1,--p3,--p6,++p7]).

input_clause(c_6462,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,++p1,--p3]).

input_clause(c_6463,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,++p1,--p3,--p5,++p7]).

input_clause(c_6464,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p7,++p1,--p3,--p5,--p6]).

input_clause(c_6465,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,++p1,--p3,--p5,--p6]).

input_clause(c_6466,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,++p1,--p3,--p5,--p7]).

input_clause(c_6467,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,++p1,--p3]).

input_clause(c_6468,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,++p1,--p3,--p6,--p7]).

input_clause(c_6469,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,++p1,--p3,++p4,--p6]).

input_clause(c_6470,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,++p1,--p3,++p4,--p7]).

input_clause(c_6471,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,++p1,--p3,++p4,--p5]).

input_clause(c_6472,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,++p1,--p3,++p4,--p5,--p6,--p7]).

input_clause(c_6473,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,++p1,++p4,--p5,--p6]).

input_clause(c_6474,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,++p1,++p4,--p5,--p7]).

input_clause(c_6475,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,++p1,++p4]).

input_clause(c_6476,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,++p1,++p4,--p6,--p7]).

input_clause(c_6477,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,++p1,--p6]).

input_clause(c_6478,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,++p1,--p7]).

input_clause(c_6479,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,++p1,--p5]).

input_clause(c_6480,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,++p1,--p5,--p6,--p7]).

input_clause(c_6481,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,++p1,++p2,--p5,--p6]).

input_clause(c_6482,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,++p1,++p2,--p5,--p7]).

input_clause(c_6483,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,++p1,++p2]).

input_clause(c_6484,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,++p1,++p2,--p6,--p7]).

input_clause(c_6485,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,++p1,++p2,++p4,--p6]).

input_clause(c_6486,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,++p1,++p2,++p4,--p7]).

input_clause(c_6487,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,++p1,++p2,++p4,--p5]).

input_clause(c_6488,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,++p1,++p2,++p4,--p5,--p6,--p7]).

input_clause(c_6489,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,++p1,++p2,--p3,++p4,--p5,--p6]).

input_clause(c_6490,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,++p1,++p2,--p3,++p4,--p5,--p7]).

input_clause(c_6491,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,++p1,++p2,--p3,++p4]).

input_clause(c_6492,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,++p1,++p2,--p3,++p4,--p6,--p7]).

input_clause(c_6493,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,++p1,++p2,--p3,--p6]).

input_clause(c_6494,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,++p1,++p2,--p3,--p7]).

input_clause(c_6495,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,++p1,++p2,--p3,--p5]).

input_clause(c_6496,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,++p1,++p2,--p3,--p5,--p6,--p7]).

input_clause(c_6497,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,++p2,--p3,--p5,--p6]).

input_clause(c_6498,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,++p2,--p3,--p5,--p7]).

input_clause(c_6499,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,++p2,--p3]).

input_clause(c_6500,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,++p2,--p3,--p6,--p7]).

input_clause(c_6501,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,++p2,--p3,++p4,--p6]).

input_clause(c_6502,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,++p2,--p3,++p4,--p7]).

input_clause(c_6503,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,++p2,--p3,++p4,--p5]).

input_clause(c_6504,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,++p2,--p3,++p4,--p5,--p6,--p7]).

input_clause(c_6505,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,++p2,++p4,--p5,--p6]).

input_clause(c_6506,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,++p2,++p4,--p5,--p7]).

input_clause(c_6507,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,++p2,++p4]).

input_clause(c_6508,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,++p2,++p4,--p6,--p7]).

input_clause(c_6509,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,++p2,--p6]).

input_clause(c_6510,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,++p2,--p7]).

input_clause(c_6511,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,++p2,--p5]).

input_clause(c_6512,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,++p2,--p5,--p6,--p7]).

input_clause(c_6513,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,--p5,--p6]).

input_clause(c_6514,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,--p5,--p7]).

input_clause(c_6515,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7]).

input_clause(c_6516,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,--p6,--p7]).

input_clause(c_6517,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,++p4,--p6]).

input_clause(c_6518,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,++p4,--p7]).

input_clause(c_6519,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,++p4,--p5]).

input_clause(c_6520,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,++p4,--p5,--p6,--p7]).

input_clause(c_6521,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,--p3,++p4,--p5,--p6]).

input_clause(c_6522,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,--p3,++p4,--p5,--p7]).

input_clause(c_6523,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,--p3,++p4]).

input_clause(c_6524,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,--p3,++p4,--p6,--p7]).

input_clause(c_6525,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,--p3,--p6]).

input_clause(c_6526,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,--p3,--p7]).

input_clause(c_6527,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,--p3,--p5]).

input_clause(c_6528,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p7,--p3,--p5,--p6,--p7]).

input_clause(c_6529,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,--p3,--p5]).

input_clause(c_6530,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,--p3,--p5,++p6,--p7]).

input_clause(c_6531,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,--p3,++p6]).

input_clause(c_6532,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,--p3,--p7]).

input_clause(c_6533,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,--p3,++p4]).

input_clause(c_6534,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,--p3,++p4,++p6,--p7]).

input_clause(c_6535,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,--p3,++p4,--p5,++p6]).

input_clause(c_6536,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,--p3,++p4,--p5,--p7]).

input_clause(c_6537,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,++p4,--p5]).

input_clause(c_6538,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,++p4,--p5,++p6,--p7]).

input_clause(c_6539,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,++p4,++p6]).

input_clause(c_6540,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,++p4,--p7]).

input_clause(c_6541,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7]).

input_clause(c_6542,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,++p6,--p7]).

input_clause(c_6543,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,--p5,++p6]).

input_clause(c_6544,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,--p5,--p7]).

input_clause(c_6545,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,++p2,--p5]).

input_clause(c_6546,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,++p2,--p5,++p6,--p7]).

input_clause(c_6547,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,++p2,++p6]).

input_clause(c_6548,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,++p2,--p7]).

input_clause(c_6549,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,++p2,++p4]).

input_clause(c_6550,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,++p2,++p4,++p6,--p7]).

input_clause(c_6551,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,++p2,++p4,--p5,++p6]).

input_clause(c_6552,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,++p2,++p4,--p5,--p7]).

input_clause(c_6553,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,++p2,--p3,++p4,--p5]).

input_clause(c_6554,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,++p2,--p3,++p4,--p5,++p6,--p7]).

input_clause(c_6555,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,++p2,--p3,++p4,++p6]).

input_clause(c_6556,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,++p2,--p3,++p4,--p7]).

input_clause(c_6557,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,++p2,--p3]).

input_clause(c_6558,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,++p2,--p3,++p6,--p7]).

input_clause(c_6559,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,++p2,--p3,--p5,++p6]).

input_clause(c_6560,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,++p2,--p3,--p5,--p7]).

input_clause(c_6561,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,++p1,++p2,--p3,--p5]).

input_clause(c_6562,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,++p1,++p2,--p3,--p5,++p6,--p7]).

input_clause(c_6563,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,++p1,++p2,--p3,++p6]).

input_clause(c_6564,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,++p1,++p2,--p3,--p7]).

input_clause(c_6565,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,++p1,++p2,--p3,++p4]).

input_clause(c_6566,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,++p1,++p2,--p3,++p4,++p6,--p7]).

input_clause(c_6567,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,++p1,++p2,--p3,++p4,--p5,++p6]).

input_clause(c_6568,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,++p1,++p2,--p3,++p4,--p5,--p7]).

input_clause(c_6569,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,++p1,++p2,++p4,--p5]).

input_clause(c_6570,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,++p1,++p2,++p4,--p5,++p6,--p7]).

input_clause(c_6571,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,++p1,++p2,++p4,++p6]).

input_clause(c_6572,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,++p1,++p2,++p4,--p7]).

input_clause(c_6573,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,++p1,++p2]).

input_clause(c_6574,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,++p1,++p2,++p6,--p7]).

input_clause(c_6575,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,++p1,++p2,--p5,++p6]).

input_clause(c_6576,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,++p1,++p2,--p5,--p7]).

input_clause(c_6577,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,++p1,--p5]).

input_clause(c_6578,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,++p1,--p5,++p6,--p7]).

input_clause(c_6579,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,++p1,++p6]).

input_clause(c_6580,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,++p1,--p7]).

input_clause(c_6581,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,++p1,++p4]).

input_clause(c_6582,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,++p1,++p4,++p6,--p7]).

input_clause(c_6583,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,++p1,++p4,--p5,++p6]).

input_clause(c_6584,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,++p1,++p4,--p5,--p7]).

input_clause(c_6585,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,++p1,--p3,++p4,--p5]).

input_clause(c_6586,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,++p1,--p3,++p4,--p5,++p6,--p7]).

input_clause(c_6587,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,++p1,--p3,++p4,++p6]).

input_clause(c_6588,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,++p1,--p3,++p4,--p7]).

input_clause(c_6589,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,++p1,--p3]).

input_clause(c_6590,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,++p1,--p3,++p6,--p7]).

input_clause(c_6591,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,++p1,--p3,--p5,++p6]).

input_clause(c_6592,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p7,++p1,--p3,--p5,--p7]).

input_clause(c_6593,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,++p1,--p3,--p5,++p7]).

input_clause(c_6594,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,++p1,--p3,--p5,++p6]).

input_clause(c_6595,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,++p1,--p3,++p6,++p7]).

input_clause(c_6596,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,++p1,--p3]).

input_clause(c_6597,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,++p1,--p3,++p4,++p7]).

input_clause(c_6598,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,++p1,--p3,++p4,++p6]).

input_clause(c_6599,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,++p1,--p3,++p4,--p5,++p6,++p7]).

input_clause(c_6600,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,++p1,--p3,++p4,--p5]).

input_clause(c_6601,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,++p1,++p4,--p5,++p7]).

input_clause(c_6602,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,++p1,++p4,--p5,++p6]).

input_clause(c_6603,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,++p1,++p4,++p6,++p7]).

input_clause(c_6604,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,++p1,++p4]).

input_clause(c_6605,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,++p1,++p7]).

input_clause(c_6606,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,++p1,++p6]).

input_clause(c_6607,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,++p1,--p5,++p6,++p7]).

input_clause(c_6608,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,++p1,--p5]).

input_clause(c_6609,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,++p1,++p2,--p5,++p7]).

input_clause(c_6610,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,++p1,++p2,--p5,++p6]).

input_clause(c_6611,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,++p1,++p2,++p6,++p7]).

input_clause(c_6612,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,++p1,++p2]).

input_clause(c_6613,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,++p1,++p2,++p4,++p7]).

input_clause(c_6614,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,++p1,++p2,++p4,++p6]).

input_clause(c_6615,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,++p1,++p2,++p4,--p5,++p6,++p7]).

input_clause(c_6616,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,++p1,++p2,++p4,--p5]).

input_clause(c_6617,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,++p1,++p2,--p3,++p4,--p5,++p7]).

input_clause(c_6618,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,++p1,++p2,--p3,++p4,--p5,++p6]).

input_clause(c_6619,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,++p1,++p2,--p3,++p4,++p6,++p7]).

input_clause(c_6620,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,++p1,++p2,--p3,++p4]).

input_clause(c_6621,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,++p1,++p2,--p3,++p7]).

input_clause(c_6622,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,++p1,++p2,--p3,++p6]).

input_clause(c_6623,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,++p1,++p2,--p3,--p5,++p6,++p7]).

input_clause(c_6624,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,++p1,++p2,--p3,--p5]).

input_clause(c_6625,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,++p2,--p3,--p5,++p7]).

input_clause(c_6626,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,++p2,--p3,--p5,++p6]).

input_clause(c_6627,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,++p2,--p3,++p6,++p7]).

input_clause(c_6628,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,++p2,--p3]).

input_clause(c_6629,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,++p2,--p3,++p4,++p7]).

input_clause(c_6630,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,++p2,--p3,++p4,++p6]).

input_clause(c_6631,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,++p2,--p3,++p4,--p5,++p6,++p7]).

input_clause(c_6632,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,++p2,--p3,++p4,--p5]).

input_clause(c_6633,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,++p2,++p4,--p5,++p7]).

input_clause(c_6634,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,++p2,++p4,--p5,++p6]).

input_clause(c_6635,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,++p2,++p4,++p6,++p7]).

input_clause(c_6636,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,++p2,++p4]).

input_clause(c_6637,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,++p2,++p7]).

input_clause(c_6638,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,++p2,++p6]).

input_clause(c_6639,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,++p2,--p5,++p6,++p7]).

input_clause(c_6640,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,++p2,--p5]).

input_clause(c_6641,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,--p5,++p7]).

input_clause(c_6642,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,--p5,++p6]).

input_clause(c_6643,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,++p6,++p7]).

input_clause(c_6644,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7]).

input_clause(c_6645,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,++p4,++p7]).

input_clause(c_6646,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,++p4,++p6]).

input_clause(c_6647,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,++p4,--p5,++p6,++p7]).

input_clause(c_6648,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,++p4,--p5]).

input_clause(c_6649,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,--p3,++p4,--p5,++p7]).

input_clause(c_6650,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,--p3,++p4,--p5,++p6]).

input_clause(c_6651,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,--p3,++p4,++p6,++p7]).

input_clause(c_6652,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,--p3,++p4]).

input_clause(c_6653,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,--p3,++p7]).

input_clause(c_6654,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,--p3,++p6]).

input_clause(c_6655,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,--p3,--p5,++p6,++p7]).

input_clause(c_6656,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p7,--p3,--p5]).

input_clause(c_6657,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,--p3,--p4,--p5,++p7]).

input_clause(c_6658,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,--p3,--p4,--p5,++p6]).

input_clause(c_6659,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,--p3,--p4,++p6,++p7]).

input_clause(c_6660,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,--p3,--p4]).

input_clause(c_6661,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,--p3,++p7]).

input_clause(c_6662,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,--p3,++p6]).

input_clause(c_6663,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,--p3,--p5,++p6,++p7]).

input_clause(c_6664,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,--p3,--p5]).

input_clause(c_6665,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,--p5,++p7]).

input_clause(c_6666,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,--p5,++p6]).

input_clause(c_6667,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,++p6,++p7]).

input_clause(c_6668,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7]).

input_clause(c_6669,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,--p4,++p7]).

input_clause(c_6670,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,--p4,++p6]).

input_clause(c_6671,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,--p4,--p5,++p6,++p7]).

input_clause(c_6672,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,--p4,--p5]).

input_clause(c_6673,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,++p2,--p4,--p5,++p7]).

input_clause(c_6674,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,++p2,--p4,--p5,++p6]).

input_clause(c_6675,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,++p2,--p4,++p6,++p7]).

input_clause(c_6676,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,++p2,--p4]).

input_clause(c_6677,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,++p2,++p7]).

input_clause(c_6678,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,++p2,++p6]).

input_clause(c_6679,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,++p2,--p5,++p6,++p7]).

input_clause(c_6680,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,++p2,--p5]).

input_clause(c_6681,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,++p2,--p3,--p5,++p7]).

input_clause(c_6682,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,++p2,--p3,--p5,++p6]).

input_clause(c_6683,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,++p2,--p3,++p6,++p7]).

input_clause(c_6684,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,++p2,--p3]).

input_clause(c_6685,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,++p2,--p3,--p4,++p7]).

input_clause(c_6686,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,++p2,--p3,--p4,++p6]).

input_clause(c_6687,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,++p2,--p3,--p4,--p5,++p6,++p7]).

input_clause(c_6688,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,++p2,--p3,--p4,--p5]).

input_clause(c_6689,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,++p1,++p2,--p3,--p4,--p5,++p7]).

input_clause(c_6690,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,++p1,++p2,--p3,--p4,--p5,++p6]).

input_clause(c_6691,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,++p1,++p2,--p3,--p4,++p6,++p7]).

input_clause(c_6692,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,++p1,++p2,--p3,--p4]).

input_clause(c_6693,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,++p1,++p2,--p3,++p7]).

input_clause(c_6694,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,++p1,++p2,--p3,++p6]).

input_clause(c_6695,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,++p1,++p2,--p3,--p5,++p6,++p7]).

input_clause(c_6696,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,++p1,++p2,--p3,--p5]).

input_clause(c_6697,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,++p1,++p2,--p5,++p7]).

input_clause(c_6698,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,++p1,++p2,--p5,++p6]).

input_clause(c_6699,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,++p1,++p2,++p6,++p7]).

input_clause(c_6700,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,++p1,++p2]).

input_clause(c_6701,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,++p1,++p2,--p4,++p7]).

input_clause(c_6702,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,++p1,++p2,--p4,++p6]).

input_clause(c_6703,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,++p1,++p2,--p4,--p5,++p6,++p7]).

input_clause(c_6704,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,++p1,++p2,--p4,--p5]).

input_clause(c_6705,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,++p1,--p4,--p5,++p7]).

input_clause(c_6706,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,++p1,--p4,--p5,++p6]).

input_clause(c_6707,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,++p1,--p4,++p6,++p7]).

input_clause(c_6708,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,++p1,--p4]).

input_clause(c_6709,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,++p1,++p7]).

input_clause(c_6710,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,++p1,++p6]).

input_clause(c_6711,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,++p1,--p5,++p6,++p7]).

input_clause(c_6712,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,++p1,--p5]).

input_clause(c_6713,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,++p1,--p3,--p5,++p7]).

input_clause(c_6714,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,++p1,--p3,--p5,++p6]).

input_clause(c_6715,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,++p1,--p3,++p6,++p7]).

input_clause(c_6716,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,++p1,--p3]).

input_clause(c_6717,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,++p1,--p3,--p4,++p7]).

input_clause(c_6718,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,++p1,--p3,--p4,++p6]).

input_clause(c_6719,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,++p1,--p3,--p4,--p5,++p6,++p7]).

input_clause(c_6720,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p7,++p1,--p3,--p4,--p5]).

input_clause(c_6721,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,++p1,--p3,--p4,--p5]).

input_clause(c_6722,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,++p1,--p3,--p4,--p5,++p6,--p7]).

input_clause(c_6723,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,++p1,--p3,--p4,++p6]).

input_clause(c_6724,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,++p1,--p3,--p4,--p7]).

input_clause(c_6725,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,++p1,--p3]).

input_clause(c_6726,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,++p1,--p3,++p6,--p7]).

input_clause(c_6727,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,++p1,--p3,--p5,++p6]).

input_clause(c_6728,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,++p1,--p3,--p5,--p7]).

input_clause(c_6729,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,++p1,--p5]).

input_clause(c_6730,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,++p1,--p5,++p6,--p7]).

input_clause(c_6731,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,++p1,++p6]).

input_clause(c_6732,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,++p1,--p7]).

input_clause(c_6733,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,++p1,--p4]).

input_clause(c_6734,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,++p1,--p4,++p6,--p7]).

input_clause(c_6735,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,++p1,--p4,--p5,++p6]).

input_clause(c_6736,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,++p1,--p4,--p5,--p7]).

input_clause(c_6737,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,++p1,++p2,--p4,--p5]).

input_clause(c_6738,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,++p1,++p2,--p4,--p5,++p6,--p7]).

input_clause(c_6739,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,++p1,++p2,--p4,++p6]).

input_clause(c_6740,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,++p1,++p2,--p4,--p7]).

input_clause(c_6741,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,++p1,++p2]).

input_clause(c_6742,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,++p1,++p2,++p6,--p7]).

input_clause(c_6743,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,++p1,++p2,--p5,++p6]).

input_clause(c_6744,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,++p1,++p2,--p5,--p7]).

input_clause(c_6745,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,++p1,++p2,--p3,--p5]).

input_clause(c_6746,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,++p1,++p2,--p3,--p5,++p6,--p7]).

input_clause(c_6747,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,++p1,++p2,--p3,++p6]).

input_clause(c_6748,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,++p1,++p2,--p3,--p7]).

input_clause(c_6749,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,++p1,++p2,--p3,--p4]).

input_clause(c_6750,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,++p1,++p2,--p3,--p4,++p6,--p7]).

input_clause(c_6751,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,++p1,++p2,--p3,--p4,--p5,++p6]).

input_clause(c_6752,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,++p1,++p2,--p3,--p4,--p5,--p7]).

input_clause(c_6753,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,++p2,--p3,--p4,--p5]).

input_clause(c_6754,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,++p2,--p3,--p4,--p5,++p6,--p7]).

input_clause(c_6755,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,++p2,--p3,--p4,++p6]).

input_clause(c_6756,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,++p2,--p3,--p4,--p7]).

input_clause(c_6757,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,++p2,--p3]).

input_clause(c_6758,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,++p2,--p3,++p6,--p7]).

input_clause(c_6759,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,++p2,--p3,--p5,++p6]).

input_clause(c_6760,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,++p2,--p3,--p5,--p7]).

input_clause(c_6761,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,++p2,--p5]).

input_clause(c_6762,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,++p2,--p5,++p6,--p7]).

input_clause(c_6763,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,++p2,++p6]).

input_clause(c_6764,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,++p2,--p7]).

input_clause(c_6765,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,++p2,--p4]).

input_clause(c_6766,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,++p2,--p4,++p6,--p7]).

input_clause(c_6767,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,++p2,--p4,--p5,++p6]).

input_clause(c_6768,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,++p2,--p4,--p5,--p7]).

input_clause(c_6769,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,--p4,--p5]).

input_clause(c_6770,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,--p4,--p5,++p6,--p7]).

input_clause(c_6771,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,--p4,++p6]).

input_clause(c_6772,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,--p4,--p7]).

input_clause(c_6773,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7]).

input_clause(c_6774,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,++p6,--p7]).

input_clause(c_6775,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,--p5,++p6]).

input_clause(c_6776,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,--p5,--p7]).

input_clause(c_6777,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,--p3,--p5]).

input_clause(c_6778,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,--p3,--p5,++p6,--p7]).

input_clause(c_6779,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,--p3,++p6]).

input_clause(c_6780,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,--p3,--p7]).

input_clause(c_6781,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,--p3,--p4]).

input_clause(c_6782,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,--p3,--p4,++p6,--p7]).

input_clause(c_6783,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,--p3,--p4,--p5,++p6]).

input_clause(c_6784,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p7,--p3,--p4,--p5,--p7]).

input_clause(c_6785,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,--p3,--p4,--p5,--p6]).

input_clause(c_6786,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,--p3,--p4,--p5,--p7]).

input_clause(c_6787,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,--p3,--p4]).

input_clause(c_6788,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,--p3,--p4,--p6,--p7]).

input_clause(c_6789,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,--p3,--p6]).

input_clause(c_6790,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,--p3,--p7]).

input_clause(c_6791,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,--p3,--p5]).

input_clause(c_6792,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,--p3,--p5,--p6,--p7]).

input_clause(c_6793,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,--p5,--p6]).

input_clause(c_6794,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,--p5,--p7]).

input_clause(c_6795,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7]).

input_clause(c_6796,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,--p6,--p7]).

input_clause(c_6797,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,--p4,--p6]).

input_clause(c_6798,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,--p4,--p7]).

input_clause(c_6799,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,--p4,--p5]).

input_clause(c_6800,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,--p4,--p5,--p6,--p7]).

input_clause(c_6801,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,++p2,--p4,--p5,--p6]).

input_clause(c_6802,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,++p2,--p4,--p5,--p7]).

input_clause(c_6803,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,++p2,--p4]).

input_clause(c_6804,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,++p2,--p4,--p6,--p7]).

input_clause(c_6805,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,++p2,--p6]).

input_clause(c_6806,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,++p2,--p7]).

input_clause(c_6807,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,++p2,--p5]).

input_clause(c_6808,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,++p2,--p5,--p6,--p7]).

input_clause(c_6809,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,++p2,--p3,--p5,--p6]).

input_clause(c_6810,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,++p2,--p3,--p5,--p7]).

input_clause(c_6811,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,++p2,--p3]).

input_clause(c_6812,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,++p2,--p3,--p6,--p7]).

input_clause(c_6813,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,++p2,--p3,--p4,--p6]).

input_clause(c_6814,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,++p2,--p3,--p4,--p7]).

input_clause(c_6815,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,++p2,--p3,--p4,--p5]).

input_clause(c_6816,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,++p2,--p3,--p4,--p5,--p6,--p7]).

input_clause(c_6817,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,++p1,++p2,--p3,--p4,--p5,--p6]).

input_clause(c_6818,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,++p1,++p2,--p3,--p4,--p5,--p7]).

input_clause(c_6819,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,++p1,++p2,--p3,--p4]).

input_clause(c_6820,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,++p1,++p2,--p3,--p4,--p6,--p7]).

input_clause(c_6821,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,++p1,++p2,--p3,--p6]).

input_clause(c_6822,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,++p1,++p2,--p3,--p7]).

input_clause(c_6823,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,++p1,++p2,--p3,--p5]).

input_clause(c_6824,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,++p1,++p2,--p3,--p5,--p6,--p7]).

input_clause(c_6825,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,++p1,++p2,--p5,--p6]).

input_clause(c_6826,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,++p1,++p2,--p5,--p7]).

input_clause(c_6827,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,++p1,++p2]).

input_clause(c_6828,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,++p1,++p2,--p6,--p7]).

input_clause(c_6829,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,++p1,++p2,--p4,--p6]).

input_clause(c_6830,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,++p1,++p2,--p4,--p7]).

input_clause(c_6831,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,++p1,++p2,--p4,--p5]).

input_clause(c_6832,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,++p1,++p2,--p4,--p5,--p6,--p7]).

input_clause(c_6833,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,++p1,--p4,--p5,--p6]).

input_clause(c_6834,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,++p1,--p4,--p5,--p7]).

input_clause(c_6835,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,++p1,--p4]).

input_clause(c_6836,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,++p1,--p4,--p6,--p7]).

input_clause(c_6837,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,++p1,--p6]).

input_clause(c_6838,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,++p1,--p7]).

input_clause(c_6839,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,++p1,--p5]).

input_clause(c_6840,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,++p1,--p5,--p6,--p7]).

input_clause(c_6841,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,++p1,--p3,--p5,--p6]).

input_clause(c_6842,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,++p1,--p3,--p5,--p7]).

input_clause(c_6843,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,++p1,--p3]).

input_clause(c_6844,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,++p1,--p3,--p6,--p7]).

input_clause(c_6845,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,++p1,--p3,--p4,--p6]).

input_clause(c_6846,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,++p1,--p3,--p4,--p7]).

input_clause(c_6847,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,++p1,--p3,--p4,--p5]).

input_clause(c_6848,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p7,++p1,--p3,--p4,--p5,--p6,--p7]).

input_clause(c_6849,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,++p1,--p3,--p4,--p5,--p6,++p7]).

input_clause(c_6850,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,++p1,--p3,--p4,--p5]).

input_clause(c_6851,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,++p1,--p3,--p4,++p7]).

input_clause(c_6852,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,++p1,--p3,--p4,--p6]).

input_clause(c_6853,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,++p1,--p3,--p6,++p7]).

input_clause(c_6854,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,++p1,--p3]).

input_clause(c_6855,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,++p1,--p3,--p5,++p7]).

input_clause(c_6856,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,++p1,--p3,--p5,--p6]).

input_clause(c_6857,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,++p1,--p5,--p6,++p7]).

input_clause(c_6858,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,++p1,--p5]).

input_clause(c_6859,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,++p1,++p7]).

input_clause(c_6860,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,++p1,--p6]).

input_clause(c_6861,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,++p1,--p4,--p6,++p7]).

input_clause(c_6862,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,++p1,--p4]).

input_clause(c_6863,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,++p1,--p4,--p5,++p7]).

input_clause(c_6864,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,++p1,--p4,--p5,--p6]).

input_clause(c_6865,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,++p1,++p2,--p4,--p5,--p6,++p7]).

input_clause(c_6866,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,++p1,++p2,--p4,--p5]).

input_clause(c_6867,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,++p1,++p2,--p4,++p7]).

input_clause(c_6868,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,++p1,++p2,--p4,--p6]).

input_clause(c_6869,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,++p1,++p2,--p6,++p7]).

input_clause(c_6870,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,++p1,++p2]).

input_clause(c_6871,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,++p1,++p2,--p5,++p7]).

input_clause(c_6872,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,++p1,++p2,--p5,--p6]).

input_clause(c_6873,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,++p1,++p2,--p3,--p5,--p6,++p7]).

input_clause(c_6874,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,++p1,++p2,--p3,--p5]).

input_clause(c_6875,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,++p1,++p2,--p3,++p7]).

input_clause(c_6876,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,++p1,++p2,--p3,--p6]).

input_clause(c_6877,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,++p1,++p2,--p3,--p4,--p6,++p7]).

input_clause(c_6878,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,++p1,++p2,--p3,--p4]).

input_clause(c_6879,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,++p1,++p2,--p3,--p4,--p5,++p7]).

input_clause(c_6880,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,++p1,++p2,--p3,--p4,--p5,--p6]).

input_clause(c_6881,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,++p2,--p3,--p4,--p5,--p6,++p7]).

input_clause(c_6882,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,++p2,--p3,--p4,--p5]).

input_clause(c_6883,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,++p2,--p3,--p4,++p7]).

input_clause(c_6884,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,++p2,--p3,--p4,--p6]).

input_clause(c_6885,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,++p2,--p3,--p6,++p7]).

input_clause(c_6886,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,++p2,--p3]).

input_clause(c_6887,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,++p2,--p3,--p5,++p7]).

input_clause(c_6888,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,++p2,--p3,--p5,--p6]).

input_clause(c_6889,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,++p2,--p5,--p6,++p7]).

input_clause(c_6890,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,++p2,--p5]).

input_clause(c_6891,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,++p2,++p7]).

input_clause(c_6892,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,++p2,--p6]).

input_clause(c_6893,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,++p2,--p4,--p6,++p7]).

input_clause(c_6894,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,++p2,--p4]).

input_clause(c_6895,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,++p2,--p4,--p5,++p7]).

input_clause(c_6896,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,++p2,--p4,--p5,--p6]).

input_clause(c_6897,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,--p4,--p5,--p6,++p7]).

input_clause(c_6898,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,--p4,--p5]).

input_clause(c_6899,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,--p4,++p7]).

input_clause(c_6900,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,--p4,--p6]).

input_clause(c_6901,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,--p6,++p7]).

input_clause(c_6902,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7]).

input_clause(c_6903,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,--p5,++p7]).

input_clause(c_6904,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,--p5,--p6]).

input_clause(c_6905,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,--p3,--p5,--p6,++p7]).

input_clause(c_6906,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,--p3,--p5]).

input_clause(c_6907,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,--p3,++p7]).

input_clause(c_6908,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,--p3,--p6]).

input_clause(c_6909,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,--p3,--p4,--p6,++p7]).

input_clause(c_6910,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,--p3,--p4]).

input_clause(c_6911,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,--p3,--p4,--p5,++p7]).

input_clause(c_6912,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p7,--p3,--p4,--p5,--p6]).

input_clause(c_6913,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,--p3,--p4,--p6,++p7]).

input_clause(c_6914,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,--p3,--p4]).

input_clause(c_6915,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,--p3,--p4,++p5,++p7]).

input_clause(c_6916,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,--p3,--p4,++p5,--p6]).

input_clause(c_6917,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,--p3,++p5,--p6,++p7]).

input_clause(c_6918,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,--p3,++p5]).

input_clause(c_6919,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,--p3,++p7]).

input_clause(c_6920,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,--p3,--p6]).

input_clause(c_6921,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,--p6,++p7]).

input_clause(c_6922,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7]).

input_clause(c_6923,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,++p5,++p7]).

input_clause(c_6924,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,++p5,--p6]).

input_clause(c_6925,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,--p4,++p5,--p6,++p7]).

input_clause(c_6926,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,--p4,++p5]).

input_clause(c_6927,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,--p4,++p7]).

input_clause(c_6928,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,--p4,--p6]).

input_clause(c_6929,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,++p2,--p4,--p6,++p7]).

input_clause(c_6930,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,++p2,--p4]).

input_clause(c_6931,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,++p2,--p4,++p5,++p7]).

input_clause(c_6932,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,++p2,--p4,++p5,--p6]).

input_clause(c_6933,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,++p2,++p5,--p6,++p7]).

input_clause(c_6934,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,++p2,++p5]).

input_clause(c_6935,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,++p2,++p7]).

input_clause(c_6936,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,++p2,--p6]).

input_clause(c_6937,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,++p2,--p3,--p6,++p7]).

input_clause(c_6938,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,++p2,--p3]).

input_clause(c_6939,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,++p2,--p3,++p5,++p7]).

input_clause(c_6940,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,++p2,--p3,++p5,--p6]).

input_clause(c_6941,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,++p2,--p3,--p4,++p5,--p6,++p7]).

input_clause(c_6942,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,++p2,--p3,--p4,++p5]).

input_clause(c_6943,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,++p2,--p3,--p4,++p7]).

input_clause(c_6944,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,++p2,--p3,--p4,--p6]).

input_clause(c_6945,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,++p1,++p2,--p3,--p4,--p6,++p7]).

input_clause(c_6946,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,++p1,++p2,--p3,--p4]).

input_clause(c_6947,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,++p1,++p2,--p3,--p4,++p5,++p7]).

input_clause(c_6948,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,++p1,++p2,--p3,--p4,++p5,--p6]).

input_clause(c_6949,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,++p1,++p2,--p3,++p5,--p6,++p7]).

input_clause(c_6950,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,++p1,++p2,--p3,++p5]).

input_clause(c_6951,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,++p1,++p2,--p3,++p7]).

input_clause(c_6952,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,++p1,++p2,--p3,--p6]).

input_clause(c_6953,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,++p1,++p2,--p6,++p7]).

input_clause(c_6954,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,++p1,++p2]).

input_clause(c_6955,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,++p1,++p2,++p5,++p7]).

input_clause(c_6956,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,++p1,++p2,++p5,--p6]).

input_clause(c_6957,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,++p1,++p2,--p4,++p5,--p6,++p7]).

input_clause(c_6958,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,++p1,++p2,--p4,++p5]).

input_clause(c_6959,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,++p1,++p2,--p4,++p7]).

input_clause(c_6960,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,++p1,++p2,--p4,--p6]).

input_clause(c_6961,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,++p1,--p4,--p6,++p7]).

input_clause(c_6962,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,++p1,--p4]).

input_clause(c_6963,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,++p1,--p4,++p5,++p7]).

input_clause(c_6964,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,++p1,--p4,++p5,--p6]).

input_clause(c_6965,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,++p1,++p5,--p6,++p7]).

input_clause(c_6966,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,++p1,++p5]).

input_clause(c_6967,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,++p1,++p7]).

input_clause(c_6968,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,++p1,--p6]).

input_clause(c_6969,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,++p1,--p3,--p6,++p7]).

input_clause(c_6970,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,++p1,--p3]).

input_clause(c_6971,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,++p1,--p3,++p5,++p7]).

input_clause(c_6972,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,++p1,--p3,++p5,--p6]).

input_clause(c_6973,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,++p1,--p3,--p4,++p5,--p6,++p7]).

input_clause(c_6974,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,++p1,--p3,--p4,++p5]).

input_clause(c_6975,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,++p1,--p3,--p4,++p7]).

input_clause(c_6976,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p7,++p1,--p3,--p4,--p6]).

input_clause(c_6977,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,++p1,--p3,--p4,--p6]).

input_clause(c_6978,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,++p1,--p3,--p4,--p7]).

input_clause(c_6979,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,++p1,--p3,--p4,++p5]).

input_clause(c_6980,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,++p1,--p3,--p4,++p5,--p6,--p7]).

input_clause(c_6981,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,++p1,--p3,++p5,--p6]).

input_clause(c_6982,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,++p1,--p3,++p5,--p7]).

input_clause(c_6983,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,++p1,--p3]).

input_clause(c_6984,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,++p1,--p3,--p6,--p7]).

input_clause(c_6985,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,++p1,--p6]).

input_clause(c_6986,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,++p1,--p7]).

input_clause(c_6987,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,++p1,++p5]).

input_clause(c_6988,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,++p1,++p5,--p6,--p7]).

input_clause(c_6989,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,++p1,--p4,++p5,--p6]).

input_clause(c_6990,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,++p1,--p4,++p5,--p7]).

input_clause(c_6991,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,++p1,--p4]).

input_clause(c_6992,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,++p1,--p4,--p6,--p7]).

input_clause(c_6993,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,++p1,++p2,--p4,--p6]).

input_clause(c_6994,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,++p1,++p2,--p4,--p7]).

input_clause(c_6995,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,++p1,++p2,--p4,++p5]).

input_clause(c_6996,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,++p1,++p2,--p4,++p5,--p6,--p7]).

input_clause(c_6997,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,++p1,++p2,++p5,--p6]).

input_clause(c_6998,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,++p1,++p2,++p5,--p7]).

input_clause(c_6999,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,++p1,++p2]).

input_clause(c_7000,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,++p1,++p2,--p6,--p7]).

input_clause(c_7001,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,++p1,++p2,--p3,--p6]).

input_clause(c_7002,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,++p1,++p2,--p3,--p7]).

input_clause(c_7003,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,++p1,++p2,--p3,++p5]).

input_clause(c_7004,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,++p1,++p2,--p3,++p5,--p6,--p7]).

input_clause(c_7005,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,++p1,++p2,--p3,--p4,++p5,--p6]).

input_clause(c_7006,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,++p1,++p2,--p3,--p4,++p5,--p7]).

input_clause(c_7007,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,++p1,++p2,--p3,--p4]).

input_clause(c_7008,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,++p1,++p2,--p3,--p4,--p6,--p7]).

input_clause(c_7009,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,++p2,--p3,--p4,--p6]).

input_clause(c_7010,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,++p2,--p3,--p4,--p7]).

input_clause(c_7011,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,++p2,--p3,--p4,++p5]).

input_clause(c_7012,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,++p2,--p3,--p4,++p5,--p6,--p7]).

input_clause(c_7013,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,++p2,--p3,++p5,--p6]).

input_clause(c_7014,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,++p2,--p3,++p5,--p7]).

input_clause(c_7015,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,++p2,--p3]).

input_clause(c_7016,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,++p2,--p3,--p6,--p7]).

input_clause(c_7017,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,++p2,--p6]).

input_clause(c_7018,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,++p2,--p7]).

input_clause(c_7019,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,++p2,++p5]).

input_clause(c_7020,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,++p2,++p5,--p6,--p7]).

input_clause(c_7021,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,++p2,--p4,++p5,--p6]).

input_clause(c_7022,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,++p2,--p4,++p5,--p7]).

input_clause(c_7023,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,++p2,--p4]).

input_clause(c_7024,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,++p2,--p4,--p6,--p7]).

input_clause(c_7025,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,--p4,--p6]).

input_clause(c_7026,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,--p4,--p7]).

input_clause(c_7027,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,--p4,++p5]).

input_clause(c_7028,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,--p4,++p5,--p6,--p7]).

input_clause(c_7029,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,++p5,--p6]).

input_clause(c_7030,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,++p5,--p7]).

input_clause(c_7031,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7]).

input_clause(c_7032,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,--p6,--p7]).

input_clause(c_7033,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,--p3,--p6]).

input_clause(c_7034,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,--p3,--p7]).

input_clause(c_7035,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,--p3,++p5]).

input_clause(c_7036,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,--p3,++p5,--p6,--p7]).

input_clause(c_7037,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,--p3,--p4,++p5,--p6]).

input_clause(c_7038,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,--p3,--p4,++p5,--p7]).

input_clause(c_7039,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,--p3,--p4]).

input_clause(c_7040,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p7,--p3,--p4,--p6,--p7]).

input_clause(c_7041,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,--p3,--p4]).

input_clause(c_7042,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,--p3,--p4,++p6,--p7]).

input_clause(c_7043,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,--p3,--p4,++p5,++p6]).

input_clause(c_7044,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,--p3,--p4,++p5,--p7]).

input_clause(c_7045,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,--p3,++p5]).

input_clause(c_7046,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,--p3,++p5,++p6,--p7]).

input_clause(c_7047,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,--p3,++p6]).

input_clause(c_7048,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,--p3,--p7]).

input_clause(c_7049,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7]).

input_clause(c_7050,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,++p6,--p7]).

input_clause(c_7051,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,++p5,++p6]).

input_clause(c_7052,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,++p5,--p7]).

input_clause(c_7053,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,--p4,++p5]).

input_clause(c_7054,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,--p4,++p5,++p6,--p7]).

input_clause(c_7055,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,--p4,++p6]).

input_clause(c_7056,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,--p4,--p7]).

input_clause(c_7057,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,++p2,--p4]).

input_clause(c_7058,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,++p2,--p4,++p6,--p7]).

input_clause(c_7059,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,++p2,--p4,++p5,++p6]).

input_clause(c_7060,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,++p2,--p4,++p5,--p7]).

input_clause(c_7061,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,++p2,++p5]).

input_clause(c_7062,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,++p2,++p5,++p6,--p7]).

input_clause(c_7063,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,++p2,++p6]).

input_clause(c_7064,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,++p2,--p7]).

input_clause(c_7065,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,++p2,--p3]).

input_clause(c_7066,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,++p2,--p3,++p6,--p7]).

input_clause(c_7067,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,++p2,--p3,++p5,++p6]).

input_clause(c_7068,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,++p2,--p3,++p5,--p7]).

input_clause(c_7069,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,++p2,--p3,--p4,++p5]).

input_clause(c_7070,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,++p2,--p3,--p4,++p5,++p6,--p7]).

input_clause(c_7071,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,++p2,--p3,--p4,++p6]).

input_clause(c_7072,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,++p2,--p3,--p4,--p7]).

input_clause(c_7073,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,++p1,++p2,--p3,--p4]).

input_clause(c_7074,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,++p1,++p2,--p3,--p4,++p6,--p7]).

input_clause(c_7075,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,++p1,++p2,--p3,--p4,++p5,++p6]).

input_clause(c_7076,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,++p1,++p2,--p3,--p4,++p5,--p7]).

input_clause(c_7077,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,++p1,++p2,--p3,++p5]).

input_clause(c_7078,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,++p1,++p2,--p3,++p5,++p6,--p7]).

input_clause(c_7079,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,++p1,++p2,--p3,++p6]).

input_clause(c_7080,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,++p1,++p2,--p3,--p7]).

input_clause(c_7081,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,++p1,++p2]).

input_clause(c_7082,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,++p1,++p2,++p6,--p7]).

input_clause(c_7083,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,++p1,++p2,++p5,++p6]).

input_clause(c_7084,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,++p1,++p2,++p5,--p7]).

input_clause(c_7085,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,++p1,++p2,--p4,++p5]).

input_clause(c_7086,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,++p1,++p2,--p4,++p5,++p6,--p7]).

input_clause(c_7087,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,++p1,++p2,--p4,++p6]).

input_clause(c_7088,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,++p1,++p2,--p4,--p7]).

input_clause(c_7089,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,++p1,--p4]).

input_clause(c_7090,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,++p1,--p4,++p6,--p7]).

input_clause(c_7091,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,++p1,--p4,++p5,++p6]).

input_clause(c_7092,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,++p1,--p4,++p5,--p7]).

input_clause(c_7093,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,++p1,++p5]).

input_clause(c_7094,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,++p1,++p5,++p6,--p7]).

input_clause(c_7095,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,++p1,++p6]).

input_clause(c_7096,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,++p1,--p7]).

input_clause(c_7097,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,++p1,--p3]).

input_clause(c_7098,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,++p1,--p3,++p6,--p7]).

input_clause(c_7099,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,++p1,--p3,++p5,++p6]).

input_clause(c_7100,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,++p1,--p3,++p5,--p7]).

input_clause(c_7101,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,++p1,--p3,--p4,++p5]).

input_clause(c_7102,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,++p1,--p3,--p4,++p5,++p6,--p7]).

input_clause(c_7103,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,++p1,--p3,--p4,++p6]).

input_clause(c_7104,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p7,++p1,--p3,--p4,--p7]).

input_clause(c_7105,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,++p1,--p3,--p4,++p7]).

input_clause(c_7106,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,++p1,--p3,--p4,++p6]).

input_clause(c_7107,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,++p1,--p3,--p4,++p5,++p6,++p7]).

input_clause(c_7108,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,++p1,--p3,--p4,++p5]).

input_clause(c_7109,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,++p1,--p3,++p5,++p7]).

input_clause(c_7110,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,++p1,--p3,++p5,++p6]).

input_clause(c_7111,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,++p1,--p3,++p6,++p7]).

input_clause(c_7112,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,++p1,--p3]).

input_clause(c_7113,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,++p1,++p7]).

input_clause(c_7114,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,++p1,++p6]).

input_clause(c_7115,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,++p1,++p5,++p6,++p7]).

input_clause(c_7116,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,++p1,++p5]).

input_clause(c_7117,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,++p1,--p4,++p5,++p7]).

input_clause(c_7118,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,++p1,--p4,++p5,++p6]).

input_clause(c_7119,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,++p1,--p4,++p6,++p7]).

input_clause(c_7120,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,++p1,--p4]).

input_clause(c_7121,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,++p1,++p2,--p4,++p7]).

input_clause(c_7122,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,++p1,++p2,--p4,++p6]).

input_clause(c_7123,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,++p1,++p2,--p4,++p5,++p6,++p7]).

input_clause(c_7124,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,++p1,++p2,--p4,++p5]).

input_clause(c_7125,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,++p1,++p2,++p5,++p7]).

input_clause(c_7126,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,++p1,++p2,++p5,++p6]).

input_clause(c_7127,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,++p1,++p2,++p6,++p7]).

input_clause(c_7128,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,++p1,++p2]).

input_clause(c_7129,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,++p1,++p2,--p3,++p7]).

input_clause(c_7130,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,++p1,++p2,--p3,++p6]).

input_clause(c_7131,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,++p1,++p2,--p3,++p5,++p6,++p7]).

input_clause(c_7132,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,++p1,++p2,--p3,++p5]).

input_clause(c_7133,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,++p1,++p2,--p3,--p4,++p5,++p7]).

input_clause(c_7134,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,++p1,++p2,--p3,--p4,++p5,++p6]).

input_clause(c_7135,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,++p1,++p2,--p3,--p4,++p6,++p7]).

input_clause(c_7136,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,++p1,++p2,--p3,--p4]).

input_clause(c_7137,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,++p2,--p3,--p4,++p7]).

input_clause(c_7138,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,++p2,--p3,--p4,++p6]).

input_clause(c_7139,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,++p2,--p3,--p4,++p5,++p6,++p7]).

input_clause(c_7140,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,++p2,--p3,--p4,++p5]).

input_clause(c_7141,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,++p2,--p3,++p5,++p7]).

input_clause(c_7142,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,++p2,--p3,++p5,++p6]).

input_clause(c_7143,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,++p2,--p3,++p6,++p7]).

input_clause(c_7144,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,++p2,--p3]).

input_clause(c_7145,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,++p2,++p7]).

input_clause(c_7146,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,++p2,++p6]).

input_clause(c_7147,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,++p2,++p5,++p6,++p7]).

input_clause(c_7148,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,++p2,++p5]).

input_clause(c_7149,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,++p2,--p4,++p5,++p7]).

input_clause(c_7150,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,++p2,--p4,++p5,++p6]).

input_clause(c_7151,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,++p2,--p4,++p6,++p7]).

input_clause(c_7152,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,++p2,--p4]).

input_clause(c_7153,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,--p4,++p7]).

input_clause(c_7154,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,--p4,++p6]).

input_clause(c_7155,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,--p4,++p5,++p6,++p7]).

input_clause(c_7156,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,--p4,++p5]).

input_clause(c_7157,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,++p5,++p7]).

input_clause(c_7158,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,++p5,++p6]).

input_clause(c_7159,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,++p6,++p7]).

input_clause(c_7160,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7]).

input_clause(c_7161,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,--p3,++p7]).

input_clause(c_7162,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,--p3,++p6]).

input_clause(c_7163,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,--p3,++p5,++p6,++p7]).

input_clause(c_7164,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,--p3,++p5]).

input_clause(c_7165,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,--p3,--p4,++p5,++p7]).

input_clause(c_7166,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,--p3,--p4,++p5,++p6]).

input_clause(c_7167,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,--p3,--p4,++p6,++p7]).

input_clause(c_7168,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p7,--p3,--p4]).

input_clause(c_7169,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,--p4,++p7]).

input_clause(c_7170,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,--p4,++p6]).

input_clause(c_7171,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,--p4,++p5,++p6,++p7]).

input_clause(c_7172,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,--p4,++p5]).

input_clause(c_7173,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p5,++p7]).

input_clause(c_7174,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p5,++p6]).

input_clause(c_7175,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p6,++p7]).

input_clause(c_7176,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7]).

input_clause(c_7177,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p3,++p7]).

input_clause(c_7178,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p3,++p6]).

input_clause(c_7179,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p3,++p5,++p6,++p7]).

input_clause(c_7180,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p3,++p5]).

input_clause(c_7181,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p3,--p4,++p5,++p7]).

input_clause(c_7182,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p3,--p4,++p5,++p6]).

input_clause(c_7183,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p3,--p4,++p6,++p7]).

input_clause(c_7184,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p3,--p4]).

input_clause(c_7185,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p2,++p3,--p4,++p7]).

input_clause(c_7186,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p2,++p3,--p4,++p6]).

input_clause(c_7187,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p2,++p3,--p4,++p5,++p6,++p7]).

input_clause(c_7188,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p2,++p3,--p4,++p5]).

input_clause(c_7189,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p2,++p3,++p5,++p7]).

input_clause(c_7190,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p2,++p3,++p5,++p6]).

input_clause(c_7191,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p2,++p3,++p6,++p7]).

input_clause(c_7192,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p2,++p3]).

input_clause(c_7193,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p2,++p7]).

input_clause(c_7194,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p2,++p6]).

input_clause(c_7195,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p2,++p5,++p6,++p7]).

input_clause(c_7196,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p2,++p5]).

input_clause(c_7197,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p2,--p4,++p5,++p7]).

input_clause(c_7198,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p2,--p4,++p5,++p6]).

input_clause(c_7199,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p2,--p4,++p6,++p7]).

input_clause(c_7200,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p2,--p4]).

input_clause(c_7201,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p1,++p2,--p4,++p7]).

input_clause(c_7202,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p1,++p2,--p4,++p6]).

input_clause(c_7203,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p1,++p2,--p4,++p5,++p6,++p7]).

input_clause(c_7204,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p1,++p2,--p4,++p5]).

input_clause(c_7205,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p1,++p2,++p5,++p7]).

input_clause(c_7206,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p1,++p2,++p5,++p6]).

input_clause(c_7207,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p1,++p2,++p6,++p7]).

input_clause(c_7208,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p1,++p2]).

input_clause(c_7209,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p1,++p2,++p3,++p7]).

input_clause(c_7210,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p1,++p2,++p3,++p6]).

input_clause(c_7211,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p1,++p2,++p3,++p5,++p6,++p7]).

input_clause(c_7212,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p1,++p2,++p3,++p5]).

input_clause(c_7213,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p1,++p2,++p3,--p4,++p5,++p7]).

input_clause(c_7214,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p1,++p2,++p3,--p4,++p5,++p6]).

input_clause(c_7215,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p1,++p2,++p3,--p4,++p6,++p7]).

input_clause(c_7216,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p1,++p2,++p3,--p4]).

input_clause(c_7217,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p1,++p3,--p4,++p7]).

input_clause(c_7218,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p1,++p3,--p4,++p6]).

input_clause(c_7219,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p1,++p3,--p4,++p5,++p6,++p7]).

input_clause(c_7220,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p1,++p3,--p4,++p5]).

input_clause(c_7221,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p1,++p3,++p5,++p7]).

input_clause(c_7222,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p1,++p3,++p5,++p6]).

input_clause(c_7223,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p1,++p3,++p6,++p7]).

input_clause(c_7224,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p1,++p3]).

input_clause(c_7225,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p1,++p7]).

input_clause(c_7226,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p1,++p6]).

input_clause(c_7227,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p1,++p5,++p6,++p7]).

input_clause(c_7228,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p1,++p5]).

input_clause(c_7229,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p1,--p4,++p5,++p7]).

input_clause(c_7230,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p1,--p4,++p5,++p6]).

input_clause(c_7231,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p1,--p4,++p6,++p7]).

input_clause(c_7232,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p7,++p1,--p4]).

input_clause(c_7233,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p1,--p4]).

input_clause(c_7234,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p1,--p4,++p6,--p7]).

input_clause(c_7235,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p1,--p4,++p5,++p6]).

input_clause(c_7236,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p1,--p4,++p5,--p7]).

input_clause(c_7237,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p1,++p5]).

input_clause(c_7238,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p1,++p5,++p6,--p7]).

input_clause(c_7239,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p1,++p6]).

input_clause(c_7240,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p1,--p7]).

input_clause(c_7241,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p1,++p3]).

input_clause(c_7242,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p1,++p3,++p6,--p7]).

input_clause(c_7243,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p1,++p3,++p5,++p6]).

input_clause(c_7244,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p1,++p3,++p5,--p7]).

input_clause(c_7245,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p1,++p3,--p4,++p5]).

input_clause(c_7246,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p1,++p3,--p4,++p5,++p6,--p7]).

input_clause(c_7247,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p1,++p3,--p4,++p6]).

input_clause(c_7248,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p1,++p3,--p4,--p7]).

input_clause(c_7249,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p1,++p2,++p3,--p4]).

input_clause(c_7250,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p1,++p2,++p3,--p4,++p6,--p7]).

input_clause(c_7251,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p1,++p2,++p3,--p4,++p5,++p6]).

input_clause(c_7252,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p1,++p2,++p3,--p4,++p5,--p7]).

input_clause(c_7253,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p1,++p2,++p3,++p5]).

input_clause(c_7254,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p1,++p2,++p3,++p5,++p6,--p7]).

input_clause(c_7255,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p1,++p2,++p3,++p6]).

input_clause(c_7256,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p1,++p2,++p3,--p7]).

input_clause(c_7257,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p1,++p2]).

input_clause(c_7258,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p1,++p2,++p6,--p7]).

input_clause(c_7259,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p1,++p2,++p5,++p6]).

input_clause(c_7260,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p1,++p2,++p5,--p7]).

input_clause(c_7261,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p1,++p2,--p4,++p5]).

input_clause(c_7262,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p1,++p2,--p4,++p5,++p6,--p7]).

input_clause(c_7263,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p1,++p2,--p4,++p6]).

input_clause(c_7264,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p1,++p2,--p4,--p7]).

input_clause(c_7265,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p2,--p4]).

input_clause(c_7266,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p2,--p4,++p6,--p7]).

input_clause(c_7267,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p2,--p4,++p5,++p6]).

input_clause(c_7268,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p2,--p4,++p5,--p7]).

input_clause(c_7269,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p2,++p5]).

input_clause(c_7270,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p2,++p5,++p6,--p7]).

input_clause(c_7271,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p2,++p6]).

input_clause(c_7272,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p2,--p7]).

input_clause(c_7273,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p2,++p3]).

input_clause(c_7274,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p2,++p3,++p6,--p7]).

input_clause(c_7275,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p2,++p3,++p5,++p6]).

input_clause(c_7276,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p2,++p3,++p5,--p7]).

input_clause(c_7277,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p2,++p3,--p4,++p5]).

input_clause(c_7278,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p2,++p3,--p4,++p5,++p6,--p7]).

input_clause(c_7279,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p2,++p3,--p4,++p6]).

input_clause(c_7280,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p2,++p3,--p4,--p7]).

input_clause(c_7281,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p3,--p4]).

input_clause(c_7282,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p3,--p4,++p6,--p7]).

input_clause(c_7283,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p3,--p4,++p5,++p6]).

input_clause(c_7284,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p3,--p4,++p5,--p7]).

input_clause(c_7285,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p3,++p5]).

input_clause(c_7286,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p3,++p5,++p6,--p7]).

input_clause(c_7287,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p3,++p6]).

input_clause(c_7288,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p3,--p7]).

input_clause(c_7289,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7]).

input_clause(c_7290,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p6,--p7]).

input_clause(c_7291,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p5,++p6]).

input_clause(c_7292,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,++p5,--p7]).

input_clause(c_7293,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,--p4,++p5]).

input_clause(c_7294,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,--p4,++p5,++p6,--p7]).

input_clause(c_7295,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,--p4,++p6]).

input_clause(c_7296,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p7,--p4,--p7]).

input_clause(c_7297,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,--p4,--p6]).

input_clause(c_7298,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,--p4,--p7]).

input_clause(c_7299,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,--p4,++p5]).

input_clause(c_7300,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,--p4,++p5,--p6,--p7]).

input_clause(c_7301,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p5,--p6]).

input_clause(c_7302,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p5,--p7]).

input_clause(c_7303,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7]).

input_clause(c_7304,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,--p6,--p7]).

input_clause(c_7305,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p3,--p6]).

input_clause(c_7306,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p3,--p7]).

input_clause(c_7307,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p3,++p5]).

input_clause(c_7308,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p3,++p5,--p6,--p7]).

input_clause(c_7309,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p3,--p4,++p5,--p6]).

input_clause(c_7310,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p3,--p4,++p5,--p7]).

input_clause(c_7311,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p3,--p4]).

input_clause(c_7312,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p3,--p4,--p6,--p7]).

input_clause(c_7313,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p2,++p3,--p4,--p6]).

input_clause(c_7314,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p2,++p3,--p4,--p7]).

input_clause(c_7315,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p2,++p3,--p4,++p5]).

input_clause(c_7316,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p2,++p3,--p4,++p5,--p6,--p7]).

input_clause(c_7317,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p2,++p3,++p5,--p6]).

input_clause(c_7318,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p2,++p3,++p5,--p7]).

input_clause(c_7319,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p2,++p3]).

input_clause(c_7320,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p2,++p3,--p6,--p7]).

input_clause(c_7321,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p2,--p6]).

input_clause(c_7322,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p2,--p7]).

input_clause(c_7323,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p2,++p5]).

input_clause(c_7324,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p2,++p5,--p6,--p7]).

input_clause(c_7325,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p2,--p4,++p5,--p6]).

input_clause(c_7326,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p2,--p4,++p5,--p7]).

input_clause(c_7327,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p2,--p4]).

input_clause(c_7328,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p2,--p4,--p6,--p7]).

input_clause(c_7329,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p1,++p2,--p4,--p6]).

input_clause(c_7330,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p1,++p2,--p4,--p7]).

input_clause(c_7331,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p1,++p2,--p4,++p5]).

input_clause(c_7332,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p1,++p2,--p4,++p5,--p6,--p7]).

input_clause(c_7333,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p1,++p2,++p5,--p6]).

input_clause(c_7334,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p1,++p2,++p5,--p7]).

input_clause(c_7335,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p1,++p2]).

input_clause(c_7336,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p1,++p2,--p6,--p7]).

input_clause(c_7337,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p1,++p2,++p3,--p6]).

input_clause(c_7338,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p1,++p2,++p3,--p7]).

input_clause(c_7339,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p1,++p2,++p3,++p5]).

input_clause(c_7340,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p1,++p2,++p3,++p5,--p6,--p7]).

input_clause(c_7341,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p1,++p2,++p3,--p4,++p5,--p6]).

input_clause(c_7342,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p1,++p2,++p3,--p4,++p5,--p7]).

input_clause(c_7343,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p1,++p2,++p3,--p4]).

input_clause(c_7344,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p1,++p2,++p3,--p4,--p6,--p7]).

input_clause(c_7345,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p1,++p3,--p4,--p6]).

input_clause(c_7346,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p1,++p3,--p4,--p7]).

input_clause(c_7347,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p1,++p3,--p4,++p5]).

input_clause(c_7348,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p1,++p3,--p4,++p5,--p6,--p7]).

input_clause(c_7349,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p1,++p3,++p5,--p6]).

input_clause(c_7350,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p1,++p3,++p5,--p7]).

input_clause(c_7351,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p1,++p3]).

input_clause(c_7352,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p1,++p3,--p6,--p7]).

input_clause(c_7353,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p1,--p6]).

input_clause(c_7354,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p1,--p7]).

input_clause(c_7355,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p1,++p5]).

input_clause(c_7356,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p1,++p5,--p6,--p7]).

input_clause(c_7357,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p1,--p4,++p5,--p6]).

input_clause(c_7358,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p1,--p4,++p5,--p7]).

input_clause(c_7359,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p1,--p4]).

input_clause(c_7360,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p7,++p1,--p4,--p6,--p7]).

input_clause(c_7361,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p1,--p4,--p6,++p7]).

input_clause(c_7362,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p1,--p4]).

input_clause(c_7363,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p1,--p4,++p5,++p7]).

input_clause(c_7364,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p1,--p4,++p5,--p6]).

input_clause(c_7365,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p1,++p5,--p6,++p7]).

input_clause(c_7366,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p1,++p5]).

input_clause(c_7367,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p1,++p7]).

input_clause(c_7368,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p1,--p6]).

input_clause(c_7369,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p1,++p3,--p6,++p7]).

input_clause(c_7370,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p1,++p3]).

input_clause(c_7371,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p1,++p3,++p5,++p7]).

input_clause(c_7372,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p1,++p3,++p5,--p6]).

input_clause(c_7373,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p1,++p3,--p4,++p5,--p6,++p7]).

input_clause(c_7374,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p1,++p3,--p4,++p5]).

input_clause(c_7375,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p1,++p3,--p4,++p7]).

input_clause(c_7376,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p1,++p3,--p4,--p6]).

input_clause(c_7377,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p1,++p2,++p3,--p4,--p6,++p7]).

input_clause(c_7378,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p1,++p2,++p3,--p4]).

input_clause(c_7379,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p1,++p2,++p3,--p4,++p5,++p7]).

input_clause(c_7380,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p1,++p2,++p3,--p4,++p5,--p6]).

input_clause(c_7381,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p1,++p2,++p3,++p5,--p6,++p7]).

input_clause(c_7382,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p1,++p2,++p3,++p5]).

input_clause(c_7383,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p1,++p2,++p3,++p7]).

input_clause(c_7384,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p1,++p2,++p3,--p6]).

input_clause(c_7385,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p1,++p2,--p6,++p7]).

input_clause(c_7386,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p1,++p2]).

input_clause(c_7387,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p1,++p2,++p5,++p7]).

input_clause(c_7388,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p1,++p2,++p5,--p6]).

input_clause(c_7389,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p1,++p2,--p4,++p5,--p6,++p7]).

input_clause(c_7390,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p1,++p2,--p4,++p5]).

input_clause(c_7391,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p1,++p2,--p4,++p7]).

input_clause(c_7392,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p1,++p2,--p4,--p6]).

input_clause(c_7393,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p2,--p4,--p6,++p7]).

input_clause(c_7394,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p2,--p4]).

input_clause(c_7395,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p2,--p4,++p5,++p7]).

input_clause(c_7396,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p2,--p4,++p5,--p6]).

input_clause(c_7397,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p2,++p5,--p6,++p7]).

input_clause(c_7398,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p2,++p5]).

input_clause(c_7399,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p2,++p7]).

input_clause(c_7400,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p2,--p6]).

input_clause(c_7401,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p2,++p3,--p6,++p7]).

input_clause(c_7402,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p2,++p3]).

input_clause(c_7403,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p2,++p3,++p5,++p7]).

input_clause(c_7404,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p2,++p3,++p5,--p6]).

input_clause(c_7405,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p2,++p3,--p4,++p5,--p6,++p7]).

input_clause(c_7406,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p2,++p3,--p4,++p5]).

input_clause(c_7407,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p2,++p3,--p4,++p7]).

input_clause(c_7408,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p2,++p3,--p4,--p6]).

input_clause(c_7409,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p3,--p4,--p6,++p7]).

input_clause(c_7410,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p3,--p4]).

input_clause(c_7411,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p3,--p4,++p5,++p7]).

input_clause(c_7412,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p3,--p4,++p5,--p6]).

input_clause(c_7413,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p3,++p5,--p6,++p7]).

input_clause(c_7414,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p3,++p5]).

input_clause(c_7415,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p3,++p7]).

input_clause(c_7416,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p3,--p6]).

input_clause(c_7417,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,--p6,++p7]).

input_clause(c_7418,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7]).

input_clause(c_7419,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p5,++p7]).

input_clause(c_7420,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,++p5,--p6]).

input_clause(c_7421,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,--p4,++p5,--p6,++p7]).

input_clause(c_7422,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,--p4,++p5]).

input_clause(c_7423,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,--p4,++p7]).

input_clause(c_7424,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p7,--p4,--p6]).

input_clause(c_7425,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,--p4,--p5,--p6,++p7]).

input_clause(c_7426,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,--p4,--p5]).

input_clause(c_7427,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,--p4,++p7]).

input_clause(c_7428,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,--p4,--p6]).

input_clause(c_7429,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,--p6,++p7]).

input_clause(c_7430,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7]).

input_clause(c_7431,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,--p5,++p7]).

input_clause(c_7432,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,--p5,--p6]).

input_clause(c_7433,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,++p3,--p5,--p6,++p7]).

input_clause(c_7434,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,++p3,--p5]).

input_clause(c_7435,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,++p3,++p7]).

input_clause(c_7436,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,++p3,--p6]).

input_clause(c_7437,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,++p3,--p4,--p6,++p7]).

input_clause(c_7438,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,++p3,--p4]).

input_clause(c_7439,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,++p3,--p4,--p5,++p7]).

input_clause(c_7440,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,++p3,--p4,--p5,--p6]).

input_clause(c_7441,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,++p2,++p3,--p4,--p5,--p6,++p7]).

input_clause(c_7442,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,++p2,++p3,--p4,--p5]).

input_clause(c_7443,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,++p2,++p3,--p4,++p7]).

input_clause(c_7444,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,++p2,++p3,--p4,--p6]).

input_clause(c_7445,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,++p2,++p3,--p6,++p7]).

input_clause(c_7446,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,++p2,++p3]).

input_clause(c_7447,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,++p2,++p3,--p5,++p7]).

input_clause(c_7448,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,++p2,++p3,--p5,--p6]).

input_clause(c_7449,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,++p2,--p5,--p6,++p7]).

input_clause(c_7450,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,++p2,--p5]).

input_clause(c_7451,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,++p2,++p7]).

input_clause(c_7452,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,++p2,--p6]).

input_clause(c_7453,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,++p2,--p4,--p6,++p7]).

input_clause(c_7454,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,++p2,--p4]).

input_clause(c_7455,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,++p2,--p4,--p5,++p7]).

input_clause(c_7456,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,++p2,--p4,--p5,--p6]).

input_clause(c_7457,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,++p1,++p2,--p4,--p5,--p6,++p7]).

input_clause(c_7458,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,++p1,++p2,--p4,--p5]).

input_clause(c_7459,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,++p1,++p2,--p4,++p7]).

input_clause(c_7460,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,++p1,++p2,--p4,--p6]).

input_clause(c_7461,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,++p1,++p2,--p6,++p7]).

input_clause(c_7462,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,++p1,++p2]).

input_clause(c_7463,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,++p1,++p2,--p5,++p7]).

input_clause(c_7464,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,++p1,++p2,--p5,--p6]).

input_clause(c_7465,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,++p1,++p2,++p3,--p5,--p6,++p7]).

input_clause(c_7466,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,++p1,++p2,++p3,--p5]).

input_clause(c_7467,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,++p1,++p2,++p3,++p7]).

input_clause(c_7468,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,++p1,++p2,++p3,--p6]).

input_clause(c_7469,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,++p1,++p2,++p3,--p4,--p6,++p7]).

input_clause(c_7470,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,++p1,++p2,++p3,--p4]).

input_clause(c_7471,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,++p1,++p2,++p3,--p4,--p5,++p7]).

input_clause(c_7472,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,++p1,++p2,++p3,--p4,--p5,--p6]).

input_clause(c_7473,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,++p1,++p3,--p4,--p5,--p6,++p7]).

input_clause(c_7474,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,++p1,++p3,--p4,--p5]).

input_clause(c_7475,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,++p1,++p3,--p4,++p7]).

input_clause(c_7476,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,++p1,++p3,--p4,--p6]).

input_clause(c_7477,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,++p1,++p3,--p6,++p7]).

input_clause(c_7478,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,++p1,++p3]).

input_clause(c_7479,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,++p1,++p3,--p5,++p7]).

input_clause(c_7480,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,++p1,++p3,--p5,--p6]).

input_clause(c_7481,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,++p1,--p5,--p6,++p7]).

input_clause(c_7482,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,++p1,--p5]).

input_clause(c_7483,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,++p1,++p7]).

input_clause(c_7484,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,++p1,--p6]).

input_clause(c_7485,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,++p1,--p4,--p6,++p7]).

input_clause(c_7486,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,++p1,--p4]).

input_clause(c_7487,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,++p1,--p4,--p5,++p7]).

input_clause(c_7488,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p7,++p1,--p4,--p5,--p6]).

input_clause(c_7489,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,++p1,--p4,--p5,--p6]).

input_clause(c_7490,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,++p1,--p4,--p5,--p7]).

input_clause(c_7491,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,++p1,--p4]).

input_clause(c_7492,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,++p1,--p4,--p6,--p7]).

input_clause(c_7493,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,++p1,--p6]).

input_clause(c_7494,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,++p1,--p7]).

input_clause(c_7495,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,++p1,--p5]).

input_clause(c_7496,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,++p1,--p5,--p6,--p7]).

input_clause(c_7497,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,++p1,++p3,--p5,--p6]).

input_clause(c_7498,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,++p1,++p3,--p5,--p7]).

input_clause(c_7499,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,++p1,++p3]).

input_clause(c_7500,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,++p1,++p3,--p6,--p7]).

input_clause(c_7501,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,++p1,++p3,--p4,--p6]).

input_clause(c_7502,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,++p1,++p3,--p4,--p7]).

input_clause(c_7503,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,++p1,++p3,--p4,--p5]).

input_clause(c_7504,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,++p1,++p3,--p4,--p5,--p6,--p7]).

input_clause(c_7505,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,++p1,++p2,++p3,--p4,--p5,--p6]).

input_clause(c_7506,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,++p1,++p2,++p3,--p4,--p5,--p7]).

input_clause(c_7507,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,++p1,++p2,++p3,--p4]).

input_clause(c_7508,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,++p1,++p2,++p3,--p4,--p6,--p7]).

input_clause(c_7509,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,++p1,++p2,++p3,--p6]).

input_clause(c_7510,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,++p1,++p2,++p3,--p7]).

input_clause(c_7511,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,++p1,++p2,++p3,--p5]).

input_clause(c_7512,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,++p1,++p2,++p3,--p5,--p6,--p7]).

input_clause(c_7513,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,++p1,++p2,--p5,--p6]).

input_clause(c_7514,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,++p1,++p2,--p5,--p7]).

input_clause(c_7515,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,++p1,++p2]).

input_clause(c_7516,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,++p1,++p2,--p6,--p7]).

input_clause(c_7517,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,++p1,++p2,--p4,--p6]).

input_clause(c_7518,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,++p1,++p2,--p4,--p7]).

input_clause(c_7519,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,++p1,++p2,--p4,--p5]).

input_clause(c_7520,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,++p1,++p2,--p4,--p5,--p6,--p7]).

input_clause(c_7521,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,++p2,--p4,--p5,--p6]).

input_clause(c_7522,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,++p2,--p4,--p5,--p7]).

input_clause(c_7523,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,++p2,--p4]).

input_clause(c_7524,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,++p2,--p4,--p6,--p7]).

input_clause(c_7525,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,++p2,--p6]).

input_clause(c_7526,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,++p2,--p7]).

input_clause(c_7527,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,++p2,--p5]).

input_clause(c_7528,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,++p2,--p5,--p6,--p7]).

input_clause(c_7529,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,++p2,++p3,--p5,--p6]).

input_clause(c_7530,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,++p2,++p3,--p5,--p7]).

input_clause(c_7531,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,++p2,++p3]).

input_clause(c_7532,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,++p2,++p3,--p6,--p7]).

input_clause(c_7533,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,++p2,++p3,--p4,--p6]).

input_clause(c_7534,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,++p2,++p3,--p4,--p7]).

input_clause(c_7535,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,++p2,++p3,--p4,--p5]).

input_clause(c_7536,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,++p2,++p3,--p4,--p5,--p6,--p7]).

input_clause(c_7537,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,++p3,--p4,--p5,--p6]).

input_clause(c_7538,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,++p3,--p4,--p5,--p7]).

input_clause(c_7539,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,++p3,--p4]).

input_clause(c_7540,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,++p3,--p4,--p6,--p7]).

input_clause(c_7541,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,++p3,--p6]).

input_clause(c_7542,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,++p3,--p7]).

input_clause(c_7543,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,++p3,--p5]).

input_clause(c_7544,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,++p3,--p5,--p6,--p7]).

input_clause(c_7545,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,--p5,--p6]).

input_clause(c_7546,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,--p5,--p7]).

input_clause(c_7547,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7]).

input_clause(c_7548,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,--p6,--p7]).

input_clause(c_7549,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,--p4,--p6]).

input_clause(c_7550,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,--p4,--p7]).

input_clause(c_7551,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,--p4,--p5]).

input_clause(c_7552,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p7,--p4,--p5,--p6,--p7]).

input_clause(c_7553,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,--p4,--p5]).

input_clause(c_7554,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,--p4,--p5,++p6,--p7]).

input_clause(c_7555,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,--p4,++p6]).

input_clause(c_7556,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,--p4,--p7]).

input_clause(c_7557,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7]).

input_clause(c_7558,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,++p6,--p7]).

input_clause(c_7559,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,--p5,++p6]).

input_clause(c_7560,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,--p5,--p7]).

input_clause(c_7561,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,++p3,--p5]).

input_clause(c_7562,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,++p3,--p5,++p6,--p7]).

input_clause(c_7563,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,++p3,++p6]).

input_clause(c_7564,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,++p3,--p7]).

input_clause(c_7565,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,++p3,--p4]).

input_clause(c_7566,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,++p3,--p4,++p6,--p7]).

input_clause(c_7567,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,++p3,--p4,--p5,++p6]).

input_clause(c_7568,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,++p3,--p4,--p5,--p7]).

input_clause(c_7569,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,++p2,++p3,--p4,--p5]).

input_clause(c_7570,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,++p2,++p3,--p4,--p5,++p6,--p7]).

input_clause(c_7571,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,++p2,++p3,--p4,++p6]).

input_clause(c_7572,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,++p2,++p3,--p4,--p7]).

input_clause(c_7573,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,++p2,++p3]).

input_clause(c_7574,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,++p2,++p3,++p6,--p7]).

input_clause(c_7575,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,++p2,++p3,--p5,++p6]).

input_clause(c_7576,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,++p2,++p3,--p5,--p7]).

input_clause(c_7577,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,++p2,--p5]).

input_clause(c_7578,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,++p2,--p5,++p6,--p7]).

input_clause(c_7579,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,++p2,++p6]).

input_clause(c_7580,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,++p2,--p7]).

input_clause(c_7581,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,++p2,--p4]).

input_clause(c_7582,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,++p2,--p4,++p6,--p7]).

input_clause(c_7583,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,++p2,--p4,--p5,++p6]).

input_clause(c_7584,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,++p2,--p4,--p5,--p7]).

input_clause(c_7585,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,++p1,++p2,--p4,--p5]).

input_clause(c_7586,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,++p1,++p2,--p4,--p5,++p6,--p7]).

input_clause(c_7587,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,++p1,++p2,--p4,++p6]).

input_clause(c_7588,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,++p1,++p2,--p4,--p7]).

input_clause(c_7589,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,++p1,++p2]).

input_clause(c_7590,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,++p1,++p2,++p6,--p7]).

input_clause(c_7591,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,++p1,++p2,--p5,++p6]).

input_clause(c_7592,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,++p1,++p2,--p5,--p7]).

input_clause(c_7593,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,++p1,++p2,++p3,--p5]).

input_clause(c_7594,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,++p1,++p2,++p3,--p5,++p6,--p7]).

input_clause(c_7595,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,++p1,++p2,++p3,++p6]).

input_clause(c_7596,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,++p1,++p2,++p3,--p7]).

input_clause(c_7597,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,++p1,++p2,++p3,--p4]).

input_clause(c_7598,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,++p1,++p2,++p3,--p4,++p6,--p7]).

input_clause(c_7599,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,++p1,++p2,++p3,--p4,--p5,++p6]).

input_clause(c_7600,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,++p1,++p2,++p3,--p4,--p5,--p7]).

input_clause(c_7601,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,++p1,++p3,--p4,--p5]).

input_clause(c_7602,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,++p1,++p3,--p4,--p5,++p6,--p7]).

input_clause(c_7603,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,++p1,++p3,--p4,++p6]).

input_clause(c_7604,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,++p1,++p3,--p4,--p7]).

input_clause(c_7605,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,++p1,++p3]).

input_clause(c_7606,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,++p1,++p3,++p6,--p7]).

input_clause(c_7607,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,++p1,++p3,--p5,++p6]).

input_clause(c_7608,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,++p1,++p3,--p5,--p7]).

input_clause(c_7609,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,++p1,--p5]).

input_clause(c_7610,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,++p1,--p5,++p6,--p7]).

input_clause(c_7611,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,++p1,++p6]).

input_clause(c_7612,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,++p1,--p7]).

input_clause(c_7613,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,++p1,--p4]).

input_clause(c_7614,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,++p1,--p4,++p6,--p7]).

input_clause(c_7615,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,++p1,--p4,--p5,++p6]).

input_clause(c_7616,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p7,++p1,--p4,--p5,--p7]).

input_clause(c_7617,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,++p1,--p4,--p5,++p7]).

input_clause(c_7618,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,++p1,--p4,--p5,++p6]).

input_clause(c_7619,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,++p1,--p4,++p6,++p7]).

input_clause(c_7620,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,++p1,--p4]).

input_clause(c_7621,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,++p1,++p7]).

input_clause(c_7622,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,++p1,++p6]).

input_clause(c_7623,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,++p1,--p5,++p6,++p7]).

input_clause(c_7624,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,++p1,--p5]).

input_clause(c_7625,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,++p1,++p3,--p5,++p7]).

input_clause(c_7626,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,++p1,++p3,--p5,++p6]).

input_clause(c_7627,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,++p1,++p3,++p6,++p7]).

input_clause(c_7628,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,++p1,++p3]).

input_clause(c_7629,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,++p1,++p3,--p4,++p7]).

input_clause(c_7630,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,++p1,++p3,--p4,++p6]).

input_clause(c_7631,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,++p1,++p3,--p4,--p5,++p6,++p7]).

input_clause(c_7632,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,++p1,++p3,--p4,--p5]).

input_clause(c_7633,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,++p1,++p2,++p3,--p4,--p5,++p7]).

input_clause(c_7634,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,++p1,++p2,++p3,--p4,--p5,++p6]).

input_clause(c_7635,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,++p1,++p2,++p3,--p4,++p6,++p7]).

input_clause(c_7636,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,++p1,++p2,++p3,--p4]).

input_clause(c_7637,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,++p1,++p2,++p3,++p7]).

input_clause(c_7638,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,++p1,++p2,++p3,++p6]).

input_clause(c_7639,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,++p1,++p2,++p3,--p5,++p6,++p7]).

input_clause(c_7640,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,++p1,++p2,++p3,--p5]).

input_clause(c_7641,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,++p1,++p2,--p5,++p7]).

input_clause(c_7642,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,++p1,++p2,--p5,++p6]).

input_clause(c_7643,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,++p1,++p2,++p6,++p7]).

input_clause(c_7644,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,++p1,++p2]).

input_clause(c_7645,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,++p1,++p2,--p4,++p7]).

input_clause(c_7646,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,++p1,++p2,--p4,++p6]).

input_clause(c_7647,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,++p1,++p2,--p4,--p5,++p6,++p7]).

input_clause(c_7648,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,++p1,++p2,--p4,--p5]).

input_clause(c_7649,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,++p2,--p4,--p5,++p7]).

input_clause(c_7650,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,++p2,--p4,--p5,++p6]).

input_clause(c_7651,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,++p2,--p4,++p6,++p7]).

input_clause(c_7652,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,++p2,--p4]).

input_clause(c_7653,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,++p2,++p7]).

input_clause(c_7654,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,++p2,++p6]).

input_clause(c_7655,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,++p2,--p5,++p6,++p7]).

input_clause(c_7656,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,++p2,--p5]).

input_clause(c_7657,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,++p2,++p3,--p5,++p7]).

input_clause(c_7658,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,++p2,++p3,--p5,++p6]).

input_clause(c_7659,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,++p2,++p3,++p6,++p7]).

input_clause(c_7660,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,++p2,++p3]).

input_clause(c_7661,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,++p2,++p3,--p4,++p7]).

input_clause(c_7662,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,++p2,++p3,--p4,++p6]).

input_clause(c_7663,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,++p2,++p3,--p4,--p5,++p6,++p7]).

input_clause(c_7664,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,++p2,++p3,--p4,--p5]).

input_clause(c_7665,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,++p3,--p4,--p5,++p7]).

input_clause(c_7666,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,++p3,--p4,--p5,++p6]).

input_clause(c_7667,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,++p3,--p4,++p6,++p7]).

input_clause(c_7668,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,++p3,--p4]).

input_clause(c_7669,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,++p3,++p7]).

input_clause(c_7670,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,++p3,++p6]).

input_clause(c_7671,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,++p3,--p5,++p6,++p7]).

input_clause(c_7672,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,++p3,--p5]).

input_clause(c_7673,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,--p5,++p7]).

input_clause(c_7674,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,--p5,++p6]).

input_clause(c_7675,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,++p6,++p7]).

input_clause(c_7676,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7]).

input_clause(c_7677,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,--p4,++p7]).

input_clause(c_7678,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,--p4,++p6]).

input_clause(c_7679,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,--p4,--p5,++p6,++p7]).

input_clause(c_7680,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p7,--p4,--p5]).

input_clause(c_7681,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,--p5,++p7]).

input_clause(c_7682,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,--p5,++p6]).

input_clause(c_7683,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p6,++p7]).

input_clause(c_7684,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7]).

input_clause(c_7685,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p4,++p7]).

input_clause(c_7686,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p4,++p6]).

input_clause(c_7687,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p4,--p5,++p6,++p7]).

input_clause(c_7688,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p4,--p5]).

input_clause(c_7689,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p3,++p4,--p5,++p7]).

input_clause(c_7690,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p3,++p4,--p5,++p6]).

input_clause(c_7691,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p3,++p4,++p6,++p7]).

input_clause(c_7692,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p3,++p4]).

input_clause(c_7693,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p3,++p7]).

input_clause(c_7694,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p3,++p6]).

input_clause(c_7695,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p3,--p5,++p6,++p7]).

input_clause(c_7696,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p3,--p5]).

input_clause(c_7697,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p2,++p3,--p5,++p7]).

input_clause(c_7698,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p2,++p3,--p5,++p6]).

input_clause(c_7699,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p2,++p3,++p6,++p7]).

input_clause(c_7700,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p2,++p3]).

input_clause(c_7701,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p2,++p3,++p4,++p7]).

input_clause(c_7702,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p2,++p3,++p4,++p6]).

input_clause(c_7703,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p2,++p3,++p4,--p5,++p6,++p7]).

input_clause(c_7704,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p2,++p3,++p4,--p5]).

input_clause(c_7705,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p2,++p4,--p5,++p7]).

input_clause(c_7706,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p2,++p4,--p5,++p6]).

input_clause(c_7707,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p2,++p4,++p6,++p7]).

input_clause(c_7708,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p2,++p4]).

input_clause(c_7709,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p2,++p7]).

input_clause(c_7710,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p2,++p6]).

input_clause(c_7711,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p2,--p5,++p6,++p7]).

input_clause(c_7712,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p2,--p5]).

input_clause(c_7713,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p1,++p2,--p5,++p7]).

input_clause(c_7714,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p1,++p2,--p5,++p6]).

input_clause(c_7715,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p1,++p2,++p6,++p7]).

input_clause(c_7716,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p1,++p2]).

input_clause(c_7717,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p1,++p2,++p4,++p7]).

input_clause(c_7718,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p1,++p2,++p4,++p6]).

input_clause(c_7719,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p1,++p2,++p4,--p5,++p6,++p7]).

input_clause(c_7720,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p1,++p2,++p4,--p5]).

input_clause(c_7721,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p1,++p2,++p3,++p4,--p5,++p7]).

input_clause(c_7722,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p1,++p2,++p3,++p4,--p5,++p6]).

input_clause(c_7723,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p1,++p2,++p3,++p4,++p6,++p7]).

input_clause(c_7724,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p1,++p2,++p3,++p4]).

input_clause(c_7725,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p1,++p2,++p3,++p7]).

input_clause(c_7726,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p1,++p2,++p3,++p6]).

input_clause(c_7727,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p1,++p2,++p3,--p5,++p6,++p7]).

input_clause(c_7728,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p1,++p2,++p3,--p5]).

input_clause(c_7729,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p1,++p3,--p5,++p7]).

input_clause(c_7730,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p1,++p3,--p5,++p6]).

input_clause(c_7731,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p1,++p3,++p6,++p7]).

input_clause(c_7732,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p1,++p3]).

input_clause(c_7733,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p1,++p3,++p4,++p7]).

input_clause(c_7734,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p1,++p3,++p4,++p6]).

input_clause(c_7735,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p1,++p3,++p4,--p5,++p6,++p7]).

input_clause(c_7736,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p1,++p3,++p4,--p5]).

input_clause(c_7737,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p1,++p4,--p5,++p7]).

input_clause(c_7738,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p1,++p4,--p5,++p6]).

input_clause(c_7739,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p1,++p4,++p6,++p7]).

input_clause(c_7740,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p1,++p4]).

input_clause(c_7741,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p1,++p7]).

input_clause(c_7742,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p1,++p6]).

input_clause(c_7743,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p1,--p5,++p6,++p7]).

input_clause(c_7744,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p7,++p1,--p5]).

input_clause(c_7745,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p1,--p5]).

input_clause(c_7746,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p1,--p5,++p6,--p7]).

input_clause(c_7747,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p1,++p6]).

input_clause(c_7748,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p1,--p7]).

input_clause(c_7749,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p1,++p4]).

input_clause(c_7750,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p1,++p4,++p6,--p7]).

input_clause(c_7751,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p1,++p4,--p5,++p6]).

input_clause(c_7752,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p1,++p4,--p5,--p7]).

input_clause(c_7753,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p1,++p3,++p4,--p5]).

input_clause(c_7754,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p1,++p3,++p4,--p5,++p6,--p7]).

input_clause(c_7755,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p1,++p3,++p4,++p6]).

input_clause(c_7756,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p1,++p3,++p4,--p7]).

input_clause(c_7757,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p1,++p3]).

input_clause(c_7758,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p1,++p3,++p6,--p7]).

input_clause(c_7759,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p1,++p3,--p5,++p6]).

input_clause(c_7760,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p1,++p3,--p5,--p7]).

input_clause(c_7761,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p1,++p2,++p3,--p5]).

input_clause(c_7762,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p1,++p2,++p3,--p5,++p6,--p7]).

input_clause(c_7763,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p1,++p2,++p3,++p6]).

input_clause(c_7764,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p1,++p2,++p3,--p7]).

input_clause(c_7765,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p1,++p2,++p3,++p4]).

input_clause(c_7766,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p1,++p2,++p3,++p4,++p6,--p7]).

input_clause(c_7767,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p1,++p2,++p3,++p4,--p5,++p6]).

input_clause(c_7768,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p1,++p2,++p3,++p4,--p5,--p7]).

input_clause(c_7769,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p1,++p2,++p4,--p5]).

input_clause(c_7770,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p1,++p2,++p4,--p5,++p6,--p7]).

input_clause(c_7771,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p1,++p2,++p4,++p6]).

input_clause(c_7772,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p1,++p2,++p4,--p7]).

input_clause(c_7773,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p1,++p2]).

input_clause(c_7774,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p1,++p2,++p6,--p7]).

input_clause(c_7775,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p1,++p2,--p5,++p6]).

input_clause(c_7776,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p1,++p2,--p5,--p7]).

input_clause(c_7777,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p2,--p5]).

input_clause(c_7778,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p2,--p5,++p6,--p7]).

input_clause(c_7779,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p2,++p6]).

input_clause(c_7780,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p2,--p7]).

input_clause(c_7781,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p2,++p4]).

input_clause(c_7782,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p2,++p4,++p6,--p7]).

input_clause(c_7783,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p2,++p4,--p5,++p6]).

input_clause(c_7784,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p2,++p4,--p5,--p7]).

input_clause(c_7785,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p2,++p3,++p4,--p5]).

input_clause(c_7786,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p2,++p3,++p4,--p5,++p6,--p7]).

input_clause(c_7787,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p2,++p3,++p4,++p6]).

input_clause(c_7788,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p2,++p3,++p4,--p7]).

input_clause(c_7789,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p2,++p3]).

input_clause(c_7790,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p2,++p3,++p6,--p7]).

input_clause(c_7791,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p2,++p3,--p5,++p6]).

input_clause(c_7792,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p2,++p3,--p5,--p7]).

input_clause(c_7793,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p3,--p5]).

input_clause(c_7794,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p3,--p5,++p6,--p7]).

input_clause(c_7795,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p3,++p6]).

input_clause(c_7796,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p3,--p7]).

input_clause(c_7797,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p3,++p4]).

input_clause(c_7798,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p3,++p4,++p6,--p7]).

input_clause(c_7799,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p3,++p4,--p5,++p6]).

input_clause(c_7800,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p3,++p4,--p5,--p7]).

input_clause(c_7801,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p4,--p5]).

input_clause(c_7802,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p4,--p5,++p6,--p7]).

input_clause(c_7803,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p4,++p6]).

input_clause(c_7804,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p4,--p7]).

input_clause(c_7805,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7]).

input_clause(c_7806,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,++p6,--p7]).

input_clause(c_7807,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,--p5,++p6]).

input_clause(c_7808,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p7,--p5,--p7]).

input_clause(c_7809,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,--p5,--p6]).

input_clause(c_7810,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,--p5,--p7]).

input_clause(c_7811,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7]).

input_clause(c_7812,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,--p6,--p7]).

input_clause(c_7813,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p4,--p6]).

input_clause(c_7814,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p4,--p7]).

input_clause(c_7815,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p4,--p5]).

input_clause(c_7816,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p4,--p5,--p6,--p7]).

input_clause(c_7817,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p3,++p4,--p5,--p6]).

input_clause(c_7818,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p3,++p4,--p5,--p7]).

input_clause(c_7819,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p3,++p4]).

input_clause(c_7820,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p3,++p4,--p6,--p7]).

input_clause(c_7821,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p3,--p6]).

input_clause(c_7822,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p3,--p7]).

input_clause(c_7823,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p3,--p5]).

input_clause(c_7824,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p3,--p5,--p6,--p7]).

input_clause(c_7825,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p2,++p3,--p5,--p6]).

input_clause(c_7826,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p2,++p3,--p5,--p7]).

input_clause(c_7827,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p2,++p3]).

input_clause(c_7828,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p2,++p3,--p6,--p7]).

input_clause(c_7829,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p2,++p3,++p4,--p6]).

input_clause(c_7830,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p2,++p3,++p4,--p7]).

input_clause(c_7831,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p2,++p3,++p4,--p5]).

input_clause(c_7832,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p2,++p3,++p4,--p5,--p6,--p7]).

input_clause(c_7833,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p2,++p4,--p5,--p6]).

input_clause(c_7834,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p2,++p4,--p5,--p7]).

input_clause(c_7835,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p2,++p4]).

input_clause(c_7836,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p2,++p4,--p6,--p7]).

input_clause(c_7837,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p2,--p6]).

input_clause(c_7838,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p2,--p7]).

input_clause(c_7839,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p2,--p5]).

input_clause(c_7840,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p2,--p5,--p6,--p7]).

input_clause(c_7841,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p1,++p2,--p5,--p6]).

input_clause(c_7842,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p1,++p2,--p5,--p7]).

input_clause(c_7843,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p1,++p2]).

input_clause(c_7844,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p1,++p2,--p6,--p7]).

input_clause(c_7845,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p1,++p2,++p4,--p6]).

input_clause(c_7846,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p1,++p2,++p4,--p7]).

input_clause(c_7847,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p1,++p2,++p4,--p5]).

input_clause(c_7848,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p1,++p2,++p4,--p5,--p6,--p7]).

input_clause(c_7849,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p1,++p2,++p3,++p4,--p5,--p6]).

input_clause(c_7850,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p1,++p2,++p3,++p4,--p5,--p7]).

input_clause(c_7851,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p1,++p2,++p3,++p4]).

input_clause(c_7852,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p1,++p2,++p3,++p4,--p6,--p7]).

input_clause(c_7853,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p1,++p2,++p3,--p6]).

input_clause(c_7854,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p1,++p2,++p3,--p7]).

input_clause(c_7855,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p1,++p2,++p3,--p5]).

input_clause(c_7856,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p1,++p2,++p3,--p5,--p6,--p7]).

input_clause(c_7857,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p1,++p3,--p5,--p6]).

input_clause(c_7858,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p1,++p3,--p5,--p7]).

input_clause(c_7859,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p1,++p3]).

input_clause(c_7860,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p1,++p3,--p6,--p7]).

input_clause(c_7861,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p1,++p3,++p4,--p6]).

input_clause(c_7862,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p1,++p3,++p4,--p7]).

input_clause(c_7863,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p1,++p3,++p4,--p5]).

input_clause(c_7864,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p1,++p3,++p4,--p5,--p6,--p7]).

input_clause(c_7865,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p1,++p4,--p5,--p6]).

input_clause(c_7866,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p1,++p4,--p5,--p7]).

input_clause(c_7867,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p1,++p4]).

input_clause(c_7868,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p1,++p4,--p6,--p7]).

input_clause(c_7869,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p1,--p6]).

input_clause(c_7870,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p1,--p7]).

input_clause(c_7871,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p1,--p5]).

input_clause(c_7872,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p7,++p1,--p5,--p6,--p7]).

input_clause(c_7873,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p1,--p5,--p6,++p7]).

input_clause(c_7874,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p1,--p5]).

input_clause(c_7875,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p1,++p7]).

input_clause(c_7876,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p1,--p6]).

input_clause(c_7877,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p1,++p4,--p6,++p7]).

input_clause(c_7878,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p1,++p4]).

input_clause(c_7879,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p1,++p4,--p5,++p7]).

input_clause(c_7880,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p1,++p4,--p5,--p6]).

input_clause(c_7881,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p1,++p3,++p4,--p5,--p6,++p7]).

input_clause(c_7882,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p1,++p3,++p4,--p5]).

input_clause(c_7883,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p1,++p3,++p4,++p7]).

input_clause(c_7884,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p1,++p3,++p4,--p6]).

input_clause(c_7885,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p1,++p3,--p6,++p7]).

input_clause(c_7886,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p1,++p3]).

input_clause(c_7887,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p1,++p3,--p5,++p7]).

input_clause(c_7888,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p1,++p3,--p5,--p6]).

input_clause(c_7889,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p1,++p2,++p3,--p5,--p6,++p7]).

input_clause(c_7890,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p1,++p2,++p3,--p5]).

input_clause(c_7891,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p1,++p2,++p3,++p7]).

input_clause(c_7892,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p1,++p2,++p3,--p6]).

input_clause(c_7893,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p1,++p2,++p3,++p4,--p6,++p7]).

input_clause(c_7894,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p1,++p2,++p3,++p4]).

input_clause(c_7895,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p1,++p2,++p3,++p4,--p5,++p7]).

input_clause(c_7896,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p1,++p2,++p3,++p4,--p5,--p6]).

input_clause(c_7897,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p1,++p2,++p4,--p5,--p6,++p7]).

input_clause(c_7898,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p1,++p2,++p4,--p5]).

input_clause(c_7899,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p1,++p2,++p4,++p7]).

input_clause(c_7900,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p1,++p2,++p4,--p6]).

input_clause(c_7901,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p1,++p2,--p6,++p7]).

input_clause(c_7902,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p1,++p2]).

input_clause(c_7903,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p1,++p2,--p5,++p7]).

input_clause(c_7904,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p1,++p2,--p5,--p6]).

input_clause(c_7905,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p2,--p5,--p6,++p7]).

input_clause(c_7906,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p2,--p5]).

input_clause(c_7907,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p2,++p7]).

input_clause(c_7908,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p2,--p6]).

input_clause(c_7909,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p2,++p4,--p6,++p7]).

input_clause(c_7910,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p2,++p4]).

input_clause(c_7911,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p2,++p4,--p5,++p7]).

input_clause(c_7912,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p2,++p4,--p5,--p6]).

input_clause(c_7913,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p2,++p3,++p4,--p5,--p6,++p7]).

input_clause(c_7914,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p2,++p3,++p4,--p5]).

input_clause(c_7915,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p2,++p3,++p4,++p7]).

input_clause(c_7916,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p2,++p3,++p4,--p6]).

input_clause(c_7917,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p2,++p3,--p6,++p7]).

input_clause(c_7918,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p2,++p3]).

input_clause(c_7919,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p2,++p3,--p5,++p7]).

input_clause(c_7920,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p2,++p3,--p5,--p6]).

input_clause(c_7921,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p3,--p5,--p6,++p7]).

input_clause(c_7922,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p3,--p5]).

input_clause(c_7923,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p3,++p7]).

input_clause(c_7924,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p3,--p6]).

input_clause(c_7925,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p3,++p4,--p6,++p7]).

input_clause(c_7926,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p3,++p4]).

input_clause(c_7927,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p3,++p4,--p5,++p7]).

input_clause(c_7928,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p3,++p4,--p5,--p6]).

input_clause(c_7929,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p4,--p5,--p6,++p7]).

input_clause(c_7930,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p4,--p5]).

input_clause(c_7931,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p4,++p7]).

input_clause(c_7932,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,++p4,--p6]).

input_clause(c_7933,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,--p6,++p7]).

input_clause(c_7934,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7]).

input_clause(c_7935,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,--p5,++p7]).

input_clause(c_7936,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p7,--p5,--p6]).

input_clause(c_7937,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,--p6,++p7]).

input_clause(c_7938,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7]).

input_clause(c_7939,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p5,++p7]).

input_clause(c_7940,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p5,--p6]).

input_clause(c_7941,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p4,++p5,--p6,++p7]).

input_clause(c_7942,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p4,++p5]).

input_clause(c_7943,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p4,++p7]).

input_clause(c_7944,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p4,--p6]).

input_clause(c_7945,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p3,++p4,--p6,++p7]).

input_clause(c_7946,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p3,++p4]).

input_clause(c_7947,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p3,++p4,++p5,++p7]).

input_clause(c_7948,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p3,++p4,++p5,--p6]).

input_clause(c_7949,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p3,++p5,--p6,++p7]).

input_clause(c_7950,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p3,++p5]).

input_clause(c_7951,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p3,++p7]).

input_clause(c_7952,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p3,--p6]).

input_clause(c_7953,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p2,++p3,--p6,++p7]).

input_clause(c_7954,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p2,++p3]).

input_clause(c_7955,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p2,++p3,++p5,++p7]).

input_clause(c_7956,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p2,++p3,++p5,--p6]).

input_clause(c_7957,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p2,++p3,++p4,++p5,--p6,++p7]).

input_clause(c_7958,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p2,++p3,++p4,++p5]).

input_clause(c_7959,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p2,++p3,++p4,++p7]).

input_clause(c_7960,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p2,++p3,++p4,--p6]).

input_clause(c_7961,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p2,++p4,--p6,++p7]).

input_clause(c_7962,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p2,++p4]).

input_clause(c_7963,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p2,++p4,++p5,++p7]).

input_clause(c_7964,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p2,++p4,++p5,--p6]).

input_clause(c_7965,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p2,++p5,--p6,++p7]).

input_clause(c_7966,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p2,++p5]).

input_clause(c_7967,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p2,++p7]).

input_clause(c_7968,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p2,--p6]).

input_clause(c_7969,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p1,++p2,--p6,++p7]).

input_clause(c_7970,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p1,++p2]).

input_clause(c_7971,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p1,++p2,++p5,++p7]).

input_clause(c_7972,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p1,++p2,++p5,--p6]).

input_clause(c_7973,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p1,++p2,++p4,++p5,--p6,++p7]).

input_clause(c_7974,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p1,++p2,++p4,++p5]).

input_clause(c_7975,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p1,++p2,++p4,++p7]).

input_clause(c_7976,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p1,++p2,++p4,--p6]).

input_clause(c_7977,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p1,++p2,++p3,++p4,--p6,++p7]).

input_clause(c_7978,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p1,++p2,++p3,++p4]).

input_clause(c_7979,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p1,++p2,++p3,++p4,++p5,++p7]).

input_clause(c_7980,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p1,++p2,++p3,++p4,++p5,--p6]).

input_clause(c_7981,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p1,++p2,++p3,++p5,--p6,++p7]).

input_clause(c_7982,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p1,++p2,++p3,++p5]).

input_clause(c_7983,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p1,++p2,++p3,++p7]).

input_clause(c_7984,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p1,++p2,++p3,--p6]).

input_clause(c_7985,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p1,++p3,--p6,++p7]).

input_clause(c_7986,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p1,++p3]).

input_clause(c_7987,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p1,++p3,++p5,++p7]).

input_clause(c_7988,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p1,++p3,++p5,--p6]).

input_clause(c_7989,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p1,++p3,++p4,++p5,--p6,++p7]).

input_clause(c_7990,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p1,++p3,++p4,++p5]).

input_clause(c_7991,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p1,++p3,++p4,++p7]).

input_clause(c_7992,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p1,++p3,++p4,--p6]).

input_clause(c_7993,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p1,++p4,--p6,++p7]).

input_clause(c_7994,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p1,++p4]).

input_clause(c_7995,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p1,++p4,++p5,++p7]).

input_clause(c_7996,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p1,++p4,++p5,--p6]).

input_clause(c_7997,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p1,++p5,--p6,++p7]).

input_clause(c_7998,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p1,++p5]).

input_clause(c_7999,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p1,++p7]).

input_clause(c_8000,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,--p7,++p1,--p6]).

input_clause(c_8001,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p1,--p6]).

input_clause(c_8002,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p1,--p7]).

input_clause(c_8003,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p1,++p5]).

input_clause(c_8004,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p1,++p5,--p6,--p7]).

input_clause(c_8005,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p1,++p4,++p5,--p6]).

input_clause(c_8006,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p1,++p4,++p5,--p7]).

input_clause(c_8007,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p1,++p4]).

input_clause(c_8008,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p1,++p4,--p6,--p7]).

input_clause(c_8009,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p1,++p3,++p4,--p6]).

input_clause(c_8010,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p1,++p3,++p4,--p7]).

input_clause(c_8011,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p1,++p3,++p4,++p5]).

input_clause(c_8012,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p1,++p3,++p4,++p5,--p6,--p7]).

input_clause(c_8013,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p1,++p3,++p5,--p6]).

input_clause(c_8014,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p1,++p3,++p5,--p7]).

input_clause(c_8015,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p1,++p3]).

input_clause(c_8016,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p1,++p3,--p6,--p7]).

input_clause(c_8017,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p1,++p2,++p3,--p6]).

input_clause(c_8018,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p1,++p2,++p3,--p7]).

input_clause(c_8019,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p1,++p2,++p3,++p5]).

input_clause(c_8020,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p1,++p2,++p3,++p5,--p6,--p7]).

input_clause(c_8021,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p1,++p2,++p3,++p4,++p5,--p6]).

input_clause(c_8022,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p1,++p2,++p3,++p4,++p5,--p7]).

input_clause(c_8023,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p1,++p2,++p3,++p4]).

input_clause(c_8024,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p1,++p2,++p3,++p4,--p6,--p7]).

input_clause(c_8025,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p1,++p2,++p4,--p6]).

input_clause(c_8026,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p1,++p2,++p4,--p7]).

input_clause(c_8027,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p1,++p2,++p4,++p5]).

input_clause(c_8028,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p1,++p2,++p4,++p5,--p6,--p7]).

input_clause(c_8029,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p1,++p2,++p5,--p6]).

input_clause(c_8030,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p1,++p2,++p5,--p7]).

input_clause(c_8031,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p1,++p2]).

input_clause(c_8032,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p1,++p2,--p6,--p7]).

input_clause(c_8033,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p2,--p6]).

input_clause(c_8034,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p2,--p7]).

input_clause(c_8035,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p2,++p5]).

input_clause(c_8036,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p2,++p5,--p6,--p7]).

input_clause(c_8037,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p2,++p4,++p5,--p6]).

input_clause(c_8038,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p2,++p4,++p5,--p7]).

input_clause(c_8039,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p2,++p4]).

input_clause(c_8040,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p2,++p4,--p6,--p7]).

input_clause(c_8041,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p2,++p3,++p4,--p6]).

input_clause(c_8042,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p2,++p3,++p4,--p7]).

input_clause(c_8043,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p2,++p3,++p4,++p5]).

input_clause(c_8044,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p2,++p3,++p4,++p5,--p6,--p7]).

input_clause(c_8045,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p2,++p3,++p5,--p6]).

input_clause(c_8046,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p2,++p3,++p5,--p7]).

input_clause(c_8047,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p2,++p3]).

input_clause(c_8048,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p2,++p3,--p6,--p7]).

input_clause(c_8049,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p3,--p6]).

input_clause(c_8050,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p3,--p7]).

input_clause(c_8051,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p3,++p5]).

input_clause(c_8052,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p3,++p5,--p6,--p7]).

input_clause(c_8053,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p3,++p4,++p5,--p6]).

input_clause(c_8054,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p3,++p4,++p5,--p7]).

input_clause(c_8055,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p3,++p4]).

input_clause(c_8056,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p3,++p4,--p6,--p7]).

input_clause(c_8057,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p4,--p6]).

input_clause(c_8058,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p4,--p7]).

input_clause(c_8059,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p4,++p5]).

input_clause(c_8060,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p4,++p5,--p6,--p7]).

input_clause(c_8061,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p5,--p6]).

input_clause(c_8062,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,++p5,--p7]).

input_clause(c_8063,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7]).

input_clause(c_8064,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p7,--p6,--p7]).

input_clause(c_8065,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7]).

input_clause(c_8066,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p6,--p7]).

input_clause(c_8067,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p5,++p6]).

input_clause(c_8068,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p5,--p7]).

input_clause(c_8069,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p4,++p5]).

input_clause(c_8070,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p4,++p5,++p6,--p7]).

input_clause(c_8071,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p4,++p6]).

input_clause(c_8072,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p4,--p7]).

input_clause(c_8073,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p3,++p4]).

input_clause(c_8074,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p3,++p4,++p6,--p7]).

input_clause(c_8075,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p3,++p4,++p5,++p6]).

input_clause(c_8076,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p3,++p4,++p5,--p7]).

input_clause(c_8077,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p3,++p5]).

input_clause(c_8078,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p3,++p5,++p6,--p7]).

input_clause(c_8079,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p3,++p6]).

input_clause(c_8080,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p3,--p7]).

input_clause(c_8081,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p2,++p3]).

input_clause(c_8082,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p2,++p3,++p6,--p7]).

input_clause(c_8083,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p2,++p3,++p5,++p6]).

input_clause(c_8084,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p2,++p3,++p5,--p7]).

input_clause(c_8085,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p2,++p3,++p4,++p5]).

input_clause(c_8086,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p2,++p3,++p4,++p5,++p6,--p7]).

input_clause(c_8087,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p2,++p3,++p4,++p6]).

input_clause(c_8088,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p2,++p3,++p4,--p7]).

input_clause(c_8089,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p2,++p4]).

input_clause(c_8090,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p2,++p4,++p6,--p7]).

input_clause(c_8091,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p2,++p4,++p5,++p6]).

input_clause(c_8092,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p2,++p4,++p5,--p7]).

input_clause(c_8093,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p2,++p5]).

input_clause(c_8094,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p2,++p5,++p6,--p7]).

input_clause(c_8095,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p2,++p6]).

input_clause(c_8096,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p2,--p7]).

input_clause(c_8097,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p1,++p2]).

input_clause(c_8098,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p1,++p2,++p6,--p7]).

input_clause(c_8099,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p1,++p2,++p5,++p6]).

input_clause(c_8100,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p1,++p2,++p5,--p7]).

input_clause(c_8101,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p1,++p2,++p4,++p5]).

input_clause(c_8102,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p1,++p2,++p4,++p5,++p6,--p7]).

input_clause(c_8103,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p1,++p2,++p4,++p6]).

input_clause(c_8104,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p1,++p2,++p4,--p7]).

input_clause(c_8105,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p1,++p2,++p3,++p4]).

input_clause(c_8106,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p1,++p2,++p3,++p4,++p6,--p7]).

input_clause(c_8107,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p1,++p2,++p3,++p4,++p5,++p6]).

input_clause(c_8108,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p1,++p2,++p3,++p4,++p5,--p7]).

input_clause(c_8109,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p1,++p2,++p3,++p5]).

input_clause(c_8110,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p1,++p2,++p3,++p5,++p6,--p7]).

input_clause(c_8111,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p1,++p2,++p3,++p6]).

input_clause(c_8112,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p1,++p2,++p3,--p7]).

input_clause(c_8113,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p1,++p3]).

input_clause(c_8114,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p1,++p3,++p6,--p7]).

input_clause(c_8115,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p1,++p3,++p5,++p6]).

input_clause(c_8116,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p1,++p3,++p5,--p7]).

input_clause(c_8117,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p1,++p3,++p4,++p5]).

input_clause(c_8118,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p1,++p3,++p4,++p5,++p6,--p7]).

input_clause(c_8119,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p1,++p3,++p4,++p6]).

input_clause(c_8120,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p1,++p3,++p4,--p7]).

input_clause(c_8121,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p1,++p4]).

input_clause(c_8122,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p1,++p4,++p6,--p7]).

input_clause(c_8123,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p1,++p4,++p5,++p6]).

input_clause(c_8124,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p1,++p4,++p5,--p7]).

input_clause(c_8125,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p1,++p5]).

input_clause(c_8126,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p1,++p5,++p6,--p7]).

input_clause(c_8127,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p1,++p6]).

input_clause(c_8128,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p7,++p1,--p7]).

input_clause(c_8129,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p1,++p7]).

input_clause(c_8130,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p1,++p6]).

input_clause(c_8131,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p1,++p5,++p6,++p7]).

input_clause(c_8132,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p1,++p5]).

input_clause(c_8133,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p1,++p4,++p5,++p7]).

input_clause(c_8134,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p1,++p4,++p5,++p6]).

input_clause(c_8135,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p1,++p4,++p6,++p7]).

input_clause(c_8136,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p1,++p4]).

input_clause(c_8137,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p1,++p3,++p4,++p7]).

input_clause(c_8138,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p1,++p3,++p4,++p6]).

input_clause(c_8139,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p1,++p3,++p4,++p5,++p6,++p7]).

input_clause(c_8140,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p1,++p3,++p4,++p5]).

input_clause(c_8141,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p1,++p3,++p5,++p7]).

input_clause(c_8142,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p1,++p3,++p5,++p6]).

input_clause(c_8143,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p1,++p3,++p6,++p7]).

input_clause(c_8144,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p1,++p3]).

input_clause(c_8145,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p1,++p2,++p3,++p7]).

input_clause(c_8146,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p1,++p2,++p3,++p6]).

input_clause(c_8147,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p1,++p2,++p3,++p5,++p6,++p7]).

input_clause(c_8148,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p1,++p2,++p3,++p5]).

input_clause(c_8149,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p1,++p2,++p3,++p4,++p5,++p7]).

input_clause(c_8150,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p1,++p2,++p3,++p4,++p5,++p6]).

input_clause(c_8151,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p1,++p2,++p3,++p4,++p6,++p7]).

input_clause(c_8152,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p1,++p2,++p3,++p4]).

input_clause(c_8153,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p1,++p2,++p4,++p7]).

input_clause(c_8154,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p1,++p2,++p4,++p6]).

input_clause(c_8155,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p1,++p2,++p4,++p5,++p6,++p7]).

input_clause(c_8156,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p1,++p2,++p4,++p5]).

input_clause(c_8157,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p1,++p2,++p5,++p7]).

input_clause(c_8158,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p1,++p2,++p5,++p6]).

input_clause(c_8159,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p1,++p2,++p6,++p7]).

input_clause(c_8160,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p1,++p2]).

input_clause(c_8161,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p2,++p7]).

input_clause(c_8162,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p2,++p6]).

input_clause(c_8163,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p2,++p5,++p6,++p7]).

input_clause(c_8164,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p2,++p5]).

input_clause(c_8165,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p2,++p4,++p5,++p7]).

input_clause(c_8166,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p2,++p4,++p5,++p6]).

input_clause(c_8167,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p2,++p4,++p6,++p7]).

input_clause(c_8168,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p2,++p4]).

input_clause(c_8169,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p2,++p3,++p4,++p7]).

input_clause(c_8170,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p2,++p3,++p4,++p6]).

input_clause(c_8171,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p2,++p3,++p4,++p5,++p6,++p7]).

input_clause(c_8172,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p2,++p3,++p4,++p5]).

input_clause(c_8173,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p2,++p3,++p5,++p7]).

input_clause(c_8174,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p2,++p3,++p5,++p6]).

input_clause(c_8175,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p2,++p3,++p6,++p7]).

input_clause(c_8176,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p2,++p3]).

input_clause(c_8177,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p3,++p7]).

input_clause(c_8178,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p3,++p6]).

input_clause(c_8179,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p3,++p5,++p6,++p7]).

input_clause(c_8180,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p3,++p5]).

input_clause(c_8181,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p3,++p4,++p5,++p7]).

input_clause(c_8182,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p3,++p4,++p5,++p6]).

input_clause(c_8183,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p3,++p4,++p6,++p7]).

input_clause(c_8184,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p3,++p4]).

input_clause(c_8185,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p4,++p7]).

input_clause(c_8186,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p4,++p6]).

input_clause(c_8187,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p4,++p5,++p6,++p7]).

input_clause(c_8188,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p4,++p5]).

input_clause(c_8189,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p5,++p7]).

input_clause(c_8190,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p5,++p6]).

input_clause(c_8191,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7,++p6,++p7]).

input_clause(c_8192,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,--p7]).
%--------------------------------------------------------------------------
