%--------------------------------------------------------------------------
% File     : SYN007=FPell71-1.006 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Syntactic
% Problem  : Pelletier Problem 71
% Version  : Theorem formulation : For N = 6.
% English  : Clausal forms of statements of the form :
%            (p1 <-> (p2 <->...(pN <-> (p1 <-> (p2 <->...<-> pN)...)

% Refs     : Pelletier F.J. (1986), Seventy-Five Problems for Testing 
%            Automatic Theorem Provers, Journal of Automated Reasoning 
%            2(2), 191-216.
%          : Urquhart A. (1987), Hard Examples for Resolution, Journal 
%            of the ACM 34(1), 209-219.
% Source   : [Pelletier, 1986]
% Names    : Pelletier 71 [Pelletier, 1986]

% Status   : 
% Syntax   : Number of clauses           : 2048 (2041 non-Horn)(   0 unit)
%            Number of literals          : 18432 (   0 equality)
%            Number of predicate symbols :    6 (   6 propositional)
%            Number of function symbols  :    0 (   0 constant)
%            Number of variables         :    0 (   0 singleton)
%            Maximal clause size         :   12
%            Maximal term depth          :    0

% Comments : The number of distinct letters in U-N is N. The number 
%            of occurrences of sentence letters in 2N. The number 
%            of clauses goes up dramatically as N increases, but I don't 
%            think it shows that the problems are dramatically more 
%            difficult as N increases. Rather, it's that the awkward 
%            clause form representation comes to the fore most 
%            dramatically with embedded biconditionals. On all other 
%            measures of complexity, one should say that the problems 
%            increase linearly in difficulty. Urquhart says that the proof 
%            size of any resolution system increases exponentially with 
%            increase in N.
%          : This problem can also be done in terms of graphs, 
%            as described in Pelletier Problem 74.
%--------------------------------------------------------------------------
input_clause(c_1,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p1,++p6]).

input_clause(c_2,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p1,++p5]).

input_clause(c_3,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p1,++p4,++p5,++p6]).

input_clause(c_4,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p1,++p4]).

input_clause(c_5,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p1,++p3,++p4,++p6]).

input_clause(c_6,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p1,++p3,++p4,++p5]).

input_clause(c_7,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p1,++p3,++p5,++p6]).

input_clause(c_8,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p1,++p3]).

input_clause(c_9,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p1,++p2,++p3,++p6]).

input_clause(c_10,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p1,++p2,++p3,++p5]).

input_clause(c_11,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p1,++p2,++p3,++p4,++p5,++p6]).

input_clause(c_12,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p1,++p2,++p3,++p4]).

input_clause(c_13,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p1,++p2,++p4,++p6]).

input_clause(c_14,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p1,++p2,++p4,++p5]).

input_clause(c_15,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p1,++p2,++p5,++p6]).

input_clause(c_16,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,--p1,++p2]).

input_clause(c_17,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p2,++p6]).

input_clause(c_18,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p2,++p5]).

input_clause(c_19,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p2,++p4,++p5,++p6]).

input_clause(c_20,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p2,++p4]).

input_clause(c_21,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p2,++p3,++p4,++p6]).

input_clause(c_22,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p2,++p3,++p4,++p5]).

input_clause(c_23,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p2,++p3,++p5,++p6]).

input_clause(c_24,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p2,++p3]).

input_clause(c_25,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p3,++p6]).

input_clause(c_26,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p3,++p5]).

input_clause(c_27,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p3,++p4,++p5,++p6]).

input_clause(c_28,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p3,++p4]).

input_clause(c_29,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p4,++p6]).

input_clause(c_30,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p4,++p5]).

input_clause(c_31,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6,++p5,++p6]).

input_clause(c_32,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p6]).

input_clause(c_33,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6]).

input_clause(c_34,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p5,--p6]).

input_clause(c_35,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p4,++p5]).

input_clause(c_36,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p4,--p6]).

input_clause(c_37,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p3,++p4]).

input_clause(c_38,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p3,++p4,++p5,--p6]).

input_clause(c_39,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p3,++p5]).

input_clause(c_40,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p3,--p6]).

input_clause(c_41,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p2,++p3]).

input_clause(c_42,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p2,++p3,++p5,--p6]).

input_clause(c_43,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p2,++p3,++p4,++p5]).

input_clause(c_44,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p2,++p3,++p4,--p6]).

input_clause(c_45,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p2,++p4]).

input_clause(c_46,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p2,++p4,++p5,--p6]).

input_clause(c_47,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p2,++p5]).

input_clause(c_48,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,++p2,--p6]).

input_clause(c_49,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p1,++p2]).

input_clause(c_50,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p1,++p2,++p5,--p6]).

input_clause(c_51,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p1,++p2,++p4,++p5]).

input_clause(c_52,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p1,++p2,++p4,--p6]).

input_clause(c_53,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p1,++p2,++p3,++p4]).

input_clause(c_54,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p1,++p2,++p3,++p4,++p5,--p6]).

input_clause(c_55,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p1,++p2,++p3,++p5]).

input_clause(c_56,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p1,++p2,++p3,--p6]).

input_clause(c_57,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p1,++p3]).

input_clause(c_58,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p1,++p3,++p5,--p6]).

input_clause(c_59,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p1,++p3,++p4,++p5]).

input_clause(c_60,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p1,++p3,++p4,--p6]).

input_clause(c_61,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p1,++p4]).

input_clause(c_62,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p1,++p4,++p5,--p6]).

input_clause(c_63,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p1,++p5]).

input_clause(c_64,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p6,--p1,--p6]).

input_clause(c_65,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p1,--p5]).

input_clause(c_66,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p1,--p6]).

input_clause(c_67,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p1,++p4]).

input_clause(c_68,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p1,++p4,--p5,--p6]).

input_clause(c_69,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p1,++p3,++p4,--p5]).

input_clause(c_70,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p1,++p3,++p4,--p6]).

input_clause(c_71,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p1,++p3]).

input_clause(c_72,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p1,++p3,--p5,--p6]).

input_clause(c_73,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p1,++p2,++p3,--p5]).

input_clause(c_74,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p1,++p2,++p3,--p6]).

input_clause(c_75,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p1,++p2,++p3,++p4]).

input_clause(c_76,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p1,++p2,++p3,++p4,--p5,--p6]).

input_clause(c_77,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p1,++p2,++p4,--p5]).

input_clause(c_78,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p1,++p2,++p4,--p6]).

input_clause(c_79,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p1,++p2]).

input_clause(c_80,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p1,++p2,--p5,--p6]).

input_clause(c_81,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p2,--p5]).

input_clause(c_82,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p2,--p6]).

input_clause(c_83,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p2,++p4]).

input_clause(c_84,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p2,++p4,--p5,--p6]).

input_clause(c_85,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p2,++p3,++p4,--p5]).

input_clause(c_86,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p2,++p3,++p4,--p6]).

input_clause(c_87,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p2,++p3]).

input_clause(c_88,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p2,++p3,--p5,--p6]).

input_clause(c_89,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p3,--p5]).

input_clause(c_90,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p3,--p6]).

input_clause(c_91,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p3,++p4]).

input_clause(c_92,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p3,++p4,--p5,--p6]).

input_clause(c_93,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p4,--p5]).

input_clause(c_94,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,++p4,--p6]).

input_clause(c_95,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6]).

input_clause(c_96,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p6,--p5,--p6]).

input_clause(c_97,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p5,++p6]).

input_clause(c_98,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6]).

input_clause(c_99,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p4,++p6]).

input_clause(c_100,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p4,--p5]).

input_clause(c_101,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p3,++p4,--p5,++p6]).

input_clause(c_102,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p3,++p4]).

input_clause(c_103,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p3,++p6]).

input_clause(c_104,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p3,--p5]).

input_clause(c_105,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p2,++p3,--p5,++p6]).

input_clause(c_106,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p2,++p3]).

input_clause(c_107,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p2,++p3,++p4,++p6]).

input_clause(c_108,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p2,++p3,++p4,--p5]).

input_clause(c_109,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p2,++p4,--p5,++p6]).

input_clause(c_110,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p2,++p4]).

input_clause(c_111,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p2,++p6]).

input_clause(c_112,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,++p2,--p5]).

input_clause(c_113,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p1,++p2,--p5,++p6]).

input_clause(c_114,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p1,++p2]).

input_clause(c_115,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p1,++p2,++p4,++p6]).

input_clause(c_116,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p1,++p2,++p4,--p5]).

input_clause(c_117,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p1,++p2,++p3,++p4,--p5,++p6]).

input_clause(c_118,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p1,++p2,++p3,++p4]).

input_clause(c_119,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p1,++p2,++p3,++p6]).

input_clause(c_120,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p1,++p2,++p3,--p5]).

input_clause(c_121,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p1,++p3,--p5,++p6]).

input_clause(c_122,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p1,++p3]).

input_clause(c_123,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p1,++p3,++p4,++p6]).

input_clause(c_124,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p1,++p3,++p4,--p5]).

input_clause(c_125,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p1,++p4,--p5,++p6]).

input_clause(c_126,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p1,++p4]).

input_clause(c_127,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p1,++p6]).

input_clause(c_128,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p6,--p1,--p5]).

input_clause(c_129,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p1,--p4,--p5,++p6]).

input_clause(c_130,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p1,--p4]).

input_clause(c_131,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p1,++p6]).

input_clause(c_132,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p1,--p5]).

input_clause(c_133,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p1,++p3,--p5,++p6]).

input_clause(c_134,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p1,++p3]).

input_clause(c_135,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p1,++p3,--p4,++p6]).

input_clause(c_136,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p1,++p3,--p4,--p5]).

input_clause(c_137,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p1,++p2,++p3,--p4,--p5,++p6]).

input_clause(c_138,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p1,++p2,++p3,--p4]).

input_clause(c_139,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p1,++p2,++p3,++p6]).

input_clause(c_140,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p1,++p2,++p3,--p5]).

input_clause(c_141,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p1,++p2,--p5,++p6]).

input_clause(c_142,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p1,++p2]).

input_clause(c_143,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p1,++p2,--p4,++p6]).

input_clause(c_144,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p1,++p2,--p4,--p5]).

input_clause(c_145,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p2,--p4,--p5,++p6]).

input_clause(c_146,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p2,--p4]).

input_clause(c_147,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p2,++p6]).

input_clause(c_148,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p2,--p5]).

input_clause(c_149,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p2,++p3,--p5,++p6]).

input_clause(c_150,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p2,++p3]).

input_clause(c_151,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p2,++p3,--p4,++p6]).

input_clause(c_152,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p2,++p3,--p4,--p5]).

input_clause(c_153,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p3,--p4,--p5,++p6]).

input_clause(c_154,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p3,--p4]).

input_clause(c_155,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p3,++p6]).

input_clause(c_156,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,++p3,--p5]).

input_clause(c_157,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p5,++p6]).

input_clause(c_158,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6]).

input_clause(c_159,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p4,++p6]).

input_clause(c_160,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p6,--p4,--p5]).

input_clause(c_161,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p4,--p5]).

input_clause(c_162,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p4,--p6]).

input_clause(c_163,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6]).

input_clause(c_164,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p5,--p6]).

input_clause(c_165,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p3,--p5]).

input_clause(c_166,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p3,--p6]).

input_clause(c_167,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p3,--p4]).

input_clause(c_168,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p3,--p4,--p5,--p6]).

input_clause(c_169,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p2,++p3,--p4,--p5]).

input_clause(c_170,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p2,++p3,--p4,--p6]).

input_clause(c_171,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p2,++p3]).

input_clause(c_172,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p2,++p3,--p5,--p6]).

input_clause(c_173,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p2,--p5]).

input_clause(c_174,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p2,--p6]).

input_clause(c_175,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p2,--p4]).

input_clause(c_176,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,++p2,--p4,--p5,--p6]).

input_clause(c_177,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p1,++p2,--p4,--p5]).

input_clause(c_178,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p1,++p2,--p4,--p6]).

input_clause(c_179,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p1,++p2]).

input_clause(c_180,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p1,++p2,--p5,--p6]).

input_clause(c_181,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p1,++p2,++p3,--p5]).

input_clause(c_182,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p1,++p2,++p3,--p6]).

input_clause(c_183,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p1,++p2,++p3,--p4]).

input_clause(c_184,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p1,++p2,++p3,--p4,--p5,--p6]).

input_clause(c_185,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p1,++p3,--p4,--p5]).

input_clause(c_186,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p1,++p3,--p4,--p6]).

input_clause(c_187,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p1,++p3]).

input_clause(c_188,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p1,++p3,--p5,--p6]).

input_clause(c_189,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p1,--p5]).

input_clause(c_190,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p1,--p6]).

input_clause(c_191,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p1,--p4]).

input_clause(c_192,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p6,--p1,--p4,--p5,--p6]).

input_clause(c_193,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p1,--p4]).

input_clause(c_194,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p1,--p4,++p5,--p6]).

input_clause(c_195,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p1,++p5]).

input_clause(c_196,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p1,--p6]).

input_clause(c_197,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p1,++p3]).

input_clause(c_198,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p1,++p3,++p5,--p6]).

input_clause(c_199,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p1,++p3,--p4,++p5]).

input_clause(c_200,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p1,++p3,--p4,--p6]).

input_clause(c_201,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p1,++p2,++p3,--p4]).

input_clause(c_202,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p1,++p2,++p3,--p4,++p5,--p6]).

input_clause(c_203,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p1,++p2,++p3,++p5]).

input_clause(c_204,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p1,++p2,++p3,--p6]).

input_clause(c_205,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p1,++p2]).

input_clause(c_206,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p1,++p2,++p5,--p6]).

input_clause(c_207,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p1,++p2,--p4,++p5]).

input_clause(c_208,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p1,++p2,--p4,--p6]).

input_clause(c_209,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p2,--p4]).

input_clause(c_210,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p2,--p4,++p5,--p6]).

input_clause(c_211,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p2,++p5]).

input_clause(c_212,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p2,--p6]).

input_clause(c_213,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p2,++p3]).

input_clause(c_214,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p2,++p3,++p5,--p6]).

input_clause(c_215,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p2,++p3,--p4,++p5]).

input_clause(c_216,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p2,++p3,--p4,--p6]).

input_clause(c_217,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p3,--p4]).

input_clause(c_218,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p3,--p4,++p5,--p6]).

input_clause(c_219,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p3,++p5]).

input_clause(c_220,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p3,--p6]).

input_clause(c_221,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6]).

input_clause(c_222,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,++p5,--p6]).

input_clause(c_223,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p4,++p5]).

input_clause(c_224,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p6,--p4,--p6]).

input_clause(c_225,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p4,++p6]).

input_clause(c_226,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p4,++p5]).

input_clause(c_227,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p5,++p6]).

input_clause(c_228,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6]).

input_clause(c_229,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p3,++p6]).

input_clause(c_230,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p3,++p5]).

input_clause(c_231,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p3,--p4,++p5,++p6]).

input_clause(c_232,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p3,--p4]).

input_clause(c_233,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p2,++p3,--p4,++p6]).

input_clause(c_234,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p2,++p3,--p4,++p5]).

input_clause(c_235,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p2,++p3,++p5,++p6]).

input_clause(c_236,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p2,++p3]).

input_clause(c_237,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p2,++p6]).

input_clause(c_238,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p2,++p5]).

input_clause(c_239,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p2,--p4,++p5,++p6]).

input_clause(c_240,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,++p2,--p4]).

input_clause(c_241,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p1,++p2,--p4,++p6]).

input_clause(c_242,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p1,++p2,--p4,++p5]).

input_clause(c_243,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p1,++p2,++p5,++p6]).

input_clause(c_244,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p1,++p2]).

input_clause(c_245,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p1,++p2,++p3,++p6]).

input_clause(c_246,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p1,++p2,++p3,++p5]).

input_clause(c_247,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p1,++p2,++p3,--p4,++p5,++p6]).

input_clause(c_248,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p1,++p2,++p3,--p4]).

input_clause(c_249,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p1,++p3,--p4,++p6]).

input_clause(c_250,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p1,++p3,--p4,++p5]).

input_clause(c_251,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p1,++p3,++p5,++p6]).

input_clause(c_252,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p1,++p3]).

input_clause(c_253,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p1,++p6]).

input_clause(c_254,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p1,++p5]).

input_clause(c_255,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p1,--p4,++p5,++p6]).

input_clause(c_256,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p6,--p1,--p4]).

input_clause(c_257,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p1,--p3,--p4,++p6]).

input_clause(c_258,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p1,--p3,--p4,++p5]).

input_clause(c_259,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p1,--p3,++p5,++p6]).

input_clause(c_260,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p1,--p3]).

input_clause(c_261,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p1,++p6]).

input_clause(c_262,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p1,++p5]).

input_clause(c_263,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p1,--p4,++p5,++p6]).

input_clause(c_264,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p1,--p4]).

input_clause(c_265,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p1,++p2,--p4,++p6]).

input_clause(c_266,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p1,++p2,--p4,++p5]).

input_clause(c_267,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p1,++p2,++p5,++p6]).

input_clause(c_268,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p1,++p2]).

input_clause(c_269,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p1,++p2,--p3,++p6]).

input_clause(c_270,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p1,++p2,--p3,++p5]).

input_clause(c_271,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p1,++p2,--p3,--p4,++p5,++p6]).

input_clause(c_272,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p1,++p2,--p3,--p4]).

input_clause(c_273,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p2,--p3,--p4,++p6]).

input_clause(c_274,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p2,--p3,--p4,++p5]).

input_clause(c_275,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p2,--p3,++p5,++p6]).

input_clause(c_276,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p2,--p3]).

input_clause(c_277,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p2,++p6]).

input_clause(c_278,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p2,++p5]).

input_clause(c_279,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p2,--p4,++p5,++p6]).

input_clause(c_280,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p2,--p4]).

input_clause(c_281,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p4,++p6]).

input_clause(c_282,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p4,++p5]).

input_clause(c_283,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,++p5,++p6]).

input_clause(c_284,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6]).

input_clause(c_285,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p3,++p6]).

input_clause(c_286,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p3,++p5]).

input_clause(c_287,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p3,--p4,++p5,++p6]).

input_clause(c_288,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p6,--p3,--p4]).

input_clause(c_289,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p3,--p4]).

input_clause(c_290,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p3,--p4,++p5,--p6]).

input_clause(c_291,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p3,++p5]).

input_clause(c_292,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p3,--p6]).

input_clause(c_293,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6]).

input_clause(c_294,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p5,--p6]).

input_clause(c_295,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p4,++p5]).

input_clause(c_296,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p4,--p6]).

input_clause(c_297,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p2,--p4]).

input_clause(c_298,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p2,--p4,++p5,--p6]).

input_clause(c_299,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p2,++p5]).

input_clause(c_300,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p2,--p6]).

input_clause(c_301,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p2,--p3]).

input_clause(c_302,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p2,--p3,++p5,--p6]).

input_clause(c_303,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p2,--p3,--p4,++p5]).

input_clause(c_304,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,++p2,--p3,--p4,--p6]).

input_clause(c_305,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p1,++p2,--p3,--p4]).

input_clause(c_306,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p1,++p2,--p3,--p4,++p5,--p6]).

input_clause(c_307,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p1,++p2,--p3,++p5]).

input_clause(c_308,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p1,++p2,--p3,--p6]).

input_clause(c_309,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p1,++p2]).

input_clause(c_310,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p1,++p2,++p5,--p6]).

input_clause(c_311,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p1,++p2,--p4,++p5]).

input_clause(c_312,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p1,++p2,--p4,--p6]).

input_clause(c_313,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p1,--p4]).

input_clause(c_314,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p1,--p4,++p5,--p6]).

input_clause(c_315,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p1,++p5]).

input_clause(c_316,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p1,--p6]).

input_clause(c_317,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p1,--p3]).

input_clause(c_318,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p1,--p3,++p5,--p6]).

input_clause(c_319,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p1,--p3,--p4,++p5]).

input_clause(c_320,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p6,--p1,--p3,--p4,--p6]).

input_clause(c_321,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p1,--p3,--p4,--p5]).

input_clause(c_322,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p1,--p3,--p4,--p6]).

input_clause(c_323,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p1,--p3]).

input_clause(c_324,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p1,--p3,--p5,--p6]).

input_clause(c_325,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p1,--p5]).

input_clause(c_326,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p1,--p6]).

input_clause(c_327,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p1,--p4]).

input_clause(c_328,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p1,--p4,--p5,--p6]).

input_clause(c_329,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p1,++p2,--p4,--p5]).

input_clause(c_330,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p1,++p2,--p4,--p6]).

input_clause(c_331,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p1,++p2]).

input_clause(c_332,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p1,++p2,--p5,--p6]).

input_clause(c_333,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p1,++p2,--p3,--p5]).

input_clause(c_334,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p1,++p2,--p3,--p6]).

input_clause(c_335,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p1,++p2,--p3,--p4]).

input_clause(c_336,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p1,++p2,--p3,--p4,--p5,--p6]).

input_clause(c_337,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p2,--p3,--p4,--p5]).

input_clause(c_338,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p2,--p3,--p4,--p6]).

input_clause(c_339,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p2,--p3]).

input_clause(c_340,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p2,--p3,--p5,--p6]).

input_clause(c_341,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p2,--p5]).

input_clause(c_342,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p2,--p6]).

input_clause(c_343,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p2,--p4]).

input_clause(c_344,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,++p2,--p4,--p5,--p6]).

input_clause(c_345,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p4,--p5]).

input_clause(c_346,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p4,--p6]).

input_clause(c_347,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6]).

input_clause(c_348,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p5,--p6]).

input_clause(c_349,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p3,--p5]).

input_clause(c_350,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p3,--p6]).

input_clause(c_351,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p3,--p4]).

input_clause(c_352,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p6,--p3,--p4,--p5,--p6]).

input_clause(c_353,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p3,--p4,--p5,++p6]).

input_clause(c_354,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p3,--p4]).

input_clause(c_355,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p3,++p6]).

input_clause(c_356,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p3,--p5]).

input_clause(c_357,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p5,++p6]).

input_clause(c_358,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6]).

input_clause(c_359,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p4,++p6]).

input_clause(c_360,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p4,--p5]).

input_clause(c_361,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p2,--p4,--p5,++p6]).

input_clause(c_362,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p2,--p4]).

input_clause(c_363,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p2,++p6]).

input_clause(c_364,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p2,--p5]).

input_clause(c_365,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p2,--p3,--p5,++p6]).

input_clause(c_366,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p2,--p3]).

input_clause(c_367,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p2,--p3,--p4,++p6]).

input_clause(c_368,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,++p2,--p3,--p4,--p5]).

input_clause(c_369,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p1,++p2,--p3,--p4,--p5,++p6]).

input_clause(c_370,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p1,++p2,--p3,--p4]).

input_clause(c_371,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p1,++p2,--p3,++p6]).

input_clause(c_372,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p1,++p2,--p3,--p5]).

input_clause(c_373,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p1,++p2,--p5,++p6]).

input_clause(c_374,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p1,++p2]).

input_clause(c_375,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p1,++p2,--p4,++p6]).

input_clause(c_376,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p1,++p2,--p4,--p5]).

input_clause(c_377,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p1,--p4,--p5,++p6]).

input_clause(c_378,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p1,--p4]).

input_clause(c_379,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p1,++p6]).

input_clause(c_380,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p1,--p5]).

input_clause(c_381,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p1,--p3,--p5,++p6]).

input_clause(c_382,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p1,--p3]).

input_clause(c_383,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p1,--p3,--p4,++p6]).

input_clause(c_384,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p6,--p1,--p3,--p4,--p5]).

input_clause(c_385,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p1,--p3,--p5,++p6]).

input_clause(c_386,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p1,--p3]).

input_clause(c_387,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p1,--p3,++p4,++p6]).

input_clause(c_388,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p1,--p3,++p4,--p5]).

input_clause(c_389,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p1,++p4,--p5,++p6]).

input_clause(c_390,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p1,++p4]).

input_clause(c_391,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p1,++p6]).

input_clause(c_392,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p1,--p5]).

input_clause(c_393,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p1,++p2,--p5,++p6]).

input_clause(c_394,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p1,++p2]).

input_clause(c_395,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p1,++p2,++p4,++p6]).

input_clause(c_396,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p1,++p2,++p4,--p5]).

input_clause(c_397,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p1,++p2,--p3,++p4,--p5,++p6]).

input_clause(c_398,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p1,++p2,--p3,++p4]).

input_clause(c_399,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p1,++p2,--p3,++p6]).

input_clause(c_400,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p1,++p2,--p3,--p5]).

input_clause(c_401,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p2,--p3,--p5,++p6]).

input_clause(c_402,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p2,--p3]).

input_clause(c_403,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p2,--p3,++p4,++p6]).

input_clause(c_404,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p2,--p3,++p4,--p5]).

input_clause(c_405,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p2,++p4,--p5,++p6]).

input_clause(c_406,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p2,++p4]).

input_clause(c_407,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p2,++p6]).

input_clause(c_408,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p2,--p5]).

input_clause(c_409,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p5,++p6]).

input_clause(c_410,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6]).

input_clause(c_411,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p4,++p6]).

input_clause(c_412,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,++p4,--p5]).

input_clause(c_413,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p3,++p4,--p5,++p6]).

input_clause(c_414,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p3,++p4]).

input_clause(c_415,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p3,++p6]).

input_clause(c_416,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p6,--p3,--p5]).

input_clause(c_417,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p3,--p5]).

input_clause(c_418,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p3,--p6]).

input_clause(c_419,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p3,++p4]).

input_clause(c_420,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p3,++p4,--p5,--p6]).

input_clause(c_421,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p4,--p5]).

input_clause(c_422,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p4,--p6]).

input_clause(c_423,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6]).

input_clause(c_424,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p5,--p6]).

input_clause(c_425,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p2,--p5]).

input_clause(c_426,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p2,--p6]).

input_clause(c_427,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p2,++p4]).

input_clause(c_428,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p2,++p4,--p5,--p6]).

input_clause(c_429,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p2,--p3,++p4,--p5]).

input_clause(c_430,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p2,--p3,++p4,--p6]).

input_clause(c_431,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p2,--p3]).

input_clause(c_432,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,++p2,--p3,--p5,--p6]).

input_clause(c_433,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p1,++p2,--p3,--p5]).

input_clause(c_434,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p1,++p2,--p3,--p6]).

input_clause(c_435,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p1,++p2,--p3,++p4]).

input_clause(c_436,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p1,++p2,--p3,++p4,--p5,--p6]).

input_clause(c_437,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p1,++p2,++p4,--p5]).

input_clause(c_438,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p1,++p2,++p4,--p6]).

input_clause(c_439,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p1,++p2]).

input_clause(c_440,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p1,++p2,--p5,--p6]).

input_clause(c_441,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p1,--p5]).

input_clause(c_442,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p1,--p6]).

input_clause(c_443,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p1,++p4]).

input_clause(c_444,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p1,++p4,--p5,--p6]).

input_clause(c_445,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p1,--p3,++p4,--p5]).

input_clause(c_446,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p1,--p3,++p4,--p6]).

input_clause(c_447,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p1,--p3]).

input_clause(c_448,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p6,--p1,--p3,--p5,--p6]).

input_clause(c_449,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p1,--p3]).

input_clause(c_450,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p1,--p3,++p5,--p6]).

input_clause(c_451,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p1,--p3,++p4,++p5]).

input_clause(c_452,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p1,--p3,++p4,--p6]).

input_clause(c_453,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p1,++p4]).

input_clause(c_454,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p1,++p4,++p5,--p6]).

input_clause(c_455,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p1,++p5]).

input_clause(c_456,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p1,--p6]).

input_clause(c_457,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p1,++p2]).

input_clause(c_458,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p1,++p2,++p5,--p6]).

input_clause(c_459,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p1,++p2,++p4,++p5]).

input_clause(c_460,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p1,++p2,++p4,--p6]).

input_clause(c_461,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p1,++p2,--p3,++p4]).

input_clause(c_462,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p1,++p2,--p3,++p4,++p5,--p6]).

input_clause(c_463,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p1,++p2,--p3,++p5]).

input_clause(c_464,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p1,++p2,--p3,--p6]).

input_clause(c_465,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p2,--p3]).

input_clause(c_466,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p2,--p3,++p5,--p6]).

input_clause(c_467,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p2,--p3,++p4,++p5]).

input_clause(c_468,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p2,--p3,++p4,--p6]).

input_clause(c_469,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p2,++p4]).

input_clause(c_470,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p2,++p4,++p5,--p6]).

input_clause(c_471,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p2,++p5]).

input_clause(c_472,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p2,--p6]).

input_clause(c_473,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6]).

input_clause(c_474,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p5,--p6]).

input_clause(c_475,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p4,++p5]).

input_clause(c_476,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,++p4,--p6]).

input_clause(c_477,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p3,++p4]).

input_clause(c_478,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p3,++p4,++p5,--p6]).

input_clause(c_479,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p3,++p5]).

input_clause(c_480,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p6,--p3,--p6]).

input_clause(c_481,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p3,++p6]).

input_clause(c_482,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p3,++p5]).

input_clause(c_483,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p3,++p4,++p5,++p6]).

input_clause(c_484,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p3,++p4]).

input_clause(c_485,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p4,++p6]).

input_clause(c_486,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p4,++p5]).

input_clause(c_487,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p5,++p6]).

input_clause(c_488,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6]).

input_clause(c_489,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p2,++p6]).

input_clause(c_490,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p2,++p5]).

input_clause(c_491,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p2,++p4,++p5,++p6]).

input_clause(c_492,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p2,++p4]).

input_clause(c_493,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p2,--p3,++p4,++p6]).

input_clause(c_494,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p2,--p3,++p4,++p5]).

input_clause(c_495,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p2,--p3,++p5,++p6]).

input_clause(c_496,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,++p2,--p3]).

input_clause(c_497,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p1,++p2,--p3,++p6]).

input_clause(c_498,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p1,++p2,--p3,++p5]).

input_clause(c_499,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p1,++p2,--p3,++p4,++p5,++p6]).

input_clause(c_500,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p1,++p2,--p3,++p4]).

input_clause(c_501,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p1,++p2,++p4,++p6]).

input_clause(c_502,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p1,++p2,++p4,++p5]).

input_clause(c_503,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p1,++p2,++p5,++p6]).

input_clause(c_504,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p1,++p2]).

input_clause(c_505,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p1,++p6]).

input_clause(c_506,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p1,++p5]).

input_clause(c_507,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p1,++p4,++p5,++p6]).

input_clause(c_508,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p1,++p4]).

input_clause(c_509,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p1,--p3,++p4,++p6]).

input_clause(c_510,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p1,--p3,++p4,++p5]).

input_clause(c_511,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p1,--p3,++p5,++p6]).

input_clause(c_512,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p6,--p1,--p3]).

input_clause(c_513,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p1,--p2,--p3,++p6]).

input_clause(c_514,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p1,--p2,--p3,++p5]).

input_clause(c_515,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p1,--p2,--p3,++p4,++p5,++p6]).

input_clause(c_516,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p1,--p2,--p3,++p4]).

input_clause(c_517,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p1,--p2,++p4,++p6]).

input_clause(c_518,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p1,--p2,++p4,++p5]).

input_clause(c_519,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p1,--p2,++p5,++p6]).

input_clause(c_520,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p1,--p2]).

input_clause(c_521,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p1,++p6]).

input_clause(c_522,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p1,++p5]).

input_clause(c_523,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p1,++p4,++p5,++p6]).

input_clause(c_524,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p1,++p4]).

input_clause(c_525,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p1,--p3,++p4,++p6]).

input_clause(c_526,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p1,--p3,++p4,++p5]).

input_clause(c_527,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p1,--p3,++p5,++p6]).

input_clause(c_528,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p1,--p3]).

input_clause(c_529,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p3,++p6]).

input_clause(c_530,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p3,++p5]).

input_clause(c_531,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p3,++p4,++p5,++p6]).

input_clause(c_532,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p3,++p4]).

input_clause(c_533,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p4,++p6]).

input_clause(c_534,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p4,++p5]).

input_clause(c_535,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,++p5,++p6]).

input_clause(c_536,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6]).

input_clause(c_537,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p2,++p6]).

input_clause(c_538,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p2,++p5]).

input_clause(c_539,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p2,++p4,++p5,++p6]).

input_clause(c_540,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p2,++p4]).

input_clause(c_541,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p2,--p3,++p4,++p6]).

input_clause(c_542,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p2,--p3,++p4,++p5]).

input_clause(c_543,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p2,--p3,++p5,++p6]).

input_clause(c_544,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p6,--p2,--p3]).

input_clause(c_545,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p2,--p3]).

input_clause(c_546,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p2,--p3,++p5,--p6]).

input_clause(c_547,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p2,--p3,++p4,++p5]).

input_clause(c_548,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p2,--p3,++p4,--p6]).

input_clause(c_549,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p2,++p4]).

input_clause(c_550,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p2,++p4,++p5,--p6]).

input_clause(c_551,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p2,++p5]).

input_clause(c_552,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p2,--p6]).

input_clause(c_553,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6]).

input_clause(c_554,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p5,--p6]).

input_clause(c_555,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p4,++p5]).

input_clause(c_556,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,++p4,--p6]).

input_clause(c_557,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p3,++p4]).

input_clause(c_558,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p3,++p4,++p5,--p6]).

input_clause(c_559,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p3,++p5]).

input_clause(c_560,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p3,--p6]).

input_clause(c_561,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p1,--p3]).

input_clause(c_562,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p1,--p3,++p5,--p6]).

input_clause(c_563,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p1,--p3,++p4,++p5]).

input_clause(c_564,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p1,--p3,++p4,--p6]).

input_clause(c_565,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p1,++p4]).

input_clause(c_566,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p1,++p4,++p5,--p6]).

input_clause(c_567,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p1,++p5]).

input_clause(c_568,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p1,--p6]).

input_clause(c_569,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p1,--p2]).

input_clause(c_570,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p1,--p2,++p5,--p6]).

input_clause(c_571,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p1,--p2,++p4,++p5]).

input_clause(c_572,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p1,--p2,++p4,--p6]).

input_clause(c_573,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p1,--p2,--p3,++p4]).

input_clause(c_574,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p1,--p2,--p3,++p4,++p5,--p6]).

input_clause(c_575,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p1,--p2,--p3,++p5]).

input_clause(c_576,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p6,--p1,--p2,--p3,--p6]).

input_clause(c_577,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p1,--p2,--p3,--p5]).

input_clause(c_578,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p1,--p2,--p3,--p6]).

input_clause(c_579,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p1,--p2,--p3,++p4]).

input_clause(c_580,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p1,--p2,--p3,++p4,--p5,--p6]).

input_clause(c_581,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p1,--p2,++p4,--p5]).

input_clause(c_582,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p1,--p2,++p4,--p6]).

input_clause(c_583,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p1,--p2]).

input_clause(c_584,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p1,--p2,--p5,--p6]).

input_clause(c_585,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p1,--p5]).

input_clause(c_586,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p1,--p6]).

input_clause(c_587,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p1,++p4]).

input_clause(c_588,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p1,++p4,--p5,--p6]).

input_clause(c_589,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p1,--p3,++p4,--p5]).

input_clause(c_590,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p1,--p3,++p4,--p6]).

input_clause(c_591,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p1,--p3]).

input_clause(c_592,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p1,--p3,--p5,--p6]).

input_clause(c_593,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p3,--p5]).

input_clause(c_594,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p3,--p6]).

input_clause(c_595,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p3,++p4]).

input_clause(c_596,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p3,++p4,--p5,--p6]).

input_clause(c_597,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p4,--p5]).

input_clause(c_598,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,++p4,--p6]).

input_clause(c_599,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6]).

input_clause(c_600,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p5,--p6]).

input_clause(c_601,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p2,--p5]).

input_clause(c_602,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p2,--p6]).

input_clause(c_603,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p2,++p4]).

input_clause(c_604,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p2,++p4,--p5,--p6]).

input_clause(c_605,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p2,--p3,++p4,--p5]).

input_clause(c_606,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p2,--p3,++p4,--p6]).

input_clause(c_607,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p2,--p3]).

input_clause(c_608,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p6,--p2,--p3,--p5,--p6]).

input_clause(c_609,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p2,--p3,--p5,++p6]).

input_clause(c_610,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p2,--p3]).

input_clause(c_611,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p2,--p3,++p4,++p6]).

input_clause(c_612,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p2,--p3,++p4,--p5]).

input_clause(c_613,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p2,++p4,--p5,++p6]).

input_clause(c_614,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p2,++p4]).

input_clause(c_615,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p2,++p6]).

input_clause(c_616,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p2,--p5]).

input_clause(c_617,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p5,++p6]).

input_clause(c_618,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6]).

input_clause(c_619,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p4,++p6]).

input_clause(c_620,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,++p4,--p5]).

input_clause(c_621,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p3,++p4,--p5,++p6]).

input_clause(c_622,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p3,++p4]).

input_clause(c_623,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p3,++p6]).

input_clause(c_624,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p3,--p5]).

input_clause(c_625,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p1,--p3,--p5,++p6]).

input_clause(c_626,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p1,--p3]).

input_clause(c_627,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p1,--p3,++p4,++p6]).

input_clause(c_628,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p1,--p3,++p4,--p5]).

input_clause(c_629,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p1,++p4,--p5,++p6]).

input_clause(c_630,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p1,++p4]).

input_clause(c_631,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p1,++p6]).

input_clause(c_632,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p1,--p5]).

input_clause(c_633,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p1,--p2,--p5,++p6]).

input_clause(c_634,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p1,--p2]).

input_clause(c_635,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p1,--p2,++p4,++p6]).

input_clause(c_636,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p1,--p2,++p4,--p5]).

input_clause(c_637,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p1,--p2,--p3,++p4,--p5,++p6]).

input_clause(c_638,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p1,--p2,--p3,++p4]).

input_clause(c_639,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p1,--p2,--p3,++p6]).

input_clause(c_640,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p6,--p1,--p2,--p3,--p5]).

input_clause(c_641,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p1,--p2,--p3,--p4,--p5,++p6]).

input_clause(c_642,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p1,--p2,--p3,--p4]).

input_clause(c_643,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p1,--p2,--p3,++p6]).

input_clause(c_644,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p1,--p2,--p3,--p5]).

input_clause(c_645,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p1,--p2,--p5,++p6]).

input_clause(c_646,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p1,--p2]).

input_clause(c_647,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p1,--p2,--p4,++p6]).

input_clause(c_648,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p1,--p2,--p4,--p5]).

input_clause(c_649,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p1,--p4,--p5,++p6]).

input_clause(c_650,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p1,--p4]).

input_clause(c_651,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p1,++p6]).

input_clause(c_652,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p1,--p5]).

input_clause(c_653,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p1,--p3,--p5,++p6]).

input_clause(c_654,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p1,--p3]).

input_clause(c_655,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p1,--p3,--p4,++p6]).

input_clause(c_656,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p1,--p3,--p4,--p5]).

input_clause(c_657,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p3,--p4,--p5,++p6]).

input_clause(c_658,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p3,--p4]).

input_clause(c_659,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p3,++p6]).

input_clause(c_660,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p3,--p5]).

input_clause(c_661,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p5,++p6]).

input_clause(c_662,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6]).

input_clause(c_663,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p4,++p6]).

input_clause(c_664,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p4,--p5]).

input_clause(c_665,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p2,--p4,--p5,++p6]).

input_clause(c_666,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p2,--p4]).

input_clause(c_667,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p2,++p6]).

input_clause(c_668,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p2,--p5]).

input_clause(c_669,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p2,--p3,--p5,++p6]).

input_clause(c_670,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p2,--p3]).

input_clause(c_671,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p2,--p3,--p4,++p6]).

input_clause(c_672,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p6,--p2,--p3,--p4,--p5]).

input_clause(c_673,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p2,--p3,--p4,--p5]).

input_clause(c_674,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p2,--p3,--p4,--p6]).

input_clause(c_675,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p2,--p3]).

input_clause(c_676,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p2,--p3,--p5,--p6]).

input_clause(c_677,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p2,--p5]).

input_clause(c_678,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p2,--p6]).

input_clause(c_679,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p2,--p4]).

input_clause(c_680,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p2,--p4,--p5,--p6]).

input_clause(c_681,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p4,--p5]).

input_clause(c_682,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p4,--p6]).

input_clause(c_683,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6]).

input_clause(c_684,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p5,--p6]).

input_clause(c_685,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p3,--p5]).

input_clause(c_686,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p3,--p6]).

input_clause(c_687,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p3,--p4]).

input_clause(c_688,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p3,--p4,--p5,--p6]).

input_clause(c_689,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p1,--p3,--p4,--p5]).

input_clause(c_690,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p1,--p3,--p4,--p6]).

input_clause(c_691,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p1,--p3]).

input_clause(c_692,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p1,--p3,--p5,--p6]).

input_clause(c_693,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p1,--p5]).

input_clause(c_694,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p1,--p6]).

input_clause(c_695,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p1,--p4]).

input_clause(c_696,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p1,--p4,--p5,--p6]).

input_clause(c_697,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p1,--p2,--p4,--p5]).

input_clause(c_698,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p1,--p2,--p4,--p6]).

input_clause(c_699,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p1,--p2]).

input_clause(c_700,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p1,--p2,--p5,--p6]).

input_clause(c_701,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p1,--p2,--p3,--p5]).

input_clause(c_702,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p1,--p2,--p3,--p6]).

input_clause(c_703,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p1,--p2,--p3,--p4]).

input_clause(c_704,theorem,
    [++p1,++p2,++p3,++p4,++p5,++p6,--p1,--p2,--p3,--p4,--p5,--p6]).

input_clause(c_705,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p1,--p2,--p3,--p4]).

input_clause(c_706,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p1,--p2,--p3,--p4,++p5,--p6]).

input_clause(c_707,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p1,--p2,--p3,++p5]).

input_clause(c_708,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p1,--p2,--p3,--p6]).

input_clause(c_709,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p1,--p2]).

input_clause(c_710,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p1,--p2,++p5,--p6]).

input_clause(c_711,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p1,--p2,--p4,++p5]).

input_clause(c_712,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p1,--p2,--p4,--p6]).

input_clause(c_713,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p1,--p4]).

input_clause(c_714,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p1,--p4,++p5,--p6]).

input_clause(c_715,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p1,++p5]).

input_clause(c_716,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p1,--p6]).

input_clause(c_717,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p1,--p3]).

input_clause(c_718,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p1,--p3,++p5,--p6]).

input_clause(c_719,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p1,--p3,--p4,++p5]).

input_clause(c_720,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p1,--p3,--p4,--p6]).

input_clause(c_721,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p3,--p4]).

input_clause(c_722,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p3,--p4,++p5,--p6]).

input_clause(c_723,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p3,++p5]).

input_clause(c_724,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p3,--p6]).

input_clause(c_725,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6]).

input_clause(c_726,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,++p5,--p6]).

input_clause(c_727,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p4,++p5]).

input_clause(c_728,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p4,--p6]).

input_clause(c_729,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p2,--p4]).

input_clause(c_730,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p2,--p4,++p5,--p6]).

input_clause(c_731,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p2,++p5]).

input_clause(c_732,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p2,--p6]).

input_clause(c_733,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p2,--p3]).

input_clause(c_734,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p2,--p3,++p5,--p6]).

input_clause(c_735,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p2,--p3,--p4,++p5]).

input_clause(c_736,theorem,
    [++p1,++p2,++p3,++p4,--p5,++p6,--p2,--p3,--p4,--p6]).

input_clause(c_737,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p2,--p3,--p4,++p6]).

input_clause(c_738,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p2,--p3,--p4,++p5]).

input_clause(c_739,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p2,--p3,++p5,++p6]).

input_clause(c_740,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p2,--p3]).

input_clause(c_741,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p2,++p6]).

input_clause(c_742,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p2,++p5]).

input_clause(c_743,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p2,--p4,++p5,++p6]).

input_clause(c_744,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p2,--p4]).

input_clause(c_745,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p4,++p6]).

input_clause(c_746,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p4,++p5]).

input_clause(c_747,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,++p5,++p6]).

input_clause(c_748,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6]).

input_clause(c_749,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p3,++p6]).

input_clause(c_750,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p3,++p5]).

input_clause(c_751,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p3,--p4,++p5,++p6]).

input_clause(c_752,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p3,--p4]).

input_clause(c_753,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p1,--p3,--p4,++p6]).

input_clause(c_754,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p1,--p3,--p4,++p5]).

input_clause(c_755,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p1,--p3,++p5,++p6]).

input_clause(c_756,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p1,--p3]).

input_clause(c_757,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p1,++p6]).

input_clause(c_758,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p1,++p5]).

input_clause(c_759,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p1,--p4,++p5,++p6]).

input_clause(c_760,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p1,--p4]).

input_clause(c_761,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p1,--p2,--p4,++p6]).

input_clause(c_762,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p1,--p2,--p4,++p5]).

input_clause(c_763,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p1,--p2,++p5,++p6]).

input_clause(c_764,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p1,--p2]).

input_clause(c_765,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p1,--p2,--p3,++p6]).

input_clause(c_766,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p1,--p2,--p3,++p5]).

input_clause(c_767,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p1,--p2,--p3,--p4,++p5,++p6]).

input_clause(c_768,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p6,--p1,--p2,--p3,--p4]).

input_clause(c_769,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p1,--p2,--p4,++p6]).

input_clause(c_770,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p1,--p2,--p4,++p5]).

input_clause(c_771,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p1,--p2,++p5,++p6]).

input_clause(c_772,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p1,--p2]).

input_clause(c_773,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p1,--p2,++p3,++p6]).

input_clause(c_774,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p1,--p2,++p3,++p5]).

input_clause(c_775,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p1,--p2,++p3,--p4,++p5,++p6]).

input_clause(c_776,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p1,--p2,++p3,--p4]).

input_clause(c_777,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p1,++p3,--p4,++p6]).

input_clause(c_778,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p1,++p3,--p4,++p5]).

input_clause(c_779,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p1,++p3,++p5,++p6]).

input_clause(c_780,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p1,++p3]).

input_clause(c_781,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p1,++p6]).

input_clause(c_782,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p1,++p5]).

input_clause(c_783,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p1,--p4,++p5,++p6]).

input_clause(c_784,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p1,--p4]).

input_clause(c_785,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p4,++p6]).

input_clause(c_786,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p4,++p5]).

input_clause(c_787,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p5,++p6]).

input_clause(c_788,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6]).

input_clause(c_789,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p3,++p6]).

input_clause(c_790,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p3,++p5]).

input_clause(c_791,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p3,--p4,++p5,++p6]).

input_clause(c_792,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,++p3,--p4]).

input_clause(c_793,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p2,++p3,--p4,++p6]).

input_clause(c_794,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p2,++p3,--p4,++p5]).

input_clause(c_795,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p2,++p3,++p5,++p6]).

input_clause(c_796,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p2,++p3]).

input_clause(c_797,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p2,++p6]).

input_clause(c_798,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p2,++p5]).

input_clause(c_799,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p2,--p4,++p5,++p6]).

input_clause(c_800,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p6,--p2,--p4]).

input_clause(c_801,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p2,--p4]).

input_clause(c_802,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p2,--p4,++p5,--p6]).

input_clause(c_803,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p2,++p5]).

input_clause(c_804,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p2,--p6]).

input_clause(c_805,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p2,++p3]).

input_clause(c_806,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p2,++p3,++p5,--p6]).

input_clause(c_807,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p2,++p3,--p4,++p5]).

input_clause(c_808,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p2,++p3,--p4,--p6]).

input_clause(c_809,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p3,--p4]).

input_clause(c_810,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p3,--p4,++p5,--p6]).

input_clause(c_811,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p3,++p5]).

input_clause(c_812,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p3,--p6]).

input_clause(c_813,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6]).

input_clause(c_814,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,++p5,--p6]).

input_clause(c_815,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p4,++p5]).

input_clause(c_816,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p4,--p6]).

input_clause(c_817,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p1,--p4]).

input_clause(c_818,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p1,--p4,++p5,--p6]).

input_clause(c_819,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p1,++p5]).

input_clause(c_820,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p1,--p6]).

input_clause(c_821,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p1,++p3]).

input_clause(c_822,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p1,++p3,++p5,--p6]).

input_clause(c_823,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p1,++p3,--p4,++p5]).

input_clause(c_824,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p1,++p3,--p4,--p6]).

input_clause(c_825,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p1,--p2,++p3,--p4]).

input_clause(c_826,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p1,--p2,++p3,--p4,++p5,--p6]).

input_clause(c_827,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p1,--p2,++p3,++p5]).

input_clause(c_828,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p1,--p2,++p3,--p6]).

input_clause(c_829,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p1,--p2]).

input_clause(c_830,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p1,--p2,++p5,--p6]).

input_clause(c_831,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p1,--p2,--p4,++p5]).

input_clause(c_832,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p6,--p1,--p2,--p4,--p6]).

input_clause(c_833,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p1,--p2,--p4,--p5]).

input_clause(c_834,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p1,--p2,--p4,--p6]).

input_clause(c_835,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p1,--p2]).

input_clause(c_836,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p1,--p2,--p5,--p6]).

input_clause(c_837,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p1,--p2,++p3,--p5]).

input_clause(c_838,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p1,--p2,++p3,--p6]).

input_clause(c_839,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p1,--p2,++p3,--p4]).

input_clause(c_840,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p1,--p2,++p3,--p4,--p5,--p6]).

input_clause(c_841,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p1,++p3,--p4,--p5]).

input_clause(c_842,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p1,++p3,--p4,--p6]).

input_clause(c_843,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p1,++p3]).

input_clause(c_844,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p1,++p3,--p5,--p6]).

input_clause(c_845,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p1,--p5]).

input_clause(c_846,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p1,--p6]).

input_clause(c_847,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p1,--p4]).

input_clause(c_848,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p1,--p4,--p5,--p6]).

input_clause(c_849,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p4,--p5]).

input_clause(c_850,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p4,--p6]).

input_clause(c_851,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6]).

input_clause(c_852,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p5,--p6]).

input_clause(c_853,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p3,--p5]).

input_clause(c_854,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p3,--p6]).

input_clause(c_855,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p3,--p4]).

input_clause(c_856,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,++p3,--p4,--p5,--p6]).

input_clause(c_857,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p2,++p3,--p4,--p5]).

input_clause(c_858,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p2,++p3,--p4,--p6]).

input_clause(c_859,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p2,++p3]).

input_clause(c_860,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p2,++p3,--p5,--p6]).

input_clause(c_861,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p2,--p5]).

input_clause(c_862,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p2,--p6]).

input_clause(c_863,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p2,--p4]).

input_clause(c_864,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p6,--p2,--p4,--p5,--p6]).

input_clause(c_865,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p2,--p4,--p5,++p6]).

input_clause(c_866,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p2,--p4]).

input_clause(c_867,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p2,++p6]).

input_clause(c_868,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p2,--p5]).

input_clause(c_869,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p2,++p3,--p5,++p6]).

input_clause(c_870,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p2,++p3]).

input_clause(c_871,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p2,++p3,--p4,++p6]).

input_clause(c_872,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p2,++p3,--p4,--p5]).

input_clause(c_873,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p3,--p4,--p5,++p6]).

input_clause(c_874,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p3,--p4]).

input_clause(c_875,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p3,++p6]).

input_clause(c_876,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,++p3,--p5]).

input_clause(c_877,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p5,++p6]).

input_clause(c_878,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6]).

input_clause(c_879,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p4,++p6]).

input_clause(c_880,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p4,--p5]).

input_clause(c_881,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p1,--p4,--p5,++p6]).

input_clause(c_882,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p1,--p4]).

input_clause(c_883,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p1,++p6]).

input_clause(c_884,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p1,--p5]).

input_clause(c_885,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p1,++p3,--p5,++p6]).

input_clause(c_886,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p1,++p3]).

input_clause(c_887,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p1,++p3,--p4,++p6]).

input_clause(c_888,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p1,++p3,--p4,--p5]).

input_clause(c_889,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p1,--p2,++p3,--p4,--p5,++p6]).

input_clause(c_890,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p1,--p2,++p3,--p4]).

input_clause(c_891,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p1,--p2,++p3,++p6]).

input_clause(c_892,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p1,--p2,++p3,--p5]).

input_clause(c_893,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p1,--p2,--p5,++p6]).

input_clause(c_894,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p1,--p2]).

input_clause(c_895,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p1,--p2,--p4,++p6]).

input_clause(c_896,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p6,--p1,--p2,--p4,--p5]).

input_clause(c_897,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p1,--p2,--p5,++p6]).

input_clause(c_898,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p1,--p2]).

input_clause(c_899,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p1,--p2,++p4,++p6]).

input_clause(c_900,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p1,--p2,++p4,--p5]).

input_clause(c_901,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p1,--p2,++p3,++p4,--p5,++p6]).

input_clause(c_902,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p1,--p2,++p3,++p4]).

input_clause(c_903,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p1,--p2,++p3,++p6]).

input_clause(c_904,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p1,--p2,++p3,--p5]).

input_clause(c_905,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p1,++p3,--p5,++p6]).

input_clause(c_906,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p1,++p3]).

input_clause(c_907,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p1,++p3,++p4,++p6]).

input_clause(c_908,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p1,++p3,++p4,--p5]).

input_clause(c_909,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p1,++p4,--p5,++p6]).

input_clause(c_910,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p1,++p4]).

input_clause(c_911,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p1,++p6]).

input_clause(c_912,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p1,--p5]).

input_clause(c_913,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p5,++p6]).

input_clause(c_914,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6]).

input_clause(c_915,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p4,++p6]).

input_clause(c_916,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p4,--p5]).

input_clause(c_917,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p3,++p4,--p5,++p6]).

input_clause(c_918,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p3,++p4]).

input_clause(c_919,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p3,++p6]).

input_clause(c_920,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,++p3,--p5]).

input_clause(c_921,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p2,++p3,--p5,++p6]).

input_clause(c_922,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p2,++p3]).

input_clause(c_923,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p2,++p3,++p4,++p6]).

input_clause(c_924,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p2,++p3,++p4,--p5]).

input_clause(c_925,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p2,++p4,--p5,++p6]).

input_clause(c_926,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p2,++p4]).

input_clause(c_927,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p2,++p6]).

input_clause(c_928,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p6,--p2,--p5]).

input_clause(c_929,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p2,--p5]).

input_clause(c_930,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p2,--p6]).

input_clause(c_931,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p2,++p4]).

input_clause(c_932,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p2,++p4,--p5,--p6]).

input_clause(c_933,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p2,++p3,++p4,--p5]).

input_clause(c_934,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p2,++p3,++p4,--p6]).

input_clause(c_935,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p2,++p3]).

input_clause(c_936,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p2,++p3,--p5,--p6]).

input_clause(c_937,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p3,--p5]).

input_clause(c_938,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p3,--p6]).

input_clause(c_939,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p3,++p4]).

input_clause(c_940,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p3,++p4,--p5,--p6]).

input_clause(c_941,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p4,--p5]).

input_clause(c_942,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,++p4,--p6]).

input_clause(c_943,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6]).

input_clause(c_944,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p5,--p6]).

input_clause(c_945,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p1,--p5]).

input_clause(c_946,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p1,--p6]).

input_clause(c_947,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p1,++p4]).

input_clause(c_948,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p1,++p4,--p5,--p6]).

input_clause(c_949,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p1,++p3,++p4,--p5]).

input_clause(c_950,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p1,++p3,++p4,--p6]).

input_clause(c_951,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p1,++p3]).

input_clause(c_952,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p1,++p3,--p5,--p6]).

input_clause(c_953,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p1,--p2,++p3,--p5]).

input_clause(c_954,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p1,--p2,++p3,--p6]).

input_clause(c_955,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p1,--p2,++p3,++p4]).

input_clause(c_956,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p1,--p2,++p3,++p4,--p5,--p6]).

input_clause(c_957,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p1,--p2,++p4,--p5]).

input_clause(c_958,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p1,--p2,++p4,--p6]).

input_clause(c_959,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p1,--p2]).

input_clause(c_960,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p6,--p1,--p2,--p5,--p6]).

input_clause(c_961,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p1,--p2]).

input_clause(c_962,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p1,--p2,++p5,--p6]).

input_clause(c_963,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p1,--p2,++p4,++p5]).

input_clause(c_964,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p1,--p2,++p4,--p6]).

input_clause(c_965,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p1,--p2,++p3,++p4]).

input_clause(c_966,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p1,--p2,++p3,++p4,++p5,--p6]).

input_clause(c_967,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p1,--p2,++p3,++p5]).

input_clause(c_968,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p1,--p2,++p3,--p6]).

input_clause(c_969,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p1,++p3]).

input_clause(c_970,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p1,++p3,++p5,--p6]).

input_clause(c_971,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p1,++p3,++p4,++p5]).

input_clause(c_972,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p1,++p3,++p4,--p6]).

input_clause(c_973,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p1,++p4]).

input_clause(c_974,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p1,++p4,++p5,--p6]).

input_clause(c_975,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p1,++p5]).

input_clause(c_976,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p1,--p6]).

input_clause(c_977,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6]).

input_clause(c_978,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p5,--p6]).

input_clause(c_979,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p4,++p5]).

input_clause(c_980,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p4,--p6]).

input_clause(c_981,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p3,++p4]).

input_clause(c_982,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p3,++p4,++p5,--p6]).

input_clause(c_983,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p3,++p5]).

input_clause(c_984,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,++p3,--p6]).

input_clause(c_985,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p2,++p3]).

input_clause(c_986,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p2,++p3,++p5,--p6]).

input_clause(c_987,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p2,++p3,++p4,++p5]).

input_clause(c_988,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p2,++p3,++p4,--p6]).

input_clause(c_989,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p2,++p4]).

input_clause(c_990,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p2,++p4,++p5,--p6]).

input_clause(c_991,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p2,++p5]).

input_clause(c_992,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p6,--p2,--p6]).

input_clause(c_993,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p2,++p6]).

input_clause(c_994,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p2,++p5]).

input_clause(c_995,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p2,++p4,++p5,++p6]).

input_clause(c_996,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p2,++p4]).

input_clause(c_997,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p2,++p3,++p4,++p6]).

input_clause(c_998,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p2,++p3,++p4,++p5]).

input_clause(c_999,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p2,++p3,++p5,++p6]).

input_clause(c_1000,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p2,++p3]).

input_clause(c_1001,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p3,++p6]).

input_clause(c_1002,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p3,++p5]).

input_clause(c_1003,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p3,++p4,++p5,++p6]).

input_clause(c_1004,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p3,++p4]).

input_clause(c_1005,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p4,++p6]).

input_clause(c_1006,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p4,++p5]).

input_clause(c_1007,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,++p5,++p6]).

input_clause(c_1008,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6]).

input_clause(c_1009,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p1,++p6]).

input_clause(c_1010,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p1,++p5]).

input_clause(c_1011,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p1,++p4,++p5,++p6]).

input_clause(c_1012,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p1,++p4]).

input_clause(c_1013,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p1,++p3,++p4,++p6]).

input_clause(c_1014,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p1,++p3,++p4,++p5]).

input_clause(c_1015,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p1,++p3,++p5,++p6]).

input_clause(c_1016,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p1,++p3]).

input_clause(c_1017,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p1,--p2,++p3,++p6]).

input_clause(c_1018,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p1,--p2,++p3,++p5]).

input_clause(c_1019,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p1,--p2,++p3,++p4,++p5,++p6]).

input_clause(c_1020,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p1,--p2,++p3,++p4]).

input_clause(c_1021,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p1,--p2,++p4,++p6]).

input_clause(c_1022,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p1,--p2,++p4,++p5]).

input_clause(c_1023,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p1,--p2,++p5,++p6]).

input_clause(c_1024,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p6,--p1,--p2]).

input_clause(c_1025,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p2,++p6]).

input_clause(c_1026,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p2,++p5]).

input_clause(c_1027,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p2,++p4,++p5,++p6]).

input_clause(c_1028,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p2,++p4]).

input_clause(c_1029,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p2,++p3,++p4,++p6]).

input_clause(c_1030,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p2,++p3,++p4,++p5]).

input_clause(c_1031,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p2,++p3,++p5,++p6]).

input_clause(c_1032,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,--p2,++p3]).

input_clause(c_1033,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p3,++p6]).

input_clause(c_1034,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p3,++p5]).

input_clause(c_1035,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p3,++p4,++p5,++p6]).

input_clause(c_1036,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p3,++p4]).

input_clause(c_1037,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p4,++p6]).

input_clause(c_1038,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p4,++p5]).

input_clause(c_1039,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p5,++p6]).

input_clause(c_1040,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6]).

input_clause(c_1041,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p1,++p6]).

input_clause(c_1042,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p1,++p5]).

input_clause(c_1043,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p1,++p4,++p5,++p6]).

input_clause(c_1044,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p1,++p4]).

input_clause(c_1045,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p1,++p3,++p4,++p6]).

input_clause(c_1046,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p1,++p3,++p4,++p5]).

input_clause(c_1047,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p1,++p3,++p5,++p6]).

input_clause(c_1048,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p1,++p3]).

input_clause(c_1049,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p1,--p2,++p3,++p6]).

input_clause(c_1050,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p1,--p2,++p3,++p5]).

input_clause(c_1051,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p1,--p2,++p3,++p4,++p5,++p6]).

input_clause(c_1052,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p1,--p2,++p3,++p4]).

input_clause(c_1053,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p1,--p2,++p4,++p6]).

input_clause(c_1054,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p1,--p2,++p4,++p5]).

input_clause(c_1055,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p1,--p2,++p5,++p6]).

input_clause(c_1056,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p6,++p1,--p2]).

input_clause(c_1057,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p1,--p2]).

input_clause(c_1058,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p1,--p2,++p5,--p6]).

input_clause(c_1059,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p1,--p2,++p4,++p5]).

input_clause(c_1060,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p1,--p2,++p4,--p6]).

input_clause(c_1061,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p1,--p2,++p3,++p4]).

input_clause(c_1062,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p1,--p2,++p3,++p4,++p5,--p6]).

input_clause(c_1063,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p1,--p2,++p3,++p5]).

input_clause(c_1064,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p1,--p2,++p3,--p6]).

input_clause(c_1065,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p1,++p3]).

input_clause(c_1066,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p1,++p3,++p5,--p6]).

input_clause(c_1067,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p1,++p3,++p4,++p5]).

input_clause(c_1068,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p1,++p3,++p4,--p6]).

input_clause(c_1069,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p1,++p4]).

input_clause(c_1070,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p1,++p4,++p5,--p6]).

input_clause(c_1071,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p1,++p5]).

input_clause(c_1072,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p1,--p6]).

input_clause(c_1073,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6]).

input_clause(c_1074,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p5,--p6]).

input_clause(c_1075,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p4,++p5]).

input_clause(c_1076,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p4,--p6]).

input_clause(c_1077,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p3,++p4]).

input_clause(c_1078,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p3,++p4,++p5,--p6]).

input_clause(c_1079,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p3,++p5]).

input_clause(c_1080,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,++p3,--p6]).

input_clause(c_1081,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p2,++p3]).

input_clause(c_1082,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p2,++p3,++p5,--p6]).

input_clause(c_1083,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p2,++p3,++p4,++p5]).

input_clause(c_1084,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p2,++p3,++p4,--p6]).

input_clause(c_1085,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p2,++p4]).

input_clause(c_1086,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p2,++p4,++p5,--p6]).

input_clause(c_1087,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p2,++p5]).

input_clause(c_1088,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p6,--p2,--p6]).

input_clause(c_1089,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p2,--p5]).

input_clause(c_1090,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p2,--p6]).

input_clause(c_1091,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p2,++p4]).

input_clause(c_1092,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p2,++p4,--p5,--p6]).

input_clause(c_1093,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p2,++p3,++p4,--p5]).

input_clause(c_1094,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p2,++p3,++p4,--p6]).

input_clause(c_1095,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p2,++p3]).

input_clause(c_1096,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p2,++p3,--p5,--p6]).

input_clause(c_1097,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p3,--p5]).

input_clause(c_1098,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p3,--p6]).

input_clause(c_1099,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p3,++p4]).

input_clause(c_1100,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p3,++p4,--p5,--p6]).

input_clause(c_1101,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p4,--p5]).

input_clause(c_1102,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p4,--p6]).

input_clause(c_1103,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6]).

input_clause(c_1104,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,--p5,--p6]).

input_clause(c_1105,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p1,--p5]).

input_clause(c_1106,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p1,--p6]).

input_clause(c_1107,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p1,++p4]).

input_clause(c_1108,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p1,++p4,--p5,--p6]).

input_clause(c_1109,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p1,++p3,++p4,--p5]).

input_clause(c_1110,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p1,++p3,++p4,--p6]).

input_clause(c_1111,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p1,++p3]).

input_clause(c_1112,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p1,++p3,--p5,--p6]).

input_clause(c_1113,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p1,--p2,++p3,--p5]).

input_clause(c_1114,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p1,--p2,++p3,--p6]).

input_clause(c_1115,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p1,--p2,++p3,++p4]).

input_clause(c_1116,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p1,--p2,++p3,++p4,--p5,--p6]).

input_clause(c_1117,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p1,--p2,++p4,--p5]).

input_clause(c_1118,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p1,--p2,++p4,--p6]).

input_clause(c_1119,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p1,--p2]).

input_clause(c_1120,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p6,++p1,--p2,--p5,--p6]).

input_clause(c_1121,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p1,--p2,--p5,++p6]).

input_clause(c_1122,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p1,--p2]).

input_clause(c_1123,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p1,--p2,++p4,++p6]).

input_clause(c_1124,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p1,--p2,++p4,--p5]).

input_clause(c_1125,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p1,--p2,++p3,++p4,--p5,++p6]).

input_clause(c_1126,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p1,--p2,++p3,++p4]).

input_clause(c_1127,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p1,--p2,++p3,++p6]).

input_clause(c_1128,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p1,--p2,++p3,--p5]).

input_clause(c_1129,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p1,++p3,--p5,++p6]).

input_clause(c_1130,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p1,++p3]).

input_clause(c_1131,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p1,++p3,++p4,++p6]).

input_clause(c_1132,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p1,++p3,++p4,--p5]).

input_clause(c_1133,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p1,++p4,--p5,++p6]).

input_clause(c_1134,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p1,++p4]).

input_clause(c_1135,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p1,++p6]).

input_clause(c_1136,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p1,--p5]).

input_clause(c_1137,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p5,++p6]).

input_clause(c_1138,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6]).

input_clause(c_1139,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p4,++p6]).

input_clause(c_1140,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p4,--p5]).

input_clause(c_1141,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p3,++p4,--p5,++p6]).

input_clause(c_1142,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p3,++p4]).

input_clause(c_1143,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p3,++p6]).

input_clause(c_1144,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,++p3,--p5]).

input_clause(c_1145,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p2,++p3,--p5,++p6]).

input_clause(c_1146,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p2,++p3]).

input_clause(c_1147,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p2,++p3,++p4,++p6]).

input_clause(c_1148,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p2,++p3,++p4,--p5]).

input_clause(c_1149,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p2,++p4,--p5,++p6]).

input_clause(c_1150,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p2,++p4]).

input_clause(c_1151,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p2,++p6]).

input_clause(c_1152,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p6,--p2,--p5]).

input_clause(c_1153,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p2,--p4,--p5,++p6]).

input_clause(c_1154,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p2,--p4]).

input_clause(c_1155,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p2,++p6]).

input_clause(c_1156,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p2,--p5]).

input_clause(c_1157,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p2,++p3,--p5,++p6]).

input_clause(c_1158,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p2,++p3]).

input_clause(c_1159,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p2,++p3,--p4,++p6]).

input_clause(c_1160,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p2,++p3,--p4,--p5]).

input_clause(c_1161,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p3,--p4,--p5,++p6]).

input_clause(c_1162,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p3,--p4]).

input_clause(c_1163,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p3,++p6]).

input_clause(c_1164,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p3,--p5]).

input_clause(c_1165,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p5,++p6]).

input_clause(c_1166,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6]).

input_clause(c_1167,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p4,++p6]).

input_clause(c_1168,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,--p4,--p5]).

input_clause(c_1169,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p1,--p4,--p5,++p6]).

input_clause(c_1170,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p1,--p4]).

input_clause(c_1171,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p1,++p6]).

input_clause(c_1172,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p1,--p5]).

input_clause(c_1173,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p1,++p3,--p5,++p6]).

input_clause(c_1174,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p1,++p3]).

input_clause(c_1175,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p1,++p3,--p4,++p6]).

input_clause(c_1176,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p1,++p3,--p4,--p5]).

input_clause(c_1177,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p1,--p2,++p3,--p4,--p5,++p6]).

input_clause(c_1178,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p1,--p2,++p3,--p4]).

input_clause(c_1179,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p1,--p2,++p3,++p6]).

input_clause(c_1180,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p1,--p2,++p3,--p5]).

input_clause(c_1181,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p1,--p2,--p5,++p6]).

input_clause(c_1182,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p1,--p2]).

input_clause(c_1183,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p1,--p2,--p4,++p6]).

input_clause(c_1184,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p6,++p1,--p2,--p4,--p5]).

input_clause(c_1185,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p1,--p2,--p4,--p5]).

input_clause(c_1186,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p1,--p2,--p4,--p6]).

input_clause(c_1187,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p1,--p2]).

input_clause(c_1188,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p1,--p2,--p5,--p6]).

input_clause(c_1189,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p1,--p2,++p3,--p5]).

input_clause(c_1190,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p1,--p2,++p3,--p6]).

input_clause(c_1191,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p1,--p2,++p3,--p4]).

input_clause(c_1192,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p1,--p2,++p3,--p4,--p5,--p6]).

input_clause(c_1193,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p1,++p3,--p4,--p5]).

input_clause(c_1194,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p1,++p3,--p4,--p6]).

input_clause(c_1195,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p1,++p3]).

input_clause(c_1196,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p1,++p3,--p5,--p6]).

input_clause(c_1197,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p1,--p5]).

input_clause(c_1198,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p1,--p6]).

input_clause(c_1199,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p1,--p4]).

input_clause(c_1200,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p1,--p4,--p5,--p6]).

input_clause(c_1201,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p4,--p5]).

input_clause(c_1202,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p4,--p6]).

input_clause(c_1203,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6]).

input_clause(c_1204,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p5,--p6]).

input_clause(c_1205,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p3,--p5]).

input_clause(c_1206,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p3,--p6]).

input_clause(c_1207,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p3,--p4]).

input_clause(c_1208,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,++p3,--p4,--p5,--p6]).

input_clause(c_1209,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p2,++p3,--p4,--p5]).

input_clause(c_1210,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p2,++p3,--p4,--p6]).

input_clause(c_1211,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p2,++p3]).

input_clause(c_1212,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p2,++p3,--p5,--p6]).

input_clause(c_1213,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p2,--p5]).

input_clause(c_1214,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p2,--p6]).

input_clause(c_1215,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p2,--p4]).

input_clause(c_1216,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p6,--p2,--p4,--p5,--p6]).

input_clause(c_1217,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p2,--p4]).

input_clause(c_1218,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p2,--p4,++p5,--p6]).

input_clause(c_1219,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p2,++p5]).

input_clause(c_1220,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p2,--p6]).

input_clause(c_1221,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p2,++p3]).

input_clause(c_1222,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p2,++p3,++p5,--p6]).

input_clause(c_1223,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p2,++p3,--p4,++p5]).

input_clause(c_1224,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p2,++p3,--p4,--p6]).

input_clause(c_1225,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p3,--p4]).

input_clause(c_1226,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p3,--p4,++p5,--p6]).

input_clause(c_1227,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p3,++p5]).

input_clause(c_1228,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p3,--p6]).

input_clause(c_1229,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6]).

input_clause(c_1230,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p5,--p6]).

input_clause(c_1231,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p4,++p5]).

input_clause(c_1232,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,--p4,--p6]).

input_clause(c_1233,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p1,--p4]).

input_clause(c_1234,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p1,--p4,++p5,--p6]).

input_clause(c_1235,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p1,++p5]).

input_clause(c_1236,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p1,--p6]).

input_clause(c_1237,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p1,++p3]).

input_clause(c_1238,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p1,++p3,++p5,--p6]).

input_clause(c_1239,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p1,++p3,--p4,++p5]).

input_clause(c_1240,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p1,++p3,--p4,--p6]).

input_clause(c_1241,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p1,--p2,++p3,--p4]).

input_clause(c_1242,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p1,--p2,++p3,--p4,++p5,--p6]).

input_clause(c_1243,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p1,--p2,++p3,++p5]).

input_clause(c_1244,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p1,--p2,++p3,--p6]).

input_clause(c_1245,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p1,--p2]).

input_clause(c_1246,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p1,--p2,++p5,--p6]).

input_clause(c_1247,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p1,--p2,--p4,++p5]).

input_clause(c_1248,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p6,++p1,--p2,--p4,--p6]).

input_clause(c_1249,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p1,--p2,--p4,++p6]).

input_clause(c_1250,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p1,--p2,--p4,++p5]).

input_clause(c_1251,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p1,--p2,++p5,++p6]).

input_clause(c_1252,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p1,--p2]).

input_clause(c_1253,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p1,--p2,++p3,++p6]).

input_clause(c_1254,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p1,--p2,++p3,++p5]).

input_clause(c_1255,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p1,--p2,++p3,--p4,++p5,++p6]).

input_clause(c_1256,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p1,--p2,++p3,--p4]).

input_clause(c_1257,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p1,++p3,--p4,++p6]).

input_clause(c_1258,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p1,++p3,--p4,++p5]).

input_clause(c_1259,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p1,++p3,++p5,++p6]).

input_clause(c_1260,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p1,++p3]).

input_clause(c_1261,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p1,++p6]).

input_clause(c_1262,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p1,++p5]).

input_clause(c_1263,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p1,--p4,++p5,++p6]).

input_clause(c_1264,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p1,--p4]).

input_clause(c_1265,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p4,++p6]).

input_clause(c_1266,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p4,++p5]).

input_clause(c_1267,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p5,++p6]).

input_clause(c_1268,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6]).

input_clause(c_1269,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p3,++p6]).

input_clause(c_1270,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p3,++p5]).

input_clause(c_1271,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p3,--p4,++p5,++p6]).

input_clause(c_1272,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,++p3,--p4]).

input_clause(c_1273,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p2,++p3,--p4,++p6]).

input_clause(c_1274,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p2,++p3,--p4,++p5]).

input_clause(c_1275,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p2,++p3,++p5,++p6]).

input_clause(c_1276,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p2,++p3]).

input_clause(c_1277,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p2,++p6]).

input_clause(c_1278,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p2,++p5]).

input_clause(c_1279,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p2,--p4,++p5,++p6]).

input_clause(c_1280,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p6,--p2,--p4]).

input_clause(c_1281,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p2,--p3,--p4,++p6]).

input_clause(c_1282,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p2,--p3,--p4,++p5]).

input_clause(c_1283,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p2,--p3,++p5,++p6]).

input_clause(c_1284,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p2,--p3]).

input_clause(c_1285,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p2,++p6]).

input_clause(c_1286,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p2,++p5]).

input_clause(c_1287,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p2,--p4,++p5,++p6]).

input_clause(c_1288,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p2,--p4]).

input_clause(c_1289,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p4,++p6]).

input_clause(c_1290,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p4,++p5]).

input_clause(c_1291,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p5,++p6]).

input_clause(c_1292,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6]).

input_clause(c_1293,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p3,++p6]).

input_clause(c_1294,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p3,++p5]).

input_clause(c_1295,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p3,--p4,++p5,++p6]).

input_clause(c_1296,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,--p3,--p4]).

input_clause(c_1297,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p1,--p3,--p4,++p6]).

input_clause(c_1298,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p1,--p3,--p4,++p5]).

input_clause(c_1299,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p1,--p3,++p5,++p6]).

input_clause(c_1300,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p1,--p3]).

input_clause(c_1301,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p1,++p6]).

input_clause(c_1302,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p1,++p5]).

input_clause(c_1303,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p1,--p4,++p5,++p6]).

input_clause(c_1304,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p1,--p4]).

input_clause(c_1305,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p1,--p2,--p4,++p6]).

input_clause(c_1306,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p1,--p2,--p4,++p5]).

input_clause(c_1307,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p1,--p2,++p5,++p6]).

input_clause(c_1308,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p1,--p2]).

input_clause(c_1309,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p1,--p2,--p3,++p6]).

input_clause(c_1310,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p1,--p2,--p3,++p5]).

input_clause(c_1311,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p1,--p2,--p3,--p4,++p5,++p6]).

input_clause(c_1312,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p6,++p1,--p2,--p3,--p4]).

input_clause(c_1313,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p1,--p2,--p3,--p4]).

input_clause(c_1314,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p1,--p2,--p3,--p4,++p5,--p6]).

input_clause(c_1315,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p1,--p2,--p3,++p5]).

input_clause(c_1316,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p1,--p2,--p3,--p6]).

input_clause(c_1317,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p1,--p2]).

input_clause(c_1318,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p1,--p2,++p5,--p6]).

input_clause(c_1319,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p1,--p2,--p4,++p5]).

input_clause(c_1320,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p1,--p2,--p4,--p6]).

input_clause(c_1321,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p1,--p4]).

input_clause(c_1322,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p1,--p4,++p5,--p6]).

input_clause(c_1323,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p1,++p5]).

input_clause(c_1324,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p1,--p6]).

input_clause(c_1325,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p1,--p3]).

input_clause(c_1326,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p1,--p3,++p5,--p6]).

input_clause(c_1327,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p1,--p3,--p4,++p5]).

input_clause(c_1328,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p1,--p3,--p4,--p6]).

input_clause(c_1329,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p3,--p4]).

input_clause(c_1330,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p3,--p4,++p5,--p6]).

input_clause(c_1331,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p3,++p5]).

input_clause(c_1332,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p3,--p6]).

input_clause(c_1333,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6]).

input_clause(c_1334,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,++p5,--p6]).

input_clause(c_1335,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p4,++p5]).

input_clause(c_1336,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p4,--p6]).

input_clause(c_1337,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p2,--p4]).

input_clause(c_1338,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p2,--p4,++p5,--p6]).

input_clause(c_1339,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p2,++p5]).

input_clause(c_1340,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p2,--p6]).

input_clause(c_1341,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p2,--p3]).

input_clause(c_1342,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p2,--p3,++p5,--p6]).

input_clause(c_1343,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p2,--p3,--p4,++p5]).

input_clause(c_1344,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p6,--p2,--p3,--p4,--p6]).

input_clause(c_1345,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p2,--p3,--p4,--p5]).

input_clause(c_1346,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p2,--p3,--p4,--p6]).

input_clause(c_1347,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p2,--p3]).

input_clause(c_1348,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p2,--p3,--p5,--p6]).

input_clause(c_1349,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p2,--p5]).

input_clause(c_1350,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p2,--p6]).

input_clause(c_1351,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p2,--p4]).

input_clause(c_1352,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p2,--p4,--p5,--p6]).

input_clause(c_1353,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p4,--p5]).

input_clause(c_1354,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p4,--p6]).

input_clause(c_1355,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6]).

input_clause(c_1356,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p5,--p6]).

input_clause(c_1357,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p3,--p5]).

input_clause(c_1358,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p3,--p6]).

input_clause(c_1359,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p3,--p4]).

input_clause(c_1360,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,--p3,--p4,--p5,--p6]).

input_clause(c_1361,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p1,--p3,--p4,--p5]).

input_clause(c_1362,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p1,--p3,--p4,--p6]).

input_clause(c_1363,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p1,--p3]).

input_clause(c_1364,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p1,--p3,--p5,--p6]).

input_clause(c_1365,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p1,--p5]).

input_clause(c_1366,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p1,--p6]).

input_clause(c_1367,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p1,--p4]).

input_clause(c_1368,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p1,--p4,--p5,--p6]).

input_clause(c_1369,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p1,--p2,--p4,--p5]).

input_clause(c_1370,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p1,--p2,--p4,--p6]).

input_clause(c_1371,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p1,--p2]).

input_clause(c_1372,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p1,--p2,--p5,--p6]).

input_clause(c_1373,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p1,--p2,--p3,--p5]).

input_clause(c_1374,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p1,--p2,--p3,--p6]).

input_clause(c_1375,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p1,--p2,--p3,--p4]).

input_clause(c_1376,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p6,++p1,--p2,--p3,--p4,--p5,--p6]).

input_clause(c_1377,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p1,--p2,--p3,--p4,--p5,++p6]).

input_clause(c_1378,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p1,--p2,--p3,--p4]).

input_clause(c_1379,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p1,--p2,--p3,++p6]).

input_clause(c_1380,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p1,--p2,--p3,--p5]).

input_clause(c_1381,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p1,--p2,--p5,++p6]).

input_clause(c_1382,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p1,--p2]).

input_clause(c_1383,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p1,--p2,--p4,++p6]).

input_clause(c_1384,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p1,--p2,--p4,--p5]).

input_clause(c_1385,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p1,--p4,--p5,++p6]).

input_clause(c_1386,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p1,--p4]).

input_clause(c_1387,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p1,++p6]).

input_clause(c_1388,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p1,--p5]).

input_clause(c_1389,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p1,--p3,--p5,++p6]).

input_clause(c_1390,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p1,--p3]).

input_clause(c_1391,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p1,--p3,--p4,++p6]).

input_clause(c_1392,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,++p1,--p3,--p4,--p5]).

input_clause(c_1393,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p3,--p4,--p5,++p6]).

input_clause(c_1394,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p3,--p4]).

input_clause(c_1395,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p3,++p6]).

input_clause(c_1396,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p3,--p5]).

input_clause(c_1397,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p5,++p6]).

input_clause(c_1398,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6]).

input_clause(c_1399,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p4,++p6]).

input_clause(c_1400,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p4,--p5]).

input_clause(c_1401,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p2,--p4,--p5,++p6]).

input_clause(c_1402,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p2,--p4]).

input_clause(c_1403,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p2,++p6]).

input_clause(c_1404,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p2,--p5]).

input_clause(c_1405,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p2,--p3,--p5,++p6]).

input_clause(c_1406,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p2,--p3]).

input_clause(c_1407,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p2,--p3,--p4,++p6]).

input_clause(c_1408,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p6,--p2,--p3,--p4,--p5]).

input_clause(c_1409,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p2,--p3,--p5,++p6]).

input_clause(c_1410,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p2,--p3]).

input_clause(c_1411,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p2,--p3,++p4,++p6]).

input_clause(c_1412,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p2,--p3,++p4,--p5]).

input_clause(c_1413,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p2,++p4,--p5,++p6]).

input_clause(c_1414,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p2,++p4]).

input_clause(c_1415,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p2,++p6]).

input_clause(c_1416,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p2,--p5]).

input_clause(c_1417,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p5,++p6]).

input_clause(c_1418,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6]).

input_clause(c_1419,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p4,++p6]).

input_clause(c_1420,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p4,--p5]).

input_clause(c_1421,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p3,++p4,--p5,++p6]).

input_clause(c_1422,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p3,++p4]).

input_clause(c_1423,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p3,++p6]).

input_clause(c_1424,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,--p3,--p5]).

input_clause(c_1425,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p1,--p3,--p5,++p6]).

input_clause(c_1426,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p1,--p3]).

input_clause(c_1427,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p1,--p3,++p4,++p6]).

input_clause(c_1428,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p1,--p3,++p4,--p5]).

input_clause(c_1429,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p1,++p4,--p5,++p6]).

input_clause(c_1430,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p1,++p4]).

input_clause(c_1431,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p1,++p6]).

input_clause(c_1432,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p1,--p5]).

input_clause(c_1433,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p1,--p2,--p5,++p6]).

input_clause(c_1434,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p1,--p2]).

input_clause(c_1435,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p1,--p2,++p4,++p6]).

input_clause(c_1436,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p1,--p2,++p4,--p5]).

input_clause(c_1437,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p1,--p2,--p3,++p4,--p5,++p6]).

input_clause(c_1438,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p1,--p2,--p3,++p4]).

input_clause(c_1439,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p1,--p2,--p3,++p6]).

input_clause(c_1440,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p6,++p1,--p2,--p3,--p5]).

input_clause(c_1441,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p1,--p2,--p3,--p5]).

input_clause(c_1442,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p1,--p2,--p3,--p6]).

input_clause(c_1443,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p1,--p2,--p3,++p4]).

input_clause(c_1444,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p1,--p2,--p3,++p4,--p5,--p6]).

input_clause(c_1445,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p1,--p2,++p4,--p5]).

input_clause(c_1446,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p1,--p2,++p4,--p6]).

input_clause(c_1447,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p1,--p2]).

input_clause(c_1448,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p1,--p2,--p5,--p6]).

input_clause(c_1449,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p1,--p5]).

input_clause(c_1450,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p1,--p6]).

input_clause(c_1451,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p1,++p4]).

input_clause(c_1452,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p1,++p4,--p5,--p6]).

input_clause(c_1453,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p1,--p3,++p4,--p5]).

input_clause(c_1454,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p1,--p3,++p4,--p6]).

input_clause(c_1455,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p1,--p3]).

input_clause(c_1456,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p1,--p3,--p5,--p6]).

input_clause(c_1457,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p3,--p5]).

input_clause(c_1458,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p3,--p6]).

input_clause(c_1459,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p3,++p4]).

input_clause(c_1460,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p3,++p4,--p5,--p6]).

input_clause(c_1461,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p4,--p5]).

input_clause(c_1462,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,++p4,--p6]).

input_clause(c_1463,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6]).

input_clause(c_1464,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p5,--p6]).

input_clause(c_1465,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p2,--p5]).

input_clause(c_1466,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p2,--p6]).

input_clause(c_1467,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p2,++p4]).

input_clause(c_1468,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p2,++p4,--p5,--p6]).

input_clause(c_1469,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p2,--p3,++p4,--p5]).

input_clause(c_1470,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p2,--p3,++p4,--p6]).

input_clause(c_1471,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p2,--p3]).

input_clause(c_1472,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p6,--p2,--p3,--p5,--p6]).

input_clause(c_1473,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p2,--p3]).

input_clause(c_1474,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p2,--p3,++p5,--p6]).

input_clause(c_1475,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p2,--p3,++p4,++p5]).

input_clause(c_1476,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p2,--p3,++p4,--p6]).

input_clause(c_1477,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p2,++p4]).

input_clause(c_1478,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p2,++p4,++p5,--p6]).

input_clause(c_1479,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p2,++p5]).

input_clause(c_1480,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p2,--p6]).

input_clause(c_1481,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6]).

input_clause(c_1482,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p5,--p6]).

input_clause(c_1483,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p4,++p5]).

input_clause(c_1484,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p4,--p6]).

input_clause(c_1485,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p3,++p4]).

input_clause(c_1486,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p3,++p4,++p5,--p6]).

input_clause(c_1487,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p3,++p5]).

input_clause(c_1488,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,--p3,--p6]).

input_clause(c_1489,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p1,--p3]).

input_clause(c_1490,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p1,--p3,++p5,--p6]).

input_clause(c_1491,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p1,--p3,++p4,++p5]).

input_clause(c_1492,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p1,--p3,++p4,--p6]).

input_clause(c_1493,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p1,++p4]).

input_clause(c_1494,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p1,++p4,++p5,--p6]).

input_clause(c_1495,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p1,++p5]).

input_clause(c_1496,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p1,--p6]).

input_clause(c_1497,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p1,--p2]).

input_clause(c_1498,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p1,--p2,++p5,--p6]).

input_clause(c_1499,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p1,--p2,++p4,++p5]).

input_clause(c_1500,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p1,--p2,++p4,--p6]).

input_clause(c_1501,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p1,--p2,--p3,++p4]).

input_clause(c_1502,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p1,--p2,--p3,++p4,++p5,--p6]).

input_clause(c_1503,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p1,--p2,--p3,++p5]).

input_clause(c_1504,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p6,++p1,--p2,--p3,--p6]).

input_clause(c_1505,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p1,--p2,--p3,++p6]).

input_clause(c_1506,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p1,--p2,--p3,++p5]).

input_clause(c_1507,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p1,--p2,--p3,++p4,++p5,++p6]).

input_clause(c_1508,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p1,--p2,--p3,++p4]).

input_clause(c_1509,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p1,--p2,++p4,++p6]).

input_clause(c_1510,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p1,--p2,++p4,++p5]).

input_clause(c_1511,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p1,--p2,++p5,++p6]).

input_clause(c_1512,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p1,--p2]).

input_clause(c_1513,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p1,++p6]).

input_clause(c_1514,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p1,++p5]).

input_clause(c_1515,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p1,++p4,++p5,++p6]).

input_clause(c_1516,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p1,++p4]).

input_clause(c_1517,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p1,--p3,++p4,++p6]).

input_clause(c_1518,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p1,--p3,++p4,++p5]).

input_clause(c_1519,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p1,--p3,++p5,++p6]).

input_clause(c_1520,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p1,--p3]).

input_clause(c_1521,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p3,++p6]).

input_clause(c_1522,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p3,++p5]).

input_clause(c_1523,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p3,++p4,++p5,++p6]).

input_clause(c_1524,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p3,++p4]).

input_clause(c_1525,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p4,++p6]).

input_clause(c_1526,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p4,++p5]).

input_clause(c_1527,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,++p5,++p6]).

input_clause(c_1528,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6]).

input_clause(c_1529,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p2,++p6]).

input_clause(c_1530,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p2,++p5]).

input_clause(c_1531,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p2,++p4,++p5,++p6]).

input_clause(c_1532,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p2,++p4]).

input_clause(c_1533,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p2,--p3,++p4,++p6]).

input_clause(c_1534,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p2,--p3,++p4,++p5]).

input_clause(c_1535,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p2,--p3,++p5,++p6]).

input_clause(c_1536,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p6,--p2,--p3]).

input_clause(c_1537,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p3,++p6]).

input_clause(c_1538,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p3,++p5]).

input_clause(c_1539,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p3,++p4,++p5,++p6]).

input_clause(c_1540,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,--p3,++p4]).

input_clause(c_1541,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p4,++p6]).

input_clause(c_1542,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p4,++p5]).

input_clause(c_1543,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p5,++p6]).

input_clause(c_1544,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6]).

input_clause(c_1545,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p2,++p6]).

input_clause(c_1546,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p2,++p5]).

input_clause(c_1547,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p2,++p4,++p5,++p6]).

input_clause(c_1548,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p2,++p4]).

input_clause(c_1549,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p2,--p3,++p4,++p6]).

input_clause(c_1550,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p2,--p3,++p4,++p5]).

input_clause(c_1551,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p2,--p3,++p5,++p6]).

input_clause(c_1552,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p2,--p3]).

input_clause(c_1553,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p1,++p2,--p3,++p6]).

input_clause(c_1554,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p1,++p2,--p3,++p5]).

input_clause(c_1555,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p1,++p2,--p3,++p4,++p5,++p6]).

input_clause(c_1556,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p1,++p2,--p3,++p4]).

input_clause(c_1557,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p1,++p2,++p4,++p6]).

input_clause(c_1558,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p1,++p2,++p4,++p5]).

input_clause(c_1559,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p1,++p2,++p5,++p6]).

input_clause(c_1560,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p1,++p2]).

input_clause(c_1561,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p1,++p6]).

input_clause(c_1562,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p1,++p5]).

input_clause(c_1563,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p1,++p4,++p5,++p6]).

input_clause(c_1564,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p1,++p4]).

input_clause(c_1565,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p1,--p3,++p4,++p6]).

input_clause(c_1566,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p1,--p3,++p4,++p5]).

input_clause(c_1567,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p1,--p3,++p5,++p6]).

input_clause(c_1568,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p6,++p1,--p3]).

input_clause(c_1569,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p1,--p3]).

input_clause(c_1570,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p1,--p3,++p5,--p6]).

input_clause(c_1571,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p1,--p3,++p4,++p5]).

input_clause(c_1572,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p1,--p3,++p4,--p6]).

input_clause(c_1573,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p1,++p4]).

input_clause(c_1574,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p1,++p4,++p5,--p6]).

input_clause(c_1575,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p1,++p5]).

input_clause(c_1576,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p1,--p6]).

input_clause(c_1577,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p1,++p2]).

input_clause(c_1578,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p1,++p2,++p5,--p6]).

input_clause(c_1579,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p1,++p2,++p4,++p5]).

input_clause(c_1580,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p1,++p2,++p4,--p6]).

input_clause(c_1581,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p1,++p2,--p3,++p4]).

input_clause(c_1582,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p1,++p2,--p3,++p4,++p5,--p6]).

input_clause(c_1583,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p1,++p2,--p3,++p5]).

input_clause(c_1584,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p1,++p2,--p3,--p6]).

input_clause(c_1585,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p2,--p3]).

input_clause(c_1586,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p2,--p3,++p5,--p6]).

input_clause(c_1587,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p2,--p3,++p4,++p5]).

input_clause(c_1588,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p2,--p3,++p4,--p6]).

input_clause(c_1589,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p2,++p4]).

input_clause(c_1590,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p2,++p4,++p5,--p6]).

input_clause(c_1591,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p2,++p5]).

input_clause(c_1592,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p2,--p6]).

input_clause(c_1593,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6]).

input_clause(c_1594,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p5,--p6]).

input_clause(c_1595,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p4,++p5]).

input_clause(c_1596,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,++p4,--p6]).

input_clause(c_1597,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p3,++p4]).

input_clause(c_1598,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p3,++p4,++p5,--p6]).

input_clause(c_1599,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p3,++p5]).

input_clause(c_1600,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p6,--p3,--p6]).

input_clause(c_1601,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p3,--p5]).

input_clause(c_1602,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p3,--p6]).

input_clause(c_1603,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p3,++p4]).

input_clause(c_1604,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p3,++p4,--p5,--p6]).

input_clause(c_1605,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p4,--p5]).

input_clause(c_1606,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p4,--p6]).

input_clause(c_1607,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6]).

input_clause(c_1608,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,--p5,--p6]).

input_clause(c_1609,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p2,--p5]).

input_clause(c_1610,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p2,--p6]).

input_clause(c_1611,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p2,++p4]).

input_clause(c_1612,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p2,++p4,--p5,--p6]).

input_clause(c_1613,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p2,--p3,++p4,--p5]).

input_clause(c_1614,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p2,--p3,++p4,--p6]).

input_clause(c_1615,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p2,--p3]).

input_clause(c_1616,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p2,--p3,--p5,--p6]).

input_clause(c_1617,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p1,++p2,--p3,--p5]).

input_clause(c_1618,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p1,++p2,--p3,--p6]).

input_clause(c_1619,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p1,++p2,--p3,++p4]).

input_clause(c_1620,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p1,++p2,--p3,++p4,--p5,--p6]).

input_clause(c_1621,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p1,++p2,++p4,--p5]).

input_clause(c_1622,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p1,++p2,++p4,--p6]).

input_clause(c_1623,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p1,++p2]).

input_clause(c_1624,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p1,++p2,--p5,--p6]).

input_clause(c_1625,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p1,--p5]).

input_clause(c_1626,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p1,--p6]).

input_clause(c_1627,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p1,++p4]).

input_clause(c_1628,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p1,++p4,--p5,--p6]).

input_clause(c_1629,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p1,--p3,++p4,--p5]).

input_clause(c_1630,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p1,--p3,++p4,--p6]).

input_clause(c_1631,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p1,--p3]).

input_clause(c_1632,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p6,++p1,--p3,--p5,--p6]).

input_clause(c_1633,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p1,--p3,--p5,++p6]).

input_clause(c_1634,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p1,--p3]).

input_clause(c_1635,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p1,--p3,++p4,++p6]).

input_clause(c_1636,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p1,--p3,++p4,--p5]).

input_clause(c_1637,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p1,++p4,--p5,++p6]).

input_clause(c_1638,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p1,++p4]).

input_clause(c_1639,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p1,++p6]).

input_clause(c_1640,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p1,--p5]).

input_clause(c_1641,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p1,++p2,--p5,++p6]).

input_clause(c_1642,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p1,++p2]).

input_clause(c_1643,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p1,++p2,++p4,++p6]).

input_clause(c_1644,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p1,++p2,++p4,--p5]).

input_clause(c_1645,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p1,++p2,--p3,++p4,--p5,++p6]).

input_clause(c_1646,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p1,++p2,--p3,++p4]).

input_clause(c_1647,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p1,++p2,--p3,++p6]).

input_clause(c_1648,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p1,++p2,--p3,--p5]).

input_clause(c_1649,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p2,--p3,--p5,++p6]).

input_clause(c_1650,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p2,--p3]).

input_clause(c_1651,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p2,--p3,++p4,++p6]).

input_clause(c_1652,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p2,--p3,++p4,--p5]).

input_clause(c_1653,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p2,++p4,--p5,++p6]).

input_clause(c_1654,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p2,++p4]).

input_clause(c_1655,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p2,++p6]).

input_clause(c_1656,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p2,--p5]).

input_clause(c_1657,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p5,++p6]).

input_clause(c_1658,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6]).

input_clause(c_1659,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p4,++p6]).

input_clause(c_1660,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,++p4,--p5]).

input_clause(c_1661,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p3,++p4,--p5,++p6]).

input_clause(c_1662,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p3,++p4]).

input_clause(c_1663,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p3,++p6]).

input_clause(c_1664,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p6,--p3,--p5]).

input_clause(c_1665,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p3,--p4,--p5,++p6]).

input_clause(c_1666,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p3,--p4]).

input_clause(c_1667,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p3,++p6]).

input_clause(c_1668,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p3,--p5]).

input_clause(c_1669,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p5,++p6]).

input_clause(c_1670,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6]).

input_clause(c_1671,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p4,++p6]).

input_clause(c_1672,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,--p4,--p5]).

input_clause(c_1673,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p2,--p4,--p5,++p6]).

input_clause(c_1674,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p2,--p4]).

input_clause(c_1675,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p2,++p6]).

input_clause(c_1676,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p2,--p5]).

input_clause(c_1677,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p2,--p3,--p5,++p6]).

input_clause(c_1678,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p2,--p3]).

input_clause(c_1679,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p2,--p3,--p4,++p6]).

input_clause(c_1680,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p2,--p3,--p4,--p5]).

input_clause(c_1681,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p1,++p2,--p3,--p4,--p5,++p6]).

input_clause(c_1682,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p1,++p2,--p3,--p4]).

input_clause(c_1683,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p1,++p2,--p3,++p6]).

input_clause(c_1684,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p1,++p2,--p3,--p5]).

input_clause(c_1685,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p1,++p2,--p5,++p6]).

input_clause(c_1686,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p1,++p2]).

input_clause(c_1687,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p1,++p2,--p4,++p6]).

input_clause(c_1688,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p1,++p2,--p4,--p5]).

input_clause(c_1689,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p1,--p4,--p5,++p6]).

input_clause(c_1690,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p1,--p4]).

input_clause(c_1691,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p1,++p6]).

input_clause(c_1692,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p1,--p5]).

input_clause(c_1693,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p1,--p3,--p5,++p6]).

input_clause(c_1694,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p1,--p3]).

input_clause(c_1695,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p1,--p3,--p4,++p6]).

input_clause(c_1696,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p6,++p1,--p3,--p4,--p5]).

input_clause(c_1697,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p1,--p3,--p4,--p5]).

input_clause(c_1698,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p1,--p3,--p4,--p6]).

input_clause(c_1699,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p1,--p3]).

input_clause(c_1700,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p1,--p3,--p5,--p6]).

input_clause(c_1701,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p1,--p5]).

input_clause(c_1702,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p1,--p6]).

input_clause(c_1703,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p1,--p4]).

input_clause(c_1704,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p1,--p4,--p5,--p6]).

input_clause(c_1705,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p1,++p2,--p4,--p5]).

input_clause(c_1706,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p1,++p2,--p4,--p6]).

input_clause(c_1707,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p1,++p2]).

input_clause(c_1708,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p1,++p2,--p5,--p6]).

input_clause(c_1709,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p1,++p2,--p3,--p5]).

input_clause(c_1710,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p1,++p2,--p3,--p6]).

input_clause(c_1711,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p1,++p2,--p3,--p4]).

input_clause(c_1712,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p1,++p2,--p3,--p4,--p5,--p6]).

input_clause(c_1713,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p2,--p3,--p4,--p5]).

input_clause(c_1714,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p2,--p3,--p4,--p6]).

input_clause(c_1715,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p2,--p3]).

input_clause(c_1716,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p2,--p3,--p5,--p6]).

input_clause(c_1717,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p2,--p5]).

input_clause(c_1718,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p2,--p6]).

input_clause(c_1719,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p2,--p4]).

input_clause(c_1720,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,++p2,--p4,--p5,--p6]).

input_clause(c_1721,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p4,--p5]).

input_clause(c_1722,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p4,--p6]).

input_clause(c_1723,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6]).

input_clause(c_1724,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p5,--p6]).

input_clause(c_1725,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p3,--p5]).

input_clause(c_1726,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p3,--p6]).

input_clause(c_1727,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p3,--p4]).

input_clause(c_1728,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p6,--p3,--p4,--p5,--p6]).

input_clause(c_1729,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p3,--p4]).

input_clause(c_1730,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p3,--p4,++p5,--p6]).

input_clause(c_1731,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p3,++p5]).

input_clause(c_1732,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p3,--p6]).

input_clause(c_1733,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6]).

input_clause(c_1734,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p5,--p6]).

input_clause(c_1735,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p4,++p5]).

input_clause(c_1736,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,--p4,--p6]).

input_clause(c_1737,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p2,--p4]).

input_clause(c_1738,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p2,--p4,++p5,--p6]).

input_clause(c_1739,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p2,++p5]).

input_clause(c_1740,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p2,--p6]).

input_clause(c_1741,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p2,--p3]).

input_clause(c_1742,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p2,--p3,++p5,--p6]).

input_clause(c_1743,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p2,--p3,--p4,++p5]).

input_clause(c_1744,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p2,--p3,--p4,--p6]).

input_clause(c_1745,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p1,++p2,--p3,--p4]).

input_clause(c_1746,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p1,++p2,--p3,--p4,++p5,--p6]).

input_clause(c_1747,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p1,++p2,--p3,++p5]).

input_clause(c_1748,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p1,++p2,--p3,--p6]).

input_clause(c_1749,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p1,++p2]).

input_clause(c_1750,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p1,++p2,++p5,--p6]).

input_clause(c_1751,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p1,++p2,--p4,++p5]).

input_clause(c_1752,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p1,++p2,--p4,--p6]).

input_clause(c_1753,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p1,--p4]).

input_clause(c_1754,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p1,--p4,++p5,--p6]).

input_clause(c_1755,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p1,++p5]).

input_clause(c_1756,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p1,--p6]).

input_clause(c_1757,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p1,--p3]).

input_clause(c_1758,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p1,--p3,++p5,--p6]).

input_clause(c_1759,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p1,--p3,--p4,++p5]).

input_clause(c_1760,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p6,++p1,--p3,--p4,--p6]).

input_clause(c_1761,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p1,--p3,--p4,++p6]).

input_clause(c_1762,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p1,--p3,--p4,++p5]).

input_clause(c_1763,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p1,--p3,++p5,++p6]).

input_clause(c_1764,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p1,--p3]).

input_clause(c_1765,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p1,++p6]).

input_clause(c_1766,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p1,++p5]).

input_clause(c_1767,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p1,--p4,++p5,++p6]).

input_clause(c_1768,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p1,--p4]).

input_clause(c_1769,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p1,++p2,--p4,++p6]).

input_clause(c_1770,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p1,++p2,--p4,++p5]).

input_clause(c_1771,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p1,++p2,++p5,++p6]).

input_clause(c_1772,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p1,++p2]).

input_clause(c_1773,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p1,++p2,--p3,++p6]).

input_clause(c_1774,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p1,++p2,--p3,++p5]).

input_clause(c_1775,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p1,++p2,--p3,--p4,++p5,++p6]).

input_clause(c_1776,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p1,++p2,--p3,--p4]).

input_clause(c_1777,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p2,--p3,--p4,++p6]).

input_clause(c_1778,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p2,--p3,--p4,++p5]).

input_clause(c_1779,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p2,--p3,++p5,++p6]).

input_clause(c_1780,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p2,--p3]).

input_clause(c_1781,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p2,++p6]).

input_clause(c_1782,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p2,++p5]).

input_clause(c_1783,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p2,--p4,++p5,++p6]).

input_clause(c_1784,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p2,--p4]).

input_clause(c_1785,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p4,++p6]).

input_clause(c_1786,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p4,++p5]).

input_clause(c_1787,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,++p5,++p6]).

input_clause(c_1788,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6]).

input_clause(c_1789,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p3,++p6]).

input_clause(c_1790,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p3,++p5]).

input_clause(c_1791,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p3,--p4,++p5,++p6]).

input_clause(c_1792,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p6,--p3,--p4]).

input_clause(c_1793,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p4,++p6]).

input_clause(c_1794,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,--p4,++p5]).

input_clause(c_1795,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p5,++p6]).

input_clause(c_1796,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6]).

input_clause(c_1797,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p3,++p6]).

input_clause(c_1798,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p3,++p5]).

input_clause(c_1799,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p3,--p4,++p5,++p6]).

input_clause(c_1800,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p3,--p4]).

input_clause(c_1801,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p2,++p3,--p4,++p6]).

input_clause(c_1802,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p2,++p3,--p4,++p5]).

input_clause(c_1803,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p2,++p3,++p5,++p6]).

input_clause(c_1804,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p2,++p3]).

input_clause(c_1805,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p2,++p6]).

input_clause(c_1806,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p2,++p5]).

input_clause(c_1807,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p2,--p4,++p5,++p6]).

input_clause(c_1808,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p2,--p4]).

input_clause(c_1809,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p1,++p2,--p4,++p6]).

input_clause(c_1810,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p1,++p2,--p4,++p5]).

input_clause(c_1811,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p1,++p2,++p5,++p6]).

input_clause(c_1812,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p1,++p2]).

input_clause(c_1813,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p1,++p2,++p3,++p6]).

input_clause(c_1814,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p1,++p2,++p3,++p5]).

input_clause(c_1815,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p1,++p2,++p3,--p4,++p5,++p6]).

input_clause(c_1816,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p1,++p2,++p3,--p4]).

input_clause(c_1817,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p1,++p3,--p4,++p6]).

input_clause(c_1818,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p1,++p3,--p4,++p5]).

input_clause(c_1819,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p1,++p3,++p5,++p6]).

input_clause(c_1820,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p1,++p3]).

input_clause(c_1821,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p1,++p6]).

input_clause(c_1822,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p1,++p5]).

input_clause(c_1823,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p1,--p4,++p5,++p6]).

input_clause(c_1824,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p6,++p1,--p4]).

input_clause(c_1825,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p1,--p4]).

input_clause(c_1826,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p1,--p4,++p5,--p6]).

input_clause(c_1827,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p1,++p5]).

input_clause(c_1828,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p1,--p6]).

input_clause(c_1829,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p1,++p3]).

input_clause(c_1830,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p1,++p3,++p5,--p6]).

input_clause(c_1831,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p1,++p3,--p4,++p5]).

input_clause(c_1832,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p1,++p3,--p4,--p6]).

input_clause(c_1833,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p1,++p2,++p3,--p4]).

input_clause(c_1834,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p1,++p2,++p3,--p4,++p5,--p6]).

input_clause(c_1835,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p1,++p2,++p3,++p5]).

input_clause(c_1836,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p1,++p2,++p3,--p6]).

input_clause(c_1837,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p1,++p2]).

input_clause(c_1838,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p1,++p2,++p5,--p6]).

input_clause(c_1839,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p1,++p2,--p4,++p5]).

input_clause(c_1840,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p1,++p2,--p4,--p6]).

input_clause(c_1841,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p2,--p4]).

input_clause(c_1842,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p2,--p4,++p5,--p6]).

input_clause(c_1843,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p2,++p5]).

input_clause(c_1844,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p2,--p6]).

input_clause(c_1845,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p2,++p3]).

input_clause(c_1846,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p2,++p3,++p5,--p6]).

input_clause(c_1847,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p2,++p3,--p4,++p5]).

input_clause(c_1848,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p2,++p3,--p4,--p6]).

input_clause(c_1849,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p3,--p4]).

input_clause(c_1850,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p3,--p4,++p5,--p6]).

input_clause(c_1851,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p3,++p5]).

input_clause(c_1852,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p3,--p6]).

input_clause(c_1853,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6]).

input_clause(c_1854,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,++p5,--p6]).

input_clause(c_1855,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p4,++p5]).

input_clause(c_1856,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p6,--p4,--p6]).

input_clause(c_1857,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p4,--p5]).

input_clause(c_1858,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p4,--p6]).

input_clause(c_1859,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6]).

input_clause(c_1860,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,--p5,--p6]).

input_clause(c_1861,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p3,--p5]).

input_clause(c_1862,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p3,--p6]).

input_clause(c_1863,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p3,--p4]).

input_clause(c_1864,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p3,--p4,--p5,--p6]).

input_clause(c_1865,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p2,++p3,--p4,--p5]).

input_clause(c_1866,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p2,++p3,--p4,--p6]).

input_clause(c_1867,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p2,++p3]).

input_clause(c_1868,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p2,++p3,--p5,--p6]).

input_clause(c_1869,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p2,--p5]).

input_clause(c_1870,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p2,--p6]).

input_clause(c_1871,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p2,--p4]).

input_clause(c_1872,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p2,--p4,--p5,--p6]).

input_clause(c_1873,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p1,++p2,--p4,--p5]).

input_clause(c_1874,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p1,++p2,--p4,--p6]).

input_clause(c_1875,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p1,++p2]).

input_clause(c_1876,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p1,++p2,--p5,--p6]).

input_clause(c_1877,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p1,++p2,++p3,--p5]).

input_clause(c_1878,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p1,++p2,++p3,--p6]).

input_clause(c_1879,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p1,++p2,++p3,--p4]).

input_clause(c_1880,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p1,++p2,++p3,--p4,--p5,--p6]).

input_clause(c_1881,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p1,++p3,--p4,--p5]).

input_clause(c_1882,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p1,++p3,--p4,--p6]).

input_clause(c_1883,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p1,++p3]).

input_clause(c_1884,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p1,++p3,--p5,--p6]).

input_clause(c_1885,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p1,--p5]).

input_clause(c_1886,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p1,--p6]).

input_clause(c_1887,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p1,--p4]).

input_clause(c_1888,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p6,++p1,--p4,--p5,--p6]).

input_clause(c_1889,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p1,--p4,--p5,++p6]).

input_clause(c_1890,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p1,--p4]).

input_clause(c_1891,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p1,++p6]).

input_clause(c_1892,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p1,--p5]).

input_clause(c_1893,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p1,++p3,--p5,++p6]).

input_clause(c_1894,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p1,++p3]).

input_clause(c_1895,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p1,++p3,--p4,++p6]).

input_clause(c_1896,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p1,++p3,--p4,--p5]).

input_clause(c_1897,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p1,++p2,++p3,--p4,--p5,++p6]).

input_clause(c_1898,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p1,++p2,++p3,--p4]).

input_clause(c_1899,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p1,++p2,++p3,++p6]).

input_clause(c_1900,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p1,++p2,++p3,--p5]).

input_clause(c_1901,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p1,++p2,--p5,++p6]).

input_clause(c_1902,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p1,++p2]).

input_clause(c_1903,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p1,++p2,--p4,++p6]).

input_clause(c_1904,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p1,++p2,--p4,--p5]).

input_clause(c_1905,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p2,--p4,--p5,++p6]).

input_clause(c_1906,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p2,--p4]).

input_clause(c_1907,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p2,++p6]).

input_clause(c_1908,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p2,--p5]).

input_clause(c_1909,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p2,++p3,--p5,++p6]).

input_clause(c_1910,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p2,++p3]).

input_clause(c_1911,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p2,++p3,--p4,++p6]).

input_clause(c_1912,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p2,++p3,--p4,--p5]).

input_clause(c_1913,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p3,--p4,--p5,++p6]).

input_clause(c_1914,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p3,--p4]).

input_clause(c_1915,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p3,++p6]).

input_clause(c_1916,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,++p3,--p5]).

input_clause(c_1917,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p5,++p6]).

input_clause(c_1918,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6]).

input_clause(c_1919,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p4,++p6]).

input_clause(c_1920,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p6,--p4,--p5]).

input_clause(c_1921,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,--p5,++p6]).

input_clause(c_1922,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6]).

input_clause(c_1923,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p4,++p6]).

input_clause(c_1924,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p4,--p5]).

input_clause(c_1925,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p3,++p4,--p5,++p6]).

input_clause(c_1926,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p3,++p4]).

input_clause(c_1927,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p3,++p6]).

input_clause(c_1928,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p3,--p5]).

input_clause(c_1929,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p2,++p3,--p5,++p6]).

input_clause(c_1930,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p2,++p3]).

input_clause(c_1931,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p2,++p3,++p4,++p6]).

input_clause(c_1932,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p2,++p3,++p4,--p5]).

input_clause(c_1933,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p2,++p4,--p5,++p6]).

input_clause(c_1934,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p2,++p4]).

input_clause(c_1935,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p2,++p6]).

input_clause(c_1936,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p2,--p5]).

input_clause(c_1937,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p1,++p2,--p5,++p6]).

input_clause(c_1938,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p1,++p2]).

input_clause(c_1939,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p1,++p2,++p4,++p6]).

input_clause(c_1940,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p1,++p2,++p4,--p5]).

input_clause(c_1941,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p1,++p2,++p3,++p4,--p5,++p6]).

input_clause(c_1942,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p1,++p2,++p3,++p4]).

input_clause(c_1943,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p1,++p2,++p3,++p6]).

input_clause(c_1944,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p1,++p2,++p3,--p5]).

input_clause(c_1945,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p1,++p3,--p5,++p6]).

input_clause(c_1946,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p1,++p3]).

input_clause(c_1947,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p1,++p3,++p4,++p6]).

input_clause(c_1948,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p1,++p3,++p4,--p5]).

input_clause(c_1949,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p1,++p4,--p5,++p6]).

input_clause(c_1950,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p1,++p4]).

input_clause(c_1951,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p1,++p6]).

input_clause(c_1952,theorem,
    [--p1,--p2,--p3,--p4,++p5,--p6,++p1,--p5]).

input_clause(c_1953,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p1,--p5]).

input_clause(c_1954,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p1,--p6]).

input_clause(c_1955,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p1,++p4]).

input_clause(c_1956,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p1,++p4,--p5,--p6]).

input_clause(c_1957,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p1,++p3,++p4,--p5]).

input_clause(c_1958,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p1,++p3,++p4,--p6]).

input_clause(c_1959,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p1,++p3]).

input_clause(c_1960,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p1,++p3,--p5,--p6]).

input_clause(c_1961,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p1,++p2,++p3,--p5]).

input_clause(c_1962,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p1,++p2,++p3,--p6]).

input_clause(c_1963,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p1,++p2,++p3,++p4]).

input_clause(c_1964,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p1,++p2,++p3,++p4,--p5,--p6]).

input_clause(c_1965,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p1,++p2,++p4,--p5]).

input_clause(c_1966,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p1,++p2,++p4,--p6]).

input_clause(c_1967,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p1,++p2]).

input_clause(c_1968,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p1,++p2,--p5,--p6]).

input_clause(c_1969,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p2,--p5]).

input_clause(c_1970,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p2,--p6]).

input_clause(c_1971,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p2,++p4]).

input_clause(c_1972,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p2,++p4,--p5,--p6]).

input_clause(c_1973,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p2,++p3,++p4,--p5]).

input_clause(c_1974,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p2,++p3,++p4,--p6]).

input_clause(c_1975,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p2,++p3]).

input_clause(c_1976,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p2,++p3,--p5,--p6]).

input_clause(c_1977,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p3,--p5]).

input_clause(c_1978,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p3,--p6]).

input_clause(c_1979,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p3,++p4]).

input_clause(c_1980,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p3,++p4,--p5,--p6]).

input_clause(c_1981,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p4,--p5]).

input_clause(c_1982,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,++p4,--p6]).

input_clause(c_1983,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6]).

input_clause(c_1984,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p6,--p5,--p6]).

input_clause(c_1985,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6]).

input_clause(c_1986,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p5,--p6]).

input_clause(c_1987,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p4,++p5]).

input_clause(c_1988,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p4,--p6]).

input_clause(c_1989,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p3,++p4]).

input_clause(c_1990,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p3,++p4,++p5,--p6]).

input_clause(c_1991,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p3,++p5]).

input_clause(c_1992,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p3,--p6]).

input_clause(c_1993,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p2,++p3]).

input_clause(c_1994,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p2,++p3,++p5,--p6]).

input_clause(c_1995,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p2,++p3,++p4,++p5]).

input_clause(c_1996,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p2,++p3,++p4,--p6]).

input_clause(c_1997,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p2,++p4]).

input_clause(c_1998,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p2,++p4,++p5,--p6]).

input_clause(c_1999,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p2,++p5]).

input_clause(c_2000,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p2,--p6]).

input_clause(c_2001,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p1,++p2]).

input_clause(c_2002,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p1,++p2,++p5,--p6]).

input_clause(c_2003,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p1,++p2,++p4,++p5]).

input_clause(c_2004,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p1,++p2,++p4,--p6]).

input_clause(c_2005,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p1,++p2,++p3,++p4]).

input_clause(c_2006,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p1,++p2,++p3,++p4,++p5,--p6]).

input_clause(c_2007,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p1,++p2,++p3,++p5]).

input_clause(c_2008,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p1,++p2,++p3,--p6]).

input_clause(c_2009,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p1,++p3]).

input_clause(c_2010,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p1,++p3,++p5,--p6]).

input_clause(c_2011,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p1,++p3,++p4,++p5]).

input_clause(c_2012,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p1,++p3,++p4,--p6]).

input_clause(c_2013,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p1,++p4]).

input_clause(c_2014,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p1,++p4,++p5,--p6]).

input_clause(c_2015,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p1,++p5]).

input_clause(c_2016,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p6,++p1,--p6]).

input_clause(c_2017,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p1,++p6]).

input_clause(c_2018,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p1,++p5]).

input_clause(c_2019,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p1,++p4,++p5,++p6]).

input_clause(c_2020,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p1,++p4]).

input_clause(c_2021,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p1,++p3,++p4,++p6]).

input_clause(c_2022,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p1,++p3,++p4,++p5]).

input_clause(c_2023,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p1,++p3,++p5,++p6]).

input_clause(c_2024,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p1,++p3]).

input_clause(c_2025,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p1,++p2,++p3,++p6]).

input_clause(c_2026,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p1,++p2,++p3,++p5]).

input_clause(c_2027,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p1,++p2,++p3,++p4,++p5,++p6]).

input_clause(c_2028,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p1,++p2,++p3,++p4]).

input_clause(c_2029,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p1,++p2,++p4,++p6]).

input_clause(c_2030,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p1,++p2,++p4,++p5]).

input_clause(c_2031,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p1,++p2,++p5,++p6]).

input_clause(c_2032,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p1,++p2]).

input_clause(c_2033,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p2,++p6]).

input_clause(c_2034,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p2,++p5]).

input_clause(c_2035,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p2,++p4,++p5,++p6]).

input_clause(c_2036,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p2,++p4]).

input_clause(c_2037,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p2,++p3,++p4,++p6]).

input_clause(c_2038,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p2,++p3,++p4,++p5]).

input_clause(c_2039,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p2,++p3,++p5,++p6]).

input_clause(c_2040,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p2,++p3]).

input_clause(c_2041,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p3,++p6]).

input_clause(c_2042,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p3,++p5]).

input_clause(c_2043,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p3,++p4,++p5,++p6]).

input_clause(c_2044,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p3,++p4]).

input_clause(c_2045,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p4,++p6]).

input_clause(c_2046,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p4,++p5]).

input_clause(c_2047,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6,++p5,++p6]).

input_clause(c_2048,theorem,
    [--p1,--p2,--p3,--p4,--p5,--p6]).
%--------------------------------------------------------------------------
