%--------------------------------------------------------------------------
% File     : SYN007=FPell71-1.005 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Syntactic
% Problem  : Pelletier Problem 71
% Version  : Theorem formulation : For N = 5.
% English  : Clausal forms of statements of the form :
%            (p1 <-> (p2 <->...(pN <-> (p1 <-> (p2 <->...<-> pN)...)

% Refs     : Pelletier F.J. (1986), Seventy-Five Problems for Testing 
%            Automatic Theorem Provers, Journal of Automated Reasoning 
%            2(2), 191-216.
%          : Urquhart A. (1987), Hard Examples for Resolution, Journal 
%            of the ACM 34(1), 209-219.
% Source   : [Pelletier, 1986]
% Names    : Pelletier 71 [Pelletier, 1986]

% Status   : 
% Syntax   : Number of clauses           :  512 ( 506 non-Horn)(   0 unit)
%            Number of literals          : 3840 (   0 equality)
%            Number of predicate symbols :    5 (   5 propositional)
%            Number of function symbols  :    0 (   0 constant)
%            Number of variables         :    0 (   0 singleton)
%            Maximal clause size         :    9
%            Maximal term depth          :    0

% Comments : The number of distinct letters in U-N is N. The number 
%            of occurrences of sentence letters in 2N. The number 
%            of clauses goes up dramatically as N increases, but I don't 
%            think it shows that the problems are dramatically more 
%            difficult as N increases. Rather, it's that the awkward 
%            clause form representation comes to the fore most 
%            dramatically with embedded biconditionals. On all other 
%            measures of complexity, one should say that the problems 
%            increase linearly in difficulty. Urquhart says that the proof 
%            size of any resolution system increases exponentially with 
%            increase in N.
%          : This problem can also be done in terms of graphs, 
%            as described in Pelletier Problem 74.
%--------------------------------------------------------------------------
input_clause(c_1,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p1,++p5]).

input_clause(c_2,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p1,++p4]).

input_clause(c_3,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p1,++p3,++p4,++p5]).

input_clause(c_4,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p1,++p3]).

input_clause(c_5,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p1,++p2,++p3,++p5]).

input_clause(c_6,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p1,++p2,++p3,++p4]).

input_clause(c_7,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p1,++p2,++p4,++p5]).

input_clause(c_8,theorem,
    [++p1,--p2,--p3,--p4,--p5,--p1,++p2]).

input_clause(c_9,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p2,++p5]).

input_clause(c_10,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p2,++p4]).

input_clause(c_11,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p2,++p3,++p4,++p5]).

input_clause(c_12,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p2,++p3]).

input_clause(c_13,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p3,++p5]).

input_clause(c_14,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p3,++p4]).

input_clause(c_15,theorem,
    [++p1,--p2,--p3,--p4,--p5,++p4,++p5]).

input_clause(c_16,theorem,
    [++p1,--p2,--p3,--p4,--p5]).

input_clause(c_17,theorem,
    [++p1,--p2,--p3,--p4,++p5]).

input_clause(c_18,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p4,--p5]).

input_clause(c_19,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p3,++p4]).

input_clause(c_20,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p3,--p5]).

input_clause(c_21,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p2,++p3]).

input_clause(c_22,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p2,++p3,++p4,--p5]).

input_clause(c_23,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p2,++p4]).

input_clause(c_24,theorem,
    [++p1,--p2,--p3,--p4,++p5,++p2,--p5]).

input_clause(c_25,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p1,++p2]).

input_clause(c_26,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p1,++p2,++p4,--p5]).

input_clause(c_27,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p1,++p2,++p3,++p4]).

input_clause(c_28,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p1,++p2,++p3,--p5]).

input_clause(c_29,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p1,++p3]).

input_clause(c_30,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p1,++p3,++p4,--p5]).

input_clause(c_31,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p1,++p4]).

input_clause(c_32,theorem,
    [++p1,--p2,--p3,--p4,++p5,--p1,--p5]).

input_clause(c_33,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p1,--p4]).

input_clause(c_34,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p1,--p5]).

input_clause(c_35,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p1,++p3]).

input_clause(c_36,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p1,++p3,--p4,--p5]).

input_clause(c_37,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p1,++p2,++p3,--p4]).

input_clause(c_38,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p1,++p2,++p3,--p5]).

input_clause(c_39,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p1,++p2]).

input_clause(c_40,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p1,++p2,--p4,--p5]).

input_clause(c_41,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p2,--p4]).

input_clause(c_42,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p2,--p5]).

input_clause(c_43,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p2,++p3]).

input_clause(c_44,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p2,++p3,--p4,--p5]).

input_clause(c_45,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p3,--p4]).

input_clause(c_46,theorem,
    [++p1,--p2,--p3,++p4,++p5,++p3,--p5]).

input_clause(c_47,theorem,
    [++p1,--p2,--p3,++p4,++p5]).

input_clause(c_48,theorem,
    [++p1,--p2,--p3,++p4,++p5,--p4,--p5]).

input_clause(c_49,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p4,++p5]).

input_clause(c_50,theorem,
    [++p1,--p2,--p3,++p4,--p5]).

input_clause(c_51,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p3,++p5]).

input_clause(c_52,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p3,--p4]).

input_clause(c_53,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p2,++p3,--p4,++p5]).

input_clause(c_54,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p2,++p3]).

input_clause(c_55,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p2,++p5]).

input_clause(c_56,theorem,
    [++p1,--p2,--p3,++p4,--p5,++p2,--p4]).

input_clause(c_57,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p1,++p2,--p4,++p5]).

input_clause(c_58,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p1,++p2]).

input_clause(c_59,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p1,++p2,++p3,++p5]).

input_clause(c_60,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p1,++p2,++p3,--p4]).

input_clause(c_61,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p1,++p3,--p4,++p5]).

input_clause(c_62,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p1,++p3]).

input_clause(c_63,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p1,++p5]).

input_clause(c_64,theorem,
    [++p1,--p2,--p3,++p4,--p5,--p1,--p4]).

input_clause(c_65,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p1,--p3,--p4,++p5]).

input_clause(c_66,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p1,--p3]).

input_clause(c_67,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p1,++p5]).

input_clause(c_68,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p1,--p4]).

input_clause(c_69,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p1,++p2,--p4,++p5]).

input_clause(c_70,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p1,++p2]).

input_clause(c_71,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p1,++p2,--p3,++p5]).

input_clause(c_72,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p1,++p2,--p3,--p4]).

input_clause(c_73,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p2,--p3,--p4,++p5]).

input_clause(c_74,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p2,--p3]).

input_clause(c_75,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p2,++p5]).

input_clause(c_76,theorem,
    [++p1,--p2,++p3,++p4,--p5,++p2,--p4]).

input_clause(c_77,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p4,++p5]).

input_clause(c_78,theorem,
    [++p1,--p2,++p3,++p4,--p5]).

input_clause(c_79,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p3,++p5]).

input_clause(c_80,theorem,
    [++p1,--p2,++p3,++p4,--p5,--p3,--p4]).

input_clause(c_81,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p3,--p4]).

input_clause(c_82,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p3,--p5]).

input_clause(c_83,theorem,
    [++p1,--p2,++p3,++p4,++p5]).

input_clause(c_84,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p4,--p5]).

input_clause(c_85,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p2,--p4]).

input_clause(c_86,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p2,--p5]).

input_clause(c_87,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p2,--p3]).

input_clause(c_88,theorem,
    [++p1,--p2,++p3,++p4,++p5,++p2,--p3,--p4,--p5]).

input_clause(c_89,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p1,++p2,--p3,--p4]).

input_clause(c_90,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p1,++p2,--p3,--p5]).

input_clause(c_91,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p1,++p2]).

input_clause(c_92,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p1,++p2,--p4,--p5]).

input_clause(c_93,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p1,--p4]).

input_clause(c_94,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p1,--p5]).

input_clause(c_95,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p1,--p3]).

input_clause(c_96,theorem,
    [++p1,--p2,++p3,++p4,++p5,--p1,--p3,--p4,--p5]).

input_clause(c_97,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p1,--p3]).

input_clause(c_98,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p1,--p3,++p4,--p5]).

input_clause(c_99,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p1,++p4]).

input_clause(c_100,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p1,--p5]).

input_clause(c_101,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p1,++p2]).

input_clause(c_102,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p1,++p2,++p4,--p5]).

input_clause(c_103,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p1,++p2,--p3,++p4]).

input_clause(c_104,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p1,++p2,--p3,--p5]).

input_clause(c_105,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p2,--p3]).

input_clause(c_106,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p2,--p3,++p4,--p5]).

input_clause(c_107,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p2,++p4]).

input_clause(c_108,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p2,--p5]).

input_clause(c_109,theorem,
    [++p1,--p2,++p3,--p4,++p5]).

input_clause(c_110,theorem,
    [++p1,--p2,++p3,--p4,++p5,++p4,--p5]).

input_clause(c_111,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p3,++p4]).

input_clause(c_112,theorem,
    [++p1,--p2,++p3,--p4,++p5,--p3,--p5]).

input_clause(c_113,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p3,++p5]).

input_clause(c_114,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p3,++p4]).

input_clause(c_115,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p4,++p5]).

input_clause(c_116,theorem,
    [++p1,--p2,++p3,--p4,--p5]).

input_clause(c_117,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p2,++p5]).

input_clause(c_118,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p2,++p4]).

input_clause(c_119,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p2,--p3,++p4,++p5]).

input_clause(c_120,theorem,
    [++p1,--p2,++p3,--p4,--p5,++p2,--p3]).

input_clause(c_121,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p1,++p2,--p3,++p5]).

input_clause(c_122,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p1,++p2,--p3,++p4]).

input_clause(c_123,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p1,++p2,++p4,++p5]).

input_clause(c_124,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p1,++p2]).

input_clause(c_125,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p1,++p5]).

input_clause(c_126,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p1,++p4]).

input_clause(c_127,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p1,--p3,++p4,++p5]).

input_clause(c_128,theorem,
    [++p1,--p2,++p3,--p4,--p5,--p1,--p3]).

input_clause(c_129,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p1,--p2,--p3,++p5]).

input_clause(c_130,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p1,--p2,--p3,++p4]).

input_clause(c_131,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p1,--p2,++p4,++p5]).

input_clause(c_132,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p1,--p2]).

input_clause(c_133,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p1,++p5]).

input_clause(c_134,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p1,++p4]).

input_clause(c_135,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p1,--p3,++p4,++p5]).

input_clause(c_136,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p1,--p3]).

input_clause(c_137,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p3,++p5]).

input_clause(c_138,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p3,++p4]).

input_clause(c_139,theorem,
    [++p1,++p2,++p3,--p4,--p5,++p4,++p5]).

input_clause(c_140,theorem,
    [++p1,++p2,++p3,--p4,--p5]).

input_clause(c_141,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p2,++p5]).

input_clause(c_142,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p2,++p4]).

input_clause(c_143,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p2,--p3,++p4,++p5]).

input_clause(c_144,theorem,
    [++p1,++p2,++p3,--p4,--p5,--p2,--p3]).

input_clause(c_145,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p2,--p3]).

input_clause(c_146,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p2,--p3,++p4,--p5]).

input_clause(c_147,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p2,++p4]).

input_clause(c_148,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p2,--p5]).

input_clause(c_149,theorem,
    [++p1,++p2,++p3,--p4,++p5]).

input_clause(c_150,theorem,
    [++p1,++p2,++p3,--p4,++p5,++p4,--p5]).

input_clause(c_151,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p3,++p4]).

input_clause(c_152,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p3,--p5]).

input_clause(c_153,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p1,--p3]).

input_clause(c_154,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p1,--p3,++p4,--p5]).

input_clause(c_155,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p1,++p4]).

input_clause(c_156,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p1,--p5]).

input_clause(c_157,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p1,--p2]).

input_clause(c_158,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p1,--p2,++p4,--p5]).

input_clause(c_159,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p1,--p2,--p3,++p4]).

input_clause(c_160,theorem,
    [++p1,++p2,++p3,--p4,++p5,--p1,--p2,--p3,--p5]).

input_clause(c_161,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p1,--p2,--p3,--p4]).

input_clause(c_162,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p1,--p2,--p3,--p5]).

input_clause(c_163,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p1,--p2]).

input_clause(c_164,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p1,--p2,--p4,--p5]).

input_clause(c_165,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p1,--p4]).

input_clause(c_166,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p1,--p5]).

input_clause(c_167,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p1,--p3]).

input_clause(c_168,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p1,--p3,--p4,--p5]).

input_clause(c_169,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p3,--p4]).

input_clause(c_170,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p3,--p5]).

input_clause(c_171,theorem,
    [++p1,++p2,++p3,++p4,++p5]).

input_clause(c_172,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p4,--p5]).

input_clause(c_173,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p2,--p4]).

input_clause(c_174,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p2,--p5]).

input_clause(c_175,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p2,--p3]).

input_clause(c_176,theorem,
    [++p1,++p2,++p3,++p4,++p5,--p2,--p3,--p4,--p5]).

input_clause(c_177,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p2,--p3,--p4,++p5]).

input_clause(c_178,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p2,--p3]).

input_clause(c_179,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p2,++p5]).

input_clause(c_180,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p2,--p4]).

input_clause(c_181,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p4,++p5]).

input_clause(c_182,theorem,
    [++p1,++p2,++p3,++p4,--p5]).

input_clause(c_183,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p3,++p5]).

input_clause(c_184,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p3,--p4]).

input_clause(c_185,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p1,--p3,--p4,++p5]).

input_clause(c_186,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p1,--p3]).

input_clause(c_187,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p1,++p5]).

input_clause(c_188,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p1,--p4]).

input_clause(c_189,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p1,--p2,--p4,++p5]).

input_clause(c_190,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p1,--p2]).

input_clause(c_191,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p1,--p2,--p3,++p5]).

input_clause(c_192,theorem,
    [++p1,++p2,++p3,++p4,--p5,--p1,--p2,--p3,--p4]).

input_clause(c_193,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p1,--p2,--p4,++p5]).

input_clause(c_194,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p1,--p2]).

input_clause(c_195,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p1,--p2,++p3,++p5]).

input_clause(c_196,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p1,--p2,++p3,--p4]).

input_clause(c_197,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p1,++p3,--p4,++p5]).

input_clause(c_198,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p1,++p3]).

input_clause(c_199,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p1,++p5]).

input_clause(c_200,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p1,--p4]).

input_clause(c_201,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p4,++p5]).

input_clause(c_202,theorem,
    [++p1,++p2,--p3,++p4,--p5]).

input_clause(c_203,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p3,++p5]).

input_clause(c_204,theorem,
    [++p1,++p2,--p3,++p4,--p5,++p3,--p4]).

input_clause(c_205,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p2,++p3,--p4,++p5]).

input_clause(c_206,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p2,++p3]).

input_clause(c_207,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p2,++p5]).

input_clause(c_208,theorem,
    [++p1,++p2,--p3,++p4,--p5,--p2,--p4]).

input_clause(c_209,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p2,--p4]).

input_clause(c_210,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p2,--p5]).

input_clause(c_211,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p2,++p3]).

input_clause(c_212,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p2,++p3,--p4,--p5]).

input_clause(c_213,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p3,--p4]).

input_clause(c_214,theorem,
    [++p1,++p2,--p3,++p4,++p5,++p3,--p5]).

input_clause(c_215,theorem,
    [++p1,++p2,--p3,++p4,++p5]).

input_clause(c_216,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p4,--p5]).

input_clause(c_217,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p1,--p4]).

input_clause(c_218,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p1,--p5]).

input_clause(c_219,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p1,++p3]).

input_clause(c_220,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p1,++p3,--p4,--p5]).

input_clause(c_221,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p1,--p2,++p3,--p4]).

input_clause(c_222,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p1,--p2,++p3,--p5]).

input_clause(c_223,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p1,--p2]).

input_clause(c_224,theorem,
    [++p1,++p2,--p3,++p4,++p5,--p1,--p2,--p4,--p5]).

input_clause(c_225,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p1,--p2]).

input_clause(c_226,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p1,--p2,++p4,--p5]).

input_clause(c_227,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p1,--p2,++p3,++p4]).

input_clause(c_228,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p1,--p2,++p3,--p5]).

input_clause(c_229,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p1,++p3]).

input_clause(c_230,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p1,++p3,++p4,--p5]).

input_clause(c_231,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p1,++p4]).

input_clause(c_232,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p1,--p5]).

input_clause(c_233,theorem,
    [++p1,++p2,--p3,--p4,++p5]).

input_clause(c_234,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p4,--p5]).

input_clause(c_235,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p3,++p4]).

input_clause(c_236,theorem,
    [++p1,++p2,--p3,--p4,++p5,++p3,--p5]).

input_clause(c_237,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p2,++p3]).

input_clause(c_238,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p2,++p3,++p4,--p5]).

input_clause(c_239,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p2,++p4]).

input_clause(c_240,theorem,
    [++p1,++p2,--p3,--p4,++p5,--p2,--p5]).

input_clause(c_241,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p2,++p5]).

input_clause(c_242,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p2,++p4]).

input_clause(c_243,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p2,++p3,++p4,++p5]).

input_clause(c_244,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p2,++p3]).

input_clause(c_245,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p3,++p5]).

input_clause(c_246,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p3,++p4]).

input_clause(c_247,theorem,
    [++p1,++p2,--p3,--p4,--p5,++p4,++p5]).

input_clause(c_248,theorem,
    [++p1,++p2,--p3,--p4,--p5]).

input_clause(c_249,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p1,++p5]).

input_clause(c_250,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p1,++p4]).

input_clause(c_251,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p1,++p3,++p4,++p5]).

input_clause(c_252,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p1,++p3]).

input_clause(c_253,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p1,--p2,++p3,++p5]).

input_clause(c_254,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p1,--p2,++p3,++p4]).

input_clause(c_255,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p1,--p2,++p4,++p5]).

input_clause(c_256,theorem,
    [++p1,++p2,--p3,--p4,--p5,--p1,--p2]).

input_clause(c_257,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p2,++p5]).

input_clause(c_258,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p2,++p4]).

input_clause(c_259,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p2,++p3,++p4,++p5]).

input_clause(c_260,theorem,
    [--p1,++p2,--p3,--p4,--p5,--p2,++p3]).

input_clause(c_261,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p3,++p5]).

input_clause(c_262,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p3,++p4]).

input_clause(c_263,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p4,++p5]).

input_clause(c_264,theorem,
    [--p1,++p2,--p3,--p4,--p5]).

input_clause(c_265,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p1,++p5]).

input_clause(c_266,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p1,++p4]).

input_clause(c_267,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p1,++p3,++p4,++p5]).

input_clause(c_268,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p1,++p3]).

input_clause(c_269,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p1,--p2,++p3,++p5]).

input_clause(c_270,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p1,--p2,++p3,++p4]).

input_clause(c_271,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p1,--p2,++p4,++p5]).

input_clause(c_272,theorem,
    [--p1,++p2,--p3,--p4,--p5,++p1,--p2]).

input_clause(c_273,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p1,--p2]).

input_clause(c_274,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p1,--p2,++p4,--p5]).

input_clause(c_275,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p1,--p2,++p3,++p4]).

input_clause(c_276,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p1,--p2,++p3,--p5]).

input_clause(c_277,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p1,++p3]).

input_clause(c_278,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p1,++p3,++p4,--p5]).

input_clause(c_279,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p1,++p4]).

input_clause(c_280,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p1,--p5]).

input_clause(c_281,theorem,
    [--p1,++p2,--p3,--p4,++p5]).

input_clause(c_282,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p4,--p5]).

input_clause(c_283,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p3,++p4]).

input_clause(c_284,theorem,
    [--p1,++p2,--p3,--p4,++p5,++p3,--p5]).

input_clause(c_285,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p2,++p3]).

input_clause(c_286,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p2,++p3,++p4,--p5]).

input_clause(c_287,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p2,++p4]).

input_clause(c_288,theorem,
    [--p1,++p2,--p3,--p4,++p5,--p2,--p5]).

input_clause(c_289,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p2,--p4]).

input_clause(c_290,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p2,--p5]).

input_clause(c_291,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p2,++p3]).

input_clause(c_292,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p2,++p3,--p4,--p5]).

input_clause(c_293,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p3,--p4]).

input_clause(c_294,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p3,--p5]).

input_clause(c_295,theorem,
    [--p1,++p2,--p3,++p4,++p5]).

input_clause(c_296,theorem,
    [--p1,++p2,--p3,++p4,++p5,--p4,--p5]).

input_clause(c_297,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p1,--p4]).

input_clause(c_298,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p1,--p5]).

input_clause(c_299,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p1,++p3]).

input_clause(c_300,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p1,++p3,--p4,--p5]).

input_clause(c_301,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p1,--p2,++p3,--p4]).

input_clause(c_302,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p1,--p2,++p3,--p5]).

input_clause(c_303,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p1,--p2]).

input_clause(c_304,theorem,
    [--p1,++p2,--p3,++p4,++p5,++p1,--p2,--p4,--p5]).

input_clause(c_305,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p1,--p2,--p4,++p5]).

input_clause(c_306,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p1,--p2]).

input_clause(c_307,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p1,--p2,++p3,++p5]).

input_clause(c_308,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p1,--p2,++p3,--p4]).

input_clause(c_309,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p1,++p3,--p4,++p5]).

input_clause(c_310,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p1,++p3]).

input_clause(c_311,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p1,++p5]).

input_clause(c_312,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p1,--p4]).

input_clause(c_313,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p4,++p5]).

input_clause(c_314,theorem,
    [--p1,++p2,--p3,++p4,--p5]).

input_clause(c_315,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p3,++p5]).

input_clause(c_316,theorem,
    [--p1,++p2,--p3,++p4,--p5,++p3,--p4]).

input_clause(c_317,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p2,++p3,--p4,++p5]).

input_clause(c_318,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p2,++p3]).

input_clause(c_319,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p2,++p5]).

input_clause(c_320,theorem,
    [--p1,++p2,--p3,++p4,--p5,--p2,--p4]).

input_clause(c_321,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p2,--p3,--p4,++p5]).

input_clause(c_322,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p2,--p3]).

input_clause(c_323,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p2,++p5]).

input_clause(c_324,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p2,--p4]).

input_clause(c_325,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p4,++p5]).

input_clause(c_326,theorem,
    [--p1,++p2,++p3,++p4,--p5]).

input_clause(c_327,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p3,++p5]).

input_clause(c_328,theorem,
    [--p1,++p2,++p3,++p4,--p5,--p3,--p4]).

input_clause(c_329,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p1,--p3,--p4,++p5]).

input_clause(c_330,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p1,--p3]).

input_clause(c_331,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p1,++p5]).

input_clause(c_332,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p1,--p4]).

input_clause(c_333,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p1,--p2,--p4,++p5]).

input_clause(c_334,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p1,--p2]).

input_clause(c_335,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p1,--p2,--p3,++p5]).

input_clause(c_336,theorem,
    [--p1,++p2,++p3,++p4,--p5,++p1,--p2,--p3,--p4]).

input_clause(c_337,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p1,--p2,--p3,--p4]).

input_clause(c_338,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p1,--p2,--p3,--p5]).

input_clause(c_339,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p1,--p2]).

input_clause(c_340,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p1,--p2,--p4,--p5]).

input_clause(c_341,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p1,--p4]).

input_clause(c_342,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p1,--p5]).

input_clause(c_343,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p1,--p3]).

input_clause(c_344,theorem,
    [--p1,++p2,++p3,++p4,++p5,++p1,--p3,--p4,--p5]).

input_clause(c_345,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p3,--p4]).

input_clause(c_346,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p3,--p5]).

input_clause(c_347,theorem,
    [--p1,++p2,++p3,++p4,++p5]).

input_clause(c_348,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p4,--p5]).

input_clause(c_349,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p2,--p4]).

input_clause(c_350,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p2,--p5]).

input_clause(c_351,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p2,--p3]).

input_clause(c_352,theorem,
    [--p1,++p2,++p3,++p4,++p5,--p2,--p3,--p4,--p5]).

input_clause(c_353,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p2,--p3]).

input_clause(c_354,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p2,--p3,++p4,--p5]).

input_clause(c_355,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p2,++p4]).

input_clause(c_356,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p2,--p5]).

input_clause(c_357,theorem,
    [--p1,++p2,++p3,--p4,++p5]).

input_clause(c_358,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p4,--p5]).

input_clause(c_359,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p3,++p4]).

input_clause(c_360,theorem,
    [--p1,++p2,++p3,--p4,++p5,--p3,--p5]).

input_clause(c_361,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p1,--p3]).

input_clause(c_362,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p1,--p3,++p4,--p5]).

input_clause(c_363,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p1,++p4]).

input_clause(c_364,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p1,--p5]).

input_clause(c_365,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p1,--p2]).

input_clause(c_366,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p1,--p2,++p4,--p5]).

input_clause(c_367,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p1,--p2,--p3,++p4]).

input_clause(c_368,theorem,
    [--p1,++p2,++p3,--p4,++p5,++p1,--p2,--p3,--p5]).

input_clause(c_369,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p1,--p2,--p3,++p5]).

input_clause(c_370,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p1,--p2,--p3,++p4]).

input_clause(c_371,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p1,--p2,++p4,++p5]).

input_clause(c_372,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p1,--p2]).

input_clause(c_373,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p1,++p5]).

input_clause(c_374,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p1,++p4]).

input_clause(c_375,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p1,--p3,++p4,++p5]).

input_clause(c_376,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p1,--p3]).

input_clause(c_377,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p3,++p5]).

input_clause(c_378,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p3,++p4]).

input_clause(c_379,theorem,
    [--p1,++p2,++p3,--p4,--p5,++p4,++p5]).

input_clause(c_380,theorem,
    [--p1,++p2,++p3,--p4,--p5]).

input_clause(c_381,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p2,++p5]).

input_clause(c_382,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p2,++p4]).

input_clause(c_383,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p2,--p3,++p4,++p5]).

input_clause(c_384,theorem,
    [--p1,++p2,++p3,--p4,--p5,--p2,--p3]).

input_clause(c_385,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p3,++p5]).

input_clause(c_386,theorem,
    [--p1,--p2,++p3,--p4,--p5,--p3,++p4]).

input_clause(c_387,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p4,++p5]).

input_clause(c_388,theorem,
    [--p1,--p2,++p3,--p4,--p5]).

input_clause(c_389,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p2,++p5]).

input_clause(c_390,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p2,++p4]).

input_clause(c_391,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p2,--p3,++p4,++p5]).

input_clause(c_392,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p2,--p3]).

input_clause(c_393,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p1,++p2,--p3,++p5]).

input_clause(c_394,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p1,++p2,--p3,++p4]).

input_clause(c_395,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p1,++p2,++p4,++p5]).

input_clause(c_396,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p1,++p2]).

input_clause(c_397,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p1,++p5]).

input_clause(c_398,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p1,++p4]).

input_clause(c_399,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p1,--p3,++p4,++p5]).

input_clause(c_400,theorem,
    [--p1,--p2,++p3,--p4,--p5,++p1,--p3]).

input_clause(c_401,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p1,--p3]).

input_clause(c_402,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p1,--p3,++p4,--p5]).

input_clause(c_403,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p1,++p4]).

input_clause(c_404,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p1,--p5]).

input_clause(c_405,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p1,++p2]).

input_clause(c_406,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p1,++p2,++p4,--p5]).

input_clause(c_407,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p1,++p2,--p3,++p4]).

input_clause(c_408,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p1,++p2,--p3,--p5]).

input_clause(c_409,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p2,--p3]).

input_clause(c_410,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p2,--p3,++p4,--p5]).

input_clause(c_411,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p2,++p4]).

input_clause(c_412,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p2,--p5]).

input_clause(c_413,theorem,
    [--p1,--p2,++p3,--p4,++p5]).

input_clause(c_414,theorem,
    [--p1,--p2,++p3,--p4,++p5,++p4,--p5]).

input_clause(c_415,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p3,++p4]).

input_clause(c_416,theorem,
    [--p1,--p2,++p3,--p4,++p5,--p3,--p5]).

input_clause(c_417,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p3,--p4]).

input_clause(c_418,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p3,--p5]).

input_clause(c_419,theorem,
    [--p1,--p2,++p3,++p4,++p5]).

input_clause(c_420,theorem,
    [--p1,--p2,++p3,++p4,++p5,--p4,--p5]).

input_clause(c_421,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p2,--p4]).

input_clause(c_422,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p2,--p5]).

input_clause(c_423,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p2,--p3]).

input_clause(c_424,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p2,--p3,--p4,--p5]).

input_clause(c_425,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p1,++p2,--p3,--p4]).

input_clause(c_426,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p1,++p2,--p3,--p5]).

input_clause(c_427,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p1,++p2]).

input_clause(c_428,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p1,++p2,--p4,--p5]).

input_clause(c_429,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p1,--p4]).

input_clause(c_430,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p1,--p5]).

input_clause(c_431,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p1,--p3]).

input_clause(c_432,theorem,
    [--p1,--p2,++p3,++p4,++p5,++p1,--p3,--p4,--p5]).

input_clause(c_433,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p1,--p3,--p4,++p5]).

input_clause(c_434,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p1,--p3]).

input_clause(c_435,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p1,++p5]).

input_clause(c_436,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p1,--p4]).

input_clause(c_437,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p1,++p2,--p4,++p5]).

input_clause(c_438,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p1,++p2]).

input_clause(c_439,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p1,++p2,--p3,++p5]).

input_clause(c_440,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p1,++p2,--p3,--p4]).

input_clause(c_441,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p2,--p3,--p4,++p5]).

input_clause(c_442,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p2,--p3]).

input_clause(c_443,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p2,++p5]).

input_clause(c_444,theorem,
    [--p1,--p2,++p3,++p4,--p5,++p2,--p4]).

input_clause(c_445,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p4,++p5]).

input_clause(c_446,theorem,
    [--p1,--p2,++p3,++p4,--p5]).

input_clause(c_447,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p3,++p5]).

input_clause(c_448,theorem,
    [--p1,--p2,++p3,++p4,--p5,--p3,--p4]).

input_clause(c_449,theorem,
    [--p1,--p2,--p3,++p4,--p5,--p4,++p5]).

input_clause(c_450,theorem,
    [--p1,--p2,--p3,++p4,--p5]).

input_clause(c_451,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p3,++p5]).

input_clause(c_452,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p3,--p4]).

input_clause(c_453,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p2,++p3,--p4,++p5]).

input_clause(c_454,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p2,++p3]).

input_clause(c_455,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p2,++p5]).

input_clause(c_456,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p2,--p4]).

input_clause(c_457,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p1,++p2,--p4,++p5]).

input_clause(c_458,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p1,++p2]).

input_clause(c_459,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p1,++p2,++p3,++p5]).

input_clause(c_460,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p1,++p2,++p3,--p4]).

input_clause(c_461,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p1,++p3,--p4,++p5]).

input_clause(c_462,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p1,++p3]).

input_clause(c_463,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p1,++p5]).

input_clause(c_464,theorem,
    [--p1,--p2,--p3,++p4,--p5,++p1,--p4]).

input_clause(c_465,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p1,--p4]).

input_clause(c_466,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p1,--p5]).

input_clause(c_467,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p1,++p3]).

input_clause(c_468,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p1,++p3,--p4,--p5]).

input_clause(c_469,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p1,++p2,++p3,--p4]).

input_clause(c_470,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p1,++p2,++p3,--p5]).

input_clause(c_471,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p1,++p2]).

input_clause(c_472,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p1,++p2,--p4,--p5]).

input_clause(c_473,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p2,--p4]).

input_clause(c_474,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p2,--p5]).

input_clause(c_475,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p2,++p3]).

input_clause(c_476,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p2,++p3,--p4,--p5]).

input_clause(c_477,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p3,--p4]).

input_clause(c_478,theorem,
    [--p1,--p2,--p3,++p4,++p5,++p3,--p5]).

input_clause(c_479,theorem,
    [--p1,--p2,--p3,++p4,++p5]).

input_clause(c_480,theorem,
    [--p1,--p2,--p3,++p4,++p5,--p4,--p5]).

input_clause(c_481,theorem,
    [--p1,--p2,--p3,--p4,++p5]).

input_clause(c_482,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p4,--p5]).

input_clause(c_483,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p3,++p4]).

input_clause(c_484,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p3,--p5]).

input_clause(c_485,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p2,++p3]).

input_clause(c_486,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p2,++p3,++p4,--p5]).

input_clause(c_487,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p2,++p4]).

input_clause(c_488,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p2,--p5]).

input_clause(c_489,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p1,++p2]).

input_clause(c_490,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p1,++p2,++p4,--p5]).

input_clause(c_491,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p1,++p2,++p3,++p4]).

input_clause(c_492,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p1,++p2,++p3,--p5]).

input_clause(c_493,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p1,++p3]).

input_clause(c_494,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p1,++p3,++p4,--p5]).

input_clause(c_495,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p1,++p4]).

input_clause(c_496,theorem,
    [--p1,--p2,--p3,--p4,++p5,++p1,--p5]).

input_clause(c_497,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p1,++p5]).

input_clause(c_498,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p1,++p4]).

input_clause(c_499,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p1,++p3,++p4,++p5]).

input_clause(c_500,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p1,++p3]).

input_clause(c_501,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p1,++p2,++p3,++p5]).

input_clause(c_502,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p1,++p2,++p3,++p4]).

input_clause(c_503,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p1,++p2,++p4,++p5]).

input_clause(c_504,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p1,++p2]).

input_clause(c_505,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p2,++p5]).

input_clause(c_506,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p2,++p4]).

input_clause(c_507,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p2,++p3,++p4,++p5]).

input_clause(c_508,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p2,++p3]).

input_clause(c_509,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p3,++p5]).

input_clause(c_510,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p3,++p4]).

input_clause(c_511,theorem,
    [--p1,--p2,--p3,--p4,--p5,++p4,++p5]).

input_clause(c_512,theorem,
    [--p1,--p2,--p3,--p4,--p5]).
%--------------------------------------------------------------------------
