%--------------------------------------------------------------------------
% File     : SYN007=FPell71-1.004 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Syntactic
% Problem  : Pelletier Problem 71
% Version  : Theorem formulation : For N = 4.
% English  : Clausal forms of statements of the form :
%            (p1 <-> (p2 <->...(pN <-> (p1 <-> (p2 <->...<-> pN)...)

% Refs     : Pelletier F.J. (1986), Seventy-Five Problems for Testing 
%            Automatic Theorem Provers, Journal of Automated Reasoning 
%            2(2), 191-216.
%          : Urquhart A. (1987), Hard Examples for Resolution, Journal 
%            of the ACM 34(1), 209-219.
% Source   : [Pelletier, 1986]
% Names    : Pelletier 71 [Pelletier, 1986]

% Status   : 
% Syntax   : Number of clauses           :  128 ( 123 non-Horn)(   0 unit)
%            Number of literals          :  768 (   0 equality)
%            Number of predicate symbols :    4 (   4 propositional)
%            Number of function symbols  :    0 (   0 constant)
%            Number of variables         :    0 (   0 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    0

% Comments : The number of distinct letters in U-N is N. The number 
%            of occurrences of sentence letters in 2N. The number 
%            of clauses goes up dramatically as N increases, but I don't 
%            think it shows that the problems are dramatically more 
%            difficult as N increases. Rather, it's that the awkward 
%            clause form representation comes to the fore most 
%            dramatically with embedded biconditionals. On all other 
%            measures of complexity, one should say that the problems 
%            increase linearly in difficulty. Urquhart says that the proof 
%            size of any resolution system increases exponentially with 
%            increase in N.
%          : This problem can also be done in terms of graphs, 
%            as described in Pelletier Problem 74.
%--------------------------------------------------------------------------
input_clause(c_1,theorem,
    [++p1,--p2,--p3,--p4,--p1,++p4]).

input_clause(c_2,theorem,
    [++p1,--p2,--p3,--p4,--p1,++p3]).

input_clause(c_3,theorem,
    [++p1,--p2,--p3,--p4,--p1,++p2,++p3,++p4]).

input_clause(c_4,theorem,
    [++p1,--p2,--p3,--p4,--p1,++p2]).

input_clause(c_5,theorem,
    [++p1,--p2,--p3,--p4,++p2,++p4]).

input_clause(c_6,theorem,
    [++p1,--p2,--p3,--p4,++p2,++p3]).

input_clause(c_7,theorem,
    [++p1,--p2,--p3,--p4,++p3,++p4]).

input_clause(c_8,theorem,
    [++p1,--p2,--p3,--p4]).

input_clause(c_9,theorem,
    [++p1,--p2,--p3,++p4]).

input_clause(c_10,theorem,
    [++p1,--p2,--p3,++p4,++p3,--p4]).

input_clause(c_11,theorem,
    [++p1,--p2,--p3,++p4,++p2,++p3]).

input_clause(c_12,theorem,
    [++p1,--p2,--p3,++p4,++p2,--p4]).

input_clause(c_13,theorem,
    [++p1,--p2,--p3,++p4,--p1,++p2]).

input_clause(c_14,theorem,
    [++p1,--p2,--p3,++p4,--p1,++p2,++p3,--p4]).

input_clause(c_15,theorem,
    [++p1,--p2,--p3,++p4,--p1,++p3]).

input_clause(c_16,theorem,
    [++p1,--p2,--p3,++p4,--p1,--p4]).

input_clause(c_17,theorem,
    [++p1,--p2,++p3,++p4,--p1,--p3]).

input_clause(c_18,theorem,
    [++p1,--p2,++p3,++p4,--p1,--p4]).

input_clause(c_19,theorem,
    [++p1,--p2,++p3,++p4,--p1,++p2]).

input_clause(c_20,theorem,
    [++p1,--p2,++p3,++p4,--p1,++p2,--p3,--p4]).

input_clause(c_21,theorem,
    [++p1,--p2,++p3,++p4,++p2,--p3]).

input_clause(c_22,theorem,
    [++p1,--p2,++p3,++p4,++p2,--p4]).

input_clause(c_23,theorem,
    [++p1,--p2,++p3,++p4]).

input_clause(c_24,theorem,
    [++p1,--p2,++p3,++p4,--p3,--p4]).

input_clause(c_25,theorem,
    [++p1,--p2,++p3,--p4,--p3,++p4]).

input_clause(c_26,theorem,
    [++p1,--p2,++p3,--p4]).

input_clause(c_27,theorem,
    [++p1,--p2,++p3,--p4,++p2,++p4]).

input_clause(c_28,theorem,
    [++p1,--p2,++p3,--p4,++p2,--p3]).

input_clause(c_29,theorem,
    [++p1,--p2,++p3,--p4,--p1,++p2,--p3,++p4]).

input_clause(c_30,theorem,
    [++p1,--p2,++p3,--p4,--p1,++p2]).

input_clause(c_31,theorem,
    [++p1,--p2,++p3,--p4,--p1,++p4]).

input_clause(c_32,theorem,
    [++p1,--p2,++p3,--p4,--p1,--p3]).

input_clause(c_33,theorem,
    [++p1,++p2,++p3,--p4,--p1,--p2,--p3,++p4]).

input_clause(c_34,theorem,
    [++p1,++p2,++p3,--p4,--p1,--p2]).

input_clause(c_35,theorem,
    [++p1,++p2,++p3,--p4,--p1,++p4]).

input_clause(c_36,theorem,
    [++p1,++p2,++p3,--p4,--p1,--p3]).

input_clause(c_37,theorem,
    [++p1,++p2,++p3,--p4,--p3,++p4]).

input_clause(c_38,theorem,
    [++p1,++p2,++p3,--p4]).

input_clause(c_39,theorem,
    [++p1,++p2,++p3,--p4,--p2,++p4]).

input_clause(c_40,theorem,
    [++p1,++p2,++p3,--p4,--p2,--p3]).

input_clause(c_41,theorem,
    [++p1,++p2,++p3,++p4,--p2,--p3]).

input_clause(c_42,theorem,
    [++p1,++p2,++p3,++p4,--p2,--p4]).

input_clause(c_43,theorem,
    [++p1,++p2,++p3,++p4]).

input_clause(c_44,theorem,
    [++p1,++p2,++p3,++p4,--p3,--p4]).

input_clause(c_45,theorem,
    [++p1,++p2,++p3,++p4,--p1,--p3]).

input_clause(c_46,theorem,
    [++p1,++p2,++p3,++p4,--p1,--p4]).

input_clause(c_47,theorem,
    [++p1,++p2,++p3,++p4,--p1,--p2]).

input_clause(c_48,theorem,
    [++p1,++p2,++p3,++p4,--p1,--p2,--p3,--p4]).

input_clause(c_49,theorem,
    [++p1,++p2,--p3,++p4,--p1,--p2]).

input_clause(c_50,theorem,
    [++p1,++p2,--p3,++p4,--p1,--p2,++p3,--p4]).

input_clause(c_51,theorem,
    [++p1,++p2,--p3,++p4,--p1,++p3]).

input_clause(c_52,theorem,
    [++p1,++p2,--p3,++p4,--p1,--p4]).

input_clause(c_53,theorem,
    [++p1,++p2,--p3,++p4]).

input_clause(c_54,theorem,
    [++p1,++p2,--p3,++p4,++p3,--p4]).

input_clause(c_55,theorem,
    [++p1,++p2,--p3,++p4,--p2,++p3]).

input_clause(c_56,theorem,
    [++p1,++p2,--p3,++p4,--p2,--p4]).

input_clause(c_57,theorem,
    [++p1,++p2,--p3,--p4,--p2,++p4]).

input_clause(c_58,theorem,
    [++p1,++p2,--p3,--p4,--p2,++p3]).

input_clause(c_59,theorem,
    [++p1,++p2,--p3,--p4,++p3,++p4]).

input_clause(c_60,theorem,
    [++p1,++p2,--p3,--p4]).

input_clause(c_61,theorem,
    [++p1,++p2,--p3,--p4,--p1,++p4]).

input_clause(c_62,theorem,
    [++p1,++p2,--p3,--p4,--p1,++p3]).

input_clause(c_63,theorem,
    [++p1,++p2,--p3,--p4,--p1,--p2,++p3,++p4]).

input_clause(c_64,theorem,
    [++p1,++p2,--p3,--p4,--p1,--p2]).

input_clause(c_65,theorem,
    [--p1,++p2,--p3,--p4,--p2,++p4]).

input_clause(c_66,theorem,
    [--p1,++p2,--p3,--p4,--p2,++p3]).

input_clause(c_67,theorem,
    [--p1,++p2,--p3,--p4,++p3,++p4]).

input_clause(c_68,theorem,
    [--p1,++p2,--p3,--p4]).

input_clause(c_69,theorem,
    [--p1,++p2,--p3,--p4,++p1,++p4]).

input_clause(c_70,theorem,
    [--p1,++p2,--p3,--p4,++p1,++p3]).

input_clause(c_71,theorem,
    [--p1,++p2,--p3,--p4,++p1,--p2,++p3,++p4]).

input_clause(c_72,theorem,
    [--p1,++p2,--p3,--p4,++p1,--p2]).

input_clause(c_73,theorem,
    [--p1,++p2,--p3,++p4,++p1,--p2]).

input_clause(c_74,theorem,
    [--p1,++p2,--p3,++p4,++p1,--p2,++p3,--p4]).

input_clause(c_75,theorem,
    [--p1,++p2,--p3,++p4,++p1,++p3]).

input_clause(c_76,theorem,
    [--p1,++p2,--p3,++p4,++p1,--p4]).

input_clause(c_77,theorem,
    [--p1,++p2,--p3,++p4]).

input_clause(c_78,theorem,
    [--p1,++p2,--p3,++p4,++p3,--p4]).

input_clause(c_79,theorem,
    [--p1,++p2,--p3,++p4,--p2,++p3]).

input_clause(c_80,theorem,
    [--p1,++p2,--p3,++p4,--p2,--p4]).

input_clause(c_81,theorem,
    [--p1,++p2,++p3,++p4,--p2,--p3]).

input_clause(c_82,theorem,
    [--p1,++p2,++p3,++p4,--p2,--p4]).

input_clause(c_83,theorem,
    [--p1,++p2,++p3,++p4]).

input_clause(c_84,theorem,
    [--p1,++p2,++p3,++p4,--p3,--p4]).

input_clause(c_85,theorem,
    [--p1,++p2,++p3,++p4,++p1,--p3]).

input_clause(c_86,theorem,
    [--p1,++p2,++p3,++p4,++p1,--p4]).

input_clause(c_87,theorem,
    [--p1,++p2,++p3,++p4,++p1,--p2]).

input_clause(c_88,theorem,
    [--p1,++p2,++p3,++p4,++p1,--p2,--p3,--p4]).

input_clause(c_89,theorem,
    [--p1,++p2,++p3,--p4,++p1,--p2,--p3,++p4]).

input_clause(c_90,theorem,
    [--p1,++p2,++p3,--p4,++p1,--p2]).

input_clause(c_91,theorem,
    [--p1,++p2,++p3,--p4,++p1,++p4]).

input_clause(c_92,theorem,
    [--p1,++p2,++p3,--p4,++p1,--p3]).

input_clause(c_93,theorem,
    [--p1,++p2,++p3,--p4,--p3,++p4]).

input_clause(c_94,theorem,
    [--p1,++p2,++p3,--p4]).

input_clause(c_95,theorem,
    [--p1,++p2,++p3,--p4,--p2,++p4]).

input_clause(c_96,theorem,
    [--p1,++p2,++p3,--p4,--p2,--p3]).

input_clause(c_97,theorem,
    [--p1,--p2,++p3,--p4,--p3,++p4]).

input_clause(c_98,theorem,
    [--p1,--p2,++p3,--p4]).

input_clause(c_99,theorem,
    [--p1,--p2,++p3,--p4,++p2,++p4]).

input_clause(c_100,theorem,
    [--p1,--p2,++p3,--p4,++p2,--p3]).

input_clause(c_101,theorem,
    [--p1,--p2,++p3,--p4,++p1,++p2,--p3,++p4]).

input_clause(c_102,theorem,
    [--p1,--p2,++p3,--p4,++p1,++p2]).

input_clause(c_103,theorem,
    [--p1,--p2,++p3,--p4,++p1,++p4]).

input_clause(c_104,theorem,
    [--p1,--p2,++p3,--p4,++p1,--p3]).

input_clause(c_105,theorem,
    [--p1,--p2,++p3,++p4,++p1,--p3]).

input_clause(c_106,theorem,
    [--p1,--p2,++p3,++p4,++p1,--p4]).

input_clause(c_107,theorem,
    [--p1,--p2,++p3,++p4,++p1,++p2]).

input_clause(c_108,theorem,
    [--p1,--p2,++p3,++p4,++p1,++p2,--p3,--p4]).

input_clause(c_109,theorem,
    [--p1,--p2,++p3,++p4,++p2,--p3]).

input_clause(c_110,theorem,
    [--p1,--p2,++p3,++p4,++p2,--p4]).

input_clause(c_111,theorem,
    [--p1,--p2,++p3,++p4]).

input_clause(c_112,theorem,
    [--p1,--p2,++p3,++p4,--p3,--p4]).

input_clause(c_113,theorem,
    [--p1,--p2,--p3,++p4]).

input_clause(c_114,theorem,
    [--p1,--p2,--p3,++p4,++p3,--p4]).

input_clause(c_115,theorem,
    [--p1,--p2,--p3,++p4,++p2,++p3]).

input_clause(c_116,theorem,
    [--p1,--p2,--p3,++p4,++p2,--p4]).

input_clause(c_117,theorem,
    [--p1,--p2,--p3,++p4,++p1,++p2]).

input_clause(c_118,theorem,
    [--p1,--p2,--p3,++p4,++p1,++p2,++p3,--p4]).

input_clause(c_119,theorem,
    [--p1,--p2,--p3,++p4,++p1,++p3]).

input_clause(c_120,theorem,
    [--p1,--p2,--p3,++p4,++p1,--p4]).

input_clause(c_121,theorem,
    [--p1,--p2,--p3,--p4,++p1,++p4]).

input_clause(c_122,theorem,
    [--p1,--p2,--p3,--p4,++p1,++p3]).

input_clause(c_123,theorem,
    [--p1,--p2,--p3,--p4,++p1,++p2,++p3,++p4]).

input_clause(c_124,theorem,
    [--p1,--p2,--p3,--p4,++p1,++p2]).

input_clause(c_125,theorem,
    [--p1,--p2,--p3,--p4,++p2,++p4]).

input_clause(c_126,theorem,
    [--p1,--p2,--p3,--p4,++p2,++p3]).

input_clause(c_127,theorem,
    [--p1,--p2,--p3,--p4,++p3,++p4]).

input_clause(c_128,theorem,
    [--p1,--p2,--p3,--p4]).
%--------------------------------------------------------------------------
