%--------------------------------------------------------------------------
% File     : SYN007=FPell71-1.003 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Syntactic
% Problem  : Pelletier Problem 71
% Version  : Theorem formulation : For N = 3.
% English  : Clausal forms of statements of the form :
%            (p1 <-> (p2 <->...(pN <-> (p1 <-> (p2 <->...<-> pN)...)

% Refs     : Pelletier F.J. (1986), Seventy-Five Problems for Testing 
%            Automatic Theorem Provers, Journal of Automated Reasoning 
%            2(2), 191-216.
%          : Urquhart A. (1987), Hard Examples for Resolution, Journal 
%            of the ACM 34(1), 209-219.
% Source   : [Pelletier, 1986]
% Names    : Pelletier 71 [Pelletier, 1986]

% Status   : 
% Syntax   : Number of clauses           :   32 (  28 non-Horn)(   0 unit)
%            Number of literals          :  144 (   0 equality)
%            Number of predicate symbols :    3 (   3 propositional)
%            Number of function symbols  :    0 (   0 constant)
%            Number of variables         :    0 (   0 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    0

% Comments : The number of distinct letters in U-N is N. The number 
%            of occurrences of sentence letters in 2N. The number 
%            of clauses goes up dramatically as N increases, but I don't 
%            think it shows that the problems are dramatically more 
%            difficult as N increases. Rather, it's that the awkward 
%            clause form representation comes to the fore most 
%            dramatically with embedded biconditionals. On all other 
%            measures of complexity, one should say that the problems 
%            increase linearly in difficulty. Urquhart says that the proof 
%            size of any resolution system increases exponentially with 
%            increase in N.
%          : This problem can also be done in terms of graphs, 
%            as described in Pelletier Problem 74.
%--------------------------------------------------------------------------
input_clause(c_1,theorem,
    [++p1,--p2,--p3,--p1,++p3]).

input_clause(c_2,theorem,
    [++p1,--p2,--p3,--p1,++p2]).

input_clause(c_3,theorem,
    [++p1,--p2,--p3,++p2,++p3]).

input_clause(c_4,theorem,
    [++p1,--p2,--p3]).

input_clause(c_5,theorem,
    [++p1,--p2,++p3]).

input_clause(c_6,theorem,
    [++p1,--p2,++p3,++p2,--p3]).

input_clause(c_7,theorem,
    [++p1,--p2,++p3,--p1,++p2]).

input_clause(c_8,theorem,
    [++p1,--p2,++p3,--p1,--p3]).

input_clause(c_9,theorem,
    [++p1,++p2,++p3,--p1,--p2]).

input_clause(c_10,theorem,
    [++p1,++p2,++p3,--p1,--p3]).

input_clause(c_11,theorem,
    [++p1,++p2,++p3]).

input_clause(c_12,theorem,
    [++p1,++p2,++p3,--p2,--p3]).

input_clause(c_13,theorem,
    [++p1,++p2,--p3,--p2,++p3]).

input_clause(c_14,theorem,
    [++p1,++p2,--p3]).

input_clause(c_15,theorem,
    [++p1,++p2,--p3,--p1,++p3]).

input_clause(c_16,theorem,
    [++p1,++p2,--p3,--p1,--p2]).

input_clause(c_17,theorem,
    [--p1,++p2,--p3,--p2,++p3]).

input_clause(c_18,theorem,
    [--p1,++p2,--p3]).

input_clause(c_19,theorem,
    [--p1,++p2,--p3,++p1,++p3]).

input_clause(c_20,theorem,
    [--p1,++p2,--p3,++p1,--p2]).

input_clause(c_21,theorem,
    [--p1,++p2,++p3,++p1,--p2]).

input_clause(c_22,theorem,
    [--p1,++p2,++p3,++p1,--p3]).

input_clause(c_23,theorem,
    [--p1,++p2,++p3]).

input_clause(c_24,theorem,
    [--p1,++p2,++p3,--p2,--p3]).

input_clause(c_25,theorem,
    [--p1,--p2,++p3]).

input_clause(c_26,theorem,
    [--p1,--p2,++p3,++p2,--p3]).

input_clause(c_27,theorem,
    [--p1,--p2,++p3,++p1,++p2]).

input_clause(c_28,theorem,
    [--p1,--p2,++p3,++p1,--p3]).

input_clause(c_29,theorem,
    [--p1,--p2,--p3,++p1,++p3]).

input_clause(c_30,theorem,
    [--p1,--p2,--p3,++p1,++p2]).

input_clause(c_31,theorem,
    [--p1,--p2,--p3,++p2,++p3]).

input_clause(c_32,theorem,
    [--p1,--p2,--p3]).
%--------------------------------------------------------------------------
