%--------------------------------------------------------------------------
% File     : SYN007=FPell71-1.001 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Syntactic
% Problem  : Pelletier Problem 71
% Version  : Theorem formulation : For N = 1.
% English  : Clausal forms of statements of the form :
%            (p1 <-> (p2 <->...(pN <-> (p1 <-> (p2 <->...<-> pN)...)

% Refs     : Pelletier F.J. (1986), Seventy-Five Problems for Testing 
%            Automatic Theorem Provers, Journal of Automated Reasoning 
%            2(2), 191-216.
%          : Urquhart A. (1987), Hard Examples for Resolution, Journal 
%            of the ACM 34(1), 209-219.
% Source   : [Pelletier, 1986]
% Names    : Pelletier 71 [Pelletier, 1986]

% Status   : 
% Syntax   : Number of clauses           :    2 (   0 non-Horn)(   2 unit)
%            Number of literals          :    2 (   0 equality)
%            Number of predicate symbols :    1 (   1 propositional)
%            Number of function symbols  :    0 (   0 constant)
%            Number of variables         :    0 (   0 singleton)
%            Maximal clause size         :    1
%            Maximal term depth          :    0

% Comments : The number of distinct letters in U-N is N. The number 
%            of occurrences of sentence letters in 2N. The number 
%            of clauses goes up dramatically as N increases, but I don't 
%            think it shows that the problems are dramatically more 
%            difficult as N increases. Rather, it's that the awkward 
%            clause form representation comes to the fore most 
%            dramatically with embedded biconditionals. On all other 
%            measures of complexity, one should say that the problems 
%            increase linearly in difficulty. Urquhart says that the proof 
%            size of any resolution system increases exponentially with 
%            increase in N.
%          : This problem can also be done in terms of graphs, 
%            as described in Pelletier Problem 74.
%--------------------------------------------------------------------------
input_clause(c_1,theorem,
    [++p1]).

input_clause(c_2,theorem,
    [--p1]).
%--------------------------------------------------------------------------
