%--------------------------------------------------------------------------
% File     : SYN005=Or1-1.008 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Syntactic
% Problem  : Disjunctions that form a contradiction
% Version  : Theorem formulation : Size 8.
% English  : ~p1(X1,X2) v ~p2(X2,X3) v ... v ~pN(XN,X1).
%             p1(a,a)      p2(a,a) ...        pN(a,a)

% Refs     : Plaisted D.A. (1982), A Simplified Problem Reduction Format, 
%            Artificial Intelligence 18(X), 227-261.
% Source   : [Plaisted, 1982]
% Names    : Problem 5.4 [Plaisted, 1982]

% Status   : 
% Syntax   : Number of clauses           :    9 (   0 non-Horn)(   8 unit)
%            Number of literals          :   16 (   0 equality)
%            Number of predicate symbols :    8 (   0 propositional)
%            Number of function symbols  :    1 (   1 constant)
%            Number of variables         :    9 (   2 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    1

% Comments : "On this example locking resolution (even with a bad choice 
%            of indices) and SL-resolution generate search spaces of size 
%            polynomial in n, but positive unit resolution, all-negative 
%            resolution, set-of-support strategy, ancestry-filter form, 
%            and input resolution all generate search spaces of size 
%            exponential in n." [Plaisted, 1982, p. 244]
%--------------------------------------------------------------------------
input_clause(disjunction,theorem,
    [--p1(X1,X2),
     --p2(X2,X3),
     --p3(X3,X4),
     --p4(X4,X5),
     --p5(X5,X6),
     --p6(X6,X7),
     --p7(X7,X8),
     --p8(X8,X9)]).

input_clause(p1,theorem,
    [++p1(a,a)]).

input_clause(p2,theorem,
    [++p2(a,a)]).

input_clause(p3,theorem,
    [++p3(a,a)]).

input_clause(p4,theorem,
    [++p4(a,a)]).

input_clause(p5,theorem,
    [++p5(a,a)]).

input_clause(p6,theorem,
    [++p6(a,a)]).

input_clause(p7,theorem,
    [++p7(a,a)]).

input_clause(p8,theorem,
    [++p8(a,a)]).
%--------------------------------------------------------------------------
