%--------------------------------------------------------------------------
% File     : SYN005=Or1-1.003 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Syntactic
% Problem  : Disjunctions that form a contradiction
% Version  : Theorem formulation : Size 3.
% English  : ~p1(X1,X2) v ~p2(X2,X3) v ... v ~pN(XN,X1)
%             p1(a,a)      p2(a,a) ...        pN(a,a)

% Refs     : Plaisted D.A. (1982), A Simplified Problem Reduction Format, 
%            Artificial Intelligence 18(X), 227-261.
% Source   : [Plaisted, 1982]
% Names    : Problem 5.4 [Plaisted, 1982]

% Status   : 
% Syntax   : Number of clauses           :    4 (   0 non-Horn)(   3 unit)
%            Number of literals          :    6 (   0 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    1 (   1 constant)
%            Number of variables         :    4 (   2 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    1

% Comments : "On this example locking resolution (even with a bad choice 
%            of indices) and SL-resolution generate search spaces of size 
%            polynomial in n, but positive unit resolution, all-negative 
%            resolution, set-of-support strategy, ancestry-filter form, 
%            and input resolution all generate search spaces of size 
%            exponential in n." [Plaisted, 1982, p. 244]
%--------------------------------------------------------------------------
input_clause(disjunction,theorem,
    [--p1(X1,X2),
     --p2(X2,X3),
     --p3(X3,X4)]).

input_clause(p1,theorem,
    [++p1(a,a)]).

input_clause(p2,theorem,
    [++p2(a,a)]).

input_clause(p3,theorem,
    [++p3(a,a)]).
%--------------------------------------------------------------------------
