%--------------------------------------------------------------------------
% File     : SYN005=Or1-1.002 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Syntactic
% Problem  : Disjunctions that form a contradiction
% Version  : Theorem formulation : Size 2.
% English  : ~p1(X1,X2) v ~p2(X2,X3) v ... v ~pN(XN,X1).
%             p1(a,a)      p2(a,a) ...        pN(a,a)

% Refs     : Plaisted D.A. (1982), A Simplified Problem Reduction Format, 
%            Artificial Intelligence 18(X), 227-261.
% Source   : [Plaisted, 1982]
% Names    : Problem 5.4 [Plaisted, 1982]

% Status   : 
% Syntax   : Number of clauses           :    3 (   0 non-Horn)(   2 unit)
%            Number of literals          :    4 (   0 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    1 (   1 constant)
%            Number of variables         :    2 (   0 singleton)
%            Maximal clause size         :    2
%            Maximal term depth          :    1

% Comments : "On this example locking resolution (even with a bad choice 
%            of indices) and SL-resolution generate search spaces of size 
%            polynomial in n, but positive unit resolution, all-negative 
%            resolution, set-of-support strategy, ancestry-filter form, 
%            and input resolution all generate search spaces of size 
%            exponential in n." [Plaisted, 1982, p. 244]
%--------------------------------------------------------------------------
input_clause(disjunction,theorem,
    [--p1(X1,X2),
     --p2(X2,X1)]).

input_clause(p1,theorem,
    [++p1(a,a)]).

input_clause(p2,theorem,
    [++p2(a,a)]).
%--------------------------------------------------------------------------
