%--------------------------------------------------------------------------
% File     : SYN004=Implies2-1.002 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Syntactic
% Problem  : Implications that form a contradiction
% Version  : Theorem formulation : Size 2.
% English  : P1 & Q1 -> P2     P1 & Q1 -> Q2     :
%            P2 & Q2 -> P3     P2 & Q2 -> Q3     :
%              ......           ......           :
%            Pk-1 & Qk-1 ->Pk  Pk-1 & Qk-1 -> Qk :
%            P1     Q1         ~Pk v ~Qk         :

% Refs     : Plaisted D.A. (1982), A Simplified Problem Reduction Format, 
%            Artificial Intelligence 18(X), 227-261.
% Source   : [Plaisted, 1982]
% Names    : Problem 5.3 [Plaisted, 1982]

% Status   : 
% Syntax   : Number of clauses           :    5 (   0 non-Horn)(   2 unit)
%            Number of literals          :   10 (   0 equality)
%            Number of predicate symbols :    4 (   4 propositional)
%            Number of function symbols  :    0 (   0 constant)
%            Number of variables         :    0 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    0

% Comments : "This set of clauses can cause the following strategies 
%            to generate minimal length proofs having length exponential 
%            in k: SL-resolution, locking resolution with a bad choice 
%            of indices. However, all of the following strategies can 
%            always generate proofs polynomial in the size 
%            of S if S is an inconsistent set of propositional Horn 
%            clauses: all-negative resolution, set-of-support strategy, 
%            ancestry-filter form, and input resolution." [Plaisted, 
%            1982, p. 244]
%--------------------------------------------------------------------------
input_clause(p1q1p2,theorem,
    [--p1,--q1,++p2]).

input_clause(p1q1q2,theorem,
    [--p1,--q1,++q2]).

input_clause(p1,theorem,
    [++p1]).

input_clause(q1,theorem,
    [++q1]).

input_clause(not_p2_or_q2,theorem,
    [--p2,--q2]).
%--------------------------------------------------------------------------
