%--------------------------------------------------------------------------
% File     : SYN003=Implies1-1.002 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Syntactic
% Problem  : Implications that form a contradiction
% Version  : Theorem formulation : Size 2.
% English  : P1 & Q1 -> P2     P1 & R1 -> P2     Q -> Q1     R -> R1   :
%            P2 & Q2 -> P3     P2 & R2 -> P3     Q -> Q2     R -> R2   :
%              ......           ......        ....      ....           :
%            Pk-1 & Qk-1 ->Pk  Pk-1 & Rk-1 -> Pk Q -> Qk-1   R -> Rk-1 :
%            P1                ~Pk               Q           R         :

% Refs     : Plaisted D.A. (1982), A Simplified Problem Reduction Format, 
%            Artificial Intelligence 18(X), 227-261.
% Source   : [Plaisted, 1982]
% Names    : Problem 5.2 [Plaisted, 1982]

% Status   : 
% Syntax   : Number of clauses           :    8 (   0 non-Horn)(   4 unit)
%            Number of literals          :   14 (   0 equality)
%            Number of predicate symbols :    6 (   6 propositional)
%            Number of function symbols  :    0 (   0 constant)
%            Number of variables         :    0 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    0

% Comments : "This set of clauses can cause the following strategies 
%            to generate a search space which is exponential 
%            in k: All-negative resolution, set-of-support with ~Pk as the 
%            support set, input resolution, SL-resolution, locking 
%            resolution with a bad choice of indices, and ancestor-filter 
%            form (linear resolution)." [Plaisted, 1982, p. 243]
%--------------------------------------------------------------------------
input_clause(p1q1p2,theorem,
    [--p1,--q1,++p2]).

input_clause(p1r1p2,theorem,
    [--p1,--r1,++p2]).

input_clause(qq1,theorem,
    [--q,++q1]).

input_clause(rr1,theorem,
    [--r,++r1]).

input_clause(p1,theorem,
    [++p1]).

input_clause(not_p2,theorem,
    [--p2]).

input_clause(q,theorem,
    [++q]).

input_clause(r,theorem,
    [++r]).
%--------------------------------------------------------------------------
