%--------------------------------------------------------------------------
% File     : SET450=FuncSubS2-6 : TPTP v1.1.1. Bugfixed v1.0.1.
% Domain   : Set Theory
% Problem  : Condition 2 for one function to be a subset of another
% Version  : [Quaife, 1992] axioms.
% English  : 

% Refs     : Quaife A. (1992), Automated Deduction in von 
%            Neumann-Bernays-Godel Set Theory, In Journal of Automated 
%            Reasoning 8(1), 91-147.
% Source   : [Quaife]
% Names    : FU16.2 [Quaife]

% Status   : 
% Syntax   : Number of clauses           :  193 (   8 non-Horn)(  42 unit)
%            Number of literals          :  394 ( 186 equality)
%            Number of predicate symbols :   11 (   0 propositional)
%            Number of function symbols  :   49 (  14 constant)
%            Number of variables         :  443 (  33 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    6

% Comments : Not in [Quaife, 1992], Theorem FU16 in Quaife's collection
%          : Quaife proves all these problems by augmenting the axioms 
%            with all previously proved theorems. With a few exceptions 
%            (the problems that correspond to [Bledsoe, et al., 1986] 
%            problems), the TPTP has retained the order in which Quaife 
%            presents the problems. The user may create an augmented 
%            version of this problem by adding all previously proved 
%            theorems (the ones that correspond to [Bledsoe, et al., 1986] 
%            are easily identified and positioned using Quaife's naming 
%            scheme).
% Bugfixes : v1.0.1 - Bugfix in SET004-1.ax.
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include von Neuman-Bernays-Godel set theory axioms 
include('Axioms/SET004-0.ax').
include('Axioms/SET004-0.eq').
%----Include von Neuman-Bernays-Godel Boolean Algebra definitions 
include('Axioms/SET004-1.ax').
include('Axioms/SET004-1.eq').
%--------------------------------------------------------------------------
input_clause(not_subfunction_substitution1,axiom,
    [--equal(A,B),
     ++equal(not_subfunction(A,C),not_subfunction(B,C))]).

input_clause(not_subfunction_substitution2,axiom,
    [--equal(D,E),
     ++equal(not_subfunction(F,D),not_subfunction(F,E))]).

input_clause(prove_function_subset_function2_1,theorem,
    [++function(x)]).

input_clause(prove_function_subset_function2_2,theorem,
    [++subclass(domain_of(x),domain_of(y))]).

input_clause(prove_function_subset_function2_3,theorem,
    [++equal(apply(x,not_subfunction(x,y)),apply(y,
not_subfunction(x,y)))]).

input_clause(prove_function_subset_function2_4,theorem,
    [--subclass(x,y)]).
%--------------------------------------------------------------------------
