%--------------------------------------------------------------------------
% File     : SET428=SVClAltDef4-6 : TPTP v1.1.1. Bugfixed v1.0.1.
% Domain   : Set Theory
% Problem  : Single valued class alternate definition 4
% Version  : [Quaife, 1992] axioms.
% English  : 

% Refs     : Quaife A. (1992), Automated Deduction in von 
%            Neumann-Bernays-Godel Set Theory, In Journal of Automated 
%            Reasoning 8(1), 91-147.
% Source   : [Quaife]
% Names    : SV3.3 [Quaife, 1992]

% Status   : 
% Syntax   : Number of clauses           :  189 (   8 non-Horn)(  40 unit)
%            Number of literals          :  388 ( 182 equality)
%            Number of predicate symbols :   11 (   0 propositional)
%            Number of function symbols  :   47 (  13 constant)
%            Number of variables         :  437 (  33 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    6

% Comments : Quaife proves all these problems by augmenting the axioms 
%            with all previously proved theorems. With a few exceptions 
%            (the problems that correspond to [Bledsoe, et al., 1986] 
%            problems), the TPTP has retained the order in which Quaife 
%            presents the problems. The user may create an augmented 
%            version of this problem by adding all previously proved 
%            theorems (the ones that correspond to [Bledsoe, et al., 1986] 
%            are easily identified and positioned using Quaife's naming 
%            scheme).
% Bugfixes : v1.0.1 - Bugfix in SET004-1.ax.
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include von Neuman-Bernays-Godel set theory axioms 
include('Axioms/SET004-0.ax').
include('Axioms/SET004-0.eq').
%----Include von Neuman-Bernays-Godel Boolean Algebra definitions 
include('Axioms/SET004-1.ax').
include('Axioms/SET004-1.eq').
%--------------------------------------------------------------------------
input_clause(prove_single_valued_class_alternate_defn4_1,theorem,
    [++equal(single_valued1(x),single_valued2(x))]).

input_clause(prove_single_valued_class_alternate_defn4_2,theorem,
    [--single_valued_class(x)]).
%--------------------------------------------------------------------------
