%--------------------------------------------------------------------------
% File     : SET140=SetB3Rdcn2-6 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Set Theory
% Problem  : Triple reduction 2
% Version  : [Quaife, 1992] axioms.
% English  : 

% Refs     : Quaife A. (1992), Automated Deduction in von 
%            Neumann-Bernays-Godel Set Theory, In Journal of Automated 
%            Reasoning 8(1), 91-147.
% Source   : [Quaife]
% Names    : SB6.2 [Quaife]

% Status   : 
% Syntax   : Number of clauses           :  163 (   8 non-Horn)(  32 unit)
%            Number of literals          :  338 ( 166 equality)
%            Number of predicate symbols :   10 (   0 propositional)
%            Number of function symbols  :   41 (  10 constant)
%            Number of variables         :  387 (  26 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    6

% Comments : The 'set builder' problems, of which this is one, do not 
%            appear in [Quaife, 1992]. In Quaife's development, these 
%            problems appear between the SINGLETON and the ORDERED PAIRS 
%            problems of [Quaife, 1992]. However, in order to correspond 
%            to the paper, these theorems have not been used in the 
%            augmented versions of the subsequent problems in [Quaife, 
%            1992].
%          : Not in [Quaife, 1992]. Theorem SB6 in Quaife's collection.
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include von Neuman-Bernays-Godel set theory axioms 
include('Axioms/SET004-0.ax').
include('Axioms/SET004-0.eq').
%--------------------------------------------------------------------------
%----(SBDEF1): definition of set builder.
input_clause(definition_of_set_builder,axiom,
    [++equal(union(singleton(X),Y),set_builder(X,Y))]).

input_clause(set_builder_substitution1,axiom,
    [--equal(A,B),
     ++equal(set_builder(A,C),set_builder(B,C))]).

input_clause(set_builder_substitution2,axiom,
    [--equal(D,E),
     ++equal(set_builder(F,D),set_builder(F,E))]).

input_clause(prove_triple_reduction2_1,theorem,
    [--equal(set_builder(x,set_builder(y,set_builder(x,null_class))),
unordered_pair(x,y))]).
%--------------------------------------------------------------------------
