%--------------------------------------------------------------------------
% File     : SET117=OrdPrSetCor1-6 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Set Theory
% Problem  : Corollary 1 to every ordered pair being a set
% Version  : [Quaife, 1992] axioms.
% English  : 

% Refs     : Quaife A. (1992), Automated Deduction in von 
%            Neumann-Bernays-Godel Set Theory, In Journal of Automated 
%            Reasoning 8(1), 91-147.
% Source   : [Quaife]
% Names    : OP9.1 [Quaife, 1992]

% Status   : 
% Syntax   : Number of clauses           :  161 (   8 non-Horn)(  32 unit)
%            Number of literals          :  334 ( 161 equality)
%            Number of predicate symbols :   10 (   0 propositional)
%            Number of function symbols  :   39 (   9 constant)
%            Number of variables         :  379 (  26 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    6

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include von Neuman-Bernays-Godel set theory axioms 
include('Axioms/SET004-0.ax').
include('Axioms/SET004-0.eq').
%--------------------------------------------------------------------------
input_clause(prove_corollary_1_to_ordered_pairs_are_sets_1,theorem,
    [++equal(ordered_pair(first(x),second(x)),x)]).

input_clause(prove_corollary_1_to_ordered_pairs_are_sets_2,theorem,
    [--member(x,universal_class)]).
%--------------------------------------------------------------------------
