%--------------------------------------------------------------------------
% File     : SET115=1stUnq2-6 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Set Theory
% Problem  : 1st is unique if x is not an ordered pair of sets, part 2
% Version  : [Quaife, 1992] axioms.
% English  : 

% Refs     : Quaife A. (1992), Automated Deduction in von 
%            Neumann-Bernays-Godel Set Theory, In Journal of Automated 
%            Reasoning 8(1), 91-147.
% Source   : [Quaife]
% Names    : OP8.2 [Quaife, 1992]

% Status   : 
% Syntax   : Number of clauses           :  163 (   8 non-Horn)(  32 unit)
%            Number of literals          :  338 ( 166 equality)
%            Number of predicate symbols :   10 (   0 propositional)
%            Number of function symbols  :   41 (   9 constant)
%            Number of variables         :  383 (  26 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    6

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include von Neuman-Bernays-Godel set theory axioms 
include('Axioms/SET004-0.ax').
include('Axioms/SET004-0.eq').
%--------------------------------------------------------------------------
input_clause(first1_substitution1,axiom,
    [--equal(A,B),
     ++equal(first1(A),first1(B))]).

input_clause(second1_substitution1,axiom,
    [--equal(C,D),
     ++equal(second1(C),second1(D))]).

input_clause(prove_unique_1st_and_2nd_in_pair_of_non_sets3_1,theorem,
    [--equal(ordered_pair(first1(x),second1(x)),x)]).

input_clause(prove_unique_1st_in_pair_of_non_sets,theorem,
    [--equal(first(x),x)]).
%--------------------------------------------------------------------------
