%--------------------------------------------------------------------------
% File     : SET112=2ndOrdPr2-7 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Set Theory
% Problem  : 2nd is the ordered pair, second condition
% Version  : [Quaife, 1992] axioms : Augmented.
% English  : 

% Refs     : Quaife A. (1992), Automated Deduction in von 
%            Neumann-Bernays-Godel Set Theory, In Journal of Automated 
%            Reasoning 8(1), 91-147.
% Source   : [Quaife]
% Names    : OP6.5 [Quaife, 1992]

% Status   : 
% Syntax   : Number of clauses           :  224 (  28 non-Horn)(  47 unit)
%            Number of literals          :  467 ( 221 equality)
%            Number of predicate symbols :   10 (   0 propositional)
%            Number of function symbols  :   41 (   9 constant)
%            Number of variables         :  500 (  54 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    6

% Comments : Preceding lemmas are added.
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include von Neuman-Bernays-Godel set theory axioms 
include('Axioms/SET004-0.ax').
include('Axioms/SET004-0.eq').
%--------------------------------------------------------------------------
%----Corollaries to Unordered pair axiom. Not in paper, but in email. 
input_clause(corollary_1_to_unordered_pair,axiom,
    [--member(ordered_pair(X,Y),cross_product(U,V)),
     ++member(X,unordered_pair(X,Y))]).

input_clause(corollary_2_to_unordered_pair,axiom,
    [--member(ordered_pair(X,Y),cross_product(U,V)),
     ++member(Y,unordered_pair(X,Y))]).

%----Corollaries to Cartesian product axiom.
input_clause(corollary_1_to_cartesian_product,axiom,
    [--member(ordered_pair(U,V),cross_product(X,Y)),
     ++member(U,universal_class)]).

input_clause(corollary_2_to_cartesian_product,axiom,
    [--member(ordered_pair(U,V),cross_product(X,Y)),
     ++member(V,universal_class)]).

%----                        PARTIAL ORDER.
%----(PO1): reflexive.
input_clause(subclass_is_reflexive,axiom,
    [++subclass(X,X)]).

%----(PO2): antisymmetry is part of A-3.
%----(x < y), (y < x) --> (x = y).

%----(PO3): transitivity.
input_clause(transitivity_of_subclass,axiom,
    [--subclass(X,Y),
     --subclass(Y,Z),
     ++subclass(X,Z)]).

%----                          EQUALITY.
%----(EQ1): equality axiom.
%----a:x:(x = x).
%----This is always an axiom in the TPTP presentation.

%----substitutivity.
%----Not in the paper, and always an axiom in the TPTP presentation 

%----(EQ2): expanded equality definition.
input_clause(equality1,axiom,
    [++equal(X,Y),
     ++member(not_subclass_element(X,Y),X),
     ++member(not_subclass_element(Y,X),Y)]).

input_clause(equality2,axiom,
    [--member(not_subclass_element(X,Y),Y),
     ++equal(X,Y),
     ++member(not_subclass_element(Y,X),Y)]).

input_clause(equality3,axiom,
    [--member(not_subclass_element(Y,X),X),
     ++equal(X,Y),
     ++member(not_subclass_element(X,Y),X)]).

input_clause(equality4,axiom,
    [--member(not_subclass_element(X,Y),Y),
     --member(not_subclass_element(Y,X),X),
     ++equal(X,Y)]).

%----                        SPECIAL CLASSES.
%----(SP1): lemma.
input_clause(special_classes_lemma,axiom,
    [--member(Y,intersection(complement(X),X))]).

%----(SP2):  Existence of O (null class).
%----e:x:a:z:(-(z e x)).
input_clause(existence_of_null_class,axiom,
    [--member(Z,null_class)]).

%----(SP3): O is a subclass of every class.
input_clause(null_class_is_subclass,axiom,
    [++subclass(null_class,X)]).

%----corollary.
input_clause(corollary_of_null_class_is_subclass,axiom,
    [--subclass(X,null_class),
     ++equal(X,null_class)]).

%----(SP4): uniqueness of null class.
input_clause(null_class_is_unique,axiom,
    [++equal(Z,null_class),
     ++member(not_subclass_element(Z,null_class),Z)]).

%----(SP5): O is a set (follows from axiom of infinity).
input_clause(null_class_is_a_set,axiom,
    [++member(null_class,universal_class)]).

%----                      UNORDERED PAIRS.
%----(UP1): unordered pair is commutative.
input_clause(commutativity_of_unordered_pair,axiom,
    [++equal(unordered_pair(X,Y),unordered_pair(Y,X))]).

%----(UP2): if one argument is a proper class, pair contains only the 
%----other. In a slightly different form to the paper 
input_clause(singleton_in_unordered_pair1,axiom,
    [++subclass(singleton(X),unordered_pair(X,Y))]).

input_clause(singleton_in_unordered_pair2,axiom,
    [++subclass(singleton(Y),unordered_pair(X,Y))]).

input_clause(unordered_pair_equals_singleton1,axiom,
    [++member(Y,universal_class),
     ++equal(unordered_pair(X,Y),singleton(X))]).

input_clause(unordered_pair_equals_singleton2,axiom,
    [++member(X,universal_class),
     ++equal(unordered_pair(X,Y),singleton(Y))]).

%----(UP3): if both arguments are proper classes, pair is null. 
input_clause(null_unordered_pair,axiom,
    [++equal(unordered_pair(X,Y),null_class),
     ++member(X,universal_class),
     ++member(Y,universal_class)]).

%----(UP4): left cancellation for unordered pairs.
input_clause(left_cancellation,axiom,
    [--equal(unordered_pair(X,Y),unordered_pair(X,Z)),
     --member(ordered_pair(Y,Z),cross_product(universal_class,universal_class)),
     ++equal(Y,Z)]).

%----(UP5): right cancellation for unordered pairs.
input_clause(right_cancellation,axiom,
    [--equal(unordered_pair(X,Z),unordered_pair(Y,Z)),
     --member(ordered_pair(X,Y),cross_product(universal_class,universal_class)),
     ++equal(X,Y)]).

%----(UP6): corollary to (A-4).
input_clause(corollary_to_unordered_pair_axiom1,axiom,
    [--member(X,universal_class),
     --equal(unordered_pair(X,Y),null_class)]).

input_clause(corollary_to_unordered_pair_axiom2,axiom,
    [--member(Y,universal_class),
     --equal(unordered_pair(X,Y),null_class)]).

%----corollary to instantiate variables.
%----Not in the paper 
input_clause(corollary_to_unordered_pair_axiom3,axiom,
    [--member(ordered_pair(X,Y),cross_product(U,V)),
     --equal(unordered_pair(X,Y),null_class)]).

%----(UP7): if both members of a pair belong to a set, the pair 
%----is a subset. 
input_clause(unordered_pair_is_subset,axiom,
    [--member(X,Z),
     --member(Y,Z),
     ++subclass(unordered_pair(X,Y),Z)]).

%----                       SINGLETONS.
%----(SS1):  every singleton is a set.
input_clause(singletons_are_sets,axiom,
    [++member(singleton(X),universal_class)]).

%----corollary, not in the paper.
input_clause(corollary_1_to_singletons_are_sets,axiom,
    [++member(singleton(Y),unordered_pair(X,singleton(Y)))]).

%----(SS2): a set belongs to its singleton.
%----(u = x), (u e universal_class) --> (u e {x}).
input_clause(set_in_its_singleton,axiom,
    [--member(X,universal_class),
     ++member(X,singleton(X))]).

%----corollary 
input_clause(corollary_to_set_in_its_singleton,axiom,
    [--member(X,universal_class),
     --equal(singleton(X),null_class)]).

%----Not in the paper 
input_clause(null_class_in_its_singleton,axiom,
    [++member(null_class,singleton(null_class))]).

%----(SS3): only x can belong to {x}.
input_clause(only_member_in_singleton,axiom,
    [--member(Y,singleton(X)),
     ++equal(Y,X)]).

%----(SS4): if x is not a set, {x} = O.
input_clause(singleton_is_null_class,axiom,
    [++member(X,universal_class),
     ++equal(singleton(X),null_class)]).

%----(SS5): a singleton set is determined by its element. 
input_clause(singleton_identified_by_element1,axiom,
    [--equal(singleton(X),singleton(Y)),
     --member(X,universal_class),
     ++equal(X,Y)]).

input_clause(singleton_identified_by_element2,axiom,
    [--equal(singleton(X),singleton(Y)),
     --member(Y,universal_class),
     ++equal(X,Y)]).

%----(SS5.5).
%----Not in the paper 
input_clause(singleton_in_unordered_pair3,axiom,
    [--equal(unordered_pair(Y,Z),singleton(X)),
     --member(X,universal_class),
     ++equal(X,Y),
     ++equal(X,Z)]).

%----(SS6): existence of memb.
%----a:x:e:u:(((u e universal_class) & x = {u}) | (-e:y:((y 
%----e universal_class) & x = {y}) & u = x)). 
input_clause(member_of_substitution1,axiom,
    [--equal(A,B),
     ++equal(member_of(A),member_of(B))]).

input_clause(member_exists1,axiom,
    [--member(Y,universal_class),
     ++member(member_of(singleton(Y)),universal_class)]).

input_clause(member_exists2,axiom,
    [--member(Y,universal_class),
     ++equal(singleton(member_of(singleton(Y))),singleton(Y))]).

input_clause(member_exists3,axiom,
    [++member(member_of(X),universal_class),
     ++equal(member_of(X),X)]).

input_clause(member_exists4,axiom,
    [++equal(singleton(member_of(X)),X),
     ++equal(member_of(X),X)]).

%----(SS7): uniqueness of memb of a singleton set.
%----a:x:a:u:(((u e universal_class) & x = {u}) ==> member_of(x) = u) 
input_clause(member_of_singleton_is_unique,axiom,
    [--member(U,universal_class),
     ++equal(member_of(singleton(U)),U)]).

%----(SS8): uniqueness of memb when x is not a singleton of a set. 
%----a:x:a:u:((e:y:((y e universal_class) & x = {y}) 
%----& u = x) | member_of(x) = u) 
input_clause(member_of1_substitution1,axiom,
    [--equal(A,B),
     ++equal(member_of1(A),member_of1(B))]).

input_clause(member_of_non_singleton_unique1,axiom,
    [++member(member_of1(X),universal_class),
     ++equal(member_of(X),X)]).

input_clause(member_of_non_singleton_unique2,axiom,
    [++equal(singleton(member_of1(X)),X),
     ++equal(member_of(X),X)]).

%----(SS9): corollary to (SS1).
input_clause(corollary_2_to_singletons_are_sets,axiom,
    [--equal(singleton(member_of(X)),X),
     ++member(X,universal_class)]).

%----(SS10).
input_clause(property_of_singletons1,axiom,
    [--equal(singleton(member_of(X)),X),
     --member(Y,X),
     ++equal(member_of(X),Y)]).

%----(SS11).
input_clause(property_of_singletons2,axiom,
    [--member(X,Y),
     ++subclass(singleton(X),Y)]).

%----(SS12): there are at most two subsets of a singleton. 
input_clause(two_subsets_of_singleton,axiom,
    [--subclass(X,singleton(Y)),
     ++equal(X,null_class),
     ++equal(singleton(Y),X)]).

%----(SS13): a class contains 0, 1, or at least 2 members. 
input_clause(number_of_elements_in_class,axiom,
    [++member(not_subclass_element(intersection(complement(singleton(
not_subclass_element(X,null_class))),X),null_class),intersection(
complement(singleton(not_subclass_element(X,null_class))),X)),
     ++equal(singleton(not_subclass_element(X,null_class)),X),
     ++equal(X,null_class)]).

%----corollaries.
input_clause(corollary_2_to_number_of_elements_in_class,axiom,
    [++member(not_subclass_element(intersection(complement(singleton(not_subclass_element(X,null_class))),X),null_class),X),
     ++equal(singleton(not_subclass_element(X,null_class)),X),
     ++equal(X,null_class)]).

input_clause(corollary_1_to_number_of_elements_in_class,axiom,
    [--equal(not_subclass_element(intersection(complement(singleton(not_subclass_element(X,null_class))),X),null_class),not_subclass_element(X,null_class)),
     ++equal(singleton(not_subclass_element(X,null_class)),X),
     ++equal(X,null_class)]).

%----(SS14): relation to ordered pair.
%----It looks like we could simplify Godel's axioms by taking singleton 
%----as a primitive and using the next as a definition. Not in the paper 
input_clause(unordered_pairs_and_singletons,axiom,
    [++equal(unordered_pair(X,Y),union(singleton(X),singleton(Y)))]).

%----                       ORDERED PAIRS.
%----(OP1): an ordered pair is a set.
input_clause(ordered_pair_is_set,axiom,
    [++member(ordered_pair(X,Y),universal_class)]).

%----(OP2): members of ordered pair.
input_clause(singleton_member_of_ordered_pair,axiom,
    [++member(singleton(X),ordered_pair(X,Y))]).

input_clause(unordered_pair_member_of_ordered_pair,axiom,
    [++member(unordered_pair(X,singleton(Y)),ordered_pair(X,Y))]).

%----(OP3): special cases.
input_clause(property_1_of_ordered_pair,axiom,
    [++equal(unordered_pair(singleton(X),unordered_pair(X,null_class)),
ordered_pair(X,Y)),
     ++member(Y,universal_class)]).

input_clause(property_2_of_ordered_pair,axiom,
    [--member(Y,universal_class),
     ++equal(unordered_pair(null_class,singleton(singleton(Y))),
ordered_pair(X,Y)),
     ++member(X,universal_class)]).

input_clause(property_3_of_ordered_pair,axiom,
    [++equal(unordered_pair(null_class,singleton(null_class)),
ordered_pair(X,Y)),
     ++member(X,universal_class),
     ++member(Y,universal_class)]).

%----(OP4)-(OP5): an ordered pair uniquely determines its components. 
%----(OP4). This OP10 from the paper. OP4 is now omitted 
input_clause(ordered_pair_determines_components1,axiom,
    [--equal(ordered_pair(W,X),ordered_pair(Y,Z)),
     --member(W,universal_class),
     ++equal(W,Y)]).

%----(OP5). This OP11 from the paper. OP5 is now omitted 
input_clause(ordered_pair_determines_components2,axiom,
    [--equal(ordered_pair(W,X),ordered_pair(Y,Z)),
     --member(X,universal_class),
     ++equal(X,Z)]).

input_clause(prove_existence_of_1st_and_2nd_5_1,theorem,
    [--equal(ordered_pair(first(x),second(x)),x)]).

input_clause(prove_existence_of_1st_and_2nd_5_2,theorem,
    [--equal(second(x),x)]).
%--------------------------------------------------------------------------
