%--------------------------------------------------------------------------
% File     : SET112=2ndOrdPr2-6 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Set Theory
% Problem  : 2nd is the ordered pair, second condition
% Version  : [Quaife, 1992] axioms.
% English  : 

% Refs     : Quaife A. (1992), Automated Deduction in von 
%            Neumann-Bernays-Godel Set Theory, In Journal of Automated 
%            Reasoning 8(1), 91-147.
% Source   : [Quaife]
% Names    : OP6.5 [Quaife, 1992]

% Status   : 
% Syntax   : Number of clauses           :  161 (   8 non-Horn)(  32 unit)
%            Number of literals          :  334 ( 162 equality)
%            Number of predicate symbols :   10 (   0 propositional)
%            Number of function symbols  :   39 (   9 constant)
%            Number of variables         :  379 (  26 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    6

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include von Neuman-Bernays-Godel set theory axioms 
include('Axioms/SET004-0.ax').
include('Axioms/SET004-0.eq').
%--------------------------------------------------------------------------
input_clause(prove_existence_of_1st_and_2nd_5_1,theorem,
    [--equal(ordered_pair(first(x),second(x)),x)]).

input_clause(prove_existence_of_1st_and_2nd_5_2,theorem,
    [--equal(second(x),x)]).
%--------------------------------------------------------------------------
