%--------------------------------------------------------------------------
% File     : SET105=OrdPrEl3-6 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Set Theory
% Problem  : Special member 3 of an ordered pair
% Version  : [Quaife, 1992] axioms.
% English  : 

% Refs     : Quaife A. (1992), Automated Deduction in von 
%            Neumann-Bernays-Godel Set Theory, In Journal of Automated 
%            Reasoning 8(1), 91-147.
% Source   : [Quaife]
% Names    : OP3.3 [Quaife, 1992]

% Status   : 
% Syntax   : Number of clauses           :  162 (   8 non-Horn)(  33 unit)
%            Number of literals          :  335 ( 161 equality)
%            Number of predicate symbols :   10 (   0 propositional)
%            Number of function symbols  :   40 (  10 constant)
%            Number of variables         :  379 (  26 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    6

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include von Neuman-Bernays-Godel set theory axioms 
include('Axioms/SET004-0.ax').
include('Axioms/SET004-0.eq').
%--------------------------------------------------------------------------
input_clause(prove_property_3_of_ordered_pair_1,theorem,
    [--equal(unordered_pair(null_class,singleton(null_class)),
ordered_pair(x,y))]).

input_clause(prove_property_3_of_ordered_pair_2,theorem,
    [--member(x,universal_class)]).

input_clause(prove_property_3_of_ordered_pair_3,theorem,
    [--member(y,universal_class)]).
%--------------------------------------------------------------------------
