%--------------------------------------------------------------------------
% File     : SET092=MembUnq2-6 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Set Theory
% Problem  : Member_of(X) is unique if X is not a singleton, part 2
% Version  : [Quaife, 1992] axioms.
% English  : 

% Refs     : Quaife A. (1992), Automated Deduction in von 
%            Neumann-Bernays-Godel Set Theory, In Journal of Automated 
%            Reasoning 8(1), 91-147.
% Source   : [Quaife]
% Names    : SS8.2 [Quaife, 1992]

% Status   : 
% Syntax   : Number of clauses           :  163 (   8 non-Horn)(  32 unit)
%            Number of literals          :  338 ( 166 equality)
%            Number of predicate symbols :   10 (   0 propositional)
%            Number of function symbols  :   41 (   9 constant)
%            Number of variables         :  383 (  26 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    6

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include von Neuman-Bernays-Godel set theory axioms 
include('Axioms/SET004-0.ax').
include('Axioms/SET004-0.eq').
%--------------------------------------------------------------------------
input_clause(member_of_substitution1,axiom,
    [--equal(A,B),
     ++equal(member_of(A),member_of(B))]).

input_clause(member_of1_substitution1,axiom,
    [--equal(C,D),
     ++equal(member_of1(C),member_of1(D))]).

input_clause(prove_member_of_non_singleton_unique2_1,theorem,
    [--equal(singleton(member_of1(x)),x)]).

input_clause(prove_member_of_non_singleton_unique2_2,theorem,
    [--equal(member_of(x),x)]).
%--------------------------------------------------------------------------
