%--------------------------------------------------------------------------
% File     : SET088=SgtnEl3-6 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Set Theory
% Problem  : A singleton set has a member, part 3
% Version  : [Quaife, 1992] axioms.
% English  : 

% Refs     : Quaife A. (1992), Automated Deduction in von 
%            Neumann-Bernays-Godel Set Theory, In Journal of Automated 
%            Reasoning 8(1), 91-147.
% Source   : [Quaife]
% Names    : SS6.3 [Quaife, 1992]

% Status   : 
% Syntax   : Number of clauses           :  162 (   8 non-Horn)(  32 unit)
%            Number of literals          :  336 ( 163 equality)
%            Number of predicate symbols :   10 (   0 propositional)
%            Number of function symbols  :   40 (   9 constant)
%            Number of variables         :  381 (  26 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    6

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include von Neuman-Bernays-Godel set theory axioms 
include('Axioms/SET004-0.ax').
include('Axioms/SET004-0.eq').
%--------------------------------------------------------------------------
input_clause(member_of_substitution1,axiom,
    [--equal(A,B),
     ++equal(member_of(A),member_of(B))]).

input_clause(prove_member_exists3_1,theorem,
    [--member(member_of(x),universal_class)]).

input_clause(prove_member_exists3_2,theorem,
    [--equal(member_of(x),x)]).
%--------------------------------------------------------------------------
