%--------------------------------------------------------------------------
% File     : SET085=UOrdPrSgtn-6 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Set Theory
% Problem  : Unordered pair that is a singleton
% Version  : [Quaife, 1992] axioms.
% English  : 

% Refs     : Quaife A. (1992), Automated Deduction in von 
%            Neumann-Bernays-Godel Set Theory, In Journal of Automated 
%            Reasoning 8(1), 91-147.
% Source   : [Quaife]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :  163 (   8 non-Horn)(  34 unit)
%            Number of literals          :  336 ( 163 equality)
%            Number of predicate symbols :   10 (   0 propositional)
%            Number of function symbols  :   41 (  11 constant)
%            Number of variables         :  379 (  26 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    6

% Comments : Not in [Quaife, 1992]. Theorem SS5.5, in Quaife's collection.
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include von Neuman-Bernays-Godel set theory axioms 
include('Axioms/SET004-0.ax').
include('Axioms/SET004-0.eq').
%--------------------------------------------------------------------------
input_clause(prove_singleton_in_unordered_pair3_1,theorem,
    [++equal(unordered_pair(y,z),singleton(x))]).

input_clause(prove_singleton_in_unordered_pair3_2,theorem,
    [++member(x,universal_class)]).

input_clause(prove_singleton_in_unordered_pair3_3,theorem,
    [--equal(x,y)]).

input_clause(prove_singleton_in_unordered_pair3_4,theorem,
    [--equal(x,z)]).
%--------------------------------------------------------------------------
