%--------------------------------------------------------------------------
% File     : SET076=UOrdPrSubS-6 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Set Theory
% Problem  : Unorderd pair is a subset
% Version  : [Quaife, 1992] axioms.
% English  : If both members of an unordered pair belong to a set, the 
%            pair is a subset.

% Refs     : Quaife A. (1992), Automated Deduction in von 
%            Neumann-Bernays-Godel Set Theory, In Journal of Automated 
%            Reasoning 8(1), 91-147.
% Source   : [Quaife]
% Names    : UP7 [Quaife, 1992]

% Status   : 
% Syntax   : Number of clauses           :  162 (   8 non-Horn)(  33 unit)
%            Number of literals          :  335 ( 160 equality)
%            Number of predicate symbols :   10 (   0 propositional)
%            Number of function symbols  :   41 (  11 constant)
%            Number of variables         :  379 (  26 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    6

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include von Neuman-Bernays-Godel set theory axioms 
include('Axioms/SET004-0.ax').
include('Axioms/SET004-0.eq').
%--------------------------------------------------------------------------
input_clause(prove_unordered_pair_is_subset_1,theorem,
    [++member(x,z)]).

input_clause(prove_unordered_pair_is_subset_2,theorem,
    [++member(y,z)]).

input_clause(prove_unordered_pair_is_subset_3,theorem,
    [--subclass(unordered_pair(x,y),z)]).
%--------------------------------------------------------------------------
